/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.RB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@SASScope(value="ALL")
public class ConditionalRelationType
implements Serializable {
    static final long serialVersionUID = -3895230168167804951L;
    private final String name;
    private final String key;
    private static List types = new ArrayList(2);
    public static final ConditionalRelationType AND = new ConditionalRelationType("AND", "Util.Boolean.AND.Label.txt");
    public static final ConditionalRelationType OR = new ConditionalRelationType("OR", "Util.Boolean.OR.Label.txt");

    private ConditionalRelationType(String name, String key) {
        this.name = name;
        this.key = key;
        types.add(this);
    }

    public String toString() {
        return this.name;
    }

    public String getLabel() {
        return RB.getStringResource(this.key);
    }

    public String getLabel(Locale locale) {
        return RB.getStringResource(this.key, locale);
    }

    public static ConditionalRelationType findType(String name) {
        ConditionalRelationType type = null;
        if (name != null) {
            for (ConditionalRelationType t : types) {
                if (!name.equals(t.toString())) continue;
                type = t;
                break;
            }
        }
        return type;
    }

    public static List getAvailableTypes() {
        return Collections.unmodifiableList(types);
    }
}

