/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.beans.PropertyChangeEvent;
import com.sas.beans.PropertyChangeSupport;
import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.Util;
import java.beans.PropertyChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public abstract class AbstractFilterLogicBaseNode
extends DefaultMutableTreeNode
implements FilterLogicBaseNodeInterface {
    protected String label;
    protected String description;
    protected PropertyChangeSupport propertyChangeSupport;

    public AbstractFilterLogicBaseNode() {
        this((Object)null);
    }

    public AbstractFilterLogicBaseNode(Object userObject) {
        super(userObject);
        this.label = null;
        this.description = null;
    }

    public AbstractFilterLogicBaseNode(FilterLogicBaseNodeInterface other) {
        super(other.getUserObject());
        this.label = other.getFilterLabel();
        this.description = other.getFilterDescription();
    }

    @Override
    public Object clone() {
        AbstractFilterLogicBaseNode newNode = (AbstractFilterLogicBaseNode)super.clone();
        newNode.userObject = this.userObject;
        newNode.label = this.label;
        newNode.description = this.description;
        return newNode;
    }

    @Override
    public String getFilterLabel() {
        return this.label;
    }

    @Override
    public String getFilterDescription() {
        return this.description;
    }

    @Override
    public int getMaxChildren() {
        return -1;
    }

    @Override
    public FilterLogicBaseNodeInterface getChildLogicNodeAt(int childIndex) {
        TreeNode node = this.getChildAt(childIndex);
        if (node instanceof FilterLogicBaseNodeInterface) {
            return (FilterLogicBaseNodeInterface)node;
        }
        return null;
    }

    @Override
    public FilterLogicBaseNodeInterface getParentLogicNode() {
        TreeNode node = this.getParent();
        if (node instanceof FilterLogicBaseNodeInterface) {
            return (FilterLogicBaseNodeInterface)node;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.userObject = null;
    }

    public void setFilterDescription(String string) {
        if (string != this.description) {
            String oldValue = this.description;
            this.description = string;
            this.firePropertyChange("description", oldValue, this.description);
        }
    }

    public void setFilterLabel(String string) {
        if (string != this.label) {
            String oldValue = this.label;
            this.label = string;
            this.firePropertyChange("label", oldValue, this.label);
        }
    }

    @Override
    public void setUserObject(Object userObject) {
        if (userObject != this.userObject) {
            Object oldValue = this.userObject;
            super.setUserObject(userObject);
            this.firePropertyChange("userObject", oldValue, this.userObject);
        }
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return Util.indexOfInstance(this.children, aChild);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.processPropertyChange((java.beans.PropertyChangeEvent)evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }
}

