/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.export;

import com.sas.codepolicy.SASScope;
import com.sas.commands.export.OLAPExportCommandInterface;
import com.sas.commands.export.RelationalExportCommandV2Interface;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class ExportSelectorCommandFactory {
    private Map<String, String> relationalExportCommandClassNames = new HashMap<String, String>();
    private Map<String, String> olapExportCommandClassNames;

    public ExportSelectorCommandFactory() {
        this.relationalExportCommandClassNames.put("TSV", "com.sas.servlet.commands.jdbc.export.ExportToTabSeparatedCommand");
        this.relationalExportCommandClassNames.put("CSV", "com.sas.servlet.commands.jdbc.export.ExportToCSVCommand");
        this.relationalExportCommandClassNames.put("XML", "com.sas.servlet.commands.jdbc.export.ExportToExcelXMLCommand");
        this.relationalExportCommandClassNames.put("HTML", "com.sas.servlet.commands.jdbc.export.ExportToHTMLCommand");
        this.relationalExportCommandClassNames.put("WHTML", "com.sas.servlet.commands.jdbc.export.ExportToHTMLCommand");
        this.relationalExportCommandClassNames.put("XLSX", "com.sas.export.office.commands.ExportToXLSXCommand");
        this.olapExportCommandClassNames = new HashMap<String, String>();
        this.olapExportCommandClassNames.put("TSV", "com.sas.servlet.commands.olap.export.OLAPExportToTabSeparatedCommand");
        this.olapExportCommandClassNames.put("CSV", "com.sas.servlet.commands.olap.export.OLAPExportToCSVCommand");
        this.olapExportCommandClassNames.put("XML", "com.sas.servlet.commands.olap.export.OLAPExportToExcelXMLCommand");
        this.olapExportCommandClassNames.put("HTML", "com.sas.servlet.commands.olap.export.OLAPExportToHTMLCommand");
        this.olapExportCommandClassNames.put("WHTML", "com.sas.servlet.commands.olap.export.OLAPExportToHTMLCommand");
        this.olapExportCommandClassNames.put("XLSX", "com.sas.export.office.commands.OLAPExportToXLSXCommand");
    }

    public RelationalExportCommandV2Interface getRelationalCommand(String outputType, ClassLoader loader) {
        RelationalExportCommandV2Interface command = null;
        if (outputType != null && loader != null && this.relationalExportCommandClassNames.containsKey(outputType)) {
            Class<?> c = null;
            try {
                c = Class.forName(this.relationalExportCommandClassNames.get(outputType), true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                command = (RelationalExportCommandV2Interface)c.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return command;
    }

    public OLAPExportCommandInterface getOLAPCommand(String outputType, ClassLoader loader) {
        OLAPExportCommandInterface command = null;
        if (outputType != null && loader != null && this.olapExportCommandClassNames.containsKey(outputType)) {
            Class<?> c = null;
            try {
                c = Class.forName(this.olapExportCommandClassNames.get(outputType), true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                command = (OLAPExportCommandInterface)c.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return command;
    }
}

