/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.relational;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.BaseCommand;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.util.SortDirectionInterface;
import java.util.ArrayList;
import javax.swing.table.TableModel;

public class SortCommand
extends BaseCommand
implements CommandSupportedInterface,
SortDirectionInterface,
CommandStatusInterface {
    public static final String RB_KEY = "SortCommand.";
    private SortableInterface model;
    private int column;
    private int direction;
    private String actionClass;
    private int maxSortableColumns;
    private boolean multipleColumnSorting;
    private boolean disabledIfCurrentState;

    public SortCommand() {
        this(null);
    }

    public SortCommand(int direction) {
        this(null, direction);
    }

    public SortCommand(String name) {
        this(name, 0);
    }

    public SortCommand(String name, int direction) {
        this(name, direction, -1);
    }

    public SortCommand(String name, int direction, int maxSortableColumns) {
        this(name, direction, maxSortableColumns, true);
    }

    public SortCommand(String name, int direction, boolean multipleColumnSorting) {
        this(name, direction, -1, multipleColumnSorting);
    }

    public SortCommand(String name, int direction, int maxSortableColumns, boolean multipleColumnSorting) {
        this(name, null, direction, maxSortableColumns, multipleColumnSorting);
    }

    public SortCommand(String name, String actionClass) {
        this(name, actionClass, 0, -1, true);
    }

    public SortCommand(String name, String actionClass, int direction, int maxSortableColumns, boolean multipleColumnSorting) {
        super(name);
        this.actionClass = actionClass;
        this.direction = direction;
        this.maxSortableColumns = maxSortableColumns;
        this.multipleColumnSorting = multipleColumnSorting;
    }

    public void setModel(SortableInterface model) {
        this.model = model;
    }

    public SortableInterface getModel() {
        return this.model;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setMaxSortableColumns(int maxSortableColumns) {
        this.maxSortableColumns = maxSortableColumns;
    }

    public int getMaxSortableColumns() {
        return this.maxSortableColumns;
    }

    public void setMultipleColumnSortingEnabled(boolean mulitpleColumnSorting) {
        this.multipleColumnSorting = mulitpleColumnSorting;
    }

    public boolean isMultipleColumnSortingEnabled() {
        return this.multipleColumnSorting;
    }

    public void setDisabledIfCurrentState(boolean disabledIfCurrentState) {
        this.disabledIfCurrentState = disabledIfCurrentState;
    }

    public boolean isDisabledIfCurrentState() {
        return this.disabledIfCurrentState;
    }

    @Override
    public void execute(Object o) {
        SortableInterface model = this.getModel();
        if (model != null) {
            String columnName = TableViewUtil.getColumnName((TableModel)model, this.getColumn());
            try {
                if (this.isMultipleColumnSortingEnabled()) {
                    String[] columns = model.getSortedColumns();
                    int[] directions = model.getSortedDirections();
                    ArrayList<String> newColumns = new ArrayList<String>();
                    ArrayList<Integer> newDirections = new ArrayList<Integer>();
                    newColumns.add(columnName);
                    newDirections.add(new Integer(this.direction));
                    for (int i = 0; i < columns.length; ++i) {
                        if (columns[i] == null || columns[i].equals(columnName) || this.getMaxSortableColumns() != -1 && this.getMaxSortableColumns() <= i) continue;
                        newColumns.add(columns[i]);
                        newDirections.add(new Integer(directions[i]));
                    }
                    int size = newDirections.size();
                    int[] ndirections = new int[size];
                    for (int i = 0; i < size; ++i) {
                        ndirections[i] = (Integer)newDirections.get(i);
                    }
                    model.sort(newColumns.toArray(new String[0]), ndirections);
                } else if (this.getMaxSortableColumns() != 0) {
                    model.sort(new String[]{columnName}, new int[]{this.direction});
                }
            }
            catch (SortException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object model = actionFilter.getAttribute("model");
        Integer column = (Integer)actionFilter.getAttribute("modelColumn");
        if (column == null || column == Integer.MAX_VALUE) {
            return false;
        }
        return model != null && model instanceof SortableInterface && column != null && ((SortableInterface)model).isSortAllowed();
    }

    protected boolean isColumnSortable(int column, SortableInterface model) {
        if (column > -1) {
            String name = TableViewUtil.getColumnName((TableModel)model, column);
            if (this.getMaxSortableColumns() != 0 && model.isSortAllowed() && model.isColumnSortable(name)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isColumnSorted(int column, int direction, SortableInterface model) {
        if (column > -1) {
            String name = TableViewUtil.getColumnName((TableModel)model, column);
            String[] sortedCols = model.getSortedColumns();
            int[] sortedDirs = model.getSortedDirections();
            if (name != null && sortedCols != null && sortedDirs != null && sortedCols.length == sortedDirs.length) {
                for (int i = 0; i < sortedCols.length; ++i) {
                    if (!name.equals(sortedCols[i])) continue;
                    return sortedDirs[i] == direction;
                }
            }
        }
        return false;
    }

    protected boolean isColumnSorted(int column, SortableInterface model) {
        if (column > -1) {
            String name = TableViewUtil.getColumnName((TableModel)model, column);
            String[] sortedCols = model.getSortedColumns();
            if (name != null && sortedCols != null) {
                for (int i = 0; i < sortedCols.length; ++i) {
                    if (!name.equals(sortedCols[i])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        Object model = filter.getAttribute("model");
        Integer column = (Integer)filter.getAttribute("modelColumn");
        if (column == null || column == Integer.MAX_VALUE) {
            return 16;
        }
        if (model != null && model instanceof SortableInterface && column != null) {
            if (this.isColumnSortable(column, (SortableInterface)model)) {
                if (this.isDisabledIfCurrentState()) {
                    if (this.isColumnSorted(column, this.direction, (SortableInterface)model)) {
                        return 8;
                    }
                    if (!this.isColumnSorted(column, (SortableInterface)model) && this.direction != 0) {
                        return 16;
                    }
                }
                return 0;
            }
            return 4;
        }
        return 2;
    }
}

