/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.relational;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.BaseCommand;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.table.MoveColumnInterface;
import javax.swing.SwingConstants;

public class MoveColumnCommand
extends BaseCommand
implements CommandStatusInterface,
SwingConstants {
    public static final String RB_KEY = "MoveColumnCommand.";
    protected MoveColumnInterface moveColumnInterface;
    protected int moveColumn;
    private String actionClass;
    private int orientation;
    private int distance;

    public MoveColumnCommand() {
        this(null);
    }

    public MoveColumnCommand(String name) {
        this(name, null);
    }

    public MoveColumnCommand(String name, String actionClass) {
        this(name, actionClass, 10);
    }

    public MoveColumnCommand(int orientation) {
        this(null, orientation);
    }

    public MoveColumnCommand(String name, int orientation) {
        this(name, null, orientation);
    }

    public MoveColumnCommand(String name, String actionClass, int orientation) {
        super(name);
        this.actionClass = actionClass;
        this.orientation = orientation;
        this.distance = 1;
    }

    @Override
    public void execute(Object o) {
        this.getMoveColumnInterface();
        this.getMoveColumn();
        this.getDistanceToMoveColumn();
        this.getOrientation();
        if (this.moveColumnInterface != null) {
            boolean leftToRightOrientation = true;
            if (this.moveColumnInterface instanceof TableView) {
                leftToRightOrientation = ((TableView)this.moveColumnInterface).getComponentOrientation().isLeftToRight();
            }
            int newIndex = this.moveColumn;
            newIndex = this.orientation == 2 || this.orientation == 10 ? (leftToRightOrientation ? (newIndex -= this.distance) : (newIndex += this.distance)) : (leftToRightOrientation ? (newIndex += this.distance) : (newIndex -= this.distance));
            this.moveColumnInterface.moveColumn(this.moveColumn, newIndex);
        }
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        MoveColumnInterface mci = (MoveColumnInterface)filter.getAttribute("moveColumnInterface");
        boolean leftToRightOrientation = true;
        if (mci instanceof TableView) {
            leftToRightOrientation = ((TableView)mci).getComponentOrientation().isLeftToRight();
        }
        int orient = this.orientation;
        Integer o = (Integer)filter.getAttribute("orientation");
        if (o != null) {
            orient = o;
        }
        int moveLeftAmount = this.distance;
        int moveRightAmount = this.distance;
        o = (Integer)filter.getAttribute("moveColumnLeftAmount");
        if (o != null) {
            moveLeftAmount = o;
        }
        if ((o = (Integer)filter.getAttribute("moveColumnRightAmount")) != null) {
            moveRightAmount = o;
        }
        if (mci != null) {
            int colIndex;
            int newIndex = colIndex = ((Integer)filter.getAttribute("moveColumn")).intValue();
            newIndex = orient == 2 || orient == 10 ? (leftToRightOrientation ? (newIndex -= moveLeftAmount) : (newIndex += moveRightAmount)) : (leftToRightOrientation ? (newIndex += moveRightAmount) : (newIndex -= moveLeftAmount));
            if (mci.isColumnMoveAllowed(colIndex, newIndex)) {
                return 0;
            }
        }
        return 16;
    }

    public void setMoveColumnInterface(MoveColumnInterface moveColumnInterface) {
        this.moveColumnInterface = moveColumnInterface;
    }

    public MoveColumnInterface getMoveColumnInterface() {
        return this.moveColumnInterface;
    }

    public void setMoveColumn(int column) {
        this.moveColumn = column;
    }

    public int getMoveColumn() {
        return this.moveColumn;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setDistanceToMoveColumn(int newDistance) {
        this.distance = newDistance;
    }

    public int getDistanceToMoveColumn() {
        return this.distance;
    }
}

