/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.support.RB;
import com.sas.codepolicy.SASScope;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

@SASScope(value="ALL")
public abstract class BaseViewerSupport {
    private String actionSupportType;
    private Map hiddenActions;
    private Collection areaTypes;
    private Object uniqueId;
    static final String RB_KEY = "BaseViewerSupport.";

    @SASScope
    public BaseViewerSupport() {
    }

    public BaseViewerSupport(ActionProviderViewInterface viewer) {
        this.setUniqueId(new Integer(System.identityHashCode(viewer)));
    }

    @SASScope
    public BaseViewerSupport(String actionSupportType) {
        this();
        this.setActionSupportType(actionSupportType);
    }

    @SASScope
    public Map getHiddenActionsMap() {
        if (this.hiddenActions == null) {
            this.hiddenActions = Collections.synchronizedMap(new HashMap());
        }
        return this.hiddenActions;
    }

    public void setActionVisible(String actionType, String areaType, boolean visible) {
        block19: {
            Vector hiddenAreaTypesList;
            block17: {
                block18: {
                    if (areaType != null && !this.validAreaType(areaType)) {
                        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidAreaType.txt"), areaType));
                    }
                    if (actionType != null) {
                        if (areaType == null) {
                            if (this.areaTypes == null) {
                                this.areaTypes = this.listAreaTypes();
                            }
                            Iterator iterator = this.areaTypes.iterator();
                            boolean foundActionTypeInOneArea = false;
                            while (iterator.hasNext()) {
                                if (!this.validActionType(actionType, (String)iterator.next())) continue;
                                foundActionTypeInOneArea = true;
                            }
                            if (!foundActionTypeInOneArea) {
                                throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidActionType.txt"), actionType, areaType));
                            }
                        } else if (!this.validActionType(actionType, areaType)) {
                            throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidActionType.txt"), actionType, areaType));
                        }
                    } else {
                        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionType.txt"));
                    }
                    hiddenAreaTypesList = (Vector)this.getHiddenActionsMap().get(actionType);
                    if (visible) break block17;
                    if (hiddenAreaTypesList == null) {
                        hiddenAreaTypesList = new Vector();
                        this.getHiddenActionsMap().put(actionType, hiddenAreaTypesList);
                    }
                    if (areaType != null) break block18;
                    if (this.areaTypes == null) {
                        this.areaTypes = this.listAreaTypes();
                    }
                    if (this.areaTypes == null) break block19;
                    for (String validAreaType : this.areaTypes) {
                        if (hiddenAreaTypesList.contains(validAreaType)) continue;
                        hiddenAreaTypesList.listIterator().add(validAreaType);
                    }
                    break block19;
                }
                if (hiddenAreaTypesList.contains(areaType)) break block19;
                hiddenAreaTypesList.listIterator().add(areaType);
                break block19;
            }
            if (hiddenAreaTypesList != null) {
                if (areaType == null) {
                    Iterator iterator = this.getHiddenActionsMap().keySet().iterator();
                    while (iterator.hasNext()) {
                        String hiddenActionType = (String)iterator.next();
                        if (!actionType.equals(hiddenActionType)) continue;
                        iterator.remove();
                    }
                } else {
                    Iterator iterator = hiddenAreaTypesList.iterator();
                    while (iterator.hasNext()) {
                        String hiddenAreaType = (String)iterator.next();
                        if (!hiddenAreaType.equals(areaType)) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }

    public boolean isActionVisible(String actionType, String areaType) {
        if (areaType != null && !this.validAreaType(areaType)) {
            throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidAreaType.txt"), areaType));
        }
        if (!this.validActionType(actionType, areaType)) {
            throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "invalidActionType.txt"), actionType, areaType));
        }
        List hiddenAreaTypesList = (List)this.getHiddenActionsMap().get(actionType);
        if (hiddenAreaTypesList != null) {
            if (areaType == null) {
                if (this.areaTypes == null) {
                    this.areaTypes = this.listAreaTypes();
                }
                Iterator iterator = this.areaTypes.iterator();
                while (iterator.hasNext()) {
                    if (!hiddenAreaTypesList.contains((String)iterator.next())) continue;
                    return false;
                }
            } else if (hiddenAreaTypesList.contains(areaType)) {
                return false;
            }
        }
        return true;
    }

    public void setActionSupportType(String actionSupportType) {
        if (this.actionSupportType != null && !actionSupportType.equals(this.actionSupportType)) {
            this.areaTypes = null;
        }
        this.actionSupportType = actionSupportType;
    }

    public String getActionSupportType() {
        return this.actionSupportType;
    }

    public Object getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Object uniqueId) {
        this.uniqueId = uniqueId;
    }

    @SASScope
    protected boolean validAreaType(String areaType) {
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (this.areaTypes == null) {
            this.areaTypes = this.listAreaTypes();
        }
        return this.areaTypes != null && this.areaTypes.contains(areaType);
    }

    @SASScope
    protected boolean validActionType(String actionType, String areaType) {
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionType.txt"));
        }
        Collection actionTypeList = this.listActionTypes(areaType);
        return actionTypeList != null && actionTypeList.contains(actionType);
    }

    public abstract Collection listAreaTypes();

    public abstract Collection listActionTypes(String var1);
}

