/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support;

import com.sas.actionprovider.ActionCache;
import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.ActionTypeCounter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.AreaFilterCache;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.BaseActionProvider;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.actionprovider.DynamicRootRenderInfoInterface;
import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.actionprovider.support.ActionEntry;
import com.sas.actionprovider.support.DynamicActionCountInterface;
import com.sas.actionprovider.support.RB;
import com.sas.actionprovider.util.DynamicValueInfo;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

@SASScope(value="ALL")
public abstract class BaseActionProviderSupport {
    static final String RB_KEY = "BaseActionProviderSupport.";
    public static final String NON_SPECIFIC_AREA = "NON_SPECIFIC_AREA";
    public static final int ENABLED = 0;
    public static final int DISABLED = 16;
    public static final int VIEWER_DISABLED = 32;
    public static final int AREA_DISABLED = 64;
    public static final int MODEL_TYPE_DISABLED = 1;
    public static final int MODEL_STATE_DISABLED = 2;
    public static final int MODEL_MEMBER_DISABLED = 4;
    public static final int IS_CURRENT_STATE_DISABLED = 8;
    public static final int UNSUPPORTED = 128;
    @SASScope
    protected static final String ACTION = "ACTION";
    @SASScope
    protected static final String OVERRIDES = "OVERRIDES";
    private static final String CONDITION = "CONDITION";
    @SASScope
    protected static final String AREA = "AREA";
    @SASScope
    protected static final String VIEWERS = "VIEWERS";
    private static final String DEFAULT_ACTION_TYPES = "DEFAULT_ACTION_TYPES";
    private static final String CUSTOM_ACTION_TYPES = "CUSTOM_ACTION_TYPES";
    private boolean authoritativeOverridesEnabled;
    @SASScope
    public static final String HTTP_ACTIONS = "com.sas.actionprovider.HttpAction";
    @SASScope
    public static final String SWING_ACTIONS = "com.sas.actionprovider.SwingAction";
    public static final String AREA_VALUE_ATTRKEY = "areaValue";
    private Map actions;
    private Map defaultAOLMap;
    private Map customActionRemovalMap;
    private Map viewerToOrderListsMap;
    private Locale locale;
    private Class actionClass;
    private SimpleTemplate simpleTemplate;
    private BaseActionProvider actionProvider;
    private ActionTypeCounter actionTypeCounter;
    private Map attributeInfos = Collections.synchronizedMap(new HashMap(31));
    @SASScope
    protected Map actionTypeToShortActionTypeMap;
    private Class[] attributeMethodsArgType;
    private StringBuffer smallBuffer;
    @SASScope
    protected boolean debug;

    public BaseActionProviderSupport() {
        this(null);
    }

    public BaseActionProviderSupport(Class actionClass) {
        if (actionClass != null) {
            this.setActionClass(actionClass);
        }
        this.actions = Collections.synchronizedMap(new HashMap(7, 1.0f));
        this.defaultAOLMap = Collections.synchronizedMap(new HashMap(7, 1.0f));
        this.customActionRemovalMap = Collections.synchronizedMap(new HashMap(3, 1.0f));
        this.viewerToOrderListsMap = Collections.synchronizedMap(new HashMap(3, 1.0f));
        this.actionTypeCounter = new ActionTypeCounter();
        this.actionTypeToShortActionTypeMap = this.initializeShortActionTypeMap();
        this.authoritativeOverridesEnabled = false;
    }

    @SASScope
    protected Map initializeShortActionTypeMap() {
        return new HashMap();
    }

    @SASScope
    protected void setActionClass(Class actionClass) {
        this.actionClass = actionClass;
    }

    @SASScope
    protected Class getActionClass() {
        return this.actionClass;
    }

    public ActionOrderList getActionOrderList(ActionProviderViewInterface viewer, String areaType) {
        ActionOrderList aol = null;
        if (viewer == null) {
            aol = (ActionOrderList)this.defaultAOLMap.get(areaType);
        } else {
            Object uniqueId = viewer.getUniqueId();
            HashMap<String, ActionOrderList> viewerAreaTypeToOrderListMap = (HashMap<String, ActionOrderList>)this.viewerToOrderListsMap.get(uniqueId);
            if (viewerAreaTypeToOrderListMap != null) {
                aol = (ActionOrderList)viewerAreaTypeToOrderListMap.get(areaType);
            } else {
                viewerAreaTypeToOrderListMap = new HashMap<String, ActionOrderList>();
                this.viewerToOrderListsMap.put(uniqueId, viewerAreaTypeToOrderListMap);
            }
            if (aol == null) {
                aol = ActionOrderList.copy((ActionOrderList)this.defaultAOLMap.get(areaType));
                viewerAreaTypeToOrderListMap.put(areaType, aol);
            }
        }
        return aol;
    }

    public void setActionOrderList(ActionOrderList orderList, ActionProviderViewInterface viewer, String areaType) {
        if (orderList != null) {
            this.addAreaType(areaType);
            if (viewer == null) {
                this.defaultAOLMap.put(areaType, orderList);
            } else {
                Object uniqueId = viewer.getUniqueId();
                Map<String, ActionOrderList> viewerAreaTypeToOrderListMap = (Map<String, ActionOrderList>)this.viewerToOrderListsMap.get(uniqueId);
                if (viewerAreaTypeToOrderListMap == null) {
                    viewerAreaTypeToOrderListMap = Collections.synchronizedMap(new HashMap(7, 1.0f));
                    this.viewerToOrderListsMap.put(uniqueId, viewerAreaTypeToOrderListMap);
                }
                viewerAreaTypeToOrderListMap.put(areaType, orderList);
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionOrderList.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAction(BaseAction action, Collection viewers, Area area) {
        Vector<String> vector;
        Vector<String> areaTypesCollection = null;
        if (area == null) {
            vector = areaTypesCollection = this.listAreaTypes();
            synchronized (vector) {
                Iterator iterator = areaTypesCollection.iterator();
                if (action.isCustom()) {
                    while (iterator.hasNext()) {
                        this.validateActionRegistration((String)iterator.next(), action);
                    }
                } else {
                    this.validateActionRegistration((String)iterator.next(), action);
                }
            }
        } else {
            areaTypesCollection = new Vector<String>(6);
            String areaType = area.getType();
            areaTypesCollection.add(areaType);
            this.validateActionRegistration(areaType, action);
        }
        if (areaTypesCollection != null) {
            vector = areaTypesCollection;
            synchronized (vector) {
                for (String currentAreaType : areaTypesCollection) {
                    Map defaultCustomMap = (Map)this.actions.get(currentAreaType);
                    if (action.isCustom()) {
                        Map customActionTypesMap = (Map)defaultCustomMap.get(CUSTOM_ACTION_TYPES);
                        if (customActionTypesMap == null) {
                            customActionTypesMap = Collections.synchronizedMap(new HashMap(7, 1.0f));
                            defaultCustomMap.put(CUSTOM_ACTION_TYPES, customActionTypesMap);
                        }
                        this.registerCustomAction(action, area == null ? new Area(currentAreaType) : area, viewers, customActionTypesMap);
                    } else {
                        this.registerOverrideAction(action, area == null ? new Area(currentAreaType) : area, viewers, (Map)defaultCustomMap.get(DEFAULT_ACTION_TYPES));
                    }
                    String actionType = action.getActionType();
                    Collection collection = viewers;
                    synchronized (collection) {
                        for (ActionProviderViewInterface viewer : viewers) {
                            Vector<String> customActionTypeCollection;
                            Map customizedAreaMap = (Map)this.customActionRemovalMap.get(viewer.getUniqueId());
                            if (customizedAreaMap == null) {
                                customizedAreaMap = Collections.synchronizedMap(new HashMap(7, 1.0f));
                                this.customActionRemovalMap.put(viewer.getUniqueId(), customizedAreaMap);
                            }
                            if ((customActionTypeCollection = (Vector<String>)customizedAreaMap.get(currentAreaType)) == null) {
                                customActionTypeCollection = new Vector<String>(2);
                                customizedAreaMap.put(currentAreaType, customActionTypeCollection);
                            }
                            if (customActionTypeCollection.contains(actionType)) continue;
                            customActionTypeCollection.add(actionType);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void registerOverrideAction(BaseAction action, Area area, Collection viewers, Map defaultActionTypesMap) {
        String actionType = action.getActionType();
        ActionEntry actionEntry = (ActionEntry)defaultActionTypesMap.get(actionType);
        Vector<ActionEntry> overridesCollection = actionEntry.getOverrides();
        if (overridesCollection == null) {
            overridesCollection = new Vector<ActionEntry>(1);
            actionEntry.setOverrides(overridesCollection);
        }
        boolean foundAction = false;
        ActionEntry overrideEntry2 = null;
        Vector<ActionEntry> vector = overridesCollection;
        synchronized (vector) {
            for (ActionEntry overrideEntry2 : overridesCollection) {
                BaseAction storedAction;
                if (overrideEntry2 == null || overrideEntry2.getAction() == null || (storedAction = overrideEntry2.getAction()) == null || storedAction != action) continue;
                foundAction = true;
                break;
            }
        }
        if (!foundAction) {
            overrideEntry2 = new ActionEntry();
            overrideEntry2.setAction(action);
            overridesCollection.add(overrideEntry2);
        }
        Collection mergedCollection = this.addToCollection(overrideEntry2.getViewers(), this.convertToUniqueIdCollection(viewers));
        overrideEntry2.setViewers(mergedCollection);
        List values = area.getValues();
        if (values != null && values.size() > 0) {
            overrideEntry2.setArea(area);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void registerCustomAction(BaseAction action, Area area, Collection viewers, Map customActionTypesMap) {
        String actionType = action.getActionType();
        ActionEntry customActionEntry = (ActionEntry)customActionTypesMap.get(actionType);
        if (customActionEntry == null) {
            customActionEntry = new ActionEntry();
            customActionTypesMap.put(actionType, customActionEntry);
        }
        Area areaToRegister = null;
        List values = area.getValues();
        if (values != null && !values.isEmpty()) {
            areaToRegister = area;
        }
        customActionEntry.addRegistration(action, this.convertToUniqueIdCollection(viewers), areaToRegister);
        Map defaultActionTypesMap = this.getActionTypesMap(area.getType(), true);
        if (defaultActionTypesMap != null && defaultActionTypesMap.containsKey(actionType)) {
            return;
        }
        Collection collection = viewers;
        synchronized (collection) {
            Iterator iterator = viewers.iterator();
            while (iterator.hasNext()) {
                ActionOrderList orderList = this.getActionOrderList((ActionProviderViewInterface)iterator.next(), area.getType());
                orderList.add(actionType);
            }
        }
    }

    public ActionList getActions(ActionSupportFilter actionFilter) {
        this.validateFilter(actionFilter);
        this.setFilterLocale(actionFilter);
        this.actionTypeCounter.clear();
        Map areaScopeAttributeMap = this.getAreaScopeAttributeMap(actionFilter);
        if (areaScopeAttributeMap != null) {
            try {
                actionFilter.setAttribute("areaScopeAttributeMap", areaScopeAttributeMap);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
        }
        ActionOrderList orderList = this.getActionOrderList(actionFilter.getViewer(), actionFilter.getAreaType());
        ActionList temp = this.generateActionList(actionFilter, orderList);
        ActionProviderMapPool.returnMap(areaScopeAttributeMap);
        if (temp != null && orderList != null) {
            Map rootAttributesMap = orderList.getRootRenderInfoMap();
            if (orderList instanceof DynamicRootRenderInfoInterface) {
                rootAttributesMap = ((DynamicRootRenderInfoInterface)((Object)orderList)).getRootRenderInfoMap(actionFilter);
            }
            if (rootAttributesMap != null) {
                try {
                    temp.setAttribute("StyleMap", rootAttributesMap.get("StyleMap"));
                }
                catch (AttributeSetException attributeSetException) {
                    // empty catch block
                }
            }
        }
        return temp;
    }

    private void setFilterLocale(ActionSupportFilter filter) {
        BaseActionProvider ap = this.getActionProvider();
        if (ap == null) {
            return;
        }
        filter.setLocale(ap.getLocale());
    }

    public BaseAction getAction(String actionType, ActionSupportFilter actionFilter) {
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionType.txt"));
        }
        this.validateFilter(actionFilter);
        this.setFilterLocale(actionFilter);
        this.actionTypeCounter.clear();
        Map areaScopeAttributeMap = this.getAreaScopeAttributeMap(actionFilter);
        if (areaScopeAttributeMap != null) {
            try {
                actionFilter.setAttribute("areaScopeAttributeMap", areaScopeAttributeMap);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
        }
        BaseAction action = null;
        if (actionFilter.getViewer().isActionVisible(actionType, actionFilter.getAreaType())) {
            action = this.getAction(actionFilter, actionType, false);
        }
        ActionProviderMapPool.returnMap(areaScopeAttributeMap);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionList generateActionList(ActionSupportFilter filter, ActionOrderList orderList) {
        ActionList actionsList = null;
        if (orderList != null) {
            boolean poolingOn = filter.isPoolingOn();
            String areaType = filter.getAreaType();
            BaseAction orderListAction = null;
            String orderListActionType = orderList.getActionType();
            if (orderListActionType != null) {
                List hiddenAreasList;
                Map hiddenActionsMap = filter.getHiddenActionsMap();
                if (hiddenActionsMap != null ? (hiddenAreasList = (List)hiddenActionsMap.get(orderListActionType)) != null && hiddenAreasList.contains(areaType) : !filter.getViewer().isActionVisible(orderListActionType, areaType)) {
                    return null;
                }
                orderListAction = this.getAction(filter, orderListActionType, true);
                if (orderListAction == null) {
                    return null;
                }
                if (!orderListAction.isEnabled()) {
                    ActionList temp = this.setActionListAttributes(this.getActionsList(null, poolingOn), orderListAction, filter);
                    this.getActionProvider().returnAction(orderListAction);
                    return temp;
                }
            } else if (orderList.isEmpty()) {
                return null;
            }
            ActionOrderList actionOrderList = orderList;
            synchronized (actionOrderList) {
                int size = orderList.size();
                for (int j = 0; j < size; ++j) {
                    Object orderElement = orderList.get(j);
                    if (orderElement == ActionList.SEPARATOR) {
                        actionsList = this.getActionsList(actionsList, poolingOn);
                        actionsList.getActions().add(orderElement);
                        continue;
                    }
                    if (orderElement instanceof ActionOrderList) {
                        ActionOrderList aol = (ActionOrderList)orderElement;
                        int listCount = 1;
                        String listActionType = orderList.getActionType();
                        if (listActionType != null) {
                            ActionStrategyInterface asi = this.getStrategy(filter, listActionType, false);
                            if (asi instanceof DynamicActionCountInterface) {
                                listCount = ((DynamicActionCountInterface)((Object)asi)).getActionCount(filter, listActionType);
                            } else if (this instanceof DynamicActionCountInterface) {
                                listCount = ((DynamicActionCountInterface)((Object)this)).getActionCount(filter, listActionType);
                            }
                        }
                        for (int i = 0; i < listCount; ++i) {
                            filter.setListIndex(i + 1);
                            ActionList temp = this.generateActionList(filter, aol);
                            if (temp == null) continue;
                            if (!temp.isEmpty()) {
                                actionsList = this.getActionsList(actionsList, poolingOn);
                                actionsList.getActions().add(temp);
                                continue;
                            }
                            if (aol.isEnabledIfEmpty()) {
                                actionsList = this.getActionsList(actionsList, poolingOn);
                                actionsList.getActions().add(temp);
                                continue;
                            }
                            this.getActionProvider().returnActionList(temp);
                        }
                        continue;
                    }
                    if (!(orderElement instanceof String)) continue;
                    String actionType = (String)orderElement;
                    boolean actionIsVisible = true;
                    Map hiddenActionsMap = filter.getHiddenActionsMap();
                    if (hiddenActionsMap != null) {
                        List hiddenAreasList = (List)hiddenActionsMap.get(actionType);
                        if (hiddenAreasList != null && hiddenAreasList.contains(areaType)) {
                            actionIsVisible = false;
                        }
                    } else if (!filter.getViewer().isActionVisible(actionType, areaType)) {
                        actionIsVisible = false;
                    }
                    if (!actionIsVisible) continue;
                    int actionCount = 1;
                    ActionStrategyInterface asi = this.getStrategy(filter, actionType, false);
                    if (asi instanceof DynamicActionCountInterface) {
                        actionCount = ((DynamicActionCountInterface)((Object)asi)).getActionCount(filter, actionType);
                    } else if (this instanceof DynamicActionCountInterface) {
                        actionCount = ((DynamicActionCountInterface)((Object)this)).getActionCount(filter, actionType);
                    }
                    for (int i = 0; i < actionCount; ++i) {
                        filter.setActionIndex(i + 1);
                        BaseAction action = this.getAction(filter, actionType, false);
                        if (action == null) continue;
                        actionsList = this.getActionsList(actionsList, poolingOn);
                        actionsList.getActions().add(action);
                    }
                }
                if (actionsList != null && !actionsList.getActions().isEmpty() || orderList.isEnabledIfEmpty()) {
                    if (actionsList == null) {
                        actionsList = this.getActionsList(actionsList, poolingOn);
                    }
                    if (orderList.getActionType() == null) {
                        actionsList.putValue("Name", orderList.getName());
                        if (!filter.isSwing()) {
                            actionsList.setId(this.getActionId(filter, null, orderList.getName()));
                        }
                    } else if (orderListAction != null) {
                        this.setActionListAttributes(actionsList, orderListAction, filter);
                    }
                }
            }
            if (orderListAction != null) {
                this.getActionProvider().returnAction(orderListAction);
            }
        }
        return actionsList;
    }

    private ActionStrategyInterface getStrategy(ActionSupportFilter filter, String actionType, boolean listType) {
        String areaType = filter.getAreaType();
        Map defaultActionTypes = this.getActionTypesMap(areaType, true);
        if (defaultActionTypes != null && defaultActionTypes.containsKey(actionType)) {
            ActionEntry actionEntry = (ActionEntry)defaultActionTypes.get(actionType);
            BaseAction action = this.getOverrideAction(actionEntry.getOverrides(), filter, listType);
            if (action == null) {
                action = actionEntry.getAction();
            }
            if (action != null) {
                return action.getActionStrategy();
            }
            return null;
        }
        Map customActionTypes = this.getActionTypesMap(areaType, false);
        if (customActionTypes == null) {
            return null;
        }
        ActionEntry actionEntry = (ActionEntry)customActionTypes.get(actionType);
        if (actionEntry == null) {
            return null;
        }
        BaseAction action = actionEntry.getAction(filter.getViewer().getUniqueId());
        if (action == null) {
            return null;
        }
        return action.getActionStrategy();
    }

    private ActionList getActionsList(ActionList actionsList, boolean fromPool) {
        if (actionsList == null) {
            actionsList = this.getActionProvider().getActionList(fromPool);
        }
        return actionsList;
    }

    private ActionList setActionListAttributes(ActionList actionsList, BaseAction action, ActionSupportFilter filter) {
        List currentDescriptors = action.getCurrentAttributeDescriptors();
        int size = currentDescriptors.size();
        for (int i = 0; i < size; ++i) {
            Object attrValue;
            AttributeDescriptorInterface adi = (AttributeDescriptorInterface)currentDescriptors.get(i);
            String name = adi.getName();
            if (name == null || (attrValue = action.getValue(name)) == null) continue;
            actionsList.putValue(name, attrValue);
        }
        if (actionsList != null && action != null) {
            actionsList.setViewer(action.getViewer());
        }
        if (!filter.isSwing()) {
            actionsList.setId(action.getId());
        }
        return actionsList;
    }

    private BaseAction getAction(ActionSupportFilter filter, String actionType, boolean listType) {
        ActionEntry actionEntry;
        String areaType = filter.getAreaType();
        Map customActionTypes = this.getActionTypesMap(areaType, false);
        if (customActionTypes != null && customActionTypes.containsKey(actionType) && (actionEntry = (ActionEntry)customActionTypes.get(actionType)) != null && actionEntry.getAction(filter.getViewer().getUniqueId()) != null) {
            return this.getSetAction((ActionEntry)customActionTypes.get(actionType), filter, listType);
        }
        Map defaultActionTypes = this.getActionTypesMap(areaType, true);
        if (defaultActionTypes != null && defaultActionTypes.containsKey(actionType)) {
            ActionEntry actionEntry2 = (ActionEntry)defaultActionTypes.get(actionType);
            if (this.overrideExistsForViewer(actionEntry2.getOverrides(), filter.getViewer().getUniqueId())) {
                BaseAction action = this.getOverrideAction(actionEntry2.getOverrides(), filter, listType);
                if (action != null) {
                    return action;
                }
                if (this.isAuthoritativeOverridesEnabled()) {
                    return null;
                }
            }
            return this.getSetAction(actionEntry2, filter, listType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overrideExistsForViewer(Collection overrides, Object uniqueViewerId) {
        if (overrides == null || overrides.isEmpty()) {
            return false;
        }
        Collection collection = overrides;
        synchronized (collection) {
            for (ActionEntry overrideEntry : overrides) {
                if (overrideEntry == null || !overrideEntry.getViewers().contains(uniqueViewerId)) continue;
                return true;
            }
        }
        return false;
    }

    @SASScope
    protected Map getActionTypesMap(String areaType, boolean defaultActionTypes) {
        Map defaultCustomMap = (Map)this.actions.get(areaType);
        if (defaultCustomMap == null) {
            return null;
        }
        Map actionTypesMap = (Map)defaultCustomMap.get(defaultActionTypes ? DEFAULT_ACTION_TYPES : CUSTOM_ACTION_TYPES);
        if (actionTypesMap == null || actionTypesMap.size() <= 0) {
            return null;
        }
        return actionTypesMap;
    }

    @SASScope(value="ALL")
    public BaseAction getDefaultAction(String areaType, String actionType) {
        ActionEntry actionEntry;
        Map defaultActionTypesMap = this.getActionTypesMap(areaType, true);
        if (defaultActionTypesMap != null && (actionEntry = (ActionEntry)defaultActionTypesMap.get(actionType)) != null) {
            return actionEntry.getAction();
        }
        return null;
    }

    private BaseAction getSetAction(ActionEntry actionEntry, ActionSupportFilter filter, boolean listType) {
        if (actionEntry == null) {
            return null;
        }
        Object uniqueViewerId = filter.getViewer().getUniqueId();
        BaseAction action = actionEntry.getAction(uniqueViewerId);
        if (action == null) {
            return null;
        }
        int status = 0;
        Area area = actionEntry.getArea(uniqueViewerId);
        if (area != null && action.getActionStrategy() == null && !this.validArea(area, filter)) {
            if ((action.getReturnStatus() & 0x40) == 0) {
                return null;
            }
            status |= 0x40;
        }
        if (action.getActionStrategy() != null) {
            if (area != null) {
                filter.setValidAreaValues(area.getValues());
            }
            status |= action.getActionStrategy().getActionStatus(action, filter);
        } else {
            status |= this.getActionStatus(action, filter);
        }
        if (status != 0) {
            if ((status & action.getReturnStatus()) != status) {
                return null;
            }
            action = this.getActionProvider().getAction(action, filter.isPoolingOn());
            action.setEnabled(false);
        } else {
            action = this.getActionProvider().getAction(action, filter.isPoolingOn());
        }
        if (action != null && !filter.isSwing()) {
            action.setId(this.getActionId(filter, action.getActionType(), null));
        }
        if (action != null && action.getActionStrategy() != null) {
            action.getActionStrategy().setActionAttributes(action, filter);
            if (this.getActionProvider() != null) {
                this.getActionProvider().setUpAction(action, filter, action.getCurrentAttributeDescriptors(), listType);
            }
        } else {
            this.setActionAttrs(action, filter, listType);
        }
        return action;
    }

    protected String getActionId(ActionSupportFilter filter, String actionType, String orderListName) {
        StringBuffer sb = this.getSmallBuffer();
        if (filter.getViewerId() != null) {
            sb.append(filter.getViewerId());
        }
        if (actionType == null) {
            sb.append("_");
            if (orderListName != null) {
                sb.append(Strings.replace((String)orderListName, (int)0, (int)(orderListName.length() - 1), (String)" ", (String)"_"));
            }
        } else {
            String shortActionType = (String)this.actionTypeToShortActionTypeMap.get(actionType);
            if (shortActionType == null) {
                shortActionType = actionType;
            }
            if (!shortActionType.startsWith("_")) {
                sb.append("_");
            }
            sb.append(shortActionType);
        }
        sb.append(this.actionTypeCounter.getNextCount(actionType));
        return sb.toString();
    }

    @SASScope
    protected int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        int status = 0;
        DynamicAttributeCommandInterface command = action.getCommand();
        if (command != null) {
            if (command instanceof CommandSupportedInterface && !((CommandSupportedInterface)((Object)command)).isSupported(filter)) {
                status |= 0x80;
            }
            if (command instanceof CommandStatusInterface) {
                status |= ((CommandStatusInterface)((Object)command)).getCommandStatus(filter);
            }
        }
        return status;
    }

    @SASScope
    protected boolean isValidAreaType(String areaType) {
        Collection c = this.listAreaTypes();
        return c.contains(areaType);
    }

    @SASScope
    protected void setActionAttrs(BaseAction action, ActionSupportFilter filter, boolean listType) {
        Map areaScopeAttributeMap = (Map)filter.getAttribute("areaScopeAttributeMap");
        Map actionScopeAttributeMap = this.getActionScopeAttributeMap(action.getActionType(), filter);
        HashMap valueDictionary = null;
        List currentDescriptors = action.getCurrentAttributeDescriptors();
        int numberOfAttributes = currentDescriptors.size();
        for (int i = 0; i < numberOfAttributes; ++i) {
            AttributeDescriptorInterface adi = (AttributeDescriptorInterface)currentDescriptors.get(i);
            if (adi.getSupplementalProperty("DYNAMIC") == Boolean.FALSE) continue;
            String attributeName = adi.getName();
            if (adi.getSupplementalProperty("CUSTOM") == Boolean.TRUE) {
                Object value = this.getCustomAttributeValue(attributeName, filter);
                if (value != null) {
                    action.putValue(attributeName, value);
                    continue;
                }
                if (!adi.isRequired()) continue;
            }
            Object currentValue = action.getValue(attributeName);
            if (currentValue != null && currentValue instanceof String && ((String)currentValue).indexOf("%") >= 0) {
                SimpleTemplate template = this.getSimpleTemplate();
                template.setTemplate((String)currentValue);
                if (valueDictionary == null) {
                    valueDictionary = ActionProviderMapPool.getMap();
                }
                this.populateValueDictionary(valueDictionary, areaScopeAttributeMap, actionScopeAttributeMap, template.getNameDictionary(), filter, action.getActionType());
                template.setValueDictionary((Map)valueDictionary);
                String formattedString = template.format();
                action.putValue(attributeName, formattedString.equals("") ? null : formattedString);
                continue;
            }
            if (actionScopeAttributeMap != null && actionScopeAttributeMap.containsKey(attributeName)) {
                action.putValue(attributeName, actionScopeAttributeMap.get(attributeName));
                continue;
            }
            Object o = this.getActionScopeAttribute(action.getActionType(), attributeName, filter);
            if (o == null) {
                o = this.getActionScopeAttribute(action.getActionType(), attributeName, filter, currentValue);
            }
            if (o == null) {
                if (areaScopeAttributeMap != null && areaScopeAttributeMap.containsKey(attributeName)) {
                    o = areaScopeAttributeMap.get(attributeName);
                } else {
                    o = this.getAreaScopeAttribute(attributeName, filter);
                    if (o == null) {
                        o = this.getDynamicValue(attributeName, filter, currentValue);
                    }
                }
            }
            if (o == null) continue;
            action.putValue(attributeName, o);
        }
        if (actionScopeAttributeMap != null) {
            ActionProviderMapPool.returnMap(actionScopeAttributeMap);
        }
        if (valueDictionary != null) {
            ActionProviderMapPool.returnMap(valueDictionary);
        }
        if (this.getActionProvider() != null) {
            this.getActionProvider().setUpAction(action, filter, currentDescriptors, listType);
        }
    }

    private void populateValueDictionary(Map valueDictionary, Map areaScopeAttributeMap, Map actionScopeAttributeMap, Map neededKeys, ActionSupportFilter filter, String actionType) {
        if (neededKeys == null) {
            return;
        }
        Set keys = neededKeys.keySet();
        if (keys == null) {
            return;
        }
        for (String neededKey : keys) {
            if (valueDictionary.containsKey(neededKey)) continue;
            if (actionScopeAttributeMap != null && actionScopeAttributeMap.containsKey(neededKey)) {
                valueDictionary.put(neededKey, actionScopeAttributeMap.get(neededKey));
                continue;
            }
            Object o = this.getActionScopeAttribute(actionType, neededKey, filter);
            if (o == null) {
                if (areaScopeAttributeMap != null && areaScopeAttributeMap.containsKey(neededKey)) {
                    o = areaScopeAttributeMap.get(neededKey);
                } else {
                    o = this.getAreaScopeAttribute(neededKey, filter);
                    if (o == null) {
                        o = this.getDynamicValue(neededKey, filter, null);
                    }
                }
            }
            if (o == null) continue;
            valueDictionary.put(neededKey, o);
        }
    }

    @SASScope
    protected Object getAreaScopeAttribute(String attributeName, ActionSupportFilter filter) {
        return null;
    }

    @SASScope
    protected Object getActionScopeAttribute(String actionType, String attributeName, ActionSupportFilter filter) {
        return null;
    }

    protected Object getActionScopeAttribute(String actionType, String attributeName, ActionSupportFilter filter, Object currentValue) {
        return null;
    }

    protected Map getActionScopeAttributeMap(String actionType, ActionSupportFilter filter) {
        return null;
    }

    @SASScope
    protected abstract Map getAreaScopeAttributeMap(ActionSupportFilter var1);

    @SASScope
    protected Object getCustomAttributeValue(String attributeName, ActionSupportFilter filter) {
        return null;
    }

    public Collection listAreaTypes() {
        return new HashSet(this.actions.keySet());
    }

    public Collection listActionTypes(String areaType) {
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        Map defaultActionTypesMap = this.getActionTypesMap(areaType, true);
        Map customActionTypesMap = this.getActionTypesMap(areaType, false);
        if (defaultActionTypesMap == null && customActionTypesMap == null) {
            return new HashSet(0);
        }
        if (customActionTypesMap == null && defaultActionTypesMap != null) {
            return new HashSet(defaultActionTypesMap.keySet());
        }
        if (defaultActionTypesMap == null && customActionTypesMap != null) {
            return new HashSet(customActionTypesMap.keySet());
        }
        Set baseKeySet = defaultActionTypesMap.keySet();
        if (baseKeySet != null) {
            return this.mergeSets(baseKeySet, customActionTypesMap.keySet());
        }
        return new HashSet(customActionTypesMap.keySet());
    }

    private Set mergeSets(Set first, Set second) {
        if (first == null && second == null) {
            return new HashSet(0);
        }
        if (first == null) {
            return new HashSet(second);
        }
        if (second == null) {
            return new HashSet(first);
        }
        HashSet set = new HashSet(first);
        set.addAll(second);
        return set;
    }

    private Collection addToCollection(Collection target, Vector source) {
        if (target == null && source == null) {
            return new Vector();
        }
        if (target == null) {
            return source;
        }
        if (source == null) {
            return target;
        }
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            Object obj = source.get(i);
            if (target.contains(obj)) continue;
            target.add(obj);
        }
        return target;
    }

    @SASScope
    protected Map addAreaType(String areaType) {
        if (areaType != null) {
            Map defaultCustomMap = (Map)this.actions.get(areaType);
            if (defaultCustomMap == null) {
                defaultCustomMap = Collections.synchronizedMap(new HashMap(3, 1.0f));
                defaultCustomMap.put(DEFAULT_ACTION_TYPES, Collections.synchronizedMap(new HashMap(7, 1.0f)));
                this.actions.put(areaType, defaultCustomMap);
                ActionOrderList orderList = this.getActionOrderList(null, areaType);
                if (orderList == null) {
                    orderList = new ActionOrderList("ROOT_NAME");
                    this.defaultAOLMap.put(areaType, orderList);
                }
            }
            return (Map)defaultCustomMap.get(DEFAULT_ACTION_TYPES);
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
    }

    private Map addAreaToActionAssociation(String areaType, String actionType) {
        ActionOrderList orderList;
        Map defaultActionTypesMap = this.addAreaType(areaType);
        if (!defaultActionTypesMap.containsKey(actionType)) {
            defaultActionTypesMap.put(actionType, null);
        }
        if (!(orderList = this.getActionOrderList(null, areaType)).contains(actionType)) {
            orderList.add(actionType);
        }
        return defaultActionTypesMap;
    }

    private Map removeAreaToActionAssociation(String areaType, String actionType) {
        Map defaultActionTypesMap = null;
        Map defaultCustomMap = (Map)this.actions.get(areaType);
        if (defaultCustomMap != null) {
            ActionOrderList orderList;
            defaultActionTypesMap = (Map)defaultCustomMap.get(DEFAULT_ACTION_TYPES);
            if (defaultActionTypesMap != null && !defaultActionTypesMap.containsKey(actionType)) {
                defaultActionTypesMap.remove(actionType);
            }
            if ((orderList = this.getActionOrderList(null, areaType)).contains(actionType)) {
                orderList.remove(actionType);
            }
        }
        return defaultActionTypesMap;
    }

    protected void addDefaultAction(BaseAction action, String areaType) {
        String actionType = null;
        if (action == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAction.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        actionType = action.getActionType();
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionTypeInvalid.txt"));
        }
        action.setCustom(false);
        Map defaultActionTypesMap = this.addAreaToActionAssociation(areaType, actionType);
        if (defaultActionTypesMap != null && defaultActionTypesMap.size() > 0) {
            ActionEntry actionEntry = (ActionEntry)defaultActionTypesMap.get(actionType);
            if (actionEntry != null) {
                actionEntry.setAction(action);
            } else {
                actionEntry = new ActionEntry();
                actionEntry.setAction(action);
                defaultActionTypesMap.put(actionType, actionEntry);
            }
        }
    }

    @SASScope
    protected void removeDefaultAction(String actionType, String areaType) {
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionTypeInvalid.txt"));
        }
        this.removeAreaToActionAssociation(areaType, actionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected BaseAction getOverrideAction(Collection overrides, ActionSupportFilter actionFilter, boolean listType) {
        if (overrides == null) {
            return null;
        }
        Object uniqueViewerId = actionFilter.getViewer().getUniqueId();
        Collection collection = overrides;
        synchronized (collection) {
            for (ActionEntry overrideEntry : overrides) {
                BaseAction action;
                if (overrideEntry == null || !overrideEntry.getViewers().contains(uniqueViewerId) || (action = this.getSetAction(overrideEntry, actionFilter, listType)) == null) continue;
                return action;
            }
        }
        return null;
    }

    @SASScope
    protected void validateActionRegistration(String areaType, BaseAction action) {
        String actionType = null;
        if (this.actions.size() <= 0) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noAreaTypesDefined.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (action == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAction.txt"));
        }
        actionType = action.getActionType();
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionTypeInvalid.txt"));
        }
        Map defaultCustomMap = (Map)this.actions.get(areaType);
        if (defaultCustomMap == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAreaType.txt"));
        }
        if (!action.isCustom()) {
            Map defaultActionTypesMap = (Map)defaultCustomMap.get(DEFAULT_ACTION_TYPES);
            if (defaultActionTypesMap != null && defaultActionTypesMap.size() > 0) {
                if (!defaultActionTypesMap.containsKey(actionType)) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noDefaultTypeMatchingOverride.txt"));
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "noDefaultTypeMatchingOverride.txt"));
            }
        }
    }

    @SASScope
    protected void validateFilter(ActionSupportFilter filter) {
        String areaType = null;
        if (filter == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullFilter.txt"));
        }
        areaType = filter.getAreaType();
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        try {
            if (this.getClass().getField(areaType) == null) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAreaType.txt"));
            }
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAreaType.txt"));
        }
        catch (SecurityException cse) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAreaType.txt"));
        }
        if (filter.getViewer() == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullViewer.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public ActionList getDefaultActions(String areaType) {
        ActionList actionList = new ActionList();
        Map defaultActionTypes = this.getActionTypesMap(areaType, true);
        if (defaultActionTypes != null && defaultActionTypes.size() > 0) {
            List actions = actionList.getActions();
            Map map = defaultActionTypes;
            synchronized (map) {
                Iterator iterator = defaultActionTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    actions.add(((ActionEntry)defaultActionTypes.get(iterator.next())).getAction());
                }
            }
        }
        return actionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection listDefaultActions(String areaType) {
        ArrayList<BaseAction> actionList = new ArrayList<BaseAction>(15);
        Map defaultActionTypes = this.getActionTypesMap(areaType, true);
        if (defaultActionTypes != null && defaultActionTypes.size() > 0) {
            Map map = defaultActionTypes;
            synchronized (map) {
                Iterator iterator = defaultActionTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    actionList.add(((ActionEntry)defaultActionTypes.get(iterator.next())).getAction());
                }
            }
        }
        return actionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector convertToUniqueIdCollection(Collection viewers) {
        Collection collection = viewers;
        synchronized (collection) {
            Vector<Object> hashCodeCollection = new Vector<Object>(viewers.size() + 1, 1);
            Iterator iterator = viewers.iterator();
            while (iterator.hasNext()) {
                hashCodeCollection.add(((ActionProviderViewInterface)iterator.next()).getUniqueId());
            }
            return hashCodeCollection;
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void reset() {
        this.viewerToOrderListsMap.clear();
        this.customActionRemovalMap.clear();
        for (Object areaType : this.actions.keySet()) {
            Map defaultCustomMap = (Map)this.actions.get(areaType);
            Map customActionMap = (Map)defaultCustomMap.get(CUSTOM_ACTION_TYPES);
            if (customActionMap != null) {
                customActionMap.clear();
            }
            Map defaultActionMap = (Map)defaultCustomMap.get(DEFAULT_ACTION_TYPES);
            Set defaultActionTypes = defaultActionMap.keySet();
            Iterator defaultActionTypesIterator = defaultActionTypes.iterator();
            while (defaultActionTypesIterator.hasNext()) {
                ActionEntry actionEntry = (ActionEntry)defaultActionMap.get(defaultActionTypesIterator.next());
                if (actionEntry.getOverrides() == null) continue;
                actionEntry.getOverrides().clear();
            }
            ActionOrderList defaultAOL = (ActionOrderList)this.defaultAOLMap.get(areaType);
            if (defaultAOL == null || defaultAOL.isEmpty()) {
                return;
            }
            if (defaultActionMap == null || defaultActionMap.isEmpty()) {
                defaultAOL.clear();
                return;
            }
            this.removeAllNonDefaultActionTypes(defaultAOL, defaultActionTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllNonDefaultActionTypes(ActionOrderList aol, Set defaultActionTypes) {
        if (aol == null) {
            return;
        }
        ActionOrderList actionOrderList = aol;
        synchronized (actionOrderList) {
            ListIterator iterator = aol.listIterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item == ActionList.SEPARATOR) continue;
                if (item instanceof ActionOrderList) {
                    this.removeAllNonDefaultActionTypes((ActionOrderList)item, defaultActionTypes);
                    continue;
                }
                if (!(item instanceof String) || defaultActionTypes.contains(item)) continue;
                iterator.remove();
            }
        }
    }

    @SASScope
    public void flushViewerReferencesFromSupportClass(ActionProviderViewInterface viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullViewer.txt"));
        }
        this.flushViewerReferencesFromSupportClassFromId(viewer.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public void flushViewerReferencesFromSupportClassFromId(Object uniqueId) {
        Map customAreaMap;
        if (this.viewerToOrderListsMap.containsKey(uniqueId)) {
            this.viewerToOrderListsMap.remove(uniqueId);
        }
        if ((customAreaMap = (Map)this.customActionRemovalMap.get(uniqueId)) != null) {
            Map map = customAreaMap;
            synchronized (map) {
                for (String areaType : customAreaMap.keySet()) {
                    Map defaultCustomMap = (Map)this.actions.get(areaType);
                    if (defaultCustomMap == null) continue;
                    Map customActionTypesMap = (Map)defaultCustomMap.get(CUSTOM_ACTION_TYPES);
                    Map defaultActionTypesMap = (Map)defaultCustomMap.get(DEFAULT_ACTION_TYPES);
                    Collection customActionTypesCollection = (Collection)customAreaMap.get(areaType);
                    if (customActionTypesCollection == null) continue;
                    for (String actionType : customActionTypesCollection) {
                        Collection overrideCollection;
                        ActionEntry actionEntry;
                        if (customActionTypesMap != null) {
                            Collection viewers;
                            actionEntry = (ActionEntry)customActionTypesMap.get(actionType);
                            if (actionEntry.removeViewer(uniqueId) == 0) {
                                customActionTypesMap.remove(actionType);
                            }
                            if (actionEntry != null && (viewers = actionEntry.getViewers()) != null) {
                                viewers.remove(uniqueId);
                                if (viewers.size() == 0) {
                                    customActionTypesMap.remove(actionType);
                                    ActionOrderList defaulAOL = (ActionOrderList)this.defaultAOLMap.get(areaType);
                                    if (defaulAOL != null) {
                                        defaulAOL.removeAll(actionType, true);
                                    }
                                }
                            }
                        }
                        if (defaultActionTypesMap == null || (actionEntry = (ActionEntry)defaultActionTypesMap.get(actionType)) == null || (overrideCollection = actionEntry.getOverrides()) == null) continue;
                        Iterator overrideEntryIterator = overrideCollection.iterator();
                        while (overrideEntryIterator.hasNext()) {
                            Collection viewers;
                            ActionEntry overrideEntry = (ActionEntry)overrideEntryIterator.next();
                            if (overrideEntry == null || (viewers = overrideEntry.getViewers()) == null) continue;
                            viewers.remove(uniqueId);
                            if (viewers.size() != 0) continue;
                            overrideEntryIterator.remove();
                        }
                    }
                }
            }
            this.customActionRemovalMap.remove(uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public ActionCache getActionCache(AreaFilterCache cache) {
        this.validateFilter(cache);
        ActionCache actionCache = new ActionCache();
        ActionSupportFilter filter = new ActionSupportFilter(cache.getActionSupportType(), cache.getAreaType(), cache.getViewer());
        filter.setDelay(cache.getDelay());
        int numberOfDynamicAttrMaps = cache.size();
        for (int i = 0; i < numberOfDynamicAttrMaps; ++i) {
            Map dynamicAttrMap = cache.getDynamicFilterAttributes(i);
            if (dynamicAttrMap != null) {
                Map map = dynamicAttrMap;
                synchronized (map) {
                    for (String attrName : dynamicAttrMap.keySet()) {
                        try {
                            filter.setAttribute(attrName, dynamicAttrMap.get(attrName));
                        }
                        catch (AttributeSetException attributeSetException) {}
                    }
                }
            }
            ActionList al = this.getActions(filter);
            actionCache.add(al);
        }
        return actionCache;
    }

    private SimpleTemplate getSimpleTemplate() {
        if (this.simpleTemplate == null) {
            this.simpleTemplate = new SimpleTemplate();
        }
        return this.simpleTemplate;
    }

    public void setActionProvider(BaseActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public BaseActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public abstract void initialize();

    @SASScope
    protected abstract boolean validArea(Area var1, ActionSupportFilter var2);

    public abstract BaseAction newActionInstance(String var1, String var2);

    @SASScope
    protected Object getDynamicValue(String valueName, ActionSupportFilter filter, Object defaultValue) {
        Object returnValue = null;
        DynamicValueInfo valueInfo = this.getDynamicValueInfo(filter.getAreaType(), valueName);
        if (valueInfo != null) {
            if (valueInfo.isFilterValue()) {
                String filterAlias = valueInfo.getFilterAlias();
                returnValue = filter.getAttribute(filterAlias != null ? filterAlias : valueName);
            } else {
                try {
                    returnValue = valueInfo.getValueMethod().invoke(valueInfo.getValueObject(), filter.getArgumentObjectArray());
                }
                catch (IllegalAccessException iae) {
                    System.out.println("BaseActionProviderSupport: getDynamicValue(): IllegalAccessException, this = " + this + ", attribute = " + valueName);
                }
                catch (InvocationTargetException ite) {
                    System.out.println("BaseActionProviderSupport: getDynamicValue(): InvocationTargetException, this = " + this + ", attribute = " + valueName);
                }
            }
        }
        if (returnValue == null && !this.isNullValid(valueName)) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    private DynamicValueInfo getDynamicValueInfo(String areaType, String valueName) {
        Map areaAttributeInfos = (Map)this.attributeInfos.get(areaType);
        if (areaAttributeInfos == null) {
            return null;
        }
        return (DynamicValueInfo)areaAttributeInfos.get(valueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void addDynamicValueInfo(String areaType, String valueName, String methodName, Object methodObject, String filterAlias, boolean nullValid) {
        Map<String, DynamicValueInfo> areaAttributeInfos = (Map<String, DynamicValueInfo>)this.attributeInfos.get(areaType);
        if (areaAttributeInfos == null) {
            areaAttributeInfos = Collections.synchronizedMap(new HashMap(31));
            this.attributeInfos.put(areaType, areaAttributeInfos);
        }
        try {
            DynamicValueInfo valueInfo = new DynamicValueInfo();
            valueInfo.setValueName(valueName);
            valueInfo.setNullValid(nullValid);
            if (methodName == null) {
                valueInfo.setFilterValue(true);
                valueInfo.setFilterAlias(filterAlias);
            } else {
                valueInfo.setValueObject(methodObject);
                if (methodObject instanceof Class) {
                    valueInfo.setValueMethod(((Class)methodObject).getMethod(methodName, this.getAttributeMethodsArgType()));
                } else {
                    valueInfo.setValueMethod(methodObject.getClass().getMethod(methodName, this.getAttributeMethodsArgType()));
                }
            }
            Map<String, DynamicValueInfo> map = areaAttributeInfos;
            synchronized (map) {
                areaAttributeInfos.put(valueName, valueInfo);
            }
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("BAS: addAttributeMethod(): NoSuchMethodException, method = " + methodName);
        }
    }

    private boolean isNullValid(String valueName) {
        DynamicValueInfo valueInfo = (DynamicValueInfo)this.attributeInfos.get(valueName);
        if (valueInfo == null) {
            return false;
        }
        return valueInfo.isNullValid();
    }

    private Class[] getAttributeMethodsArgType() {
        if (this.attributeMethodsArgType == null) {
            this.attributeMethodsArgType = new Class[1];
            this.attributeMethodsArgType[0] = ActionSupportFilter.class;
        }
        return this.attributeMethodsArgType;
    }

    private StringBuffer getSmallBuffer() {
        if (this.smallBuffer == null) {
            this.smallBuffer = new StringBuffer();
        } else {
            this.smallBuffer.setLength(0);
        }
        return this.smallBuffer;
    }

    @SASScope
    public void setAuthoritativeOverridesEnabled(boolean authoritativeOverridesEnabled) {
        this.authoritativeOverridesEnabled = authoritativeOverridesEnabled;
    }

    @SASScope
    public boolean isAuthoritativeOverridesEnabled() {
        return this.authoritativeOverridesEnabled;
    }
}

