/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies;

import com.sas.actionprovider.ActionStatusKeysInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.actionprovider.util.DynamicValueInfo;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.util.SimpleTemplate;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseActionStrategy
implements ActionStrategyInterface,
ActionStatusKeysInterface {
    static final String RB_KEY = "BaseActionStrategy.";
    protected static String TEMPLATE_DELIMITER = "%";
    private static String INVALID_FORMATTED_VALUE = "";
    private Map attributeInfos = Collections.synchronizedMap(new HashMap(31));
    private Class[] attributeMethodsArgType;
    private boolean swing;
    private Object util;

    public BaseActionStrategy() {
        this(true, null);
    }

    public BaseActionStrategy(boolean swing, Object utilObject) {
        this.setUtilObject(utilObject);
        this.setSwing(swing);
        this.initialize();
    }

    protected void initialize() {
    }

    @Override
    public void initializeAction(BaseAction action, String areaType, Locale locale) {
        this.initializeActionAttributes(action, areaType, locale);
        this.setLocaleDependentDefaultAttributes(action, areaType, locale);
    }

    protected void setUtilObject(Object util) {
        this.util = util;
    }

    protected Object getUtilObject() {
        return this.util;
    }

    protected void setSwing(boolean swing) {
        this.swing = swing;
    }

    protected boolean isSwing() {
        return this.swing;
    }

    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
    }

    @Override
    public void setLocaleDependentDefaultAttributes(BaseAction action, String areaType, Locale locale) {
    }

    @Override
    public void setActionAttributes(BaseAction action, ActionSupportFilter filter) {
        List currentDescriptors = action.getCurrentAttributeDescriptors();
        if (currentDescriptors == null) {
            return;
        }
        int numberOfAttributes = currentDescriptors.size();
        for (int i = 0; i < numberOfAttributes; ++i) {
            AttributeDescriptorInterface adi = (AttributeDescriptorInterface)currentDescriptors.get(i);
            if (adi.getSupplementalProperty("DYNAMIC") == Boolean.FALSE) continue;
            String attributeName = adi.getName();
            if (adi.getSupplementalProperty("CUSTOM") == Boolean.TRUE) {
                action.putValue(attributeName, this.getCustomAttributeValue(attributeName, filter));
                continue;
            }
            Object currentValue = action.getValue(attributeName);
            if (currentValue != null && currentValue instanceof String && ((String)currentValue).indexOf(TEMPLATE_DELIMITER) >= 0) {
                action.putValue(attributeName, this.getFormattedTemplateValue((String)currentValue, filter));
                continue;
            }
            Object value = this.getDynamicValue(attributeName, filter, currentValue);
            action.putValue(attributeName, value);
        }
    }

    @Override
    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        int status = 0;
        DynamicAttributeCommandInterface command = action.getCommand();
        if (command != null) {
            if (command instanceof CommandSupportedInterface && !((CommandSupportedInterface)((Object)command)).isSupported(filter)) {
                status |= 0x80;
            }
            if (command instanceof CommandStatusInterface) {
                status |= ((CommandStatusInterface)((Object)command)).getCommandStatus(filter);
            }
        }
        return status;
    }

    protected Object getDynamicValue(String valueName, ActionSupportFilter filter, Object defaultValue) {
        Object returnValue = null;
        DynamicValueInfo valueInfo = (DynamicValueInfo)this.attributeInfos.get(valueName);
        if (valueInfo != null) {
            if (valueInfo.isFilterValue()) {
                String filterAlias = valueInfo.getFilterAlias();
                returnValue = filter.getAttribute(filterAlias != null ? filterAlias : valueName);
            } else {
                try {
                    returnValue = valueInfo.getValueMethod().invoke(valueInfo.getValueObject(), filter.getArgumentObjectArray());
                }
                catch (IllegalAccessException iae) {
                    System.out.println("BaseActionStrategy: getDynamicValue(): IllegalAccessException, this = " + this + ", attribute = " + valueName);
                }
                catch (InvocationTargetException ite) {
                    System.out.println("BaseActionStrategy: getDynamicValue(): InvocationTargetException, this = " + this + ", attribute = " + valueName);
                }
            }
        }
        if (returnValue == null && !this.isNullValid(valueName)) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    private boolean isNullValid(String valueName) {
        DynamicValueInfo valueInfo = (DynamicValueInfo)this.attributeInfos.get(valueName);
        if (valueInfo == null) {
            return false;
        }
        return valueInfo.isNullValid();
    }

    protected void addDynamicValueInfo(String valueName, String methodName, Object methodObject, String filterAlias) {
        this.addDynamicValueInfo(valueName, methodName, methodObject, filterAlias, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDynamicValueInfo(String valueName, String methodName, Object methodObject, String filterAlias, boolean nullValid) {
        try {
            DynamicValueInfo valueInfo = new DynamicValueInfo();
            valueInfo.setValueName(valueName);
            valueInfo.setNullValid(nullValid);
            if (methodName == null) {
                valueInfo.setFilterValue(true);
                valueInfo.setFilterAlias(filterAlias);
            } else {
                valueInfo.setValueObject(methodObject);
                if (methodObject instanceof Class) {
                    valueInfo.setValueMethod(((Class)methodObject).getMethod(methodName, this.getAttributeMethodsArgType()));
                } else {
                    valueInfo.setValueMethod(methodObject.getClass().getMethod(methodName, this.getAttributeMethodsArgType()));
                }
            }
            Map map = this.attributeInfos;
            synchronized (map) {
                this.attributeInfos.put(valueName, valueInfo);
            }
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("BAS: addAttributeMethod(): NoSuchMethodException, method = " + methodName);
        }
    }

    private Map getAttributeInfoObjects() {
        return this.attributeInfos;
    }

    private Class[] getAttributeMethodsArgType() {
        if (this.attributeMethodsArgType == null) {
            this.attributeMethodsArgType = new Class[1];
            this.attributeMethodsArgType[0] = ActionSupportFilter.class;
        }
        return this.attributeMethodsArgType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedTemplateValue(String pattern, ActionSupportFilter filter) {
        SimpleTemplate template;
        String formattedString = null;
        SimpleTemplate simpleTemplate = template = filter.getSimpleTemplate();
        synchronized (simpleTemplate) {
            template.setTemplate(pattern);
            Map valuesDictionary = template.getValueDictionary();
            this.updateValuesDictionary(valuesDictionary, template.getNameDictionary().keySet(), filter);
            formattedString = template.format();
            if (formattedString.equals(INVALID_FORMATTED_VALUE)) {
                formattedString = null;
            }
            valuesDictionary.clear();
        }
        return formattedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValuesDictionary(Map valuesDictionary, Set neededKeys, ActionSupportFilter filter) {
        String[] keys;
        String[] stringArray = keys = neededKeys.toArray(filter.getTemplateKeyArray());
        synchronized (keys) {
            for (String key : keys) {
                if (key != null) {
                    Object value = this.getDynamicValue(key, filter, null);
                    valuesDictionary.put(key, value);
                }
                keys[i] = null;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected Object getCustomAttributeValue(String attributeName, ActionSupportFilter filter) {
        return null;
    }
}

