/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.AreaFilterCache;
import com.sas.codepolicy.SASScope;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class ViewerFilterCache {
    private ActionProviderViewInterface viewer;
    private boolean delay;
    private Map filters;

    public ViewerFilterCache() {
        this(null, false);
    }

    public ViewerFilterCache(ActionProviderViewInterface viewer, boolean delay) {
        this.setViewer(viewer);
        this.setDelay(delay);
        this.filters = Collections.synchronizedMap(new HashMap(3));
    }

    public AreaFilterCache getAreaFilterCache(String areaType) {
        AreaFilterCache areaCache = (AreaFilterCache)((Object)this.filters.get(areaType));
        if (areaCache == null) {
            areaCache = new AreaFilterCache(this.viewer != null ? this.viewer.getActionSupportType() : null, areaType, this.viewer);
            areaCache.setDelay(this.getDelay());
            this.filters.put(areaType, areaCache);
        }
        return areaCache;
    }

    public ActionProviderViewInterface getViewer() {
        return this.viewer;
    }

    public void setViewer(ActionProviderViewInterface viewer) {
        this.viewer = viewer;
    }

    public boolean getDelay() {
        return this.delay;
    }

    public void setDelay(boolean delay) {
        this.delay = delay;
    }
}

