/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionCache;
import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderActionListPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.AreaFilterCache;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.RB;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.entities.AttributeDescriptorInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseActionProvider {
    @SASScope
    protected ContentsChangedListenerList allContentsChangedListeners;
    private static String defaultNamePrefix = "AP";
    private static long nameCount = 0L;
    private String name;
    private Locale locale;
    private Map defaultSupportClassNames = Collections.synchronizedMap(new HashMap());
    private Map allSupportClassNames = Collections.synchronizedMap(new HashMap());
    private Map supportClasses = Collections.synchronizedMap(new HashMap());
    private Map supportClassInstances = Collections.synchronizedMap(new HashMap());
    @SASScope
    protected String actionClassName;
    private Class actionClass;
    private boolean authoritativeOverridesEnabled = false;
    static final String RB_KEY = "BaseActionProvider.";

    @SASScope
    public String getActionClassName() {
        return this.actionClassName;
    }

    @SASScope
    protected void setActionClass(Class actionClass) {
        this.actionClass = actionClass;
    }

    @SASScope
    protected Class getActionClass() {
        return this.actionClass;
    }

    @SASScope
    public ActionCache getActionCache(AreaFilterCache cache) {
        this.validateFilter(cache);
        BaseActionProviderSupport support = this.getSupport(cache.getActionSupportType());
        if (support != null) {
            return support.getActionCache(cache);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), cache.getActionSupportType()));
    }

    public ActionList getActions(ActionSupportFilter filter) {
        this.validateFilter(filter);
        BaseActionProviderSupport support = this.getSupport(filter.getActionSupportType());
        if (support != null) {
            return support.getActions(filter);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), filter.getActionSupportType()));
    }

    public BaseAction getAction(String actionType, ActionSupportFilter filter) {
        this.validateFilter(filter);
        BaseActionProviderSupport support = this.getSupport(filter.getActionSupportType());
        if (support != null) {
            return support.getAction(actionType, filter);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), filter.getActionSupportType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAction(BaseAction action, Collection viewers, Area area) {
        this.validateAction(action, viewers, area);
        Collection collection = viewers;
        synchronized (collection) {
            for (ActionProviderViewInterface viewer : viewers) {
                BaseActionProviderSupport support = this.getSupport(viewer.getActionSupportType());
                if (support != null) {
                    support.setAction(action, viewers, area);
                    continue;
                }
                throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), viewer.getActionSupportType()));
            }
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @SASScope
    public void removeSupportClass(String supportType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (this.allSupportClassNames.remove(supportType) != null) {
            Map defaultSupportClassNames;
            if (this.supportClasses.containsKey(supportType)) {
                this.supportClasses.remove(supportType);
            }
            if (this.supportClassInstances.containsKey(supportType)) {
                this.supportClassInstances.remove(supportType);
            }
            if ((defaultSupportClassNames = this.getDefaultSupportClassNamesMap()).containsKey(supportType)) {
                this.allSupportClassNames.put(supportType, defaultSupportClassNames.get(supportType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected void validateAction(BaseAction action, Collection viewers, Area area) {
        String areaType;
        if (action == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionInvalid.txt"));
        }
        if (action.getActionType() == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionTypeInvalid.txt"));
        }
        if (area != null && (areaType = area.getType()) == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaTypeInvalid.txt"));
        }
        if (viewers == null || viewers.size() <= 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "atLeastOneViewer.txt"));
        }
        Collection collection = viewers;
        synchronized (collection) {
            Iterator iterator = viewers.iterator();
            while (iterator.hasNext()) {
                ActionProviderViewInterface viewer = null;
                Object objViewer = iterator.next();
                if (objViewer == null || !(objViewer instanceof ActionProviderViewInterface)) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "viewerTypeInvalid.txt"));
                }
                viewer = (ActionProviderViewInterface)objViewer;
                String supportType = viewer.getActionSupportType();
                if (supportType == null) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "viewerSupportTypeNotSet.txt"));
                }
                if (!this.allSupportClassNames.containsKey(supportType)) {
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "viewerSupportTypeNotValid.txt"));
                }
                this.getSupportClass(supportType);
            }
        }
    }

    @SASScope
    protected void validateFilter(ActionSupportFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullFilter.txt"));
        }
        String supportType = filter.getActionSupportType();
        if (supportType == null || !this.allSupportClassNames.containsKey(supportType)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidSupportKey.txt"));
        }
    }

    @SASScope
    protected BaseActionProviderSupport getSupport(String supportType) {
        BaseActionProviderSupport supportInstance = (BaseActionProviderSupport)this.supportClassInstances.get(supportType);
        if (supportInstance == null) {
            return this.getSupportInstance(this.getSupportClass(supportType), supportType);
        }
        return supportInstance;
    }

    private BaseActionProviderSupport getSupportInstance(Class supportClass, String supportType) {
        if (supportClass == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportClass.txt"));
        }
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        BaseActionProviderSupport support = null;
        try {
            Class[] parameterTypes = new Class[]{Class.class};
            Constructor constructor = supportClass.getConstructor(parameterTypes);
            Object[] initArgs = new Object[]{this.getActionClass()};
            support = (BaseActionProviderSupport)constructor.newInstance(initArgs);
            support.setActionProvider(this);
            support.setLocale(this.getLocale());
            support.initialize();
            this.supportClassInstances.put(supportType, support);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportNotInstantiable.txt"), supportType, supportClass.getName()));
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportNotAccessible.txt"), supportType, supportClass.getName()));
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassInstantiationError.txt"), supportType, supportClass.getName()));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassConstructorInvalid.txt"), supportType, supportClass.getName()));
        }
        support.setAuthoritativeOverridesEnabled(this.isAuthoritativeOverridesEnabled());
        return support;
    }

    @SASScope
    public ActionList getDefaultActions(String supportType, String areaType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            ActionList actions = support.getDefaultActions(areaType);
            return actions;
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public Collection listDefaultActions(String supportType, String areaType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            Collection actions = support.listDefaultActions(areaType);
            return actions;
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public BaseAction getDefaultAction(String supportType, String areaType, String actionType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            return support.getDefaultAction(areaType, actionType);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public String getName() {
        if (this.name == null) {
            this.name = BaseActionProvider.getDefaultName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static synchronized String getDefaultName() {
        if (++nameCount == Long.MAX_VALUE) {
            nameCount = 0L;
            defaultNamePrefix = defaultNamePrefix + "_";
        }
        return defaultNamePrefix + nameCount;
    }

    public BaseAction newActionInstance(String supportType, String areaType, String actionType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (actionType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            return support.newActionInstance(areaType, actionType);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public Collection listAreaTypes(String supportType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            return support.listAreaTypes();
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public Collection listActionTypes(String supportType, String areaType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            return support.listActionTypes(areaType);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public void setActionOrderList(String supportType, ActionOrderList orderList, ActionProviderViewInterface viewer, String areaType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        if (orderList == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullActionOrderList.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support == null) {
            throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
        }
        support.setActionOrderList(orderList, viewer, areaType);
    }

    public ActionOrderList getActionOrderList(String supportType, ActionProviderViewInterface viewer, String areaType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullAreaType.txt"));
        }
        BaseActionProviderSupport support = this.getSupport(supportType);
        if (support != null) {
            return support.getActionOrderList(viewer, areaType);
        }
        throw new IllegalStateException(MessageFormat.format(RB.getStringResource(RB_KEY, "supportClassNotLoaded.txt"), supportType));
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    @SASScope
    protected Map getDefaultSupportClassNamesMap() {
        return this.defaultSupportClassNames;
    }

    @SASScope
    public Map getSupportClassNamesMap() {
        return new HashMap(this.allSupportClassNames);
    }

    @SASScope
    protected Map getAllSupportClassNamesMap() {
        return this.allSupportClassNames;
    }

    @SASScope
    protected Map getSupportClassesMap() {
        return this.supportClasses;
    }

    @SASScope
    protected Map getSupportClassIntancesMap() {
        return this.supportClassInstances;
    }

    @SASScope
    public void setUpAction(BaseAction action, ActionSupportFilter filter, List attributeDescriptors, boolean listType) {
        action.setActionProvider(this);
        action.setViewer(filter.getViewer());
        if (!action.isActive()) {
            action.setEnabled(false);
            if (action.getValue("ShortDisabledDescription") == null) {
                action.putValue("ShortDisabledDescription", "");
            }
        }
    }

    @SASScope
    public void processAction(BaseAction action, ActionSupportFilter filter, AttributeDescriptorInterface[] attributeDescriptors, boolean listType) {
        action.setActionProvider(this);
        action.setViewer(filter.getViewer());
        if (!action.isActive()) {
            action.setEnabled(false);
            if (action.getValue("ShortDisabledDescription") == null) {
                action.putValue("ShortDisabledDescription", "");
            }
        }
    }

    @SASScope
    public void returnActionList(ActionList actionList) {
        if (actionList == null) {
            return;
        }
        List actions = actionList.getActions();
        int numActions = actions.size();
        for (int i = 0; i < numActions; ++i) {
            Object item = actions.get(i);
            if (item == ActionList.SEPARATOR) continue;
            if (item.getClass() == ActionList.class) {
                this.returnActionList((ActionList)((Object)item));
                continue;
            }
            this.returnAction((BaseAction)item);
        }
        ActionProviderActionListPool.returnActionList(actionList);
    }

    @SASScope
    public void returnAction(BaseAction action) {
    }

    @SASScope
    public ActionList getActionList(boolean fromPoolIfPossible) {
        if (fromPoolIfPossible) {
            return ActionProviderActionListPool.getActionList();
        }
        return new ActionList();
    }

    @SASScope
    public BaseAction getAction(BaseAction action, boolean fromPoolIfPossible) {
        BaseAction returnAction = null;
        try {
            returnAction = (BaseAction)action.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        return returnAction;
    }

    @SASScope
    public void setAuthoritativeOverridesEnabled(boolean authoritativeOverridesEnabled) {
        this.authoritativeOverridesEnabled = authoritativeOverridesEnabled;
    }

    @SASScope
    public boolean isAuthoritativeOverridesEnabled() {
        return this.authoritativeOverridesEnabled;
    }

    @SASScope
    public abstract void addSupportClass(String var1, String var2) throws ClassNotFoundException, InstantiationException, IllegalAccessException;

    @SASScope
    protected abstract Class getSupportClass(String var1);
}

