/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.access;

import com.sas.deployment.agent.jmx.client.api.IAgentMBeanProvider;
import com.sas.deployment.agent.jmx.client.internal.AgentMBeanProvider;
import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.common.model.generated.IBlueprint;
import com.sas.deployment.common.utilities.BlueprintUtilities;
import com.sas.solstice.platform.core.access.IResults;
import com.sas.solstice.platform.core.dao.Results;
import com.sas.solstice.platform.utilities.FileUtilities;
import com.sas.tools.installs.it.schema.validation.ValidationListType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class Control {
    private static final String FAILED_TO_EXECUTE_COMMAND = "Failed to execute command.";
    private static final String FAILED_TO_GET_AGENT_CONTROL = "Unable to connect to agent.";
    private static final String ERROR_UNMARSHALLING_BLUEPRINT = "Failed to unmarshal blueprint from the location \"%s\".";
    private static final String LOCAL_FILE_DOES_NOT_EXIST = "The local file \"%s\" does not exist.";
    private static final String REMOTE_FILE_DOES_NOT_EXIST = "The remote file \"%s\" does not exist.";
    private static final String REMOTE_FOLDER_DOESNT_EXIST = "Remote folder \"%s\" does not exist.";
    private static final String UNABLE_TO_CREATE_LOCAL_FOLDER = "Unable to create the local folder \"%s\".";
    private static final String UNABLE_TO_CREATE_REMOTE_FOLDER = "Unable to create the remote folder \"%s\".";
    private static final long HUNDRED = 100L;
    private static final String COPY_BUFFER_PROPERTY = "COPY_BUFFER";
    private static final int BUFFER_SIZE = Control.getBufferSize();
    private static final String BACKSLASH = "\\";
    private static final String FRONTSLASH = "/";
    private static final Logger LOGGER = (Logger)LogManager.getLogger(Control.class);
    private AgentMBean _agentControl;
    private String _host;
    private String _port;
    private Properties _securityProperties;
    private IAgentMBeanProvider _agentProvider;

    private static IAgentMBeanProvider createAgentProvider() {
        return new AgentMBeanProvider();
    }

    private static int getBufferSize() {
        String defaultValue = "20000";
        String value = System.getProperty(COPY_BUFFER_PROPERTY, defaultValue);
        Integer wrapper = Integer.valueOf(value);
        return wrapper;
    }

    public Control() {
        this(null);
    }

    public Control(String host) {
        this(host, null, Control.createAgentProvider());
    }

    public Control(String host, String port) {
        this(host, port, Control.createAgentProvider());
    }

    Control(String host, String port, IAgentMBeanProvider agentProvider) {
        if (agentProvider == null) {
            throw new IllegalArgumentException("agentProvider must not be null");
        }
        this.setHost(host);
        this.setPort(port);
        if (port != null) {
            System.setProperty("solstice.agent.jmx.port", port);
        }
        this.setAgentProvider(agentProvider);
    }

    private String getLocalSASHome() {
        File parentDirectory;
        File jarPath = null;
        String jarFilePath = null;
        boolean sashomeFound = false;
        try {
            jarFilePath = Control.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            LOGGER.error("Error encountered attempting to find SASHome");
            LOGGER.error(e.getLocalizedMessage());
            return null;
        }
        jarPath = new File(jarFilePath);
        while (!sashomeFound && (parentDirectory = jarPath.getParentFile()) != null) {
            jarPath = parentDirectory;
            if (!new File(jarPath, "SASDeploymentAgent").exists()) continue;
            sashomeFound = true;
        }
        if (sashomeFound) {
            LOGGER.debug("Found sashome at " + jarPath.getAbsolutePath());
            return jarPath.getAbsolutePath();
        }
        return null;
    }

    private boolean ableToCreate(File localFolderFile) {
        return localFolderFile.exists() && localFolderFile.isDirectory() || localFolderFile.mkdirs();
    }

    @Deprecated
    public void changeHost(String host) throws IOException {
        boolean same = this.isSameHost(host);
        if (same) {
            return;
        }
        this.stopAgent();
        this.setHost(host);
    }

    private void checkSourceAndDestinationFilePaths(String sourceFilePath, String destinationFilePath) {
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("sourceFilePath must not be null");
        }
        if (destinationFilePath == null) {
            throw new IllegalArgumentException("destinationFilePath must not be null");
        }
    }

    public boolean connect() {
        try {
            this.startAgent();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private Results copyFile(File sourceFile, String destinationFilePath) {
        return this.copyFile(sourceFile, destinationFilePath, false);
    }

    private Results copyFile(File sourceFile, String destinationFilePath, boolean overwriteReadOnlyDestinationFile) {
        boolean exists = sourceFile.exists();
        if (!exists) {
            String message = String.format(LOCAL_FILE_DOES_NOT_EXIST, sourceFile.getAbsolutePath());
            return this.createErrorResults(message);
        }
        boolean directory = sourceFile.isDirectory();
        if (directory) {
            String message = "This method is for copying files, please use copyFolder instead";
            return this.createErrorResults(message);
        }
        AgentMBean agent = null;
        try {
            agent = this.getAgentControl();
            String destination = destinationFilePath.replace(BACKSLASH, FRONTSLASH);
            if (directory || sourceFile.length() == 0L) {
                return agent.saveFile(new byte[0], destination, true);
            }
            int perms = 0;
            perms = FileUtilities.getPosixFilePermissions((String)sourceFile.getAbsolutePath());
            Results r = this.pullBytes(sourceFile, destination, agent, overwriteReadOnlyDestinationFile);
            if (r.isOk() && perms != 0) {
                agent.setPosixFilePerms(destination, perms);
            }
            return r;
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        catch (Exception e) {
            return this.createErrorResults(e);
        }
    }

    public IResults copyFile(String sourceFilePath, String destinationFilePath) {
        return this.copyFile(sourceFilePath, destinationFilePath, false);
    }

    public IResults copyFile(String sourceFilePath, String destinationFilePath, boolean overwriteReadOnlyDestinationFile) {
        this.checkSourceAndDestinationFilePaths(sourceFilePath, destinationFilePath);
        File sourceFile = new File(sourceFilePath);
        return this.copyFile(sourceFile, destinationFilePath, overwriteReadOnlyDestinationFile);
    }

    private Results copyFilesWithin(File folder, String remotePath, String originalPath) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                Results results = this.copyFolder(file, remotePath, originalPath);
                if (results.getStatus() != 4) continue;
                return results;
            }
            String tempRemotePath = remotePath + file.getAbsolutePath().substring(originalPath.length(), file.getAbsolutePath().length());
            Results results = this.copyFile(file, tempRemotePath);
            if (results.getStatus() != 4) continue;
            return results;
        }
        Results results = new Results();
        results.setStatus(0);
        return results;
    }

    private Results copyFolder(File folder, String remotePath) {
        return this.copyFolder(folder, remotePath, folder.getAbsolutePath());
    }

    private Results copyFolder(File folder, String remotePath, String originalPath) {
        if (folder.isFile()) {
            Results results = new Results();
            String message = "This method is for copying folders, please use copyFile instead";
            results.setMessage(message);
            results.setStatus(4);
            return results;
        }
        String currentFolderRemotePath = remotePath + folder.getAbsolutePath().substring(originalPath.length(), folder.getAbsolutePath().length()) + FRONTSLASH;
        Results folderCreationResults = this.createRemoteDirectory(currentFolderRemotePath);
        if (folderCreationResults.getStatus() == 4) {
            return folderCreationResults;
        }
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
            int perms = 0;
            perms = FileUtilities.getPosixFilePermissions((String)folder.getAbsolutePath());
            Results r = this.copyFilesWithin(folder, remotePath, originalPath);
            if (!r.isOk()) {
                return r;
            }
            if (perms != 0) {
                agentControl.setPosixFilePerms(currentFolderRemotePath, perms);
            }
            return r;
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        catch (Exception e) {
            return this.createErrorResults(e);
        }
    }

    public IResults copyFolder(String sourceFolderPath, String destinationFolderPath) {
        if (sourceFolderPath == null) {
            throw new IllegalArgumentException("folder must not be null");
        }
        if (destinationFolderPath == null) {
            throw new IllegalArgumentException("remotePath must not be null");
        }
        return this.copyFolder(new File(sourceFolderPath), destinationFolderPath);
    }

    private Results createErrorResults(Exception exception) {
        String message = exception.getMessage();
        return this.createErrorResults(message, exception);
    }

    private Results createErrorResults(String message) {
        Results results = new Results();
        results.setMessage(message);
        results.setStatus(4);
        return results;
    }

    private Results createErrorResults(String message, Exception exception) {
        Results results = new Results();
        results.setMessage(message);
        results.setException(exception);
        results.setStatus(4);
        return results;
    }

    private Results createPulledFile(String remoteFolder, String localFolder, String childFolder) {
        String newPath = this.getNewPath(localFolder, remoteFolder, childFolder);
        Results results = (Results)this.pullFile(childFolder, newPath);
        return results;
    }

    private Results createRemoteDirectory(String dirPath) {
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        String remoteDir = dirPath.replace(BACKSLASH, FRONTSLASH);
        boolean status = agentControl.createDirectory(remoteDir);
        if (!status) {
            String message = String.format(UNABLE_TO_CREATE_REMOTE_FOLDER, remoteDir);
            return this.createErrorResults(message);
        }
        Results results = new Results();
        results.setStatus(0);
        return results;
    }

    private Results createResultsForErrorUnmarshallingBlueprint(String uri, Exception exception) {
        String message = String.format(ERROR_UNMARSHALLING_BLUEPRINT, uri);
        return this.createErrorResults(message, exception);
    }

    public boolean disconnect() {
        return this.stopAgent();
    }

    public IResults doExec(String[] args) {
        AgentMBean agentControl;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        try {
            return agentControl.doExec(args);
        }
        catch (Exception exception) {
            return this.createErrorResults(FAILED_TO_EXECUTE_COMMAND, exception);
        }
    }

    public IResults doExec(String[] args, int timeOut) {
        AgentMBean agentControl;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        try {
            return agentControl.doExec(args, timeOut);
        }
        catch (Exception exception) {
            return this.createErrorResults(FAILED_TO_EXECUTE_COMMAND, exception);
        }
    }

    public IResults doExecAsUser(String encryptedUserName, String encryptedPassword, String domain, String[] args) {
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        return agentControl.doExecAsUser(encryptedUserName, encryptedPassword, domain, args);
    }

    public IResults doExecAsUser(String encryptedUserName, String encryptedPassword, String domain, String[] args, int timeOut) {
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        return agentControl.doExecAsUser(encryptedUserName, encryptedPassword, domain, args, timeOut);
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentMBean getAgentControl() throws IOException {
        Control control = this;
        synchronized (control) {
            if (this._agentControl == null) {
                this.startAgent();
            }
            return this._agentControl;
        }
    }

    private IAgentMBeanProvider getAgentProvider() {
        return this._agentProvider;
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        if (this._port != null) {
            return this._port;
        }
        return System.getProperty("solstice.agent.jmx.port", "5660");
    }

    private String getNewPath(String localFolderBase, String remotePathBase, String remotePath) {
        int remotePathBaseLength = remotePathBase.length();
        int remotePathLength = remotePath.length();
        CharSequence path = remotePath.subSequence(remotePathBaseLength, remotePathLength);
        return String.format("%s%s", localFolderBase, path);
    }

    Properties getSecurityProperties() {
        return this._securityProperties;
    }

    public IResults installBlueprint(String blueprintURI, String metadataRoot, String artifactRoot) {
        if (blueprintURI == null) {
            throw new IllegalArgumentException("blueprintURI must not be null");
        }
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        return this.installBlueprint(blueprintURI, metadataRoot, artifactRoot, agentControl);
    }

    private Results installBlueprint(String blueprintURI, String metadataRoot, String artifactRoot, AgentMBean agentControl) {
        IBlueprint blueprint = null;
        try {
            blueprint = BlueprintUtilities.getBlueprintFromURIString((String)blueprintURI);
        }
        catch (MalformedURLException e) {
            return this.createResultsForErrorUnmarshallingBlueprint(blueprintURI, e);
        }
        catch (JAXBException e) {
            return this.createResultsForErrorUnmarshallingBlueprint(blueprintURI, (Exception)((Object)e));
        }
        catch (URISyntaxException e) {
            return this.createResultsForErrorUnmarshallingBlueprint(blueprintURI, e);
        }
        return agentControl.install(blueprint, metadataRoot, artifactRoot, false);
    }

    public boolean isHostAvailable() {
        IAgentMBeanProvider provider = this.getAgentProvider();
        String host = this.getHost();
        Properties properties = this.getSecurityProperties();
        return provider.isAgentAvailable(host, properties);
    }

    private boolean isSameHost(String host) {
        String currentHost = this.getHost();
        if (host == null) {
            return currentHost == null;
        }
        return host.equalsIgnoreCase(currentHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Results pullBytes(File sourceFile, String destinationFile, AgentMBean agent, boolean overwriteReadOnlyDestinationFile) {
        Results results = new Results();
        results.setStatus(0);
        BufferedInputStream in = null;
        long totalSize = sourceFile.length();
        long totalCopied = 0L;
        byte[] out = new byte[]{};
        try {
            in = new BufferedInputStream(new FileInputStream(sourceFile));
            try {
                int bufLen = BUFFER_SIZE * 1024;
                byte[] buf = new byte[bufLen];
                int len = 0;
                boolean deleteExisting = true;
                while ((len = ((InputStream)in).read(buf, 0, bufLen)) != -1) {
                    byte[] tmp = new byte[out.length + len];
                    System.arraycopy(buf, 0, tmp, 0, len);
                    results = agent.saveFile(tmp, destinationFile, deleteExisting, overwriteReadOnlyDestinationFile);
                    if (results.getStatus() != 0) {
                        LOGGER.error("Error encountered, retrying");
                        results = agent.saveFile(tmp, destinationFile, deleteExisting, overwriteReadOnlyDestinationFile);
                    }
                    if (results.getStatus() != 0) {
                        Results results2 = results;
                        return results2;
                    }
                    deleteExisting = false;
                    long percentDone = (totalCopied += (long)len) * 100L / totalSize;
                    String message = String.format("%s: %d%% done", destinationFile, percentDone);
                    LOGGER.info(message);
                }
                return results;
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException exception) {
            return this.createErrorResults(exception);
        }
    }

    public IResults pullFile(String sourceFilePath, String destinationFilePath) {
        return this.pullFile(sourceFilePath, destinationFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResults pullPicklistJars(String picklist, String localSASHome) {
        String remoteSASHome;
        Results results = new Results();
        results.setStatus(0);
        AgentMBean agentControl = null;
        Map iqMap = null;
        try {
            agentControl = this.getAgentControl();
            iqMap = agentControl.getInstallQualInfo();
            remoteSASHome = agentControl.getSASHome();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        String vjr = localSASHome + "/SASVersionedJarRepository/eclipse/plugins/";
        BufferedReader br = null;
        ArrayList<String> jarFolders = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(picklist));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("name")) continue;
                String pluginName = line.substring(line.indexOf("=") + 1);
                line = br.readLine();
                String version = line.substring(line.indexOf("=") + 1);
                String folderName = (String)pluginName + "_" + version;
                jarFolders.add(folderName);
            }
        }
        catch (IOException e) {
            Results pluginName = this.createErrorResults(FAILED_TO_EXECUTE_COMMAND, e);
            return pluginName;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    return this.createErrorResults("Failed to close picklist file", e);
                }
            }
        }
        HashSet linesToAdd = new HashSet();
        for (String folder : jarFolders) {
            String localFolder = vjr + folder;
            String remoteFolder = localFolder.replace(localSASHome, remoteSASHome);
            File localFolderFile = new File(localFolder);
            if (localFolderFile.exists()) continue;
            IResults r = this.pullFolder(remoteFolder, localFolder);
            if (!r.isOk() && !r.getMessage().contains("not exist")) {
                return r;
            }
            if (!r.isOk() && r.getMessage().contains("not exist")) {
                localFolder = localFolder + ".jar";
                folder = folder + ".jar";
                remoteFolder = remoteFolder + ".jar";
                localFolderFile = new File(localFolder);
                if (!(localFolderFile.exists() || (r = this.pullFile(remoteFolder, localFolder)).isOk() || r.getMessage().contains("not exist"))) {
                    return r;
                }
            }
            if (iqMap.get(folder) == null) continue;
            linesToAdd.addAll((Collection)iqMap.get(folder));
        }
        try {
            String iqInfo = localSASHome + "/InstallMisc/InstallLogs/ValidationFileList.xml";
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ValidationListType.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement installJax = jaxbUnmarshaller.unmarshal((Source)new StreamSource(iqInfo), ValidationListType.class);
            ValidationListType iqList = null;
            iqList = (ValidationListType)installJax.getValue();
            iqList.getSasfile().addAll(linesToAdd);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)iqList, (OutputStream)new FileOutputStream(iqInfo));
        }
        catch (JAXBException e) {
            results.setException((Exception)((Object)e));
            return results;
        }
        catch (FileNotFoundException e) {
            results.setException((Exception)e);
            return results;
        }
        String javaBin = localSASHome + "/SASPrivateJavaRuntimeEnvironment/9.4/jre/bin/java";
        String sasLauncherJar = vjr + "sas.launcher.jar";
        String[] command = new String[]{javaBin, "-cp", sasLauncherJar, "com.sas.app.NonAPI", "-install"};
        results = FileUtilities.doExec((String[])command, (int)180);
        return results;
    }

    private Results pullFile(String sourceFilePath, String destinationFilePath, AgentMBean agent, boolean overwriteReadOnlyDestinationFile) {
        byte[] bytes;
        String source = sourceFilePath.replace(BACKSLASH, FRONTSLASH);
        int perms = 0;
        try {
            perms = agent.getPosixFilePerms(source);
            bytes = agent.pullFile(source, 0L);
            if (bytes == null) {
                String message = String.format(REMOTE_FILE_DOES_NOT_EXIST, source);
                return this.createErrorResults(message);
            }
        }
        catch (IOException exception) {
            String message = exception.getMessage();
            return this.createErrorResults(message, exception);
        }
        catch (Exception e) {
            return this.createErrorResults(e);
        }
        String destination = destinationFilePath.replace(BACKSLASH, FRONTSLASH);
        Results r = this.saveFileBytesFromAgent(bytes, agent, destination, source, true, overwriteReadOnlyDestinationFile);
        if (!r.isOk()) {
            return r;
        }
        if (perms != 0) {
            try {
                FileUtilities.setPosixFilePermissions((String)destination, (int)perms);
            }
            catch (Exception e) {
                return this.createErrorResults(e);
            }
        }
        Results result = new Results();
        result.setStatus(0);
        return result;
    }

    public IResults pullFile(String sourceFilePath, String destinationFilePath, boolean overwriteReadOnlyDestinationFile) {
        this.checkSourceAndDestinationFilePaths(sourceFilePath, destinationFilePath);
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        return this.pullFile(sourceFilePath, destinationFilePath, agentControl, overwriteReadOnlyDestinationFile);
    }

    public IResults pullFolder(String sourceFolderPath, String destinationFolderPath) {
        return this.pullFolder(sourceFolderPath, destinationFolderPath, true, null);
    }

    public IResults pullFolder(String sourceFolderPath, String destinationFolderPath, List<String> extensionsToIgnore) {
        return this.pullFolder(sourceFolderPath, destinationFolderPath, true, extensionsToIgnore);
    }

    private Results pullFolder(String remoteFolder, String localFolder, boolean recursive, List<String> extensionsToIgnore) {
        if (remoteFolder == null) {
            throw new IllegalArgumentException("remoteFolder must not be null");
        }
        if (localFolder == null) {
            throw new IllegalArgumentException("localFolder must not be null");
        }
        AgentMBean agentControl = null;
        try {
            agentControl = this.getAgentControl();
        }
        catch (IOException exception) {
            return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
        }
        List children = agentControl.pullFolderList(remoteFolder, recursive, extensionsToIgnore);
        if (children == null) {
            String message = String.format(REMOTE_FOLDER_DOESNT_EXIST, remoteFolder);
            return this.createErrorResults(message);
        }
        return this.pullFoldersChildren(remoteFolder, localFolder, children);
    }

    private Results pullFoldersChildren(String remoteFolder, String localFolder, List<String> children) {
        Results results = new Results();
        HashMap<String, Integer> permsToChange = new HashMap<String, Integer>();
        Iterator<String> iterator = children.iterator();
        while (results.isOk() && iterator.hasNext()) {
            String child = iterator.next();
            if (child.endsWith(FRONTSLASH)) {
                String slashRemoved = child.substring(0, child.length() - 1);
                String newPath = this.getNewPath(localFolder, remoteFolder, slashRemoved);
                String newPathSlashesReplaced = newPath.replace(BACKSLASH, FRONTSLASH);
                File localFolderFile = new File(newPathSlashesReplaced);
                AgentMBean agentControl = null;
                try {
                    agentControl = this.getAgentControl();
                    int perms = agentControl.getPosixFilePerms(slashRemoved);
                    boolean ableToCreate = this.ableToCreate(localFolderFile);
                    if (!ableToCreate) {
                        String message = String.format(UNABLE_TO_CREATE_LOCAL_FOLDER, localFolder);
                        return this.createErrorResults(message);
                    }
                    if (perms == 0) continue;
                    permsToChange.put(newPathSlashesReplaced, perms);
                    continue;
                }
                catch (IOException exception) {
                    return this.createErrorResults(FAILED_TO_GET_AGENT_CONTROL, exception);
                }
                catch (Exception e) {
                    return this.createErrorResults(e);
                }
            }
            results = this.createPulledFile(remoteFolder, localFolder, child);
        }
        for (String path : permsToChange.keySet()) {
            int perms = (Integer)permsToChange.get(path);
            try {
                FileUtilities.setPosixFilePermissions((String)path, (int)perms);
            }
            catch (Exception e) {
                return this.createErrorResults(e);
            }
        }
        return results;
    }

    public IResults pullFolderFiles(String sourceFolderPath, String destinationFolderPath) {
        return this.pullFolder(sourceFolderPath, destinationFolderPath, false, null);
    }

    public IResults pullFolderFiles(String sourceFolderPath, String destinationFolderPath, List<String> extensionsToIgnore) {
        return this.pullFolder(sourceFolderPath, destinationFolderPath, false, extensionsToIgnore);
    }

    public List<String> pullFolderList(String folderPath, boolean recursive) throws IOException {
        AgentMBean agentControl = this.getAgentControl();
        return agentControl.pullFolderList(folderPath, recursive, null);
    }

    private Results saveFileBytesFromAgent(byte[] startBytes, AgentMBean agent, String destinationFilePath, String sourceFilePath, boolean deleteExisting, boolean overwriteReadOnlyDestinationFile) {
        boolean done = false;
        byte[] bytes = startBytes;
        long offset = 0L;
        Results results = null;
        results = FileUtilities.saveFile((byte[])bytes, (String)destinationFilePath, (boolean)deleteExisting, (boolean)overwriteReadOnlyDestinationFile);
        while (!done) {
            if (bytes.length == 0 || !results.isOk()) {
                done = true;
            } else {
                offset += (long)bytes.length;
                try {
                    bytes = agent.pullFile(sourceFilePath, offset);
                }
                catch (IOException e) {
                    results = this.createErrorResults(e.getMessage(), e);
                    done = true;
                }
            }
            results = FileUtilities.saveFile((byte[])bytes, (String)destinationFilePath, (boolean)false, (boolean)false);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAgentControl(AgentMBean agentControl) {
        Control control = this;
        synchronized (control) {
            this._agentControl = agentControl;
        }
    }

    private void setAgentProvider(IAgentMBeanProvider agentProvider) {
        this._agentProvider = agentProvider;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        String port;
        if (this.getPort() == null && (port = connectionProperties.getProperty("solstice.agent.jmx.port")) != null) {
            System.setProperty("solstice.agent.jmx.port", port);
        }
        this._securityProperties = connectionProperties;
    }

    private void setHost(String host) {
        this._host = host;
    }

    private void setPort(String port) {
        this._port = port;
    }

    @Deprecated
    public void setSecurityProperties(Properties securityProperties) {
        this._securityProperties = securityProperties;
    }

    private void startAgent() throws IOException {
        IAgentMBeanProvider provider = this.getAgentProvider();
        String host = this.getHost();
        Properties properties = this.getSecurityProperties();
        AgentMBean agent = provider.startAgent(host, properties);
        this.setAgentControl(agent);
    }

    private boolean stopAgent() {
        String host;
        IAgentMBeanProvider provider = this.getAgentProvider();
        boolean stopped = provider.stopAgent(host = this.getHost());
        if (!stopped) {
            return false;
        }
        this.setAgentControl(null);
        return true;
    }

    public String getSASHome() throws IOException {
        AgentMBean agentControl = this.getAgentControl();
        return agentControl.getSASHome();
    }
}

