/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.sparkline;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.Graph;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.sparkline.SparklineCell;
import com.sas.graphics.util.cell.sparkline.SparklineCellModel;
import com.sas.graphics.util.cell.sparkline.SparklineMatrixContainer;
import com.sas.graphics.util.cell.sparkline.SparklineMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class SparklineMatrix
extends Matrix {
    private SparklineMatrixContainer matrixContainer;
    private transient ArrayList cells;
    private SparklineCellModel sparklineCellModel;
    private transient SparklineMatrixModel model;

    public SparklineMatrix(Channel channel) {
        this(null, channel);
    }

    public SparklineMatrix(SparklineMatrixModel model, Channel channel) {
        super(channel);
        this._setModel(model);
    }

    public void setModel(SparklineMatrixModel newModel) {
        this._setModel(newModel);
    }

    public SparklineMatrixModel getModel() {
        return this.model;
    }

    private void _setModel(SparklineMatrixModel newModel) {
        if (this.model != newModel) {
            this.model = newModel;
            this.reconstruct();
        }
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        this.cells = null;
    }

    @Override
    protected synchronized void construct() {
        DataSource dataSource;
        SparklineMatrixModel matrixModel = this.getModel();
        if (matrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        if (matrixModel.getGraphModel() != null) {
            this.setAntialiasedTextEnabled(matrixModel.getGraphModel().isAntialiasedText());
        }
        if ((dataSource = this.getDataSource()) == null) {
            return;
        }
        Variable responseVariable = dataSource.getVariable(matrixModel.getResponseRole(), 0);
        if (responseVariable == null) {
            throw new IllegalStateException(RB.getStringResource("responseVariableNotSpecified.ex.txt"));
        }
        if (responseVariable.getValueCount() < 1) {
            return;
        }
        this.sparklineCellModel = new SparklineCellModel();
        this.sparklineCellModel.setResponseRole(matrixModel.getResponseRole());
        this.sparklineCellModel.setGraphModel(matrixModel.getGraphModel());
        this.sparklineCellModel.setAntialiasedGraphics(new Boolean(matrixModel.getGraphModel().isAntialiasedGraphics()));
        this.sparklineCellModel.setAntialiasedText(new Boolean(matrixModel.getGraphModel().isAntialiasedText()));
        this.cells = this.addMatrixCellComponents(this.sparklineCellModel, new DataSource[]{dataSource});
    }

    @Override
    protected List getCells() {
        return this.cells;
    }

    public ChartImageMapInfo2[] getImageMapInfo() {
        return null;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    protected ArrayList addMatrixCellComponents(SimpleModelInterface cellModel, DataSource[] dataSource) {
        Container parent;
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        ArrayList<Component> cells = new ArrayList<Component>();
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        SparklineMatrixModel sparklineMatrixModel = (SparklineMatrixModel)this.getMatrixModel();
        this.matrixContainer = new SparklineMatrixContainer(sparklineMatrixModel, dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), new SparklineCellComponentFactory(this.sparklineCellModel, dataSource[0]), actionProvider, false, this.graphModel.isAntialiasedGraphics(), this.graphModel.isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    private class SparklineCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final DataSource dataSource;
        private final SparklineCellModel cellModel;

        public SparklineCellComponentFactory(SparklineCellModel cellModel, DataSource dataSource) {
            if (cellModel == null) {
                throw new IllegalStateException("null SparklineCellModel not supported.");
            }
            this.cellModel = cellModel;
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            this.dataSource = dataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode));
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                return new SparklineCell(this.cellModel, cellDataSource, columnNode, rowNode, SparklineMatrix.this.getChannel());
            }
            return null;
        }
    }
}

