/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.scatterplot;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DiscreteStyle;
import com.sas.graphics.components.DiscreteStyleMapModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.ValueZone;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.riskmapplot.AbstractRiskMap;
import com.sas.graphics.components.riskmapplot.RiskMapPlotModel;
import com.sas.graphics.components.util.scatterplot.ScatterPlotModel;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.cell.AxisCell;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.CellModel;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.CustomMarker;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.DrilldownMarker;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalLegendCell;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixContainer;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.PlotImageMapInfo2;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.scatterplot.BIPMarkerSkinFactory;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotCell;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotCellModel;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrixContainer;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.Mapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.PipedVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.measures.BaseLength;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ScatterPlotMatrix
extends Matrix {
    public static final int COLOR = 0;
    public static final int SHAPE = 1;
    public static final int COLOR_SHAPE = 2;
    public static final String RB_KEY = "ScatterPlotMatrix.";
    private static final int MARKER_COLOR = 0;
    private static final int MARKER_STYLE = 1;
    private static final int MARKER_SIZE = 2;
    private static final int LINE_COLOR = 3;
    private static final int LINE_WIDTH = 5;
    private static final int LINE_STYLE = 4;
    private static final int FILL_COLOR = 6;
    private transient Insets outerMargin;
    private transient Dimension innerMargin;
    private transient ArrayList xCells;
    private transient ArrayList yCells;
    private transient ArrayList y2Cells;
    private transient ArrayList plotCells;
    private transient LegendCell colorLegend;
    private transient LegendCell shapeLegend;
    private transient boolean comboLegend = true;
    private transient DrilldownMarker drillMarker;
    private transient ScatterPlotCellModel scatterPlotCellModel;
    private transient ValueTree groupValueTree;
    private ScatterPlotMatrixContainer matrixContainer;
    private transient ScatterPlotMatrixModel model;
    boolean greaterThanOne = false;
    boolean lessThanOne = false;
    Dimension oldSize = null;

    public ScatterPlotMatrix(Channel channel) {
        this(null, channel);
    }

    public ScatterPlotMatrix(ScatterPlotMatrixModel newModel, Channel channel) {
        super(channel);
        this.setModel(newModel);
        this.drillMarker = new DrilldownMarker();
    }

    @Override
    public void selectionChanged(ListSelectionEvent e) {
        this.selectionChanged();
        super.selectionChanged(e);
    }

    public void setModel(ScatterPlotMatrixModel newModel) {
        if (this.model != newModel) {
            this.model = newModel;
            this.reconstruct();
        }
    }

    private void addAxisImageMapInfo(List imageMapInfoList) {
        this.addAxisImageMapInfo(imageMapInfoList, this.dataSource.getVariable(this.model.getXRole(), 0), this.xCells == null ? 0 : this.xCells.size(), this.xCells, 2);
        this.addAxisImageMapInfo(imageMapInfoList, this.dataSource.getVariable(this.model.getYRole(), 0), this.yCells == null ? 0 : this.yCells.size(), this.yCells, 3);
        this.addAxisImageMapInfo(imageMapInfoList, this.dataSource.getVariable(this.model.getY2Role(), 0), this.y2Cells == null ? 0 : this.y2Cells.size(), this.y2Cells, 4);
    }

    private void addAxisImageMapInfo(List imageMapInfoList, Variable variable, int size, ArrayList cells, int roleIndex) {
        for (int ii = 0; ii < size; ++ii) {
            AxisCell cell = (AxisCell)cells.get(ii);
            if (cell == null) continue;
            Util.LabelAndValueZones labelAndValueZones = cell.getLabelAndValueZones();
            PlotValueZone[] valueZones = variable instanceof StringVariable ? this._createPlotValueZones(labelAndValueZones.getValueZones(), roleIndex) : null;
            LabelZoneList labelZoneList = labelAndValueZones.getLabelZone();
            if (valueZones == null || valueZones.length <= 0) continue;
            PlotImageMapInfo2 info = this._createPlotImageMapInfos(valueZones, labelZoneList, roleIndex);
            info.source = cell;
            imageMapInfoList.add(info);
        }
    }

    private void addLegendImageMapInfo(List imageMapInfoList) {
        PlotImageMapInfo2 info;
        LabelZoneList legendLabelZoneList;
        PlotValueZone[] legendValueZones;
        Util.LabelAndValueZones labelAndValueZones;
        if (this.colorLegend != null) {
            if (this.colorLegend instanceof HierarchicalLegendCell) {
                imageMapInfoList.add(((HierarchicalLegendCell)this.colorLegend).getPlotImageMapInfo());
            } else {
                labelAndValueZones = this.colorLegend.getLabelAndValueZones();
                legendValueZones = this._createPlotValueZones(labelAndValueZones.getValueZones(), 6);
                legendLabelZoneList = legendValueZones == null ? null : labelAndValueZones.getLabelZone();
                info = this._createPlotImageMapInfos(legendValueZones, legendLabelZoneList, 6);
                info.source = this.colorLegend;
                imageMapInfoList.add(info);
            }
        }
        if (this.shapeLegend != null && this.shapeLegend != this.colorLegend) {
            if (this.shapeLegend instanceof HierarchicalLegendCell) {
                imageMapInfoList.add(((HierarchicalLegendCell)this.shapeLegend).getPlotImageMapInfo());
            } else {
                labelAndValueZones = this.shapeLegend.getLabelAndValueZones();
                legendValueZones = this._createPlotValueZones(labelAndValueZones.getValueZones(), 6);
                legendLabelZoneList = legendValueZones == null ? null : labelAndValueZones.getLabelZone();
                info = this._createPlotImageMapInfos(legendValueZones, legendLabelZoneList, 6);
                info.source = this.shapeLegend;
                imageMapInfoList.add(info);
            }
        }
    }

    public boolean isZoomedRowScrollBar() {
        boolean zoomed = false;
        if (this.matrixContainer != null) {
            zoomed = this.matrixContainer.getRowScrollModelProjection().isZoomed();
        }
        return zoomed;
    }

    public boolean isZoomedColumnScrollBar() {
        boolean zoomed = false;
        if (this.matrixContainer != null) {
            zoomed = this.matrixContainer.getColumnScrollModelProjection().isZoomed();
        }
        return zoomed;
    }

    public ZoomScrollBar getRowScrollBar() {
        ZoomScrollBar zsb = null;
        if (this.matrixContainer != null) {
            zsb = this.matrixContainer.getRowScrollBar();
        }
        return zsb;
    }

    public ZoomScrollBar getColumnScrollBar() {
        ZoomScrollBar zsb = null;
        if (this.matrixContainer != null) {
            zsb = this.matrixContainer.getColumnScrollBar();
        }
        return zsb;
    }

    private void addMatrixAxesImageMapInfo(List imageMapInfoList) {
        if (this.matrixContainer != null) {
            imageMapInfoList.add(this.matrixContainer.getImageMapInfo());
        }
    }

    private void addVariableListImageMapInfo(List imageMapInfoList) {
        VariableList columnVariableList = Util.newVariablelist(this.dataSource, this.model.getColumnRole());
        VariableList rowVariableList = Util.newVariablelist(this.dataSource, this.model.getRowRole());
        VariableList xVariableList = Util.newVariablelist(this.dataSource, this.model.getXRole());
        VariableList yVariableList = Util.newVariablelist(this.dataSource, this.model.getYRole());
        VariableList y2VariableList = Util.newVariablelist(this.dataSource, this.model.getY2Role());
        VariableList groupVariableList = Util.newVariablelist(this.dataSource, this.model.getGroupRole());
        VariableList sizeVariableList = Util.newVariablelist(this.dataSource, this.model.getSizeRole());
        VariableList dataTipVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getDataTipRole());
        VariableList auxiliaryVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getAuxiliaryRole());
        imageMapInfoList.add(new PlotImageMapInfo2(columnVariableList, rowVariableList, xVariableList, yVariableList, y2VariableList, sizeVariableList, groupVariableList, dataTipVariableList, auxiliaryVariableList));
    }

    public PlotImageMapInfo2[] getImageMapInfo() {
        PlotImageMapInfo2[] scatterPlotImageMapInfos = null;
        if (this.dataSource != null && this.model != null && this.plotCells != null) {
            int cellCount;
            int jj;
            Variable[] columnVariables = this.dataSource.getVariable(this.model.getColumnRole());
            Variable[] rowVariables = this.dataSource.getVariable(this.model.getRowRole());
            LabelZoneList columnLabelZoneList = null;
            LabelZoneList rowLabelZoneList = null;
            if (columnVariables != null) {
                for (jj = columnVariables.length - 1; jj >= 0; --jj) {
                    columnLabelZoneList = new LabelZoneList(null, columnVariables[jj].getName(), columnVariables[jj].getLabel(), columnLabelZoneList);
                }
            }
            if (rowVariables != null) {
                for (jj = rowVariables.length - 1; jj >= 0; --jj) {
                    rowLabelZoneList = new LabelZoneList(null, rowVariables[jj].getName(), rowVariables[jj].getLabel(), rowLabelZoneList);
                }
            }
            if ((cellCount = this.plotCells.size()) > 0) {
                ArrayList imageMapInfoList = new ArrayList();
                this.addVariableListImageMapInfo(imageMapInfoList);
                Util.addCellImageMapInfo(this.plotCells, imageMapInfoList);
                this.addAxisImageMapInfo(imageMapInfoList);
                this.addLegendImageMapInfo(imageMapInfoList);
                this.addMatrixAxesImageMapInfo(imageMapInfoList);
                scatterPlotImageMapInfos = imageMapInfoList.toArray(new PlotImageMapInfo2[imageMapInfoList.size()]);
            }
        }
        return scatterPlotImageMapInfos;
    }

    private PlotValueZone[] _createPlotValueZones(ValueZone[] inValueZones, int index) {
        if (inValueZones == null) {
            return null;
        }
        PlotValueZone[] valueZones = new PlotValueZone[inValueZones.length];
        ValueList[] valueList = new ValueList[7];
        for (int kk = 0; kk < inValueZones.length; ++kk) {
            valueList[index] = inValueZones[kk].getValue();
            valueZones[kk] = new PlotValueZone(inValueZones[kk].getShape(), valueList[0], valueList[1], valueList[2], valueList[3], valueList[4], valueList[5], valueList[6]);
        }
        return valueZones;
    }

    private PlotImageMapInfo2 _createPlotImageMapInfos(PlotValueZone[] aValueZones, LabelZoneList aLabelZoneList, int index) {
        PlotValueZone[][] valueZoneList = new PlotValueZone[7][];
        LabelZoneList[] labelZoneList = new LabelZoneList[7];
        valueZoneList[index] = aValueZones;
        labelZoneList[index] = aLabelZoneList;
        return new PlotImageMapInfo2(valueZoneList[0], valueZoneList[1], valueZoneList[2], valueZoneList[3], valueZoneList[4], valueZoneList[5], valueZoneList[6], null, labelZoneList[0], labelZoneList[1], labelZoneList[2], labelZoneList[3], labelZoneList[4], labelZoneList[5], labelZoneList[6]);
    }

    @Override
    protected List getCells() {
        return this.plotCells;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    public ScatterPlotMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        this.plotCells = null;
        this.xCells = null;
        this.yCells = null;
        this.y2Cells = null;
        this.colorLegend = null;
        this.shapeLegend = null;
    }

    @Override
    protected synchronized void construct() {
        Object[] axisCells;
        boolean displayMissing;
        LineStyle frame;
        StringToNumericMapper xAxisMapper;
        double xAxisOrigin;
        boolean y2Invalid;
        boolean yInvalid;
        boolean xInvalid;
        DataSource dataSource;
        this.updateChannel();
        ScatterPlotMatrixModel chartMatrixModel = this.getModel();
        if (chartMatrixModel == null) {
            return;
        }
        if (chartMatrixModel.getGraphModel() != null) {
            this.setAntialiasedTextEnabled(chartMatrixModel.getGraphModel().isAntialiasedText());
        }
        if ((dataSource = this.getDataSource()) == null) {
            return;
        }
        Object xRole = chartMatrixModel.getXRole();
        Variable[] xList = dataSource.getVariable(xRole);
        if (xList == null) {
            return;
        }
        NumericVariable[] xLowList = dataSource.getLowVariable(xRole);
        NumericVariable[] xHighList = dataSource.getHighVariable(xRole);
        String localizedRole = com.sas.graphics.components.RB.getStringResource("Graph.", "xRole.txt");
        this.checkLowHighVariables(xList, (Variable[])xLowList, (Variable[])xHighList, localizedRole, dataSource);
        xList = ScatterPlotMatrix.checkVariableList(xList);
        Object yRole = chartMatrixModel.getYRole();
        Object y2Role = chartMatrixModel.getY2Role();
        Variable[] yList = dataSource.getVariable(yRole);
        Variable[] y2List = dataSource.getVariable(y2Role);
        if (yList == null && y2List == null) {
            return;
        }
        NumericVariable[] yLowList = dataSource.getLowVariable(yRole);
        NumericVariable[] yHighList = dataSource.getHighVariable(yRole);
        String localizedRole2 = com.sas.graphics.components.RB.getStringResource("Graph.", "yRole.txt");
        this.checkLowHighVariables(yList, (Variable[])yLowList, (Variable[])yHighList, localizedRole2, dataSource);
        yList = ScatterPlotMatrix.checkVariableList(yList);
        NumericVariable[] y2LowList = dataSource.getLowVariable(y2Role);
        NumericVariable[] y2HighList = dataSource.getHighVariable(y2Role);
        localizedRole2 = com.sas.graphics.components.RB.getStringResource("Graph.", "y2Role.txt");
        this.checkLowHighVariables(y2List, (Variable[])y2LowList, (Variable[])y2HighList, localizedRole2, dataSource);
        y2List = ScatterPlotMatrix.checkVariableList(y2List);
        Variable[] rowList = dataSource.getVariable(chartMatrixModel.getRowRole());
        Variable[] columnList = dataSource.getVariable(chartMatrixModel.getColumnRole());
        Boolean adjustAxisForZoomScrollBar = new Boolean(!this.getFitToScreen());
        if (this.getFitToScreen()) {
            chartMatrixModel.setDisplayPolicy(new Integer(10000));
        } else {
            chartMatrixModel.setDisplayPolicy(new Integer(10002));
        }
        Graphics gc = this.getGraphics();
        this.scatterPlotCellModel = new ScatterPlotCellModel();
        this.scatterPlotCellModel.setScatterPlotMatrixModel(chartMatrixModel);
        GraphModel graphModel = chartMatrixModel.getGraphModel();
        ScatterPlotModel scatterPlotModel = chartMatrixModel.getScatterPlotModel();
        Boolean antialiasedGraphics = graphModel.isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
        Boolean antialiasedText = graphModel.isAntialiasedText() ? Boolean.TRUE : Boolean.FALSE;
        this.scatterPlotCellModel.setAntialiasedGraphics(antialiasedGraphics);
        this.scatterPlotCellModel.setAntialiasedText(antialiasedText);
        this.scatterPlotCellModel.setRuleTargetIdentifier(chartMatrixModel.getRuleTargetIdentifier());
        chartMatrixModel.setRowModel(scatterPlotModel.getRowAxisModel());
        chartMatrixModel.setColumnModel(scatterPlotModel.getColumnAxisModel());
        DataElementStyles des = graphModel.getDataElementStyles();
        boolean scatter = scatterPlotModel.getMarkerEnabled();
        this.outerMargin = new Insets(0, 0, 0, 0);
        this.scatterPlotCellModel.setOuterMargin(this.outerMargin);
        int rowCount = this.getRowValueTree().getLeafNodeCount();
        int columnCount = this.getColumnValueTree().getLeafNodeCount();
        Integer maxVertCount = new Integer(Integer.MAX_VALUE);
        Integer maxHorzCount = new Integer(Integer.MAX_VALUE);
        double markerSize = 0.0;
        Variable sizeVar = dataSource.getVariable(chartMatrixModel.getSizeRole(), 0);
        if (sizeVar != null && sizeVar instanceof NumericVariable) {
            BaseLength gl = scatterPlotModel.getMaxMarkerSize();
            markerSize = gl.getMagnitude((Object)"py");
            ContinuousRangeToNumericMapper sizeMapper = new ContinuousRangeToNumericMapper();
            sizeMapper.setOutputMin(0.0);
            sizeMapper.setOutputMax(1.0);
            sizeMapper.input.connectFrom(((NumericVariable)sizeVar).value);
            sizeMapper.setInputMin(((NumericVariable)sizeVar).getMin());
            sizeMapper.setInputMax(((NumericVariable)sizeVar).getMax());
            this.scatterPlotCellModel.setSizeMapper(sizeMapper);
        } else if (scatter) {
            MarkerStyle[] styles = des.getMarkerStyles();
            markerSize = 1.0;
            for (int ii = 0; ii < styles.length; ++ii) {
                if (!styles[ii].isVisible()) continue;
                BaseLength gl = styles[ii].getSize();
                markerSize = Math.max(markerSize, gl.getMagnitude((Object)"py"));
                break;
            }
        }
        Dimension depth = new Dimension(0, 0);
        AxisModel yAxisModel = scatterPlotModel.getYAxisModel();
        AxisModel y2AxisModel = scatterPlotModel.getY2AxisModel();
        AxisModel xAxisModel = scatterPlotModel.getXAxisModel();
        boolean yVisible = yAxisModel == null ? false : yAxisModel.isVisible();
        boolean y2Visible = y2AxisModel == null ? false : y2AxisModel.isVisible();
        boolean xVisible = xAxisModel.isVisible();
        boolean bl = xInvalid = xList == null || xList.length == 0;
        if (!xInvalid && xList[0] instanceof NumericVariable) {
            xInvalid = false;
        }
        boolean bl2 = yInvalid = yList == null || yList.length == 0;
        if (!yInvalid && yList[0] instanceof NumericVariable) {
            yInvalid = false;
        }
        boolean bl3 = y2Invalid = y2List == null || y2List.length == 0;
        if (!y2Invalid && y2List[0] instanceof NumericVariable) {
            y2Invalid = false;
        }
        if (xInvalid || yInvalid && y2Invalid) {
            return;
        }
        int aboveContentType = scatterPlotModel.getAboveContentType();
        Variable[] aboveValueVars = null;
        if (aboveContentType == 10604) {
            aboveValueVars = xList;
        } else if (aboveContentType == 10605) {
            if (y2List != null && yList != null) {
                int size1 = yList.length;
                int size2 = y2List.length;
                aboveValueVars = new Variable[size1 + size2];
                System.arraycopy(yList, 0, aboveValueVars, 0, size1);
                System.arraycopy(y2List, 0, aboveValueVars, size1, size2);
            } else {
                aboveValueVars = yList != null ? yList : y2List;
            }
        } else {
            aboveValueVars = dataSource.getVariable(chartMatrixModel.getAboveValueRole());
        }
        double xLabelSize = 0.0;
        double yLabelSize = 0.0;
        Channel channel = this.getChannel();
        if (aboveValueVars != null) {
            TextStyle tts = scatterPlotModel.getAboveValueTextStyle();
            if (tts == null) {
                tts = xAxisModel.getValueTextStyle();
            }
            if (chartMatrixModel.getGraphModel().isAntialiasedText()) {
                channel.glEnable(14);
            } else {
                channel.glDisable(14);
            }
            ShadowStyle shadow = tts.getShadowStyle();
            if (shadow.isVisible()) {
                channel.glEnable(11);
                channel.setShadowColor(shadow.getColor());
                channel.setShadowSoftness((float)shadow.getSoftness());
                channel.setShadowOffset((int)shadow.getOffsetX().getMagnitude((Object)"px"), (int)shadow.getOffsetY().getMagnitude((Object)"px"));
            } else {
                channel.glDisable(11);
            }
            for (int i = 0; i < aboveValueVars.length; ++i) {
                if (aboveValueVars[i] == null) continue;
                StringPipe value = aboveValueVars[i] instanceof StringVariable ? ((StringVariable)aboveValueVars[i]).formattedValue : ((NumericVariable)aboveValueVars[i]).formattedValue;
                Point2D labelSize = RasterLabel.getMaxWidthAndHeight((Channel)channel, (Font)tts.getFont(), (StringPipe)value);
                xLabelSize = Math.max(xLabelSize, labelSize.getX());
                yLabelSize = Math.max(yLabelSize, labelSize.getY());
            }
            switch (tts.getJustification()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    xLabelSize /= 2.0;
                }
            }
        }
        int belowContentType = scatterPlotModel.getBelowContentType();
        Variable[] belowValueVars = null;
        if (belowContentType == 10604) {
            belowValueVars = xList;
        } else if (belowContentType == 10605) {
            if (y2List != null && yList != null) {
                int size1 = yList.length;
                int size2 = y2List.length;
                belowValueVars = new Variable[size1 + size2];
                System.arraycopy(yList, 0, belowValueVars, 0, size1);
                System.arraycopy(y2List, 0, belowValueVars, size1, size2);
            } else {
                belowValueVars = yList != null ? yList : y2List;
            }
        } else {
            belowValueVars = dataSource.getVariable(chartMatrixModel.getBelowValueRole());
        }
        if (belowValueVars != null) {
            TextStyle tts = scatterPlotModel.getBelowValueTextStyle();
            if (tts == null) {
                tts = xAxisModel.getValueTextStyle();
            }
            if (chartMatrixModel.getGraphModel().isAntialiasedText()) {
                channel.glEnable(14);
            } else {
                channel.glDisable(14);
            }
            channel.glSelect2DFont(tts.getFont());
            ShadowStyle shadow = tts.getShadowStyle();
            if (shadow.isVisible()) {
                channel.glEnable(11);
                channel.setShadowColor(shadow.getColor());
                channel.setShadowSoftness((float)shadow.getSoftness());
                channel.setShadowOffset((int)shadow.getOffsetX().getMagnitude((Object)"px"), (int)shadow.getOffsetY().getMagnitude((Object)"px"));
            } else {
                channel.glDisable(11);
            }
            double xSize = 0.0;
            for (int i = 0; i < belowValueVars.length; ++i) {
                if (belowValueVars[i] == null) continue;
                StringPipe value = belowValueVars[i] instanceof StringVariable ? ((StringVariable)belowValueVars[i]).formattedValue : ((NumericVariable)belowValueVars[i]).formattedValue;
                Point2D labelSize = RasterLabel.getMaxWidthAndHeight((Channel)channel, (Font)tts.getFont(), (StringPipe)value);
                xSize = Math.max(xSize, labelSize.getX());
                yLabelSize = Math.max(yLabelSize, labelSize.getY());
            }
            switch (tts.getJustification()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    xSize /= 2.0;
                }
            }
            xLabelSize = Math.max(xLabelSize, xSize);
        }
        if (channel != null) {
            channel.glDisable(11);
        }
        xLabelSize += 2.0;
        AxisCellModel yAxisCellModel = null;
        boolean validY = yList != null;
        int len = validY ? yList.length : 0;
        boolean yAxisAttachedToCell = false;
        boolean commonAxis = scatterPlotModel.getUniformEnabled();
        if (validY) {
            double yAxisOrigin;
            if (yList[0] instanceof NumericVariable) {
                yAxisOrigin = 0.0;
                yAxisCellModel = new AxisCellModel();
                yAxisCellModel.setLocale(dataSource.getLocale());
                yAxisCellModel.setOrigin(new Double(yAxisOrigin));
                yAxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
                if (graphModel instanceof RiskMapPlotModel) {
                    yAxisCellModel.setUseRiskMapDefaults(new Boolean(true));
                    AbstractRiskMap riskMap = this.model.getScatterPlotModel().getRiskMap();
                    if (riskMap != null) {
                        yAxisCellModel.setRangeValues(riskMap.getYSegmentedRange());
                    }
                }
                if (commonAxis) {
                    ContinuousRangeToNumericMapper yAxisMapper = new ContinuousRangeToNumericMapper();
                    double[] range = new double[2];
                    NumericVariable[] downErrorVariable = dataSource.getLowVariable(yRole);
                    NumericVariable[] upErrorVariable = dataSource.getHighVariable(yRole);
                    boolean upError = upErrorVariable != null;
                    boolean downError = downErrorVariable != null;
                    range[0] = ((NumericVariable)yList[0]).getMin();
                    if (downError && downErrorVariable[0] != null) {
                        range[0] = range[0] - downErrorVariable[0].getMax();
                    }
                    range[1] = ((NumericVariable)yList[0]).getMax();
                    if (upError && upErrorVariable[0] != null) {
                        range[1] = range[1] + upErrorVariable[0].getMax();
                    }
                    for (int i = 1; i < len; ++i) {
                        double value = ((NumericVariable)yList[i]).getMin();
                        if (downError && downErrorVariable[i] != null) {
                            value -= downErrorVariable[i].getMax();
                        }
                        range[0] = Math.min(range[0], value);
                        value = ((NumericVariable)yList[i]).getMax();
                        if (upError && upErrorVariable[i] != null) {
                            value += upErrorVariable[i].getMax();
                        }
                        range[1] = Math.max(range[1], value);
                    }
                    ContinuousRangeToNumericMapper crtnm = yAxisMapper;
                    crtnm.setInputMin(range[0]);
                    crtnm.setInputMax(range[1]);
                    crtnm.setOutputMin(yAxisOrigin);
                    yAxisCellModel.setMapper((NumericMapper)crtnm);
                    crtnm.setFormat(GTKUtil.getAxisFormat(yList));
                    crtnm.setRangeFormat(scatterPlotModel.getYAxisModel().getRangeMessageFormat());
                    crtnm.setLabelRanges(yAxisModel.getContinuousValuePlacementPolicy() == 12202 || yAxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
                }
            } else {
                yAxisOrigin = 0.0;
                yAxisCellModel = new AxisCellModel();
                yAxisCellModel.setLocale(dataSource.getLocale());
                yAxisCellModel.setOrigin(new Double(yAxisOrigin));
                yAxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
                if (commonAxis) {
                    StringToNumericMapper yAxisMapper = new StringToNumericMapper();
                    yAxisMapper.setStartValue(0.0);
                    yAxisMapper.input.connectFrom(((StringVariable)yList[0]).value);
                    for (int i = 1; i < len; ++i) {
                        yAxisMapper.addStringPipe(((StringVariable)yList[i]).value);
                    }
                    yAxisCellModel.setMapper((NumericMapper)yAxisMapper);
                    yAxisMapper.setFormat(GTKUtil.getAxisFormat(yList));
                }
            }
            yAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
            yAxisCellModel.setAntialiasedText(antialiasedText);
            yAxisCellModel.setDepth(depth);
            yAxisCellModel.setTitleMarker(this.drillMarker);
            yAxisCellModel.setCellCount(new Integer(rowCount));
            yAxisCellModel.setMaximumValueCount(maxVertCount);
            yAxisCellModel.setTitleOn(Boolean.FALSE);
            yAxisCellModel.setAxisModel(yAxisModel);
            int frameVisibilityPolicy = graphModel.getFrameLineStyle().getVisibilityPolicy();
            if (frameVisibilityPolicy == 10200) {
                Boolean vis = columnList != null || rowList != null ? Boolean.TRUE : Boolean.FALSE;
                this.scatterPlotCellModel.setFrameVisible(vis);
            } else {
                this.scatterPlotCellModel.setFrameVisible(frameVisibilityPolicy == 10201 ? Boolean.TRUE : Boolean.FALSE);
            }
            yAxisCellModel.setAxisOrientation("North");
            yAxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
            yAxisCellModel.setAxisVisible(new Boolean(yAxisModel.isVisible()));
            yAxisCellModel.setExtendToMargin(Boolean.TRUE);
            yAxisCellModel.setExtendToStartMargin(Boolean.TRUE);
            yAxisCellModel.setExtendToEndMargin(Boolean.TRUE);
        }
        AxisCellModel y2AxisCellModel = null;
        boolean y2AxisAttachedToCell = false;
        if (y2List != null && y2List[0] != null) {
            y2AxisCellModel = null;
            len = y2List.length;
            if (y2List[0] instanceof NumericVariable) {
                double yAxisOrigin = 0.0;
                y2AxisCellModel = new AxisCellModel();
                y2AxisCellModel.setLocale(dataSource.getLocale());
                y2AxisCellModel.setOrigin(new Double(yAxisOrigin));
                y2AxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
                if (commonAxis || yAxisAttachedToCell) {
                    double yAxisLength;
                    double d = yAxisLength = yAxisCellModel == null ? y2AxisCellModel.getLength().doubleValue() : yAxisCellModel.getLength().doubleValue();
                    if (yAxisCellModel != null) {
                        y2AxisCellModel.setLength(yAxisCellModel.getLength());
                        y2AxisCellModel.setValueCount(yAxisCellModel.getValueCount());
                        y2AxisCellModel.setOrigin(new Double(yAxisOrigin));
                    }
                    ContinuousRangeToNumericMapper y2AxisMapper = new ContinuousRangeToNumericMapper();
                    double[] range = new double[2];
                    NumericVariable[] downErrorVariable = dataSource.getLowVariable(y2Role);
                    NumericVariable[] upErrorVariable = dataSource.getHighVariable(y2Role);
                    boolean upError = upErrorVariable != null;
                    boolean downError = downErrorVariable != null;
                    range[0] = ((NumericVariable)y2List[0]).getMin();
                    if (downError && downErrorVariable[0] != null) {
                        range[0] = range[0] - downErrorVariable[0].getMax();
                    }
                    range[1] = ((NumericVariable)y2List[0]).getMax();
                    if (upError && upErrorVariable[0] != null) {
                        range[1] = range[1] + upErrorVariable[0].getMax();
                    }
                    for (int i = 1; i < len; ++i) {
                        double value = ((NumericVariable)y2List[i]).getMin();
                        if (downError && downErrorVariable[i] != null) {
                            value -= downErrorVariable[i].getMax();
                        }
                        range[0] = Math.min(range[0], value);
                        value = ((NumericVariable)y2List[i]).getMax();
                        if (upError && upErrorVariable[i] != null) {
                            value += upErrorVariable[i].getMax();
                        }
                        range[1] = Math.max(range[1], value);
                    }
                    ContinuousRangeToNumericMapper crtnm = y2AxisMapper;
                    crtnm.setInputMin(range[0]);
                    crtnm.setInputMax(range[1]);
                    crtnm.setOutputMin(yAxisOrigin);
                    crtnm.setOutputMax(yAxisOrigin + yAxisLength);
                    crtnm.setLabelCount(y2AxisMapper.getLabelCount());
                    y2AxisCellModel.setMapper((NumericMapper)y2AxisMapper);
                    y2AxisMapper.setFormat(GTKUtil.getAxisFormat(y2List));
                    crtnm.setRangeFormat(scatterPlotModel.getY2AxisModel().getRangeMessageFormat());
                    crtnm.setLabelRanges(y2AxisModel.getContinuousValuePlacementPolicy() == 12202 || y2AxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
                }
            } else {
                double y2AxisOrigin = 0.0;
                y2AxisCellModel = new AxisCellModel();
                y2AxisCellModel.setLocale(dataSource.getLocale());
                y2AxisCellModel.setOrigin(new Double(y2AxisOrigin));
                y2AxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
                if (commonAxis || yAxisAttachedToCell) {
                    double y2AxisLength = y2AxisCellModel.getLength();
                    double y2AxisTickStride = y2AxisLength / (double)(((StringVariable)y2List[0]).getUniqueValueCount() - 1);
                    y2AxisCellModel.setMajorTickInterval(new Double(y2AxisTickStride));
                    y2AxisCellModel.setLength(new Double(y2AxisLength));
                    StringToNumericMapper y2AxisMapper = new StringToNumericMapper();
                    y2AxisMapper.setStartValue(y2AxisOrigin);
                    y2AxisMapper.setStrideValue(y2AxisTickStride);
                    y2AxisMapper.input.connectFrom(((StringVariable)y2List[0]).value);
                    for (int i = 1; i < len; ++i) {
                        y2AxisMapper.addStringPipe(((StringVariable)y2List[i]).value);
                    }
                    y2AxisCellModel.setMapper((NumericMapper)y2AxisMapper);
                    y2AxisMapper.setFormat(GTKUtil.getAxisFormat(y2List));
                }
            }
            if (!validY) {
                int frameVisibilityPolicy = graphModel.getFrameLineStyle().getVisibilityPolicy();
                if (frameVisibilityPolicy == 10200) {
                    Boolean vis = columnList != null || rowList != null ? Boolean.TRUE : Boolean.FALSE;
                    this.scatterPlotCellModel.setFrameVisible(vis);
                } else {
                    this.scatterPlotCellModel.setFrameVisible(frameVisibilityPolicy == 10201 ? Boolean.TRUE : Boolean.FALSE);
                }
            }
            y2AxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
            y2AxisCellModel.setAntialiasedText(antialiasedText);
            y2AxisCellModel.setCellCount(new Integer(rowCount));
            y2AxisCellModel.setMaximumValueCount(maxVertCount);
            y2AxisCellModel.setTitleOn(Boolean.FALSE);
            y2AxisCellModel.setAxisModel(y2AxisModel);
            y2AxisCellModel.setAxisOrientation("North");
            y2AxisCellModel.setReferenceLinesVisible(new Boolean(!validY));
            y2AxisCellModel.setPrimary(Boolean.FALSE);
            y2AxisCellModel.setAxisVisible(new Boolean(y2AxisModel.isVisible()));
            y2AxisCellModel.setDepth(depth);
            y2AxisCellModel.setTitleMarker(this.drillMarker);
            y2AxisCellModel.setExtendToMargin(Boolean.TRUE);
            y2AxisCellModel.setExtendToStartMargin(Boolean.TRUE);
            y2AxisCellModel.setExtendToEndMargin(Boolean.TRUE);
        }
        AxisCellModel xAxisCellModel = null;
        len = xList.length;
        boolean hasLegend = dataSource.getVariable(chartMatrixModel.getColorRole(), 0) != null || dataSource.getVariable(chartMatrixModel.getShapeRole(), 0) != null || dataSource.getVariable(chartMatrixModel.getGroupRole(), 0) != null || xList.length > 1 || yList != null && yList.length > 1 || y2List != null && y2List.length > 1 || yList != null && y2List != null && yList.length + y2List.length > 1;
        boolean xAxisAttachedToCell = false;
        if (xList[0] instanceof NumericVariable) {
            xAxisOrigin = 0.0;
            xAxisCellModel = new AxisCellModel();
            xAxisCellModel.setLocale(dataSource.getLocale());
            xAxisCellModel.setOrigin(new Double(xAxisOrigin));
            xAxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
            if (graphModel instanceof RiskMapPlotModel) {
                xAxisCellModel.setUseRiskMapDefaults(new Boolean(true));
                AbstractRiskMap riskMap = this.model.getScatterPlotModel().getRiskMap();
                if (riskMap != null) {
                    xAxisCellModel.setRangeValues(riskMap.getXSegmentedRange());
                }
            }
            if (commonAxis || xAxisAttachedToCell) {
                double[] range = new double[2];
                NumericVariable[] leftErrorVariable = dataSource.getLowVariable(xRole);
                NumericVariable[] rightErrorVariable = dataSource.getHighVariable(xRole);
                boolean leftError = leftErrorVariable != null;
                boolean rightError = rightErrorVariable != null;
                range[0] = ((NumericVariable)xList[0]).getMin();
                if (leftError && leftErrorVariable[0] != null) {
                    range[0] = range[0] - leftErrorVariable[0].getMax();
                }
                range[1] = ((NumericVariable)xList[0]).getMax();
                if (rightError && rightErrorVariable[0] != null) {
                    range[1] = range[1] + rightErrorVariable[0].getMax();
                }
                for (int i = 1; i < len; ++i) {
                    double value = ((NumericVariable)xList[i]).getMin();
                    if (leftError && leftErrorVariable[i] != null) {
                        value -= leftErrorVariable[i].getMax();
                    }
                    range[0] = Math.min(range[0], value);
                    value = ((NumericVariable)xList[i]).getMax();
                    if (rightError && rightErrorVariable[i] != null) {
                        value += rightErrorVariable[i].getMax();
                    }
                    range[1] = Math.max(range[1], value);
                }
                xAxisMapper = new ContinuousRangeToNumericMapper();
                ContinuousRangeToNumericMapper crtnm = (ContinuousRangeToNumericMapper)xAxisMapper;
                crtnm.setInputMin(range[0]);
                crtnm.setInputMax(range[1]);
                crtnm.setOutputMin(xAxisOrigin);
                xAxisCellModel.setMapper((NumericMapper)crtnm);
                crtnm.setFormat(GTKUtil.getAxisFormat(xList));
                crtnm.setRangeFormat(scatterPlotModel.getXAxisModel().getRangeMessageFormat());
                crtnm.setLabelRanges(xAxisModel.getContinuousValuePlacementPolicy() == 12202 || xAxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
            }
        } else {
            xAxisOrigin = 0.0;
            xAxisCellModel = new AxisCellModel();
            xAxisCellModel.setLocale(dataSource.getLocale());
            xAxisCellModel.setOrigin(new Double(xAxisOrigin));
            xAxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
            if (commonAxis) {
                xAxisMapper = new StringToNumericMapper();
                xAxisMapper.setStartValue(0.0);
                xAxisMapper.input.connectFrom(((StringVariable)xList[0]).value);
                for (int i = 1; i < len; ++i) {
                    xAxisMapper.addStringPipe(((StringVariable)xList[i]).value);
                }
                xAxisMapper.setFormat(GTKUtil.getAxisFormat(xList));
                xAxisCellModel.setMapper((NumericMapper)xAxisMapper);
            }
        }
        xAxisCellModel.setDepth(depth);
        xAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
        xAxisCellModel.setAntialiasedText(antialiasedText);
        xAxisCellModel.setTitleMarker(this.drillMarker);
        xAxisCellModel.setCellCount(new Integer(columnCount));
        xAxisCellModel.setMaximumValueCount(maxHorzCount);
        xAxisCellModel.setExtendToMargin(Boolean.TRUE);
        xAxisCellModel.setExtendToStartMargin(Boolean.TRUE);
        xAxisCellModel.setExtendToEndMargin(Boolean.TRUE);
        xAxisCellModel.setTitleOn(Boolean.FALSE);
        xAxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
        xAxisCellModel.setAxisOrientation("East");
        xAxisCellModel.setAxisModel(xAxisModel);
        xAxisCellModel.setAxisVisible(new Boolean(xAxisModel.isVisible()));
        if (dataSource.getVariable(chartMatrixModel.getColorRole(), 0) != null) {
            this.scatterPlotCellModel.setColorRole(chartMatrixModel.getColorRole());
            this.scatterPlotCellModel.setGroupByColor(Boolean.FALSE);
        } else {
            this.scatterPlotCellModel.setColorRole(chartMatrixModel.getGroupRole());
            this.scatterPlotCellModel.setGroupByColor(Boolean.TRUE);
        }
        this.scatterPlotCellModel.setAnimationKeyFrameRole(chartMatrixModel.getAnimationKeyFrameRole());
        this.scatterPlotCellModel.setAnimationIdentificationRole(chartMatrixModel.getAnimationIdentificationRole());
        if (dataSource.getVariable(chartMatrixModel.getShapeRole(), 0) != null) {
            this.scatterPlotCellModel.setShapeRole(chartMatrixModel.getShapeRole());
        } else {
            this.scatterPlotCellModel.setShapeRole(chartMatrixModel.getGroupRole());
        }
        this.scatterPlotCellModel.setAuxiliaryRole(chartMatrixModel.getAuxiliaryRole());
        this.scatterPlotCellModel.setDataTipRole(chartMatrixModel.getDataTipRole());
        this.scatterPlotCellModel.setYAxisCellModel(yAxisCellModel);
        this.scatterPlotCellModel.setXAxisCellModel(xAxisCellModel);
        this.scatterPlotCellModel.setY2AxisCellModel(y2AxisCellModel);
        this.scatterPlotCellModel.setXAxisVisible(new Boolean(xAxisAttachedToCell && xAxisModel.isVisible()));
        this.scatterPlotCellModel.setYAxisVisible(new Boolean(yAxisAttachedToCell && yAxisModel.isVisible()));
        if (y2AxisModel != null) {
            this.scatterPlotCellModel.setY2AxisVisible(new Boolean(y2AxisAttachedToCell && y2AxisModel.isVisible()));
        }
        if (gc != null) {
            gc.dispose();
        }
        Mapper[] mapper = null;
        if (hasLegend && (mapper = this._addLegend(dataSource, this.scatterPlotCellModel)) != null) {
            this.scatterPlotCellModel.setMarkerColorMapper((ColorMapper)mapper[0]);
            this.scatterPlotCellModel.setMarkerMapper((StringToNumberMapper)mapper[1]);
            this.scatterPlotCellModel.setMarkerSizeMapper((StringToNumberMapper)mapper[2]);
            this.scatterPlotCellModel.setLineColorMapper((ColorMapper)mapper[3]);
            this.scatterPlotCellModel.setLineMapper((StringToNumberMapper)mapper[4]);
            this.scatterPlotCellModel.setLineWidthMapper((StringToNumberMapper)mapper[4]);
            this.scatterPlotCellModel.setFillColorMapper((ColorMapper)mapper[6]);
        }
        if ((sizeVar == null || !(sizeVar instanceof NumericVariable)) && scatter && mapper != null && mapper[2] != null) {
            StringToNumberMapper msmapper = (StringToNumberMapper)mapper[2];
            markerSize = msmapper.getOutputMax();
        }
        boolean border = (frame = graphModel.getFrameLineStyle()).getVisibilityPolicy() != 10202;
        int borderWidth = border ? (int)frame.getThickness().getMagnitude((Object)"px") : 0;
        this.innerMargin = this.model.getScatterPlotModel().getRiskMap() == null ? new Dimension((int)Math.max(markerSize, xLabelSize) + borderWidth, (int)(markerSize + 2.0 + yLabelSize + (double)borderWidth)) : new Dimension(0, 0);
        Dimension minMargin = new Dimension(this.innerMargin.width, this.innerMargin.height);
        Dimension preferredMargin = new Dimension(this.innerMargin.width, this.innerMargin.height);
        this.scatterPlotCellModel.setInnerMargin(this.innerMargin);
        if (yAxisCellModel != null) {
            yAxisCellModel.setMargin(this.innerMargin);
            yAxisCellModel.setMinimumMargin(minMargin);
            yAxisCellModel.setPreferredMargin(preferredMargin);
        }
        if (y2AxisCellModel != null) {
            y2AxisCellModel.setPreferredMargin(preferredMargin);
            y2AxisCellModel.setMargin(this.innerMargin);
            y2AxisCellModel.setMinimumMargin(minMargin);
        }
        if (xAxisCellModel != null) {
            xAxisCellModel.setMargin(this.innerMargin);
            xAxisCellModel.setMinimumMargin(minMargin);
            xAxisCellModel.setPreferredMargin(preferredMargin);
        }
        this.plotCells = this.addMatrixCellComponents(new ScatterPlotCellFactory(), this.scatterPlotCellModel, new DataSource[]{dataSource, this.getSelectionDataSource()});
        int rows = 1;
        int cols = 1;
        int num = this.plotCells.size();
        if (validY) {
            if (yAxisAttachedToCell) {
                yAxisCellModel.computeParameters(channel);
            } else if (yVisible && this.matrixContainer != null) {
                Component[] yComp = this.matrixContainer.getYAxisCellComponents();
                if (yVisible) {
                    this.yCells = new ArrayList<Component>(Arrays.asList(yComp));
                    rows = this.yCells.size();
                    cols = num / rows;
                }
            }
        }
        if (y2AxisCellModel != null) {
            if (y2AxisAttachedToCell) {
                y2AxisCellModel.computeParameters(channel);
            } else if (y2Visible && this.matrixContainer != null) {
                Component[] y2Comp = this.matrixContainer.getY2AxisCellComponents();
                this.y2Cells = new ArrayList<Component>(Arrays.asList(y2Comp));
                rows = this.y2Cells.size();
                cols = num / rows;
            }
        }
        if (xAxisAttachedToCell) {
            xAxisCellModel.computeParameters(((ScatterPlotCell)this.plotCells.get(0)).getChannel());
        } else if (xVisible && this.matrixContainer != null) {
            Component[] xComp = this.matrixContainer.getXAxisCellComponents();
            this.xCells = new ArrayList<Component>(Arrays.asList(xComp));
            cols = this.xCells.size();
            rows = num / cols;
        }
        Object[] cells = this.plotCells.toArray();
        boolean bl4 = displayMissing = scatterPlotModel.getMissingPolicy() == 10201;
        if (!yAxisAttachedToCell) {
            axisCells = null;
            if (validY) {
                Object[] objectArray = axisCells = this.yCells == null ? null : this.yCells.toArray();
                if (len > 0) {
                    double origin;
                    if (!commonAxis) {
                        int r;
                        origin = yAxisCellModel.getOrigin();
                        if (yList[0] instanceof NumericVariable) {
                            if (yAxisModel.isAdjustValueMagnitudeEnabled()) {
                                this._findAdjustment(yAxisCellModel, rows, cols, 0, cells, yList, yAxisModel, channel);
                            }
                            for (r = 0; r < rows; ++r) {
                                double[] totalRowRange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
                                AxisCellModel axisCellModel = this.yCells == null ? yAxisCellModel : ((AxisCell)axisCells[r]).getAxisModel();
                                for (int c = 0; c < cols; ++c) {
                                    double[] range = ((ScatterPlotCell)cells[r * cols + c]).getYRange();
                                    totalRowRange[0] = Math.min(totalRowRange[0], range[0]);
                                    totalRowRange[1] = Math.max(totalRowRange[1], range[1]);
                                }
                                ContinuousRangeToNumericMapper axisMapper = new ContinuousRangeToNumericMapper();
                                axisMapper.setInputMin(totalRowRange[0]);
                                axisMapper.setInputMax(totalRowRange[1]);
                                axisMapper.setFormat(GTKUtil.getAxisFormat(yList));
                                axisMapper.setRangeFormat(yAxisModel.getRangeMessageFormat());
                                axisMapper.setLabelRanges(yAxisModel.getContinuousValuePlacementPolicy() == 12202 || yAxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
                                axisCellModel.setMapper((NumericMapper)axisMapper);
                                axisCellModel.setAdjustValueMagnitudeFactor(yAxisCellModel.getAdjustValueMagnitudeFactor());
                                axisCellModel.computeParameters(channel);
                                if (columnList != null) {
                                    int titleType = axisCellModel.getTitlePlacementType();
                                    if (titleType == 11303 || titleType == 11301) {
                                        axisCellModel.setTitlePlacementType(11306);
                                        axisCellModel.setTitleOn(Boolean.TRUE);
                                        axisCellModel.setTitleAngle(new Double(90.0));
                                        axisCellModel.setTitleHeight(new Double(0.0));
                                        axisCellModel.setTitleWidth(new Double(0.0));
                                    }
                                } else {
                                    axisCellModel.setComputeTitleHeightEnabled(false);
                                }
                                for (int c = 0; c < cols; ++c) {
                                    ScatterPlotCell scatterCell = (ScatterPlotCell)cells[r * cols + c];
                                    scatterCell.setYAxisCellModel(axisCellModel);
                                    scatterCell.setYMapper((NumericMapper)axisMapper);
                                }
                            }
                        } else {
                            for (r = 0; r < rows; ++r) {
                                int c;
                                AxisCellModel axisCellModel = this.yCells == null ? yAxisCellModel : ((AxisCell)axisCells[r]).getAxisModel();
                                StringToNumericMapper axisMapper = new StringToNumericMapper();
                                DataSource ds = ((ScatterPlotCell)cells[r]).getDataSource();
                                Variable[] variableList = ScatterPlotMatrix.checkVariableList(ds.getVariable(yRole));
                                int ll = variableList.length;
                                axisMapper.input.connectFrom(((StringVariable)variableList[0]).uniqueValue);
                                for (int j = 1; j < ll; ++j) {
                                    axisMapper.addStringPipe(((StringVariable)variableList[j]).uniqueValue);
                                }
                                for (c = 1; c < cols; ++c) {
                                    ds = ((ScatterPlotCell)cells[r * cols + c]).getDataSource();
                                    variableList = ScatterPlotMatrix.checkVariableList(ds.getVariable(yRole));
                                    for (int j = 0; j < ll; ++j) {
                                        axisMapper.addStringPipe(((StringVariable)variableList[j]).uniqueValue);
                                    }
                                }
                                axisMapper.setStartValue(origin);
                                axisMapper.setFormat(GTKUtil.getAxisFormat(yList));
                                axisMapper.setLabelMissingValues(displayMissing);
                                axisCellModel.setMapper((NumericMapper)axisMapper);
                                axisCellModel.computeParameters(channel);
                                if (columnList != null) {
                                    int titleType = axisCellModel.getTitlePlacementType();
                                    if (titleType == 11303 || titleType == 11301) {
                                        axisCellModel.setTitlePlacementType(11306);
                                        axisCellModel.setTitleOn(Boolean.TRUE);
                                        axisCellModel.setTitleAngle(new Double(90.0));
                                        axisCellModel.setTitleHeight(new Double(0.0));
                                        axisCellModel.setTitleWidth(new Double(0.0));
                                    }
                                } else {
                                    axisCellModel.setComputeTitleHeightEnabled(false);
                                }
                                for (c = 0; c < cols; ++c) {
                                    ScatterPlotCell scatterCell = (ScatterPlotCell)cells[r * cols + c];
                                    scatterCell.setYAxisCellModel(axisCellModel);
                                    scatterCell.setYMapper((NumericMapper)axisMapper);
                                }
                            }
                        }
                    } else {
                        ContinuousRangeToNumericMapper axisMapper;
                        origin = yAxisCellModel.getOrigin();
                        if (yList[0] instanceof NumericVariable) {
                            axisMapper = (ContinuousRangeToNumericMapper)yAxisCellModel.getMapper();
                            axisMapper.setFormat(GTKUtil.getAxisFormat(yList));
                            axisMapper.setRangeFormat(scatterPlotModel.getYAxisModel().getRangeMessageFormat());
                            axisMapper.setLabelRanges(yAxisModel.getContinuousValuePlacementPolicy() == 12202 || yAxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
                            yAxisCellModel.computeParameters(channel);
                        } else {
                            axisMapper = (StringToNumericMapper)yAxisCellModel.getMapper();
                            axisMapper.setStartValue(origin);
                            axisMapper.setFormat(GTKUtil.getAxisFormat(yList));
                            axisMapper.setLabelMissingValues(displayMissing);
                            yAxisCellModel.computeParameters(channel);
                        }
                        if (columnList != null) {
                            int titleType = yAxisCellModel.getTitlePlacementType();
                            if (titleType == 11303 || titleType == 11301) {
                                yAxisCellModel.setTitlePlacementType(11306);
                                yAxisCellModel.setTitleOn(Boolean.TRUE);
                                yAxisCellModel.setTitleAngle(new Double(90.0));
                                yAxisCellModel.setTitleHeight(new Double(0.0));
                                yAxisCellModel.setTitleWidth(new Double(0.0));
                            }
                        } else {
                            yAxisCellModel.setComputeTitleHeightEnabled(false);
                        }
                    }
                }
            }
            if (!y2AxisAttachedToCell && y2AxisCellModel != null) {
                Object[] axis2Cells;
                Object[] objectArray = axis2Cells = this.y2Cells == null ? null : this.y2Cells.toArray();
                if (!commonAxis) {
                    int r;
                    if (y2List[0] instanceof NumericVariable) {
                        if (y2AxisModel.isAdjustValueMagnitudeEnabled()) {
                            this._findAdjustment(y2AxisCellModel, rows, cols, 1, cells, y2List, y2AxisModel, channel);
                        }
                        for (r = 0; r < rows; ++r) {
                            double origin;
                            double length;
                            int valueCount;
                            AxisCellModel axisCellModel = this.y2Cells == null ? y2AxisCellModel : ((AxisCell)axis2Cells[r]).getAxisModel();
                            double[] totalRange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
                            AxisCellModel yModel = null;
                            if (validY && !yInvalid) {
                                yModel = ((AxisCell)axisCells[r]).getAxisModel();
                                valueCount = yModel.getValueCount();
                                length = yModel.getLength();
                                origin = yModel.getOrigin();
                                axisCellModel.setValueCount(yModel.getValueCount());
                                axisCellModel.setLength(yModel.getLength());
                                axisCellModel.setOrigin(yModel.getOrigin());
                                axisCellModel.setMajorTickInterval(yModel.getMajorTickInterval());
                            } else {
                                origin = axisCellModel.getOrigin();
                                length = axisCellModel.getLength();
                                valueCount = axisCellModel.getValueCount();
                            }
                            for (int c = 0; c < cols; ++c) {
                                double[] range = ((ScatterPlotCell)cells[r * cols + c]).getY2Range();
                                totalRange[0] = Math.min(totalRange[0], range[0]);
                                totalRange[1] = Math.max(totalRange[1], range[1]);
                            }
                            ContinuousRangeToNumericMapper axisMapper = new ContinuousRangeToNumericMapper();
                            axisMapper.setInputMin(totalRange[0]);
                            axisMapper.setInputMax(totalRange[1]);
                            axisMapper.setOutputMin(origin);
                            axisMapper.setOutputMax(origin + length);
                            axisMapper.setLabelCount(valueCount);
                            axisMapper.setFormat(GTKUtil.getAxisFormat(y2List));
                            axisCellModel.setMapper((NumericMapper)axisMapper);
                            axisCellModel.setAdjustValueMagnitudeFactor(y2AxisCellModel.getAdjustValueMagnitudeFactor());
                            if (validY && !yInvalid) {
                                axisCellModel.computeSecondaryParameters(channel);
                                if (yModel.getTitlePlacementType() == 11306) {
                                    yModel.setTitleHeight(axisCellModel.getTitleHeight());
                                } else if (axisCellModel.getTitlePlacementType() == 11306) {
                                    axisCellModel.setTitleHeight(yModel.getTitleHeight());
                                }
                            } else {
                                axisCellModel.computeParameters(channel);
                            }
                            if (columnList != null) {
                                int titleType = axisCellModel.getTitlePlacementType();
                                if (titleType == 11303 || titleType == 11301) {
                                    axisCellModel.setTitlePlacementType(11306);
                                    axisCellModel.setTitleOn(Boolean.TRUE);
                                    axisCellModel.setTitleAngle(new Double(90.0));
                                    axisCellModel.setTitleHeight(new Double(0.0));
                                    axisCellModel.setTitleWidth(new Double(0.0));
                                }
                            } else {
                                axisCellModel.setComputeTitleHeightEnabled(false);
                            }
                            for (int c = 0; c < cols; ++c) {
                                ScatterPlotCell scatterCell = (ScatterPlotCell)cells[r * cols + c];
                                scatterCell.setY2AxisCellModel(axisCellModel);
                                scatterCell.setY2Mapper((NumericMapper)axisMapper);
                            }
                        }
                    } else {
                        for (r = 0; r < rows; ++r) {
                            int c;
                            AxisCellModel yModel = this.y2Cells == null ? y2AxisCellModel : ((AxisCell)axis2Cells[r]).getAxisModel();
                            double tickStride = yModel.getMajorTickInterval();
                            double origin = yModel.getOrigin();
                            AxisCellModel axisCellModel = ((AxisCell)axis2Cells[r]).getAxisModel();
                            axisCellModel.setValueCount(yModel.getValueCount());
                            axisCellModel.setLength(yModel.getLength());
                            axisCellModel.setOrigin(yModel.getOrigin());
                            axisCellModel.setMajorTickInterval(yModel.getMajorTickInterval());
                            StringToNumericMapper axisMapper = new StringToNumericMapper();
                            DataSource ds = ((ScatterPlotCell)cells[r]).getDataSource();
                            Variable[] variableList = ScatterPlotMatrix.checkVariableList(ds.getVariable(y2Role));
                            int ll = variableList.length;
                            axisMapper.input.connectFrom(((StringVariable)variableList[0]).uniqueValue);
                            for (int j = 1; j < ll; ++j) {
                                axisMapper.addStringPipe(((StringVariable)variableList[j]).uniqueValue);
                            }
                            for (c = 1; c < cols; ++c) {
                                ds = ((ScatterPlotCell)cells[r * cols + c]).getDataSource();
                                variableList = ScatterPlotMatrix.checkVariableList(ds.getVariable(y2Role));
                                for (int j = 0; j < ll; ++j) {
                                    axisMapper.addStringPipe(((StringVariable)variableList[j]).uniqueValue);
                                }
                            }
                            axisMapper.setStartValue(origin);
                            axisMapper.setStrideValue(tickStride);
                            axisMapper.setLabelMissingValues(displayMissing);
                            axisMapper.setFormat(GTKUtil.getAxisFormat(y2List));
                            axisCellModel.setMapper((NumericMapper)axisMapper);
                            axisCellModel.computeParameters(((AxisCell)axis2Cells[r]).getChannel());
                            if (columnList != null) {
                                int titleType = axisCellModel.getTitlePlacementType();
                                if (titleType == 11303 || titleType == 11301) {
                                    axisCellModel.setTitlePlacementType(11306);
                                    axisCellModel.setTitleOn(Boolean.TRUE);
                                    axisCellModel.setTitleHeight(new Double(0.0));
                                    axisCellModel.setTitleWidth(new Double(0.0));
                                    axisCellModel.setTitleAngle(new Double(90.0));
                                }
                            } else {
                                axisCellModel.setComputeTitleHeightEnabled(false);
                            }
                            for (c = 0; c < cols; ++c) {
                                ScatterPlotCell scatterCell = (ScatterPlotCell)cells[r * cols + c];
                                scatterCell.setY2AxisCellModel(axisCellModel);
                                scatterCell.setY2Mapper((NumericMapper)axisMapper);
                            }
                        }
                    }
                } else {
                    AxisCellModel yModel = null;
                    double origin = 0.0;
                    double length = 0.0;
                    if (y2List[0] instanceof NumericVariable) {
                        int valueCount;
                        if (validY && !yInvalid) {
                            yModel = ((AxisCell)axisCells[0]).getAxisModel();
                            valueCount = yModel.getValueCount();
                            length = yModel.getLength();
                            origin = yModel.getOrigin();
                            y2AxisCellModel.setValueCount(yModel.getValueCount());
                            y2AxisCellModel.setLength(yModel.getLength());
                            y2AxisCellModel.setOrigin(yModel.getOrigin());
                            y2AxisCellModel.setMajorTickInterval(yModel.getMajorTickInterval());
                        } else {
                            origin = y2AxisCellModel.getOrigin();
                            length = y2AxisCellModel.getLength();
                            valueCount = y2AxisCellModel.getValueCount();
                        }
                        ContinuousRangeToNumericMapper axisMapper = (ContinuousRangeToNumericMapper)y2AxisCellModel.getMapper();
                        axisMapper.setOutputMin(origin);
                        axisMapper.setOutputMax(origin + length);
                        axisMapper.setLabelCount(valueCount);
                        axisMapper.setFormat(GTKUtil.getAxisFormat(y2List));
                        axisMapper.setRangeFormat(scatterPlotModel.getY2AxisModel().getRangeMessageFormat());
                        axisMapper.setLabelRanges(y2AxisModel.getContinuousValuePlacementPolicy() == 12202 || y2AxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
                        if (validY && !yInvalid) {
                            y2AxisCellModel.computeSecondaryParameters(((AxisCell)axis2Cells[0]).getChannel());
                            if (yModel.getTitlePlacementType() == 11306) {
                                yModel.setTitleHeight(y2AxisCellModel.getTitleHeight());
                            } else if (y2AxisCellModel.getTitlePlacementType() == 11306) {
                                y2AxisCellModel.setTitleHeight(yModel.getTitleHeight());
                            }
                        } else {
                            y2AxisCellModel.computeParameters(((AxisCell)axis2Cells[0]).getChannel());
                        }
                    } else {
                        y2AxisCellModel.computeParameters(((AxisCell)axis2Cells[0]).getChannel());
                    }
                    if (columnList != null) {
                        int titleType = y2AxisCellModel.getTitlePlacementType();
                        if (titleType == 11303 || titleType == 11301) {
                            y2AxisCellModel.setTitlePlacementType(11306);
                            y2AxisCellModel.setTitleOn(Boolean.TRUE);
                            y2AxisCellModel.setTitleAngle(new Double(90.0));
                            y2AxisCellModel.setTitleHeight(new Double(0.0));
                            y2AxisCellModel.setTitleWidth(new Double(0.0));
                        }
                    } else {
                        y2AxisCellModel.setComputeTitleHeightEnabled(false);
                    }
                }
            }
        }
        if (!xAxisAttachedToCell) {
            Object[] objectArray = axisCells = this.xCells == null ? null : this.xCells.toArray();
            if (!commonAxis) {
                int c;
                double origin = xAxisCellModel.getOrigin();
                if (xList[0] instanceof NumericVariable) {
                    if (xAxisModel.isAdjustValueMagnitudeEnabled()) {
                        this._findAdjustment(xAxisCellModel, rows, cols, 2, cells, xList, xAxisModel, channel);
                    }
                    for (c = 0; c < cols; ++c) {
                        int titleType;
                        double[] totalRange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
                        AxisCellModel axisCellModel = this.xCells == null ? xAxisCellModel : ((AxisCell)axisCells[c]).getAxisModel();
                        for (int r = 0; r < rows; ++r) {
                            double[] range = ((ScatterPlotCell)cells[r * cols + c]).getXRange();
                            totalRange[0] = Math.min(totalRange[0], range[0]);
                            totalRange[1] = Math.max(totalRange[1], range[1]);
                        }
                        ContinuousRangeToNumericMapper axisMapper = new ContinuousRangeToNumericMapper();
                        axisMapper.setInputMin(totalRange[0]);
                        axisMapper.setInputMax(totalRange[1]);
                        axisMapper.setFormat(GTKUtil.getAxisFormat(xList));
                        axisMapper.setRangeFormat(scatterPlotModel.getXAxisModel().getRangeMessageFormat());
                        axisMapper.setLabelRanges(xAxisModel.getContinuousValuePlacementPolicy() == 12202 || xAxisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
                        axisCellModel.setMapper((NumericMapper)axisMapper);
                        axisCellModel.setAdjustValueMagnitudeFactor(xAxisCellModel.getAdjustValueMagnitudeFactor());
                        axisCellModel.computeParameters(((AxisCell)axisCells[c]).getChannel());
                        if (rowList != null && ((titleType = axisCellModel.getTitlePlacementType()) == 11303 || titleType == 11301)) {
                            axisCellModel.setTitlePlacementType(11306);
                            axisCellModel.setTitleOn(Boolean.TRUE);
                            axisCellModel.setTitleHeight(new Double(0.0));
                            axisCellModel.setTitleWidth(new Double(0.0));
                        }
                        for (int r = 0; r < rows; ++r) {
                            ScatterPlotCell scatterCell = (ScatterPlotCell)cells[r * cols + c];
                            scatterCell.setXAxisCellModel(axisCellModel);
                            scatterCell.setXMapper((NumericMapper)axisMapper);
                        }
                    }
                } else {
                    for (c = 0; c < cols; ++c) {
                        int titleType;
                        int r;
                        AxisCellModel axisCellModel = this.xCells == null ? yAxisCellModel : ((AxisCell)axisCells[c]).getAxisModel();
                        StringToNumericMapper axisMapper = new StringToNumericMapper();
                        DataSource ds = ((ScatterPlotCell)cells[0 * cols + c]).getDataSource();
                        Variable[] variableList = ScatterPlotMatrix.checkVariableList(ds.getVariable(xRole));
                        int ll = variableList.length;
                        axisMapper.input.connectFrom(((StringVariable)variableList[0]).uniqueValue);
                        for (int j = 1; j < ll; ++j) {
                            axisMapper.addStringPipe(((StringVariable)variableList[j]).uniqueValue);
                        }
                        for (r = 1; r < rows; ++r) {
                            ds = ((ScatterPlotCell)cells[r * cols + c]).getDataSource();
                            variableList = ScatterPlotMatrix.checkVariableList(ds.getVariable(xRole));
                            for (int j = 0; j < ll; ++j) {
                                axisMapper.addStringPipe(((StringVariable)variableList[j]).uniqueValue);
                            }
                        }
                        axisMapper.setStartValue(origin);
                        axisMapper.setLabelMissingValues(displayMissing);
                        axisMapper.setFormat(GTKUtil.getAxisFormat(xList));
                        axisCellModel.setMapper((NumericMapper)axisMapper);
                        axisCellModel.computeParameters(((AxisCell)axisCells[c]).getChannel());
                        if (rowList != null && ((titleType = axisCellModel.getTitlePlacementType()) == 11303 || titleType == 11301)) {
                            axisCellModel.setTitlePlacementType(11306);
                            axisCellModel.setTitleOn(Boolean.TRUE);
                            axisCellModel.setTitleHeight(new Double(0.0));
                            axisCellModel.setTitleWidth(new Double(0.0));
                        }
                        for (r = 0; r < rows; ++r) {
                            ScatterPlotCell scatterCell = (ScatterPlotCell)cells[r * cols + c];
                            scatterCell.setXAxisCellModel(axisCellModel);
                            scatterCell.setXMapper((NumericMapper)axisMapper);
                        }
                    }
                }
            } else {
                int titleType;
                ContinuousRangeToNumericMapper axisMapper;
                double origin = xAxisCellModel.getOrigin();
                if (xList[0] instanceof NumericVariable) {
                    axisMapper = (ContinuousRangeToNumericMapper)xAxisCellModel.getMapper();
                    axisMapper.setFormat(GTKUtil.getAxisFormat(xList));
                    xAxisCellModel.computeParameters(((AxisCell)axisCells[0]).getChannel());
                } else {
                    axisMapper = (StringToNumericMapper)xAxisCellModel.getMapper();
                    axisMapper.setStartValue(origin);
                    axisMapper.setLabelMissingValues(displayMissing);
                    axisMapper.setFormat(GTKUtil.getAxisFormat(xList));
                    xAxisCellModel.computeParameters(((AxisCell)axisCells[0]).getChannel());
                }
                if (rowList != null && ((titleType = xAxisCellModel.getTitlePlacementType()) == 11303 || titleType == 11301)) {
                    xAxisCellModel.setTitlePlacementType(11306);
                    xAxisCellModel.setTitleOn(Boolean.TRUE);
                    xAxisCellModel.setTitleHeight(new Double(0.0));
                    xAxisCellModel.setTitleWidth(new Double(0.0));
                }
            }
        }
        if (this.plotCells != null) {
            int maxRow = -1;
            int maxColumn = -1;
            for (int ii = this.plotCells.size() - 1; ii >= 0; --ii) {
                ScatterPlotCell cell = (ScatterPlotCell)this.plotCells.get(ii);
                if (maxRow < cell.getRow()) {
                    maxRow = cell.getRow();
                }
                if (maxColumn >= cell.getColumn()) continue;
                maxColumn = cell.getColumn();
            }
            this.scatterPlotCellModel.setMaxRow(new Integer(maxRow));
            this.scatterPlotCellModel.setMaxColumn(new Integer(maxColumn));
        }
        if (this.scatterPlotCellModel != null) {
            if (this.scatterPlotCellModel.getYAxisCellModel() != null && this.scatterPlotCellModel.getYAxisCellModel().getTitleAddition() != null) {
                this.matrixContainer.addSpecialYAxisLabel(this.scatterPlotCellModel.getYAxisCellModel().getTitleAddition());
            }
            if (this.scatterPlotCellModel.getY2AxisCellModel() != null && this.scatterPlotCellModel.getY2AxisCellModel().getTitleAddition() != null) {
                this.matrixContainer.addSpecialY2AxisLabel(this.scatterPlotCellModel.getY2AxisCellModel().getTitleAddition());
            }
            if (this.scatterPlotCellModel.getXAxisCellModel() != null && this.scatterPlotCellModel.getXAxisCellModel().getTitleAddition() != null) {
                this.matrixContainer.addSpecialXAxisLabel(this.scatterPlotCellModel.getXAxisCellModel().getTitleAddition());
            }
        }
    }

    private void _findAdjustment(AxisCellModel axisCellModel, int rows, int cols, int whichAxis, Object[] cells, Variable[] yList, AxisModel axisModel, Channel channel) {
        boolean adjustPossible = true;
        double[] smallestGreaterThanOneRange = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double[] greatestLessThanOneRange = new double[]{-1.7976931348623157E308, -1.7976931348623157E308};
        switch (whichAxis) {
            case 0: 
            case 1: {
                for (int r = 0; r < rows; ++r) {
                    double[] totalRowRange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
                    for (int c = 0; c < cols && adjustPossible; ++c) {
                        double[] range = null;
                        switch (whichAxis) {
                            case 0: {
                                range = ((ScatterPlotCell)cells[r * cols + c]).getYRange();
                                break;
                            }
                            case 1: {
                                range = ((ScatterPlotCell)cells[r * cols + c]).getY2Range();
                            }
                        }
                        totalRowRange[0] = Math.min(totalRowRange[0], (double)range[0]);
                        totalRowRange[1] = Math.max(totalRowRange[1], range[1]);
                    }
                    adjustPossible = this._checkAdjustPossible(totalRowRange, smallestGreaterThanOneRange, greatestLessThanOneRange);
                }
                break;
            }
            case 2: {
                for (int c = 0; c < cols; ++c) {
                    double[] totalColRange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
                    for (int r = 0; r < rows && adjustPossible; ++r) {
                        double[] range = ((ScatterPlotCell)cells[r * cols + c]).getXRange();
                        totalColRange[0] = Math.min(totalColRange[0], range[0]);
                        totalColRange[1] = Math.max(totalColRange[1], range[1]);
                    }
                    adjustPossible = this._checkAdjustPossible(totalColRange, smallestGreaterThanOneRange, greatestLessThanOneRange);
                }
                break;
            }
            default: {
                this.greaterThanOne = false;
                this.lessThanOne = false;
                return;
            }
        }
        if (adjustPossible) {
            ContinuousRangeToNumericMapper axisMapper = new ContinuousRangeToNumericMapper();
            if (this.greaterThanOne) {
                axisMapper.setInputMin(smallestGreaterThanOneRange[0]);
                axisMapper.setInputMax(smallestGreaterThanOneRange[1]);
            } else {
                axisMapper.setInputMin(greatestLessThanOneRange[0]);
                axisMapper.setInputMax(greatestLessThanOneRange[1]);
            }
            axisMapper.setFormat(GTKUtil.getAxisFormat(yList));
            axisMapper.setRangeFormat(axisModel.getRangeMessageFormat());
            axisMapper.setLabelRanges(axisModel.getContinuousValuePlacementPolicy() == 12202 || axisModel.getContinuousValuePlacementPolicy() == 10200 && this.model.getLabelRanges() != false);
            axisCellModel.setMapper((NumericMapper)axisMapper);
            axisCellModel.computeParameters(channel);
        }
        this.greaterThanOne = false;
        this.lessThanOne = false;
    }

    private boolean _checkAdjustPossible(double[] range, double[] smallestGreaterThanOneRange, double[] greatestLessThanOneRange) {
        boolean adjustPossible = false;
        if (Math.abs(range[0]) >= 1.0 && Math.abs(range[1]) >= 1.0) {
            if (this.lessThanOne) {
                adjustPossible = false;
            } else {
                adjustPossible = true;
                this.greaterThanOne = true;
                smallestGreaterThanOneRange[0] = Math.min(smallestGreaterThanOneRange[0], range[0]);
                smallestGreaterThanOneRange[1] = Math.min(smallestGreaterThanOneRange[1], range[1]);
            }
        }
        if (Math.abs(range[0]) < 1.0 && Math.abs(range[1]) < 1.0) {
            if (this.greaterThanOne) {
                adjustPossible = false;
            } else {
                adjustPossible = true;
                this.lessThanOne = true;
                greatestLessThanOneRange[0] = Math.max(greatestLessThanOneRange[0], range[0]);
                greatestLessThanOneRange[1] = Math.max(greatestLessThanOneRange[1], range[1]);
            }
        }
        return adjustPossible;
    }

    private static Variable[] checkVariableList(Variable[] list) {
        int i;
        if (list == null) {
            return list;
        }
        boolean isNumeric = list[0] instanceof NumericVariable;
        boolean forceString = false;
        int len = list.length;
        for (i = 0; i < len; ++i) {
            if (list[i] instanceof NumericVariable == isNumeric) continue;
            forceString = true;
            break;
        }
        if (forceString) {
            for (i = 0; i < len; ++i) {
                if (!(list[i] instanceof NumericVariable)) continue;
                StringVariable stringVariable = new StringVariable();
                stringVariable.connectFrom((NumericVariable)list[i]);
                stringVariable.setLabel(list[i].getLabel());
                stringVariable.setFormat(null);
                list[i] = stringVariable;
            }
        }
        return list;
    }

    @Override
    public void validateTree() {
        AxisCellModel axisCellModel;
        AxisCell axisCell;
        Dimension dd;
        AxisCellModel acm;
        int ss;
        if (this.outerMargin == null || this.plotCells == null) {
            super.validateTree();
            return;
        }
        Insets oldOuterMargin = (Insets)this.outerMargin.clone();
        Dimension oldMargin = (Dimension)this.innerMargin.clone();
        int yMargin = -1;
        int y2Margin = -1;
        int xMargin = -1;
        int n = ss = this.yCells != null ? this.yCells.size() : 0;
        if (ss > 0) {
            acm = ((AxisCell)this.yCells.get(0)).getAxisModel();
            dd = acm.getMargin();
            yMargin = dd.height;
            dd.height = 0;
        }
        int n2 = ss = this.y2Cells != null ? this.y2Cells.size() : 0;
        if (ss > 0) {
            acm = ((AxisCell)this.y2Cells.get(0)).getAxisModel();
            dd = acm.getMargin();
            y2Margin = dd.height;
            dd.height = 0;
        }
        int n3 = ss = this.xCells != null ? this.xCells.size() : 0;
        if (ss > 0) {
            acm = ((AxisCell)this.xCells.get(0)).getAxisModel();
            dd = acm.getMargin();
            xMargin = dd.width;
            dd.width = 0;
        }
        super.validateTree();
        if (this.innerMargin.width == 0 && this.innerMargin.height == 0) {
            this.outerMargin.left = oldOuterMargin.left;
            this.outerMargin.top = oldOuterMargin.top;
            this.outerMargin.right = oldOuterMargin.right;
            this.outerMargin.bottom = oldOuterMargin.bottom;
            this.innerMargin.height = oldMargin.height;
            this.innerMargin.width = oldMargin.width;
            if (yMargin != -1) {
                ((AxisCell)this.yCells.get((int)0)).getAxisModel().getMargin().height = yMargin;
            }
            if (y2Margin != -1) {
                ((AxisCell)this.y2Cells.get((int)0)).getAxisModel().getMargin().height = y2Margin;
            }
            if (xMargin != -1) {
                ((AxisCell)this.xCells.get((int)0)).getAxisModel().getMargin().width = xMargin;
            }
        } else {
            Dimension mm;
            if (yMargin != -1) {
                mm = ((AxisCell)this.yCells.get(0)).getAxisModel().getMargin();
                if (mm.height != 0) {
                    this.innerMargin.height = mm.height;
                }
            } else if (y2Margin != -1) {
                mm = ((AxisCell)this.y2Cells.get(0)).getAxisModel().getMargin();
                if (mm.height != 0) {
                    this.innerMargin.height = mm.height;
                }
            }
            if (xMargin != -1) {
                mm = ((AxisCell)this.xCells.get(0)).getAxisModel().getMargin();
                if (mm.width != 0) {
                    this.innerMargin.width = mm.width;
                }
            }
        }
        if (this.xCells == null) {
            int i;
            Double catAxisAdj = new Double(this.outerMargin.bottom);
            int size2 = this.yCells != null ? this.yCells.size() : 0;
            for (i = 0; i < size2; ++i) {
                axisCell = (AxisCell)this.yCells.get(i);
                axisCellModel = axisCell.getAxisModel();
                axisCellModel.setCatAxisAdj(catAxisAdj);
                axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getWidth(), axisCell.getHeight());
            }
            if (size2 > 0) {
                Dimension mm = ((AxisCell)this.yCells.get(0)).getAxisModel().getMargin();
                if (mm.height != 0) {
                    this.innerMargin.height = mm.height;
                }
            }
            size2 = this.y2Cells != null ? this.y2Cells.size() : 0;
            for (i = 0; i < size2; ++i) {
                axisCell = (AxisCell)this.y2Cells.get(i);
                axisCellModel = axisCell.getAxisModel();
                axisCellModel.setCatAxisAdj(catAxisAdj);
                axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getWidth(), axisCell.getHeight());
            }
            if (size2 > 0) {
                Dimension mm = ((AxisCell)this.y2Cells.get(0)).getAxisModel().getMargin();
                if (mm.height != 0) {
                    this.innerMargin.height = mm.height;
                }
            }
        }
        if (this.yCells == null && this.y2Cells == null) {
            Double resAxisAdj = new Double(this.outerMargin.left);
            int size = this.xCells != null ? this.xCells.size() : 0;
            for (int i = 0; i < size; ++i) {
                axisCell = (AxisCell)this.xCells.get(i);
                axisCellModel = axisCell.getAxisModel();
                axisCellModel.setResAxisAdj(resAxisAdj);
                axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getWidth(), axisCell.getHeight());
            }
            if (size > 0) {
                Dimension mm = ((AxisCell)this.xCells.get(0)).getAxisModel().getMargin();
                if (mm.width != 0) {
                    this.innerMargin.width = mm.width;
                }
            }
        }
    }

    private Mapper[] _addLegend(DataSource ds, ScatterPlotCellModel chartCellModel) {
        if (ds == null) {
            return null;
        }
        ScatterPlotMatrixModel chartMatrixModel = chartCellModel.getScatterPlotMatrixModel();
        GraphModel graphModel = chartMatrixModel.getGraphModel();
        ScatterPlotModel scatterPlotModel = chartMatrixModel.getScatterPlotModel();
        DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
        StringVariable groupVariable = (StringVariable)ds.getVariable(chartMatrixModel.getGroupRole(), 0);
        StringVariable shapeVariable = chartCellModel.getShapeRole() == null ? null : (StringVariable)ds.getVariable(chartCellModel.getShapeRole(), 0);
        Variable colorVariable = ds.getVariable(chartCellModel.getColorRole(), 0);
        LineStyle outline = dataElementStyles.getOutlineLineStyle().getVisibilityPolicy() == 10201 ? dataElementStyles.getOutlineLineStyle() : new LineStyle(new Color(0, true));
        Mapper[] mappers = this._needHierarcialLegend(groupVariable, colorVariable, shapeVariable) ? this._addHierarcialLegendCell(scatterPlotModel, dataElementStyles, groupVariable, outline) : this._addRegularLegendCells(ds, chartMatrixModel, scatterPlotModel, dataElementStyles, colorVariable, shapeVariable, outline);
        return mappers;
    }

    private Integer[] _fillLineWidthsArray(StrokeLineStyle[] lineStyles) {
        Integer[] lineWidths = new Integer[lineStyles.length];
        for (int i = 0; i < lineWidths.length; ++i) {
            lineWidths[i] = new Integer((int)lineStyles[i].getThickness().getMagnitude((Object)"py"));
        }
        return lineWidths;
    }

    private Integer[] _fillMarkerSizesArray(MarkerStyle[] markerStyles) {
        Integer[] markerSizes = new Integer[markerStyles.length];
        for (int i = 0; i < markerSizes.length; ++i) {
            markerSizes[i] = new Integer((int)markerStyles[i].getSize().getMagnitude((Object)"py"));
        }
        return markerSizes;
    }

    private Mapper[] _addRegularLegendCells(DataSource ds, ScatterPlotMatrixModel chartMatrixModel, ScatterPlotModel scatterPlotModel, DataElementStyles dataElementStyles, Variable colorVariable, StringVariable shapeVariable, LineStyle outline) {
        Mapper[] mappers = new Mapper[7];
        Color[] cycleColors = dataElementStyles.getDiscreteFillColors();
        boolean lineEnabled = scatterPlotModel.getInterpolationEnabled();
        boolean markerEnabled = scatterPlotModel.getMarkerEnabled();
        boolean fillEnabled = scatterPlotModel.getFillAreaEnabled();
        Boolean antialiasedGraphics = this.graphModel.isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
        Boolean antialiasedText = this.graphModel.isAntialiasedText() ? Boolean.TRUE : Boolean.FALSE;
        MarkerStyle[] markerStyles = dataElementStyles.getMarkerStyles();
        LineStyle[] lineStyles = dataElementStyles.getLineStyles();
        FillStyle[] fillStyles = dataElementStyles.getFillStyles();
        Integer[] markerSizes = this._fillMarkerSizesArray(markerStyles);
        Integer[] lineWidths = this._fillLineWidthsArray((StrokeLineStyle[])lineStyles);
        Color lineColor = lineStyles[0].getColor();
        StringVector labelVector = new StringVector();
        ColorVector colorVector = new ColorVector();
        IntegerVector markerVector = new IntegerVector();
        IntegerVector markerSizeVector = new IntegerVector();
        IntegerVector lineWidthVector = new IntegerVector();
        boolean vectorsCreated = this._createVectorsForLegend(ds, chartMatrixModel, labelVector, colorVector, markerVector, markerSizeVector, lineWidthVector, cycleColors, markerStyles, lineStyles);
        String shapeLegendTitle = this._setupMappersShapeLegend(markerStyles, (StrokeLineStyle[])lineStyles, markerSizes, lineWidths, lineEnabled, markerEnabled, shapeVariable, mappers);
        String legendTitle = colorVariable != null ? colorVariable.getLabel() : null;
        lineColor = this._setupMappersColorLegend(dataElementStyles, markerStyles, (StrokeLineStyle[])lineStyles, fillStyles, colorVariable, mappers, cycleColors, lineColor);
        this._addLegendCell(scatterPlotModel, antialiasedGraphics, antialiasedText, dataElementStyles, markerStyles, (StrokeLineStyle[])lineStyles, markerEnabled, colorVariable, shapeVariable, mappers, outline, labelVector, colorVector, markerVector, vectorsCreated, shapeLegendTitle, legendTitle);
        this._enableMissingValuesLabeling(mappers);
        this._setLegendCellMarkers(dataElementStyles, markerStyles, (StrokeLineStyle[])lineStyles, fillStyles, lineEnabled, markerEnabled, fillEnabled, shapeVariable, cycleColors, lineColor, labelVector);
        return mappers;
    }

    private boolean _needHierarcialLegend(StringVariable groupVariable, Variable colorVariable, StringVariable shapeVariable) {
        return !(!this.dataSource.isOLAPData() || groupVariable == null || colorVariable != null && colorVariable != groupVariable || shapeVariable != null && shapeVariable != groupVariable);
    }

    private void _setLegendCellMarkers(DataElementStyles dataElementStyles, MarkerStyle[] markerStyles, StrokeLineStyle[] lineStyles, FillStyle[] fillStyles, boolean lineEnabled, boolean markerEnabled, boolean fillEnabled, StringVariable shapeVariable, Color[] cycleColors, Color lineColor, StringVector labelVector) {
        if ((lineEnabled || fillEnabled) && (this.shapeLegend != null || this.comboLegend && this.colorLegend != null)) {
            LegendCell lineLegend = this.shapeLegend == null ? this.colorLegend : this.shapeLegend;
            Channel jlegendChannel = lineLegend.getJLegendChannel();
            DiscreteStyleMapModel styleMap = shapeVariable != null ? Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(this.dataSource, (Variable)shapeVariable, dataElementStyles.getDiscreteStyleMapModel()) : null;
            Integer[] markers = this._fillMarkerArray(dataElementStyles, markerStyles, lineStyles, fillStyles, lineEnabled, markerEnabled, fillEnabled, shapeVariable, cycleColors, lineColor, labelVector, jlegendChannel, styleMap);
            if (shapeVariable != null) {
                StringToNumberMapper snm = GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper((Variable)shapeVariable, markers);
                snm.setLabelMissingValues(true);
                lineLegend.setMarkerMapper(snm);
            } else if (labelVector != null) {
                int size = labelVector.size();
                IntegerVector lineVector = new IntegerVector();
                for (int i = 0; i < size; ++i) {
                    lineVector.addValue(markers[i].intValue());
                }
                lineLegend.setMarkerVector(lineVector);
            }
        }
    }

    private Integer[] _fillMarkerArray(DataElementStyles dataElementStyles, MarkerStyle[] markerStyles, StrokeLineStyle[] lineStyles, FillStyle[] fillStyles, boolean lineEnabled, boolean markerEnabled, boolean fillEnabled, StringVariable shapeVariable, Color[] cycleColors, Color lineColor, StringVector labelVector, Channel jlegendChannel, DiscreteStyleMapModel styleMap) {
        int markerArrayLength = shapeVariable != null ? shapeVariable.getUniqueValueCount() : labelVector.size();
        Integer[] markers = new Integer[markerArrayLength];
        for (int ii = 0; ii < markerArrayLength; ++ii) {
            GTKUtil.LineAttributes la;
            Boolean antialiasedGraphics;
            MarkerStyle ms = Util.newCycledMarkerStyle(markerStyles, cycleColors, ii);
            StrokeLineStyle ls = Util.newCycledLineStyle(lineStyles, cycleColors, ii);
            FillStyle fs = Util.newCycledFillStyle(fillStyles, cycleColors, ii);
            if (shapeVariable != null && styleMap != null) {
                try {
                    String fuValue = shapeVariable.formattedUniqueValue.getValue(ii);
                    if (fuValue != null) {
                        String stringValue = fuValue.toString().trim();
                        MarkerStyle markerStyle = ScatterPlotMatrix._getMarkerStyleOverride(styleMap, stringValue);
                        StrokeLineStyle lineStyle = ScatterPlotMatrix._getLineStyleOverride(styleMap, stringValue);
                        Color styleMapColor = ScatterPlotMatrix._getFillStyleColorOverride(styleMap, stringValue);
                        if (markerStyle != null) {
                            ms = markerStyle;
                        }
                        if (lineStyle != null) {
                            ls = lineStyle;
                        }
                        if (styleMapColor != null) {
                            fs.setSolidFillColor(styleMapColor);
                        }
                    }
                }
                catch (MissingValueException fuValue) {
                    // empty catch block
                }
            }
            int type = markerEnabled && ms.isVisible() ? ms.getSymbol() : -1;
            CustomMarker cm = null;
            Boolean bl = antialiasedGraphics = this.graphModel.isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
            if (!fillEnabled) {
                if (ls.getVisibilityPolicy() != 10202) {
                    la = GTKUtil.getLineAttributes(ls);
                    cm = new CustomMarker(jlegendChannel, type, la.stipplePattern, la.stippleFactor, this.comboLegend ? ls.getColor() : lineColor);
                    cm.setMarkerSkinFactory(this.createMarkerSkinFactory());
                    cm.setAntialiasingOn(antialiasedGraphics);
                    markers[ii] = new Integer(jlegendChannel.addCustomMarker((CustomMarkerInterface)cm));
                    continue;
                }
                cm = new CustomMarker(jlegendChannel, type, 0, 1, null);
                cm.setMarkerSkinFactory(this.createMarkerSkinFactory());
                cm.setAntialiasingOn(antialiasedGraphics);
                markers[ii] = new Integer(jlegendChannel.addCustomMarker((CustomMarkerInterface)cm));
                continue;
            }
            if (lineEnabled && ls.getVisibilityPolicy() != 10202) {
                la = GTKUtil.getLineAttributes(ls);
                cm = new CustomMarker(jlegendChannel, type, fs, dataElementStyles.getOutlineLineStyle().getColor(), la.stipplePattern, la.stippleFactor, this.comboLegend ? ls.getColor() : lineColor);
                cm.setMarkerSkinFactory(this.createMarkerSkinFactory());
                cm.setAntialiasingOn(antialiasedGraphics);
                markers[ii] = new Integer(jlegendChannel.addCustomMarker((CustomMarkerInterface)cm));
                continue;
            }
            cm = new CustomMarker(jlegendChannel, type, fs, dataElementStyles.getOutlineLineStyle().getColor(), 0, 1, null);
            cm.setMarkerSkinFactory(this.createMarkerSkinFactory());
            cm.setAntialiasingOn(antialiasedGraphics);
            markers[ii] = new Integer(jlegendChannel.addCustomMarker((CustomMarkerInterface)cm));
        }
        return markers;
    }

    private void _addLegendCell(ScatterPlotModel scatterPlotModel, Boolean antialiasedGraphics, Boolean antialiasedText, DataElementStyles dataElementStyles, MarkerStyle[] markerStyles, StrokeLineStyle[] lineStyles, boolean markerEnabled, Variable colorVariable, StringVariable shapeVariable, Mapper[] mappers, LineStyle outline, StringVector labelVector, ColorVector colorVector, IntegerVector markerVector, boolean vectorsCreated, String shapeLegendTitle, String legendTitle) {
        DiscreteStyleMapModel styleMap;
        Color markerColor;
        boolean both_shapeVariable_colorVariable_specified = shapeVariable != null && colorVariable != null;
        boolean neither_shapeVariable_colorVariable_specified = shapeVariable == null && colorVariable == null;
        boolean only_shapeVariable_specifed = shapeVariable != null && colorVariable == null;
        boolean only_colorVariable_specifed = shapeVariable == null && colorVariable != null;
        Color color = markerColor = markerEnabled ? markerStyles[0].getColor() : lineStyles[0].getColor();
        if (both_shapeVariable_colorVariable_specified) {
            ColorMapper colorMapper;
            ColorMapper colorMapper2 = colorMapper = markerEnabled ? (ColorMapper)mappers[0] : (ColorMapper)mappers[3];
            if (colorVariable instanceof StringVariable) {
                DiscreteStyleMapModel styleMap2 = Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(this.dataSource, (Variable)shapeVariable, dataElementStyles.getDiscreteStyleMapModel());
                ScatterPlotMatrix._applyStyleMapFillStyles(styleMap2, (ColorMapper)mappers[6], (Variable)shapeVariable);
                ScatterPlotMatrix._applyStyleMapMarkerStyles(styleMap2, (ColorMapper)mappers[0], (StringToNumberMapper)mappers[1], (StringToNumberMapper)mappers[2], (Variable)shapeVariable);
                ScatterPlotMatrix._applyStyleMapLineStyles(styleMap2, (StringToColorMapper)mappers[3], (StringToNumberMapper)mappers[5], (StringToNumberMapper)mappers[4], (Variable)shapeVariable);
            }
            if (shapeVariable == colorVariable || colorVariable instanceof StringVariable && shapeVariable.getName().equals(colorVariable.getName())) {
                this._add_OneLegendCell_MapperDriven(scatterPlotModel, colorMapper, legendTitle, (StringToNumberMapper)mappers[1], outline, markerColor, antialiasedGraphics, antialiasedText);
            } else {
                this._add_TwoLegendCells_MapperDriven(scatterPlotModel, colorMapper, legendTitle, (StringToNumberMapper)mappers[1], shapeLegendTitle, outline, markerColor, antialiasedGraphics, antialiasedText);
            }
        }
        if (only_shapeVariable_specifed) {
            if (shapeVariable instanceof StringVariable) {
                styleMap = Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(this.dataSource, (Variable)shapeVariable, dataElementStyles.getDiscreteStyleMapModel());
                ScatterPlotMatrix._applyStyleMapFillStyles(styleMap, (ColorMapper)mappers[6], (Variable)shapeVariable);
                ScatterPlotMatrix._applyStyleMapMarkerStyles(styleMap, (ColorMapper)mappers[0], (StringToNumberMapper)mappers[1], (StringToNumberMapper)mappers[2], (Variable)shapeVariable);
                ScatterPlotMatrix._applyStyleMapLineStyles(styleMap, (StringToColorMapper)mappers[3], (StringToNumberMapper)mappers[5], (StringToNumberMapper)mappers[4], (Variable)shapeVariable);
            }
            this._add_ShapeAndOrColorLegendCells(scatterPlotModel, labelVector, (PipedVector)colorVector, legendTitle, mappers[1], shapeLegendTitle, outline, markerColor, antialiasedGraphics, antialiasedText);
        }
        if (only_colorVariable_specifed) {
            if (colorVariable instanceof StringVariable) {
                styleMap = Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(this.dataSource, (Variable)((StringVariable)colorVariable), dataElementStyles.getDiscreteStyleMapModel());
                ScatterPlotMatrix._applyStyleMapFillStyles(styleMap, (ColorMapper)mappers[6], colorVariable);
                ScatterPlotMatrix._applyStyleMapMarkerStyles(styleMap, (ColorMapper)mappers[0], (StringToNumberMapper)mappers[1], (StringToNumberMapper)mappers[2], colorVariable);
                ScatterPlotMatrix._applyStyleMapLineStyles(styleMap, (StringToColorMapper)mappers[3], (StringToNumberMapper)mappers[5], (StringToNumberMapper)mappers[4], colorVariable);
            }
            this._add_ShapeAndOrColorLegendCells(scatterPlotModel, labelVector, (PipedVector)markerVector, legendTitle, markerEnabled ? mappers[0] : mappers[3], shapeLegendTitle, outline, markerColor, antialiasedGraphics, antialiasedText);
        }
        if (neither_shapeVariable_colorVariable_specified && vectorsCreated) {
            this._add_OneLegendCell_VectorDriven(scatterPlotModel, labelVector, colorVector, markerVector, outline, markerColor, antialiasedGraphics, antialiasedText);
        }
    }

    private Color _setupMappersColorLegend(DataElementStyles dataElementStyles, MarkerStyle[] markerStyles, StrokeLineStyle[] lineStyles, FillStyle[] fillStyles, Variable colorVariable, Mapper[] mappers, Color[] cycleColors, Color lineColor) {
        if (colorVariable != null) {
            Variable legendVariable = colorVariable;
            if (colorVariable instanceof StringVariable) {
                if (this.isLegendToBeSorted(colorVariable)) {
                    NumericVariable v = this.dataSource.getBaseVariable((StringVariable)colorVariable);
                    if (v == null) {
                        v = colorVariable;
                        v.setSortByFormattedValues(true);
                    }
                    v.setUniqueValueSort(1);
                    legendVariable = v;
                }
                mappers[0] = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(legendVariable, markerStyles, cycleColors);
                mappers[3] = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(legendVariable, lineStyles, cycleColors);
                mappers[6] = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(legendVariable, fillStyles, cycleColors);
            } else if (colorVariable instanceof NumericVariable) {
                double[] rangeValues = new double[]{((NumericVariable)colorVariable).getMin(), ((NumericVariable)colorVariable).getMax()};
                Color[] colorScheme = new Color[]{dataElementStyles.getContinuousFillTwoColorStartColor(), dataElementStyles.getContinuousFillTwoColorEndColor()};
                ContinuousRangeToColorMapper colorMapper = new ContinuousRangeToColorMapper();
                colorMapper.input.connectFrom(((NumericVariable)colorVariable).value);
                colorMapper.setColorSpectrumColors(colorScheme);
                colorMapper.setColorSpectrumValues(rangeValues);
                mappers[0] = colorMapper;
                mappers[3] = colorMapper;
                mappers[6] = colorMapper;
                return colorScheme[0];
            }
        }
        return lineColor;
    }

    private String _setupMappersShapeLegend(MarkerStyle[] markerStyles, StrokeLineStyle[] lineStyles, Integer[] markerSizes, Integer[] lineWidths, boolean lineEnabled, boolean markerEnabled, StringVariable shapeVariable, Mapper[] mappers) {
        String shapeLegendTitle = null;
        if (shapeVariable != null) {
            StringVariable legendVariable = shapeVariable;
            if (this.isLegendToBeSorted((Variable)shapeVariable)) {
                NumericVariable baseShapeVariable = this.dataSource.getBaseVariable(shapeVariable);
                if (baseShapeVariable == null) {
                    baseShapeVariable = shapeVariable;
                    baseShapeVariable.setSortByFormattedValues(true);
                }
                baseShapeVariable.setUniqueValueSort(1);
                legendVariable = baseShapeVariable;
            }
            shapeLegendTitle = shapeVariable.getLabel();
            if (markerEnabled) {
                mappers[1] = GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper((Variable)legendVariable, markerStyles);
                mappers[2] = GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper((Variable)legendVariable, markerSizes);
            }
            if (lineEnabled) {
                mappers[4] = GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper((Variable)legendVariable, lineStyles);
                mappers[5] = GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper((Variable)legendVariable, lineWidths);
            }
        }
        return shapeLegendTitle;
    }

    private boolean _createVectorsForLegend(DataSource ds, ScatterPlotMatrixModel chartMatrixModel, StringVector labelVector, ColorVector colorVector, IntegerVector markerVector, IntegerVector markerSizeVector, IntegerVector lineWidthVector, Color[] cycleColors, MarkerStyle[] markerStyles, LineStyle[] lineStyles) {
        boolean vectorsCreated = false;
        Variable[] xVariableArray = ds.getVariable(chartMatrixModel.getXRole());
        Variable[] yVariableArray = ds.getVariable(chartMatrixModel.getYRole());
        Variable[] y2VariableArray = ds.getVariable(chartMatrixModel.getY2Role());
        int xVariableArraySize = xVariableArray == null || xVariableArray.length < 2 ? 0 : xVariableArray.length;
        int yVariableArraySize = 0;
        int yVariableArraySize_combined = 0;
        if (yVariableArray != null && yVariableArray.length > 0) {
            yVariableArraySize = yVariableArraySize_combined = yVariableArray.length;
        }
        if (y2VariableArray != null && y2VariableArray.length > 0) {
            yVariableArraySize_combined += y2VariableArray.length;
        }
        if (xVariableArraySize > 1 || yVariableArraySize_combined > 1) {
            int index = 0;
            if (xVariableArraySize > 1 && yVariableArraySize_combined > 1) {
                int overlaySize = Math.max(xVariableArraySize, yVariableArraySize_combined);
                for (index = 0; index < overlaySize; ++index) {
                    String label = this._createOverlayLabel(index, xVariableArraySize, yVariableArraySize, yVariableArraySize_combined, xVariableArray, yVariableArray, y2VariableArray);
                    if (label == null) continue;
                    this._fillVectorsForLegend(labelVector, label, colorVector, markerVector, markerSizeVector, lineWidthVector, cycleColors, markerStyles, lineStyles, index);
                }
            } else if (xVariableArraySize > 1) {
                for (index = 0; index < xVariableArray.length; ++index) {
                    String label = xVariableArray[index].getLabel();
                    this._fillVectorsForLegend(labelVector, label, colorVector, markerVector, markerSizeVector, lineWidthVector, cycleColors, markerStyles, lineStyles, index);
                }
            } else {
                String label;
                for (index = 0; index < yVariableArraySize; ++index) {
                    label = yVariableArray[index].getLabel();
                    this._fillVectorsForLegend(labelVector, label, colorVector, markerVector, markerSizeVector, lineWidthVector, cycleColors, markerStyles, lineStyles, index);
                }
                while (index < yVariableArraySize_combined) {
                    label = y2VariableArray[index - yVariableArraySize].getLabel();
                    this._fillVectorsForLegend(labelVector, label, colorVector, markerVector, markerSizeVector, lineWidthVector, cycleColors, markerStyles, lineStyles, index);
                    ++index;
                }
            }
            if (labelVector.size() > 0 || colorVector.size() > 0 || markerVector.size() > 0 || markerSizeVector.size() > 0 || lineWidthVector.size() > 0) {
                vectorsCreated = true;
            }
        }
        return vectorsCreated;
    }

    private void _enableMissingValuesLabeling(Mapper[] mappers) {
        StringToNumberMapper numericMapper;
        StringToNumberMapper numberMapper;
        ColorMapper colorMapper;
        if (mappers[0] != null) {
            colorMapper = (ColorMapper)mappers[0];
            colorMapper.setReplaceMissingValues(true);
            colorMapper.setLabelMissingValues(true);
        }
        if (mappers[3] != null) {
            colorMapper = (ColorMapper)mappers[3];
            colorMapper.setLabelMissingValues(true);
        }
        if (mappers[6] != null) {
            colorMapper = (ColorMapper)mappers[6];
            colorMapper.setLabelMissingValues(true);
        }
        if (mappers[1] != null) {
            numberMapper = (StringToNumberMapper)mappers[1];
            numberMapper.setLabelMissingValues(true);
        }
        if (mappers[4] != null) {
            numericMapper = (StringToNumberMapper)mappers[4];
            numericMapper.setLabelMissingValues(true);
        }
        if (mappers[2] != null) {
            numberMapper = (StringToNumberMapper)mappers[2];
            numberMapper.setLabelMissingValues(true);
        }
        if (mappers[5] != null) {
            numericMapper = (StringToNumberMapper)mappers[5];
            numericMapper.setLabelMissingValues(true);
        }
    }

    private String _createOverlayLabel(int index, int xVariableArraySize, int yVariableArraySize, int yVariableArraySize_combined, Variable[] xVariableArray, Variable[] yVariableArray, Variable[] y2VariableArray) {
        String[] labels = new String[]{index < xVariableArraySize ? xVariableArray[index].getLabel() : null, index < yVariableArraySize ? yVariableArray[index].getLabel() : (index < yVariableArraySize_combined ? y2VariableArray[index - yVariableArraySize].getLabel() : null)};
        if (labels[0] == null) {
            String x = com.sas.graphics.components.RB.getStringResource("Graph.", "xRole.txt");
            String message = Message.format((String)RB.getStringResource(RB_KEY, "unEqualRoles.ex.fmt.txt"), (Object)x);
            System.err.println(message);
            return null;
        }
        if (labels[1] == null) {
            String y = com.sas.graphics.components.RB.getStringResource("Graph.", "yRole.txt");
            String message = Message.format((String)RB.getStringResource(RB_KEY, "unEqualRoles.ex.fmt.txt"), (Object)y);
            System.err.println(message);
            return null;
        }
        return Message.format((String)RB.getStringResource(RB_KEY, "versus.fmt.txt"), (Object)labels[0], (Object)labels[1]);
    }

    private void _fillVectorsForLegend(StringVector nameVector, String name, ColorVector colorVector, IntegerVector markerVector, IntegerVector markerSizeVector, IntegerVector lineWidthVector, Color[] cycleColors, MarkerStyle[] markerStyles, LineStyle[] lineStyles, int index) {
        nameVector.addValue(name);
        MarkerStyle ms = Util.newCycledMarkerStyle(markerStyles, cycleColors, index);
        if (ms.isVisible()) {
            markerVector.addValue(ms.getSymbol());
        } else {
            markerVector.addValue(-1);
        }
        colorVector.addValue(ms.getColor());
        markerSizeVector.addValue((int)ms.getSize().getMagnitude((Object)"py"));
        LineStyle ls = Util.newCycledLineStyle(lineStyles, cycleColors, index);
        lineWidthVector.addValue((int)ls.getThickness().getMagnitude((Object)"py"));
    }

    private boolean isLegendToBeSorted(Variable variable) {
        OLAPLevelVariable olv;
        boolean result = true;
        if (variable instanceof OLAPLevelVariable && (olv = (OLAPLevelVariable)variable).getDimensionType() == 1) {
            result = false;
        }
        return result;
    }

    private Mapper[] _addHierarcialLegendCell(ScatterPlotModel scatterPlotModel, DataElementStyles dataElementStyles, StringVariable groupVariable, LineStyle outline) {
        String key;
        Enumeration iter;
        Hashtable table;
        StringToNumberMapper snm2;
        StringToNumberMapper snm;
        StringToColorMapper scm;
        FillStyle backgroundFillStyle;
        Container parent;
        Mapper[] mappers = new Mapper[7];
        boolean lineEnabled = scatterPlotModel.getInterpolationEnabled();
        boolean markerEnabled = scatterPlotModel.getMarkerEnabled();
        boolean fillEnabled = scatterPlotModel.getFillAreaEnabled();
        Boolean antialiasedGraphics = this.graphModel.isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
        Boolean antialiasedText = this.graphModel.isAntialiasedText() ? Boolean.TRUE : Boolean.FALSE;
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        Color backgroundColor = (backgroundFillStyle = scatterPlotModel.getColorLegendModel().getBackgroundFillStyle()).isVisible() ? backgroundFillStyle.getSolidFillColor() : null;
        AbstractMarkerSkinFactory factory = this.createMarkerSkinFactory();
        ValuePane.MultiStyleValueComponentFactory valueComponentFactory = Util.createMultiStyleValueComponentFactory(this.getGroupValueTree(), scatterPlotModel.getColorLegendModel().getValueTextStyle(), dataElementStyles, fillEnabled, markerEnabled, lineEnabled, this.dataSource.getDataSourceSelectionModel(), actionProvider, groupVariable, 1, this, backgroundColor, this.getChannel(), factory);
        if (markerEnabled) {
            scm = new StringToColorMapper();
            snm = new StringToNumberMapper();
            snm2 = new StringToNumberMapper();
            table = new Hashtable(valueComponentFactory.getFormattedValue2MarkerStyleMap());
            iter = table.keys();
            while (iter.hasMoreElements()) {
                key = (String)iter.nextElement();
                MarkerStyle ms = (MarkerStyle)table.get(key);
                scm.add(key, ms.getColor());
                snm.add(key, (Number)new Integer(ms.getSymbol()));
                snm2.add(key, (Number)new Integer((int)ms.getSize().getMagnitude((Object)"py")));
            }
            scm.input.connectFrom(groupVariable.formattedValue);
            snm.input.connectFrom(groupVariable.formattedValue);
            snm2.input.connectFrom(groupVariable.formattedValue);
            mappers[0] = scm;
            mappers[1] = snm;
            mappers[2] = snm2;
            mappers[3] = scm;
            mappers[6] = scm;
        }
        if (lineEnabled) {
            scm = new StringToColorMapper();
            snm = new StringToNumberMapper();
            snm2 = new StringToNumberMapper();
            table = new Hashtable(valueComponentFactory.getFormattedValue2LineStyleMap());
            iter = table.keys();
            while (iter.hasMoreElements()) {
                key = (String)iter.nextElement();
                StrokeLineStyle ls = (StrokeLineStyle)table.get(key);
                scm.add(key, ls.getColor());
                snm.add(key, (Number)new Integer(ls.getSASGraphLineStyle()));
                snm2.add(key, (Number)new Integer((int)ls.getThickness().getMagnitude((Object)"py")));
            }
            scm.input.connectFrom(groupVariable.formattedValue);
            snm.input.connectFrom(groupVariable.formattedValue);
            snm2.input.connectFrom(groupVariable.formattedValue);
            mappers[3] = scm;
            mappers[4] = snm;
            mappers[5] = snm2;
        }
        if (fillEnabled) {
            scm = new StringToColorMapper();
            Hashtable table2 = new Hashtable(valueComponentFactory.getFormattedValue2FillStyleMap());
            Enumeration iter2 = table2.keys();
            while (iter2.hasMoreElements()) {
                String key2 = (String)iter2.nextElement();
                FillStyle fs = (FillStyle)table2.get(key2);
                scm.add(key2, fs.getSolidFillColor());
            }
            scm.input.connectFrom(groupVariable.formattedValue);
            mappers[6] = scm;
            if (!markerEnabled && !lineEnabled) {
                mappers[0] = scm;
                mappers[3] = scm;
            }
        }
        if (!(markerEnabled || lineEnabled || fillEnabled)) {
            scm = new StringToColorMapper();
            scm.input.connectFrom(groupVariable.formattedValue);
            mappers[0] = scm;
            mappers[3] = scm;
            mappers[6] = scm;
        }
        LegendCellModel lcm = new LegendCellModel(this.createMarkerSkinFactory());
        lcm.setLegendModel(scatterPlotModel.getColorLegendModel());
        lcm.setAntialiasedGraphics(antialiasedGraphics);
        lcm.setAntialiasedText(antialiasedText);
        lcm.setMarkerOutlineLineStyle(outline);
        lcm.setDefaultLabel(groupVariable.getLabel());
        lcm.setTitleMarker(this.drillMarker);
        int placement = scatterPlotModel.getColorLegendModel().getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
        lcm.setPlacement(new Integer(placement));
        HierarchicalLegendCell legendCell = new HierarchicalLegendCell(this.getGroupValueTree(), lcm, valueComponentFactory, actionProvider, 4, this.getChannel());
        this.colorLegend = legendCell;
        this.addLegend(legendCell, placement);
        this.comboLegend = true;
        return mappers;
    }

    private void _add_OneLegendCell_VectorDriven(ScatterPlotModel scatterPlotModel, StringVector nameVector, ColorVector colorVector, IntegerVector markerVector, LineStyle outlineLineStyle, Color color, Boolean antialiasedGraphics, Boolean antialiasedText) {
        LegendModel legModel = scatterPlotModel.getColorLegendModel();
        if (!legModel.isVisible()) {
            return;
        }
        LegendCellModel lcm = new LegendCellModel(this.createMarkerSkinFactory());
        lcm.setLegendModel(legModel);
        lcm.setAntialiasedGraphics(antialiasedGraphics);
        lcm.setAntialiasedText(antialiasedText);
        lcm.setMarkerOutlineLineStyle(outlineLineStyle);
        lcm.setTitleMarker(this.drillMarker);
        lcm.setStringVector(nameVector);
        lcm.setColorVector(colorVector);
        lcm.setMarkerVector(markerVector);
        int placement = legModel.getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
        lcm.setPlacement(new Integer(placement));
        this.colorLegend = new LegendCell(lcm, this.getChannel());
        this.addLegend(this.colorLegend, placement);
    }

    private void _add_OneLegendCell_MapperDriven(ScatterPlotModel scatterPlotModel, ColorMapper colorMapper, String legendTitle, StringToNumberMapper numberMapper, LineStyle outline, Color markerColor, Boolean antialiasedGraphics, Boolean antialiasedText) {
        LegendModel legModel = scatterPlotModel.getColorLegendModel();
        if (!legModel.isVisible()) {
            return;
        }
        LegendCellModel lcm = new LegendCellModel(this.createMarkerSkinFactory());
        lcm.setColorMapper(colorMapper);
        lcm.setMarkerMapper(numberMapper);
        lcm.setMarkerOutlineLineStyle(outline);
        lcm.setTitleMarker(this.drillMarker);
        lcm.setAntialiasedText(antialiasedText);
        lcm.setAntialiasedGraphics(antialiasedGraphics);
        String label = legModel.getLabel();
        if (label != null) {
            lcm.setDefaultLabel(label);
        } else {
            lcm.setDefaultLabel(legendTitle);
        }
        lcm.setLegendModel(legModel);
        lcm.setMarkerColor(markerColor);
        int placement = legModel.getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
        lcm.setPlacement(new Integer(placement));
        this.colorLegend = new LegendCell(lcm, this.getChannel());
        this.addLegend(this.colorLegend, placement);
    }

    private void _add_ShapeAndOrColorLegendCells(ScatterPlotModel scatterPlotModel, StringVector nameVector, PipedVector objVector, String legendTitle, Mapper mapper, String shapeLegendTitle, LineStyle outline, Color markerColor, Boolean antialiasedGraphics, Boolean antialiasedText) {
        String label;
        LegendModel legModel = scatterPlotModel.getColorLegendModel();
        LegendModel legModel2 = scatterPlotModel.getElementLegendModel();
        CellModel colorCell = null;
        CellModel shapeCell = null;
        this.comboLegend = false;
        if (objVector.size() > 0) {
            if (objVector instanceof ColorVector) {
                if (legModel.isVisible()) {
                    colorCell = new LegendCellModel(this.createMarkerSkinFactory());
                    ((LegendCellModel)colorCell).setColorVector((ColorVector)objVector);
                    ((LegendCellModel)colorCell).setStringVector(nameVector);
                    ((LegendCellModel)colorCell).setTitleMarker(this.drillMarker);
                }
            } else if (objVector instanceof IntegerVector && legModel2.isVisible()) {
                shapeCell = new LegendCellModel(this.createMarkerSkinFactory());
                ((LegendCellModel)shapeCell).setMarkerVector((IntegerVector)objVector);
                ((LegendCellModel)shapeCell).setStringVector(nameVector);
                ((LegendCellModel)shapeCell).setTitleMarker(this.drillMarker);
            }
        }
        if (mapper instanceof ColorMapper) {
            if (legModel.isVisible()) {
                colorCell = new LegendCellModel(this.createMarkerSkinFactory());
                ((LegendCellModel)colorCell).setColorMapper((ColorMapper)mapper);
                ((LegendCellModel)colorCell).setTitleMarker(this.drillMarker);
            }
        } else if (mapper instanceof StringToNumberMapper && legModel2.isVisible()) {
            shapeCell = new LegendCellModel(this.createMarkerSkinFactory());
            ((LegendCellModel)shapeCell).setMarkerMapper((StringToNumberMapper)mapper);
            ((LegendCellModel)shapeCell).setTitleMarker(this.drillMarker);
        }
        if (colorCell != null) {
            colorCell.setAntialiasedGraphics(antialiasedGraphics);
            colorCell.setAntialiasedText(antialiasedText);
            ((LegendCellModel)colorCell).setMarkerOutlineLineStyle(outline);
            label = legModel.getLabel();
            if (label != null) {
                ((LegendCellModel)colorCell).setDefaultLabel(label);
            } else {
                ((LegendCellModel)colorCell).setDefaultLabel(legendTitle);
            }
            ((LegendCellModel)colorCell).setLegendModel(legModel);
        }
        if (shapeCell != null) {
            shapeCell.setAntialiasedGraphics(antialiasedGraphics);
            shapeCell.setAntialiasedText(antialiasedText);
            ((LegendCellModel)shapeCell).setMarkerColor(markerColor);
            ((LegendCellModel)shapeCell).setMarkerOutlineLineStyle(outline);
            label = legModel2.getLabel();
            if (label != null) {
                ((LegendCellModel)shapeCell).setDefaultLabel(label);
            } else {
                ((LegendCellModel)shapeCell).setDefaultLabel(shapeLegendTitle);
            }
            ((LegendCellModel)shapeCell).setLegendModel(legModel2);
        }
        if (colorCell != null && shapeCell != null) {
            int position1 = legModel.getPlacement();
            if (position1 == 10200) {
                position1 = 5;
            }
            ((LegendCellModel)colorCell).setOrientation(new Integer(position1 == 7 || position1 == 3 ? 1 : 0));
            this.colorLegend = new LegendCell((LegendCellModel)colorCell, this.getChannel());
            this.addLegend(this.colorLegend, position1);
            int position2 = legModel2.getPlacement();
            if (position2 == 10200) {
                position2 = 5;
            }
            ((LegendCellModel)shapeCell).setOrientation(new Integer(position2 == 7 || position2 == 3 ? 1 : 0));
            this.shapeLegend = new LegendCell((LegendCellModel)shapeCell, this.getChannel());
            this.addLegend(this.shapeLegend, position2);
        } else if (colorCell != null) {
            int position1 = legModel.getPlacement();
            if (position1 == 10200) {
                position1 = 5;
            }
            ((LegendCellModel)colorCell).setOrientation(new Integer(position1 == 7 || position1 == 3 ? 1 : 0));
            this.colorLegend = new LegendCell((LegendCellModel)colorCell, this.getChannel());
            this.addLegend(this.colorLegend, legModel.getPlacement());
        } else if (shapeCell != null) {
            int position1 = legModel2.getPlacement();
            if (position1 == 10200) {
                position1 = 5;
            }
            ((LegendCellModel)shapeCell).setOrientation(new Integer(position1 == 7 || position1 == 3 ? 1 : 0));
            this.shapeLegend = new LegendCell((LegendCellModel)shapeCell, this.getChannel());
            this.addLegend(this.shapeLegend, legModel2.getPlacement());
        }
    }

    private void _add_TwoLegendCells_MapperDriven(ScatterPlotModel scatterPlotModel, ColorMapper colorMapper, String legendTitle, StringToNumberMapper numberMapper, String shapeLegendTitle, LineStyle outline, Color markerColor, Boolean antialiasedGraphics, Boolean antialiasedText) {
        LegendModel legModel = scatterPlotModel.getColorLegendModel();
        boolean colorVisible = legModel.isVisible() && colorMapper != null;
        LegendCellModel colorCell = null;
        if (colorVisible) {
            colorCell = new LegendCellModel(this.createMarkerSkinFactory());
            colorCell.setAntialiasedGraphics(antialiasedGraphics);
            colorCell.setAntialiasedText(antialiasedText);
            colorCell.setColorMapper(colorMapper);
            colorCell.setTitleMarker(this.drillMarker);
            colorCell.setMarkerOutlineLineStyle(outline);
            String label = legModel.getLabel();
            if (label != null) {
                colorCell.setDefaultLabel(label);
            } else {
                colorCell.setDefaultLabel(legendTitle);
            }
            colorCell.setLegendModel(legModel);
        }
        LegendModel legModel2 = scatterPlotModel.getElementLegendModel();
        boolean shapeVisible = legModel.isVisible() && numberMapper != null;
        LegendCellModel shapeCell = null;
        if (shapeVisible) {
            shapeCell = new LegendCellModel(this.createMarkerSkinFactory());
            shapeCell.setAntialiasedGraphics(antialiasedGraphics);
            shapeCell.setAntialiasedText(antialiasedText);
            shapeCell.setMarkerMapper(numberMapper);
            shapeCell.setTitleMarker(this.drillMarker);
            shapeCell.setColorMapper(null);
            shapeCell.setMarkerColor(markerColor);
            shapeCell.setMarkerOutlineLineStyle(outline);
            String label = legModel2.getLabel();
            if (label != null) {
                shapeCell.setDefaultLabel(label);
            } else {
                shapeCell.setDefaultLabel(shapeLegendTitle);
            }
            shapeCell.setLegendModel(legModel2);
        }
        if (colorVisible && shapeVisible) {
            int position1 = legModel.getPlacement();
            if (position1 == 10200) {
                position1 = 5;
            }
            colorCell.setOrientation(new Integer(position1 == 7 || position1 == 3 ? 1 : 0));
            this.colorLegend = new LegendCell(colorCell, this.getChannel());
            this.addLegend(this.colorLegend, position1);
            int position2 = legModel2.getPlacement();
            if (position2 == 10200) {
                position2 = 5;
            }
            shapeCell.setOrientation(new Integer(position2 == 7 || position2 == 3 ? 1 : 0));
            this.shapeLegend = new LegendCell(shapeCell, this.getChannel());
            this.addLegend(this.shapeLegend, position2);
        } else if (colorVisible) {
            int position1 = legModel.getPlacement();
            if (position1 == 10200) {
                position1 = 5;
            }
            colorCell.setOrientation(new Integer(position1 == 7 || position1 == 3 ? 1 : 0));
            this.colorLegend = new LegendCell(colorCell, this.getChannel());
            this.addLegend(this.colorLegend, legModel.getPlacement());
        } else if (shapeVisible) {
            int position2 = legModel2.getPlacement();
            if (position2 == 10200) {
                position2 = 5;
            }
            shapeCell.setOrientation(new Integer(position2 == 7 || position2 == 3 ? 1 : 0));
            this.shapeLegend = new LegendCell(shapeCell, this.getChannel());
            this.addLegend(this.shapeLegend, legModel2.getPlacement());
        }
    }

    private void checkLowHighVariables(Variable[] list, Variable[] lowList, Variable[] highList, String role, DataSource dataSource) {
        int i;
        if (list == null) {
            return;
        }
        int len = lowList != null ? lowList.length : 0;
        boolean validLow = false;
        for (int i2 = 0; i2 < len; ++i2) {
            if (lowList[i2] != null && list[i2] instanceof StringVariable) {
                String mainLabel = list[i2].getLabel();
                String errorLabel = lowList[i2].getLabel();
                String localizedRole = com.sas.graphics.components.RB.getStringResource("Graph.", "lowError.txt");
                String message = Message.format((String)RB.getStringResource("invalidErrorVariable.ex.fmt.txt"), (Object)mainLabel, (Object)localizedRole, (Object)errorLabel);
                System.err.println(message);
                dataSource.removeVariable(lowList[i2]);
                continue;
            }
            if (lowList[i2] == null) continue;
            validLow = true;
        }
        len = highList != null ? highList.length : 0;
        boolean validHigh = false;
        for (i = 0; i < len; ++i) {
            if (highList[i] != null && list[i] instanceof StringVariable) {
                String mainLabel = list[i].getLabel();
                String errorLabel = highList[i].getLabel();
                String localizedRole = com.sas.graphics.components.RB.getStringResource("Graph.", "highError.txt");
                String message = Message.format((String)RB.getStringResource("invalidErrorVariable.ex.fmt.txt"), (Object)mainLabel, (Object)localizedRole, (Object)errorLabel);
                System.err.println(message);
                dataSource.removeVariable(highList[i]);
                continue;
            }
            if (highList[i] == null) continue;
            validHigh = true;
        }
        len = list.length;
        if (validHigh || validLow) {
            for (i = 0; i < len; ++i) {
                if (lowList[i] != null || highList[i] != null || !(list[i] instanceof StringVariable)) continue;
                String message = Message.format((String)RB.getStringResource("invalidErrorVariableList.ex.fmt.txt"), (Object)role);
                System.err.println(message);
                for (int ii = 0; ii < len; ++ii) {
                    if (lowList[ii] != null) {
                        dataSource.removeVariable(lowList[ii]);
                    }
                    if (highList[ii] == null) continue;
                    dataSource.removeVariable(highList[ii]);
                }
                break;
            }
        }
    }

    @Override
    protected ArrayList addMatrixCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource) {
        Container parent;
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        ScatterPlotMatrixModel scatterPlotMatrixModel = (ScatterPlotMatrixModel)this.getMatrixModel();
        this.matrixContainer = new ScatterPlotMatrixContainer(this.model, dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), new ScatterPlotCellComponentFactory(this.scatterPlotCellModel, dataSource[0], dataSource[1]), new AxisCellComponentFactory(this.scatterPlotCellModel.getXAxisCellModel()), new AxisCellComponentFactory(this.scatterPlotCellModel.getYAxisCellModel()), new AxisCellComponentFactory(this.scatterPlotCellModel.getY2AxisCellModel()), this.getMessageModel(), actionProvider, false, scatterPlotMatrixModel.getGraphModel().isAntialiasedGraphics(), scatterPlotMatrixModel.getGraphModel().isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        ArrayList<Component> cells = new ArrayList<Component>();
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    @Override
    protected ArrayList addRowTabletCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        ArrayList<JComponent> cellList = new ArrayList<JComponent>();
        if (this.matrixContainer != null) {
            DefaultMutableTreeNode[] rowOrdinals = this.getRowValueTree() != null ? this.getRowValueTree().getLeafNodes() : null;
            int rowCount = rowOrdinals == null ? 1 : rowOrdinals.length;
            for (int jj = 0; jj < rowCount; ++jj) {
                DefaultMutableTreeNode rowOrdinal = rowOrdinals == null ? null : rowOrdinals[jj];
                JComponent cell = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
                MatrixContainer.TabletCellIdentifier tabletCellIdentifier = new MatrixContainer.TabletCellIdentifier();
                tabletCellIdentifier.ordinal = rowOrdinal;
                cellList.add(cell);
            }
        } else if (this.matrixContainer != null) {
            JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
            this.matrixContainer.add((Component)cellComponent, (Object)(primary ? "West" : "East"));
            cellList.add(cellComponent);
        }
        return cellList;
    }

    @Override
    protected ArrayList addColumnTabletCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        ArrayList<JComponent> cellList = new ArrayList<JComponent>();
        if (this.matrixContainer != null) {
            DefaultMutableTreeNode[] columnOrdinals = this.getColumnValueTree() != null ? this.getColumnValueTree().getLeafNodes() : null;
            int columnCount = columnOrdinals == null ? 1 : columnOrdinals.length;
            for (int jj = 0; jj < columnCount; ++jj) {
                DefaultMutableTreeNode columnOrdinal = columnOrdinals == null ? null : columnOrdinals[jj];
                JComponent cell = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
                MatrixContainer.TabletCellIdentifier tabletCellIdentifier = new MatrixContainer.TabletCellIdentifier();
                tabletCellIdentifier.ordinal = columnOrdinal;
                cellList.add(cell);
            }
        } else if (this.matrixContainer != null) {
            JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
            this.matrixContainer.add((Component)cellComponent, (Object)(primary ? "West" : "East"));
            cellList.add(cellComponent);
        }
        return cellList;
    }

    @Override
    protected void resetTrees() {
        super.resetTrees();
        this.groupValueTree = null;
    }

    protected ValueTree getGroupValueTree() {
        if (this.groupValueTree == null) {
            this.createGroupTree();
        }
        return this.groupValueTree;
    }

    private void createGroupTree() {
        ValueTree[] trees = ValueTree.createTrees(this.dataSource, ((ScatterPlotMatrixModel)this.getMatrixModel()).getGroupRole(), null);
        this.groupValueTree = trees[0];
    }

    private static void _applyStyleMapFillStyles(DiscreteStyleMapModel styleMap, ColorMapper colorMapper, Variable variable) {
        if (colorMapper instanceof StringToColorMapper) {
            for (int i = 0; i < variable.getValueCount(); ++i) {
                Object value = Variable.getValue((Variable)variable, (int)i, (boolean)true);
                if (value == null) continue;
                value = value.toString().trim();
                Color styleMapColor = ScatterPlotMatrix._getFillStyleColorOverride(styleMap, value);
                if (colorMapper == null || styleMapColor == null) continue;
                ((StringToColorMapper)colorMapper).add((String)value, styleMapColor);
            }
        }
    }

    private static void _applyStyleMapMarkerStyles(DiscreteStyleMapModel styleMap, ColorMapper colorMapper, StringToNumberMapper symbolMapper, StringToNumberMapper sizeMapper, Variable variable) {
        for (int i = 0; i < variable.getValueCount(); ++i) {
            MarkerStyle markerStyle;
            Object value = Variable.getValue((Variable)variable, (int)i, (boolean)true);
            if (value == null || (markerStyle = ScatterPlotMatrix._getMarkerStyleOverride(styleMap, value = value.toString().trim())) == null) continue;
            if (symbolMapper != null) {
                symbolMapper.add((String)value, (Number)new Integer(markerStyle.getSymbol()));
            }
            if (sizeMapper != null) {
                sizeMapper.add((String)value, (Number)new Double(markerStyle.getSize().getMagnitude((Object)"pt")));
            }
            if (colorMapper == null || markerStyle.getColor() == null) continue;
            ((StringToColorMapper)colorMapper).add((String)value, markerStyle.getColor());
        }
    }

    private static void _applyStyleMapLineStyles(DiscreteStyleMapModel styleMap, StringToColorMapper colorMapper, StringToNumberMapper sizeMapper, StringToNumberMapper styleMapper, Variable variable) {
        for (int i = 0; i < variable.getValueCount(); ++i) {
            String stringValue;
            StrokeLineStyle lineStyle;
            Object value = Variable.getValue((Variable)variable, (int)i, (boolean)true);
            if (value == null || (lineStyle = ScatterPlotMatrix._getLineStyleOverride(styleMap, stringValue = value.toString().trim())) == null) continue;
            if (colorMapper != null) {
                colorMapper.add(stringValue, lineStyle.getColor());
            }
            if (sizeMapper != null) {
                sizeMapper.add(stringValue, (Number)new Double(lineStyle.getThickness().getMagnitude((Object)"px")));
            }
            if (styleMapper == null) continue;
            styleMapper.add(stringValue, (Number)new Integer(lineStyle.getSASGraphLineStyle()));
        }
    }

    private static Color _getFillStyleColorOverride(DiscreteStyleMapModel styleMap, Object dataValue) {
        DiscreteStyle discreteStyle;
        if (styleMap != null && (discreteStyle = styleMap.get(dataValue)) != null && discreteStyle.getFillStyle() != null) {
            return discreteStyle.getFillStyle().getSolidFillColor();
        }
        return null;
    }

    private static MarkerStyle _getMarkerStyleOverride(DiscreteStyleMapModel styleMap, Object dataValue) {
        DiscreteStyle discreteStyle;
        if (styleMap != null && (discreteStyle = styleMap.get(dataValue)) != null && discreteStyle.getMarkerStyle() != null) {
            return discreteStyle.getMarkerStyle();
        }
        return null;
    }

    private static StrokeLineStyle _getLineStyleOverride(DiscreteStyleMapModel styleMap, Object dataValue) {
        DiscreteStyle discreteStyle;
        if (styleMap != null && (discreteStyle = styleMap.get(dataValue)) != null && discreteStyle.getLineStyle() != null) {
            return discreteStyle.getLineStyle();
        }
        return null;
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.plotCells != null) {
            for (int ii = 0; ii < this.plotCells.size(); ++ii) {
                ((ScatterPlotCell)this.plotCells.get(ii)).setAnimationFrame(animationPosition);
            }
        }
    }

    public void selectionChanged() {
        if (this.plotCells != null) {
            int cellCount = this.plotCells.size();
            for (int i = 0; i < cellCount; ++i) {
                ScatterPlotCell cell = (ScatterPlotCell)this.plotCells.get(i);
                cell.selectionChanged();
            }
        }
    }

    public AbstractMarkerSkinFactory createMarkerSkinFactory() {
        if (this.getModel().getScatterPlotModel().getSkin() == null) {
            return null;
        }
        int i = this.getModel().getScatterPlotModel().getSkin();
        return BIPMarkerSkinFactory.getInstance(i);
    }

    private class ScatterPlotCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final DataSource dataSource;
        private final DataSource selectionDataSource;
        private final ScatterPlotCellModel cellModel;
        private final Object animationKeyFrameRole;
        private final Object animationIDRole;

        public ScatterPlotCellComponentFactory(ScatterPlotCellModel cellModel, DataSource dataSource, DataSource selectionDataSource) {
            if (cellModel == null) {
                throw new IllegalStateException("null ScatterPlotCellModel not supported.");
            }
            this.cellModel = cellModel;
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            Variable[] animationKeyFrameVariables = dataSource.getVariable(cellModel.getAnimationKeyFrameRole());
            Variable[] animationIDVariables = dataSource.getVariable(cellModel.getAnimationIdentificationRole());
            if (animationKeyFrameVariables == null || animationIDVariables == null) {
                this.animationKeyFrameRole = null;
                this.animationIDRole = null;
            } else {
                this.animationKeyFrameRole = cellModel.getAnimationKeyFrameRole();
                this.animationIDRole = cellModel.getAnimationIdentificationRole();
            }
            this.dataSource = dataSource;
            this.selectionDataSource = selectionDataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode), (boolean)true);
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                DataSource cellSelectionDataSource = null;
                if (this.selectionDataSource != null) {
                    whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode), (boolean)false);
                    cellSelectionDataSource = this.selectionDataSource.newDataSourceWhere(whereClause);
                }
                if (this.animationKeyFrameRole != null && this.animationIDRole != null) {
                    cellDataSource = cellDataSource.newAnimationDataSource(this.animationKeyFrameRole, this.animationIDRole);
                    cellSelectionDataSource = cellSelectionDataSource.newAnimationDataSource(this.animationKeyFrameRole, this.animationIDRole);
                }
                return new ScatterPlotCell(this.cellModel, cellDataSource, cellSelectionDataSource, columnNode, rowNode, ScatterPlotMatrix.this.getChannel());
            }
            return null;
        }
    }

    private class ScatterPlotCellFactory
    implements Matrix.CellFactoryInterface,
    Matrix.CellFactoryInterface2 {
        private ScatterPlotCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            ScatterPlotCell scatterPlotCell = null;
            if (dataSource != null && dataSource.length > 0) {
                scatterPlotCell = new ScatterPlotCell((ScatterPlotCellModel)cellModel, dataSource[0], dataSource[1], null, null, channel);
            }
            return scatterPlotCell;
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Matrix.MatrixInfo matrixInfo, Channel channel) {
            ScatterPlotCell scatterPlotCell = null;
            if (dataSource != null && dataSource.length > 0) {
                scatterPlotCell = matrixInfo != null ? new ScatterPlotCell((ScatterPlotCellModel)cellModel, dataSource[0], dataSource[1], matrixInfo.getColumnOrdinal(), matrixInfo.getRowOrdinal(), channel) : new ScatterPlotCell((ScatterPlotCellModel)cellModel, dataSource[0], dataSource[1], null, null, channel);
            }
            return scatterPlotCell;
        }
    }

    private class AxisCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final AxisCellModel cellModel;

        public AxisCellComponentFactory(AxisCellModel cellModel) {
            this.cellModel = cellModel;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            if (node instanceof DataTreeGroupNode && this.cellModel != null) {
                AxisCellModel commonModel = this.cellModel;
                NumericMapper mapper = commonModel.getMapper();
                if (mapper != null) {
                    return new AxisCell(commonModel, ScatterPlotMatrix.this.getChannel());
                }
                AxisCellModel axisCellModel = new AxisCellModel(null, commonModel);
                AxisCell axisCell = new AxisCell(axisCellModel, ScatterPlotMatrix.this.getChannel());
                axisCellModel.computeParameters(axisCell.getChannel());
                return axisCell;
            }
            return null;
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            throw new IllegalStateException("Not Supported");
        }
    }
}

