/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.scatterplot;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TickStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.riskmapplot.AbstractRiskMap;
import com.sas.graphics.components.util.scatterplot.ScatterPlotModel;
import com.sas.graphics.util.MutableInteger;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.PlotImageMapInfo2;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.scatterplot.BIPMarkerSkinFactory;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotCellModel;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AxisDetail;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorCache;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.Mapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericCache;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringMissingValueReplacement;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.gtk.gl.SplineConnector;
import com.sas.graphics.util.gtk.gl.StepConnector;
import com.sas.graphics.util.gtk.gl.Switch;
import com.sas.graphics.util.gtk.gl.TukeyBox;
import com.sas.graphics.util.gtk.labeling.PointLabelLayout;
import com.sas.graphics.util.gtk.labeling.PointLabelLayoutManager;
import com.sas.measures.BaseLength;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ScatterComposite
extends Composite {
    private static final transient BaseLength MINIMUM_SIZE = new BaseLength(8.0, "pt");
    private transient SimpleModelInterface cellModel;
    private transient DataSource dataSource;
    private transient Variable[] xVariable;
    private transient Variable[] yVariable;
    private transient Variable[] y2Variable;
    private transient Variable colorVariable;
    private transient Variable sizeVariable;
    private transient StringVariable shapeVariable;
    private transient StringVariable groupVariable;
    private transient Variable[] leftErrorVariable;
    private transient Variable[] rightErrorVariable;
    private transient Variable[] upErrorVariable;
    private transient Variable[] downErrorVariable;
    private transient Variable[] up2ErrorVariable;
    private transient Variable[] down2ErrorVariable;
    private transient Variable aboveValueVariable;
    private transient Variable belowValueVariable;
    private transient Variable[] xSelectionVariable;
    private transient Variable[] ySelectionVariable;
    private transient Variable[] dataTipVariableArray;
    private transient Variable[] auxiliaryVariableArray;
    private transient Object xVariableRole;
    private transient Object yVariableRole;
    private transient Object y2VariableRole;
    private transient Object colorVariableRole;
    private transient Object sizeVariableRole;
    private transient Object shapeVariableRole;
    private transient Object aboveValueVariableRole;
    private transient Object belowValueVariableRole;
    private transient Object xSelectionVariableRole;
    private transient Object ySelectionVariableRole;
    private transient Object dataTipRole;
    private transient Object auxiliaryRole;
    private transient NumericMapper[] xMapper;
    private transient NumericMapper[] yMapper;
    private transient NumericMapper[] y2Mapper;
    private transient AxisCellModel xAxisCellModel = null;
    private transient AxisCellModel yAxisCellModel = null;
    private transient AxisCellModel y2AxisCellModel = null;
    private transient Channel channel;
    private transient boolean groupByColor = false;
    private transient boolean nodata = true;
    private transient Rectangle validSelectionArea;
    private transient double xAxisLength;
    private transient double yAxisLength;
    static final transient String MISSING_VALUE = RB.getStringResource("missingValue.txt");
    private static final int LABEL_LAYOUT_THRESHOLD = 250;
    private PointLabelLayout abovePointLabelLayout;
    private PointLabelLayout belowPointLabelLayout;
    private PointLabelLayoutManager pointLabelLayoutManager;
    private List selectionFilterList = new ArrayList();
    private AbstractRiskMap riskMap;
    private ImageIcon markerEffectsIcon = null;
    private AbstractMarkerSkinFactory skinFactory = null;
    private double xAxisLeadingMarginLength;
    private double yAxisLeadingMarginLength;
    private double y2AxisLeadingMarginLength;
    private double xAxisTrailingMarginLength;
    private double yAxisTrailingMarginLength;
    private int catAxisAdj;
    private int resAxisAdj;
    private Dimension defaultSize = new Dimension(0, 0);
    Rectangle bounds = null;
    private transient DataSource dataSourceSelection;
    private transient Variable[] xVariableSelection;
    private transient Variable[] yVariableSelection;
    private transient Variable[] y2VariableSelection;
    private transient Variable[] leftErrorVariableSelection;
    private transient Variable[] rightErrorVariableSelection;
    private transient Variable[] upErrorVariableSelection;
    private transient Variable[] downErrorVariableSelection;
    private transient Variable[] up2ErrorVariableSelection;
    private transient Variable[] down2ErrorVariableSelection;
    private transient Variable aboveValueVariableSelection;
    private transient Variable belowValueVariableSelection;
    private transient Variable sizeVariableSelection;
    private transient Variable shapeVariableSelection;
    private transient Variable colorVariableSelection;
    private transient Variable groupVariableSelection;
    private transient NumericMapper[] xMapperSelection;
    private transient NumericMapper[] yMapperSelection;
    private transient NumericMapper[] y2MapperSelection;
    private transient Composite selectionComposite = null;

    public ScatterComposite(ScatterPlotCellModel cellModel, DataSource dataSource, Channel ch) {
        this.cellModel = cellModel;
        this.dataSource = dataSource;
        this.channel = ch;
        this.channel.glDisable(1);
        this.initializeVariables(this.channel);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public SimpleModelInterface getModel() {
        return this.cellModel;
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.dataSource.isAnimationEnabled()) {
            this.dataSource.setAnimationPosition(animationPosition);
        }
    }

    private void initializeVariables(Channel myChannel) {
        boolean validY;
        if (this.dataSource == null) {
            return;
        }
        if (this.xVariable != null) {
            return;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        ScatterPlotMatrixModel matrixModel = cellModel.getScatterPlotMatrixModel();
        ScatterPlotModel plotModel = matrixModel.getScatterPlotModel();
        this.dataSource.sortBy(matrixModel.getSortRole());
        Variable[] sortVar = this.dataSource.getVariable(matrixModel.getSortRole());
        int order = matrixModel.getGraphModel().getDataElementStyles().getMarkerStyles()[0].getConnectionOrder();
        if (sortVar == null && order != 40100) {
            Variable[] var = order == 40101 ? this.dataSource.getVariable(matrixModel.getXRole()) : this.dataSource.getVariable(matrixModel.getYRole());
            for (int i = 0; i < var.length; ++i) {
                this.dataSource.sortByVar(var[i], 10401);
            }
        }
        this.xVariableRole = matrixModel.getXRole();
        this.yVariableRole = matrixModel.getYRole();
        this.y2VariableRole = matrixModel.getY2Role();
        this.sizeVariableRole = matrixModel.getSizeRole();
        this.xSelectionVariableRole = matrixModel.getXSelectionRole();
        this.ySelectionVariableRole = matrixModel.getYSelectionRole();
        this.aboveValueVariableRole = matrixModel.getAboveValueRole();
        this.belowValueVariableRole = matrixModel.getBelowValueRole();
        this.shapeVariableRole = cellModel.getShapeRole();
        this.colorVariableRole = cellModel.getColorRole();
        this.dataTipRole = cellModel.getDataTipRole();
        this.auxiliaryRole = cellModel.getAuxiliaryRole();
        this.xVariable = ScatterComposite.checkVariableList(this.dataSource.getVariable(this.xVariableRole));
        this.yVariable = ScatterComposite.checkVariableList(this.dataSource.getVariable(this.yVariableRole));
        this.y2Variable = ScatterComposite.checkVariableList(this.dataSource.getVariable(this.y2VariableRole));
        this.sizeVariable = this.dataSource.getVariable(this.sizeVariableRole, 0);
        this.xSelectionVariable = ScatterComposite.checkVariableList(this.dataSource.getVariable(this.xSelectionVariableRole));
        this.ySelectionVariable = ScatterComposite.checkVariableList(this.dataSource.getVariable(this.ySelectionVariableRole));
        this.leftErrorVariable = this.dataSource.getLowVariable(this.xVariableRole);
        this.rightErrorVariable = this.dataSource.getHighVariable(this.xVariableRole);
        this.upErrorVariable = this.dataSource.getHighVariable(this.yVariableRole);
        this.downErrorVariable = this.dataSource.getLowVariable(this.yVariableRole);
        this.up2ErrorVariable = this.dataSource.getHighVariable(this.y2VariableRole);
        this.down2ErrorVariable = this.dataSource.getLowVariable(this.y2VariableRole);
        this.aboveValueVariable = this.dataSource.getVariable(this.aboveValueVariableRole, 0);
        this.belowValueVariable = this.dataSource.getVariable(this.belowValueVariableRole, 0);
        this.colorVariable = this.dataSource.getVariable(this.colorVariableRole, 0);
        this.shapeVariable = (StringVariable)this.dataSource.getVariable(this.shapeVariableRole, 0);
        this.groupVariable = (StringVariable)this.dataSource.getVariable(matrixModel.getGroupRole(), 0);
        this.dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, this.dataTipRole);
        this.auxiliaryVariableArray = Util.getGTKVariableArray(this.dataSource, this.auxiliaryRole);
        AxisCellModel localXAxisCellModel = cellModel.getXAxisCellModel();
        AxisCellModel localYAxisCellModel = cellModel.getYAxisCellModel();
        AxisCellModel localY2AxisCellModel = cellModel.getY2AxisCellModel();
        int observations = 0;
        for (int i = 0; i < this.xVariable.length && observations == 0; observations += this.xVariable[i].getValueCount(), ++i) {
        }
        this.nodata = observations == 0;
        boolean bl = validY = this.yVariable != null;
        if (!validY) {
            localYAxisCellModel = localY2AxisCellModel;
        }
        boolean displayMissing = plotModel.getMissingPolicy() == 10201;
        NumericMapper xAxisMapper = localXAxisCellModel.getMapper();
        boolean xAxisVisible = cellModel.getXAxisVisible();
        this.xMapper = new NumericMapper[this.xVariable.length];
        if (xAxisMapper != null) {
            if (xAxisMapper instanceof StringToNumericMapper) {
                this.xMapper[0] = new StringToNumericMapper();
                ((StringToNumericMapper)this.xMapper[0]).input.connectFrom(((StringVariable)this.xVariable[0]).value);
                ((StringToNumericMapper)this.xMapper[0]).shareMap((StringToNumericMapper)xAxisMapper);
                this.xMapper[0].setLabelMissingValues(displayMissing);
            } else {
                this.xMapper[0] = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)this.xMapper[0]).input.connectFrom(((NumericVariable)this.xVariable[0]).value);
                ((ContinuousRangeToNumericMapper)this.xMapper[0]).shareMap((ContinuousRangeToNumericMapper)xAxisMapper);
            }
            this.xAxisCellModel = localXAxisCellModel;
        } else if (xAxisVisible) {
            ContinuousRangeToNumericMapper axisMapper;
            this.xAxisCellModel = new AxisCellModel(null, localXAxisCellModel);
            double origin = this.xAxisCellModel.getOrigin();
            if (this.xVariable[0] instanceof NumericVariable) {
                axisMapper = new ContinuousRangeToNumericMapper();
                double[] range = this.getXRange();
                axisMapper.setInputMin(range[0]);
                axisMapper.setInputMax(range[1]);
                axisMapper.setOutputMin(origin);
                xAxisMapper = axisMapper;
            } else {
                axisMapper = new StringToNumericMapper();
                axisMapper.setStartValue(origin);
                axisMapper.input.connectFrom(((StringVariable)this.xVariable[0]).value);
                axisMapper.setLabelMissingValues(displayMissing);
                xAxisMapper = axisMapper;
            }
            xAxisMapper.setFormat(GTKUtil.getAxisFormat(this.xVariable));
            this.xMapper[0] = xAxisMapper;
            this.xAxisCellModel.setMapper(xAxisMapper);
            this.xAxisCellModel.computeParameters(myChannel);
        }
        NumericMapper yAxisMapper = localYAxisCellModel.getMapper();
        boolean yAxisVisible = cellModel.getYAxisVisible();
        if (validY) {
            if (yAxisMapper != null) {
                this.yMapper = new NumericMapper[this.yVariable.length];
                if (yAxisMapper instanceof StringToNumericMapper) {
                    this.yMapper[0] = new StringToNumericMapper();
                    ((StringToNumericMapper)this.yMapper[0]).input.connectFrom(((StringVariable)this.yVariable[0]).value);
                    ((StringToNumericMapper)this.yMapper[0]).shareMap((StringToNumericMapper)yAxisMapper);
                    this.yMapper[0].setLabelMissingValues(displayMissing);
                } else {
                    this.yMapper[0] = new ContinuousRangeToNumericMapper();
                    ((ContinuousRangeToNumericMapper)this.yMapper[0]).input.connectFrom(((NumericVariable)this.yVariable[0]).value);
                    ((ContinuousRangeToNumericMapper)this.yMapper[0]).shareMap((ContinuousRangeToNumericMapper)yAxisMapper);
                }
                this.yAxisCellModel = localYAxisCellModel;
            } else if (yAxisVisible) {
                ContinuousRangeToNumericMapper axisMapper;
                this.yAxisCellModel = new AxisCellModel(null, localYAxisCellModel);
                double origin = this.yAxisCellModel.getOrigin();
                if (this.yVariable[0] instanceof NumericVariable) {
                    axisMapper = new ContinuousRangeToNumericMapper();
                    double[] range = this.getYRange();
                    axisMapper.setInputMin(range[0]);
                    axisMapper.setInputMax(range[1]);
                    axisMapper.setOutputMin(origin);
                    yAxisMapper = axisMapper;
                } else {
                    axisMapper = new StringToNumericMapper();
                    axisMapper.setStartValue(origin);
                    axisMapper.input.connectFrom(((StringVariable)this.yVariable[0]).value);
                    axisMapper.setLabelMissingValues(displayMissing);
                    yAxisMapper = axisMapper;
                }
                yAxisMapper.setFormat(GTKUtil.getAxisFormat(this.yVariable));
                this.yAxisCellModel.setMapper(yAxisMapper);
                this.yAxisCellModel.computeParameters(myChannel);
                if (this.yMapper == null) {
                    this.yMapper = new NumericMapper[this.yVariable.length];
                }
                this.yMapper[0] = yAxisMapper;
            }
        }
        if (localY2AxisCellModel == null) {
            return;
        }
        NumericMapper y2AxisMapper = localY2AxisCellModel.getMapper();
        boolean y2AxisVisible = cellModel.getY2AxisVisible();
        if (y2AxisMapper != null) {
            this.y2Mapper = new NumericMapper[this.y2Variable.length];
            if (y2AxisMapper instanceof StringToNumericMapper) {
                this.y2Mapper[0] = new StringToNumericMapper();
                ((StringToNumericMapper)this.y2Mapper[0]).input.connectFrom(((StringVariable)this.y2Variable[0]).value);
                ((StringToNumericMapper)this.y2Mapper[0]).shareMap((StringToNumericMapper)y2AxisMapper);
            } else {
                this.y2Mapper[0] = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)this.y2Mapper[0]).input.connectFrom(((NumericVariable)this.y2Variable[0]).value);
                ((ContinuousRangeToNumericMapper)this.y2Mapper[0]).shareMap((ContinuousRangeToNumericMapper)y2AxisMapper);
            }
            this.y2AxisCellModel = localY2AxisCellModel;
        } else if (y2AxisVisible) {
            this.y2AxisCellModel = new AxisCellModel(null, localY2AxisCellModel);
            double origin = this.y2AxisCellModel.getOrigin();
            Double Length = this.yAxisCellModel.getLength();
            double length = Length;
            Integer ValueCount = this.yAxisCellModel.getValueCount();
            int valueCount = ValueCount;
            this.y2AxisCellModel.setLength(Length);
            this.y2AxisCellModel.setValueCount(ValueCount);
            if (this.y2Variable[0] instanceof NumericVariable) {
                ContinuousRangeToNumericMapper axisMapper = new ContinuousRangeToNumericMapper();
                double[] range = this.getY2Range();
                axisMapper.setInputMin(range[0]);
                axisMapper.setInputMax(range[1]);
                if (this.y2AxisCellModel.getAxisModel().isReverseDirection()) {
                    axisMapper.setOutputMax(origin);
                    axisMapper.setOutputMin(origin + length);
                } else {
                    axisMapper.setOutputMin(origin);
                    axisMapper.setOutputMax(origin + length);
                }
                axisMapper.setLabelCount(valueCount);
                y2AxisMapper = axisMapper;
            } else {
                Double TickStride = this.yAxisCellModel.getMajorTickInterval();
                double tickStride = TickStride;
                StringToNumericMapper axisMapper = new StringToNumericMapper();
                if (this.y2AxisCellModel.getAxisModel().isReverseDirection()) {
                    axisMapper.setStartValue(origin + length);
                    axisMapper.setStrideValue(-tickStride);
                } else {
                    axisMapper.setStartValue(origin);
                    axisMapper.setStrideValue(tickStride);
                }
                axisMapper.input.connectFrom(((StringVariable)this.y2Variable[0]).value);
                y2AxisMapper = axisMapper;
                this.y2AxisCellModel.setMajorTickInterval(TickStride);
                axisMapper.setLabelMissingValues(displayMissing);
            }
            y2AxisMapper.setFormat(GTKUtil.getAxisFormat(this.y2Variable));
            this.y2AxisCellModel.setMapper(y2AxisMapper);
            if (!validY) {
                this.y2AxisCellModel.computeParameters(myChannel);
            } else {
                this.y2AxisCellModel.computeSecondaryParameters(myChannel);
            }
            if (this.y2Mapper == null) {
                this.y2Mapper = new NumericMapper[this.y2Variable.length];
            }
            this.y2Mapper[0] = y2AxisMapper;
        }
        if (!validY) {
            this.yMapper = this.y2Mapper;
            this.yAxisCellModel = this.y2AxisCellModel;
        }
    }

    public synchronized void construct(int column, int row) {
        NumericPipe np;
        FilledLineConnector connector3;
        ColorProperty needleCP;
        StringToColorMapper markerColorMapper;
        LineSegment y2zGrid;
        int frameWidth;
        int tickPlacement;
        TextStyle labelStyle;
        String title;
        TextStyle labelStyle2;
        String title2;
        int overlayNum2;
        int overlayNum;
        boolean combOverlay;
        this.removeAllElements();
        this.pointLabelLayoutManager = null;
        this.selectionFilterList.clear();
        if (this.dataSource == null || this.xVariable == null) {
            return;
        }
        int valueCount = this.dataSource.getValueCount();
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        ScatterPlotMatrixModel matrixModel = cellModel.getScatterPlotMatrixModel();
        ScatterPlotModel plotModel = matrixModel.getScatterPlotModel();
        boolean hasSelection = this.selectionComposite != null;
        Composite s1 = null;
        Composite s2 = null;
        if (hasSelection) {
            this.selectionComposite.removeAllElements();
        }
        boolean scatter = plotModel.getMarkerEnabled() != false && !this.nodata;
        boolean line = plotModel.getInterpolationEnabled() != false && !this.nodata;
        boolean fill = plotModel.getFillAreaEnabled() != false && !this.nodata;
        boolean validY = this.yVariable != null;
        GraphModel graphModel = matrixModel.getGraphModel();
        AxisModel xAxisModel = this.xAxisCellModel.getAxisModel();
        AxisModel yAxisModel = this.yAxisCellModel.getAxisModel();
        AxisModel y2AxisModel = this.y2AxisCellModel == null ? null : this.y2AxisCellModel.getAxisModel();
        boolean xAxisVisible = cellModel.getXAxisVisible() != false && xAxisModel.isVisible();
        boolean yAxisVisible = cellModel.getYAxisVisible() != false && yAxisModel.isVisible();
        boolean numericX = this.xVariable[0] instanceof NumericVariable;
        boolean numericY2 = this.y2Variable != null && this.y2Variable[0] instanceof NumericVariable;
        boolean numericY = validY ? this.yVariable[0] instanceof NumericVariable : numericY2;
        Dimension margin = cellModel.getInnerMargin();
        int yOverlayNum = validY ? this.yVariable.length : 0;
        boolean yOverlay = yOverlayNum > 1;
        int xOverlayNum = this.xVariable.length;
        boolean xOverlay = xOverlayNum > 1;
        boolean y2 = this.y2Variable != null;
        int y2OverlayNum = y2 ? this.y2Variable.length : 0;
        boolean y2Overlay = y2OverlayNum > 1;
        boolean bl = combOverlay = xOverlay && yOverlayNum + y2OverlayNum > 1;
        if (combOverlay) {
            overlayNum = Math.min(xOverlayNum, yOverlayNum);
            overlayNum2 = Math.min(xOverlayNum - overlayNum, y2OverlayNum);
        } else if (xOverlay) {
            overlayNum = validY ? xOverlayNum : 0;
            overlayNum2 = y2 ? xOverlayNum : 0;
        } else {
            overlayNum = yOverlayNum;
            overlayNum2 = y2OverlayNum;
        }
        int skint = 10200;
        if (plotModel.getSkin() != null) {
            skint = plotModel.getSkin();
        }
        this.skinFactory = BIPMarkerSkinFactory.getInstance(skint);
        DataElementStyles des = graphModel.getDataElementStyles();
        MarkerStyle[] markerStyles = des.getMarkerStyles();
        Color[] cycleColors = des.getDiscreteFillColors();
        BaseLength dsize = plotModel.getMinMarkerSize();
        double minMarkerSize = dsize == null ? 0.0 : dsize.getMagnitude((Object)"py");
        dsize = plotModel.getMaxMarkerSize();
        double maxMarkerSize = dsize == null ? 0.0 : dsize.getMagnitude((Object)"py");
        NumericProperty markerScale = new NumericProperty();
        NumericProperty markerSelectionScale = hasSelection ? new NumericProperty() : null;
        boolean sizeFlag = false;
        if (this.sizeVariable != null && this.sizeVariable instanceof NumericVariable) {
            ContinuousRangeToNumericMapper sizeMapper = new ContinuousRangeToNumericMapper();
            ContinuousRangeToNumericMapper cellSizeMapper = cellModel.getSizeMapper();
            if (cellSizeMapper == null) {
                sizeMapper.setOutputMin(0.0);
                sizeMapper.setOutputMax(1.0);
                sizeMapper.setInputMin(((NumericVariable)this.sizeVariable).getMin());
                sizeMapper.setInputMax(((NumericVariable)this.sizeVariable).getMax());
            } else {
                sizeMapper.shareMap(cellSizeMapper);
            }
            sizeMapper.input.connectFrom(((NumericVariable)this.sizeVariable).value);
            Calculator c = new Calculator("inA + inC*(inB-inA)");
            c.inA.setValue(minMarkerSize);
            c.inB.setValue(maxMarkerSize);
            c.inC.connectFrom((NumericPipe)sizeMapper);
            markerScale.connectFrom((NumericPipe)c);
            sizeFlag = true;
            if (hasSelection) {
                ContinuousRangeToNumericMapper sm = new ContinuousRangeToNumericMapper();
                sm.shareMap(sizeMapper);
                sm.input.connectFrom(((NumericVariable)this.sizeVariableSelection).value);
                Calculator cs = new Calculator("inA + inC*(inB-inA)");
                cs.inA.setValue(minMarkerSize);
                cs.inB.setValue(maxMarkerSize);
                cs.inC.connectFrom((NumericPipe)sm);
                markerSelectionScale.connectFrom((NumericPipe)cs);
            }
        } else if (this.groupVariable != null) {
            // empty if block
        }
        AxisWallModel axisWallModel = plotModel.getAxisWallModel();
        boolean xAxisPrimary = true;
        boolean yAxisPrimary = true;
        if (margin == null) {
            margin = new Dimension(this.xAxisCellModel.getMargin().width, this.yAxisCellModel.getMargin().height);
        }
        BaseLength startOffset = xAxisModel.getStartOffset();
        BaseLength endOffset = xAxisModel.getEndOffset();
        this.xAxisTrailingMarginLength = endOffset == null ? (double)Math.min(margin.width, this.bounds.width / 2) : endOffset.getMagnitude((Object)"px");
        this.xAxisLeadingMarginLength = startOffset == null ? (double)Math.min(margin.width, this.bounds.width / 2) : startOffset.getMagnitude((Object)"px");
        double xAxisCenterLength = Math.round(this.xAxisCellModel.getLength());
        startOffset = yAxisModel.getStartOffset();
        endOffset = yAxisModel.getEndOffset();
        this.yAxisLeadingMarginLength = startOffset == null ? (double)Math.min(margin.height, this.bounds.height / 2) : startOffset.getMagnitude((Object)"py");
        this.yAxisTrailingMarginLength = endOffset == null ? (double)Math.min(margin.height, this.bounds.height / 2) : endOffset.getMagnitude((Object)"py");
        double yAxisCenterLength = Math.round(this.yAxisCellModel.getLength());
        this.xAxisLength = this.xAxisLeadingMarginLength + xAxisCenterLength + this.xAxisTrailingMarginLength;
        this.yAxisLength = this.yAxisLeadingMarginLength + yAxisCenterLength + this.yAxisTrailingMarginLength;
        this.y2AxisLeadingMarginLength = 0.0;
        if (this.y2AxisCellModel != null) {
            startOffset = y2AxisModel.getStartOffset();
            this.y2AxisLeadingMarginLength = startOffset == null ? (double)margin.height : startOffset.getMagnitude((Object)"py");
        }
        this.resAxisAdj = yAxisVisible ? this.yAxisCellModel.getResAxisAdj().intValue() : 0;
        this.catAxisAdj = xAxisVisible ? this.xAxisCellModel.getCatAxisAdj().intValue() : 0;
        Dimension depth = this.xAxisCellModel.getDepth();
        boolean dim3D = depth.width > 0;
        Grid backFrame = null;
        if (dim3D) {
            this.channel.glViewport(0, 0, (int)this.xAxisLength, (int)this.yAxisLength);
            this.channel.glOblique(0.0, this.xAxisLength, (double)depth.height, this.yAxisLength + (double)depth.height, 0.0, (double)depth.width, 1.0, 45.0);
            this.channel.glEnable(3);
            this.channel.glEnable(19);
            this.channel.glEnable(1);
            this.channel.glLight(19, 3, new double[]{0.5, 0.5, 1.0});
            Box box = new Box();
            box.setNormalsReversed(true);
            backFrame = box;
        } else {
            Grid frame2D;
            backFrame = frame2D = new Grid();
        }
        backFrame.selectEnabled.setValue(false);
        this.addElement((Element)backFrame);
        RectangularAxis xAxis = null;
        int xPlacement = this.xAxisCellModel.getTitlePlacementType();
        RasterLabel xAxisLabel = null;
        if (xAxisVisible) {
            xAxis = this.xAxisCellModel.getGTKAxis(this.xAxisCellModel.getMapper());
            xAxis.setLength(this.xAxisLength - 1.0);
            xAxis.setLineOffset(-this.xAxisLeadingMarginLength - 1.0);
            xAxis.selectEnabled.setValue(false);
            title2 = this.xAxisCellModel.getTitle();
            if (xPlacement == 11302 || xPlacement == 11303) {
                labelStyle2 = xAxisModel.getLabelTextStyle();
                xAxisLabel = xPlacement == 11302 ? this.getALabel(labelStyle2, title2, new double[]{this.xAxisLength - this.xAxisLeadingMarginLength + 3.0, -this.yAxisLeadingMarginLength - 2.0}, 2, 1) : this.getALabel(labelStyle2, title2, new double[]{this.xAxisLength - this.xAxisLeadingMarginLength + 3.0, -this.yAxisLeadingMarginLength - 2.0}, 2, 0);
                Util.SelectInfo.selectEnable((Element)xAxisLabel, 4, "PX");
            }
            if (this.xVariable[0] instanceof StringVariable) {
                Util.SelectInfo.selectEnable((Element)xAxis, 4);
            } else {
                Util.SelectInfo.selectDisable((Element)xAxis);
            }
            if (xAxisModel.isDrillIconVisible()) {
                AxisStyle axisStyle = xAxis.getStyle();
                axisStyle.setTitleMarkerVisible(true);
                axisStyle.setTitleMarkerId(this.channel.addCustomMarker((CustomMarkerInterface)this.xAxisCellModel.getTitleMarker()));
                axisStyle.setTitleMarkerSize(this.xAxisCellModel.getTitleMarker().getSize());
            }
        } else if (xAxisModel.getMajorTickStyle().getPlacement() == 50001 || xAxisModel.getMajorTickStyle().getPlacement() == 50000 || xAxisModel.getMinorTickStyle().getPlacement() == 50001 || xAxisModel.getMinorTickStyle().getPlacement() == 50000) {
            xAxis = RectangularAxis.getXAxis((NumericMapper)this.xAxisCellModel.getMapper(), (double)(this.xAxisLength + 2.0));
            xAxis.setLineOffset(-this.xAxisLeadingMarginLength - 2.0);
            xAxis.selectEnabled.setValue(false);
            AxisStyle axisStyle = xAxis.getStyle();
            axisStyle.setAxisLineOn(false);
            axisStyle.setTitleOn(false);
            axisStyle.setLabelsOn(false);
            TickMarkStyle gtkMajorTickStyle = axisStyle.getMajorTickStyle();
            TickStyle compMajorTickStyle = xAxisModel.getMajorTickStyle();
            boolean tickMarksVisible = compMajorTickStyle.getLineStyle().getVisibilityPolicy() != 10202;
            axisStyle.setMajorTickMarksOn(tickMarksVisible);
            gtkMajorTickStyle.setColor(compMajorTickStyle.getLineStyle().getColor());
            gtkMajorTickStyle.setLineWidth((int)compMajorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"py"));
            switch (compMajorTickStyle.getPlacement()) {
                default: {
                    gtkMajorTickStyle.setTickMarkJustification(1);
                    break;
                }
                case 50001: {
                    gtkMajorTickStyle.setTickMarkJustification(2);
                    break;
                }
                case 50000: {
                    gtkMajorTickStyle.setTickMarkJustification(0);
                }
            }
            if (this.xMapper[0] instanceof StringToNumericMapper) {
                axisStyle.setMinorTickMarksOn(false);
            } else {
                TickMarkStyle gtkMinorTickStyle = axisStyle.getMinorTickStyle();
                TickStyle compMinorTickStyle = xAxisModel.getMinorTickStyle();
                axisStyle.setMinorTickMarksOn(compMinorTickStyle.getLineStyle().getVisibilityPolicy() != 10202);
                gtkMinorTickStyle.setColor(compMinorTickStyle.getLineStyle().getColor());
                gtkMinorTickStyle.setLineWidth((int)compMinorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"py"));
                gtkMinorTickStyle.setMinorTickCount(xAxisModel.getContinuousMinorTickCount());
                switch (compMinorTickStyle.getPlacement()) {
                    default: {
                        gtkMinorTickStyle.setTickMarkJustification(1);
                        break;
                    }
                    case 50001: {
                        gtkMinorTickStyle.setTickMarkJustification(2);
                        break;
                    }
                    case 50000: {
                        gtkMinorTickStyle.setTickMarkJustification(0);
                    }
                }
            }
        }
        if (xPlacement == 11301) {
            title2 = this.xAxisCellModel.getTitle();
            labelStyle2 = xAxisModel.getLabelTextStyle();
            double xpos = this.xAxisLength - this.xAxisLeadingMarginLength + 3.0;
            double ypos = -this.yAxisLeadingMarginLength;
            xAxisLabel = this.getALabel(labelStyle2, title2, new double[]{xpos, ypos}, 2, 3);
            Util.SelectInfo.selectEnable((Element)xAxisLabel, 4, "PX");
        }
        RectangularAxis yAxis = null;
        boolean yAdj = false;
        int yPlacement = this.yAxisCellModel.getTitlePlacementType();
        RasterLabel yAxisLabel = null;
        if (yAxisVisible) {
            yAxis = this.yAxisCellModel.getGTKAxis(this.yAxisCellModel.getMapper());
            this.resAxisAdj = this.yAxisCellModel.getResAxisAdj().intValue();
            yAxis.setLength(this.yAxisLength);
            yAxis.setLineOffset(-this.yAxisLeadingMarginLength);
            yAxis.selectEnabled.setValue(false);
            title = this.yAxisCellModel.getTitle();
            labelStyle = yAxisModel.getLabelTextStyle();
            if (yPlacement == 11302) {
                yAxisLabel = this.getALabel(labelStyle, title, new double[]{-this.xAxisLeadingMarginLength, this.yAxisLength - this.yAxisLeadingMarginLength + 2.0}, 4, 3);
            } else if (yPlacement == 11303) {
                yAxisLabel = this.yAxisCellModel.getTitleBreak() == null ? this.getALabel(labelStyle, title, new double[]{-this.xAxisLeadingMarginLength, this.yAxisLength - this.yAxisLeadingMarginLength + 2.0}, 4, 3) : this.getALabel(labelStyle, title, new double[]{-this.xAxisLeadingMarginLength - (double)this.resAxisAdj + 2.0, this.yAxisLength - this.yAxisLeadingMarginLength + 2.0}, 2, 3);
            } else if (yPlacement == 11301) {
                yAxisLabel = this.getALabel(labelStyle, title, new double[]{-this.xAxisLeadingMarginLength, this.yAxisLength - this.yAxisLeadingMarginLength + 2.0}, 2, 3);
            }
            Util.SelectInfo.selectEnable(yAxisLabel, 4, "PY");
            yAxis.selectDetailEnabled.setValue(true);
            Util.SelectInfo.selectEnable((Element)yAxis, 4);
            if (yAxisModel.isDrillIconVisible()) {
                AxisStyle axisStyle = yAxis.getStyle();
                axisStyle.setTitleMarkerVisible(true);
                axisStyle.setTitleMarkerId(this.channel.addCustomMarker((CustomMarkerInterface)this.yAxisCellModel.getTitleMarker()));
                axisStyle.setTitleMarkerSize(this.yAxisCellModel.getTitleMarker().getSize());
            }
        } else if (yAxisModel.getMajorTickStyle().getPlacement() == 50000 || yAxisModel.getMajorTickStyle().getPlacement() == 50001 || yAxisModel.getMinorTickStyle().getPlacement() == 50000 || yAxisModel.getMinorTickStyle().getPlacement() == 50001) {
            yAxis = RectangularAxis.getYAxis((NumericMapper)this.yAxisCellModel.getMapper(), (double)this.yAxisLength);
            yAxis.setLineOffset(-this.yAxisLeadingMarginLength);
            yAxis.selectEnabled.setValue(false);
            AxisStyle axisStyle = yAxis.getStyle();
            axisStyle.setAxisLineOn(false);
            axisStyle.setTitleOn(false);
            axisStyle.setLabelsOn(false);
            TickMarkStyle gtkMajorTickStyle = axisStyle.getMajorTickStyle();
            TickStyle compMajorTickStyle = yAxisModel.getMajorTickStyle();
            axisStyle.setMajorTickMarksOn(compMajorTickStyle.getLineStyle().getVisibilityPolicy() != 10202);
            gtkMajorTickStyle.setColor(compMajorTickStyle.getLineStyle().getColor());
            gtkMajorTickStyle.setLineWidth((int)compMajorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"px"));
            switch (compMajorTickStyle.getPlacement()) {
                case 50001: {
                    gtkMajorTickStyle.setTickMarkJustification(2);
                    break;
                }
                case 50002: {
                    gtkMajorTickStyle.setTickMarkJustification(1);
                    break;
                }
                default: {
                    gtkMajorTickStyle.setTickMarkJustification(0);
                }
            }
            if (this.yMapper[0] instanceof StringToNumericMapper) {
                axisStyle.setMinorTickMarksOn(false);
            } else {
                TickMarkStyle gtkMinorTickStyle = axisStyle.getMinorTickStyle();
                TickStyle compMinorTickStyle = yAxisModel.getMinorTickStyle();
                axisStyle.setMinorTickMarksOn(compMinorTickStyle.getLineStyle().getVisibilityPolicy() != 10202);
                gtkMinorTickStyle.setColor(compMinorTickStyle.getLineStyle().getColor());
                gtkMinorTickStyle.setLineWidth((int)compMinorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"px"));
                gtkMinorTickStyle.setMinorTickCount(yAxisModel.getContinuousMinorTickCount());
                switch (compMinorTickStyle.getPlacement()) {
                    case 50001: {
                        gtkMinorTickStyle.setTickMarkJustification(2);
                        break;
                    }
                    case 50002: {
                        gtkMinorTickStyle.setTickMarkJustification(1);
                        break;
                    }
                    default: {
                        gtkMinorTickStyle.setTickMarkJustification(0);
                    }
                }
            }
        }
        if (!yAxisVisible && this.yAxisCellModel.getPrimary().booleanValue() && (yPlacement == 11301 || yPlacement == 11303 && this.yAxisCellModel.getTitleBreak() != null)) {
            title = this.yAxisCellModel.getTitle();
            labelStyle = yAxisModel.getLabelTextStyle();
            double xpos = -this.xAxisLeadingMarginLength;
            if (yPlacement == 11303) {
                title = title.substring(this.yAxisCellModel.getTitleBreak());
            }
            yAxisLabel = this.getALabel(labelStyle, title, new double[]{xpos, this.yAxisLength - this.yAxisLeadingMarginLength + 2.0}, 2, 3);
            Util.SelectInfo.selectEnable((Element)yAxisLabel, 4, "PY");
        }
        RectangularAxis y2Axis = null;
        int y2Placement = y2AxisModel == null ? 11302 : this.y2AxisCellModel.getTitlePlacementType();
        RasterLabel y2AxisLabel = null;
        int n = tickPlacement = y2AxisModel == null ? 50002 : y2AxisModel.getMajorTickStyle().getPlacement();
        if (tickPlacement == 50000 || tickPlacement == 50001 || tickPlacement == 50000 || tickPlacement == 50001) {
            y2Axis = RectangularAxis.getYAxis((NumericMapper)this.y2AxisCellModel.getMapper(), (double)this.yAxisLength);
            y2Axis.setFitAlgorithm(this.y2AxisCellModel.getFitAlgorithm());
            y2Axis.setTruncateStartCount(32);
            y2Axis.setTruncateEndCount(32);
            y2Axis.setTruncateAngleStartCount(10);
            y2Axis.setTruncateAngleEndCount(10);
            y2Axis.setLineOffset(-this.yAxisLeadingMarginLength);
            y2Axis.selectEnabled.setValue(false);
            y2Axis.setPrimary(false);
            y2Axis.transform.translateX.setValue(this.xAxisLength - this.xAxisLeadingMarginLength);
            AxisStyle axisStyle = y2Axis.getStyle();
            axisStyle.setAxisLineOn(false);
            axisStyle.setTitleOn(false);
            axisStyle.setLabelsOn(false);
            TickMarkStyle gtkMajorTickStyle = axisStyle.getMajorTickStyle();
            TickStyle compMajorTickStyle = y2AxisModel.getMajorTickStyle();
            axisStyle.setMajorTickMarksOn(compMajorTickStyle.getLineStyle().getVisibilityPolicy() != 10202);
            gtkMajorTickStyle.setColor(compMajorTickStyle.getLineStyle().getColor());
            gtkMajorTickStyle.setLineWidth((int)compMajorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"px"));
            switch (compMajorTickStyle.getPlacement()) {
                case 50001: {
                    gtkMajorTickStyle.setTickMarkJustification(2);
                    break;
                }
                case 50002: {
                    gtkMajorTickStyle.setTickMarkJustification(1);
                    break;
                }
                default: {
                    gtkMajorTickStyle.setTickMarkJustification(0);
                }
            }
            if (this.y2Mapper[0] instanceof StringToNumericMapper) {
                axisStyle.setMinorTickMarksOn(false);
            } else {
                TickMarkStyle gtkMinorTickStyle = axisStyle.getMinorTickStyle();
                TickStyle compMinorTickStyle = y2AxisModel.getMinorTickStyle();
                axisStyle.setMinorTickMarksOn(compMinorTickStyle.getLineStyle().getVisibilityPolicy() != 10202);
                gtkMinorTickStyle.setColor(compMinorTickStyle.getLineStyle().getColor());
                gtkMinorTickStyle.setLineWidth((int)compMinorTickStyle.getLineStyle().getThickness().getMagnitude((Object)"px"));
                gtkMinorTickStyle.setMinorTickCount(y2AxisModel.getContinuousMinorTickCount());
                switch (compMinorTickStyle.getPlacement()) {
                    case 50001: {
                        gtkMinorTickStyle.setTickMarkJustification(2);
                        break;
                    }
                    case 50002: {
                        gtkMinorTickStyle.setTickMarkJustification(1);
                        break;
                    }
                    default: {
                        gtkMinorTickStyle.setTickMarkJustification(0);
                    }
                }
            }
        }
        if (y2Placement == 11301 || y2Placement == 11303 && this.y2AxisCellModel.getTitleBreak() != null) {
            String title3 = this.y2AxisCellModel.getTitle();
            TextStyle labelStyle3 = y2AxisModel.getLabelTextStyle();
            double xpos = this.xAxisLength - this.xAxisLeadingMarginLength;
            if (y2Placement == 11303) {
                title3 = title3.substring(0, this.y2AxisCellModel.getTitleBreak());
            }
            y2AxisLabel = this.getALabel(labelStyle3, title3, new double[]{xpos, this.yAxisLength - this.yAxisLeadingMarginLength + 2.0}, 4, 3);
            Util.SelectInfo.selectEnable((Element)y2AxisLabel, 4, "SY");
        }
        if (yAxisPrimary && yAxis != null) {
            this.transform.translateX.setValue((double)this.resAxisAdj + this.xAxisLeadingMarginLength);
            if (hasSelection) {
                this.selectionComposite.transform.translateX.setValue((double)this.resAxisAdj + this.xAxisLeadingMarginLength);
            }
        } else {
            this.transform.translateX.setValue(this.xAxisLeadingMarginLength);
            if (hasSelection) {
                this.selectionComposite.transform.translateX.setValue(this.xAxisLeadingMarginLength);
            }
        }
        if (xAxisPrimary && xAxis != null) {
            this.transform.translateY.setValue((double)this.catAxisAdj + this.yAxisLeadingMarginLength);
            if (hasSelection) {
                this.selectionComposite.transform.translateY.setValue((double)this.catAxisAdj + this.yAxisLeadingMarginLength);
            }
        } else {
            this.transform.translateY.setValue(this.yAxisLeadingMarginLength);
            if (hasSelection) {
                this.selectionComposite.transform.translateY.setValue(this.yAxisLeadingMarginLength);
            }
        }
        this.riskMap = plotModel.getRiskMap();
        boolean isRiskMap = this.riskMap != null;
        int gridVisibility = xAxisModel.getGridLineStyle().getVisibilityPolicy();
        boolean xGridVisible = gridVisibility == 10201 || gridVisibility == 10200 && (dim3D || isRiskMap);
        Grid xGrid = xGridVisible ? new Grid() : null;
        gridVisibility = yAxisModel.getGridLineStyle().getVisibilityPolicy();
        boolean yGridVisible = gridVisibility == 10201 || gridVisibility == 10200 && (dim3D || isRiskMap);
        Grid yGrid = yGridVisible || isRiskMap ? new Grid() : null;
        gridVisibility = y2AxisModel == null ? 10202 : y2AxisModel.getGridLineStyle().getVisibilityPolicy();
        boolean y2GridVisible = gridVisibility == 10201 || gridVisibility == 10200 && dim3D;
        Grid y2Grid = y2GridVisible ? new Grid() : null;
        LineStyle frameStyle = graphModel.getFrameLineStyle();
        boolean isFrameVisible = cellModel.getFrameVisible();
        int n2 = frameWidth = isFrameVisible ? (int)frameStyle.getThickness().getMagnitude((Object)"px") : 0;
        if (this.riskMap != null) {
            boolean reverseY;
            boolean reverseX;
            boolean descReverseY;
            double xDataBegin = Double.MAX_VALUE;
            double xDataEnd = Double.MIN_VALUE;
            double yDataBegin = Double.MAX_VALUE;
            double yDataEnd = Double.MIN_VALUE;
            double[] xArray = new double[this.riskMap.getXSegmentedRange().length - 1];
            double[] yArray = new double[this.riskMap.getYSegmentedRange().length - 1];
            xArray = this.riskMap.getXSegmentedRange();
            yArray = this.riskMap.getYSegmentedRange();
            xDataBegin = Double.isNaN(xAxisModel.getMinimum()) ? xArray[0] : xAxisModel.getMinimum();
            xDataEnd = Double.isNaN(xAxisModel.getMaximum()) ? xArray[xArray.length - 1] : xAxisModel.getMaximum();
            yDataBegin = Double.isNaN(yAxisModel.getMinimum()) ? yArray[0] : yAxisModel.getMinimum();
            yDataEnd = Double.isNaN(yAxisModel.getMaximum()) ? yArray[yArray.length - 1] : yAxisModel.getMaximum();
            if (this.xMapper[0] instanceof ContinuousRangeToNumericMapper && this.xMapper.length > 0) {
                if (((ContinuousRangeToNumericMapper)this.xMapper[0]).getInputMax() < ((ContinuousRangeToNumericMapper)this.xMapper[0]).getInputMin()) {
                    xDataEnd = Math.max(((ContinuousRangeToNumericMapper)this.xMapper[0]).getInputMin(), xDataEnd);
                    xDataBegin = Math.min(((ContinuousRangeToNumericMapper)this.xMapper[0]).getInputMax(), xDataBegin);
                } else {
                    xDataBegin = Math.min(((ContinuousRangeToNumericMapper)this.xMapper[0]).getInputMin(), xDataBegin);
                    xDataEnd = Math.max(((ContinuousRangeToNumericMapper)this.xMapper[0]).getInputMax(), xDataEnd);
                }
            }
            if (this.yMapper[0] instanceof ContinuousRangeToNumericMapper && this.xMapper.length > 0) {
                if (((ContinuousRangeToNumericMapper)this.yMapper[0]).getInputMax() < ((ContinuousRangeToNumericMapper)this.yMapper[0]).getInputMin()) {
                    yDataEnd = Math.max(((ContinuousRangeToNumericMapper)this.yMapper[0]).getInputMin(), yDataEnd);
                    yDataBegin = Math.min(((ContinuousRangeToNumericMapper)this.yMapper[0]).getInputMax(), yDataBegin);
                } else {
                    yDataBegin = Math.min(((ContinuousRangeToNumericMapper)this.yMapper[0]).getInputMin(), yDataBegin);
                    yDataEnd = Math.max(((ContinuousRangeToNumericMapper)this.yMapper[0]).getInputMax(), yDataEnd);
                }
            }
            int imageWidth = this.xAxisCellModel.getLength().intValue();
            int imageHeight = this.yAxisCellModel.getLength().intValue();
            Image image = this.riskMap.createImage(imageWidth, imageHeight, xDataBegin, xDataEnd, yDataBegin, yDataEnd);
            boolean descReverseX = xArray[0] > xArray[xArray.length - 1];
            if ((image = ScatterComposite.translateRiskMap(image, descReverseX, descReverseY = yArray[0] > yArray[yArray.length - 1], reverseX = xAxisModel.isReverseDirection(), reverseY = yAxisModel.isReverseDirection())) != null) {
                yGrid.getStyle().setBackgroundOn(true);
                yGrid.getStyle().setBackgroundImage(image);
                yGrid.getStyle().setBackgroundColor(plotModel.getAxisWallModel().getWallFillStyle().getSolidFillColor());
            }
        }
        LineSegment xzGrid = dim3D && xGridVisible ? new LineSegment() : null;
        LineSegment yzGrid = dim3D && yGridVisible ? new LineSegment() : null;
        LineSegment lineSegment = y2zGrid = dim3D && y2GridVisible ? new LineSegment() : null;
        if (!yAxisModel.isGridInFront()) {
            if (yGrid != null) {
                this.addElement((Element)yGrid);
            }
            if (yzGrid != null) {
                this.addElement((Element)yzGrid);
            }
        }
        if (y2GridVisible && !y2AxisModel.isGridInFront()) {
            if (y2Grid != null) {
                this.addElement((Element)y2Grid);
            }
            if (y2zGrid != null) {
                this.addElement((Element)y2zGrid);
            }
        }
        if (!xAxisModel.isGridInFront()) {
            if (xGrid != null) {
                this.addElement((Element)xGrid);
            }
            if (xzGrid != null) {
                this.addElement((Element)xzGrid);
            }
        }
        if (xAxis != null) {
            this.addElement((Element)xAxis);
            if (xAxisPrimary) {
                xAxis.transform.translateY.setValue(-this.yAxisLeadingMarginLength);
            } else {
                xAxis.setPrimary(false);
                xAxis.transform.translateY.setValue(this.yAxisLength - this.yAxisLeadingMarginLength);
            }
        }
        if (xAxisLabel != null) {
            xAxisLabel.trimOn.setValue(false);
            this.addElement((Element)xAxisLabel);
        }
        if (yAxis != null) {
            this.addElement((Element)yAxis);
            if (yAxisPrimary) {
                yAxis.transform.translateX.setValue(-this.xAxisLeadingMarginLength + (double)yAdj - 2.0);
            } else {
                yAxis.setPrimary(false);
                yAxis.transform.translateX.setValue(this.xAxisLength - this.xAxisLeadingMarginLength);
            }
        }
        if (y2Axis != null) {
            this.addElement((Element)y2Axis);
        }
        if (yAxisLabel != null) {
            yAxisLabel.trimOn.setValue(false);
            this.addElement((Element)yAxisLabel);
        }
        if (y2AxisLabel != null) {
            y2AxisLabel.trimOn.setValue(false);
            this.addElement((Element)y2AxisLabel);
        }
        double xBaseline = plotModel.getXAxisBaseline();
        if (numericX) {
            ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)this.xMapper[0];
            if (!Double.isInfinite(xBaseline)) {
                xBaseline = cm.getValue(xBaseline);
            }
            if (xBaseline < cm.getOutputMin() || Double.isNaN(xBaseline)) {
                xBaseline = -this.xAxisLeadingMarginLength;
            } else if (xBaseline > cm.getOutputMax()) {
                xBaseline = this.xAxisLength - this.xAxisLeadingMarginLength;
            } else {
                StrokeLineStyle lineStyle = xAxisModel.getAxisLineStyle();
                this.addALine(this, new double[]{xBaseline, xBaseline, -this.yAxisLeadingMarginLength, -this.yAxisLeadingMarginLength + this.yAxisLength}, lineStyle);
            }
        }
        double yBaseline = plotModel.getYAxisBaseline();
        if (numericY) {
            ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)this.yMapper[0];
            if (!Double.isInfinite(yBaseline)) {
                yBaseline = cm.getValue(yBaseline);
            }
            if (yBaseline < cm.getOutputMin() || Double.isNaN(yBaseline)) {
                yBaseline = -this.yAxisLeadingMarginLength;
            } else if (yBaseline > cm.getOutputMax()) {
                yBaseline = this.yAxisLength - this.yAxisLeadingMarginLength;
            } else {
                StrokeLineStyle lineStyle = yAxisModel != null ? yAxisModel.getAxisLineStyle() : y2AxisModel.getAxisLineStyle();
                this.addALine(this, new double[]{-this.xAxisLeadingMarginLength, -this.xAxisLeadingMarginLength + this.xAxisLength, yBaseline, yBaseline}, lineStyle);
            }
        }
        double y2Baseline = plotModel.getY2AxisBaseline();
        if (numericY2) {
            ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)this.y2Mapper[0];
            if (!Double.isInfinite(y2Baseline)) {
                y2Baseline = cm.getValue(y2Baseline);
            }
            if (y2Baseline < cm.getOutputMin() || Double.isNaN(y2Baseline)) {
                y2Baseline = -this.yAxisLeadingMarginLength;
            } else if (y2Baseline > cm.getOutputMax()) {
                y2Baseline = this.yAxisLength - this.yAxisLeadingMarginLength;
            } else {
                StrokeLineStyle lineStyle = y2AxisModel == null ? yAxisModel.getAxisLineStyle() : y2AxisModel.getAxisLineStyle();
                this.addALine(this, new double[]{-this.xAxisLeadingMarginLength, -this.xAxisLeadingMarginLength + this.xAxisLength, y2Baseline, y2Baseline}, lineStyle);
            }
        }
        Composite referenceLinesFrontComposite = new Composite();
        Composite referenceLinesBackComposite = new Composite();
        Composite response2ReferenceLinesFrontComposite = new Composite();
        Composite response2ReferenceLinesBackComposite = new Composite();
        this.addReferenceLines(numericX, xAxisModel, (Mapper)this.xMapper[0], this.xVariable[0], referenceLinesFrontComposite, referenceLinesBackComposite, this.xAxisTrailingMarginLength, this.yAxisTrailingMarginLength, true, row, column, 2, 4);
        if (validY) {
            this.addReferenceLines(numericY, yAxisModel, (Mapper)this.yMapper[0], this.yVariable[0], referenceLinesFrontComposite, referenceLinesBackComposite, this.xAxisTrailingMarginLength, this.yAxisTrailingMarginLength, false, row, column, 2, 4);
        }
        if (this.y2Mapper != null && this.y2Mapper.length > 0 && this.y2Mapper[0] != null) {
            this.addReferenceLines(numericY2, y2AxisModel, (Mapper)this.y2Mapper[0], this.y2Variable[0], referenceLinesFrontComposite, referenceLinesBackComposite, this.xAxisTrailingMarginLength, this.yAxisTrailingMarginLength, false, row, column, 4, 2);
        }
        if (referenceLinesBackComposite.getElementCount() > 0) {
            this.addElement((Element)referenceLinesBackComposite);
        }
        if (response2ReferenceLinesBackComposite.getElementCount() > 0) {
            this.addElement((Element)response2ReferenceLinesBackComposite);
        }
        ColorMapper mc = cellModel.getMarkerColorMapper();
        ColorMapper lc = cellModel.getLineColorMapper();
        ColorMapper fc = cellModel.getFillColorMapper();
        StringToNumberMapper numberMapper = cellModel.getMarkerMapper();
        LineStyle outline = des.getOutlineLineStyle();
        Color markerOutlineColor = outline.getVisibilityPolicy() == 10200 ? null : des.getOutlineLineStyle().getColor();
        StrokeLineStyle[] lineStyles = des.getLineStyles();
        FillStyle[] fillStyles = des.getFillStyles();
        ColorProperty markerColor = new ColorProperty();
        ColorProperty lineColor = new ColorProperty();
        ColorProperty fillColor = new ColorProperty();
        if (this.colorVariable == null) {
            if (overlayNum + overlayNum2 > 1) {
                markerColor = null;
                lineColor = null;
                fillColor = null;
            } else {
                markerColor.setValue(markerStyles[0].getColor());
                lineColor.setValue(lineStyles[0].getColor());
                fillColor.setValue(fillStyles[0].getSolidFillColor());
            }
        }
        boolean stringColor = this.colorVariable instanceof StringVariable;
        boolean bl2 = this.groupByColor = cellModel.getGroupByColor() != false && this.colorVariable != null;
        if (stringColor || this.groupByColor) {
            if (scatter) {
                markerColorMapper = new StringToColorMapper();
                markerColorMapper.shareMap((StringToColorMapper)mc);
                if (stringColor) {
                    markerColorMapper.input.connectFrom(((StringVariable)this.colorVariable).formattedValue);
                } else {
                    markerColorMapper.input.connectFrom(((NumericVariable)this.colorVariable).formattedValue);
                }
                markerColor.connectFrom((ColorPipe)markerColorMapper);
            }
            if (line) {
                StringToColorMapper lineColorMapper = new StringToColorMapper();
                if (lc != null) {
                    lineColorMapper.shareMap((StringToColorMapper)lc);
                }
                if (stringColor) {
                    lineColorMapper.input.connectFrom(((StringVariable)this.colorVariable).formattedValue);
                } else {
                    lineColorMapper.input.connectFrom(((NumericVariable)this.colorVariable).formattedValue);
                }
                lineColor.connectFrom((ColorPipe)lineColorMapper);
            }
            if (fill) {
                StringToColorMapper fillColorMapper = new StringToColorMapper();
                fillColorMapper.shareMap((StringToColorMapper)fc);
                if (stringColor) {
                    fillColorMapper.input.connectFrom(((StringVariable)this.colorVariable).formattedValue);
                } else {
                    fillColorMapper.input.connectFrom(((NumericVariable)this.colorVariable).formattedValue);
                }
                fillColor.connectFrom((ColorPipe)fillColorMapper);
            }
        } else if (this.colorVariable instanceof NumericVariable) {
            markerColorMapper = new ContinuousRangeToColorMapper();
            if (mc != null) {
                markerColorMapper.shareMap((ContinuousRangeToColorMapper)mc);
            } else if (lc != null) {
                markerColorMapper.shareMap((ContinuousRangeToColorMapper)lc);
            }
            markerColorMapper.input.connectFrom(((NumericVariable)this.colorVariable).value);
            markerColor = new ColorProperty();
            markerColor.connectFrom((ColorPipe)markerColorMapper);
            lineColor = markerColor;
            fillColor = markerColor;
        }
        NumericPipe styleProperty = null;
        NumericPipe styleSelectionProperty = null;
        if (numberMapper != null && this.shapeVariable != null) {
            StringToNumberMapper markerMapper = new StringToNumberMapper();
            markerMapper.shareMap(numberMapper);
            markerMapper.input.connectFrom(this.shapeVariable.formattedValue);
            styleProperty = markerMapper.value;
            if (hasSelection) {
                StringToNumberMapper msMapper = new StringToNumberMapper();
                msMapper.shareMap(markerMapper);
                if (this.shapeVariableSelection instanceof StringVariable) {
                    msMapper.input.connectFrom(((StringVariable)this.shapeVariableSelection).formattedValue);
                } else {
                    msMapper.input.connectFrom(((NumericVariable)this.shapeVariableSelection).formattedValue);
                }
                styleSelectionProperty = msMapper.value;
            }
        }
        StringToNumberMapper markerSizeMapper = cellModel.getMarkerSizeMapper();
        if (!sizeFlag && this.groupVariable != null) {
            StringToNumberMapper markerMapper = new StringToNumberMapper();
            markerMapper.shareMap(markerSizeMapper);
            if (this.groupVariable != null) {
                markerMapper.input.connectFrom(this.groupVariable.formattedValue);
            }
            markerScale.connectFrom(markerMapper.value);
            sizeFlag = true;
            if (hasSelection) {
                StringToNumberMapper msMapper = new StringToNumberMapper();
                msMapper.shareMap(markerSizeMapper);
                if (this.groupVariableSelection != null) {
                    if (this.groupVariableSelection instanceof StringVariable) {
                        msMapper.input.connectFrom(((StringVariable)this.groupVariableSelection).formattedValue);
                    } else {
                        msMapper.input.connectFrom(((NumericVariable)this.groupVariableSelection).formattedValue);
                    }
                }
                markerSelectionScale.connectFrom(msMapper.value);
            }
        }
        int connectionOrder = 40100;
        boolean joinVisible = true;
        boolean needlesVisible = false;
        boolean skipMissing = plotModel.getSkipMissing();
        NumericProperty lineScale = new NumericProperty();
        lineScale.setValue(2.0);
        boolean markerVisible = false;
        int count = Math.min(overlayNum + overlayNum2, markerStyles.length);
        if (scatter) {
            int i = 0;
            while (i < count & !markerVisible) {
                MarkerStyle ms = Util.newCycledMarkerStyle(markerStyles, cycleColors, i);
                markerVisible = scatter & ms.isVisible();
                ++i;
            }
        }
        Color color = null;
        Color selectionColor = graphModel.getBrushModel().getSelectionColor();
        Color selectionAccentColor = graphModel.getBrushModel().getSelectionAccentColor();
        ColorProperty selectionMarkerEdgeColor = null;
        if (hasSelection) {
            StringToColorMapper markerColorMapper2;
            if (stringColor || this.groupByColor) {
                if (scatter) {
                    markerColorMapper2 = new StringToColorMapper();
                    markerColorMapper2.shareMap((StringToColorMapper)mc);
                    if (stringColor) {
                        markerColorMapper2.input.connectFrom(((StringVariable)this.colorVariableSelection).formattedValue);
                    } else {
                        markerColorMapper2.input.connectFrom(((NumericVariable)this.colorVariableSelection).formattedValue);
                    }
                    selectionMarkerEdgeColor = new ColorProperty();
                    selectionMarkerEdgeColor.connectFrom((ColorPipe)markerColorMapper2);
                }
            } else if (this.colorVariable instanceof NumericVariable) {
                markerColorMapper2 = new ContinuousRangeToColorMapper();
                if (mc != null) {
                    markerColorMapper2.shareMap((ContinuousRangeToColorMapper)mc);
                } else if (lc != null) {
                    markerColorMapper2.shareMap((ContinuousRangeToColorMapper)lc);
                }
                markerColorMapper2.input.connectFrom(((NumericVariable)this.colorVariableSelection).value);
                selectionMarkerEdgeColor = new ColorProperty();
                selectionMarkerEdgeColor.connectFrom((ColorPipe)markerColorMapper2);
            }
        }
        LineStyle needleLS = plotModel.getNeedleLineStyle();
        double needleSize = needleLS.getThickness().getMagnitude((Object)"py");
        boolean useNeedleColor = plotModel.getUseNeedleColor();
        if (useNeedleColor) {
            needleCP = new ColorProperty();
            needleCP.setValue(needleLS.getColor());
        } else {
            needleCP = markerColor == null ? new ColorProperty() : markerColor;
        }
        if (!useNeedleColor) {
            useNeedleColor = markerColor != null;
        }
        boolean useErrorColor = plotModel.getUseErrorColor();
        ColorProperty errorCP = null;
        if (!useErrorColor) {
            errorCP = markerColor;
        }
        ColorProperty errorSelectionCP = null;
        ColorProperty needleSelectionCP = null;
        if (hasSelection) {
            errorSelectionCP = new ColorProperty();
            errorSelectionCP.setValue(selectionColor);
            needleSelectionCP = new ColorProperty();
            needleSelectionCP.setValue(selectionColor);
        }
        int aboveContentType = plotModel.getAboveContentType();
        int belowContentType = plotModel.getBelowContentType();
        double tukeyWidth = this.xMapper[0] instanceof StringToNumericMapper ? ((StringToNumericMapper)this.xMapper[0]).getStrideValue() * 0.8 : (this.xAxisLength - this.xAxisLeadingMarginLength - this.xAxisTrailingMarginLength) * 0.8 / (double)(this.xAxisCellModel.getValueCount() - 1);
        tukeyWidth = Math.max(5.0, Math.min(40.0, tukeyWidth));
        Composite lineComposite = new Composite();
        Composite markerComposite = new Composite();
        Composite labelComposite = new Composite();
        if (hasSelection) {
            s1 = new Composite();
        }
        for (int i = 0; i < overlayNum; ++i) {
            ColorProperty labelColor;
            int joinType;
            MarkerStyle ms = Util.newCycledMarkerStyle(markerStyles, cycleColors, i);
            StrokeLineStyle ls = Util.newCycledLineStyle(lineStyles, cycleColors, i);
            FillStyle fs = Util.newCycledFillStyle(fillStyles, cycleColors, i);
            if (line || fill) {
                joinType = ms.getInterpolation();
                connectionOrder = ms.getConnectionOrder();
                if (line && joinType != 40009) {
                    needlesVisible = joinType == 40007 && numericY || joinType == 40008 && numericX;
                    joinVisible = !needlesVisible && joinType != 40000;
                } else {
                    needlesVisible = false;
                    joinVisible = false;
                }
            } else {
                joinVisible = false;
                needlesVisible = false;
                joinType = 40000;
            }
            NumericMapper xiMapper = this.xMapper[0];
            NumericMapper yiMapper = this.yMapper[0];
            int xIndex = 0;
            int yIndex = 0;
            Variable xiVariable = this.xVariable[0];
            Variable yiVariable = this.yVariable[0];
            if (combOverlay) {
                xIndex = i;
                yIndex = i;
                xiVariable = this.xVariable[xIndex];
                yiVariable = this.yVariable[yIndex];
                if (i == 0) {
                    xiMapper = this.xMapper[0];
                    yiMapper = this.yMapper[0];
                } else {
                    if (this.xMapper[0] instanceof ContinuousRangeToNumericMapper) {
                        xiMapper = new ContinuousRangeToNumericMapper();
                        ((ContinuousRangeToNumericMapper)xiMapper).input.connectFrom(((NumericVariable)xiVariable).value);
                        ((ContinuousRangeToNumericMapper)xiMapper).shareMap((ContinuousRangeToNumericMapper)this.xMapper[0]);
                    } else {
                        xiMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)xiMapper).input.connectFrom(((StringVariable)xiVariable).value);
                        ((StringToNumericMapper)xiMapper).shareMap((StringToNumericMapper)this.xMapper[0]);
                    }
                    xiMapper.setFormat(this.xMapper[0].getFormat());
                    this.xMapper[xIndex] = xiMapper;
                    if (this.yMapper[0] instanceof ContinuousRangeToNumericMapper) {
                        yiMapper = new ContinuousRangeToNumericMapper();
                        ((ContinuousRangeToNumericMapper)yiMapper).input.connectFrom(((NumericVariable)yiVariable).value);
                        ((ContinuousRangeToNumericMapper)yiMapper).shareMap((ContinuousRangeToNumericMapper)this.yMapper[0]);
                    } else {
                        yiMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)yiMapper).input.connectFrom(((StringVariable)yiVariable).value);
                        ((StringToNumericMapper)yiMapper).shareMap((StringToNumericMapper)this.yMapper[0]);
                    }
                    yiMapper.setFormat(this.yMapper[0].getFormat());
                    this.yMapper[yIndex] = yiMapper;
                }
            } else if (xOverlay) {
                xIndex = i;
                xiVariable = this.xVariable[i];
                if (i == 0) {
                    xiMapper = this.xMapper[0];
                } else {
                    if (this.xMapper[0] instanceof ContinuousRangeToNumericMapper) {
                        xiMapper = new ContinuousRangeToNumericMapper();
                        ((ContinuousRangeToNumericMapper)xiMapper).input.connectFrom(((NumericVariable)xiVariable).value);
                        ((ContinuousRangeToNumericMapper)xiMapper).shareMap((ContinuousRangeToNumericMapper)this.xMapper[0]);
                    } else {
                        xiMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)xiMapper).input.connectFrom(((StringVariable)xiVariable).value);
                        ((StringToNumericMapper)xiMapper).shareMap((StringToNumericMapper)this.xMapper[0]);
                    }
                    xiMapper.setFormat(this.xMapper[0].getFormat());
                    this.xMapper[i] = xiMapper;
                }
            } else if (yOverlay) {
                yIndex = i;
                yiVariable = this.yVariable[i];
                if (i == 0) {
                    yiMapper = this.yMapper[0];
                } else {
                    if (this.yMapper[0] instanceof ContinuousRangeToNumericMapper) {
                        this.yMapper[i] = yiMapper = new ContinuousRangeToNumericMapper();
                        ((ContinuousRangeToNumericMapper)yiMapper).input.connectFrom(((NumericVariable)yiVariable).value);
                        ((ContinuousRangeToNumericMapper)yiMapper).shareMap((ContinuousRangeToNumericMapper)this.yMapper[0]);
                    } else {
                        this.yMapper[i] = yiMapper = new StringToNumericMapper();
                        ((StringToNumericMapper)yiMapper).input.connectFrom(((StringVariable)yiVariable).value);
                        ((StringToNumericMapper)yiMapper).shareMap((StringToNumericMapper)this.yMapper[0]);
                    }
                    yiMapper.setFormat(this.yMapper[0].getFormat());
                }
            }
            if (i == 0 && (xiMapper instanceof ContinuousRangeToNumericMapper && Double.isNaN(((ContinuousRangeToNumericMapper)xiMapper).getOutputMin()) || yiMapper instanceof ContinuousRangeToNumericMapper && Double.isNaN(((ContinuousRangeToNumericMapper)yiMapper).getOutputMin()))) break;
            if (joinVisible || fill) {
                if (lineColor != null && !this.groupByColor) {
                    try {
                        color = lineColor.getValue(i);
                    }
                    catch (MissingValueException missingValueException) {}
                } else {
                    color = ls.getColor();
                }
                Element element = this.addLines(lineComposite, xiMapper, yiMapper, lineColor, i, lineStyles, cycleColors, color, joinType, connectionOrder, skipMissing);
                if (fill) {
                    if (fillColor != null && !this.groupByColor) {
                        try {
                            color = fillColor.getValue(i);
                        }
                        catch (MissingValueException missingValueException) {}
                    } else {
                        color = fs.getSolidFillColor();
                    }
                    if (element instanceof FilledLineConnector) {
                        FilledLineConnector connector2 = (FilledLineConnector)element;
                        connector2.fillOn.setValue(true);
                        connector2.fillColor.setValue(color);
                        connector2.setFillToPlane(Plane.XZ);
                        if (!line) {
                            connector2.lineOn.setValue(false);
                        }
                    } else if (element instanceof Switch) {
                        Switch s = (Switch)element;
                        int ecount = s.getChoiceCount();
                        for (int e = 0; e < ecount; ++e) {
                            element = s.getChoice(e);
                            if (!(element instanceof FilledLineConnector)) continue;
                            connector3 = (FilledLineConnector)element;
                            connector3.fillOn.setValue(true);
                            connector3.fillColor.connectFrom((ColorPipe)fillColor);
                            if (connectionOrder != 40100) {
                                ColorCache colorCache = new ColorCache();
                                colorCache.input.connectFrom((ColorPipe)fillColor);
                                if (connector3.fillColor.isConnected()) {
                                    colorCache.input.connectFrom(connector3.fillColor.getConnection());
                                    connector3.fillColor.connectFrom((ColorPipe)colorCache);
                                }
                            } else {
                                connector3.fillColor.connectFrom((ColorPipe)fillColor);
                            }
                            connector3.setFillToPlane(Plane.XZ);
                            if (line) continue;
                            connector3.lineOn.setValue(false);
                        }
                    }
                }
            }
            if (scatter && valueCount > 0 && ms.isVisible()) {
                if (markerColor != null && !this.groupByColor) {
                    try {
                        color = markerColor.getValue(i);
                    }
                    catch (MissingValueException element) {}
                } else {
                    color = ms.getColor();
                }
            }
            if (!useErrorColor && markerColor == null) {
                errorCP = new ColorProperty();
                errorCP.setValue(color);
            }
            this.addErrors(markerComposite, des, xiMapper, yiMapper, errorCP, xIndex, yIndex, true, false);
            if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName()))) {
                this.addErrors(s1, des, this.xMapperSelection[xIndex], this.yMapperSelection[yIndex], errorSelectionCP, xIndex, yIndex, true, true);
            }
            if (needlesVisible) {
                if (!useNeedleColor) {
                    needleCP = new ColorProperty();
                    needleCP.setValue(color);
                }
                if (joinType == 40007) {
                    this.addVerticalNeedles(lineComposite, xiMapper, yiMapper, needleCP, needleSize, yBaseline);
                    if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName()))) {
                        this.addVerticalNeedles(s1, this.xMapperSelection[xIndex], this.yMapperSelection[yIndex], needleSelectionCP, needleSize, yBaseline);
                    }
                } else {
                    this.addHorizontalNeedles(lineComposite, xiMapper, yiMapper, needleCP, needleSize, xBaseline);
                    if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName()))) {
                        this.addHorizontalNeedles(s1, this.xMapperSelection[xIndex], this.yMapperSelection[yIndex], needleSelectionCP, needleSize, xBaseline);
                    }
                }
            }
            if (scatter && ms.isVisible()) {
                if (!sizeFlag) {
                    markerScale = new NumericProperty();
                    markerScale.setValue(markerStyles[i % markerStyles.length].getSize().getMagnitude((Object)"py"));
                    if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName()))) {
                        markerSelectionScale = markerScale;
                    }
                }
                if (joinType == 40009 && yiVariable instanceof NumericVariable) {
                    this.addTukeyBox(markerComposite, xiMapper, yiMapper, (NumericVariable)yiVariable, tukeyWidth, markerColor, markerScale, color, markerOutlineColor, ms.getSymbol(), styleProperty);
                    if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName()))) {
                        this.addTukeyBox(s1, this.xMapperSelection[xIndex], this.yMapperSelection[yIndex], (NumericVariable)this.yVariableSelection[yIndex], tukeyWidth, null, markerSelectionScale, selectionColor, selectionColor, ms.getSymbol(), styleSelectionProperty);
                    }
                } else {
                    Marker marker;
                    this.addMarkers(markerComposite, xiMapper, yiMapper, markerColor, markerScale, color, markerOutlineColor, ms.getSymbol(), styleProperty, xiVariable.getName(), yiVariable.getName(), selectionColor, selectionAccentColor, this.xSelectionVariable != null && this.xSelectionVariable.length > xIndex ? this.xSelectionVariable[xIndex] : null, this.ySelectionVariable != null && this.ySelectionVariable.length > xIndex ? this.ySelectionVariable[yIndex] : null, xiVariable, yiVariable);
                    if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName())) && (marker = this.addMarkers(s1, this.xMapperSelection[xIndex], this.yMapperSelection[yIndex], null, markerSelectionScale, selectionColor, selectionAccentColor, ms.getSymbol(), styleSelectionProperty, this.xVariableSelection[xIndex].getName(), this.yVariableSelection[yIndex].getName(), null, null, null, null, null, null)) != null && selectionMarkerEdgeColor != null) {
                        marker.edgeColor.connectFrom((ColorPipe)selectionMarkerEdgeColor);
                    }
                }
            }
            switch (aboveContentType) {
                default: {
                    break;
                }
                case 10601: {
                    this.aboveValueVariable = null;
                    this.aboveValueVariableSelection = null;
                    break;
                }
                case 10604: {
                    this.aboveValueVariable = xiVariable;
                    if (!hasSelection) break;
                    this.aboveValueVariableSelection = this.xVariableSelection[xIndex];
                    break;
                }
                case 10605: {
                    this.aboveValueVariable = yiVariable;
                    if (!hasSelection) break;
                    this.aboveValueVariableSelection = this.yVariableSelection[yIndex];
                }
            }
            switch (belowContentType) {
                default: {
                    break;
                }
                case 10601: {
                    this.belowValueVariable = null;
                    this.belowValueVariableSelection = null;
                    break;
                }
                case 10604: {
                    this.belowValueVariable = xiVariable;
                    if (!hasSelection) break;
                    this.belowValueVariableSelection = this.xVariableSelection[xIndex];
                    break;
                }
                case 10605: {
                    this.belowValueVariable = yiVariable;
                    if (!hasSelection) break;
                    this.belowValueVariableSelection = this.yVariableSelection[yIndex];
                }
            }
            if (markerColor == null) {
                labelColor = new ColorProperty();
                labelColor.setValue(color);
                this.addLabels(labelComposite, plotModel, xiMapper, yiMapper, markerScale, labelColor, false);
            } else {
                this.addLabels(labelComposite, plotModel, xiMapper, yiMapper, markerScale, markerColor, false);
            }
            if (!hasSelection) continue;
            labelColor = new ColorProperty();
            labelColor.setValue(selectionColor);
            this.addLabels(s1, plotModel, this.xMapperSelection[xIndex], this.yMapperSelection[yIndex], markerSelectionScale, labelColor, true);
        }
        Composite line2Composite = null;
        Composite marker2Composite = null;
        Composite label2Composite = null;
        if (y2) {
            line2Composite = new Composite();
            marker2Composite = new Composite();
            label2Composite = new Composite();
            line2Composite.transform.translateY.setValue(this.y2AxisLeadingMarginLength - this.yAxisLeadingMarginLength);
            marker2Composite.transform.translateY.setValue(this.y2AxisLeadingMarginLength - this.yAxisLeadingMarginLength);
            label2Composite.transform.translateY.setValue(this.y2AxisLeadingMarginLength - this.yAxisLeadingMarginLength);
            if (hasSelection) {
                s2 = new Composite();
                s2.transform.translateY.setValue(this.y2AxisLeadingMarginLength - this.yAxisLeadingMarginLength);
            }
            for (int i = 0; i < overlayNum2; ++i) {
                ColorProperty labelColor;
                int joinType;
                MarkerStyle ms = Util.newCycledMarkerStyle(markerStyles, cycleColors, overlayNum + i);
                StrokeLineStyle ls = Util.newCycledLineStyle(lineStyles, cycleColors, overlayNum + i);
                FillStyle fs = Util.newCycledFillStyle(fillStyles, cycleColors, overlayNum + i);
                NumericMapper xiMapper = this.xMapper[0];
                NumericMapper yiMapper = this.y2Mapper[0];
                int xIndex = 0;
                int yIndex = 0;
                Variable xiVariable = this.xVariable[0];
                Variable yiVariable = this.y2Variable[0];
                if (combOverlay) {
                    xIndex = i + overlayNum;
                    if (xIndex == 0) {
                        xiMapper = this.xMapper[0];
                    } else {
                        xiVariable = this.xVariable[xIndex];
                        if (this.xMapper[0] instanceof ContinuousRangeToNumericMapper) {
                            xiMapper = new ContinuousRangeToNumericMapper();
                            ((ContinuousRangeToNumericMapper)xiMapper).input.connectFrom(((NumericVariable)xiVariable).value);
                            ((ContinuousRangeToNumericMapper)xiMapper).shareMap((ContinuousRangeToNumericMapper)this.xMapper[0]);
                        } else {
                            xiMapper = new StringToNumericMapper();
                            ((StringToNumericMapper)xiMapper).input.connectFrom(((StringVariable)xiVariable).value);
                            ((StringToNumericMapper)xiMapper).shareMap((StringToNumericMapper)this.xMapper[0]);
                        }
                        xiMapper.setFormat(this.xMapper[0].getFormat());
                        this.xMapper[xIndex] = xiMapper;
                    }
                    yIndex = i;
                    yiVariable = this.y2Variable[yIndex];
                    if (yIndex == 0) {
                        yiMapper = this.y2Mapper[0];
                    } else {
                        if (this.y2Mapper[0] instanceof ContinuousRangeToNumericMapper) {
                            this.y2Mapper[yIndex] = yiMapper = new ContinuousRangeToNumericMapper();
                            ((ContinuousRangeToNumericMapper)yiMapper).input.connectFrom(((NumericVariable)yiVariable).value);
                            ((ContinuousRangeToNumericMapper)yiMapper).shareMap((ContinuousRangeToNumericMapper)this.y2Mapper[0]);
                        } else {
                            this.y2Mapper[yIndex] = yiMapper = new StringToNumericMapper();
                            ((StringToNumericMapper)yiMapper).input.connectFrom(((StringVariable)yiVariable).value);
                            ((StringToNumericMapper)yiMapper).shareMap((StringToNumericMapper)this.y2Mapper[0]);
                        }
                        yiMapper.setFormat(this.y2Mapper[0].getFormat());
                    }
                } else if (xOverlay) {
                    xIndex = i;
                    if (i == 0) {
                        xiMapper = this.xMapper[0];
                    } else {
                        xiVariable = this.xVariable[i];
                        if (this.xMapper[0] instanceof ContinuousRangeToNumericMapper) {
                            xiMapper = new ContinuousRangeToNumericMapper();
                            ((ContinuousRangeToNumericMapper)xiMapper).input.connectFrom(((NumericVariable)xiVariable).value);
                            ((ContinuousRangeToNumericMapper)xiMapper).shareMap((ContinuousRangeToNumericMapper)this.xMapper[0]);
                        } else {
                            xiMapper = new StringToNumericMapper();
                            ((StringToNumericMapper)xiMapper).input.connectFrom(((StringVariable)xiVariable).value);
                            ((StringToNumericMapper)xiMapper).shareMap((StringToNumericMapper)this.xMapper[0]);
                        }
                        xiMapper.setFormat(this.xMapper[0].getFormat());
                        this.xMapper[i] = xiMapper;
                    }
                } else if (y2Overlay) {
                    yIndex = i;
                    yiVariable = this.y2Variable[i];
                    if (yIndex == 0) {
                        yiMapper = this.y2Mapper[0];
                    } else {
                        if (this.y2Mapper[0] instanceof ContinuousRangeToNumericMapper) {
                            this.y2Mapper[i] = yiMapper = new ContinuousRangeToNumericMapper();
                            ((ContinuousRangeToNumericMapper)yiMapper).input.connectFrom(((NumericVariable)yiVariable).value);
                            ((ContinuousRangeToNumericMapper)yiMapper).shareMap((ContinuousRangeToNumericMapper)this.y2Mapper[0]);
                        } else {
                            this.y2Mapper[i] = yiMapper = new StringToNumericMapper();
                            ((StringToNumericMapper)yiMapper).input.connectFrom(((StringVariable)yiVariable).value);
                            ((StringToNumericMapper)yiMapper).shareMap((StringToNumericMapper)this.y2Mapper[0]);
                        }
                        yiMapper.setFormat(this.y2Mapper[0].getFormat());
                    }
                }
                if (i == 0 && (xiMapper instanceof ContinuousRangeToNumericMapper && Double.isNaN(((ContinuousRangeToNumericMapper)xiMapper).getOutputMin()) || yiMapper instanceof ContinuousRangeToNumericMapper && Double.isNaN(((ContinuousRangeToNumericMapper)yiMapper).getOutputMin()))) break;
                if (line || fill) {
                    joinType = ms.getInterpolation();
                    connectionOrder = ms.getConnectionOrder();
                    if (line) {
                        needlesVisible = joinType == 40007 && numericY2 || joinType == 40008 && numericX;
                        joinVisible = !needlesVisible && joinType != 40000;
                    } else {
                        joinVisible = false;
                        needlesVisible = false;
                    }
                } else {
                    joinVisible = false;
                    needlesVisible = false;
                    joinType = 40000;
                }
                if (joinVisible || fill) {
                    if (lineColor != null && !this.groupByColor) {
                        try {
                            color = lineColor.getValue(overlayNum + i);
                        }
                        catch (MissingValueException e) {}
                    } else {
                        color = ls.getColor();
                    }
                    Element element = this.addLines(line2Composite, xiMapper, yiMapper, lineColor, overlayNum + i, lineStyles, cycleColors, color, joinType, connectionOrder, skipMissing);
                    if (fill) {
                        if (fillColor != null && !this.groupByColor) {
                            try {
                                color = fillColor.getValue(i);
                            }
                            catch (MissingValueException connector3) {}
                        } else {
                            color = fs.getSolidFillColor();
                        }
                        if (element instanceof FilledLineConnector) {
                            connector3 = (FilledLineConnector)element;
                            connector3.fillOn.setValue(true);
                            connector3.fillColor.setValue(color);
                            connector3.setFillToPlane(Plane.XZ);
                            if (!line) {
                                connector3.lineOn.setValue(false);
                            }
                        } else if (element instanceof Switch) {
                            Switch s = (Switch)element;
                            int ecount = s.getChoiceCount();
                            for (int e = 0; e < ecount; ++e) {
                                element = s.getChoice(e);
                                if (!(element instanceof FilledLineConnector)) continue;
                                FilledLineConnector connector4 = (FilledLineConnector)element;
                                connector4.fillOn.setValue(true);
                                connector4.fillColor.connectFrom((ColorPipe)fillColor);
                                if (connectionOrder != 40100) {
                                    ColorCache colorCache = new ColorCache();
                                    colorCache.input.connectFrom((ColorPipe)fillColor);
                                    if (connector4.fillColor.isConnected()) {
                                        colorCache.input.connectFrom(connector4.fillColor.getConnection());
                                        connector4.fillColor.connectFrom((ColorPipe)colorCache);
                                    }
                                } else {
                                    connector4.fillColor.connectFrom((ColorPipe)fillColor);
                                }
                                connector4.setFillToPlane(Plane.XZ);
                                if (line) continue;
                                connector4.lineOn.setValue(false);
                            }
                        }
                    }
                }
                if (scatter && ms.isVisible()) {
                    if (markerColor != null && !this.groupByColor) {
                        try {
                            color = markerColor.getValue(overlayNum + i);
                        }
                        catch (MissingValueException element) {}
                    } else {
                        color = ms.getColor();
                    }
                }
                if (!useErrorColor && markerColor == null) {
                    errorCP = new ColorProperty();
                    errorCP.setValue(color);
                }
                this.addErrors(marker2Composite, des, xiMapper, yiMapper, errorCP, xIndex, yIndex, false, false);
                if (hasSelection) {
                    this.addErrors(s2, des, this.xMapperSelection[xIndex], this.y2MapperSelection[yIndex], errorSelectionCP, xIndex, yIndex, false, true);
                }
                if (needlesVisible) {
                    if (!useNeedleColor) {
                        needleCP = new ColorProperty();
                        needleCP.setValue(color);
                    }
                    if (joinType == 40007) {
                        this.addVerticalNeedles(line2Composite, xiMapper, yiMapper, needleCP, needleSize, y2Baseline);
                        if (hasSelection) {
                            this.addVerticalNeedles(s2, this.xMapperSelection[xIndex], this.y2MapperSelection[yIndex], needleSelectionCP, needleSize, y2Baseline);
                        }
                    } else {
                        this.addHorizontalNeedles(line2Composite, xiMapper, yiMapper, needleCP, needleSize, xBaseline);
                        if (hasSelection && (cellModel.getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(this.xVariable[xIndex].getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(this.yVariable[yIndex].getRootVariable().getColumnName()))) {
                            this.addHorizontalNeedles(s2, this.xMapperSelection[xIndex], this.y2MapperSelection[yIndex], needleSelectionCP, needleSize, xBaseline);
                        }
                    }
                }
                if (scatter && ms.isVisible()) {
                    Marker marker;
                    if (!sizeFlag) {
                        markerScale = new NumericProperty();
                        markerScale.setValue(markerStyles[(i + overlayNum) % markerStyles.length].getSize().getMagnitude((Object)"py"));
                        if (hasSelection) {
                            markerSelectionScale = markerScale;
                        }
                    }
                    this.addMarkers(marker2Composite, xiMapper, yiMapper, markerColor, markerScale, color, markerOutlineColor, ms.getSymbol(), styleProperty, xiVariable.getName(), yiVariable.getName(), selectionColor, selectionAccentColor, this.xSelectionVariable != null && this.xSelectionVariable.length > xIndex ? this.xSelectionVariable[xIndex] : null, this.ySelectionVariable != null && this.ySelectionVariable.length > xIndex ? this.ySelectionVariable[yIndex] : null, xiVariable, yiVariable);
                    if (hasSelection && (marker = this.addMarkers(s2, this.xMapperSelection[xIndex], this.y2MapperSelection[yIndex], null, markerSelectionScale, selectionColor, selectionAccentColor, ms.getSymbol(), styleSelectionProperty, this.xVariableSelection[xIndex].getName(), this.y2VariableSelection[yIndex].getName(), null, null, null, null, null, null)) != null && selectionMarkerEdgeColor != null) {
                        marker.edgeColor.connectFrom((ColorPipe)selectionMarkerEdgeColor);
                    }
                }
                switch (aboveContentType) {
                    default: {
                        break;
                    }
                    case 10601: {
                        this.aboveValueVariable = null;
                        this.aboveValueVariableSelection = null;
                        break;
                    }
                    case 10604: {
                        this.aboveValueVariable = xiVariable;
                        if (!hasSelection) break;
                        this.aboveValueVariableSelection = this.xVariableSelection[xIndex];
                        break;
                    }
                    case 10605: {
                        this.aboveValueVariable = yiVariable;
                        if (!hasSelection) break;
                        this.aboveValueVariableSelection = this.y2VariableSelection[yIndex];
                    }
                }
                switch (belowContentType) {
                    default: {
                        break;
                    }
                    case 10601: {
                        this.belowValueVariable = null;
                        this.belowValueVariableSelection = null;
                        break;
                    }
                    case 10604: {
                        this.belowValueVariable = xiVariable;
                        if (!hasSelection) break;
                        this.belowValueVariableSelection = this.xVariableSelection[xIndex];
                        break;
                    }
                    case 10605: {
                        this.belowValueVariable = yiVariable;
                        if (!hasSelection) break;
                        this.belowValueVariableSelection = this.y2VariableSelection[yIndex];
                    }
                }
                if (markerColor == null) {
                    labelColor = new ColorProperty();
                    labelColor.setValue(color);
                    this.addLabels(label2Composite, plotModel, xiMapper, yiMapper, markerScale, labelColor, false);
                } else {
                    this.addLabels(label2Composite, plotModel, xiMapper, yiMapper, markerScale, markerColor, false);
                }
                if (!hasSelection) continue;
                labelColor = new ColorProperty();
                labelColor.setValue(selectionColor);
                this.addLabels(s2, plotModel, this.xMapperSelection[xIndex], this.y2MapperSelection[yIndex], markerSelectionScale, labelColor, true);
            }
        }
        if (valueCount > 0) {
            if (lineComposite.getElementCount() > 0) {
                this.addElement((Element)lineComposite);
            }
            if (line2Composite != null && line2Composite.getElementCount() > 0) {
                this.addElement((Element)line2Composite);
            }
            if (markerComposite.getElementCount() > 0) {
                this.addElement((Element)markerComposite);
            }
            if (marker2Composite != null && marker2Composite.getElementCount() > 0) {
                this.addElement((Element)marker2Composite);
            }
            if (labelComposite.getElementCount() > 0) {
                this.addElement((Element)labelComposite);
            }
            if (label2Composite != null && label2Composite.getElementCount() > 0) {
                this.addElement((Element)label2Composite);
            }
            if (hasSelection) {
                this.selectionComposite.addElement((Element)s1);
                if (s2 != null && s2.getElementCount() > 0) {
                    this.selectionComposite.addElement(s2);
                }
            }
        }
        if (referenceLinesFrontComposite.getElementCount() > 0) {
            this.addElement((Element)referenceLinesFrontComposite);
        }
        if (response2ReferenceLinesFrontComposite.getElementCount() > 0) {
            this.addElement((Element)response2ReferenceLinesFrontComposite);
        }
        if (backFrame instanceof Box) {
            Box box = (Box)backFrame;
            box.sizeX.setValue(this.xAxisLength);
            box.sizeY.setValue(this.yAxisLength);
            box.sizeZ.setValue((double)depth.width);
            box.color.setValue(axisWallModel.getWallFillStyle().getSolidFillColor());
            box.fillOn.setValue(true);
            box.transform.translateX.setValue(this.xAxisLength / 2.0 - this.xAxisLeadingMarginLength);
            box.transform.translateY.setValue(this.yAxisLength / 2.0 - this.yAxisLeadingMarginLength);
            box.transform.translateZ.setValue((double)(-depth.width / 2));
            box.origin.setValue(0);
            if (isFrameVisible) {
                box.edgeOn.setValue(true);
                box.edgeColor.setValue(frameStyle.getColor());
                frameWidth = 0;
            }
        } else {
            boolean lastRow;
            Grid frame2D = backFrame;
            GTKUtil.applyFillStyle(frame2D, axisWallModel.getWallFillStyle());
            int y2Adj = -Math.max(2, (frameWidth + 1) / 2);
            boolean lastCol = column < 0 || this.xAxisCellModel.getCellCount() == column + 1;
            boolean bl3 = lastRow = row < 0 || this.yAxisCellModel.getCellCount() == row + 1;
            if (lastCol && y2AxisModel != null && y2AxisModel.isVisible()) {
                int axisWidth = (int)y2AxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px");
                y2Adj = axisWidth >= frameWidth ? frameWidth : -(frameWidth + 1 - axisWidth) / 2;
            }
            int x2Adj = row == -1 ? frameWidth / 2 : -Math.max(1, (frameWidth + 1) / 2);
            int xAxisAdj = 2 * frameWidth;
            if (lastRow) {
                if (xAxisModel.isVisible()) {
                    int axisWidth = (int)xAxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"py");
                    if (axisWidth < frameWidth) {
                        xAxisAdj = -Math.max(0, (frameWidth + axisWidth) / 2);
                    } else if (this.xAxisCellModel.getAxisVisible().booleanValue()) {
                        xAxisAdj = 0;
                    }
                } else {
                    xAxisAdj = -(frameWidth + 1) / 2;
                }
            }
            int yAxisAdj = 2 * frameWidth;
            if (column <= 0) {
                if (validY && yAxisModel.isVisible()) {
                    int axisWidth = (int)yAxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px");
                    if (axisWidth < frameWidth) {
                        yAxisAdj = -(frameWidth + 1 - axisWidth) / 2;
                    }
                } else {
                    yAxisAdj = -(frameWidth + 1) / 2;
                }
            }
            GridStyle gridStyle = frame2D.getStyle();
            if (isFrameVisible) {
                gridStyle.setBorderOn(true);
                gridStyle.setMajorLineColor(frameStyle.getColor());
                gridStyle.setLineWidth(frameWidth);
                frame2D.setWidth(this.xAxisLength + (double)yAxisAdj + (double)y2Adj + 2.0);
                frame2D.setHeight(this.yAxisLength + (double)xAxisAdj + (double)x2Adj);
                frame2D.transform.translateX.setValue(-this.xAxisLeadingMarginLength - (double)yAxisAdj - 1.0);
                frame2D.transform.translateY.setValue(-this.yAxisLeadingMarginLength - (double)xAxisAdj);
                frame2D.selectEnabled.setValue(false);
            } else {
                gridStyle.setBorderOn(false);
                frame2D.setWidth(this.xAxisLength + 2.0);
                frame2D.setHeight(this.yAxisLength);
                frame2D.transform.translateX.setValue(-this.xAxisLeadingMarginLength - 1.0 - 1.0);
                frame2D.transform.translateY.setValue(-this.yAxisLeadingMarginLength - 1.0);
            }
        }
        this.validSelectionArea = new Rectangle(-1, this.yAxisCellModel.getTitleHeight().intValue(), (int)this.xAxisLength - 1, (int)this.yAxisLength);
        if (yGrid != null) {
            np = this.yAxisCellModel.getValues();
            NumericMapper mapper = this.yAxisCellModel.getMapper();
            if (np != null) {
                yGrid.horizontalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)mapper).majorTickOffset);
            } else if (mapper != null) {
                if (mapper instanceof ContinuousRangeToNumericMapper) {
                    if (isRiskMap) {
                        yGrid.horizontalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)mapper).majorTickOffset);
                    } else {
                        yGrid.horizontalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)mapper).uniqueValue);
                    }
                } else {
                    yGrid.horizontalLineOffset.connectFrom(((StringToNumericMapper)mapper).uniqueValue);
                }
            } else if (numericY) {
                yGrid.horizontalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)this.yMapper[0]).uniqueValue);
            } else {
                yGrid.horizontalLineOffset.connectFrom(((StringToNumericMapper)this.yMapper[0]).uniqueValue);
            }
            yGrid.setHorizontalOrigin(-this.xAxisLeadingMarginLength + (double)(frameWidth / 2));
            yGrid.selectEnabled.setValue(false);
            if (dim3D) {
                yGrid.transform.translateZ.setValue((double)(-depth.width + 1));
            }
            GridStyle gridStyle = yGrid.getStyle();
            gridStyle.setBorderOn(false);
            gridStyle.setBackgroundOn(this.riskMap != null);
            StrokeLineStyle gridLineStyle = this.yAxisCellModel.getAxisModel().getGridLineStyle();
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(gridLineStyle);
            gridStyle.setLineWidth(gla.lineWidth);
            if (gla.stipplePattern != 0) {
                gridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            }
            gridStyle.setMajorLineColor(gridLineStyle.getColor());
            yGrid.setWidth(this.xAxisLength - (double)(2 * frameWidth));
            yGrid.setHeight(this.yAxisLength - 1.0 - (double)(2 * frameWidth));
        }
        if (y2Grid != null) {
            np = this.y2AxisCellModel.getValues();
            NumericMapper mapper = this.y2AxisCellModel.getMapper();
            if (np != null) {
                y2Grid.horizontalLineOffset.connectFrom(np);
            } else if (mapper != null) {
                if (mapper instanceof ContinuousRangeToNumericMapper) {
                    y2Grid.horizontalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)mapper).uniqueValue);
                } else {
                    y2Grid.horizontalLineOffset.connectFrom(((StringToNumericMapper)mapper).uniqueValue);
                }
            } else if (numericY2) {
                y2Grid.horizontalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)this.y2Mapper[0]).uniqueValue);
            } else {
                y2Grid.horizontalLineOffset.connectFrom(((StringToNumericMapper)this.y2Mapper[0]).uniqueValue);
            }
            y2Grid.setHorizontalOrigin(-this.xAxisLeadingMarginLength + (double)frameWidth);
            y2Grid.selectEnabled.setValue(false);
            if (dim3D) {
                y2Grid.transform.translateZ.setValue((double)(depth.width - 1));
            }
            GridStyle gridStyle = y2Grid.getStyle();
            gridStyle.setBorderOn(false);
            gridStyle.setBackgroundOn(false);
            StrokeLineStyle gridLineStyle = this.y2AxisCellModel.getAxisModel().getGridLineStyle();
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(gridLineStyle);
            gridStyle.setLineWidth(gla.lineWidth);
            if (gla.stipplePattern != 0) {
                gridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            }
            gridStyle.setMajorLineColor(gridLineStyle.getColor());
            y2Grid.setWidth(this.xAxisLength - 1.0 - (double)(2 * frameWidth));
            y2Grid.setHeight(this.yAxisLength - 1.0 - (double)(2 * frameWidth));
        }
        if (xGrid != null) {
            np = this.xAxisCellModel.getValues();
            NumericMapper mapper = this.xAxisCellModel.getMapper();
            if (np != null) {
                xGrid.verticalLineOffset.connectFrom(np);
            } else if (mapper != null) {
                if (mapper instanceof ContinuousRangeToNumericMapper) {
                    if (isRiskMap) {
                        xGrid.verticalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)mapper).majorTickOffset);
                    } else {
                        xGrid.verticalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)mapper).uniqueValue);
                    }
                } else {
                    xGrid.verticalLineOffset.connectFrom(((StringToNumericMapper)mapper).uniqueValue);
                }
            } else if (numericX) {
                xGrid.verticalLineOffset.connectFrom(((ContinuousRangeToNumericMapper)this.xMapper[0]).uniqueValue);
            } else {
                xGrid.verticalLineOffset.connectFrom(((StringToNumericMapper)this.xMapper[0]).uniqueValue);
            }
            GridStyle gridStyle = xGrid.getStyle();
            gridStyle.setBorderOn(false);
            StrokeLineStyle gridLineStyle = this.xAxisCellModel.getAxisModel().getGridLineStyle();
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(gridLineStyle);
            gridStyle.setLineWidth(gla.lineWidth);
            if (gla.stipplePattern != 0) {
                gridStyle.setStipple(gla.stipplePattern, gla.stippleFactor);
            }
            gridStyle.setMajorLineColor(gridLineStyle.getColor());
            gridStyle.setBackgroundOn(false);
            xGrid.selectEnabled.setValue(false);
            if (dim3D) {
                xGrid.transform.translateZ.setValue((double)(-depth.width + 1));
            }
            xGrid.setVerticalOrigin(-this.yAxisLeadingMarginLength + (double)frameWidth);
            xGrid.setWidth(this.xAxisLength - 1.0 - (double)(2 * frameWidth));
            xGrid.setHeight(this.yAxisLength - 1.0 - (double)(2 * frameWidth));
        }
        if (xzGrid != null) {
            np = this.yAxisCellModel.getValues();
            NumericMapper mapper = this.yAxisCellModel.getMapper();
            if (np != null) {
                xzGrid.beginY.connectFrom(np);
            } else if (mapper != null) {
                if (mapper instanceof ContinuousRangeToNumericMapper) {
                    xzGrid.beginY.connectFrom(((ContinuousRangeToNumericMapper)mapper).uniqueValue);
                } else {
                    xzGrid.beginY.connectFrom(((StringToNumericMapper)mapper).uniqueValue);
                }
            } else if (numericY) {
                xzGrid.beginY.connectFrom(((ContinuousRangeToNumericMapper)this.yMapper[0]).uniqueValue);
            } else {
                xzGrid.beginY.connectFrom(((StringToNumericMapper)this.yMapper[0]).uniqueValue);
            }
            xzGrid.endY.connectFrom((NumericPipe)xzGrid.beginY);
            xzGrid.beginX.setValue(0.0);
            xzGrid.endX.setValue(0.0);
            xzGrid.beginZ.setValue((double)(-depth.width + 2));
            xzGrid.endZ.setValue(0.0);
            xzGrid.color.setValue(this.yAxisCellModel.getAxisModel().getGridLineStyle().getColor());
            xzGrid.transform.translateX.setValue(-this.xAxisLeadingMarginLength);
        }
        if (yzGrid != null) {
            np = this.xAxisCellModel.getValues();
            NumericMapper mapper = this.xAxisCellModel.getMapper();
            if (np != null) {
                yzGrid.beginX.connectFrom(np);
            } else if (mapper != null) {
                if (mapper instanceof ContinuousRangeToNumericMapper) {
                    yzGrid.beginX.connectFrom(((ContinuousRangeToNumericMapper)mapper).uniqueValue);
                } else {
                    yzGrid.beginX.connectFrom(((StringToNumericMapper)mapper).uniqueValue);
                }
            } else if (numericX) {
                yzGrid.beginY.connectFrom(((ContinuousRangeToNumericMapper)this.xMapper[0]).uniqueValue);
            } else {
                yzGrid.beginY.connectFrom(((StringToNumericMapper)this.xMapper[0]).uniqueValue);
            }
            yzGrid.endX.connectFrom((NumericPipe)yzGrid.beginX);
            yzGrid.beginY.setValue(-this.yAxisLeadingMarginLength);
            yzGrid.endY.setValue(-this.yAxisLeadingMarginLength);
            yzGrid.beginZ.setValue(0.0);
            yzGrid.endZ.setValue((double)(-depth.width + 1));
            yzGrid.color.setValue(xAxisModel.getGridLineStyle().getColor());
        }
        if (yAxisModel.isGridInFront()) {
            if (yGrid != null) {
                this.addElement((Element)yGrid);
            }
            if (yzGrid != null) {
                this.addElement((Element)yzGrid);
            }
        }
        if (y2GridVisible && y2AxisModel.isGridInFront()) {
            if (y2Grid != null) {
                this.addElement((Element)y2Grid);
            }
            if (y2zGrid != null) {
                this.addElement((Element)y2zGrid);
            }
        }
        if (xAxisModel.isGridInFront()) {
            if (xGrid != null) {
                this.addElement((Element)xGrid);
            }
            if (xzGrid != null) {
                this.addElement((Element)xzGrid);
            }
        }
    }

    private void addVerticalNeedles(Composite c, NumericMapper xiMapper, NumericMapper yiMapper, ColorProperty colorP, double width, double baseline) {
        LineSegment eSegment = new LineSegment();
        eSegment.lineWidth.setValue(width);
        eSegment.beginX.connectFrom((NumericPipe)xiMapper);
        eSegment.endX.connectFrom((NumericPipe)xiMapper);
        eSegment.beginY.connectFrom((NumericPipe)yiMapper);
        eSegment.endY.setValue(baseline);
        eSegment.color.connectFrom((ColorPipe)colorP);
        c.addElement((Element)eSegment);
    }

    private void addHorizontalNeedles(Composite c, NumericMapper xiMapper, NumericMapper yiMapper, ColorProperty colorP, double width, double baseline) {
        LineSegment eSegment = new LineSegment();
        eSegment.lineWidth.setValue(width);
        eSegment.beginX.connectFrom((NumericPipe)xiMapper);
        eSegment.endX.setValue(baseline);
        eSegment.beginY.connectFrom((NumericPipe)yiMapper);
        eSegment.endY.connectFrom((NumericPipe)yiMapper);
        eSegment.color.connectFrom((ColorPipe)colorP);
        c.addElement((Element)eSegment);
    }

    private void addErrors(Composite cc, DataElementStyles des, NumericMapper xiMapper, NumericMapper yiMapper, ColorProperty colorP, int xIndex, int yIndex, boolean primary, boolean selection) {
        Calculator c;
        Marker marker;
        ContinuousRangeToNumericMapper errorMapper;
        LineSegment eSegment;
        int ii;
        Variable error;
        Variable yiVariable;
        Variable xiVariable;
        if (selection) {
            xiVariable = this.xVariableSelection[xIndex];
            yiVariable = primary ? this.yVariableSelection[yIndex] : this.y2VariableSelection[yIndex];
            error = this.leftErrorVariableSelection[xIndex];
        } else {
            xiVariable = this.xVariable[xIndex];
            yiVariable = primary ? this.yVariable[yIndex] : this.y2Variable[yIndex];
            error = this.leftErrorVariable[xIndex];
        }
        MarkerStyle[] markerStyles = des.getErrorMarkerStyles();
        StrokeLineStyle[] lineStyles = des.getErrorLineStyles();
        StrokeLineStyle errorStyle = lineStyles[0];
        MarkerStyle errorMarkerStyle = markerStyles[0];
        int msize = markerStyles.length;
        int lsize = lineStyles.length;
        for (ii = 0; ii < 2; ++ii) {
            if (ii == 1) {
                Variable variable = error = selection ? this.rightErrorVariableSelection[xIndex] : this.rightErrorVariable[xIndex];
                if (lsize > 1) {
                    errorStyle = lineStyles[1];
                }
                if (msize > 1) {
                    errorMarkerStyle = markerStyles[1];
                }
            }
            if (error == null) continue;
            eSegment = new LineSegment();
            eSegment.selectEnabled.setValue(false);
            cc.addElement((Element)eSegment);
            eSegment.lineWidth.setValue(errorStyle.getThickness().getMagnitude((Object)"py"));
            eSegment.beginX.connectFrom((NumericPipe)xiMapper);
            eSegment.beginY.connectFrom((NumericPipe)yiMapper);
            eSegment.endY.connectFrom((NumericPipe)yiMapper);
            errorMapper = new ContinuousRangeToNumericMapper();
            errorMapper.shareMap((ContinuousRangeToNumericMapper)xiMapper);
            eSegment.endX.connectFrom((NumericPipe)errorMapper);
            marker = new Marker();
            marker.selectEnabled.setValue(false);
            cc.addElement((Element)marker);
            marker.type.setValue(errorMarkerStyle.getSymbol());
            marker.size.setValue((int)errorMarkerStyle.getSize().getMagnitude((Object)"py"));
            marker.coordY.connectFrom((NumericPipe)yiMapper);
            marker.coordX.connectFrom((NumericPipe)errorMapper);
            if (colorP == null) {
                eSegment.color.setValue(errorStyle.getColor());
                marker.color.setValue(errorMarkerStyle.getColor());
            } else {
                eSegment.color.connectFrom((ColorPipe)colorP);
                marker.color.connectFrom((ColorPipe)colorP);
            }
            c = ii == 0 ? new Calculator("inA + inB") : new Calculator("inA - inB");
            c.inA.connectFrom(((NumericVariable)xiVariable).value);
            c.inB.connectFrom(((NumericVariable)error).value);
            errorMapper.input.connectFrom((NumericPipe)c);
        }
        for (ii = 0; ii < 2; ++ii) {
            if (ii == 0) {
                error = selection ? (primary ? this.upErrorVariableSelection[yIndex] : this.up2ErrorVariableSelection[yIndex]) : (primary ? this.upErrorVariable[yIndex] : this.up2ErrorVariable[yIndex]);
                errorStyle = lsize > 2 ? lineStyles[2] : lineStyles[0];
                errorMarkerStyle = msize > 2 ? markerStyles[2] : markerStyles[0];
            } else {
                if (selection) {
                    error = primary ? this.downErrorVariableSelection[yIndex] : this.down2ErrorVariableSelection[yIndex];
                } else {
                    Variable variable = error = primary ? this.downErrorVariable[yIndex] : this.down2ErrorVariable[yIndex];
                }
                if (lsize > 3) {
                    errorStyle = lineStyles[3];
                } else if (lsize > 1) {
                    errorStyle = lineStyles[1];
                }
                if (msize > 3) {
                    errorMarkerStyle = markerStyles[3];
                } else if (msize > 1) {
                    errorMarkerStyle = markerStyles[1];
                }
            }
            if (error == null || errorStyle.getVisibilityPolicy() == 10202) continue;
            eSegment = new LineSegment();
            eSegment.lineWidth.setValue(errorStyle.getThickness().getMagnitude((Object)"py"));
            eSegment.beginX.connectFrom((NumericPipe)xiMapper);
            eSegment.endX.connectFrom((NumericPipe)xiMapper);
            eSegment.endY.connectFrom((NumericPipe)yiMapper);
            errorMapper = new ContinuousRangeToNumericMapper();
            errorMapper.shareMap((ContinuousRangeToNumericMapper)yiMapper);
            marker = new Marker();
            if (colorP == null) {
                eSegment.color.setValue(errorStyle.getColor());
                marker.color.setValue(errorMarkerStyle.getColor());
            } else {
                eSegment.color.connectFrom((ColorPipe)colorP);
                marker.color.connectFrom((ColorPipe)colorP);
            }
            c = ii == 0 ? new Calculator("inA + inB") : new Calculator("inA - inB");
            c.inA.connectFrom(((NumericVariable)yiVariable).value);
            c.inB.connectFrom(((NumericVariable)error).value);
            errorMapper.input.connectFrom((NumericPipe)c);
            eSegment.beginY.connectFrom((NumericPipe)errorMapper);
            eSegment.selectEnabled.setValue(false);
            cc.addElement((Element)eSegment);
            marker.type.setValue(errorMarkerStyle.getSymbol());
            marker.size.setValue((int)errorMarkerStyle.getSize().getMagnitude((Object)"py"));
            marker.coordX.connectFrom((NumericPipe)xiMapper);
            marker.coordY.connectFrom((NumericPipe)errorMapper);
            marker.selectEnabled.setValue(false);
            cc.addElement((Element)marker);
        }
    }

    public Rectangle getValidSelectionArea() {
        return this.validSelectionArea;
    }

    private Element addLines(Composite c, NumericMapper xiMapper, NumericMapper yiMapper, ColorProperty lineColor, int style, StrokeLineStyle[] lineStyles, Color[] cycleColors, Color color, int joinType, int joinOrder, boolean skipMissing) {
        SplineConnector connector;
        StrokeLineStyle ls = Util.newCycledLineStyle(lineStyles, cycleColors, style);
        GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(ls);
        if (this.shapeVariable != null || this.colorVariable != null && (this.colorVariable instanceof StringVariable || this.groupByColor)) {
            StringToNumericMapper groupMapper = new StringToNumericMapper();
            if (this.colorVariable instanceof StringVariable) {
                groupMapper.input.connectFrom(((StringVariable)this.colorVariable).formattedValue);
            } else if (this.colorVariable instanceof NumericVariable) {
                groupMapper.input.connectFrom(((NumericVariable)this.colorVariable).formattedValue);
            } else if (this.shapeVariable != null) {
                groupMapper.input.connectFrom(this.shapeVariable.formattedValue);
            }
            groupMapper.setStartValue(0.0);
            groupMapper.setStrideValue(1.0);
            groupMapper.setLabelMissingValues(true);
            Switch lineSwitch = new Switch();
            Util.SelectInfo.selectEnable((Element)lineSwitch, 1);
            lineSwitch.whichChoice.connectFrom((NumericPipe)groupMapper);
            int maxLine = (int)groupMapper.getOutputMax();
            for (int s = 0; s <= maxLine; ++s) {
                SplineConnector connector2;
                ls = Util.newCycledLineStyle(lineStyles, cycleColors, s);
                if (ls.getVisibilityPolicy() == 10202) continue;
                switch (joinType) {
                    default: {
                        connector2 = new SplineConnector();
                        break;
                    }
                    case 40002: {
                        connector2 = new LineConnector();
                        break;
                    }
                    case 40004: {
                        connector2 = new StepConnector();
                        ((StepConnector)connector2).setJustification(2);
                        ((StepConnector)connector2).setJoin(true);
                        break;
                    }
                    case 40003: {
                        connector2 = new StepConnector();
                        ((StepConnector)connector2).setJustification(0);
                        ((StepConnector)connector2).setJoin(true);
                        break;
                    }
                    case 40005: {
                        connector2 = new StepConnector();
                        ((StepConnector)connector2).setJustification(1);
                        ((StepConnector)connector2).setJoin(true);
                    }
                }
                Util.SelectInfo.selectEnable((Element)connector2, 1);
                switch (joinOrder) {
                    default: {
                        connector2.setConnectionOrder(0);
                        break;
                    }
                    case 40101: {
                        connector2.setConnectionOrder(1);
                        break;
                    }
                    case 40102: {
                        connector2.setConnectionOrder(2);
                    }
                }
                connector2.selectEnabled.setValue(false);
                connector2.pointX.connectFrom((NumericPipe)xiMapper);
                connector2.pointY.connectFrom((NumericPipe)yiMapper);
                if (lineColor == null) {
                    connector2.color.setValue(color);
                } else {
                    connector2.color.connectFrom((ColorPipe)lineColor);
                }
                if (joinOrder != 40100) {
                    NumericCache xiCache = new NumericCache();
                    NumericCache yiCache = new NumericCache();
                    ColorCache colorCache = new ColorCache();
                    xiCache.input.connectFrom(xiMapper.value);
                    yiCache.input.connectFrom(yiMapper.value);
                    connector2.pointX.connectFrom((NumericPipe)xiCache);
                    connector2.pointY.connectFrom((NumericPipe)yiCache);
                    colorCache.input.connectFrom((ColorPipe)lineColor);
                    if (connector2.color.isConnected()) {
                        colorCache.input.connectFrom(connector2.color.getConnection());
                        connector2.color.connectFrom((ColorPipe)colorCache);
                    }
                }
                connector2.setSkipMissingOn(skipMissing);
                gla = GTKUtil.getLineAttributes(ls);
                connector2.setStipple(gla.stipplePattern, gla.stippleFactor);
                connector2.lineWidth.setValue((double)gla.lineWidth);
                lineSwitch.addChoice((Element)connector2);
            }
            c.addElement((Element)lineSwitch);
            return lineSwitch;
        }
        if (ls.getVisibilityPolicy() == 10202) {
            return null;
        }
        switch (joinType) {
            default: {
                connector = new SplineConnector();
                break;
            }
            case 40002: {
                connector = new LineConnector();
                break;
            }
            case 40004: {
                connector = new StepConnector();
                ((StepConnector)connector).setJustification(2);
                ((StepConnector)connector).setJoin(true);
                break;
            }
            case 40005: {
                connector = new StepConnector();
                ((StepConnector)connector).setJustification(1);
                ((StepConnector)connector).setJoin(true);
                break;
            }
            case 40003: {
                connector = new StepConnector();
                ((StepConnector)connector).setJustification(0);
                ((StepConnector)connector).setJoin(true);
            }
        }
        Util.SelectInfo.selectEnable((Element)connector, 1);
        switch (joinOrder) {
            default: {
                connector.setConnectionOrder(0);
                break;
            }
            case 40101: {
                connector.setConnectionOrder(1);
                break;
            }
            case 40102: {
                connector.setConnectionOrder(2);
            }
        }
        if (joinOrder != 40100) {
            NumericCache xiCache = new NumericCache();
            NumericCache yiCache = new NumericCache();
            xiCache.input.connectFrom((NumericPipe)xiMapper);
            yiCache.input.connectFrom((NumericPipe)yiMapper);
            connector.pointX.connectFrom((NumericPipe)xiCache);
            connector.pointY.connectFrom((NumericPipe)yiCache);
        } else {
            connector.pointX.connectFrom((NumericPipe)xiMapper);
            connector.pointY.connectFrom((NumericPipe)yiMapper);
        }
        connector.setSkipMissingOn(skipMissing);
        c.addElement((Element)connector);
        connector.setStipple(gla.stipplePattern, gla.stippleFactor);
        connector.lineWidth.setValue((double)gla.lineWidth);
        if (lineColor == null) {
            connector.color.setValue(color);
        } else {
            connector.color.connectFrom((ColorPipe)lineColor);
        }
        return connector;
    }

    private Marker addMarkers(Composite c, NumericMapper xiMapper, NumericMapper yiMapper, ColorProperty markerColor, NumericProperty markerScale, Color color, Color markerOutlineColor, int symbol, NumericPipe shapeProperty, String xVariableName, String yVariableName, Color selectionColor, Color selectionAccentColor, Variable xSelectionVariable, Variable ySelectionVariable, Variable xVariable, Variable yVariable) {
        ScatterPlotCellModel cellModel;
        Marker marker = new Marker();
        if (xSelectionVariable != null && ySelectionVariable != null) {
            Util.SelectInfo.selectEnable((Element)marker, xVariable, yVariable, 3);
        } else if (xSelectionVariable != null) {
            Util.SelectInfo.selectEnable((Element)marker, xVariable, 3);
        } else if (ySelectionVariable != null) {
            Util.SelectInfo.selectEnable((Element)marker, yVariable, 3);
        } else {
            Util.SelectInfo.selectEnable((Element)marker, 3);
        }
        marker.type.setValue(symbol);
        marker.coordX.connectFrom((NumericPipe)xiMapper);
        marker.coordY.connectFrom((NumericPipe)yiMapper);
        if (selectionColor != null && selectionAccentColor != null && (xSelectionVariable != null || ySelectionVariable != null) && ((cellModel = (ScatterPlotCellModel)this.getModel()).getRuleTargetIdentifier() == null || cellModel.getRuleTargetIdentifier().equals(xVariable.getRootVariable().getColumnName()) || cellModel.getRuleTargetIdentifier().equals(yVariable.getRootVariable().getColumnName()))) {
            marker.highlightEdgeColor.setValue(selectionAccentColor);
            marker.highlightFillColor.setValue(selectionColor);
            Calculator hilightOn = new Calculator("inA+inB");
            marker.highlightOn.connectFrom(hilightOn.value);
            if (xSelectionVariable != null) {
                hilightOn.inA.connectFrom(((NumericVariable)xSelectionVariable).value);
            }
            if (ySelectionVariable != null) {
                hilightOn.inB.connectFrom(((NumericVariable)ySelectionVariable).value);
            }
        }
        if (markerColor == null) {
            marker.color.setValue(color);
        } else if (markerColor.isConnected()) {
            marker.color.connectFrom((ColorPipe)markerColor);
        } else {
            marker.color.setValue(markerColor.getValue());
        }
        if (markerOutlineColor == null) {
            marker.edgeColor.connectFrom((ColorPipe)marker.color);
        } else {
            marker.edgeColor.setValue(markerOutlineColor);
        }
        if (markerScale.isConnected()) {
            marker.size.connectFrom((NumericPipe)markerScale);
        } else {
            marker.size.setValue((int)markerScale.getValue());
        }
        if (this.shapeVariable != null) {
            marker.type.connectFrom(shapeProperty);
        }
        if (this.markerEffectsIcon != null) {
            marker.setSkin(this.markerEffectsIcon.getImage());
        }
        marker.setSkinFactory(this.skinFactory);
        c.addElement((Element)marker);
        return marker;
    }

    private void addTukeyBox(Composite c, NumericMapper xiMapper, NumericMapper yiMapper, NumericVariable yvar, double boxWidth, ColorProperty markerColor, NumericProperty markerScale, Color color, Color markerOutlineColor, int symbol, NumericPipe shapeProperty) {
        TukeyBox box = new TukeyBox();
        box.transform.translateX.connectFrom(xiMapper.uniqueValue);
        box.y.connectFrom(yiMapper.value);
        box.rawY.connectFrom(yvar.value);
        box.x.connectFrom(xiMapper.value);
        if (markerColor == null) {
            box.markerColor.setValue(color);
            box.outlineColor.setValue(color);
            box.whiskerColor.setValue(color);
            box.meanColor.setValue(color);
            box.capColor.setValue(color);
            box.medianColor.setValue(color);
            box.markerWidth.connectFrom((NumericPipe)markerScale);
            box.boxWidth.setValue(boxWidth);
            box.y.connectFrom((NumericPipe)yiMapper);
        } else {
            box.markerColor.connectFrom((ColorPipe)markerColor);
            box.outlineColor.connectFrom((ColorPipe)markerColor);
            box.whiskerColor.connectFrom((ColorPipe)markerColor);
            box.meanColor.connectFrom((ColorPipe)markerColor);
            box.capColor.connectFrom((ColorPipe)markerColor);
            box.medianColor.connectFrom((ColorPipe)markerColor);
            box.markerWidth.connectFrom((NumericPipe)markerScale);
            box.boxWidth.setValue(boxWidth);
            box.y.connectFrom((NumericPipe)yiMapper);
        }
        c.addElement((Element)box);
        if (this.shapeVariable == null) {
            box.markerShape.setValue(symbol);
        } else {
            box.markerShape.connectFrom(shapeProperty);
        }
    }

    private void addLabels(Composite cc, ScatterPlotModel plotModel, NumericMapper xiMapper, NumericMapper yiMapper, NumericProperty markerScale, ColorProperty color, boolean selection) {
        StringMissingValueReplacement missingValueReplacement;
        Font font;
        RasterLabel label;
        ShadowStyle shadow;
        AdvancedTextStyle ats = null;
        ColorProperty lcolor = color;
        Calculator c = null;
        ArrayList layoutList = new ArrayList();
        boolean labelColorUsed = plotModel.getUseValueColor();
        boolean useLabelLayout = this.calculateLabelLayoutUse(xiMapper.value, yiMapper.value, selection);
        if (!selection) {
            this.abovePointLabelLayout = null;
            this.belowPointLabelLayout = null;
        }
        if (this.aboveValueVariable != null && (ats = plotModel.getAboveValueTextStyle()).isVisible()) {
            if (labelColorUsed && !selection) {
                lcolor = new ColorProperty();
                lcolor.setValue(ats.getColor());
            }
            c = new Calculator("inA + (inB/2)");
            c.inA.connectFrom(yiMapper.value);
            c.inB.connectFrom((NumericPipe)markerScale);
            shadow = ats.getShadowStyle();
            label = new RasterLabel();
            if (shadow.isVisible()) {
                label.shadowColor.setValue(shadow.getColor());
                label.shadowOn.setValue(shadow.isVisible());
                label.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
                label.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
            }
            font = ats.getFont();
            label.setFont(font);
            label.color.connectFrom((ColorPipe)lcolor);
            label.selectEnabled.setValue(false);
            label.trimOn.setValue(true);
            switch (ats.getJustification()) {
                default: {
                    label.horizontalJustification.setValue(1);
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    label.horizontalJustification.setValue(0);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    label.horizontalJustification.setValue(2);
                }
            }
            label.verticalJustification.setValue(3);
            label.angle.setValue(Util.resolveBaselineAngle(ats));
            label.transform.translateX.connectFrom((NumericPipe)xiMapper);
            label.transform.translateY.connectFrom((NumericPipe)c);
            missingValueReplacement = new StringMissingValueReplacement();
            if (selection) {
                if (this.aboveValueVariable instanceof NumericVariable) {
                    missingValueReplacement.input.connectFrom(((NumericVariable)this.aboveValueVariableSelection).formattedValue);
                } else {
                    missingValueReplacement.input.connectFrom(((StringVariable)this.aboveValueVariableSelection).formattedValue);
                }
            } else if (this.aboveValueVariable instanceof NumericVariable) {
                missingValueReplacement.input.connectFrom(((NumericVariable)this.aboveValueVariable).formattedValue);
            } else {
                missingValueReplacement.input.connectFrom(((StringVariable)this.aboveValueVariable).formattedValue);
            }
            label.string.connectFrom((StringPipe)missingValueReplacement);
            cc.addElement((Element)label);
            if (useLabelLayout) {
                if (this.abovePointLabelLayout == null) {
                    this.abovePointLabelLayout = new PointLabelLayout();
                }
                c.setExpression("inA+1");
                this.spliceInPointLabelLayout(this.abovePointLabelLayout, label, (StringPipe)missingValueReplacement, xiMapper.value, c.value, (int)Math.ceil(markerScale.getValue()), selection, layoutList);
            }
        }
        if (this.belowValueVariable != null && (ats = plotModel.getBelowValueTextStyle()).isVisible()) {
            if (labelColorUsed && !selection) {
                lcolor = new ColorProperty();
                lcolor.setValue(ats.getColor());
            }
            c = new Calculator("inA - (inB/2)");
            c.inA.connectFrom(yiMapper.value);
            c.inB.connectFrom((NumericPipe)markerScale);
            shadow = ats.getShadowStyle();
            label = new RasterLabel();
            if (shadow.isVisible()) {
                label.shadowColor.setValue(shadow.getColor());
                label.shadowOn.setValue(shadow.isVisible());
                label.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
                label.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
            }
            font = ats.getFont();
            label.setFont(font);
            label.color.connectFrom((ColorPipe)lcolor);
            label.selectEnabled.setValue(false);
            label.trimOn.setValue(true);
            switch (ats.getJustification()) {
                default: {
                    label.horizontalJustification.setValue(1);
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    label.horizontalJustification.setValue(0);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    label.horizontalJustification.setValue(2);
                }
            }
            label.verticalJustification.setValue(0);
            label.angle.setValue(Util.resolveBaselineAngle(ats));
            label.transform.translateX.connectFrom((NumericPipe)xiMapper);
            label.transform.translateY.connectFrom((NumericPipe)c);
            missingValueReplacement = new StringMissingValueReplacement();
            if (selection) {
                if (this.belowValueVariable instanceof NumericVariable) {
                    missingValueReplacement.input.connectFrom(((NumericVariable)this.belowValueVariableSelection).formattedValue);
                } else {
                    missingValueReplacement.input.connectFrom(((StringVariable)this.belowValueVariableSelection).formattedValue);
                }
            } else if (this.belowValueVariable instanceof NumericVariable) {
                missingValueReplacement.input.connectFrom(((NumericVariable)this.belowValueVariable).formattedValue);
            } else {
                missingValueReplacement.input.connectFrom(((StringVariable)this.belowValueVariable).formattedValue);
            }
            label.string.connectFrom((StringPipe)missingValueReplacement);
            cc.addElement((Element)label);
            if (useLabelLayout) {
                if (this.belowPointLabelLayout == null) {
                    this.belowPointLabelLayout = new PointLabelLayout();
                }
                c.setExpression("inA-1");
                this.spliceInPointLabelLayout(this.belowPointLabelLayout, label, (StringPipe)missingValueReplacement, xiMapper.value, c.value, (int)Math.ceil(markerScale.getValue()), selection, layoutList);
            }
        }
        if (layoutList.size() > 0 && !selection) {
            if (this.pointLabelLayoutManager == null) {
                this.pointLabelLayoutManager = this.createPointLabelLayoutManager();
            }
            for (int i = 0; i < layoutList.size(); ++i) {
                this.pointLabelLayoutManager.addLayout((PointLabelLayout)layoutList.get(i));
            }
        }
    }

    private PointLabelLayoutManager createPointLabelLayoutManager() {
        Rectangle b = new Rectangle();
        b.width = (int)this.xAxisLength;
        b.height = (int)this.yAxisLength;
        b.x = (int)(-this.xAxisLeadingMarginLength);
        b.y = (int)(-this.yAxisLeadingMarginLength);
        PointLabelLayoutManager pllm = new PointLabelLayoutManager(b);
        return pllm;
    }

    private boolean calculateLabelLayoutUse(NumericPipe x, NumericPipe y, boolean selection) {
        boolean result;
        if (selection) {
            result = this.pointLabelLayoutManager != null;
        } else {
            AInitAction ia = new AInitAction();
            x.init(ia);
            y.init(ia);
            int valueCount = ia.getValueCount();
            result = valueCount < 250;
        }
        return result;
    }

    private void spliceInPointLabelLayout(PointLabelLayout pll, RasterLabel rl, StringPipe label, NumericPipe x, NumericPipe y, int markerSize, boolean selection, List layoutList) {
        IntegerPipe vAlign;
        IntegerPipe hAlign;
        NumericPipe ypos;
        NumericPipe xpos;
        StringPipe adjustedLabel;
        if (selection) {
            SelectionFilter sf = new SelectionFilter(pll, this.getSelectionVariable().value);
            this.selectionFilterList.add(sf);
            adjustedLabel = sf.adjustedLabel;
            xpos = sf.xpos;
            ypos = sf.ypos;
            hAlign = sf.hAlign;
            vAlign = sf.vAlign;
        } else {
            Graphics g = this.channel.getBackbufferGC();
            g.setFont(rl.getFont());
            pll.setFontMetrics(this.channel.getBackbufferGC().getFontMetrics());
            pll.x.connectFrom(x);
            pll.y.connectFrom(y);
            pll.label.connectFrom(label);
            pll.setMarkerSize(markerSize);
            layoutList.add(pll);
            adjustedLabel = pll.adjustedLabel;
            xpos = pll.xpos;
            ypos = pll.ypos;
            hAlign = pll.hAlign;
            vAlign = pll.vAlign;
        }
        rl.string.connectFrom(adjustedLabel);
        rl.transform.translateX.connectFrom(xpos);
        rl.transform.translateY.connectFrom(ypos);
        rl.horizontalJustification.connectFrom(hAlign);
        rl.verticalJustification.connectFrom(vAlign);
    }

    private NumericVariable getSelectionVariable() {
        ScatterPlotCellModel cm = (ScatterPlotCellModel)this.getModel();
        ScatterPlotMatrixModel matrixModel = cm.getScatterPlotMatrixModel();
        Object selectionVariableRole = matrixModel.getSelectionRole();
        Variable selectionVar = ScatterComposite.checkVariableList(this.dataSource.getVariable(selectionVariableRole))[0];
        return (NumericVariable)selectionVar;
    }

    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        if (this.nodata) {
            return null;
        }
        Vector[] pairs = this.getLabelValuePairs(obsIndex, x, y);
        if (pairs == null) {
            return null;
        }
        return new PickInfo(pairs, obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    private Vector[] getLabelValuePairs(int obsIndex, int x, int y) {
        int newdist;
        int ii;
        Vector labelValuePairs = new Vector();
        boolean graphDataIsVisible = this.dataTipVariableArray == null || this.dataTipVariableArray.length <= 0 || this.dataTipVariableArray[0] == null || ((ScatterPlotCellModel)this.getModel()).getScatterPlotMatrixModel().getGraphModel().getDataTipModel().getContent() != 11401;
        double[] loc = new double[]{x, y, 0.0};
        this.channel.gluUnProject(loc, loc);
        x = (int)loc[0] - (int)this.xAxisLeadingMarginLength - this.resAxisAdj;
        y = (int)loc[1] - (int)this.yAxisLeadingMarginLength - this.catAxisAdj;
        int y2 = (int)loc[1] - (int)this.y2AxisLeadingMarginLength - this.catAxisAdj;
        int y2length = 0;
        int[] y2pos = null;
        if (this.y2Variable != null) {
            y2length = this.y2Variable.length;
            y2pos = new int[y2length];
        }
        for (int ii2 = 0; ii2 < y2length; ++ii2) {
            if (this.y2Mapper[ii2] == null) continue;
            try {
                y2pos[ii2] = (int)this.y2Mapper[ii2].getValue(obsIndex) - y2;
                continue;
            }
            catch (MissingValueException e) {
                y2pos[ii2] = 2000;
            }
        }
        int ylength = 0;
        int[] ypos = null;
        if (this.yVariable != null) {
            ylength = this.yVariable.length;
            ypos = new int[ylength];
        }
        for (int ii3 = 0; ii3 < ylength; ++ii3) {
            if (this.yMapper[ii3] == null) continue;
            try {
                ypos[ii3] = (int)this.yMapper[ii3].getValue(obsIndex) - y;
                continue;
            }
            catch (MissingValueException e) {
                ypos[ii3] = 2000;
            }
        }
        int xlength = this.xVariable.length;
        int[] xpos = new int[xlength];
        for (int ii4 = 0; ii4 < xlength; ++ii4) {
            if (this.xMapper[ii4] == null) continue;
            try {
                xpos[ii4] = (int)this.xMapper[ii4].getValue(obsIndex) - x;
                continue;
            }
            catch (MissingValueException e) {
                xpos[ii4] = 2000;
            }
        }
        boolean ypick = true;
        int dist = 201;
        int xindex = -1;
        int yindex = -1;
        if (xlength == 1) {
            xindex = 0;
            for (ii = 0; ii < ylength; ++ii) {
                newdist = ypos[ii] * ypos[ii] + xpos[xindex] * xpos[xindex];
                if (dist <= newdist) continue;
                dist = newdist;
                yindex = ii;
            }
            for (ii = 0; ii < y2length; ++ii) {
                int yi = ii;
                int newdist2 = y2pos[yi] * y2pos[yi] + xpos[xindex] * xpos[xindex];
                if (dist <= newdist2) continue;
                dist = newdist2;
                yindex = yi;
                ypick = false;
            }
        } else if (ylength + y2length == 1) {
            yindex = 0;
            if (ylength == 1) {
                for (ii = 0; ii < xlength; ++ii) {
                    newdist = ypos[yindex] * ypos[yindex] + xpos[ii] * xpos[ii];
                    if (dist <= newdist) continue;
                    dist = newdist;
                    xindex = ii;
                }
            } else {
                for (ii = 0; ii < xlength; ++ii) {
                    newdist = y2pos[yindex] * y2pos[yindex] + xpos[ii] * xpos[ii];
                    if (dist <= newdist) continue;
                    dist = newdist;
                    xindex = ii;
                    ypick = false;
                }
            }
        } else {
            int ii5;
            int max = Math.min(ylength, xlength);
            for (ii5 = 0; ii5 < max; ++ii5) {
                int newdist3 = ypos[ii5] * ypos[ii5] + xpos[ii5] * xpos[ii5];
                if (dist <= newdist3) continue;
                dist = newdist3;
                yindex = ii5;
                xindex = ii5;
            }
            max = Math.min(y2length, xlength - ylength);
            for (ii5 = 0; ii5 < max; ++ii5) {
                int yi = ii5;
                int xi = ii5 + ylength;
                int newdist4 = y2pos[yi] * y2pos[yi] + xpos[xi] * xpos[xi];
                if (dist <= newdist4) continue;
                dist = newdist4;
                xindex = xi;
                yindex = yi;
                ypick = false;
            }
        }
        if (dist > 200) {
            return null;
        }
        Object role = ypick ? this.yVariableRole : this.y2VariableRole;
        Variable variable = ypick ? this.yVariable[yindex] : this.y2Variable[yindex];
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.xVariableRole, this.xVariable[xindex], obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.shapeVariableRole, (Variable)this.shapeVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.sizeVariableRole, this.sizeVariable, obsIndex, graphDataIsVisible);
        if (this.colorVariable != this.shapeVariable) {
            GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.colorVariableRole, this.colorVariable, obsIndex, graphDataIsVisible);
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.dataTipRole, this.dataTipVariableArray, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.auxiliaryRole, this.auxiliaryVariableArray, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    public Dimension getPreferredSize() {
        int vlen;
        if (this.dataSource == null || this.nodata) {
            return this.defaultSize;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        if (cellModel == null || this.xAxisCellModel == null || this.yAxisCellModel == null) {
            return this.defaultSize;
        }
        Double doubleValue = this.yAxisCellModel.getCatAxisAdj();
        int catAxisAdj = doubleValue == null ? 0 : doubleValue.intValue();
        doubleValue = this.xAxisCellModel.getResAxisAdj();
        int resAxisAdj = doubleValue == null ? 0 : doubleValue.intValue();
        int xTitleWidth = this.xAxisCellModel.getTitleWidth().intValue();
        int yTitleHeight = this.yAxisCellModel.getTitleHeight().intValue();
        int hlen = this.xAxisCellModel.getAxisModel().isVisible() ? this.xAxisCellModel.getIdealPreferredLength().intValue() : 640;
        int n = vlen = this.yAxisCellModel.getAxisModel().isVisible() ? this.yAxisCellModel.getIdealPreferredLength().intValue() : hlen * 3 / 4;
        if (cellModel.getYAxisVisible().booleanValue() && this.y2Mapper != null && this.y2Mapper[0] != null) {
            vlen = this.yAxisCellModel.getAxisModel().isVisible() ? Math.max(vlen, this.y2AxisCellModel.getLength().intValue()) : this.y2AxisCellModel.getLength().intValue();
        }
        Dimension d = new Dimension(hlen + 2 * this.xAxisCellModel.getMargin().width + resAxisAdj + this.xAxisCellModel.getDepth().width + xTitleWidth, vlen + 2 * this.yAxisCellModel.getMargin().height + catAxisAdj + this.yAxisCellModel.getDepth().height + yTitleHeight);
        return d;
    }

    public Dimension getMinimumSize() {
        int px = (int)MINIMUM_SIZE.getMagnitude((Object)"px");
        return new Dimension(px, px);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
        if (this.xMapper == null || this.yMapper == null && this.y2Mapper == null) {
            return;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        this._setTitleHeight(this.channel, this.yAxisCellModel, this.y2AxisCellModel);
        int yCellCount = this.yAxisCellModel.getCellCount() == null ? 1 : this.yAxisCellModel.getCellCount();
        int xCellCount = this.xAxisCellModel.getCellCount() == null ? 1 : this.xAxisCellModel.getCellCount();
        Insets outerMargin = cellModel.getOuterMargin();
        this.xAxisCellModel.computeParameters(this.channel, width, 0.4 * (double)height * (double)yCellCount);
        int catAxisAdj = this.xAxisCellModel.getCatAxisAdj().intValue();
        if (cellModel.getXAxisVisible().booleanValue()) {
            this.yAxisCellModel.setCatAxisAdj(new Double(catAxisAdj));
        }
        this.yAxisCellModel.computeParameters(this.channel, 1 * width * xCellCount, height);
        int resAxisAdj = this.yAxisCellModel.getResAxisAdj().intValue();
        if (cellModel.getYAxisVisible().booleanValue()) {
            this.xAxisCellModel.setResAxisAdj(new Double(resAxisAdj));
            this.xAxisCellModel.computeParameters(this.channel, 1 * width * xCellCount, height);
            catAxisAdj = this.xAxisCellModel.getCatAxisAdj().intValue();
        }
        Dimension margin = this.yAxisCellModel.getMargin();
        int saveMarginHeight = margin.height;
        if (catAxisAdj > outerMargin.bottom) {
            outerMargin.bottom = catAxisAdj;
            cellModel.getXAxisCellModel().setCatAxisAdj(new Double(catAxisAdj));
            cellModel.getXAxisCellModel().setMaximumSize(this.xAxisCellModel.getMaximumSize());
        } else {
            catAxisAdj = outerMargin.bottom;
        }
        this.xAxisCellModel.setCatAxisAdj(null);
        if (this.xAxisCellModel.getCatAxisAdj() == null || this.xAxisCellModel.getCatAxisAdj().intValue() == 0) {
            this.xAxisCellModel.setCatAxisAdj(new Double(catAxisAdj));
        }
        if (this.y2AxisCellModel != null) {
            this.y2AxisCellModel.computeParameters(this.channel, 0.4 * (double)width * (double)xCellCount, height);
            if (saveMarginHeight < margin.height) {
                this.yAxisCellModel.computeParameters(this.channel, 0.4 * (double)width * (double)xCellCount, height);
            }
        }
    }

    private void _setTitleHeight(Channel channel, AxisCellModel yAxisCellModel, AxisCellModel y2AxisCellModel) {
        boolean y2Title;
        boolean yTitle;
        double yTitleHeight = 0.0;
        boolean yAxis = yAxisCellModel != null && yAxisCellModel.getAxisVisible() != false;
        boolean bl = yTitle = yAxis && yAxisCellModel.getTitlePlacementType() != 11306;
        if (yTitle) {
            String title = yAxisCellModel.getTitle();
            channel.glSelect2DFont(yAxisCellModel.getAxisModel().getLabelTextStyle().getFont());
            yTitleHeight = (int)(channel.glGetTextHeight(title) + 4.0);
        }
        double y2TitleHeight = 0.0;
        boolean y2Axis = y2AxisCellModel != null && y2AxisCellModel.getAxisVisible() != false;
        boolean bl2 = y2Title = y2Axis && y2AxisCellModel.getTitlePlacementType() != 11306;
        if (y2Title) {
            String title = y2AxisCellModel.getTitle();
            channel.glSelect2DFont(y2AxisCellModel.getAxisModel().getLabelTextStyle().getFont());
            y2TitleHeight = (int)(channel.glGetTextHeight(title) + 4.0);
        }
        Double titleHeight = new Double(Math.max(yTitleHeight, y2TitleHeight));
        if (yAxis) {
            yAxisCellModel.setTitleHeight(titleHeight);
        }
        if (y2Axis) {
            y2AxisCellModel.setTitleHeight(titleHeight);
        }
    }

    public double[] getXRange() {
        if (this.xVariable == null || !(this.xVariable[0] instanceof NumericVariable)) {
            return null;
        }
        int len = this.xVariable.length;
        double[] range = new double[2];
        boolean leftError = this.leftErrorVariable != null;
        boolean rightError = this.rightErrorVariable != null;
        range[0] = ((NumericVariable)this.xVariable[0]).getMin();
        if (leftError && this.leftErrorVariable[0] != null) {
            range[0] = range[0] - ((NumericVariable)this.leftErrorVariable[0]).getMax();
        }
        range[1] = ((NumericVariable)this.xVariable[0]).getMax();
        if (rightError && this.rightErrorVariable[0] != null) {
            range[1] = range[1] + ((NumericVariable)this.rightErrorVariable[0]).getMax();
        }
        for (int i = 1; i < len; ++i) {
            double value = ((NumericVariable)this.xVariable[i]).getMin();
            if (leftError && this.leftErrorVariable[i] != null) {
                value -= ((NumericVariable)this.leftErrorVariable[i]).getMax();
            }
            range[0] = Math.min(range[0], value);
            value = ((NumericVariable)this.xVariable[i]).getMax();
            if (rightError && this.rightErrorVariable[i] != null) {
                value += ((NumericVariable)this.rightErrorVariable[i]).getMax();
            }
            range[1] = Math.max(range[1], value);
        }
        return range;
    }

    public double[] getYRange() {
        if (this.yVariable == null || !(this.yVariable[0] instanceof NumericVariable)) {
            return null;
        }
        int len = this.yVariable.length;
        double[] range = new double[2];
        boolean upError = this.upErrorVariable != null;
        boolean downError = this.downErrorVariable != null;
        range[0] = ((NumericVariable)this.yVariable[0]).getMin();
        if (downError && this.downErrorVariable[0] != null) {
            range[0] = range[0] - ((NumericVariable)this.downErrorVariable[0]).getMax();
        }
        range[1] = ((NumericVariable)this.yVariable[0]).getMax();
        if (upError && this.upErrorVariable[0] != null) {
            range[1] = range[1] + ((NumericVariable)this.upErrorVariable[0]).getMax();
        }
        for (int i = 1; i < len; ++i) {
            double value = ((NumericVariable)this.yVariable[i]).getMin();
            if (downError && this.downErrorVariable[i] != null) {
                value -= ((NumericVariable)this.downErrorVariable[i]).getMax();
            }
            range[0] = Math.min(range[0], value);
            value = ((NumericVariable)this.yVariable[i]).getMax();
            if (upError && this.upErrorVariable[i] != null) {
                value += ((NumericVariable)this.upErrorVariable[i]).getMax();
            }
            range[1] = Math.max(range[1], value);
        }
        return range;
    }

    public double[] getY2Range() {
        if (this.y2Variable == null || !(this.y2Variable[0] instanceof NumericVariable)) {
            return null;
        }
        int len = this.y2Variable.length;
        double[] range = new double[2];
        boolean upError = this.up2ErrorVariable != null;
        boolean downError = this.down2ErrorVariable != null;
        range[0] = ((NumericVariable)this.y2Variable[0]).getMin();
        if (downError && this.down2ErrorVariable[0] != null) {
            range[0] = range[0] - ((NumericVariable)this.down2ErrorVariable[0]).getMax();
        }
        range[1] = ((NumericVariable)this.y2Variable[0]).getMax();
        if (upError && this.up2ErrorVariable[0] != null) {
            range[1] = range[1] + ((NumericVariable)this.up2ErrorVariable[0]).getMax();
        }
        for (int i = 1; i < len; ++i) {
            double value = ((NumericVariable)this.y2Variable[i]).getMin();
            if (downError && this.down2ErrorVariable[i] != null) {
                value -= ((NumericVariable)this.down2ErrorVariable[i]).getMax();
            }
            range[0] = Math.min(range[0], value);
            value = ((NumericVariable)this.y2Variable[i]).getMax();
            if (upError && this.up2ErrorVariable[i] != null) {
                value += ((NumericVariable)this.up2ErrorVariable[i]).getMax();
            }
            range[1] = Math.max(range[1], value);
        }
        return range;
    }

    public int getMarkerCount() {
        int ii;
        int markerCount = 0;
        int xCount = 0;
        if (this.xVariable != null) {
            for (int ii2 = 0; ii2 < this.xVariable.length; ++ii2) {
                if (this.xVariable[ii2] == null) continue;
                ++xCount;
            }
        }
        int yCount = 0;
        if (this.yVariable != null) {
            for (ii = 0; ii < this.yVariable.length; ++ii) {
                if (this.yVariable[ii] == null) continue;
                ++yCount;
            }
        }
        if (xCount > 0 && yCount > 0) {
            if (this.xVariable != null) {
                for (ii = 0; ii < this.xVariable.length; ++ii) {
                    if (this.xVariable[ii] == null) continue;
                    markerCount = this.xVariable[ii].getValueCount();
                    break;
                }
            }
            markerCount = xCount > 1 && yCount > 1 ? (markerCount *= Math.min(xCount, yCount)) : (markerCount *= Math.max(xCount, yCount));
        }
        return markerCount;
    }

    public void setXMapper(NumericMapper mapper) {
        int xsize = this.xVariable.length;
        this.xMapper = new NumericMapper[xsize];
        if (mapper instanceof StringToNumericMapper) {
            StringToNumericMapper sm = new StringToNumericMapper();
            this.xMapper[0] = sm;
            sm.input.connectFrom(((StringVariable)this.xVariable[0]).value);
            sm.shareMap((StringToNumericMapper)mapper);
        } else {
            ContinuousRangeToNumericMapper sourceMapper = (ContinuousRangeToNumericMapper)mapper;
            this.xMapper[0] = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)this.xMapper[0]).input.connectFrom(((NumericVariable)this.xVariable[0]).value);
            ((ContinuousRangeToNumericMapper)this.xMapper[0]).shareMap(sourceMapper);
            ((ContinuousRangeToNumericMapper)this.xMapper[0]).setLabelRanges(sourceMapper.isLabelRanges());
            ((ContinuousRangeToNumericMapper)this.xMapper[0]).setRangeFormat(sourceMapper.getRangeFormat());
        }
        this.xMapper[0].setLabelMissingValues(mapper.isLabelMissingValues());
        this.xMapper[0].setFormat(mapper.getFormat());
        if (this.selectionComposite != null) {
            this.xMapperSelection = new NumericMapper[xsize];
            for (int i = 0; i < xsize; ++i) {
                if (mapper instanceof StringToNumericMapper) {
                    StringToNumericMapper sm = new StringToNumericMapper();
                    this.xMapperSelection[i] = sm;
                    sm.input.connectFrom(((StringVariable)this.xVariableSelection[i]).value);
                    sm.shareMap((StringToNumericMapper)this.xMapper[0]);
                } else {
                    this.xMapperSelection[i] = new ContinuousRangeToNumericMapper();
                    ((ContinuousRangeToNumericMapper)this.xMapperSelection[i]).input.connectFrom(((NumericVariable)this.xVariableSelection[i]).value);
                    ((ContinuousRangeToNumericMapper)this.xMapperSelection[i]).shareMap((ContinuousRangeToNumericMapper)this.xMapper[0]);
                }
                this.xMapperSelection[i].setLabelMissingValues(mapper.isLabelMissingValues());
                this.xMapperSelection[i].setFormat(mapper.getFormat());
            }
        }
    }

    public void setYMapper(NumericMapper mapper) {
        int ysize = this.yVariable.length;
        this.yMapper = new NumericMapper[ysize];
        this.yMapper[0] = mapper;
        if (mapper instanceof StringToNumericMapper) {
            StringToNumericMapper sm = new StringToNumericMapper();
            this.yMapper[0] = sm;
            sm.input.connectFrom(((StringVariable)this.yVariable[0]).value);
            sm.shareMap((StringToNumericMapper)mapper);
        } else {
            ContinuousRangeToNumericMapper sourceMapper = (ContinuousRangeToNumericMapper)mapper;
            this.yMapper[0] = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)this.yMapper[0]).input.connectFrom(((NumericVariable)this.yVariable[0]).value);
            ((ContinuousRangeToNumericMapper)this.yMapper[0]).shareMap(sourceMapper);
            ((ContinuousRangeToNumericMapper)this.yMapper[0]).setLabelRanges(sourceMapper.isLabelRanges());
            ((ContinuousRangeToNumericMapper)this.yMapper[0]).setRangeFormat(sourceMapper.getRangeFormat());
        }
        this.yMapper[0].setLabelMissingValues(mapper.isLabelMissingValues());
        this.yMapper[0].setFormat(mapper.getFormat());
        if (this.selectionComposite != null) {
            this.yMapperSelection = new NumericMapper[ysize];
            for (int i = 0; i < ysize; ++i) {
                if (mapper instanceof StringToNumericMapper) {
                    StringToNumericMapper sm = new StringToNumericMapper();
                    this.yMapperSelection[i] = sm;
                    sm.input.connectFrom(((StringVariable)this.yVariableSelection[i]).value);
                    sm.shareMap((StringToNumericMapper)this.yMapper[0]);
                } else {
                    this.yMapperSelection[i] = new ContinuousRangeToNumericMapper();
                    ((ContinuousRangeToNumericMapper)this.yMapperSelection[i]).input.connectFrom(((NumericVariable)this.yVariableSelection[i]).value);
                    ((ContinuousRangeToNumericMapper)this.yMapperSelection[i]).shareMap((ContinuousRangeToNumericMapper)this.yMapper[0]);
                }
                this.yMapperSelection[i].setLabelMissingValues(mapper.isLabelMissingValues());
                this.yMapperSelection[i].setFormat(mapper.getFormat());
            }
        }
    }

    public void setY2Mapper(NumericMapper mapper) {
        int ysize = this.y2Variable.length;
        this.y2Mapper = new NumericMapper[ysize];
        this.y2Mapper[0] = mapper;
        if (mapper instanceof StringToNumericMapper) {
            StringToNumericMapper sm = new StringToNumericMapper();
            this.y2Mapper[0] = sm;
            sm.input.connectFrom(((StringVariable)this.y2Variable[0]).value);
            sm.shareMap((StringToNumericMapper)mapper);
        } else {
            ContinuousRangeToNumericMapper sourceMapper = (ContinuousRangeToNumericMapper)mapper;
            this.y2Mapper[0] = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)this.y2Mapper[0]).input.connectFrom(((NumericVariable)this.y2Variable[0]).value);
            ((ContinuousRangeToNumericMapper)this.y2Mapper[0]).shareMap(sourceMapper);
            ((ContinuousRangeToNumericMapper)this.y2Mapper[0]).setLabelRanges(sourceMapper.isLabelRanges());
            ((ContinuousRangeToNumericMapper)this.y2Mapper[0]).setRangeFormat(sourceMapper.getRangeFormat());
        }
        this.y2Mapper[0].setLabelMissingValues(mapper.isLabelMissingValues());
        this.y2Mapper[0].setFormat(mapper.getFormat());
        if (this.yVariable == null) {
            this.yMapper = this.y2Mapper;
        }
        if (this.selectionComposite != null) {
            this.y2MapperSelection = new NumericMapper[ysize];
            for (int i = 0; i < ysize; ++i) {
                if (mapper instanceof StringToNumericMapper) {
                    StringToNumericMapper sm = new StringToNumericMapper();
                    this.y2MapperSelection[i] = sm;
                    sm.input.connectFrom(((StringVariable)this.y2VariableSelection[i]).value);
                    sm.shareMap((StringToNumericMapper)this.y2Mapper[0]);
                } else {
                    this.y2MapperSelection[i] = new ContinuousRangeToNumericMapper();
                    ((ContinuousRangeToNumericMapper)this.y2MapperSelection[i]).input.connectFrom(((NumericVariable)this.y2VariableSelection[i]).value);
                    ((ContinuousRangeToNumericMapper)this.y2MapperSelection[i]).shareMap((ContinuousRangeToNumericMapper)this.y2Mapper[0]);
                }
                this.y2MapperSelection[i].setLabelMissingValues(mapper.isLabelMissingValues());
                this.y2MapperSelection[i].setFormat(mapper.getFormat());
            }
            if (this.yVariable == null) {
                this.yMapperSelection = this.y2MapperSelection;
            }
        }
    }

    void setXAxisCellModel(AxisCellModel model) {
        this.xAxisCellModel = model;
    }

    void setYAxisCellModel(AxisCellModel model) {
        this.yAxisCellModel = model;
    }

    void setY2AxisCellModel(AxisCellModel model) {
        this.y2AxisCellModel = model;
        if (this.yVariable == null) {
            this.yAxisCellModel = model;
        }
    }

    public Variable[] getXVariable() {
        return this.xVariable;
    }

    public Variable[] getYVariable() {
        return this.yVariable;
    }

    private void addReferenceLines(boolean numeric, AxisModel axisModel, Mapper mapper, Variable variable, Composite frontComposite, Composite backComposite, double xend, double yend, boolean isHorizontalAxis, int row, int column, int automaticNumericJustification, int automaticStringJustification) {
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        int maxRow = cellModel.getMaxRow();
        int maxColumn = cellModel.getMaxColumn();
        double yLength = Math.round(this.yAxisCellModel.getLength());
        double xLength = Math.round(this.xAxisCellModel.getLength());
        if (numeric) {
            Util.addReferenceLines(axisModel.getReferenceLineModels(), this.channel, this.dataSource, null, mapper, axisModel, this.xAxisLeadingMarginLength, xend, this.yAxisLeadingMarginLength, yend, yLength, xLength, isHorizontalAxis, frontComposite, frontComposite, row, column, maxRow, maxColumn, 0.0, automaticNumericJustification, 11302, true, true);
            Util.addReferenceLines(axisModel.getReferenceLineModels(), this.channel, this.dataSource, null, mapper, axisModel, this.xAxisLeadingMarginLength, xend, this.yAxisLeadingMarginLength, yend, yLength, xLength, isHorizontalAxis, backComposite, frontComposite, row, column, maxRow, maxColumn, 0.0, automaticNumericJustification, 11302, false, true);
        } else {
            Util.addReferenceLines(axisModel.getReferenceLineModels(), this.channel, this.dataSource, (StringVariable)variable, (Mapper)((StringToNumericMapper)mapper), axisModel, this.xAxisLeadingMarginLength, xend, this.yAxisLeadingMarginLength, yend, this.yAxisLength - this.yAxisLeadingMarginLength - yend, this.xAxisLength - this.xAxisLeadingMarginLength - xend, isHorizontalAxis, backComposite, frontComposite, row, column, maxRow, maxColumn, 0.0, automaticStringJustification, 11301, false, true);
            Util.addReferenceLines(axisModel.getReferenceLineModels(), this.channel, this.dataSource, (StringVariable)variable, (Mapper)((StringToNumericMapper)mapper), axisModel, this.xAxisLeadingMarginLength, xend, this.yAxisLeadingMarginLength, yend, this.yAxisLength - this.yAxisLeadingMarginLength - yend, this.xAxisLength - this.xAxisLeadingMarginLength - xend, isHorizontalAxis, frontComposite, frontComposite, row, column, maxRow, maxColumn, 0.0, automaticStringJustification, 11301, true, true);
        }
    }

    private double addALine(Composite c, double[] loc, LineStyle lineStyle) {
        if (lineStyle.getVisibilityPolicy() == 10202) {
            return 0.0;
        }
        LineSegment eSegment = new LineSegment();
        double width = 2.0;
        if (lineStyle instanceof StrokeLineStyle) {
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes((StrokeLineStyle)lineStyle);
            eSegment.setStipple(gla.stipplePattern, gla.stippleFactor);
            width = gla.lineWidth;
        }
        eSegment.lineWidth.setValue(width);
        eSegment.beginX.setValue(loc[0]);
        eSegment.endX.setValue(loc[1]);
        eSegment.beginY.setValue(loc[2]);
        eSegment.endY.setValue(loc[3]);
        eSegment.color.setValue(lineStyle.getColor());
        c.addElement((Element)eSegment);
        return width;
    }

    private RasterLabel getALabel(TextStyle textStyle, String text, double[] loc, int horzJustification, int vertJustification) {
        RasterLabel label = new RasterLabel();
        label.setFont(textStyle.getFont());
        label.color.setValue(textStyle.getColor());
        label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
        label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
        label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
        label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
        label.trimOn.setValue(true);
        double xpos = loc[0];
        double ypos = loc[1];
        if (vertJustification == 1) {
            label.verticalJustification.setValue(0);
        } else if (vertJustification == 0) {
            label.verticalJustification.setValue(1);
        } else {
            label.verticalJustification.setValue(3);
        }
        if (horzJustification == 4) {
            label.horizontalJustification.setValue(2);
        } else if (horzJustification == 0) {
            label.horizontalJustification.setValue(1);
        } else {
            label.horizontalJustification.setValue(0);
        }
        label.angle.setValue(Util.resolveBaselineAngle(textStyle));
        label.transform.translateX.setValue(xpos);
        label.transform.translateY.setValue(ypos);
        label.string.setValue(text);
        return label;
    }

    AxisCellModel getXAxisCellModel() {
        if (this.xAxisCellModel != null) {
            return this.xAxisCellModel;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        return cellModel.getXAxisCellModel();
    }

    AxisCellModel getYAxisCellModel() {
        if (this.yAxisCellModel != null) {
            return this.xAxisCellModel;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        return cellModel.getYAxisCellModel();
    }

    AxisCellModel getY2AxisCellModel() {
        if (this.y2AxisCellModel != null) {
            return this.xAxisCellModel;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        return cellModel.getY2AxisCellModel();
    }

    public PlotImageMapInfo2 getImageMapInfo(ValueList columnValueList, ValueList rowValueList, NetworkRoot root, JComponent source) {
        Vector selectableShapes = root.computeSelectableShapes();
        PlotImageMapInfo2 scatterPlotImageMapInfo = null;
        Shape xTitleShape = null;
        Shape yTitleShape = null;
        Shape y2TitleShape = null;
        Shape xMarkerShape = null;
        Shape yMarkerShape = null;
        Shape y2MarkerShape = null;
        if (selectableShapes != null) {
            int count = selectableShapes.size();
            boolean xIsString = this.xVariable[0] instanceof StringVariable;
            boolean yIsString = this.yVariable != null && this.yVariable[0] instanceof StringVariable;
            boolean y2IsString = this.y2Variable != null && this.y2Variable[0] instanceof StringVariable;
            ArrayList<PlotValueZone> xValueZonesList = xIsString ? new ArrayList<PlotValueZone>(count) : null;
            ArrayList<PlotValueZone> yValueZonesList = yIsString ? new ArrayList<PlotValueZone>(count) : null;
            ArrayList<PlotValueZone> y2ValueZonesList = y2IsString ? new ArrayList<PlotValueZone>(count) : null;
            ArrayList<PlotValueZone> dataElementValueZonesList = new ArrayList<PlotValueZone>(count);
            for (int ii = 0; ii < count; ++ii) {
                double y;
                double x;
                SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
                SelectResult sr = selectableShape.getSelectResult();
                Element element = sr.getElement();
                if (element instanceof RectangularAxis) {
                    RectangularAxis axis = (RectangularAxis)element;
                    AxisDetail axisDetail = (AxisDetail)sr.getDetail();
                    int orientation = axis.getOrientation();
                    if (axisDetail == null) continue;
                    if (orientation == 1) {
                        if (xIsString && axisDetail.getType() == 0) {
                            try {
                                ValueList xValueList = new ValueList(axis.labels.getValue(axisDetail.getLabelIndex()), axis.labels.getValue(axisDetail.getLabelIndex()), null);
                                PlotValueZone xValueZone = new PlotValueZone(selectableShape.getShape(), columnValueList, rowValueList, xValueList, null, null, null, null);
                                xValueZonesList.add(xValueZone);
                            }
                            catch (MissingValueException xValueList) {}
                            continue;
                        }
                        if (axisDetail.getType() == 2) {
                            xTitleShape = selectableShape.getShape();
                            continue;
                        }
                        if (axisDetail.getType() != 4) continue;
                        xMarkerShape = selectableShape.getShape();
                        continue;
                    }
                    if (axis.isPrimary()) {
                        if (yIsString && axisDetail.getType() == 0) {
                            try {
                                ValueList yValueList = new ValueList(axis.labels.getValue(axisDetail.getLabelIndex()), axis.labels.getValue(axisDetail.getLabelIndex()), null);
                                PlotValueZone yValueZone = new PlotValueZone(selectableShape.getShape(), columnValueList, rowValueList, null, yValueList, null, null, null);
                                yValueZonesList.add(yValueZone);
                            }
                            catch (MissingValueException yValueList) {}
                            continue;
                        }
                        if (axisDetail.getType() == 2) {
                            yTitleShape = selectableShape.getShape();
                            continue;
                        }
                        if (axisDetail.getType() != 4) continue;
                        yMarkerShape = selectableShape.getShape();
                        continue;
                    }
                    if (y2IsString && axisDetail.getType() == 0) {
                        try {
                            ValueList y2ValueList = new ValueList(axis.labels.getValue(axisDetail.getLabelIndex()), axis.labels.getValue(axisDetail.getLabelIndex()), null);
                            PlotValueZone y2ValueZone = new PlotValueZone(selectableShape.getShape(), columnValueList, rowValueList, null, null, y2ValueList, null, null);
                            y2ValueZonesList.add(y2ValueZone);
                        }
                        catch (MissingValueException y2ValueList) {}
                        continue;
                    }
                    if (axisDetail.getType() == 2) {
                        y2TitleShape = selectableShape.getShape();
                        continue;
                    }
                    if (axisDetail.getType() != 4) continue;
                    y2MarkerShape = selectableShape.getShape();
                    continue;
                }
                if (element instanceof RasterLabel && element.getUserData() != null) {
                    if (!(element.getUserData() instanceof Util.SelectInfo) || !(((Util.SelectInfo)element.getUserData()).userData instanceof String)) continue;
                    String userData = (String)((Util.SelectInfo)element.getUserData()).userData;
                    if (userData.equals("PX")) {
                        xTitleShape = selectableShape.getShape();
                        continue;
                    }
                    if (userData.equals("PY")) {
                        yTitleShape = selectableShape.getShape();
                        continue;
                    }
                    if (!userData.equals("SY")) continue;
                    y2TitleShape = selectableShape.getShape();
                    continue;
                }
                if (!(element instanceof Marker) && !(element instanceof FilledLineConnector)) continue;
                int obsIndex = sr.getValueIndex();
                if (element instanceof Marker) {
                    Marker m = (Marker)element;
                    try {
                        x = m.coordX.getValue(obsIndex);
                        y = m.coordY.getValue(obsIndex);
                    }
                    catch (MissingValueException e) {
                        y = 0.0;
                        x = 0.0;
                    }
                } else {
                    FilledLineConnector flc = (FilledLineConnector)element;
                    try {
                        x = flc.pointX.getValue(obsIndex);
                        y = flc.pointY.getValue(obsIndex);
                    }
                    catch (MissingValueException e) {
                        y = 0.0;
                        x = 0.0;
                    }
                }
                ValueList[] valueList = this.computeValueList(obsIndex, x, y);
                ValueList groupValueList = GTKUtil.toValueList((Variable)this.groupVariable, obsIndex);
                ValueList sizeValueList = GTKUtil.toValueList(this.sizeVariable, obsIndex);
                ValueList dataTipValueList = GTKUtil.toValueList(this.dataTipVariableArray, obsIndex);
                ValueList auxiliaryValueList = GTKUtil.toValueList(this.auxiliaryVariableArray, obsIndex);
                PlotValueZone elementValueZone = new PlotValueZone(selectableShape.getShape(), columnValueList, rowValueList, valueList[0], valueList[1], valueList[2], sizeValueList, groupValueList, dataTipValueList, auxiliaryValueList);
                dataElementValueZonesList.add(elementValueZone);
            }
            LabelZoneList xLabelZoneList = null;
            LabelZoneList yLabelZoneList = null;
            LabelZoneList y2LabelZoneList = null;
            if (xTitleShape != null) {
                xLabelZoneList = new LabelZoneList(xTitleShape, this.xVariable[0].getName(), this.xVariable[0].getLabel(), new DataZone(xMarkerShape), null);
            }
            if (yTitleShape != null) {
                yLabelZoneList = new LabelZoneList(yTitleShape, this.yVariable[0].getName(), this.yVariable[0].getLabel(), new DataZone(yMarkerShape), null);
            }
            if (y2TitleShape != null) {
                y2LabelZoneList = new LabelZoneList(y2TitleShape, this.y2Variable[0].getName(), this.y2Variable[0].getLabel(), new DataZone(y2MarkerShape), null);
            }
            PlotValueZone[] xValueZones = xIsString ? xValueZonesList.toArray(new PlotValueZone[0]) : null;
            PlotValueZone[] yValueZones = yIsString ? yValueZonesList.toArray(new PlotValueZone[0]) : null;
            PlotValueZone[] y2ValueZones = y2IsString ? y2ValueZonesList.toArray(new PlotValueZone[0]) : null;
            PlotValueZone[] dataElementValueZones = dataElementValueZonesList.toArray(new PlotValueZone[0]);
            if (dataElementValueZones != null) {
                for (int ii = 0; ii < dataElementValueZones.length / 2; ++ii) {
                    PlotValueZone vz = dataElementValueZones[dataElementValueZones.length - ii - 1];
                    dataElementValueZones[dataElementValueZones.length - ii - 1] = dataElementValueZones[ii];
                    dataElementValueZones[ii] = vz;
                }
            }
            scatterPlotImageMapInfo = new PlotImageMapInfo2(null, null, xValueZones, yValueZones, y2ValueZones, null, null, dataElementValueZones, null, null, xLabelZoneList, yLabelZoneList, y2LabelZoneList, null, null);
            scatterPlotImageMapInfo.source = source;
        }
        return scatterPlotImageMapInfo;
    }

    private ValueList[] computeValueList(int obsIndex, double x, double y) {
        ValueList xValueList = null;
        if (this.xVariable != null && this.xVariable.length > 0) {
            for (int i = this.xVariable.length - 1; i >= 0; --i) {
                try {
                    if (this.xMapper[i] == null) {
                        xValueList = new ValueList(this.xVariable[i], null, xValueList);
                        continue;
                    }
                    double xval = this.xMapper[i].getValue(obsIndex);
                    if (xval == x) {
                        xValueList = GTKUtil.toValueList(this.xVariable[i], obsIndex, xValueList);
                        continue;
                    }
                    xValueList = new ValueList(this.xVariable[i], null, xValueList);
                    continue;
                }
                catch (MissingValueException e) {
                    xValueList = new ValueList(this.xVariable[i], null, xValueList);
                }
            }
        }
        ValueList yValueList = null;
        if (this.yVariable != null && this.yVariable.length > 0) {
            for (int i = this.yVariable.length - 1; i >= 0; --i) {
                if (this.yMapper[i] == null) {
                    yValueList = new ValueList(this.yVariable[i], null, yValueList);
                    continue;
                }
                try {
                    double yval = this.yMapper[i].getValue(obsIndex);
                    if (yval == y) {
                        yValueList = GTKUtil.toValueList(this.yVariable[i], obsIndex, yValueList);
                        continue;
                    }
                    yValueList = new ValueList(this.yVariable[i], null, yValueList);
                    continue;
                }
                catch (MissingValueException e) {
                    yValueList = new ValueList(this.yVariable[i], null, yValueList);
                }
            }
        }
        ValueList y2ValueList = null;
        if (this.y2Variable != null && this.y2Variable.length > 0) {
            for (int i = this.y2Variable.length - 1; i >= 0; --i) {
                if (this.y2Mapper[i] == null) {
                    y2ValueList = new ValueList(this.y2Variable[i], null, y2ValueList);
                    continue;
                }
                try {
                    double y2val = this.y2Mapper[i].getValue(obsIndex);
                    if (y2val == y) {
                        y2ValueList = GTKUtil.toValueList(this.y2Variable[i], obsIndex, y2ValueList);
                        continue;
                    }
                    y2ValueList = new ValueList(this.y2Variable[i], null, y2ValueList);
                    continue;
                }
                catch (MissingValueException e) {
                    y2ValueList = new ValueList(this.y2Variable[i], null, y2ValueList);
                }
            }
        }
        return new ValueList[]{xValueList, yValueList, y2ValueList};
    }

    private static Variable[] checkVariableList(Variable[] list) {
        int i;
        if (list == null) {
            return list;
        }
        boolean isNumeric = list[0] instanceof NumericVariable;
        boolean forceString = false;
        int len = list.length;
        for (i = 0; i < len; ++i) {
            if (list[i] instanceof NumericVariable == isNumeric) continue;
            forceString = true;
            break;
        }
        if (forceString) {
            for (i = 0; i < len; ++i) {
                if (!(list[i] instanceof NumericVariable)) continue;
                StringVariable stringVariable = new StringVariable();
                stringVariable.connectFrom((NumericVariable)list[i]);
                stringVariable.setLabel(list[i].getLabel());
                list[i] = stringVariable;
            }
        }
        return list;
    }

    Composite createSelectionComposite(DataSource data) {
        int i;
        boolean validY;
        if (data == null) {
            return null;
        }
        ScatterPlotCellModel cellModel = (ScatterPlotCellModel)this.getModel();
        ScatterPlotMatrixModel matrixModel = cellModel.getScatterPlotMatrixModel();
        ScatterPlotModel plotModel = matrixModel.getScatterPlotModel();
        this.dataSourceSelection = data;
        this.dataSourceSelection.sortBy(matrixModel.getSortRole());
        this.yVariableSelection = ScatterComposite.checkVariableList(this.dataSourceSelection.getVariable(this.yVariableRole));
        this.xVariableSelection = ScatterComposite.checkVariableList(this.dataSourceSelection.getVariable(this.xVariableRole));
        this.y2VariableSelection = ScatterComposite.checkVariableList(this.dataSourceSelection.getVariable(this.y2VariableRole));
        this.leftErrorVariableSelection = this.dataSourceSelection.getLowVariable(this.xVariableRole);
        this.rightErrorVariableSelection = this.dataSourceSelection.getHighVariable(this.xVariableRole);
        this.upErrorVariableSelection = this.dataSourceSelection.getHighVariable(this.yVariableRole);
        this.downErrorVariableSelection = this.dataSourceSelection.getLowVariable(this.yVariableRole);
        this.up2ErrorVariableSelection = this.dataSourceSelection.getHighVariable(this.y2VariableRole);
        this.down2ErrorVariableSelection = this.dataSourceSelection.getLowVariable(this.y2VariableRole);
        this.aboveValueVariableSelection = this.dataSourceSelection.getVariable(this.aboveValueVariableRole, 0);
        this.belowValueVariableSelection = this.dataSourceSelection.getVariable(this.belowValueVariableRole, 0);
        this.shapeVariableSelection = this.dataSourceSelection.getVariable(this.shapeVariableRole, 0);
        this.colorVariableSelection = this.dataSourceSelection.getVariable(this.colorVariableRole, 0);
        this.sizeVariableSelection = this.dataSourceSelection.getVariable(this.sizeVariableRole, 0);
        this.groupVariableSelection = this.dataSourceSelection.getVariable(matrixModel.getGroupRole(), 0);
        boolean displayMissing = plotModel.getMissingPolicy() == 10201;
        this.xMapperSelection = new NumericMapper[this.xVariableSelection.length];
        if (this.xMapper[0] != null) {
            for (int i2 = 0; i2 < this.xVariableSelection.length; ++i2) {
                if (this.xMapper[0] instanceof StringToNumericMapper) {
                    this.xMapperSelection[i2] = new StringToNumericMapper();
                    ((StringToNumericMapper)this.xMapperSelection[i2]).input.connectFrom(((StringVariable)this.xVariableSelection[i2]).value);
                    ((StringToNumericMapper)this.xMapperSelection[i2]).shareMap((StringToNumericMapper)this.xMapper[0]);
                    this.xMapperSelection[i2].setLabelMissingValues(displayMissing);
                    continue;
                }
                this.xMapperSelection[i2] = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)this.xMapperSelection[i2]).input.connectFrom(((NumericVariable)this.xVariableSelection[i2]).value);
                ((ContinuousRangeToNumericMapper)this.xMapperSelection[i2]).shareMap((ContinuousRangeToNumericMapper)this.xMapper[0]);
            }
        }
        boolean bl = validY = this.yVariableSelection != null;
        if (validY && this.yMapper != null) {
            this.yMapperSelection = new NumericMapper[this.yVariableSelection.length];
            for (i = 0; i < this.yVariableSelection.length; ++i) {
                if (this.yMapper[0] instanceof StringToNumericMapper) {
                    this.yMapperSelection[i] = new StringToNumericMapper();
                    ((StringToNumericMapper)this.yMapperSelection[i]).input.connectFrom(((StringVariable)this.yVariableSelection[i]).value);
                    ((StringToNumericMapper)this.yMapperSelection[i]).shareMap((StringToNumericMapper)this.yMapper[0]);
                    this.yMapperSelection[i].setLabelMissingValues(displayMissing);
                    continue;
                }
                this.yMapperSelection[i] = new ContinuousRangeToNumericMapper();
                ((ContinuousRangeToNumericMapper)this.yMapperSelection[i]).input.connectFrom(((NumericVariable)this.yVariableSelection[i]).value);
                ((ContinuousRangeToNumericMapper)this.yMapperSelection[i]).shareMap((ContinuousRangeToNumericMapper)this.yMapper[0]);
            }
        }
        this.selectionComposite = new Composite();
        if (this.y2Mapper == null) {
            return this.selectionComposite;
        }
        this.y2MapperSelection = new NumericMapper[this.y2VariableSelection.length];
        for (i = 0; i < this.y2VariableSelection.length; ++i) {
            if (this.y2Mapper[0] instanceof StringToNumericMapper) {
                this.y2MapperSelection[i] = new StringToNumericMapper();
                ((StringToNumericMapper)this.y2MapperSelection[i]).input.connectFrom(((StringVariable)this.y2VariableSelection[i]).value);
                ((StringToNumericMapper)this.y2MapperSelection[i]).shareMap((StringToNumericMapper)this.y2Mapper[i]);
                continue;
            }
            this.y2MapperSelection[i] = new ContinuousRangeToNumericMapper();
            ((ContinuousRangeToNumericMapper)this.y2MapperSelection[i]).input.connectFrom(((NumericVariable)this.y2VariableSelection[i]).value);
            ((ContinuousRangeToNumericMapper)this.y2MapperSelection[i]).shareMap((ContinuousRangeToNumericMapper)this.y2Mapper[0]);
        }
        if (!validY) {
            this.yMapperSelection = this.y2MapperSelection;
        }
        return this.selectionComposite;
    }

    public void updateChannel() {
        boolean dim3D;
        Dimension depth = this.xAxisCellModel.getDepth();
        boolean bl = dim3D = depth.width > 0;
        if (dim3D) {
            this.channel.glViewport(0, 0, (int)this.xAxisLength, (int)this.yAxisLength);
            this.channel.glOblique(0.0, this.xAxisLength, (double)depth.height, this.yAxisLength + (double)depth.height, 0.0, (double)depth.width, 1.0, 45.0);
            this.channel.glEnable(3);
            this.channel.glEnable(19);
            this.channel.glEnable(1);
            this.channel.glLight(19, 3, new double[]{0.5, 0.5, 1.0});
        }
    }

    public void selectionChanged() {
        int n = this.selectionFilterList.size();
        for (int i = 0; i < n; ++i) {
            SelectionFilter sf = (SelectionFilter)this.selectionFilterList.get(i);
            sf.setSelectionDirty(true);
        }
    }

    private static Image translateRiskMap(Image image, boolean descReverseX, boolean descReverseY, boolean reverseX, boolean reverseY) {
        AffineTransform tx = new AffineTransform();
        boolean translateNeeded = false;
        int xMirror = 1;
        int yMirror = 1;
        int width = 0;
        int height = 0;
        if (reverseY) {
            yMirror = -1;
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (reverseX) {
            xMirror = -1;
            width = image.getWidth(null);
            translateNeeded = true;
        }
        if (!descReverseX && descReverseY && !reverseX && !reverseY) {
            xMirror = 1;
            yMirror = -1;
            width = 0;
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (!descReverseX && descReverseY && reverseX && !reverseY) {
            xMirror = -1;
            yMirror = -1;
            width = image.getWidth(null);
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (!descReverseX && descReverseY && !reverseX && reverseY) {
            xMirror = 1;
            yMirror = 1;
            width = image.getWidth(null);
            height = 0;
            translateNeeded = true;
        }
        if (!descReverseX && descReverseY && reverseX && reverseY) {
            xMirror = -1;
            yMirror = 1;
            width = image.getWidth(null);
            height = 0;
            translateNeeded = true;
        }
        if (descReverseX && !descReverseY && !reverseX && !reverseY) {
            xMirror = -1;
            yMirror = 1;
            width = image.getWidth(null);
            height = 0;
            translateNeeded = true;
        }
        if (descReverseX && !descReverseY && reverseX && !reverseY) {
            xMirror = 1;
            yMirror = 1;
            width = image.getWidth(null);
            height = 0;
            translateNeeded = true;
        }
        if (descReverseX && !descReverseY && !reverseX && reverseY) {
            xMirror = -1;
            yMirror = -1;
            width = image.getWidth(null);
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (descReverseX && !descReverseY && reverseX && reverseY) {
            xMirror = 1;
            yMirror = -1;
            width = 0;
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (descReverseX && descReverseY && !reverseX && !reverseY) {
            xMirror = -1;
            yMirror = -1;
            width = image.getWidth(null);
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (descReverseX && descReverseY && reverseX && !reverseY) {
            xMirror = 1;
            yMirror = -1;
            width = 0;
            height = image.getHeight(null);
            translateNeeded = true;
        }
        if (descReverseX && descReverseY && !reverseX && reverseY) {
            xMirror = -1;
            yMirror = 1;
            width = image.getWidth(null);
            height = 0;
            translateNeeded = true;
        }
        if (descReverseX && descReverseY && reverseX && reverseY) {
            xMirror = 1;
            yMirror = 1;
            width = image.getWidth(null);
            height = 0;
            translateNeeded = true;
        }
        if (translateNeeded) {
            tx.translate(width, height);
            tx.scale(xMirror, yMirror);
            Graphics2D g2d = (Graphics2D)image.getGraphics();
            g2d.drawImage(image, tx, null);
        }
        return image;
    }

    private class SelectionFilter {
        private PointLabelLayout llm;
        private NumericPipe selectionPipe;
        private Map indexMap = new HashMap();
        private MutableInteger tempKey = new MutableInteger(0);
        private boolean selectionDirty = true;
        private NSP xSP;
        public NumericPipe xpos;
        private NSP ySP;
        public NumericPipe ypos;
        private ISP haSP;
        public IntegerPipe hAlign;
        private ISP vaSP;
        public IntegerPipe vAlign;
        private SSP sSP;
        public StringPipe adjustedLabel;

        public SelectionFilter(PointLabelLayout llm, NumericPipe selectionPipe) {
            this.selectionPipe = selectionPipe;
            this.llm = llm;
            this.xSP = new NSP(llm.xpos);
            this.xpos = this.xSP;
            this.ySP = new NSP(llm.ypos);
            this.ypos = this.ySP;
            this.haSP = new ISP(llm.hAlign);
            this.hAlign = this.haSP;
            this.vaSP = new ISP(llm.vAlign);
            this.vAlign = this.vaSP;
            this.sSP = new SSP((StringPipe)llm.adjustedLabel);
            this.adjustedLabel = this.sSP;
        }

        private int initIndexMap(AInitAction ia) {
            if (this.indexMap == null || this.isSelectionDirty()) {
                this.setSelectionDirty(false);
                this.indexMap.clear();
                ia.pushValueCount();
                this.llm.xpos.init(ia);
                this.llm.ypos.init(ia);
                this.llm.adjustedLabel.init(ia);
                this.llm.hAlign.init(ia);
                this.llm.vAlign.init(ia);
                this.selectionPipe.init(ia);
                int valueCount = ia.getValueCount();
                ia.popValueCount();
                for (int i = 0; i < valueCount; ++i) {
                    try {
                        double d = this.selectionPipe.getValue(i);
                        if (d == 0.0) continue;
                        Integer key = new Integer(this.indexMap.size());
                        Integer value = new Integer(i);
                        this.indexMap.put(key, value);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
            return this.indexMap.size();
        }

        public void setSelectionDirty(boolean b) {
            this.selectionDirty = true;
        }

        public boolean isSelectionDirty() {
            return this.selectionDirty;
        }

        private int getIndex(int index) throws MissingValueException {
            this.tempKey.setValue(index);
            Integer result = (Integer)this.indexMap.get(this.tempKey);
            if (result == null) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return result;
        }

        private class ISP
        extends SP
        implements IntegerPipe {
            private IntegerPipe input;

            public ISP(IntegerPipe input) {
                this.input = input;
            }

            public int getValue(int index) throws MissingValueException {
                return this.input.getValue(SelectionFilter.this.getIndex(index));
            }
        }

        private class SSP
        extends SP
        implements StringPipe {
            private StringPipe input;

            public SSP(StringPipe input) {
                this.input = input;
            }

            public String getValue(int index) throws MissingValueException {
                return this.input.getValue(SelectionFilter.this.getIndex(index));
            }
        }

        private class NSP
        extends SP
        implements NumericPipe {
            private NumericPipe input;

            public NSP(NumericPipe input) {
                this.input = input;
            }

            public double getValue(int index) throws MissingValueException {
                return this.input.getValue(SelectionFilter.this.getIndex(index));
            }
        }

        private class SP
        extends PropertyContainer
        implements Pipe {
            private SP() {
            }

            public void init(AInitAction ia) {
                int vc = SelectionFilter.this.initIndexMap(ia);
                ia.setValueCount(vc);
            }
        }
    }
}

