/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.scatterplot;

import com.sas.graphics.resources.GraphResources;
import com.sas.graphics.util.cell.scatterplot.ModernMarkerSkinFactory;
import com.sas.graphics.util.cell.scatterplot.SatinMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import java.awt.Image;

public abstract class BIPMarkerSkinFactory
extends AbstractMarkerSkinFactory {
    protected static final int SQUARE = 0;
    protected static final int CIRCLE = 1;
    private Image[] cache = new Image[2];

    protected abstract String getSkinKey(int var1);

    public static AbstractMarkerSkinFactory getInstance(int skinType) {
        BIPMarkerSkinFactory skinFactory = null;
        switch (skinType) {
            case 12301: {
                skinFactory = SatinMarkerSkinFactory.getInstance();
                break;
            }
            case 12302: {
                skinFactory = ModernMarkerSkinFactory.getInstance();
                break;
            }
        }
        return skinFactory;
    }

    private Image _getSkinImage(int markerStyle) {
        String skin = this.getSkinKey(markerStyle);
        return skin == null ? null : GraphResources.getImageIcon(skin).getImage();
    }

    protected int getStyle(int markerStyle) {
        switch (markerStyle) {
            case 0: 
            case 8: 
            case 16: 
            case 40: 
            case 41: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 164: 
            case 165: 
            case 166: {
                return 1;
            }
            case -1: 
            case 3: 
            case 11: 
            case 19: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                return 0;
            }
        }
        return -1;
    }

    public Image getSkinImage(int markerStyle) {
        int style = this.getStyle(markerStyle);
        if (style == -1) {
            return null;
        }
        if (this.cache[style] == null) {
            this.cache[style] = this._getSkinImage(markerStyle);
        }
        return this.cache[style];
    }
}

