/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.radarchart;

import com.sas.MissingValues;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.radarchart.RadarChartModel;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ColorRampLegendCellModel;
import com.sas.graphics.util.cell.CustomMarker;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.DrilldownMarker;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.radarchart.RadarChartCell;
import com.sas.graphics.util.cell.radarchart.RadarChartCellModel;
import com.sas.graphics.util.cell.radarchart.RadarChartMatrixContainer;
import com.sas.graphics.util.cell.radarchart.RadarChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class RadarChartMatrix
extends Matrix {
    private ArrayList cellList;
    private transient RadarChartMatrixModel model;
    private transient DrilldownMarker drillMarker = new DrilldownMarker();
    private transient RadarChartMatrixContainer matrixContainer;
    private transient LegendCell colorLegend;
    private transient RadarChartCellModel radarChartCellModel;

    public RadarChartMatrix(Channel channel) {
        super(channel);
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    public void setModel(RadarChartMatrixModel newModel) {
        if (this.model != newModel) {
            RadarChartMatrixModel oldModel = this.model;
            this.model = newModel;
            this.reconstruct();
            this.firePropertyChange("model", oldModel, newModel);
        }
    }

    public RadarChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    protected synchronized void construct() {
        int i;
        RadarChartCell curCell;
        RadarChartMatrixModel chartMatrixModel = this.getModel();
        if (chartMatrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        boolean responseFound = dataSource.getVariable(chartMatrixModel.getResponseRole()) != null;
        boolean uniformAxes = this.model.getRadarChartModel().isUniformAxes();
        if (!responseFound) {
            dataSource.setVariableDefinition(chartMatrixModel.getResponseRole(), new FreqVariableDefinition());
        }
        chartMatrixModel.setRowModel(chartMatrixModel.getRadarChartModel().getRowAxisModel());
        chartMatrixModel.setColumnModel(chartMatrixModel.getRadarChartModel().getColumnAxisModel());
        Boolean antialiasedGraphics = chartMatrixModel.getRadarChartModel().isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
        Boolean antialiasedText = chartMatrixModel.getRadarChartModel().isAntialiasedText() ? Boolean.TRUE : Boolean.FALSE;
        Variable categoryGTKVar = dataSource.getVariable(chartMatrixModel.getCategoryRole(), 0);
        Variable[] responseGTKVars = dataSource.getVariable(chartMatrixModel.getResponseRole());
        Variable subgroupGTKVar = dataSource.getVariable(chartMatrixModel.getSubgroupRole(), 0);
        int numCategories = categoryGTKVar != null ? categoryGTKVar.getUniqueValueCount() : 0;
        AxisCellModel[] dependentAxisCellModel = new AxisCellModel[numCategories];
        ContinuousRangeToNumericMapper[] dependentAxisMapper = new ContinuousRangeToNumericMapper[numCategories];
        double maxBaseline = 0.0;
        double minBaseline = Double.MAX_VALUE;
        double[] rangeMin = new double[numCategories];
        double[] rangeMax = new double[numCategories];
        if (subgroupGTKVar == null) {
            minBaseline = 0.0;
        }
        if (!uniformAxes) {
            for (int i2 = 0; i2 < numCategories; ++i2) {
                rangeMin[i2] = minBaseline;
                rangeMax[i2] = maxBaseline;
                String currentCat = "";
                try {
                    currentCat = ((StringVariable)categoryGTKVar).formattedUniqueValue.getValue(i2);
                }
                catch (MissingValueException mve) {
                    currentCat = ValueMap.getDefaultMissingValueLabel((MissingValues)mve.getMissingValue());
                }
                for (int j = 0; j < responseGTKVars[0].getValueCount(); ++j) {
                    String category = "";
                    try {
                        category = ((StringVariable)categoryGTKVar).formattedValue.getValue(j);
                    }
                    catch (MissingValueException mve) {
                        category = ValueMap.getDefaultMissingValueLabel((MissingValues)mve.getMissingValue());
                    }
                    if (!category.equals(currentCat)) continue;
                    try {
                        double value = ((NumericVariable)responseGTKVars[0]).value.getValue(j);
                        rangeMin[i2] = Math.min(rangeMin[i2], value);
                        rangeMax[i2] = Math.max(rangeMax[i2], value);
                        continue;
                    }
                    catch (MissingValueException value) {
                        // empty catch block
                    }
                }
            }
        } else {
            double min = minBaseline;
            double max = maxBaseline;
            if (responseGTKVars != null) {
                for (int ii = 0; ii < responseGTKVars.length; ++ii) {
                    min = Math.min(min, ((NumericVariable)responseGTKVars[ii]).getMin());
                    max = Math.max(max, ((NumericVariable)responseGTKVars[ii]).getMax());
                }
            }
            for (int i3 = 0; i3 < numCategories; ++i3) {
                rangeMax[i3] = max;
                rangeMin[i3] = min;
            }
        }
        StringVector categories = new StringVector();
        AxisModel axisModel = this.model.getRadarChartModel().getAxisModel();
        for (int i4 = 0; i4 < numCategories; ++i4) {
            try {
                categories.addValue(((StringVariable)categoryGTKVar).formattedUniqueValue.getValue(i4));
            }
            catch (MissingValueException mve) {
                categories.addValue(ValueMap.getDefaultMissingValueLabel((MissingValues)mve.getMissingValue()));
            }
            dependentAxisMapper[i4] = new ContinuousRangeToNumericMapper();
            dependentAxisMapper[i4].setInputMin(rangeMin[i4]);
            dependentAxisMapper[i4].setInputMax(rangeMax[i4]);
            dependentAxisMapper[i4].setOutputMin(0.0);
            dependentAxisMapper[i4].setOutputMax(20.0);
            dependentAxisMapper[i4].setLabelCount(5);
            dependentAxisMapper[i4].setFormat(responseGTKVars[0].getFormat());
            dependentAxisMapper[i4].setLabelRanges(axisModel.getContinuousValuePlacementPolicy() == 12202);
            dependentAxisCellModel[i4] = new AxisCellModel();
            dependentAxisCellModel[i4].setLocale(dataSource.getLocale());
            dependentAxisCellModel[i4].setAntialiasedText(antialiasedText);
            dependentAxisCellModel[i4].setAntialiasedGraphics(antialiasedGraphics);
            dependentAxisCellModel[i4].setMapper((NumericMapper)dependentAxisMapper[i4]);
            dependentAxisCellModel[i4].setValueCount(new Integer(5));
            dependentAxisCellModel[i4].setOrigin(new Double(0.0));
            dependentAxisCellModel[i4].setLength(new Double(20.0));
            dependentAxisCellModel[i4].setValueCount(new Integer(5));
            dependentAxisCellModel[i4].setAxisModel(axisModel);
            Channel channel = this.getChannel();
            Util.updateChannel(channel, 1, 1);
        }
        ColorMapper[] colorMapper = this._addLegend(dataSource, chartMatrixModel, chartMatrixModel.getRadarChartModel());
        this.radarChartCellModel = new RadarChartCellModel();
        this.radarChartCellModel.setCategoryRole(chartMatrixModel.getCategoryRole());
        this.radarChartCellModel.setSubgroupRole(chartMatrixModel.getSubgroupRole());
        this.radarChartCellModel.setResponseRole(chartMatrixModel.getResponseRole());
        this.radarChartCellModel.setAuxiliaryRole(chartMatrixModel.getAuxiliaryRole());
        this.radarChartCellModel.setDataTipRole(chartMatrixModel.getDataTipRole());
        this.radarChartCellModel.setSelectionRole(chartMatrixModel.getSelectionRole());
        this.radarChartCellModel.setRadarChartModel(chartMatrixModel.getRadarChartModel());
        this.radarChartCellModel.setTitleMarker(this.drillMarker);
        this.radarChartCellModel.setAntialiasedGraphics(antialiasedGraphics);
        this.radarChartCellModel.setAntialiasedText(antialiasedText);
        this.radarChartCellModel.setDependentAxisCellModel(dependentAxisCellModel);
        this.radarChartCellModel.setWallColor(WALL_COLOR);
        this.radarChartCellModel.setStartAngle(new Double(this.model.getRadarChartModel().getStartAngle()));
        this.radarChartCellModel.setFilledRadar(new Boolean(this.model.getRadarChartModel().isFillEnabled()));
        this.radarChartCellModel.setCategories(categories);
        DataElementStyles dataElementStyles = chartMatrixModel.getRadarChartModel().getDataElementStyles();
        if (dataElementStyles != null && dataElementStyles.getFillStyles() != null && dataElementStyles.getFillStyles().length > 0) {
            FillStyle[] fillStyles = dataElementStyles.getFillStyles();
            Color[] colorScheme = new Color[fillStyles.length];
            for (int ii = 0; ii < fillStyles.length; ++ii) {
                colorScheme[ii] = fillStyles[ii].getSolidFillColor();
            }
            this.radarChartCellModel.setColorScheme(colorScheme);
        }
        if (colorMapper != null) {
            if (colorMapper[0] != null) {
                this.radarChartCellModel.setFillMapper(colorMapper[0]);
            }
            if (colorMapper[1] != null) {
                this.radarChartCellModel.setLineColorMapper(colorMapper[1]);
            }
        }
        RadarChartMatrix.applyLineAttributes(this.radarChartCellModel, dataElementStyles.getLineStyles(), dataSource.getVariable(chartMatrixModel.getSubgroupRole(), 0));
        this.cellList = this.addMatrixCellComponents(new RadarCellFactory(), this.radarChartCellModel, new DataSource[]{dataSource});
        ListIterator iter = this.cellList.listIterator();
        Dimension curSize = new Dimension(0, 0);
        int bigWidth = 0;
        int bigHeight = 0;
        while (iter.hasNext()) {
            curCell = (RadarChartCell)iter.next();
            curSize = curCell.getIndividualPreferredSize();
            if (curSize.getWidth() > (double)bigWidth) {
                bigWidth = (int)curSize.getWidth();
            }
            if (!(curSize.getHeight() > (double)bigHeight)) continue;
            bigHeight = (int)curSize.getHeight();
        }
        this.radarChartCellModel.setPreferredSize(new Dimension(bigWidth, bigHeight));
        double max = 0.0;
        for (i = 0; i < numCategories; ++i) {
            iter = this.cellList.listIterator();
            while (iter.hasNext()) {
                curCell = (RadarChartCell)iter.next();
                try {
                    max = Math.max(max, curCell.getResponseAxisRangeMax(categories.getValue(i)));
                }
                catch (MissingValueException e) {
                    max = Math.max(max, curCell.getResponseAxisRangeMax(e.getMissingValue().toString()));
                }
                try {
                    rangeMax[i] = Math.max(rangeMax[i], curCell.getResponseAxisRangeMax(categories.getValue(i)));
                }
                catch (MissingValueException e) {
                    rangeMax[i] = Math.max(rangeMax[i], curCell.getResponseAxisRangeMax(e.getMissingValue().toString()));
                }
            }
        }
        for (i = 0; i < numCategories; ++i) {
            Channel channel = this.getChannel();
            Util.updateChannel(channel, 1, 1);
            if (!uniformAxes) {
                dependentAxisMapper[i].setInputMax(rangeMax[i]);
            } else {
                dependentAxisMapper[i].setInputMax(max);
            }
            dependentAxisCellModel[i].computeParameters(this.getChannel());
        }
    }

    private static void applyLineAttributes(RadarChartCellModel radarChartCellModel, StrokeLineStyle[] lineStyles, Variable variable) {
        Integer[] thickness = new Integer[lineStyles.length];
        Integer[] pattern = new Integer[lineStyles.length];
        Integer[] factor = new Integer[lineStyles.length];
        for (int i = 0; i < lineStyles.length; ++i) {
            GTKUtil.LineAttributes lineAttributes = GTKUtil.getLineAttributes(lineStyles[i]);
            thickness[i] = new Integer(lineAttributes.lineWidth);
            pattern[i] = new Integer(lineAttributes.stipplePattern);
            factor[i] = new Integer(lineAttributes.stippleFactor);
        }
        radarChartCellModel.setLineThicknessMapper(GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper(variable, thickness));
        radarChartCellModel.setLineStipplePatternMapper(GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper(variable, pattern));
        radarChartCellModel.setLineStippleFactorMapper(GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper(variable, factor));
    }

    private static void createCustomMarkers(StrokeLineStyle[] lineStyles, FillStyle[] fillStyles, StringVariable variable, LegendCell legendCell, int fillMarker) {
        if (variable != null) {
            int count = variable.getUniqueValueCount();
            Integer[] markers = new Integer[count];
            Channel channel = legendCell.getJLegendChannel();
            for (int i = 0; i < count; ++i) {
                StrokeLineStyle ls = Util.newCycledLineStyle(lineStyles, null, i);
                GTKUtil.LineAttributes la = GTKUtil.getLineAttributes(lineStyles[i]);
                markers[i] = new Integer(channel.addCustomMarker((CustomMarkerInterface)new CustomMarker(channel, fillMarker, la.stipplePattern, la.stippleFactor, ls.getColor())));
            }
            StringToNumberMapper snm = GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper((Variable)variable, markers);
            snm.setLabelMissingValues(true);
            legendCell.setMarkerMapper(snm);
        }
    }

    private ColorMapper[] _addLegend(DataSource ds, RadarChartMatrixModel matrixModel, RadarChartModel graphModel) {
        DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
        int radarType = this.model.getRadarChartModel().getRadarType();
        if (ds == null || dataElementStyles == null || dataElementStyles.getFillStyles() == null || dataElementStyles.getFillStyles().length < 1) {
            return null;
        }
        ColorMapper[] colorMapper = new ColorMapper[2];
        Variable subgroupVariable = ds.getVariable(matrixModel.getSubgroupRole(), 0);
        NumericVariable responseVariable = (NumericVariable)ds.getVariable(matrixModel.getResponseRole(), 0);
        LineStyle markerOutline = dataElementStyles.getOutlineLineStyle();
        if (markerOutline.getVisibilityPolicy() == 10202) {
            markerOutline = new LineStyle();
            markerOutline.setColor(new Color(0, true));
        }
        LegendCellModel lcm = null;
        if (radarType == 10906) {
            double min = responseVariable.getMin();
            double max = responseVariable.getMax();
            double mid = (min + max) / 2.0;
            double[] rangeValues = new double[]{min, mid, max};
            Color[] colors = new Color[]{dataElementStyles.getContinuousFillThreeColorStartColor(), dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
            ContinuousRangeToColorMapper continuousRangeToColorMapper = new ContinuousRangeToColorMapper();
            continuousRangeToColorMapper.input.connectFrom(responseVariable.value);
            continuousRangeToColorMapper.setColorSpectrumColors(colors);
            continuousRangeToColorMapper.setColorSpectrumValues(rangeValues);
            continuousRangeToColorMapper.setMissingReplacement(dataElementStyles.getMissingFillStyle().getSolidFillColor());
            continuousRangeToColorMapper.setReplaceMissingValues(true);
            continuousRangeToColorMapper.setLabelMissingValues(true);
            colorMapper[0] = continuousRangeToColorMapper;
            lcm = new ColorRampLegendCellModel();
            lcm.setDefaultLabel(responseVariable.getLabel());
            ((ColorRampLegendCellModel)lcm).setLowValue(new Double(responseVariable.getMin()));
            ((ColorRampLegendCellModel)lcm).setHighValue(new Double(responseVariable.getMax()));
            ((ColorRampLegendCellModel)lcm).setColors(colors);
            ((ColorRampLegendCellModel)lcm).setValueFormat(responseVariable.getFormat());
        } else if (subgroupVariable != null) {
            colorMapper[0] = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(subgroupVariable, dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors());
            colorMapper[1] = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(subgroupVariable, dataElementStyles.getLineStyles(), null);
            lcm = new LegendCellModel();
            lcm.setDefaultLabel(subgroupVariable.getLabel());
        } else {
            return null;
        }
        colorMapper[0].init(new AInitAction());
        if (colorMapper[1] != null) {
            colorMapper[1].init(new AInitAction());
        }
        lcm.setAntialiasedText(new Boolean(graphModel.isAntialiasedText()));
        lcm.setAntialiasedGraphics(new Boolean(graphModel.isAntialiasedGraphics()));
        lcm.setColorMapper(colorMapper[0]);
        lcm.setLegendModel(graphModel.getColorLegendModel());
        lcm.setMarkerOutlineLineStyle(markerOutline);
        lcm.setTitleMarker(this.drillMarker);
        int placement = graphModel.getColorLegendModel().getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
        lcm.setPlacement(new Integer(placement));
        this.colorLegend = new LegendCell(lcm, this.getChannel());
        if (graphModel.isLineEnabled()) {
            RadarChartMatrix.createCustomMarkers(dataElementStyles.getLineStyles(), dataElementStyles.getFillStyles(), (StringVariable)subgroupVariable, this.colorLegend, graphModel.isFillEnabled() ? 19 : -1);
        }
        this.addLegend(this.colorLegend, graphModel.getColorLegendModel().getPlacement());
        return colorMapper;
    }

    @Override
    protected List getCells() {
        return this.cellList;
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.removeAll();
        }
        this.cellList = null;
        this.colorLegend = null;
    }

    @Override
    protected ArrayList addMatrixCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource) {
        Container parent;
        if (this.matrixContainer != null) {
            this.remove(this.matrixContainer);
        }
        ArrayList<Component> cells = new ArrayList<Component>();
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        RadarChartMatrixModel radarChartMatrixModel = (RadarChartMatrixModel)this.getMatrixModel();
        this.matrixContainer = new RadarChartMatrixContainer(radarChartMatrixModel, dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), new RadarChartCellComponentFactory(this.radarChartCellModel, dataSource[0]), actionProvider, false, this.graphModel.isAntialiasedGraphics(), this.graphModel.isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    private class RadarChartCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final DataSource dataSource;
        private final RadarChartCellModel cellModel;

        public RadarChartCellComponentFactory(RadarChartCellModel cellModel, DataSource dataSource) {
            if (cellModel == null) {
                throw new IllegalStateException("null RadarChartCellModel not supported.");
            }
            this.cellModel = cellModel;
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            this.dataSource = dataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode));
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                return new RadarChartCell(this.cellModel, cellDataSource, RadarChartMatrix.this.getChannel());
            }
            return null;
        }
    }

    private static class RadarCellFactory
    implements Matrix.CellFactoryInterface {
        private RadarCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            return dataSource != null && dataSource.length > 0 ? new RadarChartCell((RadarChartCellModel)cellModel, dataSource[0], channel) : null;
        }
    }
}

