/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.piechart;

import com.sas.MissingValues;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DiscreteStyle;
import com.sas.graphics.components.DiscreteStyleMapModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ScrollModelInterface;
import com.sas.graphics.components.ValueZone;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.piechart.PieChartModel;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.DrilldownMarker;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalLegendCell;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.piechart.PieChartCell;
import com.sas.graphics.util.cell.piechart.PieChartCellModel;
import com.sas.graphics.util.cell.piechart.PieChartMatrixContainer;
import com.sas.graphics.util.cell.piechart.PieChartMatrixModel;
import com.sas.graphics.util.cell.scatterplot.BIPMarkerSkinFactory;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.InitAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class PieChartMatrix
extends Matrix {
    private transient ArrayList cells;
    private transient LegendCell categoryLegend;
    private transient DrilldownMarker drillMarker = new DrilldownMarker();
    private ValueTree categoryValueTree;
    private HierarchicalLegendCell hierarchicalLegend;
    private PieChartCellModel pieChartCellModel;
    private PieChartMatrixContainer matrixContainer;
    private boolean otherVisible;
    private boolean consistantFontSizes = true;
    private boolean consistantRadius = true;
    private transient PieChartMatrixModel model;

    public PieChartMatrix(Channel channel) {
        this(null, channel);
    }

    public PieChartMatrix(PieChartMatrixModel model, Channel channel) {
        super(channel);
        this._setModel(model);
    }

    public void setModel(PieChartMatrixModel newModel) {
        this._setModel(newModel);
    }

    private void _setModel(PieChartMatrixModel newModel) {
        if (this.model != newModel) {
            this.model = newModel;
            this.reconstruct();
        }
    }

    public PieChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        this.cells = null;
        this.categoryLegend = null;
        this.hierarchicalLegend = null;
    }

    @Override
    protected synchronized void construct() {
        String s;
        int ii;
        int rr;
        int numSubgroups;
        DataSource dataSource;
        PieChartMatrixModel chartMatrixModel = this.getModel();
        if (chartMatrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        if (chartMatrixModel.getPieChartModel() != null) {
            this.setAntialiasedTextEnabled(chartMatrixModel.getPieChartModel().isAntialiasedText());
        }
        if ((dataSource = this.getDataSource()) == null) {
            return;
        }
        Variable categoryVariable = dataSource.getVariable(chartMatrixModel.getCategoryRole(), 0);
        if (categoryVariable == null) {
            throw new IllegalStateException(RB.getStringResource("categoryVariableNotSpecified.ex.txt"));
        }
        if (categoryVariable.getValueCount() < 1) {
            return;
        }
        Variable[] responseVtkVars = dataSource.getVariable(chartMatrixModel.getResponseRole());
        boolean validResponse = responseVtkVars != null;
        for (int ii2 = 0; validResponse && ii2 < responseVtkVars.length; ++ii2) {
            validResponse = responseVtkVars[ii2] instanceof NumericVariable;
        }
        if (!validResponse) {
            throw new IllegalStateException(RB.getStringResource("invalidResponseVariableSpecified.ex.txt"));
        }
        chartMatrixModel.setRowModel(chartMatrixModel.getPieChartModel().getRowAxisModel());
        chartMatrixModel.setColumnModel(chartMatrixModel.getPieChartModel().getColumnAxisModel());
        boolean DEBUG = false;
        StringVariable rowVtkVar = (StringVariable)dataSource.getVariable(chartMatrixModel.getRowRole(), 0);
        StringVariable columnVtkVar = (StringVariable)dataSource.getVariable(chartMatrixModel.getColumnRole(), 0);
        StringVariable categoryVtkVar = (StringVariable)dataSource.getVariable(chartMatrixModel.getCategoryRole(), 0);
        StringVariable subgroupVtkVar = (StringVariable)dataSource.getVariable(chartMatrixModel.getSubgroupRole(), 0);
        StringVariable styleByVtkVar = (StringVariable)dataSource.getVariable(chartMatrixModel.getStyleByRole(), 0);
        int nn = categoryVtkVar.getValueCount();
        int numRows = rowVtkVar != null ? rowVtkVar.getUniqueValueCount() : 0;
        int numColumns = columnVtkVar != null ? columnVtkVar.getUniqueValueCount() : 0;
        int numCategories = categoryVtkVar != null ? categoryVtkVar.getUniqueValueCount() : 0;
        int n = numSubgroups = subgroupVtkVar != null ? subgroupVtkVar.getUniqueValueCount() : 0;
        if (numSubgroups <= 1) {
            for (int curRow = 0; curRow < numRows; ++curRow) {
                if (DEBUG) {
                    try {
                        System.out.println("row: " + rowVtkVar.formattedUniqueValue.getValue(curRow));
                    }
                    catch (MissingValueException e) {
                        System.out.println("row: --Missing--");
                    }
                }
                for (int curColumn = 0; curColumn < numColumns; ++curColumn) {
                    if (DEBUG) {
                        try {
                            System.out.println("col: " + columnVtkVar.formattedUniqueValue.getValue(curColumn));
                        }
                        catch (MissingValueException e) {
                            System.out.println("col: --Missing--");
                        }
                    }
                    for (int curCategory = 0; curCategory < numCategories; ++curCategory) {
                        if (!DEBUG) continue;
                        try {
                            NumericVariable resp = (NumericVariable)responseVtkVars[0];
                            System.out.println("category: " + categoryVtkVar.formattedUniqueValue.getValue(curCategory) + " : " + resp.formattedValue.getValue(curCategory));
                            continue;
                        }
                        catch (MissingValueException e) {
                            System.out.println("category: --Missing--");
                        }
                    }
                }
            }
        }
        this.pieChartCellModel = new PieChartCellModel();
        this.pieChartCellModel.setAnimationKeyFrameRole(chartMatrixModel.getAnimationKeyFrameRole());
        this.pieChartCellModel.setCategoryRole(chartMatrixModel.getCategoryRole());
        this.pieChartCellModel.setStyleByRole(chartMatrixModel.getStyleByRole());
        this.pieChartCellModel.setSubgroupRole(chartMatrixModel.getSubgroupRole());
        this.pieChartCellModel.setResponseRole(chartMatrixModel.getResponseRole());
        this.pieChartCellModel.setSelectionRole(chartMatrixModel.getSelectionRole());
        this.pieChartCellModel.setAuxiliaryRole(chartMatrixModel.getAuxiliaryRole());
        this.pieChartCellModel.setDataTipRole(chartMatrixModel.getDataTipRole());
        this.pieChartCellModel.setPieChartModel(chartMatrixModel.getPieChartModel());
        this.pieChartCellModel.setRuleTargetIdentifier(chartMatrixModel.getRuleTargetIdentifier());
        this.pieChartCellModel.setTitleMarker(this.drillMarker);
        this.pieChartCellModel.setAntialiasedGraphics(new Boolean(chartMatrixModel.getPieChartModel().isAntialiasedGraphics()));
        this.pieChartCellModel.setAntialiasedText(new Boolean(chartMatrixModel.getPieChartModel().isAntialiasedText()));
        StringToColorMapper colorMapper = (StringToColorMapper)this._makeColorMapper(dataSource, chartMatrixModel, chartMatrixModel.getPieChartModel());
        if (colorMapper != null) {
            this.pieChartCellModel.setColorMapper((ColorMapper)colorMapper);
        }
        this.cells = this.addMatrixCellComponents(new PieCellFactory(), this.pieChartCellModel, new DataSource[]{dataSource});
        ListIterator iter = this.cells.listIterator();
        Dimension curSize = new Dimension(0, 0);
        int smallResponseLabelFontSize = Integer.MAX_VALUE;
        int smallSliceLabelFontSize = Integer.MAX_VALUE;
        int smallSubgroupLabelFontSize = Integer.MAX_VALUE;
        int smallSubgroupTitleFontSize = Integer.MAX_VALUE;
        double smallRadius = 2.147483647E9;
        int bigWidth = 0;
        int bigHeight = 0;
        StringToColorMap map = (StringToColorMap)colorMapper.getValueMap();
        map.removeAllStringPipes();
        colorMapper.input.disconnect();
        ArrayList allCategories = new ArrayList();
        Vector<String> everything = new Vector<String>();
        Vector<String> sortedEverything = new Vector<String>();
        String otherLabel = this.pieChartCellModel.getPieChartModel().getOtherSliceLabel();
        for (rr = 0; rr < responseVtkVars.length; ++rr) {
            responseVtkVars[rr].init();
        }
        block13: for (ii = 0; ii < categoryVtkVar.getValueCount(); ++ii) {
            s = GTKUtil.VariableAccess.getFormattedValue(categoryVtkVar, ii).trim();
            if (everything.contains(s)) continue;
            for (rr = 0; rr < responseVtkVars.length; ++rr) {
                try {
                    if (!(((NumericVariable)responseVtkVars[rr]).value.getValue(ii) > 0.0)) continue;
                    everything.addElement(s);
                    continue block13;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        everything.remove(otherLabel);
        everything.addElement(otherLabel);
        StringVariable ordered_styleByVtkVar = styleByVtkVar;
        NumericVariable nbv = dataSource.getBaseVariable(ordered_styleByVtkVar);
        if (nbv != null) {
            ordered_styleByVtkVar = GTKUtil.newStringVariableFromFormattedUniqueValues(nbv);
            ordered_styleByVtkVar.setLabel(nbv.getLabel());
            ordered_styleByVtkVar.init();
        }
        for (ii = 0; ii < ordered_styleByVtkVar.getUniqueValueCount(); ++ii) {
            s = GTKUtil.VariableAccess.getFormattedUniqueValue(ordered_styleByVtkVar, ii).trim();
            if (sortedEverything.contains(s) || !everything.contains(s)) continue;
            sortedEverything.addElement(s);
        }
        sortedEverything.remove(otherLabel);
        sortedEverything.addElement(otherLabel);
        while (iter.hasNext()) {
            PieChartCell curCell = (PieChartCell)iter.next();
            this.computeAllCategories(curCell, map, allCategories);
            curSize = curCell.getIndividualPreferredSize();
            if (curSize.getWidth() > (double)bigWidth) {
                bigWidth = (int)curSize.getWidth();
            }
            if (curSize.getHeight() > (double)bigHeight) {
                bigHeight = (int)curSize.getHeight();
            }
            smallResponseLabelFontSize = Math.min(smallResponseLabelFontSize, curCell.getMinimumScaledResponseLabelSize());
            smallSliceLabelFontSize = Math.min(smallSliceLabelFontSize, curCell.getMinimumScaledSliceLabelSize());
            smallSubgroupLabelFontSize = Math.min(smallSubgroupLabelFontSize, curCell.getMinimumScaledSubgroupLabelSize());
            smallSubgroupTitleFontSize = Math.min(smallSubgroupTitleFontSize, curCell.getMinimumScaledSubgroupTitleSize());
            smallRadius = Math.min(smallRadius, curCell.getMinimumRadius());
            curCell.setDefaultFormat();
        }
        if (dataSource.isRelationalData()) {
            DataElementStyles dataElementStyles = this.pieChartCellModel.getPieChartModel().getDataElementStyles();
            FillStyle[] fillStyles = dataElementStyles.getFillStyles();
            Color[] cycleColors = dataElementStyles.getDiscreteFillColors();
            DiscreteStyleMapModel styleMap = Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(dataSource, (Variable)styleByVtkVar, dataElementStyles.getDiscreteStyleMapModel());
            map.removeAll();
            for (int jj = 0; jj < sortedEverything.size(); ++jj) {
                String catValue = (String)sortedEverything.elementAt(jj);
                if (!allCategories.contains(catValue)) continue;
                if (catValue.equals(chartMatrixModel.getPieChartModel().getOtherSliceLabel()) && chartMatrixModel.getPieChartModel().getOtherColor() != null) {
                    map.add(chartMatrixModel.getPieChartModel().getOtherSliceLabel().trim(), chartMatrixModel.getPieChartModel().getOtherColor());
                    continue;
                }
                Color solidColor = PieChartMatrix._getColorOverride(styleMap, catValue);
                if (solidColor == null) {
                    solidColor = Util.newCycledFillStyle(fillStyles, cycleColors, jj).getSolidFillColor();
                }
                map.add(catValue, solidColor);
            }
        }
        this.otherVisible = allCategories.contains(otherLabel);
        this.categoryLegend = this._addLegend(dataSource, chartMatrixModel, chartMatrixModel.getPieChartModel(), (ColorMapper)colorMapper);
        if (this.consistantFontSizes) {
            // empty if block
        }
        if (this.consistantRadius) {
            // empty if block
        }
        this.pieChartCellModel.setPreferredSize(new Dimension(bigWidth, bigHeight));
    }

    private void computeAllCategories(PieChartCell cell, StringToColorMap map, List allCategories) {
        Variable keyFrameVariable = this.dataSource.getVariable(this.model.getAnimationKeyFrameRole(), 0);
        if (keyFrameVariable != null) {
            this.computeAllCategoriesAnimated(cell, map, allCategories, keyFrameVariable);
        } else {
            this.computeAllCategoriesNotAnimated(cell, map, allCategories, false);
        }
    }

    private void computeAllCategoriesNotAnimated(PieChartCell cell, StringToColorMap map, List allCategories, boolean animationInitRequired) {
        InitAction initAction = new InitAction(cell.getChannel());
        initAction.setAnimationInitRequired(animationInitRequired);
        StringPipe[] sp = cell.getCategoryPipes(map);
        for (int i = 0; i < sp.length; ++i) {
            initAction.pushValueCount();
            sp[i].init((AInitAction)initAction);
            int n = initAction.getValueCount();
            initAction.popValueCount();
            for (int j = 0; j < n; ++j) {
                try {
                    String s = sp[i].getValue(j).trim();
                    if (allCategories.contains(s)) continue;
                    allCategories.add(s);
                    continue;
                }
                catch (MissingValueException e) {
                    String ms = ValueMap.getDefaultMissingValueLabel((MissingValues)e.getMissingValue());
                    if (allCategories.contains(ms)) continue;
                    allCategories.add(ms);
                }
            }
        }
        initAction.setAnimationInitRequired(false);
    }

    private void computeAllCategoriesAnimated(PieChartCell cell, StringToColorMap map, List allCategories, Variable keyFrameVariable) {
        Variable connection = keyFrameVariable;
        int n = connection.getUniqueValueCount();
        for (int i = 0; i < n; ++i) {
            Object keyFrame;
            try {
                keyFrame = connection instanceof StringVariable ? ((StringVariable)connection).uniqueValue.getValue(i) : new Double(((NumericVariable)connection).uniqueValue.getValue(i));
            }
            catch (MissingValueException e) {
                keyFrame = e.getMissingValue();
            }
            AnimationPosition animationPosition = new AnimationPosition(keyFrame);
            cell.setAnimationFrame(animationPosition);
            this.computeAllCategoriesNotAnimated(cell, map, allCategories, true);
        }
    }

    private static Color _getColorOverride(DiscreteStyleMapModel styleMap, Object dataValue) {
        DiscreteStyle discreteStyle;
        if (styleMap != null && (discreteStyle = styleMap.get(dataValue)) != null && discreteStyle.getFillStyle() != null) {
            return discreteStyle.getFillStyle().getSolidFillColor();
        }
        return null;
    }

    private ColorMapper _makeColorMapper(DataSource ds, PieChartMatrixModel matrixModel, PieChartModel graphModel) {
        NumericVariable v;
        DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
        if (ds == null || dataElementStyles == null || dataElementStyles.getFillStyles() == null || dataElementStyles.getFillStyles().length < 1) {
            return null;
        }
        StringToColorMapper colorMapper = null;
        Variable styleByVariable = ds.getVariable(matrixModel.getStyleByRole(), 0);
        if (styleByVariable instanceof StringVariable && (v = this.dataSource.getBaseVariable((StringVariable)styleByVariable)) != null) {
            styleByVariable = GTKUtil.newStringVariableFromFormattedUniqueValues(v);
        }
        if (this.dataSource.isRelationalData()) {
            colorMapper = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(styleByVariable, dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors());
        } else {
            StringToColorMapper stcm = new StringToColorMapper();
            stcm.input.connectFrom(((StringVariable)styleByVariable).formattedValue);
            colorMapper = stcm;
        }
        return colorMapper;
    }

    private LegendCell _addLegend(DataSource ds, PieChartMatrixModel matrixModel, PieChartModel graphModel, ColorMapper colorMapper) {
        LegendCell lc = null;
        Variable variable = ds.getVariable(matrixModel.getCategoryRole(), 0);
        if (variable != null) {
            LegendCellModel lcm = new LegendCellModel(this.createMarkerSkinFactory());
            lcm.setAntialiasedGraphics(new Boolean(graphModel.isAntialiasedGraphics()));
            lcm.setAntialiasedText(new Boolean(graphModel.isAntialiasedText()));
            lcm.setColorMapper(colorMapper);
            lcm.setMarkerOutlineLineStyle(matrixModel.getPieChartModel().getDataElementStyles().getOutlineLineStyle());
            lcm.setDefaultLabel(variable.getLabel());
            int placement = graphModel.getLegendModel().getPlacement();
            if (placement == 10200) {
                placement = 5;
            }
            lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
            lcm.setPlacement(new Integer(placement));
            lcm.setLegendModel(graphModel.getLegendModel());
            lcm.setTitleMarker(this.drillMarker);
            if (this.dataSource.isRelationalData()) {
                lc = new LegendCell(lcm, this.getChannel());
                this.addLegend(lc, placement);
            } else {
                Container parent;
                DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
                SwingActionProvider actionProvider = null;
                for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
                }
                if (parent instanceof Graph) {
                    actionProvider = ((Graph)parent).getActionProvider();
                }
                Variable categoryVariable = this.dataSource.getVariable(this.model.getCategoryRole(), 0);
                FillStyle backgroundFillStyle = matrixModel.getPieChartModel().getLegendModel().getBackgroundFillStyle();
                Color backgroundColor = backgroundFillStyle.isVisible() ? backgroundFillStyle.getSolidFillColor() : null;
                ValuePane.MultiStyleValueComponentFactory valueComponentFactory = Util.createMultiStyleValueComponentFactory(this.getCategoryValueTree(), matrixModel.getPieChartModel().getLegendModel().getValueTextStyle(), dataElementStyles, true, false, false, this.dataSource.getDataSourceSelectionModel(), actionProvider, (StringVariable)categoryVariable, 1, this, backgroundColor, this.getChannel(), lcm.getSkinFactory());
                int vc = categoryVariable.getUniqueValueCount();
                for (int ii = 0; ii < vc; ++ii) {
                    String key = GTKUtil.VariableAccess.getFormattedUniqueValue((StringVariable)categoryVariable, ii);
                    FillStyle fillStyle = (FillStyle)valueComponentFactory.getFormattedValue2FillStyleMap().get(key);
                    if (fillStyle == null) continue;
                    ((StringToColorMapper)colorMapper).add(key, fillStyle.getSolidFillColor());
                }
                String otherLabel = this.pieChartCellModel.getPieChartModel().getOtherSliceLabel();
                Color otherColor = Util.newCycledFillStyle(dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors(), this.getCategoryValueTree().getRoot().getChildCount()).getSolidFillColor();
                ((StringToColorMapper)colorMapper).add(otherLabel, otherColor);
                this.hierarchicalLegend = new HierarchicalLegendCell(this.getCategoryValueTree(), lcm, valueComponentFactory, actionProvider, 2, this.otherVisible ? otherLabel : null, this.otherVisible ? otherColor : null, this.getChannel());
                lc = this.hierarchicalLegend;
                lc.setVisible(true);
                this.addLegend(this.hierarchicalLegend, placement);
            }
        }
        return lc;
    }

    public ChartImageMapInfo2[] getImageMapInfo() {
        int cellCount;
        if (this.getErrorMessage() != null) {
            return null;
        }
        ChartImageMapInfo2[] chartImageMapInfos = null;
        if (this.dataSource != null && this.dataSource.getValueCount() > 0 && this.model != null && this.cells != null && (cellCount = this.cells.size()) > 0) {
            ArrayList l = new ArrayList();
            this.addVariableListImageMapInfo(l);
            Util.addCellImageMapInfo(this.cells, l);
            this.addLegendImageMapInfo(l);
            this.addMatrixAxesImageMapInfo(l);
            chartImageMapInfos = ChartImageMapInfo2.listToArray(l);
        }
        return chartImageMapInfos;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    private void addMatrixAxesImageMapInfo(List imageMapInfoList) {
        if (this.matrixContainer != null) {
            imageMapInfoList.add(this.matrixContainer.getImageMapInfo());
        }
    }

    private void addVariableListImageMapInfo(List imageMapInfoList) {
        VariableList columnVariableList = Util.newVariablelist(this.dataSource, this.model.getColumnRole());
        VariableList rowVariableList = Util.newVariablelist(this.dataSource, this.model.getRowRole());
        VariableList categoryVariableList = Util.newVariablelist(this.dataSource, this.model.getCategoryRole());
        VariableList subgroupVariableList = Util.newVariablelist(this.dataSource, this.model.getSubgroupRole());
        VariableList responseVariableList = Util.newVariablelist(this.dataSource, this.model.getResponseRole());
        VariableList dataTipVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getDataTipRole());
        VariableList auxiliaryVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getAuxiliaryRole());
        imageMapInfoList.add(new ChartImageMapInfo2(columnVariableList, rowVariableList, categoryVariableList, subgroupVariableList, responseVariableList, null, dataTipVariableList, auxiliaryVariableList));
    }

    private void addLegendImageMapInfo(List imageMapInfoList) {
        Util.LabelAndValueZones labelAndValueZones;
        ValueZone[] legendValueZones;
        if (this.hierarchicalLegend != null) {
            imageMapInfoList.add(this.hierarchicalLegend.getImageMapInfo());
        } else if (this.categoryLegend != null && (legendValueZones = (labelAndValueZones = this.categoryLegend.getLabelAndValueZones()).getValueZones()) != null) {
            ChartValueZone[] categoryValueZones = new ChartValueZone[legendValueZones.length];
            for (int kk = 0; kk < legendValueZones.length; ++kk) {
                categoryValueZones[kk] = new ChartValueZone(legendValueZones[kk].getShape(), null, null, null, legendValueZones[kk].getValue());
            }
            ChartImageMapInfo2 tempInfo = new ChartImageMapInfo2(null, null, categoryValueZones, null, null, null, null, labelAndValueZones.getLabelZone(), null, null, null);
            tempInfo.source = this.categoryLegend;
            imageMapInfoList.add(tempInfo);
        }
    }

    protected ValueTree getCategoryValueTree() {
        this.createCategoryTree();
        return this.categoryValueTree;
    }

    public static String aggregateHierarchyLevelName(DataTreeGroupNode leaf) {
        if (leaf == null) {
            return "";
        }
        DataTreeGroupNode current = leaf;
        String label = "" + current.getFormattedValue();
        while (current.getParent() != null) {
            if ((current = (DataTreeGroupNode)current.getParent()).getFormattedValue() == null) continue;
            label = current.getFormattedValue() + ", " + label;
        }
        return label;
    }

    private void createCategoryTree() {
        try {
            ValueTree[] trees = ValueTree.createTrees(this.dataSource, ((PieChartMatrixModel)this.getMatrixModel()).getCategoryRole(), null);
            this.categoryValueTree = trees[0];
            String hideOtherCategories = System.getProperty("sas.graph.piehideothervalues");
            if (!"true".equalsIgnoreCase(hideOtherCategories)) {
                return;
            }
            this.categoryValueTree.getLeafNodes();
            TreeSet<String> allCategories = new TreeSet<String>();
            for (int i = 0; i < this.cells.size(); ++i) {
                PieChartCell cell = (PieChartCell)this.cells.get(i);
                allCategories.addAll(cell.getVisibleCategories());
            }
            Enumeration<TreeNode> childeren = this.categoryValueTree.getRoot().depthFirstEnumeration();
            try {
                while (childeren.hasMoreElements()) {
                    DataTreeGroupNode node = (DataTreeGroupNode)childeren.nextElement();
                    if (node == null || allCategories.contains(PieChartMatrix.aggregateHierarchyLevelName(node)) || node.getChildCount() != 0) continue;
                    ((DataTreeGroupNode)node.getParent()).remove((MutableTreeNode)node);
                    childeren = this.categoryValueTree.getRoot().depthFirstEnumeration();
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.cells != null) {
            for (int ii = 0; ii < this.cells.size(); ++ii) {
                ((PieChartCell)this.cells.get(ii)).setAnimationFrame(animationPosition);
            }
        }
    }

    @Override
    protected ArrayList addMatrixCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource) {
        Container parent;
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        ArrayList<Component> cells = new ArrayList<Component>();
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        PieChartMatrixModel pieChartMatrixModel = (PieChartMatrixModel)this.getMatrixModel();
        this.matrixContainer = new PieChartMatrixContainer(pieChartMatrixModel, dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), new PieChartCellComponentFactory(this.pieChartCellModel, dataSource[0]), this.getMessageModel(), actionProvider, false, this.graphModel.isAntialiasedGraphics(), this.graphModel.isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    @Override
    protected ArrayList addRowTabletCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        return null;
    }

    @Override
    public ScrollModelInterface getScrollModel() {
        return null;
    }

    @Override
    public void setAntialiasedTextEnabled(boolean b) {
    }

    @Override
    public void setMatrixCellOutlineLineStyle(LineStyle lineStyle) {
    }

    @Override
    public void setMatrixCellOutlineVisible(boolean b) {
    }

    @Override
    protected List getCells() {
        return this.cells;
    }

    private AbstractMarkerSkinFactory createMarkerSkinFactory() {
        int dimension = this.getModel().getPieChartModel().getDimension();
        return dimension == 10101 ? null : BIPMarkerSkinFactory.getInstance(this.getModel().getPieChartModel().getSkin());
    }

    private class PieChartCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final DataSource dataSource;
        private final PieChartCellModel cellModel;
        private final Object animationKeyFrameRole;
        private final Object animationIDRole;

        public PieChartCellComponentFactory(PieChartCellModel cellModel, DataSource dataSource) {
            if (cellModel == null) {
                throw new IllegalStateException("null PieChartCellModel not supported.");
            }
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            Variable[] animationKeyFrameVariables = dataSource.getVariable(cellModel.getAnimationKeyFrameRole());
            if (animationKeyFrameVariables == null) {
                this.animationKeyFrameRole = null;
                this.animationIDRole = null;
            } else {
                Variable subgroupVariable = dataSource.getVariable(cellModel.getSubgroupRole(), 0);
                this.animationKeyFrameRole = cellModel.getAnimationKeyFrameRole();
                this.animationIDRole = subgroupVariable != null ? cellModel.getSubgroupRole() : cellModel.getCategoryRole();
            }
            this.cellModel = cellModel;
            this.dataSource = dataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode));
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                if (this.animationKeyFrameRole != null && this.animationIDRole != null) {
                    cellDataSource = cellDataSource.newAnimationDataSource(this.animationKeyFrameRole, this.animationIDRole);
                }
                return new PieChartCell(this.cellModel, cellDataSource, columnNode, rowNode, PieChartMatrix.this.getChannel());
            }
            return null;
        }
    }

    private static class PieCellFactory
    implements Matrix.CellFactoryInterface,
    Matrix.CellFactoryInterface2 {
        private PieCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            if (dataSource != null && dataSource.length > 0) {
                return new PieChartCell((PieChartCellModel)cellModel, dataSource[0], null, null, channel);
            }
            return null;
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Matrix.MatrixInfo matrixInfo, Channel channel) {
            if (dataSource != null && dataSource.length > 0) {
                if (matrixInfo != null) {
                    return new PieChartCell((PieChartCellModel)cellModel, dataSource[0], matrixInfo.getColumnOrdinal(), matrixInfo.getRowOrdinal(), channel);
                }
                return new PieChartCell((PieChartCellModel)cellModel, dataSource[0], null, null, channel);
            }
            return null;
        }
    }
}

