/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.piechart;

import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.piechart.PieChartModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.piechart.PieChartCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.PieSelectDetail;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.Pie;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.pie.PieChartRenderer;
import com.sas.graphics.util.gtk.render.pie.PieChartRendererModel;
import com.sas.measures.Measure;
import com.sas.text.SASFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;

public class PieChartCell
extends Cell
implements ChartImageMapInfo.ChartImageMapInfoAuthorInterface {
    private static final DecimalFormat pctf = new DecimalFormat("##0%");
    public static final String RB_KEY = "PieChartCell.";
    protected final transient DataSource dataSource;
    protected final transient PieChartCellModel cellModel;
    private PieChartRenderer renderer;
    private final transient ValueList columnValueList;
    private final transient ValueList rowValueList;

    public PieChartCell(PieChartCellModel cellModel, DataSource dataSource, Object columnOrdinal, Object rowOrdinal, Channel channel) {
        super(cellModel, channel);
        this.cellModel = cellModel;
        this.setOpaque(false);
        this.dataSource = dataSource;
        this.setAntiAliasingEnabled(cellModel.getPieChartModel().isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(cellModel.getPieChartModel().isAntialiasedText());
        this.setSelectionModel(dataSource.getDataSourceSelectionModel());
        this.columnValueList = Util.DataTreeGroupNodeUtil.toValueList(columnOrdinal);
        this.rowValueList = Util.DataTreeGroupNodeUtil.toValueList(rowOrdinal);
        this.createSelectionNetworkRoot(dataSource.getDataSourceSelectionModel());
        this.renderer = new PieChartRenderer(this.createRendererModel(), (JComponent)this, this.getNetworkRoot(), this.getComposite(), this.getChannel(), (StringToColorMapper)cellModel.getColorMapper());
    }

    private PieChartRendererModel createRendererModel() {
        PieChartRendererModel model = new PieChartRendererModel();
        this.fillRendererModel(model);
        return model;
    }

    private PieChartRendererModel fillRendererModel(PieChartRendererModel rendererModel) {
        PieChartModel pieChartModel = this.cellModel.getPieChartModel();
        rendererModel.setAcross(pieChartModel.getAcross());
        rendererModel.set2D(pieChartModel.getDimension() == 10100);
        rendererModel.setDonutHoleLabel(pieChartModel.getDonutHoleLabel());
        rendererModel.setDonutHoleSize(pieChartModel.getDonutHoleSize());
        rendererModel.setDown(pieChartModel.getDown());
        ArrayList<String> expCategories = new ArrayList<String>();
        for (int i = 0; i < pieChartModel.getExplodedCategories().length; ++i) {
            expCategories.add(pieChartModel.getExplodedCategories()[i]);
        }
        if (expCategories.contains(pieChartModel.getOtherSliceLabel())) {
            expCategories.remove(pieChartModel.getOtherSliceLabel());
            rendererModel.setExplodeOtherSlice(true);
        }
        rendererModel.setExplodedCategories(expCategories.toArray(new String[expCategories.size()]));
        rendererModel.setHighlightFillColor(pieChartModel.getBrushModel().getSelectionColor());
        rendererModel.setHighlightEdgeColor(pieChartModel.getBrushModel().getSelectionAccentColor());
        rendererModel.setInvisibleCategories(pieChartModel.getInvisibleCategories());
        rendererModel.setOtherColor(pieChartModel.getOtherColor());
        rendererModel.setOtherSliceLabel(pieChartModel.getOtherSliceLabel());
        rendererModel.setOtherThreshold((Measure)pieChartModel.getOtherThreshold());
        rendererModel.setSubgroupStacked(pieChartModel.getStackRole() != 1);
        rendererModel.setInsideSliceLabelContent(GTKUtil.getDataLabel(pieChartModel.getInsideSliceLabelContent()));
        rendererModel.setOutsideSliceLabelContent(GTKUtil.getDataLabel(pieChartModel.getOutsideSliceLabelContent()));
        int placement = pieChartModel.getInsideSliceLabelPlacement();
        switch (placement) {
            case 11310: {
                rendererModel.setInsideSliceLabelPlacement(RendererUtil.Placement.BEST);
                break;
            }
            default: {
                rendererModel.setInsideSliceLabelPlacement(RendererUtil.Placement.DEFAULT);
            }
        }
        placement = pieChartModel.getOutsideSliceLabelPlacement();
        switch (placement) {
            case 11309: {
                rendererModel.setOutsideSliceLabelPlacement(RendererUtil.Placement.ARROW);
                break;
            }
            default: {
                rendererModel.setOutsideSliceLabelPlacement(RendererUtil.Placement.DEFAULT);
            }
        }
        int visibility = pieChartModel.getResponseLabelVisiblePolicy();
        Variable[] responseVariableArray = this.dataSource.getVariable(this.cellModel.getResponseRole());
        boolean responseVisible = 10201 == visibility || 10200 == visibility && responseVariableArray.length > 1 || 10200 == visibility && !rendererModel.isSubgroupStacked();
        rendererModel.setResponseLabelVisible(responseVisible);
        switch (pieChartModel.getSkin()) {
            case 12302: {
                rendererModel.setSkin(RendererUtil.Skin.MODERN);
                break;
            }
            case 12301: {
                rendererModel.setSkin(RendererUtil.Skin.SATIN);
                break;
            }
            case 12300: {
                rendererModel.setSkin(RendererUtil.Skin.NONE);
                break;
            }
        }
        switch (pieChartModel.getSliceOrder()) {
            case 10401: {
                rendererModel.setSliceOrder(RendererUtil.Sort.ASCENDING);
                break;
            }
            case 10402: {
                rendererModel.setSliceOrder(RendererUtil.Sort.DESCENDING);
                break;
            }
            case 10400: {
                rendererModel.setSliceOrder(RendererUtil.Sort.NONE);
            }
        }
        rendererModel.setStartAngle(pieChartModel.getStartAngle());
        RendererUtil.DataLabel subGrpPlacement = GTKUtil.getDataLabel(pieChartModel.getSubgroupLabelModel().getPlacement());
        rendererModel.setSubgroupLabelPlacement(subGrpPlacement);
        rendererModel.setAntialiasedGraphics(this.cellModel.getAntialiasedGraphics().booleanValue());
        rendererModel.setAntialiasedText(this.cellModel.getAntialiasedText().booleanValue());
        rendererModel.setReverseDirection(pieChartModel.isReverseDirection());
        rendererModel.setSubgroupLabelDrillIconVisible(pieChartModel.getSubgroupLabelModel().isDrillIconVisible());
        rendererModel.setFixedRadius(this.cellModel.getFixedRadius());
        rendererModel.setFixedResponseLabelFontSize(this.cellModel.getFixedResponseLabelFontSize());
        rendererModel.setFixedSliceLabelFontSize(this.cellModel.getFixedSliceLabelFontSize());
        rendererModel.setFixedSubgroupLabelFontSize(this.cellModel.getFixedSubgroupLabelFontSize());
        rendererModel.setFixedSubgroupTitleFontSize(this.cellModel.getFixedSubgroupTitleFontSize());
        rendererModel.setRuleTargetIdentifier(this.cellModel.getRuleTargetIdentifier());
        rendererModel.setTitleMarker((CustomMarkerInterface)this.cellModel.getTitleMarker());
        rendererModel.setTitleMarkerSize(this.cellModel.getTitleMarker().getSize());
        rendererModel.setCategoryVariable((StringVariable)this.dataSource.getVariable(this.cellModel.getCategoryRole(), 0));
        rendererModel.setResponseVariableArray(responseVariableArray);
        rendererModel.setSelectionVariableArray(this.dataSource.getVariable(this.cellModel.getSelectionRole()));
        rendererModel.setSubgroupVariable((StringVariable)this.dataSource.getVariable(this.cellModel.getSubgroupRole(), 0));
        rendererModel.setSelectedPercentageVariable(this.dataSource.getSelectedPercentageVariable());
        FillStyle fillStyle = pieChartModel.getDataElementStyles().getFillStyles()[0];
        int fillType = fillStyle.getFillType();
        boolean imageFillEnabled = fillStyle.getImageIcon() != null && fillStyle.getImageIcon().getImage() != null && (fillType == 20002 || fillType == 20003 || fillType == 20004);
        rendererModel.setImageFillEnabled(imageFillEnabled);
        if (imageFillEnabled) {
            rendererModel.setFillImage(fillStyle.getImageIcon().getImage());
        }
        rendererModel.setOutlineLineStyle(GTKUtil.convertToGTKLineStyle(pieChartModel.getDataElementStyles().getOutlineLineStyle()));
        rendererModel.setDonutHoleLabelTextStyle(GTKUtil.mapAdvancedTextStyleToGTKTextStyle(pieChartModel.getDonutHoleLabelTextStyle()));
        rendererModel.setInsideSliceLabelTextStyle(GTKUtil.mapAdvancedTextStyleToGTKTextStyle(pieChartModel.getInsideSliceLabelTextStyle()));
        rendererModel.setOutsideSliceLabelTextStyle(GTKUtil.mapAdvancedTextStyleToGTKTextStyle(pieChartModel.getOutsideSliceLabelTextStyle()));
        rendererModel.setResponseLabelTextStyle(GTKUtil.mapAdvancedTextStyleToGTKTextStyle(pieChartModel.getResponseLabelTextStyle()));
        rendererModel.setSubgroupLabelTextStyle(GTKUtil.mapToGTKTextStyle(pieChartModel.getSubgroupLabelModel().getLabelTextStyle()));
        rendererModel.setSubgroupLabelValueTextStyle(GTKUtil.mapToGTKTextStyle(pieChartModel.getSubgroupLabelModel().getValueTextStyle()));
        rendererModel.setInsideSliceLabelTextStyleVisible(pieChartModel.getInsideSliceLabelTextStyle().isVisible());
        rendererModel.setOutsideSliceLabelTextStyleVisible(pieChartModel.getOutsideSliceLabelTextStyle().isVisible());
        rendererModel.setResponseLabelTextStyleVisible(pieChartModel.getResponseLabelTextStyle().isVisible());
        rendererModel.setPercentFormat(pctf);
        return rendererModel;
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.dataSource.isAnimationEnabled() && this.dataSource.setAnimationPosition(animationPosition)) {
            this.repaint();
        }
    }

    @Override
    protected synchronized void construct() {
        this.fillRendererModel(this.renderer.getModel());
        this.renderer.construct();
    }

    @Override
    protected PickInfo[] select(int x, int y, int w, int h, boolean isControlDown, boolean isSelectClosest, boolean isModified) {
        if (this.getSelectRoot() != null) {
            if (this.getSelectionModel() != null) {
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                if (w > 0 && h > 0) {
                    Vector v;
                    this.updateChannel();
                    int ax = x + (w > 1 ? 1 : 0);
                    int ay = y + (h > 1 ? 1 : 0);
                    int aw = Math.max(1, w - 2);
                    int ah = Math.max(1, h - 2);
                    if (isSelectClosest) {
                        v = new Vector();
                        v.add(this.getSelectRoot().selectClosest(ax, ay, aw, ah));
                    } else {
                        v = this.getSelectRoot().select(ax, ay, aw, ah, true, true);
                    }
                    if (v != null && v.size() > 0) {
                        int[] o = new int[1];
                        int size = v.size();
                        for (int ii = 0; ii < size; ++ii) {
                            PieSelectDetail psd;
                            SelectResult sr = (SelectResult)v.get(ii);
                            if (sr == null || !(sr.getElement() instanceof Pie) || (psd = (PieSelectDetail)sr.getDetail()) == null || psd.getType() != 0) continue;
                            o = psd.getOriginalValueIndices();
                            for (int i = 0; i < o.length; ++i) {
                                if (listSelectionModel instanceof DataSource.DataSourceListSelectionModel) {
                                    Util.SelectInfo selectInfo;
                                    String variableName = null;
                                    if (sr.getElement().getUserData() instanceof Util.SelectInfo && (selectInfo = (Util.SelectInfo)sr.getElement().getUserData()) != null && selectInfo.userData instanceof Variable) {
                                        variableName = ((Variable)selectInfo.userData).getName();
                                    }
                                    isModified = this.select(o[i], variableName, isControlDown, isSelectClosest, isModified);
                                    continue;
                                }
                                isModified = this.select(o[i], isControlDown, isSelectClosest, isModified);
                            }
                        }
                        return this.selectResultsToPickInfoArray(v, x, y);
                    }
                    this.repaint();
                }
            }
            return null;
        }
        return null;
    }

    public void setDefaultFormat() {
        this.renderer.setDefaultFormat(this.dataSource.getLocale());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = this.cellModel.getPreferredSize();
        return pref == null ? new Dimension(0, 0) : pref;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.renderer.getMinimumSize();
    }

    public Dimension getIndividualPreferredSize() {
        if (this.dataSource == null) {
            return super.getPreferredSize();
        }
        if (this.cellModel == null) {
            return super.getPreferredSize();
        }
        return this.renderer.getIndividualPreferredSize();
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        if (this.renderer.getModel().is3D()) {
            this.renderer.updateChannel((Component)this);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Channel c = this.renderer.getChannel();
        if (this.renderer.getModel().is2D()) {
            super.paintComponent(g);
        } else {
            this.updateChannel();
            if (g instanceof Graphics2D) {
                if (this.isAntiAliasingEnabled()) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (this.isTextAntiAliasingEnabled()) {
                    this.renderer.getChannel().glEnable(14);
                }
            }
            c.setSingleBufferGraphics(g);
            this.renderer.getNetworkRoot().build();
            c.glCallList(this.renderer.getNetworkRoot().getRootListName());
        }
    }

    @Override
    public PickInfo pick(int x, int y) {
        if (this.renderer.getModel().is2D()) {
            return super.pick(x, y);
        }
        NetworkRoot selectRoot = this.getSelectRoot();
        if (selectRoot != null) {
            this.updateChannel();
            SelectResult sr = selectRoot.selectClosest(x, y, 1, 1, false);
            return sr != null ? this.createPickInfo(x, y, sr) : null;
        }
        return null;
    }

    protected int getMinimumScaledResponseLabelSize() {
        return this.renderer.getMinimumScaledSliceLabelSize();
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected int getMinimumScaledSliceLabelSize() {
        return this.renderer.getMinimumScaledSliceLabelSize();
    }

    protected int getMinimumScaledSubgroupLabelSize() {
        return this.renderer.getMinimumScaledSubgroupLabelSize();
    }

    protected int getMinimumScaledSubgroupTitleSize() {
        return this.renderer.getMinimumScaledSubgroupTitleSize();
    }

    protected double getMinimumRadius() {
        return this.renderer.getMinimumRadius();
    }

    public StringPipe[] getCategoryPipes(StringToColorMap map) {
        return this.renderer.getCategoryPipes(map);
    }

    public int getCategoryUniqueValueCount() {
        return this.renderer.getCategoryUniqueValueCount();
    }

    @Override
    public ChartImageMapInfo getChartImageMapInfo() {
        if (this.dataSource.getValueCount() < 1) {
            return null;
        }
        boolean stackSubgroup = this.renderer.getModel().isSubgroupStacked();
        this.updateChannel();
        Vector selectableShapes = this.getNetworkRoot().computeSelectableShapes();
        if (selectableShapes != null) {
            int count = selectableShapes.size();
            ArrayList<ChartValueZone> dataElementValueZonesAL = new ArrayList<ChartValueZone>(count);
            ArrayList<Object> subgroupValueZonesAL = null;
            StringVariable subgroupVariable = (StringVariable)this.dataSource.getVariable(this.cellModel.getSubgroupRole(), 0);
            Variable[] responseVariableArray = this.dataSource.getVariable(this.cellModel.getResponseRole());
            subgroupValueZonesAL = stackSubgroup && subgroupVariable != null ? new ArrayList(subgroupVariable.getUniqueValueCount()) : (!stackSubgroup && responseVariableArray.length > 1 ? new ArrayList(responseVariableArray.length) : new ArrayList<ChartValueZone>(1));
            LabelZoneList subgroupLabelZoneList = null;
            LabelZoneList responseLabelZoneList = null;
            block10: for (int ii = 0; ii < count; ++ii) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
                SelectResult sr = selectableShape.getSelectResult();
                Element element = sr.getElement();
                if (!(element instanceof Pie) || selectableShape == null || selectableShape.getShape() == null) continue;
                Pie pieElement = (Pie)element;
                PieSelectDetail psd = (PieSelectDetail)sr.getDetail();
                if (psd == null) continue;
                switch (psd.getType()) {
                    case 0: {
                        int obsIndex = psd.getProcessedIndex();
                        ValueList categoryValueList = null;
                        StringVariable categoryVariable = (StringVariable)this.dataSource.getVariable(this.cellModel.getCategoryRole(), 0);
                        if (categoryVariable != null) {
                            Variable v = categoryVariable.getConnection();
                            if (v != null && v instanceof NumericVariable) {
                                NumericVariable numericCategory = (NumericVariable)v;
                                try {
                                    double val = numericCategory.value.getValue(obsIndex);
                                    String fv = numericCategory.formattedValue.getValue(obsIndex);
                                    categoryValueList = new ValueList(val, fv, null);
                                }
                                catch (MissingValueException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                categoryValueList = GTKUtil.toValueList(pieElement.processedCategory, (Variable)categoryVariable, obsIndex, null);
                            }
                        }
                        ValueList subgroupValueList = null;
                        if (subgroupVariable != null) {
                            Variable v = subgroupVariable.getConnection();
                            if (v != null && v instanceof NumericVariable) {
                                NumericVariable numericVar = (NumericVariable)v;
                                try {
                                    double val = numericVar.value.getValue(obsIndex);
                                    String fv = numericVar.formattedValue.getValue(obsIndex);
                                    subgroupValueList = new ValueList(val, fv, null);
                                }
                                catch (MissingValueException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                subgroupValueList = GTKUtil.toValueList(pieElement.processedSubgroup, (Variable)subgroupVariable, obsIndex, null);
                            }
                        }
                        ValueList responseValueList = this.newResponseValueList(pieElement, obsIndex);
                        Variable[] dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, this.cellModel.getDataTipRole());
                        Variable[] auxiliaryVariableArray = Util.getGTKVariableArray(this.dataSource, this.cellModel.getAuxiliaryRole());
                        ValueList dataTipValueList = GTKUtil.toValueList(dataTipVariableArray, obsIndex);
                        ValueList auxiliaryValueList = GTKUtil.toValueList(auxiliaryVariableArray, obsIndex);
                        ChartValueZone elementValueZone = new ChartValueZone(selectableShape.getShape(), this.columnValueList, this.rowValueList, categoryValueList, subgroupValueList, responseValueList, null, dataTipValueList, auxiliaryValueList);
                        dataElementValueZonesAL.add(elementValueZone);
                        continue block10;
                    }
                    case 4: {
                        String subgroupValue = psd.getSubgroupLabel();
                        ValueList subgroupValueList = null;
                        subgroupValueList = stackSubgroup ? (subgroupVariable == null ? null : new ValueList(subgroupValue, subgroupValue, null)) : new ValueList(subgroupValue, subgroupValue, null);
                        ChartValueZone elementValueZone = new ChartValueZone(selectableShape.getShape(), this.columnValueList, this.rowValueList, null, subgroupValueList, null, null);
                        subgroupValueZonesAL.add(elementValueZone);
                        continue block10;
                    }
                    case 2: {
                        if (!stackSubgroup || subgroupVariable == null) continue block10;
                        String columnName = subgroupVariable.getColumnName();
                        String label = subgroupVariable.getLabel();
                        subgroupLabelZoneList = new LabelZoneList(selectableShape.getShape().getBounds(), columnName, label, subgroupLabelZoneList);
                        continue block10;
                    }
                    case 3: {
                        String responseLabel = psd.getResponseLabel();
                        for (int jj = 0; jj < responseVariableArray.length; ++jj) {
                            if (!responseVariableArray[jj].getLabel().trim().equals(responseLabel.trim())) continue;
                            Variable thisResponse = responseVariableArray[jj];
                            String columnName = thisResponse.getColumnName();
                            String label = thisResponse.getLabel();
                            responseLabelZoneList = new LabelZoneList(selectableShape.getShape().getBounds(), columnName, label, responseLabelZoneList);
                            continue block10;
                        }
                        continue block10;
                    }
                }
            }
            ChartValueZone[] subgroupValueZones = subgroupVariable != null ? subgroupValueZonesAL.toArray(new ChartValueZone[0]) : null;
            ChartValueZone[] dataElementValueZones = dataElementValueZonesAL.toArray(new ChartValueZone[0]);
            ChartImageMapInfo2 pieChartImageMapInfo = new ChartImageMapInfo2(null, null, null, subgroupValueZones, dataElementValueZones, null, null, null, subgroupLabelZoneList, responseLabelZoneList, null);
            pieChartImageMapInfo.source = this;
            return pieChartImageMapInfo;
        }
        return null;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        if (obsIndex < 0) {
            return null;
        }
        Vector[] vector = this.getLabelValuePairs(obsIndex, this.renderer.getCurrentPie());
        return new PickInfo(vector, obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    @Override
    public PickInfo createPickInfo(int x, int y, SelectResult sr) {
        if (sr == null || !(sr.getElement() instanceof Pie)) {
            return null;
        }
        this.renderer.setCurrentPie((Pie)sr.getElement());
        PieSelectDetail psd = (PieSelectDetail)sr.getDetail();
        if (psd == null) {
            return null;
        }
        int i = psd.getProcessedIndex();
        return this.createPickInfo(x, y, i);
    }

    private Vector[] getLabelValuePairs(int processedIndex, Pie curPie) {
        Hashtable<String, Object> entry;
        Vector labelValuePairs = new Vector();
        AInitAction ia = new AInitAction((Object)this.renderer.getChannel());
        curPie.processedResponse.init(ia);
        curPie.processedCategory.init(ia);
        curPie.processedSubgroup.init(ia);
        Variable[] dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, this.cellModel.getDataTipRole());
        Variable[] responseVariableArray = this.renderer.getModel().getResponseVariableArray();
        StringVariable categoryVariable = this.renderer.getModel().getCategoryVariable();
        StringVariable subgroupVariable = this.renderer.getModel().getSubgroupVariable();
        int dataTipContent = this.cellModel.getPieChartModel().getDataTipModel().getContent();
        Boolean graphDataIsVisible = new Boolean(dataTipVariableArray == null || dataTipVariableArray.length <= 0 || dataTipVariableArray[0] == null || dataTipContent != 11401);
        if (responseVariableArray != null) {
            Object responseValue = null;
            String responseFormattedValue = null;
            try {
                responseValue = new Double(curPie.processedResponse.getValue(processedIndex));
            }
            catch (MissingValueException e) {
                responseValue = e.getMissingValue();
            }
            responseFormattedValue = this.getFormattedProcessedResponseValue(curPie, null, responseValue);
            Hashtable<String, Object> entry2 = new Hashtable<String, Object>();
            entry2.put(PickInfo.VISIBLE, graphDataIsVisible);
            entry2.put(PickInfo.ID, this.cellModel.getResponseRole());
            entry2.put(PickInfo.LABEL, this.getResponseLabel(curPie, processedIndex));
            entry2.put(PickInfo.VALUE, responseValue);
            entry2.put(PickInfo.FORMATTED_VALUE, responseFormattedValue);
            labelValuePairs.add(entry2);
        }
        if (categoryVariable != null) {
            StringPipe categoryFormattedValue = curPie.processedCategory;
            entry = new Hashtable<String, Object>();
            entry.put(PickInfo.VISIBLE, graphDataIsVisible);
            entry.put(PickInfo.ID, this.cellModel.getCategoryRole());
            entry.put(PickInfo.LABEL, categoryVariable.getLabel());
            try {
                entry.put(PickInfo.VALUE, categoryFormattedValue.getValue(processedIndex));
                entry.put(PickInfo.FORMATTED_VALUE, categoryFormattedValue.getFormatter().format((Object)categoryFormattedValue.getValue(processedIndex)));
            }
            catch (MissingValueException e) {
                entry.put(PickInfo.VALUE, e.getMissingValue());
                entry.put(PickInfo.FORMATTED_VALUE, categoryFormattedValue.getFormatter().format((Object)e.getMissingValue()));
            }
            labelValuePairs.add(entry);
        }
        if (subgroupVariable != null) {
            StringPipe subgroupFormattedValue = curPie.processedSubgroup;
            entry = new Hashtable();
            entry.put(PickInfo.VISIBLE, graphDataIsVisible);
            entry.put(PickInfo.ID, this.cellModel.getSubgroupRole());
            entry.put(PickInfo.LABEL, subgroupVariable.getLabel());
            try {
                entry.put(PickInfo.VALUE, subgroupFormattedValue.getValue(processedIndex));
                entry.put(PickInfo.FORMATTED_VALUE, subgroupFormattedValue.getFormatter().format((Object)subgroupFormattedValue.getValue(processedIndex)));
            }
            catch (MissingValueException e) {
                entry.put(PickInfo.VALUE, e.getMissingValue());
                entry.put(PickInfo.FORMATTED_VALUE, subgroupFormattedValue.getFormatter().format((Object)e.getMissingValue()));
            }
            labelValuePairs.add(entry);
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getDataTipRole(), dataTipVariableArray, processedIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getAuxiliaryRole(), Util.getGTKVariableArray(this.dataSource, this.cellModel.getAuxiliaryRole()), processedIndex, false);
        return new Vector[]{labelValuePairs};
    }

    private String getFormattedProcessedResponseValue(Pie pie, String fmtHash, Object value) {
        String fv = null;
        Formatter formatter = pie.processedResponse.getFormatter();
        HashMap respToFmtHash = this.renderer.getResponseToFmtHash();
        if (respToFmtHash != null && !respToFmtHash.isEmpty() && fmtHash != null && respToFmtHash.containsKey(fmtHash)) {
            formatter = new Formatter(new GTKFormat((Format)SASFormat.getInstance((String)((String)respToFmtHash.get(fmtHash)))));
        }
        fv = formatter.format(value);
        return fv;
    }

    private String getResponseLabel(Pie curPie, int index) {
        String result = null;
        if (this.renderer.isStackedResponse()) {
            result = (String)GTKUtil.PipeAccess.getValue(curPie.processedSubgroup, index);
        } else {
            Pie[] pieComponents = this.renderer.getPieComponents();
            if (pieComponents != null) {
                for (int i = 0; i < pieComponents.length; ++i) {
                    Pie pie = pieComponents[i];
                    if (pie != curPie) continue;
                    Variable[] responseVariableArray = this.dataSource.getVariable(this.cellModel.getResponseRole());
                    Variable v = responseVariableArray[i];
                    result = v.getLabel();
                }
            }
        }
        return result;
    }

    private ValueList newResponseValueList(Pie curPie, int index) {
        ValueList valueList;
        block5: {
            Pie[] myPie;
            block4: {
                valueList = null;
                myPie = this.renderer.getPieComponents();
                if (!this.renderer.isStackedResponse()) break block4;
                Pie pie = myPie[0];
                String responseName = (String)GTKUtil.PipeAccess.getValue(pie.processedSubgroup, index);
                Variable[] responseVariableArray = this.renderer.getModel().getResponseVariableArray();
                for (int i = responseVariableArray.length - 1; i >= 0; --i) {
                    Variable var = responseVariableArray[i];
                    if (responseName.equals(var.getLabel())) {
                        Object v = GTKUtil.PipeAccess.getValue(pie.processedResponse, index);
                        String fv = this.getFormattedProcessedResponseValue(pie, responseName, v);
                        valueList = new ValueList(v, fv, valueList);
                        continue;
                    }
                    valueList = new ValueList(null, null, valueList);
                }
                break block5;
            }
            if (myPie == null) break block5;
            for (int i = myPie.length - 1; i >= 0; --i) {
                Pie pie = myPie[i];
                if (pie == curPie) {
                    Object v = GTKUtil.PipeAccess.getValue(pie.processedResponse, index);
                    String fv = this.getFormattedProcessedResponseValue(pie, null, v);
                    valueList = new ValueList(v, fv, valueList);
                    continue;
                }
                valueList = new ValueList(null, null, valueList);
            }
        }
        return valueList;
    }

    public Set<String> getVisibleCategories() {
        Pie[] myPie = this.renderer.getPieComponents();
        TreeSet<String> categories = new TreeSet<String>();
        for (int i = 0; i < myPie.length; ++i) {
            List values = myPie[i].getVisibleCategories();
            categories.addAll(values);
        }
        return categories;
    }
}

