/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.pathanalysischart;

import com.sas.graphics.util.cell.pathanalysischart.Curve;
import com.sas.graphics.util.cell.pathanalysischart.LinkRenderer;
import com.sas.graphics.util.cell.pathanalysischart.Node;
import com.sas.graphics.util.cell.pathanalysischart.PathAnalysisChartCell;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

class Link {
    private PathAnalysisChartCell containingCell;
    private Node nodeF;
    private Node nodeT;
    private String typeF;
    private String typeT;
    private double volumeF;
    private double volumeT;
    private double positionF;
    private double positionT;
    private Color colorF;
    private Color colorT;
    private int rowIndex;

    private Link(PathAnalysisChartCell c, Node fn, String ft, double fv, Node tn, String tt, double tv) {
        this.containingCell = c;
        this.nodeF = fn;
        this.typeF = ft;
        this.volumeF = fv;
        this.nodeT = tn;
        this.typeT = tt;
        this.volumeT = tv;
        this.colorF = this.colorT = new Color(255, 230, 100, 100);
    }

    public Link(PathAnalysisChartCell c, Node fn, String ft, Node tn, String tt, double v) {
        this(c, fn, ft, v, tn, tt, v);
    }

    public Node getFromNode() {
        return this.nodeF;
    }

    public void setFromNode(Node n) {
        this.nodeF = n;
    }

    public String getFromType() {
        return this.typeF;
    }

    public void setFromType(String t) {
        this.typeF = t;
    }

    public double getFromVolume() {
        return this.volumeF;
    }

    public void setFromVolume(double v) {
        this.volumeF = v;
    }

    public double getFromPosition() {
        return this.positionF;
    }

    public void setFromPosition(double p) {
        this.positionF = p;
    }

    public Color getFromColor() {
        return this.colorF;
    }

    public void setFromColor(Color c) {
        this.colorF = c;
    }

    public Node getToNode() {
        return this.nodeT;
    }

    public void setToNode(Node n) {
        this.nodeT = n;
    }

    public String getToType() {
        return this.typeT;
    }

    public void setToType(String t) {
        this.typeT = t;
    }

    public double getToVolume() {
        return this.volumeT;
    }

    public void setToVolume(double v) {
        this.volumeT = v;
    }

    public double getToPosition() {
        return this.positionT;
    }

    public void setToPosition(double p) {
        this.positionT = p;
    }

    public Color getToColor() {
        return this.colorT;
    }

    public void setToColor(Color c) {
        this.colorT = c;
    }

    public void setRowIndex(int i) {
        this.rowIndex = i;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void paint(Graphics g) {
        Rectangle nb;
        Curve c = null;
        boolean aa = this.containingCell.getDisplayModel().isAntialiasedGraphics();
        double scale = this.containingCell.getScale();
        double sp = scale * this.positionF;
        double sw = scale * this.volumeF;
        double fp = scale * this.positionT;
        double fw = scale * this.volumeT;
        if (!aa) {
            sp = this.antialias(sp, aa);
            fp = this.antialias(fp, aa);
            sw = this.antialias(scale * this.positionF + scale * this.volumeF, aa) - sp;
            fw = this.antialias(scale * this.positionT + scale * this.volumeT, aa) - fp;
        }
        double f1y = 0.0;
        double f1x = 0.0;
        double f0y = 0.0;
        double f0x = 0.0;
        double s1y = 0.0;
        double s1x = 0.0;
        double s0y = 0.0;
        double s0x = 0.0;
        boolean fv = false;
        boolean sv = false;
        if (this.nodeF.getLevel() == -1) {
            nb = this.nodeT.getBounds();
            s0x = this.containingCell.getInflowX1();
            s0y = (double)(nb.y + this.nodeT.getBoxY() + this.nodeT.getBarY() - this.containingCell.getInflowMidHeight() + (int)(scale * this.containingCell.getLevelInflow(this.nodeT.getLevel()) / 2.0)) - sp;
            s1x = s0x;
            s1y = s0y - sw;
            sv = true;
            c = this.nodeT.getInflowCurve();
        } else {
            nb = this.nodeF.getBounds();
            s0x = (double)(nb.x + this.nodeF.getBoxX() + this.nodeF.getBarX()) + sp;
            s0y = nb.y + this.nodeF.getBoxY() + this.nodeF.getBarY() + this.containingCell.getBarH();
            s1x = s0x + sw;
            s1y = s0y;
        }
        if (this.nodeT.getLevel() == -1) {
            nb = this.nodeF.getBounds();
            f0x = this.containingCell.getOutflowX0();
            f0y = (double)(nb.y + this.nodeF.getBoxY() + this.nodeF.getBarY() + this.containingCell.getBarH() + this.containingCell.getOutflowMidHeight() + (int)(scale * this.containingCell.getLevelOutflow(this.nodeF.getLevel()) / 2.0)) - fp;
            f1x = f0x;
            f1y = f0y - fw;
            fv = true;
            c = this.nodeF.getOutflowCurve();
        } else {
            nb = this.nodeT.getBounds();
            f0x = (double)(nb.x + this.nodeT.getBoxX() + this.nodeT.getBarX()) + fp;
            f0y = nb.y + this.nodeT.getBoxY() + this.nodeT.getBarY();
            f1x = f0x + fw;
            f1y = f0y;
        }
        LinkRenderer.paint(g, s0x, s0y, s1x, s1y, sv, this.colorF, f0x, f0y, f1x, f1y, fv, null, c);
    }

    public Shape getOutline() {
        Rectangle nb;
        Curve c = null;
        boolean aa = this.containingCell.getDisplayModel().isAntialiasedGraphics();
        double scale = this.containingCell.getScale();
        double sp = scale * this.positionF;
        double sw = scale * this.volumeF;
        double fp = scale * this.positionT;
        double fw = scale * this.volumeT;
        if (!aa) {
            sp = this.antialias(sp, aa);
            fp = this.antialias(fp, aa);
            sw = this.antialias(scale * this.positionF + scale * this.volumeF, aa) - sp;
            fw = this.antialias(scale * this.positionT + scale * this.volumeT, aa) - fp;
        }
        double f1y = 0.0;
        double f1x = 0.0;
        double f0y = 0.0;
        double f0x = 0.0;
        double s1y = 0.0;
        double s1x = 0.0;
        double s0y = 0.0;
        double s0x = 0.0;
        boolean fv = false;
        boolean sv = false;
        if (this.nodeF.getLevel() == -1) {
            nb = this.nodeT.getBounds();
            s0x = this.containingCell.getInflowX1();
            s0y = (double)(nb.y + this.nodeT.getBoxY() + this.nodeT.getBarY() - this.containingCell.getInflowMidHeight() + (int)(scale * this.containingCell.getLevelInflow(this.nodeT.getLevel()) / 2.0)) - sp;
            s1x = s0x;
            s1y = s0y - sw;
            sv = true;
            c = this.nodeT.getInflowCurve();
        } else {
            nb = this.nodeF.getBounds();
            s0x = (double)(nb.x + this.nodeF.getBoxX() + this.nodeF.getBarX()) + sp;
            s0y = nb.y + this.nodeF.getBoxY() + this.nodeF.getBarY() + this.containingCell.getBarH();
            s1x = s0x + sw;
            s1y = s0y;
        }
        if (this.nodeT.getLevel() == -1) {
            nb = this.nodeF.getBounds();
            f0x = this.containingCell.getOutflowX0();
            f0y = (double)(nb.y + this.nodeF.getBoxY() + this.nodeF.getBarY() + this.containingCell.getBarH() + this.containingCell.getOutflowMidHeight() + (int)(scale * this.containingCell.getLevelOutflow(this.nodeF.getLevel()) / 2.0)) - fp;
            f1x = f0x;
            f1y = f0y - fw;
            fv = true;
            c = this.nodeF.getOutflowCurve();
        } else {
            nb = this.nodeT.getBounds();
            f0x = (double)(nb.x + this.nodeT.getBoxX() + this.nodeT.getBarX()) + fp;
            f0y = nb.y + this.nodeT.getBoxY() + this.nodeT.getBarY();
            f1x = f0x + fw;
            f1y = f0y;
        }
        return LinkRenderer.getOutline(s0x, s0y, s1x, s1y, sv, f0x, f0y, f1x, f1y, fv, c);
    }

    private double antialias(double d, boolean aa) {
        return aa ? d : Math.floor(d + 0.5);
    }
}

