/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.pathanalysischart;

import com.sas.MissingValues;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartTableDataModel;
import com.sas.graphics.components.pathanalysischart.PathTableDataModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.pathanalysischart.Node;
import com.sas.graphics.util.cell.pathanalysischart.PathAnalysisChartCell;
import com.sas.swing.visuals.treetable.SasCellRenderer;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class IOFlowTable
extends TreeTable {
    private static final String PAC_RB_KEY = "PathAnalysisChart.";
    private static final String PAC_RB_EXT = ".txt";
    private static final Icon zeroSizeIcon = new EmptyIcon(0, 0);
    private static final boolean showIcons = false;
    private static final int VOLUME_INDEX = 0;
    private static final int PATH_INDEX = 1;
    private static final int TYPE_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final int ID_INDEX = 4;
    private static final int PARENT_INDEX = 5;
    private static final int ROW_INDEX = 6;
    private static final int FLAT_CELL_PADDING = 8;
    private int volumeColumnWidth;
    private int pathColumnWidth;
    private PathAnalysisChartCell containingCell;
    private boolean inflow;
    private Node node;

    public IOFlowTable(PathAnalysisChartCell c, Node n, boolean in) {
        this.containingCell = c;
        this.node = n;
        this.inflow = in;
        String[] colNames = new String[]{"Volume", "Path", "Type", "Description", "_id", "_parent", "_rowIndex"};
        TreeTableRow root = new TreeTableRow(new Object[6]);
        TreeTableModel tm = new TreeTableModel((TreeNode)root, colNames);
        this.setDisplayedAsTree(true);
        this.setModel((TableModel)tm);
        this.setRootVisible(false);
        this.setShowGrid(false);
        this.setShowsRootHandles(true);
        this.setBorder(new LineBorder(new Color(153, 153, 153)));
        this.setEditable(false);
        this.setRowHeight(20);
        Color w = Color.white;
        Color g = new Color(240, 240, 240);
        this.setBackgroundArray(new Color[]{w, g});
        this.pathColumnWidth = -1;
        this.volumeColumnWidth = -1;
        TableColumnModel cm = this.getColumnModel();
        TableColumn tc = cm.getColumn(6);
        cm.removeColumn(tc);
        tc = cm.getColumn(5);
        cm.removeColumn(tc);
        tc = cm.getColumn(4);
        cm.removeColumn(tc);
        tc = cm.getColumn(3);
        cm.removeColumn(tc);
        tc = cm.getColumn(2);
        cm.removeColumn(tc);
        tc = cm.getColumn(1);
        tc.setPreferredWidth(tc.getWidth());
        tc = cm.getColumn(0);
        tc.setPreferredWidth(tc.getWidth());
    }

    public void add(String type, String path, String desc, Number vol, Object id, Object parent, int rowIndex) {
        Object[] new_row_data = new Object[]{vol, path, type, desc, id, parent, new Integer(rowIndex)};
        TreeTableModel ttm = (TreeTableModel)this.getModel();
        TreeTableRow new_row = new TreeTableRow(new_row_data);
        new_row.setOpenIcon(zeroSizeIcon);
        new_row.setClosedIcon(zeroSizeIcon);
        new_row.setLeafIcon(zeroSizeIcon);
        TreeTableRow parent_row = null;
        if (parent == null || parent instanceof MissingValues) {
            parent_row = (TreeTableRow)this.getRoot();
        } else {
            int nr = ttm.getRowCount(false);
            for (int rx = 0; rx < nr; ++rx) {
                TreeTableRow ttr = ttm.getRowAt(rx, false);
                Object ttr_id = ttr.getTableRow()[4];
                if (ttr_id == null || !ttr_id.equals(parent)) continue;
                parent_row = ttr;
                break;
            }
            if (parent_row != null && !this.isDisplayedAsTree()) {
                this.setDisplayedAsTree(true);
            }
        }
        if (parent_row == null) {
            String idString = id == null || id instanceof String ? (String)id : id.toString();
            String parentString = parent == null || parent instanceof String ? (String)parent : parent.toString();
            throw new IllegalArgumentException(IOFlowTable._nls("pathTableMissingParentRow", this.node.getName(), type, path, desc, idString, parentString));
        }
        parent_row.add((MutableTreeNode)new_row);
        this.expandPath(new TreePath(parent_row.getPath()));
    }

    public void computeColumnWidths() {
        TreeTableModel ttm = (TreeTableModel)this.getModel();
        boolean tree = this.isDisplayedAsTree();
        int treeLevelIndent = 20;
        if (!tree) {
            SasCellRenderer oldfcr;
            Object icr;
            TableCellRenderer r = this.getFlatCellRenderer();
            if (r == null) {
                NumberRenderer newfcr = new NumberRenderer(8);
                this.setFlatCellRenderer((TableCellRenderer)((Object)newfcr));
            } else if (r.getClass().equals(SasCellRenderer.class) && ((icr = (oldfcr = (SasCellRenderer)r).getInnerRenderer()) == null || icr instanceof TableCellRenderer)) {
                NumberRenderer newfcr = new NumberRenderer(8);
                newfcr.setFormat(oldfcr.getFormat());
                newfcr.setInnerRenderer((TableCellRenderer)icr);
                newfcr.setHorizontalAlignment(oldfcr.getHorizontalAlignment());
                this.setFlatCellRenderer((TableCellRenderer)((Object)newfcr));
            }
        }
        for (int rx = ttm.getRowCount(true) - 1; rx >= 0; --rx) {
            TreeTableRow ttr = ttm.getRowAt(rx, true);
            Object[] rowData = ttr.getTableRow();
            Object vol = rowData[0];
            TableCellRenderer cr = this.getCellRenderer(rx, 0);
            Component cc = cr.getTableCellRendererComponent((JTable)((Object)this), vol, false, false, rx, 0);
            Dimension cs = cc.getPreferredSize();
            int volColWidth = cs.width;
            if (tree) {
                TreeCellRenderer ccr;
                Icon rendererIcon = null;
                Icon rowIcon = null;
                if (cc instanceof JTree && (ccr = ((JTree)cc).getCellRenderer()) instanceof DefaultTreeCellRenderer) {
                    DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)ccr;
                    if (ttr.isLeaf()) {
                        rendererIcon = dtcr.getLeafIcon();
                        rowIcon = ttr.getLeafIcon();
                    } else if (ttr.isExpanded()) {
                        rendererIcon = dtcr.getOpenIcon();
                        rowIcon = ttr.getOpenIcon();
                    } else {
                        rendererIcon = dtcr.getClosedIcon();
                        rowIcon = ttr.getClosedIcon();
                    }
                }
                boolean showRowIcon = false;
                boolean showRendererIcon = false;
                volColWidth += ttr.getLevel() * treeLevelIndent - (!showRendererIcon && rendererIcon != null ? rendererIcon.getIconWidth() : 0) + (showRowIcon ? rowIcon.getIconWidth() : 0);
            }
            this.containingCell.setTableColumnWidth(this, 0, volColWidth += 5);
        }
    }

    public Dimension getPreferredSize() {
        TreeTableModel ttm = (TreeTableModel)this.getModel();
        int h = (ttm.getRowCount(false) - 1) * this.getRowHeight();
        int w = 0;
        TableColumnModel cm = this.getColumnModel();
        for (int cx = 0; cx < cm.getColumnCount(); ++cx) {
            w += cm.getColumn(cx).getPreferredWidth();
        }
        return new Dimension(w, h);
    }

    public void clear() {
        TreeTableRow root = (TreeTableRow)this.getRoot();
        if (root != null) {
            root.removeAllChildren();
        } else {
            DefaultTableModel m = (DefaultTableModel)this.getModel();
            m.setRowCount(0);
        }
    }

    public boolean isInflow() {
        return this.inflow;
    }

    public void setInflow(boolean in) {
        this.inflow = in;
    }

    public void getDataZoneInfo(Vector zones) {
        int numrows = this.getRowCount();
        int numcols = this.getColumnCount();
        String nodeName = this.node.getName();
        String io = this.inflow ? "_INFLOW" : "_OUTFLOW";
        String dir = this.inflow ? "IN" : "OUT";
        PathAnalysisChartTableDataModel pactdm = (PathAnalysisChartTableDataModel)this.containingCell.getDataModel();
        PathTableDataModel pathModel = pactdm.getPathTableDataModel();
        TableModel ptm = pathModel.getModel();
        TableModel ttm = this.getModel();
        Variable nodeVar = pathModel.getNodeVariable();
        Variable dirVar = pathModel.getDirectionVariable();
        Variable typeVar = pathModel.getTypeVariable();
        Variable pathVar = pathModel.getPathVariable();
        for (int rx = 0; rx < numrows; ++rx) {
            int datasetRowIndex = (Integer)this.getModel().getValueAt(rx, 6);
            ValueList datatips = this.containingCell._makeValueList(datasetRowIndex, nodeName, nodeVar, dir, dirVar, ttm.getValueAt(rx, 2), typeVar, ttm.getValueAt(rx, 1), pathVar, ptm, pathModel.getDataTipVariable());
            ValueList auxdata = this.containingCell._makeValueList(datasetRowIndex, nodeName, nodeVar, dir, dirVar, ttm.getValueAt(rx, 2), typeVar, ttm.getValueAt(rx, 1), pathVar, ptm, pathModel.getAuxilliaryVariable());
            for (int cx = 0; cx < numcols; ++cx) {
                String formattedData;
                Rectangle cb = this.getCellRect(rx, cx, false);
                Object unformattedData = this.getValueAt(rx, cx);
                String string = unformattedData == null ? null : (formattedData = unformattedData instanceof String ? (String)unformattedData : unformattedData.toString());
                if (cb.height == 0 || cb.width == 0 || cb.y >= this.getHeight() || cb.x >= this.getWidth()) continue;
                String colName = this.getColumnName(cx);
                zones.add(new ChartValueZone(new Rectangle(this.getX() + (int)cb.getX(), this.getY() + (int)cb.getY(), (int)cb.getWidth(), (int)cb.getHeight()), null, new ValueList(io, io, new ValueList(colName, colName, new ValueList(new Integer(rx), "" + rx, null))), new ValueList(nodeName, nodeName, null), null, new ValueList(unformattedData, formattedData, null), null, datatips, auxdata));
            }
        }
    }

    public void getLabelZoneInfo(Vector zones) {
        int numcols = this.getColumnCount();
        String nodeName = this.node.getName();
        String io = this.inflow ? "_INFLOW" : "_OUTFLOW";
        for (int cx = 0; cx < numcols; ++cx) {
            String formattedData;
            Rectangle cb = this.getTableHeader().getHeaderRect(cx);
            Object unformattedData = this.getColumnModel().getColumn(cx).getHeaderValue();
            String string = unformattedData == null ? null : (formattedData = unformattedData instanceof String ? (String)unformattedData : unformattedData.toString());
            if (cb.height == 0 || cb.width == 0) continue;
            String colName = this.getColumnName(cx);
            zones.add(new ChartValueZone(new Rectangle((int)cb.getX(), (int)cb.getY(), (int)cb.getWidth(), (int)cb.getHeight()), null, new ValueList(io, io, new ValueList(colName, colName, null)), new ValueList(nodeName, nodeName, null), null, new ValueList(unformattedData, formattedData, null), null, null, null));
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean isVisible() {
        return this.getRowCount() > 0;
    }

    public void doLayout() {
        if (this.volumeColumnWidth != this.containingCell.getTableColumnWidth(this, 0)) {
            this.volumeColumnWidth = this.containingCell.getTableColumnWidth(this, 0);
            this.pathColumnWidth = this.containingCell.getPathTableWidth() - this.volumeColumnWidth;
            this.getColumnModel().getColumn(0).setPreferredWidth(this.volumeColumnWidth);
            this.getColumnModel().getColumn(1).setPreferredWidth(this.pathColumnWidth);
        }
        super.doLayout();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public void invalidate() {
    }

    public void revalidate() {
        this.repaint();
    }

    public void scrollRectToVisible(Rectangle r) {
    }

    private static String _nls(String key) {
        return RB.getStringResource(PAC_RB_KEY, key + PAC_RB_EXT);
    }

    private static String _nls(String key, String p0, String p1, String p2, String p3, String p4, String p5) {
        return Message.format((String)IOFlowTable._nls(key), (Object)p0, (Object)p1, (Object)p2, (Object)p3, (Object)p4, (Object)p5);
    }

    private static class EmptyIcon
    implements Icon {
        int w;
        int h;

        public EmptyIcon(int width, int height) {
            this.w = width;
            this.h = height;
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private static class PaddedContainer
    extends Container {
        Component c;
        int pt = 0;
        int pl = 0;
        int pb = 0;
        int pr = 0;
        int ah = 0;
        int av = 0;
        Dimension myPrefSize;

        public PaddedContainer(int top, int left, int bottom, int right) {
            this.pt = top;
            this.pl = left;
            this.pb = bottom;
            this.pr = right;
            this.setLayout(null);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension cs = this.c.getPreferredSize();
            if (this.myPrefSize == null) {
                this.myPrefSize = new Dimension();
            }
            this.myPrefSize.height = cs.height + this.pt + this.pb;
            this.myPrefSize.width = cs.width + this.pl + this.pr;
            return this.myPrefSize;
        }

        public void setContents(Component comp) {
            this.removeAll();
            this.add(comp);
            this.c = comp;
        }

        public void setHorizontalAlignment(int halign) {
            this.ah = halign;
        }

        public void setVerticalAlignment(int valign) {
            this.av = valign;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public void paint(Graphics g) {
            Dimension ss = this.getSize();
            Dimension cs = this.c.getPreferredSize();
            g.setColor(this.c.getBackground());
            g.fillRect(0, 0, ss.width, ss.height);
            this.c.setSize(cs);
            int x = 0;
            int y = 0;
            switch (this.ah) {
                case 2: {
                    x = this.pl;
                    break;
                }
                case 4: {
                    x = ss.width - cs.width - this.pr;
                    break;
                }
                case 0: {
                    x = (ss.width - cs.width - this.pr - this.pl) / 2;
                }
            }
            switch (this.av) {
                case 1: {
                    y = this.pt;
                    break;
                }
                case 3: {
                    y = ss.height - cs.height - this.pb;
                    break;
                }
                case 0: {
                    y = (ss.height - cs.height - this.pt - this.pb) / 2;
                }
            }
            this.c.setLocation(x, y);
            super.paint(g);
        }
    }

    private static class NumberRenderer
    extends SasCellRenderer {
        PaddedContainer pc;

        public NumberRenderer(int padding) {
            this.pc = new PaddedContainer(0, 0, 0, padding);
            this.pc.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean isFocused, int rx, int cx) {
            Component c = super.getTableCellRendererComponent(t, value, isSelected, isFocused, rx, cx);
            this.pc.setContents(c);
            return this.pc;
        }
    }
}

