/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.pathanalysischart;

class Curve {
    public double[] x;
    public double[] y;
    public double[] n;
    private static final int SEGLEN = 5;
    private static final int NUMARCS = 8;
    private static final int WEIGHTP = 8;

    public Curve(int x0, int y0, int w, int h) {
        double w0 = 0.7366698456395302;
        double h0 = 0.9563496840765863;
        double w1 = 0.2633301543604698;
        double h1 = 0.043650315923413584;
        int sw = 1;
        int sh = 1;
        if (w < 0) {
            sw = -1;
            w = -w;
        }
        if (h < 0) {
            sh = -1;
            h = -h;
        }
        double r0 = ((double)h * w1 - (double)w * h1) / (h0 * w1 - w0 * h1);
        double r1 = ((double)w - r0 * w0) / w1;
        this._makeCurve(r0, r1);
        this._adjustOrientation(x0, y0, sw, sh);
    }

    private void _adjustOrientation(int x0, int y0, int sw, int sh) {
        int np = this.getNumberOfPoints();
        for (int i = 0; i < np; ++i) {
            this.x[i] = (double)x0 + (double)sw * this.x[i];
            this.y[i] = (double)y0 + (double)sh * this.y[i];
            this.n[i] = sh > 0 && sw > 0 ? this.n[i] : (sh > 0 && sw < 0 ? Math.PI - this.n[i] : (sh < 0 && sw > 0 ? Math.PI * 2 - this.n[i] : (sh < 0 && sw < 0 ? Math.PI + this.n[i] : 0.0)));
        }
    }

    public int getNumberOfPoints() {
        return this.x.length;
    }

    public double getX(int i) {
        return this.x[i];
    }

    public double getY(int i) {
        return this.y[i];
    }

    public double getNormal(int i) {
        return this.n[i];
    }

    public void setX(int i, double xi) {
        this.x[i] = xi;
    }

    public void getY(int i, double yi) {
        this.y[i] = yi;
    }

    public void getNormal(int i, double ni) {
        this.n[i] = ni;
    }

    private void _makeCurve(double r0, double r1) {
        int nsegs;
        double arclen;
        double r;
        int arc;
        double theta0 = Math.PI;
        double theta1 = 1.5707963267948966;
        double d_theta = (theta1 - theta0) / 8.0;
        int np = 2;
        for (arc = 1; arc <= 8; ++arc) {
            r = Curve.findRadius(r0, r1, arc);
            arclen = Math.abs(r * d_theta / Math.PI);
            nsegs = (int)(arclen / 5.0 + 0.5);
            if (nsegs < 1) {
                nsegs = 1;
            }
            np += nsegs;
        }
        this.x = new double[np];
        this.y = new double[np];
        this.n = new double[np];
        np = 0;
        this.x[np] = 0.0;
        this.y[np] = 0.0;
        this.n[np] = theta0;
        ++np;
        for (arc = 1; arc <= 8; ++arc) {
            r = Curve.findRadius(r0, r1, arc);
            arclen = Math.abs(r * d_theta / Math.PI);
            nsegs = (int)(arclen / 5.0 + 0.5);
            if (nsegs < 1) {
                nsegs = 1;
            }
            for (int seg = 1; seg <= nsegs; ++seg) {
                double theta;
                this.n[np] = theta = theta0 + d_theta * ((double)(arc - 1) + (double)seg * 1.0 / (double)nsegs);
                this.x[np] = this.x[np - 1] + r * (Math.cos(this.n[np]) - Math.cos(this.n[np - 1]));
                this.y[np] = this.y[np - 1] + r * (Math.sin(this.n[np]) - Math.sin(this.n[np - 1]));
                ++np;
            }
        }
        this.x[np] = this.x[np - 1];
        this.y[np] = this.y[np - 1];
        this.n[np] = theta1;
        if (++np != this.x.length) {
            throw new IllegalArgumentException("" + np + " != " + this.x.length);
        }
    }

    private static double findRadius(double r0, double r1, int arcNo) {
        double w = Curve.findWeight(arcNo);
        double radius = (1.0 - w) * r0 + w * r1;
        return radius;
    }

    private static double findWeight(int n) {
        double nn = (double)(n - 1) * 1.0 / 7.0;
        double weight = Math.pow(nn, 8.0);
        return weight;
    }
}

