/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.mapchart;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AnnotationDataModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DiscreteStyle;
import com.sas.graphics.components.DiscreteStyleMapModel;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ScrollModelInterface;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.mapchart.MapChartModel;
import com.sas.graphics.util.cell.CategorizationInfo;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ColorRampLegendCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.DrilldownMarker;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalLegendCell;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.mapchart.CompositePipe;
import com.sas.graphics.util.cell.mapchart.MapChartCell;
import com.sas.graphics.util.cell.mapchart.MapChartCellModel;
import com.sas.graphics.util.cell.mapchart.MapChartMatrixContainer;
import com.sas.graphics.util.cell.mapchart.MapChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.gl.SpatialFeatureCache;
import com.sas.util.NumericRangeSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class MapChartMatrix
extends Matrix {
    private static final long serialVersionUID = 1L;
    private ArrayList cells;
    private LegendCell[] colorLegend;
    private DrilldownMarker drillMarker = new DrilldownMarker();
    private MapChartCellModel mapChartCellModel;
    private MapChartMatrixContainer matrixContainer;
    private DataSource spatialDataSource;
    private SwingActionProvider actionProvider = null;
    private SpatialFeatureCache spatialFeatureCache;
    private boolean spatialDataDirty = true;
    private AnnotationDataModel annotationModel = null;
    private transient MapChartMatrixModel model;

    public MapChartMatrix(Channel channel) {
        this(null, channel);
    }

    public MapChartMatrix(MapChartMatrixModel model, Channel channel) {
        super(channel);
        this._setModel(model);
    }

    public void setModel(MapChartMatrixModel newModel) {
        this._setModel(newModel);
    }

    private void _setModel(MapChartMatrixModel newModel) {
        if (this.model == newModel) {
            return;
        }
        this.model = newModel;
        this.reconstruct();
    }

    public MapChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    public void setSpatialDataSource(DataSource sds) {
        if (sds == this.spatialDataSource) {
            return;
        }
        this.spatialDataSource = sds;
        this.reconstruct();
    }

    public DataSource getSpatialDataSource() {
        return this.spatialDataSource;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        this.cells = null;
        this.colorLegend = null;
    }

    @Override
    protected synchronized void construct() {
        this.cleanMatrixContainer();
        MapChartMatrixModel chartMatrixModel = this.getModel();
        if (chartMatrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        if (chartMatrixModel.getMapChartModel() != null) {
            this.setAntialiasedTextEnabled(chartMatrixModel.getMapChartModel().isAntialiasedText());
        }
        if (this.dataSource == null || this.spatialDataSource == null && this.dataSource.getVariable(chartMatrixModel.getWKBRole(), 0) == null) {
            return;
        }
        Variable colorVariable = this.dataSource.getVariable(chartMatrixModel.getColorRole(), 0);
        if (colorVariable == null) {
            colorVariable = this.dataSource.getVariable(chartMatrixModel.getExtrusionRole(), 0);
        }
        if (colorVariable == null) {
            throw new IllegalStateException(RB.getStringResource("colorVariableNotSpecified.ex.txt"));
        }
        if (this.dataSource.getVariable(chartMatrixModel.getIDRole(), 0) == null) {
            throw new IllegalStateException(RB.getStringResource("idVariableNotSpecified.ex.txt"));
        }
        if (colorVariable.getValueCount() < 1 && chartMatrixModel.getMapChartModel().getEmptyPolicy() == 10202) {
            return;
        }
        Variable[] colorGTKVars = this.dataSource.getVariable(chartMatrixModel.getColorRole());
        Variable[] extrusionGTKVars = this.dataSource.getVariable(chartMatrixModel.getExtrusionRole());
        boolean validColor = colorGTKVars != null;
        boolean validExtrusion = extrusionGTKVars != null;
        for (int ii = 0; validExtrusion && ii < extrusionGTKVars.length; ++ii) {
            validExtrusion = extrusionGTKVars[ii] instanceof NumericVariable;
        }
        if (!validColor && !validExtrusion) {
            throw new IllegalStateException(RB.getStringResource("invalidResponseVariableSpecified.ex.txt"));
        }
        if (!validColor) {
            colorGTKVars = extrusionGTKVars;
        }
        chartMatrixModel.setRowModel(chartMatrixModel.getMapChartModel().getRowAxisModel());
        chartMatrixModel.setColumnModel(chartMatrixModel.getMapChartModel().getColumnAxisModel());
        this.mapChartCellModel = new MapChartCellModel();
        this.mapChartCellModel.setIDRole(chartMatrixModel.getIDRole());
        this.mapChartCellModel.setColorRole(chartMatrixModel.getColorRole());
        this.mapChartCellModel.setExtrusionRole(chartMatrixModel.getExtrusionRole());
        this.mapChartCellModel.setSelectionRole(chartMatrixModel.getSelectionRole());
        this.mapChartCellModel.setAuxiliaryRole(chartMatrixModel.getAuxiliaryRole());
        this.mapChartCellModel.setDataTipRole(chartMatrixModel.getDataTipRole());
        this.mapChartCellModel.setAnimationKeyFrameRole(chartMatrixModel.getAnimationKeyFrameRole());
        this.mapChartCellModel.setMapChartModel(chartMatrixModel.getMapChartModel());
        this.mapChartCellModel.setRuleTargetIdentifier(chartMatrixModel.getRuleTargetIdentifier());
        this.mapChartCellModel.setTitleMarker(this.drillMarker);
        this.mapChartCellModel.setAllFeaturesVisible(new Boolean(chartMatrixModel.getMapChartModel().getEmptyPolicy() == 10201));
        this.mapChartCellModel.setAnnotationDataModel(this.annotationModel);
        this.updateSpatialFeatureCache(chartMatrixModel, validExtrusion);
        this.mapChartCellModel.setSpatialFeatureCache(this.spatialFeatureCache);
        this.mapChartCellModel.setAntialiasedGraphics(new Boolean(chartMatrixModel.getMapChartModel().isAntialiasedGraphics()));
        this.mapChartCellModel.setAntialiasedText(new Boolean(chartMatrixModel.getMapChartModel().isAntialiasedText()));
        ColorMapper[] colorMapperArray = this.makeColorMapper(this.dataSource, chartMatrixModel, chartMatrixModel.getMapChartModel());
        this.mapChartCellModel.setColorMapper(colorMapperArray);
        if (validExtrusion) {
            NumericMapper[] heightMapperArray = this.makeHeightMapper(this.dataSource, chartMatrixModel, this.spatialFeatureCache.getBoundingBox().getSize().y);
            this.mapChartCellModel.setHeightMapper(heightMapperArray);
        }
        this.findActionProvider();
        this.cells = this.addMatrixCellComponents(new MapCellFactory(), this.mapChartCellModel, new DataSource[]{this.dataSource});
        if (this.mapChartCellModel.getMapChartModel().getLegendModel().isVisible()) {
            this.colorLegend = new LegendCell[colorMapperArray.length];
            for (int ii = 0; ii < colorMapperArray.length; ++ii) {
                this.colorLegend[ii] = this._addLegend(this.dataSource, chartMatrixModel, chartMatrixModel.getMapChartModel(), colorMapperArray, colorGTKVars, extrusionGTKVars, ii);
            }
        }
    }

    private void findActionProvider() {
        if (this.dataSource.isOLAPData()) {
            Container parent;
            for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
            }
            if (parent instanceof Graph) {
                this.actionProvider = ((Graph)parent).getActionProvider();
            }
        }
    }

    private ColorMapper[] makeColorMapper(DataSource ds, MapChartMatrixModel matrixModel, MapChartModel graphModel) {
        DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
        if (ds == null || dataElementStyles == null || dataElementStyles.getFillStyles() == null || dataElementStyles.getFillStyles().length < 1) {
            return null;
        }
        Color missingColor = dataElementStyles.getMissingFillStyle().getSolidFillColor();
        Variable[] styleByVariableArray = ds.getVariable(matrixModel.getColorRole());
        if (styleByVariableArray == null) {
            styleByVariableArray = ds.getVariable(matrixModel.getExtrusionRole());
        }
        ColorMapper[] cma = new ColorMapper[styleByVariableArray.length];
        for (int ii = 0; ii < styleByVariableArray.length; ++ii) {
            if (styleByVariableArray[ii] instanceof StringVariable) {
                NumericVariable v = this.dataSource.getBaseVariable((StringVariable)styleByVariableArray[ii]);
                Object styleByVariable = v != null ? GTKUtil.newStringVariableFromFormattedUniqueValues(v) : styleByVariableArray[ii];
                if (this.dataSource.isRelationalData()) {
                    cma[ii] = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper((Variable)styleByVariable, dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors());
                    DiscreteStyleMapModel styleMap = Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(this.dataSource, (Variable)styleByVariable, dataElementStyles.getDiscreteStyleMapModel());
                    if (styleMap == null) continue;
                    MapChartMatrix._applyStyleMapFillStyles(styleMap, (StringToColorMapper)cma[ii], styleByVariable);
                    continue;
                }
                StringToColorMapper stcm = new StringToColorMapper();
                stcm.input.connectFrom(styleByVariable.formattedValue);
                cma[ii] = stcm;
                continue;
            }
            if (this.dataSource.isCategorized(styleByVariableArray[ii])) {
                CategorizationInfo categorizationInfo = null;
                RangeInfo[] rangeInfos = this.dataSource.categorize(styleByVariableArray[ii]);
                SegmentedRangeStyle altSegmentedRangeStyle = new SegmentedRangeStyle();
                altSegmentedRangeStyle.setDataElementStyles(dataElementStyles);
                altSegmentedRangeStyle.setPaletteType(12101);
                SegmentedRangeStyle segmentedRangeStyle = this.dataSource.getSegmentedRangeStyle(styleByVariableArray[ii]);
                if (rangeInfos != null) {
                    categorizationInfo = new CategorizationInfo(this.dataSource.getCategorizationModel(styleByVariableArray[ii]), segmentedRangeStyle, altSegmentedRangeStyle, rangeInfos);
                }
                if (categorizationInfo != null && rangeInfos != null) {
                    Util.collate(categorizationInfo);
                    DiscreteRangeToColorMapper mapper = GTKUtil.MapperFactory.newNonContinuousColorMapper(categorizationInfo);
                    if (!(mapper instanceof DiscreteRangeToColorMapper)) continue;
                    DiscreteRangeToColorMapper discreteColorMapper = mapper;
                    discreteColorMapper.setReplaceMissingValues(true);
                    discreteColorMapper.setMissingReplacement(missingColor);
                    discreteColorMapper.setLabelMissingValues(true);
                    discreteColorMapper.input.connectFrom(((NumericVariable)styleByVariableArray[ii]).value);
                    cma[ii] = discreteColorMapper;
                    StringVariable stringVariable = GTKUtil.newStringVariableFromFormattedUniqueValues((NumericVariable)styleByVariableArray[ii]);
                    stringVariable = new StringVariable();
                    stringVariable.connectFrom((NumericVariable)styleByVariableArray[ii]);
                    DiscreteStyleMapModel styleMap = Util.rawObjectValueStyleMapToTrimmedFormattedValueStyleMap(this.dataSource, (Variable)stringVariable, dataElementStyles.getDiscreteStyleMapModel());
                    if (styleMap == null) continue;
                    MapChartMatrix._applyStyleMapFillStyles(styleMap, discreteColorMapper, stringVariable);
                    continue;
                }
                DiscreteRangeToColorMapper discreteColorMapper = new DiscreteRangeToColorMapper();
                discreteColorMapper.input.setValue(0.0);
                cma[ii] = discreteColorMapper;
                continue;
            }
            Color start = styleByVariableArray.length > 1 ? Color.WHITE : dataElementStyles.getContinuousFillTwoColorStartColor();
            Color end = styleByVariableArray.length > 1 ? Util.newCycledFillStyle(dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors(), ii).getSolidFillColor() : dataElementStyles.getContinuousFillTwoColorEndColor();
            NumericVariable nv = (NumericVariable)styleByVariableArray[ii];
            if (nv.getMin() == nv.getMax()) {
                DiscreteRangeToColorMapper drtcm = new DiscreteRangeToColorMapper();
                drtcm.setReplaceMissingValues(true);
                drtcm.setMissingReplacement(missingColor);
                drtcm.setLabelMissingValues(true);
                NumericRangeSegment[] ns = new NumericRangeSegment[]{new NumericRangeSegment(nv.getMin(), nv.getMax(), false, false, (Object)dataElementStyles.getFillStyles()[0].getSolidFillColor())};
                drtcm.setRangeSegments(ns);
                cma[ii] = drtcm;
                continue;
            }
            ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
            crtcm.setColorSpectrum(nv.getMin(), nv.getMax(), start, end);
            crtcm.setReplaceMissingValues(true);
            crtcm.setMissingReplacement(missingColor);
            crtcm.setLabelMissingValues(true);
            cma[ii] = crtcm;
        }
        return cma;
    }

    private NumericMapper[] makeHeightMapper(DataSource ds, MapChartMatrixModel matrixModel, double outputRange) {
        if (ds == null) {
            return null;
        }
        Variable[] heightVariableArray = ds.getVariable(matrixModel.getExtrusionRole());
        NumericMapper[] nma = new NumericMapper[heightVariableArray.length];
        for (int ii = 0; ii < heightVariableArray.length; ++ii) {
            Variable heightVariable = heightVariableArray[ii];
            if (heightVariable instanceof StringVariable) {
                NumericVariable v = this.dataSource.getBaseVariable((StringVariable)heightVariable);
                if (v != null) {
                    heightVariable = GTKUtil.newStringVariableFromFormattedUniqueValues(v);
                }
                StringToNumericMapper stnm = new StringToNumericMapper();
                stnm.input.connectFrom(((StringVariable)heightVariable).value);
                stnm.setStartValue(0.0);
                stnm.setStrideValue(outputRange * 0.04);
                nma[ii] = stnm;
                continue;
            }
            NumericVariable nv = (NumericVariable)heightVariable;
            ContinuousRangeToNumericMapper crtnm = new ContinuousRangeToNumericMapper();
            crtnm.setOutputMax(outputRange * 0.4);
            crtnm.setOutputMin(0.0);
            crtnm.setInputMax(nv.getMax());
            crtnm.setInputMin(nv.getMin());
            crtnm.input.connectFrom(((NumericVariable)heightVariable).value);
            nma[ii] = crtnm;
        }
        return nma;
    }

    public void setSpatialDataDirty(boolean b) {
        this.spatialDataDirty = b;
        if (b) {
            this.cleanMatrixContainer();
        }
    }

    public boolean isSpatialDataDirty() {
        return this.spatialDataDirty;
    }

    private void updateSpatialFeatureCache(MapChartMatrixModel chartMatrixModel, boolean extrudeOn) {
        if (this.spatialFeatureCache != null && !this.spatialDataDirty) {
            return;
        }
        this.spatialFeatureCache = new SpatialFeatureCache();
        Variable[] idGTKVars = null;
        if (this.spatialDataSource == null || this.spatialDataSource.getVariable(chartMatrixModel.getWKBRole()) != null) {
            DataSource sds = this.spatialDataSource == null ? this.dataSource : this.spatialDataSource;
            StringVariable WKBGTKVar = (StringVariable)sds.getVariable(chartMatrixModel.getWKBRole(), 0);
            idGTKVars = sds.getVariable(this.spatialDataSource == null ? chartMatrixModel.getIDRole() : chartMatrixModel.getSpatialRole());
            this.spatialFeatureCache.wkb.connectFrom(WKBGTKVar.value);
        } else {
            idGTKVars = this.spatialDataSource.getVariable(chartMatrixModel.getSpatialRole());
            NumericVariable xGTKVar = (NumericVariable)this.spatialDataSource.getVariable(chartMatrixModel.getXRole(), 0);
            NumericVariable yGTKVar = (NumericVariable)this.spatialDataSource.getVariable(chartMatrixModel.getYRole(), 0);
            NumericVariable segGTKVar = (NumericVariable)this.spatialDataSource.getVariable(chartMatrixModel.getSegmentRole(), 0);
            if (idGTKVars == null) {
                throw new IllegalStateException(RB.getStringResource("idVariableNotSpecified.ex.txt"));
            }
            if (xGTKVar == null) {
                throw new IllegalStateException(RB.getStringResource("xVariableNotSpecified.ex.txt"));
            }
            if (yGTKVar == null) {
                throw new IllegalStateException(RB.getStringResource("yVariableNotSpecified.ex.txt"));
            }
            this.spatialFeatureCache.x.connectFrom(xGTKVar.value);
            this.spatialFeatureCache.y.connectFrom(yGTKVar.value);
            this.spatialFeatureCache.segment.connectFrom(segGTKVar.value);
        }
        if (idGTKVars == null) {
            return;
        }
        if (idGTKVars != null && idGTKVars.length > 1) {
            CompositePipe cp = new CompositePipe();
            for (int i = 0; i < idGTKVars.length; ++i) {
                if (idGTKVars[i] instanceof NumericVariable) {
                    cp.addInput((Pipe)((NumericVariable)idGTKVars[i]).value);
                    continue;
                }
                cp.addInput((Pipe)((StringVariable)idGTKVars[i]).value);
            }
            this.spatialFeatureCache.stringID.connectFrom(cp.value);
        } else if (idGTKVars[0] instanceof NumericVariable) {
            this.spatialFeatureCache.id.connectFrom(((NumericVariable)idGTKVars[0]).value);
        } else {
            this.spatialFeatureCache.stringID.connectFrom(((StringVariable)idGTKVars[0]).value);
        }
        this.spatialFeatureCache.extrudeOn.setValue(extrudeOn);
        this.spatialFeatureCache.cacheFeatures(this.getChannel());
        this.setSpatialDataDirty(false);
    }

    private LegendCell _addLegend(DataSource ds, MapChartMatrixModel matrixModel, MapChartModel graphModel, ColorMapper[] colorMapperArray, Variable[] primaryVariable, Variable[] secondaryVariable, int i) {
        LegendCellModel lcm;
        Variable variable;
        Variable variable2 = variable = primaryVariable.length > i && primaryVariable[i] == null ? secondaryVariable[i] : primaryVariable[i];
        if (variable == null) {
            return null;
        }
        LegendCell lc = null;
        if (colorMapperArray[i] instanceof ContinuousRangeToColorMapper) {
            lcm = new ColorRampLegendCellModel();
            ContinuousRangeToColorMapper crtcm = (ContinuousRangeToColorMapper)colorMapperArray[i];
            crtcm.input.connectFrom(((NumericVariable)variable).value);
        } else {
            lcm = new LegendCellModel();
        }
        lcm.setAntialiasedGraphics(new Boolean(graphModel.isAntialiasedGraphics()));
        lcm.setAntialiasedText(new Boolean(graphModel.isAntialiasedText()));
        colorMapperArray[i].setFormat(variable.getFormat());
        colorMapperArray[i].setMissingReplacement(graphModel.getDataElementStyles().getMissingFillStyle().getSolidFillColor());
        colorMapperArray[i].setLabelMissingValues(true);
        lcm.setColorMapper(colorMapperArray[i]);
        lcm.setMarkerOutlineLineStyle(matrixModel.getMapChartModel().getDataElementStyles().getOutlineLineStyle());
        lcm.setDefaultLabel(variable.getLabel());
        int placement = graphModel.getLegendModel().getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
        lcm.setPlacement(new Integer(placement));
        lcm.setLegendModel(graphModel.getLegendModel());
        lcm.setTitleMarker(this.drillMarker);
        lc = new LegendCell(lcm, this.getChannel());
        this.addLegend(lc, placement);
        return lc;
    }

    public ChartImageMapInfo2[] getImageMapInfo() {
        if (this.getErrorMessage() != null || this.dataSource == null || this.dataSource.getValueCount() <= 0 || this.model == null || this.cells == null) {
            return null;
        }
        ChartImageMapInfo2[] mapChartImageMapInfos = null;
        int cellCount = this.cells.size();
        if (cellCount > 0) {
            ArrayList l = new ArrayList();
            this.addVariableListImageMapInfo(l);
            Util.addCellImageMapInfo(this.cells, l);
            this.addLegendImageMapInfo(l);
            this.addMatrixAxesImageMapInfo(l);
            mapChartImageMapInfos = ChartImageMapInfo2.listToArray(l);
        }
        return mapChartImageMapInfos;
    }

    private void addMatrixAxesImageMapInfo(List imageMapInfoList) {
        if (this.matrixContainer != null) {
            imageMapInfoList.add(this.matrixContainer.getImageMapInfo());
        }
    }

    private void addVariableListImageMapInfo(List imageMapInfoList) {
        VariableList columnVariableList = Util.newVariablelist(this.dataSource, this.model.getColumnRole());
        VariableList rowVariableList = Util.newVariablelist(this.dataSource, this.model.getRowRole());
        VariableList colorVariableList = Util.newVariablelist(this.dataSource, this.model.getColorRole());
        VariableList extrusionVariableList = Util.newVariablelist(this.dataSource, this.model.getExtrusionRole());
        VariableList IDVariableList = Util.newVariablelist(this.dataSource, this.model.getIDRole());
        VariableList dataTipVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getDataTipRole());
        VariableList auxiliaryVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getAuxiliaryRole());
        imageMapInfoList.add(new ChartImageMapInfo2(columnVariableList, rowVariableList, IDVariableList, null, colorVariableList, extrusionVariableList, dataTipVariableList, auxiliaryVariableList));
    }

    private void addLegendImageMapInfo(List imageMapInfoList) {
        if (this.colorLegend != null) {
            for (int i = 0; i < this.colorLegend.length; ++i) {
                if (!(this.colorLegend[i] instanceof HierarchicalLegendCell)) continue;
                imageMapInfoList.add(((HierarchicalLegendCell)this.colorLegend[i]).getImageMapInfo());
            }
        }
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.cells != null) {
            for (int ii = 0; ii < this.cells.size(); ++ii) {
                ((MapChartCell)this.cells.get(ii)).setAnimationFrame(animationPosition);
            }
        }
    }

    @Override
    protected ArrayList addMatrixCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource) {
        Container parent;
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        this.matrixContainer = new MapChartMatrixContainer((MapChartMatrixModel)this.getMatrixModel(), dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), new MapChartCellComponentFactory(this.mapChartCellModel, dataSource[0]), null, actionProvider, false, this.graphModel.isAntialiasedGraphics(), this.graphModel.isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        ArrayList<Component> cells = new ArrayList<Component>();
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    @Override
    protected ArrayList addRowTabletCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        return null;
    }

    @Override
    public ScrollModelInterface getScrollModel() {
        return null;
    }

    @Override
    public void setAntialiasedTextEnabled(boolean b) {
    }

    @Override
    public void setMatrixCellOutlineLineStyle(LineStyle lineStyle) {
    }

    @Override
    public void setMatrixCellOutlineVisible(boolean b) {
    }

    @Override
    protected List getCells() {
        return this.cells;
    }

    private static void _applyStyleMapFillStyles(DiscreteStyleMapModel styleMap, DiscreteRangeToColorMapper colorMapper, StringVariable variable) {
        if (colorMapper != null && styleMap != null) {
            for (Object key : styleMap.keySet()) {
                Color styleMapColor = MapChartMatrix._getFillStyleColorOverride(styleMap, key);
                if (styleMapColor == null) continue;
                try {
                    double doubleValue;
                    if (key instanceof Number) {
                        doubleValue = ((Number)key).doubleValue();
                    } else {
                        if (!(key instanceof String)) continue;
                        doubleValue = Double.parseDouble((String)key);
                    }
                    NumericRangeSegment[] rangeSegments = colorMapper.getRangeSegments();
                    for (int j = 0; j < rangeSegments.length; ++j) {
                        if (!(rangeSegments[j].getMin() < doubleValue) && (rangeSegments[j].getMinExclude() || rangeSegments[j].getMin() != doubleValue) || !(rangeSegments[j].getMax() > doubleValue) && (rangeSegments[j].getMaxExclude() || rangeSegments[j].getMax() != doubleValue)) continue;
                        rangeSegments[j].setValue((Object)styleMapColor);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
    }

    private static void _applyStyleMapFillStyles(DiscreteStyleMapModel styleMap, StringToColorMapper colorMapper, StringVariable variable) {
        if (colorMapper != null && styleMap != null) {
            for (int i = 0; i < variable.getValueCount(); ++i) {
                Object value = Variable.getValue((Variable)variable, (int)i, (boolean)true);
                if (value == null) continue;
                String stringValue = value.toString().trim();
                Color styleMapColor = MapChartMatrix._getFillStyleColorOverride(styleMap, value);
                if (styleMapColor == null) continue;
                colorMapper.add(stringValue, styleMapColor);
            }
        }
    }

    private static Color _getFillStyleColorOverride(DiscreteStyleMapModel styleMap, Object dataValue) {
        DiscreteStyle discreteStyle;
        if (styleMap != null && (discreteStyle = styleMap.get(dataValue)) != null && discreteStyle.getFillStyle() != null) {
            return discreteStyle.getFillStyle().getSolidFillColor();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.colorLegend != null) {
            Dimension legendSize = new Dimension(0, 0);
            for (int i = 0; i < this.colorLegend.length; ++i) {
                Dimension d = this.colorLegend[i].getPreferredSize();
                if (d.width > legendSize.width) {
                    legendSize.width = d.width;
                }
                if (d.height <= legendSize.height) continue;
                legendSize.height = d.height;
            }
            this.mapChartCellModel.setPreferredSize(legendSize);
        }
        return super.getPreferredSize();
    }

    public void setAnnotationDataModel(AnnotationDataModel annotationModel) {
        this.annotationModel = annotationModel;
    }

    public AnnotationDataModel getAnnotationDataModel() {
        return this.annotationModel;
    }

    private class MapChartCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final MapChartCellModel cellModel;
        private final DataSource dataSource;
        private final Object animationKeyFrameRole;
        private final Object animationIDRole;

        public MapChartCellComponentFactory(MapChartCellModel cellModel, DataSource dataSource) {
            if (cellModel == null) {
                throw new IllegalStateException("null MapChartCellModel not supported.");
            }
            this.cellModel = cellModel;
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            Variable[] animationKeyFrameVariables = dataSource.getVariable(cellModel.getAnimationKeyFrameRole());
            Variable idVariable = dataSource.getVariable(cellModel.getIDRole(), 0);
            if (animationKeyFrameVariables == null || idVariable == null) {
                this.animationKeyFrameRole = null;
                this.animationIDRole = null;
            } else {
                this.animationKeyFrameRole = cellModel.getAnimationKeyFrameRole();
                this.animationIDRole = cellModel.getIDRole();
            }
            this.dataSource = dataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode));
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                if (this.animationKeyFrameRole != null && this.animationIDRole != null) {
                    cellDataSource = cellDataSource.newAnimationDataSource(this.animationKeyFrameRole, this.animationIDRole);
                }
                return new MapChartCell(this.cellModel, cellDataSource, columnNode, rowNode, MapChartMatrix.this.getChannel(), MapChartMatrix.this.actionProvider);
            }
            return null;
        }
    }

    private class MapCellFactory
    implements Matrix.CellFactoryInterface,
    Matrix.CellFactoryInterface2 {
        private MapCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            if (dataSource != null && dataSource.length > 0) {
                return new MapChartCell((MapChartCellModel)cellModel, dataSource[0], null, null, channel, MapChartMatrix.this.actionProvider);
            }
            return null;
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Matrix.MatrixInfo matrixInfo, Channel channel) {
            if (dataSource != null && dataSource.length > 0) {
                if (matrixInfo != null) {
                    return new MapChartCell((MapChartCellModel)cellModel, dataSource[0], matrixInfo.getColumnOrdinal(), matrixInfo.getRowOrdinal(), channel, MapChartMatrix.this.actionProvider);
                }
                return new MapChartCell((MapChartCellModel)cellModel, dataSource[0], null, null, channel, MapChartMatrix.this.actionProvider);
            }
            return null;
        }
    }
}

