/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.mapchart;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.mapchart.MapChartModel;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.GenericActionProviderView;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.mapchart.CompositePipe;
import com.sas.graphics.util.cell.mapchart.EsriIdToCompositeId;
import com.sas.graphics.util.cell.mapchart.MapChartCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Annotation;
import com.sas.graphics.util.gtk.gl.AnnotationSelectDetail;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.gtk.gl.SpatialFeatureCache;
import com.sas.graphics.util.gtk.gl.SpatialMap;
import com.sas.measures.BaseLength;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.util.ActionList;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;

public class MapChartCell
extends Cell
implements ChartImageMapInfo.ChartImageMapInfoAuthorInterface {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "MapChartCell.";
    private static final BaseLength MINIMUM_SIZE = new BaseLength(8.0, "pt");
    private final DataSource dataSource;
    private final MapChartCellModel cellModel;
    private final CompositePipe compositeIDPipe;
    private final NumericVariable numericIDVariable;
    private final StringVariable stringIDVariable;
    private final Variable[] idVariableArray;
    private final Variable[] colorVariableArray;
    private final Variable[] extrusionVariableArray;
    private final Variable[] dataTipVariableArray;
    private final Variable[] auxiliaryVariableArray;
    private final NumericVariable selectionVariable;
    private final Object IDRole;
    private final Object colorRole;
    private final Object extrusionRole;
    private final Object selectionRole;
    private final Object dataTipRole;
    private final Object auxiliaryRole;
    private ColorMapper[] colorMapperArray;
    private NumericMapper[] heightMapperArray;
    private GridInCell mapGrid = null;
    private int numMapElements = 0;
    private boolean showAllMapFeatures;
    private boolean needUpdateView = true;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private SpatialFeatureCache mapCache = null;
    private SpatialMap[] myMap;
    private final BoundingBox dataBox = new BoundingBox();
    private final ValueList columnValueList;
    private final ValueList rowValueList;
    private SwingActionProvider actionProvider;
    private final ActionUIFactory actionUIFactory;
    private final ActionSupportFilter actionSupportFilter;
    private final GenericActionProviderView actionProviderView;
    private List annotationElementList = new ArrayList();
    private OLAPDataSetInterface olapDataSet;
    HashMap actionSupportFilterAttributes = null;

    public MapChartCell(MapChartCellModel newCellModel, DataSource newDataSource, Object columnOrdinal, Object rowOrdinal, Channel channel, SwingActionProvider newActionProvider) {
        super(newCellModel, channel);
        this.setOpaque(false);
        if (newDataSource == null) {
            throw new IllegalArgumentException("null dataSource not allowed");
        }
        if (newCellModel == null) {
            throw new IllegalArgumentException("null cell-model not allowed");
        }
        this.cellModel = newCellModel;
        this.dataSource = newDataSource;
        this.actionProvider = newActionProvider;
        if (this.dataSource.isAnimationEnabled()) {
            this.setDoubleBufferPolicy(10202);
        }
        this.mapCache = this.cellModel.getSpatialFeatureCache();
        Boolean showAll = this.cellModel.getAllFeaturesVisible();
        if (showAll != null) {
            this.showAllMapFeatures = showAll;
        }
        this.setAntiAliasingEnabled(this.cellModel.getMapChartModel().isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(this.cellModel.getMapChartModel().isAntialiasedText());
        this.setSelectionModel(this.dataSource.getDataSourceSelectionModel());
        this.columnValueList = Util.DataTreeGroupNodeUtil.toValueList(columnOrdinal);
        this.rowValueList = Util.DataTreeGroupNodeUtil.toValueList(rowOrdinal);
        if (this.actionProvider != null) {
            this.actionUIFactory = new ActionUIFactory();
            this.actionProviderView = new GenericActionProviderView(this);
            this.actionSupportFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "COLUMN_HEADER_AREA", (ActionProviderViewInterface)this.actionProviderView);
            this.addOlapActionMouseListener();
        } else {
            this.actionUIFactory = null;
            this.actionProviderView = null;
            this.actionSupportFilter = null;
        }
        MapChartCellModel cellModel = (MapChartCellModel)this.getModel();
        this.IDRole = cellModel.getIDRole();
        this.colorRole = cellModel.getColorRole();
        this.extrusionRole = cellModel.getExtrusionRole();
        this.selectionRole = cellModel.getSelectionRole();
        this.dataTipRole = cellModel.getDataTipRole();
        this.auxiliaryRole = cellModel.getAuxiliaryRole();
        this.idVariableArray = this.dataSource.getVariable(this.IDRole);
        this.colorVariableArray = this.dataSource.getVariable(this.colorRole);
        this.extrusionVariableArray = this.dataSource.getVariable(this.extrusionRole);
        this.selectionVariable = (NumericVariable)this.dataSource.getVariable(this.selectionRole, 0);
        this.dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, this.dataTipRole);
        this.auxiliaryVariableArray = Util.getGTKVariableArray(this.dataSource, this.auxiliaryRole);
        this.numMapElements = Math.max(this.colorVariableArray == null ? 0 : this.colorVariableArray.length, this.extrusionVariableArray == null ? 0 : this.extrusionVariableArray.length);
        if (this.idVariableArray == null || this.idVariableArray.length == 0) {
            throw new IllegalStateException("ID variable is required");
        }
        if (this.idVariableArray.length > 1) {
            this.compositeIDPipe = new CompositePipe();
            for (int i = 0; i < this.idVariableArray.length; ++i) {
                if (this.idVariableArray[i] instanceof StringVariable) {
                    this.compositeIDPipe.addInput((Pipe)((StringVariable)this.idVariableArray[i]).value);
                    continue;
                }
                this.compositeIDPipe.addInput((Pipe)((NumericVariable)this.idVariableArray[i]).value);
            }
            this.stringIDVariable = null;
            this.numericIDVariable = null;
        } else if (this.idVariableArray[0] instanceof StringVariable) {
            this.stringIDVariable = (StringVariable)this.idVariableArray[0];
            this.compositeIDPipe = null;
            this.numericIDVariable = null;
        } else {
            this.numericIDVariable = (NumericVariable)this.idVariableArray[0];
            this.compositeIDPipe = null;
            this.stringIDVariable = null;
        }
    }

    private void addOlapActionMouseListener() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PickInfo pickInfo;
                if (e != null && (pickInfo = MapChartCell.this.pick(e.getX(), e.getY())) != null) {
                    int valueIndex = pickInfo.getObservationIndex();
                    StringVariable idVar = (StringVariable)MapChartCell.this.idVariableArray[0];
                    try {
                        String v = idVar.value.getValue(valueIndex);
                        OLAPLevelVariable rootIdVariable = (OLAPLevelVariable)idVar.getRootVariable();
                        TupleElementInterface tupleElement = rootIdVariable.getTupleElement(v);
                        MapChartCell.this.setupOlapActions(tupleElement);
                        MapChartCell.this.performOLAPAction(e);
                    }
                    catch (MissingValueException e1) {
                        e1.printStackTrace();
                    }
                    return;
                }
            }
        };
        this.addMouseListener(ml);
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.dataSource.isAnimationEnabled() && this.dataSource.setAnimationPosition(animationPosition)) {
            this.repaint();
        }
    }

    @Override
    protected synchronized void construct() {
        int ii;
        this.getNetworkRoot().removeAllElements();
        MapChartCellModel cellModel = (MapChartCellModel)this.getModel();
        MapChartModel graphModel = cellModel.getMapChartModel();
        if (!(this.colorVariableArray != null && this.colorVariableArray.length != 0 || this.extrusionVariableArray != null && this.extrusionVariableArray.length != 0)) {
            return;
        }
        ColorMapper[] modelColorMapper = cellModel.getColorMapper();
        this.colorMapperArray = new ColorMapper[this.numMapElements];
        for (ii = 0; ii < this.numMapElements; ++ii) {
            Variable styleByVariable;
            Variable variable = styleByVariable = this.colorVariableArray != null && this.colorVariableArray.length > ii && this.colorVariableArray[ii] != null ? this.colorVariableArray[ii] : this.extrusionVariableArray[ii];
            if (modelColorMapper[ii] instanceof ContinuousRangeToColorMapper) {
                ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                crtcm.shareMap((ContinuousRangeToColorMapper)modelColorMapper[ii]);
                crtcm.input.connectFrom(((NumericVariable)styleByVariable).value);
                this.colorMapperArray[ii] = crtcm;
                continue;
            }
            if (modelColorMapper[ii] instanceof StringToColorMapper) {
                StringToColorMapper stcm = new StringToColorMapper();
                stcm.shareMap((StringToColorMapper)modelColorMapper[ii]);
                stcm.input.connectFrom(((StringVariable)styleByVariable).formattedValue);
                this.colorMapperArray[ii] = stcm;
                continue;
            }
            if (!(modelColorMapper[ii] instanceof DiscreteRangeToColorMapper)) continue;
            DiscreteRangeToColorMapper drtcm = new DiscreteRangeToColorMapper();
            drtcm.shareMap((DiscreteRangeToColorMapper)modelColorMapper[ii]);
            drtcm.input.connectFrom(((NumericVariable)styleByVariable).value);
            this.colorMapperArray[ii] = drtcm;
        }
        if (this.extrusionVariableArray != null && this.extrusionVariableArray.length > 0) {
            NumericMapper[] modelHeightMapper = cellModel.getHeightMapper();
            this.heightMapperArray = new NumericMapper[this.numMapElements];
            for (int ii2 = 0; ii2 < this.numMapElements; ++ii2) {
                if (this.extrusionVariableArray.length <= ii2 || this.extrusionVariableArray[ii2] == null) continue;
                if (modelHeightMapper[ii2] instanceof ContinuousRangeToNumericMapper) {
                    ContinuousRangeToNumericMapper crtnm = new ContinuousRangeToNumericMapper();
                    crtnm.shareMap((ContinuousRangeToNumericMapper)modelHeightMapper[ii2]);
                    crtnm.input.connectFrom(((NumericVariable)this.extrusionVariableArray[ii2]).value);
                    this.heightMapperArray[ii2] = crtnm;
                    continue;
                }
                if (!(modelHeightMapper[ii2] instanceof StringToNumericMapper)) continue;
                StringToNumericMapper stnm = new StringToNumericMapper();
                stnm.shareMap((StringToNumericMapper)modelHeightMapper[ii2]);
                stnm.input.connectFrom(((StringVariable)this.extrusionVariableArray[ii2]).value);
                this.heightMapperArray[ii2] = stnm;
            }
        }
        this.myMap = new SpatialMap[this.numMapElements];
        this.computeDataBox();
        this.mapGrid = new GridInCell(this.numMapElements, graphModel.getAcross(), graphModel.getDown(), this.dataBox, this.getBounds());
        for (ii = 0; ii < this.numMapElements; ++ii) {
            this.myMap[ii] = this.createAndInitMapElement(ii);
            Vec3d translate = this.mapGrid.getMinimum(ii);
            Composite c = new Composite();
            this.getNetworkRoot().addElement((Element)c);
            c.transform.translateX.setValue(translate.x);
            c.transform.translateY.setValue(translate.y);
            if (this.extrusionVariableArray != null && this.extrusionVariableArray.length > 0) {
                c.transform.rotationAxisX.setValue(1.0);
                c.transform.rotationAxisY.setValue(0.0);
                c.transform.rotationAxisZ.setValue(0.0);
                c.transform.rotationAngle.setValue(-0.5);
            }
            c.transform.centerX.setValue(0.0);
            c.transform.centerY.setValue(translate.y);
            c.transform.centerZ.setValue(0.0);
            c.addElement((Element)this.myMap[ii]);
            TableModel annotationData = cellModel.getAnnotationDataModel().getModel();
            if (annotationData == null) continue;
            Annotation annotation = new Annotation();
            annotation.setDataBounds(this.dataBox);
            this.annotationElementList.add(annotation);
            annotation.connectAnnotationElement(annotationData);
            c.addElement((Element)annotation);
        }
    }

    private void disposeAnnotationElements() {
        for (int i = 0; i < this.annotationElementList.size(); ++i) {
            Annotation a = (Annotation)this.annotationElementList.get(i);
            a.dispose();
        }
        this.annotationElementList.clear();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeAnnotationElements();
    }

    private void computeDataBox() {
        if (this.showAllMapFeatures) {
            this.dataBox.union(this.mapCache.getBoundingBox());
        } else {
            Pipe p = this.computeIdPipe();
            StringPipe sp = null;
            NumericPipe np = null;
            if (p instanceof NumericPipe) {
                np = (NumericPipe)p;
            } else {
                sp = (StringPipe)p;
            }
            InitAction action = new InitAction(this.getChannel());
            p.init((AInitAction)action);
            for (int i = 0; i < action.getValueCount(); ++i) {
                SpatialFeatureCache.FeatureInterface feature;
                try {
                    feature = np != null ? this.mapCache.getFeature(np.getValue(i)) : this.mapCache.getFeature((Object)sp.getValue(i).trim());
                }
                catch (MissingValueException mve) {
                    continue;
                }
                if (feature == null) continue;
                this.dataBox.union(feature.getBoundingBox());
            }
        }
    }

    private Pipe computeIdPipe() {
        StringPipe result = null;
        if (this.compositeIDPipe != null) {
            result = this.compositeIDPipe.value;
        } else if (this.stringIDVariable != null && this.stringIDVariable.isConnected()) {
            if (this.dataSource.isOLAPData()) {
                EsriIdToCompositeId converter = new EsriIdToCompositeId();
                converter.input.connectFrom(this.stringIDVariable.value);
                result = converter.value;
            } else {
                result = this.stringIDVariable.value;
            }
        } else {
            result = this.numericIDVariable.value;
        }
        return result;
    }

    private SpatialMap createAndInitMapElement(int i) {
        LineStyle ls;
        Pipe idPipe;
        MapChartModel graphModel = this.cellModel.getMapChartModel();
        Variable styleByVariable = this.colorVariableArray != null && this.colorVariableArray.length > i && this.colorVariableArray[i] != null ? this.colorVariableArray[i] : this.extrusionVariableArray[i];
        boolean extrusionValid = this.extrusionVariableArray != null && this.extrusionVariableArray.length > i && this.extrusionVariableArray[i] != null;
        SpatialMap map = new SpatialMap(this.cellModel.getSpatialFeatureCache());
        map.color.connectFrom(this.colorMapperArray[i].value);
        map.extrudeOn.setValue(extrusionValid);
        if (extrusionValid) {
            map.extrudeHeight.connectFrom(this.heightMapperArray[i].value);
        }
        if ((idPipe = this.computeIdPipe()) instanceof StringPipe) {
            map.stringID.connectFrom((StringPipe)idPipe);
        } else {
            map.id.connectFrom((NumericPipe)idPipe);
        }
        map.setAllFeaturesVisible(this.showAllMapFeatures);
        Color selColor = graphModel.getBrushModel().getSelectionColor();
        Color highlightColor = new Color(selColor.getRed(), selColor.getGreen(), selColor.getBlue(), selColor.getAlpha());
        map.highlightColor.setValue(highlightColor);
        map.highlightOn.connectFrom(this.selectionVariable.value);
        FillStyle fs = graphModel.getEmptyFillStyle();
        if (fs.isVisible()) {
            int fillType = fs.getFillType();
            switch (fillType) {
                case 20000: {
                    map.setEmptyColor(fs.getSolidFillColor());
                    break;
                }
                case 20002: 
                case 20003: {
                    if (fs.getImageIcon() == null || fs.getImageIcon().getImage() == null) break;
                    map.setEmptyTextureMode(fillType == 20003 ? 3 : 2);
                    map.setEmptyTextureFit(fs.getImageFill() == 20200 ? 4 : 5);
                    map.setEmptyTextureImage(fs.getImageIcon().getImage());
                    if (fillType != 20003) break;
                    map.setEmptyColor(fs.getSolidBlendColor());
                }
            }
        }
        if ((ls = graphModel.getEmptyOutlineLineStyle()) == null) {
            ls = graphModel.getDataElementStyles().getOutlineLineStyle();
        }
        map.setEmptyEdgeVisible(ls.getVisibilityPolicy() != 10202);
        map.setEmptyEdgeColor(ls.getColor());
        map.setEmptyEdgeThickness(ls.getThickness().getMagnitude((Object)"px"));
        if (ls instanceof StrokeLineStyle) {
            map.setEmptyEdgePattern(((StrokeLineStyle)ls).getSASGraphLineStyle() - 30000);
        }
        ls = graphModel.getDataElementStyles().getOutlineLineStyle();
        map.edgeOn.setValue(ls.getVisibilityPolicy() != 10202);
        map.edgeThickness.setValue(ls.getThickness().getMagnitude((Object)"px"));
        map.edgeColor.setValue(ls.getColor());
        if (ls instanceof StrokeLineStyle) {
            map.edgePattern.setValue(((StrokeLineStyle)ls).getSASGraphLineStyle() - 30000);
        }
        int selectionOptions = this.selectionVariable != null ? 7 : 5;
        Util.SelectInfo.selectEnable((Element)map, styleByVariable, selectionOptions);
        return map;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = this.cellModel.getPreferredSize();
        if (this.mapGrid == null || prefSize == null) {
            return prefSize != null ? prefSize : new Dimension(640, 480);
        }
        double mapRatio = this.mapGrid.getSize().y / this.mapGrid.getSize().x;
        if (prefSize.width > prefSize.height) {
            return new Dimension(prefSize.width, (int)Math.round((double)prefSize.width * mapRatio));
        }
        return new Dimension((int)Math.round((double)prefSize.height * mapRatio), prefSize.height);
    }

    @Override
    public Dimension getMinimumSize() {
        int px = (int)MINIMUM_SIZE.getMagnitude((Object)"px");
        if (this.mapGrid != null) {
            return new Dimension(this.mapGrid.getCols() * 10 * px, this.mapGrid.getRows() * 10 * px);
        }
        return new Dimension(px, px);
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        Channel ch = this.getChannel();
        if (this.mapGrid == null) {
            return;
        }
        if (this.needUpdateView) {
            this.updateView();
            super.invalidateBuffer();
        }
        ch.glOrtho(this.xMin, this.xMax, this.yMin, this.yMax, -10.0, 10.0);
    }

    @Override
    protected void paintComponentImpl(Graphics g) {
        this.updateChannel();
        this.setAnnotationsVisible(false);
        super.paintComponentImpl(g);
        if (this.extrusionVariableArray == null) {
            g.setPaintMode();
            this.setOnlyDrawHighlightedRegions(true);
            this.getChannel().setSingleBufferGraphics(g);
        }
        this.setAnnotationsVisible(true);
        this.getNetworkRoot().draw();
        this.setOnlyDrawHighlightedRegions(false);
    }

    private void setOnlyDrawHighlightedRegions(boolean b) {
        for (int i = 0; i < this.myMap.length; ++i) {
            this.myMap[i].setOnlyDrawHighlightedRegions(b);
        }
    }

    private void setAnnotationsVisible(boolean b) {
        for (int i = 0; i < this.annotationElementList.size(); ++i) {
            ((Annotation)this.annotationElementList.get(i)).setVisible(b);
        }
    }

    private void updateView() {
        double cellRatio = this.getBounds().getHeight() / this.getBounds().getWidth();
        Vec3d range = this.mapGrid.getSize();
        Vec3d center = this.mapGrid.getCenter();
        double dataRatio = range.y / range.x;
        double xOffset = 0.0;
        double yOffset = 0.0;
        double border = 5.0;
        if (cellRatio > dataRatio) {
            double scale = range.x / this.getBounds().getWidth();
            double yUsed = range.y / scale;
            xOffset = range.x * 0.5;
            yOffset = (range.y + (this.getBounds().getHeight() - yUsed) * scale) * 0.5;
            border *= scale;
        } else {
            double scale = range.y / this.getBounds().getHeight();
            double xUsed = range.x / scale;
            yOffset = range.y * 0.5;
            xOffset = (range.x + (this.getBounds().getWidth() - xUsed) * scale) * 0.5;
            border *= scale;
        }
        this.xMin = center.x - xOffset - border;
        this.xMax = center.x + xOffset + border;
        this.yMin = center.y - yOffset - border;
        this.yMax = center.y + yOffset + border;
        this.needUpdateView = false;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.needUpdateView = true;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ChartImageMapInfo getChartImageMapInfo() {
        if (this.dataSource.getValueCount() < 1) {
            return null;
        }
        this.updateChannel();
        ChartImageMapInfo2 mapChartImageMapInfo = null;
        Vector selectableShapes = this.getNetworkRoot().computeSelectableShapes();
        if (selectableShapes == null) {
            return null;
        }
        int count = selectableShapes.size();
        ArrayList<ChartValueZone> dataElementValueZonesAL = new ArrayList<ChartValueZone>();
        ArrayList<ChartValueZone> annotationValueZonesAL = new ArrayList<ChartValueZone>();
        for (int ii = 0; ii < count; ++ii) {
            ValueList auxiliaryValueList;
            ValueList dataTipValueList;
            ValueList extrusionValueList;
            ValueList colorValueList;
            ValueList IDValueList;
            SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
            SelectResult sr = selectableShape.getSelectResult();
            Element element = sr.getElement();
            int obsIndex = sr.getValueIndex();
            if (element instanceof SpatialMap) {
                IDValueList = GTKUtil.toValueList(this.idVariableArray, obsIndex);
                colorValueList = null;
                extrusionValueList = null;
                dataTipValueList = null;
                auxiliaryValueList = null;
                if (this.colorVariableArray != null && this.colorVariableArray.length > 0) {
                    colorValueList = GTKUtil.toValueList(this.colorVariableArray, obsIndex);
                }
                if (this.extrusionVariableArray != null && this.extrusionVariableArray.length > 0) {
                    extrusionValueList = GTKUtil.toValueList(this.extrusionVariableArray, obsIndex);
                }
                if (this.dataTipVariableArray != null && this.dataTipVariableArray.length > 0) {
                    dataTipValueList = GTKUtil.toValueList(this.dataTipVariableArray, obsIndex);
                }
                if (this.auxiliaryVariableArray != null && this.auxiliaryVariableArray.length > 0) {
                    auxiliaryValueList = GTKUtil.toValueList(this.auxiliaryVariableArray, obsIndex);
                }
                ChartValueZone elementValueZone = new ChartValueZone(selectableShape.getShape(), this.columnValueList, this.rowValueList, IDValueList, null, colorValueList, extrusionValueList, dataTipValueList, auxiliaryValueList);
                dataElementValueZonesAL.add(elementValueZone);
                continue;
            }
            if (!(element instanceof Annotation)) continue;
            IDValueList = null;
            colorValueList = null;
            extrusionValueList = null;
            dataTipValueList = null;
            auxiliaryValueList = null;
            AnnotationSelectDetail asd = (AnnotationSelectDetail)sr.getDetail();
            String htmlString = asd.getHtml();
            if (htmlString.length() <= 0) continue;
            ChartValueZone elementValueZone = new ChartValueZone(selectableShape.getShape(), this.columnValueList, this.rowValueList, IDValueList, null, colorValueList, extrusionValueList, dataTipValueList, auxiliaryValueList, htmlString);
            annotationValueZonesAL.add(elementValueZone);
        }
        ChartValueZone[] dataElementValueZones = dataElementValueZonesAL.toArray(new ChartValueZone[0]);
        ChartValueZone[] annotationValueZones = annotationValueZonesAL.toArray(new ChartValueZone[0]);
        mapChartImageMapInfo = new ChartImageMapInfo2(null, null, null, null, dataElementValueZones, annotationValueZones, null, null, null, null, null, null);
        mapChartImageMapInfo.source = this;
        return mapChartImageMapInfo;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return new PickInfo(this.getLabelValuePairs(obsIndex), obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    private void performOLAPAction(MouseEvent e) {
        try {
            if (this.actionProvider != null) {
                this.actionSupportFilter.setAttribute("model", (Object)this.olapDataSet);
                this.actionSupportFilter.setAttributes((Map)this.actionSupportFilterAttributes);
                com.sas.actionprovider.ActionList actions = this.actionProvider.getActions(this.actionSupportFilter);
                JPopupMenu popup = this.actionUIFactory.getPopupMenu((ActionList)actions);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        catch (AttributeSetException exp) {
            exp.printStackTrace();
        }
    }

    private void setupOlapActions(TupleElementInterface tupleElement) {
        OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)this.dataSource.getModel();
        if (olapDataSet instanceof GraphOLAPDataSet) {
            olapDataSet = ((GraphOLAPDataSet)olapDataSet).getDelegateModel();
        }
        this.actionSupportFilterAttributes = new HashMap();
        this.actionSupportFilterAttributes.put("tupleElement", tupleElement);
        this.actionSupportFilterAttributes.put("isMeasure", Boolean.FALSE);
        this.actionSupportFilterAttributes.put("model", olapDataSet);
        if (olapDataSet instanceof BusinessQueryToOLAPDataSetAdapter) {
            try {
                Method getBusinessQueryMethod = olapDataSet.getClass().getMethod("getBusinessQuery", null);
                Object businessQuery = getBusinessQueryMethod.invoke((Object)olapDataSet, null);
                Class<?> olapCellRendererManagerClass = Class.forName("com.sas.swing.visuals.olaptableview.OLAPCellRendererManager");
                Class[] classes = new Class[]{Class.forName("com.sas.iquery.metadata.business.BusinessQuery"), TupleElementInterface.class};
                Method findDataItemMethod = olapCellRendererManagerClass.getMethod("findDataItem", classes);
                Object dataItem = findDataItemMethod.invoke(null, businessQuery, tupleElement);
                this.actionSupportFilterAttributes.put("dataItem", dataItem);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private Vector[] getLabelValuePairs(int obsIndex) {
        Vector labelValuePairs = new Vector();
        boolean graphDataIsVisible = this.dataTipVariableArray == null || this.dataTipVariableArray.length <= 0 || this.dataTipVariableArray[0] == null || this.cellModel.getMapChartModel().getDataTipModel().getContent() != 11401;
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.IDRole, this.idVariableArray, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.colorRole, this.colorVariableArray, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.extrusionRole, this.extrusionVariableArray, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.dataTipRole, this.dataTipVariableArray, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.auxiliaryRole, this.auxiliaryVariableArray, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    class GridInCell
    extends BoundingBox {
        private int mapsInGrid;
        private int across;
        private int down;
        private int cols;
        private int rows;
        private BoundingBox orig;
        final double separation = 1.05;

        public GridInCell(int total, int a, int d, BoundingBox db, Rectangle sb) {
            super(db);
            this.across = 0;
            this.down = 0;
            this.cols = 0;
            this.rows = 0;
            this.separation = 1.05;
            this.mapsInGrid = total;
            this.across = a;
            this.down = d;
            this.orig = db;
            if (this.across > 0 && this.down > 0) {
                if (this.across * this.down < this.mapsInGrid) {
                    if (this.across > this.down) {
                        this.down = 0;
                    } else {
                        this.across = 0;
                    }
                } else {
                    this.cols = this.across;
                    this.rows = this.down;
                    return;
                }
            }
            if (this.mapsInGrid == 1) {
                this.rows = 1;
                this.cols = 1;
            } else if (this.across > 0 && this.down == 0) {
                this.cols = this.across;
                this.rows = (int)Math.ceil((double)this.mapsInGrid / (double)this.across);
            } else if (this.down > 0 && this.across == 0) {
                this.rows = this.down;
                this.cols = (int)Math.ceil((double)this.mapsInGrid / (double)this.down);
            } else {
                double cellRatio = sb.getHeight() / sb.getWidth();
                double dataRatio = db.getSize().y / db.getSize().x;
                double ratio = dataRatio / cellRatio * (double)this.mapsInGrid;
                this.cols = (int)Math.max(1.0, Math.floor(Math.sqrt(Math.floor(Math.sqrt(ratio)) + ratio)));
                this.rows = (int)Math.ceil((double)this.mapsInGrid / (double)this.cols);
                this.cols = (int)Math.ceil((double)this.mapsInGrid / (double)this.rows);
            }
            Vec3d v = new Vec3d(this.getMaximum().x + this.getSize().x * (double)(this.cols - 1) * 1.05, this.getMaximum().y + this.getSize().y * (double)(this.rows - 1) * 1.05, 0.0);
            this.union(v);
        }

        int getRows() {
            return this.rows;
        }

        int getCols() {
            return this.cols;
        }

        Vec3d getMinimum(int mapNo) {
            if (mapNo >= this.mapsInGrid) {
                return null;
            }
            int row = (int)Math.floor((double)mapNo / (double)this.cols);
            int col = mapNo % this.cols;
            return new Vec3d(this.orig.getSize().x * (double)col * 1.05, this.orig.getSize().y * (double)row * 1.05, 0.0);
        }
    }
}

