/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.kpichart;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.kpichart.KPIChartSegmentedRangeColorModel;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.kpichart.KPIChartCell;
import com.sas.graphics.util.cell.kpichart.KPIChartCellModel;
import com.sas.graphics.util.cell.kpichart.KPIChartMatrixContainer;
import com.sas.graphics.util.cell.kpichart.KPIChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.render.kpi.KPIChartCache;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class KPIChartMatrix
extends Matrix {
    private transient KPIChartMatrixModel model;
    private transient KPIChartCellModel kpiCellModel;
    private transient KPIChartMatrixContainer matrixContainer;
    private transient ArrayList cells;
    KPIChartCache imageCache = new KPIChartCache();

    public KPIChartMatrix(Channel channel) {
        this(null, channel);
    }

    public KPIChartMatrix(KPIChartMatrixModel model, Channel channel) {
        super(channel);
        this._setModel(model);
    }

    public void setModel(KPIChartMatrixModel newModel) {
        this._setModel(newModel);
    }

    public KPIChartMatrixModel getModel() {
        return this.model;
    }

    private void _setModel(KPIChartMatrixModel newModel) {
        if (this.model != newModel) {
            this.model = newModel;
            this.reconstruct();
        }
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        this.cells = null;
    }

    @Override
    protected synchronized void construct() {
        DataSource dataSource;
        KPIChartMatrixModel matrixModel = this.getModel();
        if (matrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        if (matrixModel.getGraphModel() != null) {
            this.setAntialiasedTextEnabled(matrixModel.getGraphModel().isAntialiasedText());
        }
        if ((dataSource = this.getDataSource()) == null) {
            return;
        }
        Variable actualVariable = dataSource.getVariable(matrixModel.getActualRole(), 0);
        if (actualVariable == null) {
            throw new IllegalStateException(RB.getStringResource("actualVariableNotSpecified.ex.txt"));
        }
        if (actualVariable.getValueCount() < 1) {
            return;
        }
        KPIChartSegmentedRangeColorModel colorModel = matrixModel.getGraphModel().getSegmentedRangeColorModel();
        if (colorModel == null) {
            throw new IllegalStateException(RB.getStringResource("segmentedRangeNotSpecified.ex.txt"));
        }
        Color[] segmentColors = colorModel.getSegmentColors();
        SegmentedRangeModel segmentValues = colorModel.getSegmentedRangeModel();
        if (segmentColors == null || segmentValues == null) {
            throw new IllegalStateException(RB.getStringResource("invalidSegmentedRange.ex.txt"));
        }
        double[] values = segmentValues.getSegmentedRange();
        if (values.length != segmentColors.length + 1) {
            throw new IllegalStateException(RB.getStringResource("invalidSegmentedRange.ex.txt"));
        }
        matrixModel.setRowModel(matrixModel.getGraphModel().getRowAxisModel());
        matrixModel.setColumnModel(matrixModel.getGraphModel().getColumnAxisModel());
        this.kpiCellModel = new KPIChartCellModel();
        this.kpiCellModel.setAnimationKeyFrameRole(matrixModel.getAnimationKeyFrameRole());
        this.kpiCellModel.setActualRole(matrixModel.getActualRole());
        this.kpiCellModel.setSelectionRole(matrixModel.getSelectionRole());
        this.kpiCellModel.setGraphModel(matrixModel.getGraphModel());
        this.kpiCellModel.setRuleTargetIdentifier(matrixModel.getRuleTargetIdentifier());
        this.kpiCellModel.setAntialiasedGraphics(new Boolean(matrixModel.getGraphModel().isAntialiasedGraphics()));
        this.kpiCellModel.setAntialiasedText(new Boolean(matrixModel.getGraphModel().isAntialiasedText()));
        this.cells = this.addMatrixCellComponents(this.kpiCellModel, new DataSource[]{dataSource});
    }

    @Override
    protected List getCells() {
        return this.cells;
    }

    @Override
    public Insets getPreferredMargin(int w, int h) {
        if (this.dataSource != null && this.model != null && (this.dataSource.getVariable(this.model.getRowRole(), 0) != null || this.dataSource.getVariable(this.model.getColumnRole(), 0) != null)) {
            return super.getPreferredMargin(w, h);
        }
        return new Insets(0, 0, 0, 0);
    }

    public ChartImageMapInfo2[] getImageMapInfo() {
        return null;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.cells != null) {
            for (int ii = 0; ii < this.cells.size(); ++ii) {
                ((KPIChartCell)this.cells.get(ii)).setAnimationFrame(animationPosition);
            }
        }
    }

    protected ArrayList addMatrixCellComponents(SimpleModelInterface cellModel, DataSource[] dataSource) {
        Container parent;
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        ArrayList<Component> cells = new ArrayList<Component>();
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        KPIChartMatrixModel kpiMatrixModel = (KPIChartMatrixModel)this.getMatrixModel();
        this.matrixContainer = new KPIChartMatrixContainer(kpiMatrixModel, dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), new KPICellComponentFactory(this.kpiCellModel, dataSource[0]), actionProvider, false, this.graphModel.isAntialiasedGraphics(), this.graphModel.isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    private class KPICellComponentFactory
    implements CellPane.CellComponentFactory {
        private final DataSource dataSource;
        private final KPIChartCellModel cellModel;
        private final Object animationKeyFrameRole;

        public KPICellComponentFactory(KPIChartCellModel cellModel, DataSource dataSource) {
            if (cellModel == null) {
                throw new IllegalStateException("null KPICellModel not supported.");
            }
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            Variable[] animationKeyFrameVariables = dataSource.getVariable(cellModel.getAnimationKeyFrameRole());
            this.animationKeyFrameRole = animationKeyFrameVariables == null ? null : cellModel.getAnimationKeyFrameRole();
            this.cellModel = cellModel;
            this.dataSource = dataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode));
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                if (this.animationKeyFrameRole != null) {
                    cellDataSource = cellDataSource.newAnimationDataSource(this.animationKeyFrameRole, null);
                }
                KPIChartCell kpiChartCell = new KPIChartCell(this.cellModel, cellDataSource, columnNode, rowNode, KPIChartMatrix.this.getChannel());
                kpiChartCell.setImageCache(KPIChartMatrix.this.imageCache);
                return kpiChartCell;
            }
            return null;
        }
    }
}

