/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.ganttchart;

import com.sas.MissingValues;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.BrushModel;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphActionEvent;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TableAxisColumn;
import com.sas.graphics.components.TableAxisModel;
import com.sas.graphics.components.TableAxisZone;
import com.sas.graphics.components.TreeIconModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.ganttchart.GanttChartModel;
import com.sas.graphics.util.cell.AxisCell;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.CompoundTimeAxisCell;
import com.sas.graphics.util.cell.CompoundTimeAxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ganttchart.GanttChartCellModel;
import com.sas.graphics.util.cell.ganttchart.GanttChartComposite;
import com.sas.graphics.util.cell.ganttchart.GanttChartMatrixModel;
import com.sas.graphics.util.cell.ganttchart.GanttTableDataModel;
import com.sas.graphics.util.cell.ganttchart.GanttTreeTable;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.measures.BaseLength;
import com.sas.swing.visuals.treetable.CellAction;
import com.sas.swing.visuals.treetable.CellActionEvent;
import com.sas.swing.visuals.treetable.SasCellEditor;
import com.sas.swing.visuals.treetable.SasCellRenderer;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.text.SASFormat;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class GanttChartMatrix
extends Matrix {
    public static final String RB_KEY = "GanttChartMatrix.";
    com.sas.graphics.util.gtk.Variable earlyStartGtkVar = null;
    com.sas.graphics.util.gtk.Variable earlyFinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable lateStartGtkVar = null;
    com.sas.graphics.util.gtk.Variable lateFinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable resourceStartGtkVar = null;
    com.sas.graphics.util.gtk.Variable resourceFinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable actualStartGtkVar = null;
    com.sas.graphics.util.gtk.Variable actualFinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable custom1StartGtkVar = null;
    com.sas.graphics.util.gtk.Variable custom1FinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable custom2StartGtkVar = null;
    com.sas.graphics.util.gtk.Variable custom2FinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable baselineStartGtkVar = null;
    com.sas.graphics.util.gtk.Variable baselineFinishGtkVar = null;
    com.sas.graphics.util.gtk.Variable durationGtkVar = null;
    com.sas.graphics.util.gtk.Variable targetGtkVar = null;
    com.sas.graphics.util.gtk.Variable taskGtkVar = null;
    com.sas.graphics.util.gtk.Variable markerPosGtkVar = null;
    com.sas.graphics.util.gtk.Variable annoPosGtkVar = null;
    com.sas.graphics.util.gtk.Variable calendarGtkVar = null;
    private ArrayList componentVariableArrayList = null;
    private ArrayList componentSuccessorVariableArrayList = null;
    private transient GanttChartMatrixModel model;
    private double rangeMin = 0.0;
    private double rangeMax = 0.0;
    private transient GTKFormat dateAxisFormat;
    private int numLegendEntries;
    private int numSlackLegendEntries;
    private int taskIdx = -1;
    private transient Dimension margin = new Dimension(0, 0);
    private transient Insets outerMargin = new Insets(0, 0, 0, 0);
    private transient ArrayList ganttCells;
    private transient ArrayList depAxisCells;
    private transient GanttChartCellModel cellModel;
    private boolean dateAxisInsideCell = true;
    private boolean idAxisInsideCell = true;
    protected GanttTreeTable treeTable = null;
    private boolean treeTableHadFocus = false;
    protected int treeTableInitialDepth = Integer.MAX_VALUE;
    private ActionListener treeSortListener = null;
    private boolean inhibitTableSettings = false;
    private Object dataSourceTableModel = null;
    private GanttTableDataModel gcTableDataModel = null;
    private boolean emptyTableModel = false;
    private DataSource annoDataSource = null;
    private DataSource breaktimeDataSource = null;
    private GanttChartComposite.Memento lastValidMemento;
    private static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);
    private TableModel tableModel = null;
    private final transient ContinuousRangeToNumericMapper dependentAxisMapper = new ContinuousRangeToNumericMapper();
    private final transient DoubleClickToGraphActionRelay doubleClickListener = new DoubleClickToGraphActionRelay();
    private final transient CellActionRelay cellActionListener = new CellActionRelay();
    private final transient TableAxisModelToTreeTableRelay tamChangeListener = new TableAxisModelToTreeTableRelay();
    private Color[] colorByLegendColors;
    private String[] colorByLegendValues;
    private boolean isMilestoneLegendPresent = false;
    private boolean isTargetLegendPresent = false;
    private ActionListener linkListeners;
    private boolean sortEnabled = true;
    Dimension oldSize = null;
    String sasFormatName1 = null;

    public GanttChartMatrix(Channel channel) {
        super(channel);
    }

    public void setModel(GanttChartMatrixModel newModel) {
        if (this.model != newModel) {
            GanttChartMatrixModel oldModel = this.model;
            this.model = newModel;
            this.reconstruct();
            this.firePropertyChange("model", oldModel, newModel);
        }
    }

    public GanttChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    protected void cleanMatrixContainer() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = this.treeTableHadFocus = focusOwner == this.treeTable;
        if (this.ganttCells != null) {
            GanttChartComposite cell0 = (GanttChartComposite)this.ganttCells.get(0);
            if (cell0 != null) {
                if (cell0.isValidateTree()) {
                    this.lastValidMemento = cell0._getMemento();
                }
                cell0.dispose();
            }
            this.ganttCells = null;
        }
        super.cleanMatrixContainer();
        this.depAxisCells = null;
        this.cellModel = null;
    }

    @Override
    protected synchronized void construct() {
        boolean IdFound;
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            this.lastValidMemento = null;
            if (this.cellModel != null) {
                this.cellModel.setMemento(null);
            }
            throw new IllegalStateException(RB.getStringResource("dataSourceNotSpecified.ex.txt"));
        }
        this.cellModel = new GanttChartCellModel();
        if (this.lastValidMemento != null) {
            this.cellModel.setMemento(this.lastValidMemento);
        }
        if (this.componentVariableArrayList == null) {
            return;
        }
        GanttChartMatrixModel chartMatrixModel = this.getModel();
        if (chartMatrixModel == null) {
            return;
        }
        this.taskGtkVar = dataSource.getVariable(chartMatrixModel.getTaskRole(), 0);
        if (this.taskGtkVar == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "taskVariableNotSpecified.ex.txt"));
        }
        boolean bl = IdFound = dataSource.getVariable(chartMatrixModel.getTaskRole()) != null;
        if (!IdFound) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "taskVariableNotSpecified.ex.txt"));
        }
        this.earlyStartGtkVar = dataSource.getVariable(chartMatrixModel.getEarlyStartRole(), 0);
        this.earlyFinishGtkVar = dataSource.getVariable(chartMatrixModel.getEarlyFinishRole(), 0);
        this.lateStartGtkVar = dataSource.getVariable(chartMatrixModel.getLateStartRole(), 0);
        this.lateFinishGtkVar = dataSource.getVariable(chartMatrixModel.getLateFinishRole(), 0);
        this.resourceStartGtkVar = dataSource.getVariable(chartMatrixModel.getResourceStartRole(), 0);
        this.resourceFinishGtkVar = dataSource.getVariable(chartMatrixModel.getResourceFinishRole(), 0);
        this.actualStartGtkVar = dataSource.getVariable(chartMatrixModel.getActualStartRole(), 0);
        this.actualFinishGtkVar = dataSource.getVariable(chartMatrixModel.getActualFinishRole(), 0);
        this.custom1StartGtkVar = dataSource.getVariable(chartMatrixModel.getCustom1StartRole(), 0);
        this.custom1FinishGtkVar = dataSource.getVariable(chartMatrixModel.getCustom1FinishRole(), 0);
        this.custom2StartGtkVar = dataSource.getVariable(chartMatrixModel.getCustom2StartRole(), 0);
        this.custom2FinishGtkVar = dataSource.getVariable(chartMatrixModel.getCustom2FinishRole(), 0);
        this.baselineStartGtkVar = dataSource.getVariable(chartMatrixModel.getBaselineStartRole(), 0);
        this.baselineFinishGtkVar = dataSource.getVariable(chartMatrixModel.getBaselineFinishRole(), 0);
        this.durationGtkVar = dataSource.getVariable(chartMatrixModel.getDurationRole(), 0);
        this.targetGtkVar = dataSource.getVariable(chartMatrixModel.getTargetRole(), 0);
        this.markerPosGtkVar = dataSource.getVariable(chartMatrixModel.getMarkerPositionRole(), 0);
        this.calendarGtkVar = dataSource.getVariable(chartMatrixModel.getCalendarRole(), 0);
        if (this.annoDataSource != null) {
            this.annoPosGtkVar = this.annoDataSource.getVariable(chartMatrixModel.getAnnoPositionRole(), 0);
        }
        Boolean antialiasedGraphics = chartMatrixModel.getGanttChartModel().isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
        Boolean antialiasedText = chartMatrixModel.getGanttChartModel().isAntialiasedText() ? Boolean.TRUE : Boolean.FALSE;
        double depAxisLength = 100.0;
        CompoundTimeAxisModel depAxisModel = chartMatrixModel.getGanttChartModel().getDateAxisModel();
        CompoundTimeAxisCellModel dependentAxisCellModel = new CompoundTimeAxisCellModel();
        dependentAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
        dependentAxisCellModel.setAntialiasedText(antialiasedText);
        dependentAxisCellModel.setTimeAxisModel(depAxisModel);
        dependentAxisCellModel.setLength(new Double(depAxisLength));
        dependentAxisCellModel.setAxisOrientation("East");
        dependentAxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
        dependentAxisCellModel.setTitleOn(Boolean.FALSE);
        dependentAxisCellModel.setPrimary(Boolean.FALSE);
        Color[] c = depAxisModel.getValueCellStyle().getBackgroundColors();
        if (c != null && c.length > 0) {
            dependentAxisCellModel.setBackgroundColor(c[0]);
        }
        dependentAxisCellModel.setAxisColor(depAxisModel.getValueCellStyle().getFrameLineStyle().getColor());
        AxisModel indepAxisModel = new AxisModel();
        indepAxisModel.setReverseDirection(true);
        AxisCellModel independentAxisCellModel = new AxisCellModel();
        independentAxisCellModel.setLocale(dataSource.getLocale());
        double indepAxisOrigin = 0.0;
        TableAxisModel tableAxisModel = chartMatrixModel.getGanttChartModel().getTableAxisModel();
        int indepAxisTickStride = tableAxisModel.getValueTextStyle().getFont().getSize() + 2 * (int)chartMatrixModel.getGanttChartModel().getTableAxisModel().getCellPadding().getMagnitude((Object)"py");
        independentAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
        independentAxisCellModel.setAntialiasedText(antialiasedText);
        independentAxisCellModel.setAxisModel(indepAxisModel);
        independentAxisCellModel.setOrigin(new Double(indepAxisOrigin));
        independentAxisCellModel.setMajorTickInterval(new Double(indepAxisTickStride));
        independentAxisCellModel.setReferenceLinesVisible(Boolean.FALSE);
        independentAxisCellModel.setAxisOrientation("North");
        independentAxisCellModel.setMargin(this.margin);
        independentAxisCellModel.setMaximizeSpace(Boolean.FALSE);
        independentAxisCellModel.setAxisVisible(Boolean.FALSE);
        this.tableModel = (TableModel)dataSource.getModel();
        this.taskIdx = this.cellModel._findColumnIndex(this.taskGtkVar.getColumnName(), this.tableModel);
        boolean createNewTree = false;
        if (!com.sas.util.Util.equal((Object)this.dataSourceTableModel, (Object)dataSource.getModel())) {
            this.dataSourceTableModel = dataSource.getModel();
            createNewTree = this._createTable(this.dataSourceTableModel, chartMatrixModel.getGanttChartModel().getTableAxisModel(), dataSource.getSelectionModel(), dataSource.getLocale(), dataSource.getSortStrategy());
            boolean bl2 = this.emptyTableModel = !createNewTree;
        }
        if (this.emptyTableModel) {
            return;
        }
        BrushModel brushModel = chartMatrixModel.getGanttChartModel().getBrushModel();
        this.treeTable.setSelectionBackground(brushModel.getSelectionColor());
        this.treeTable.setSelectionForeground(brushModel.getSelectionAccentColor());
        this.treeTable.setRowSelectionAllowed(brushModel.isSelectionAllowed());
        this.treeTable.setColumnSelectionAllowed(false);
        this.treeTable.setRowHeight(indepAxisTickStride);
        this.treeTable.removeMouseListener(this.doubleClickListener);
        this.treeTable.addMouseListener(this.doubleClickListener);
        this.treeTable.removeLinkListener(this.cellActionListener);
        this.treeTable.addLinkListener(this.cellActionListener);
        this.tamChangeListener.setTableAxisModel(chartMatrixModel.getGanttChartModel().getTableAxisModel());
        this.dateAxisFormat = this._findValidDateAxisFormat();
        if (this.dateAxisFormat == null) {
            this.dateAxisFormat = dataSource.newLocalizedGTKFormat("DATE7.");
        }
        this.dependentAxisMapper.setFormat(this.dateAxisFormat);
        this._findDateAxisRange();
        this.dependentAxisMapper.setInputMin(this.rangeMin);
        this.dependentAxisMapper.setInputMax(this.rangeMax);
        dependentAxisCellModel.setMapper((NumericMapper)this.dependentAxisMapper);
        dependentAxisCellModel.setMargin(this.margin);
        BoundedRangeModel dateAxisScrollModel = this.model.getDateAxisScrollModel();
        BoundedRangeModel taskAxisScrollModel = this.model.getTaskAxisScrollModel();
        BoundedRangeModel tableColumnScrollModel = this.model.getTableColumnScrollModel();
        if (dateAxisScrollModel == null) {
            dateAxisScrollModel = new DefaultBoundedRangeModel();
            this.model.setDateAxisScrollModel(dateAxisScrollModel);
            this.cellModel.setInitializeDateAxisScrollBar(Boolean.TRUE);
        } else if (this.model.getInitializeDateAxisScrollModel() != null) {
            this.cellModel.setInitializeDateAxisScrollBar(this.model.getInitializeDateAxisScrollModel());
            this.model.setInitializeDateAxisScrollModel(null);
        }
        this.cellModel.setDateAxisScrollModel(dateAxisScrollModel);
        if (this.model.getTaskAxisScrollModel() == null || createNewTree) {
            taskAxisScrollModel = new DefaultBoundedRangeModel();
            this.model.setTaskAxisScrollModel(taskAxisScrollModel);
            this.cellModel.setInitializeTaskAxisScrollBar(Boolean.TRUE);
        }
        this.cellModel.setTaskAxisScrollModel(taskAxisScrollModel);
        if (this.model.getTableColumnScrollModel() == null) {
            tableColumnScrollModel = new DefaultBoundedRangeModel();
            this.model.setTableColumnScrollModel(tableColumnScrollModel);
            this.cellModel.setInitializeTableColumnScrollBar(Boolean.TRUE);
        }
        this.cellModel.setTableColumnScrollModel(tableColumnScrollModel);
        this.cellModel.setAntialiasedGraphics(antialiasedGraphics);
        this.cellModel.setAntialiasedText(antialiasedText);
        this.cellModel.setTaskRole(chartMatrixModel.getTaskRole());
        this.cellModel.setSuccessorRole(chartMatrixModel.getSuccessorRole());
        this.cellModel.setEarlyStartRole(chartMatrixModel.getEarlyStartRole());
        this.cellModel.setEarlyFinishRole(chartMatrixModel.getEarlyFinishRole());
        this.cellModel.setLateStartRole(chartMatrixModel.getLateStartRole());
        this.cellModel.setLateFinishRole(chartMatrixModel.getLateFinishRole());
        this.cellModel.setResourceStartRole(chartMatrixModel.getResourceStartRole());
        this.cellModel.setResourceFinishRole(chartMatrixModel.getResourceFinishRole());
        this.cellModel.setCustom1StartRole(chartMatrixModel.getCustom1StartRole());
        this.cellModel.setCustom1FinishRole(chartMatrixModel.getCustom1FinishRole());
        this.cellModel.setCustom2StartRole(chartMatrixModel.getCustom2StartRole());
        this.cellModel.setCustom2FinishRole(chartMatrixModel.getCustom2FinishRole());
        this.cellModel.setActualStartRole(chartMatrixModel.getActualStartRole());
        this.cellModel.setActualFinishRole(chartMatrixModel.getActualFinishRole());
        this.cellModel.setBaselineStartRole(chartMatrixModel.getBaselineStartRole());
        this.cellModel.setBaselineFinishRole(chartMatrixModel.getBaselineFinishRole());
        this.cellModel.setDurationRole(chartMatrixModel.getDurationRole());
        this.cellModel.setTargetRole(chartMatrixModel.getTargetRole());
        this.cellModel.setDescriptionRole(chartMatrixModel.getDescriptionRole());
        this.cellModel.setColorRole(chartMatrixModel.getColorRole());
        this.cellModel.setParentRole(chartMatrixModel.getParentRole());
        this.cellModel.setAuxiliaryRole(chartMatrixModel.getAuxiliaryRole());
        this.cellModel.setDataTipRole(chartMatrixModel.getDataTipRole());
        this.cellModel.setAnnoTaskRole(chartMatrixModel.getAnnoTaskRole());
        this.cellModel.setAnnoLocationRole(chartMatrixModel.getAnnoLocationRole());
        this.cellModel.setAnnoPositionRole(chartMatrixModel.getAnnoPositionRole());
        this.cellModel.setAnnoSymbolRole(chartMatrixModel.getAnnoSymbolRole());
        this.cellModel.setAnnoTextRole(chartMatrixModel.getAnnoTextRole());
        this.cellModel.setAnnoSymbolColorRole(chartMatrixModel.getAnnoSymbolColorRole());
        this.cellModel.setAnnoTextColorRole(chartMatrixModel.getAnnoTextColorRole());
        this.cellModel.setAnnoTextJustificationRole(chartMatrixModel.getAnnoTextJustificationRole());
        this.cellModel.setSelectionRole(chartMatrixModel.getSelectionRole());
        this.cellModel.setReplaceWithChildrenRole(chartMatrixModel.getReplaceWithChildrenRole());
        this.cellModel.setStyleByRole(chartMatrixModel.getStyleByRole());
        this.cellModel.setDrawBarRole(chartMatrixModel.getDrawBarRole());
        this.cellModel.setMarkerTaskRole(chartMatrixModel.getMarkerTaskRole());
        this.cellModel.setMarkerLocationRole(chartMatrixModel.getMarkerLocationRole());
        this.cellModel.setMarkerPositionRole(chartMatrixModel.getMarkerPositionRole());
        this.cellModel.setMarkerSymbolRole(chartMatrixModel.getMarkerSymbolRole());
        this.cellModel.setMarkerTextRole(chartMatrixModel.getMarkerTextRole());
        this.cellModel.setMarkerSymbolColorRole(chartMatrixModel.getMarkerSymbolColorRole());
        this.cellModel.setMarkerTextColorRole(chartMatrixModel.getMarkerTextColorRole());
        this.cellModel.setMarkerTextJustificationRole(chartMatrixModel.getMarkerTextJustificationRole());
        this.cellModel.setCalendarRole(chartMatrixModel.getCalendarRole());
        this.cellModel.setBreaktimeCalendarRole(chartMatrixModel.getBreaktimeCalendarRole());
        this.cellModel.setBreaktimeStartRole(chartMatrixModel.getBreaktimeStartRole());
        this.cellModel.setBreaktimeFinishRole(chartMatrixModel.getBreaktimeFinishRole());
        this.cellModel.setBreaktimeDurationRole(chartMatrixModel.getBreaktimeDurationRole());
        this.cellModel.setTableColumnVariables(this.componentVariableArrayList);
        this.cellModel.setSuccesorVariables(this.componentSuccessorVariableArrayList);
        this.cellModel.setMouseEventListenerRecasterFactory(chartMatrixModel.getMouseEventListenerRecasterFactory());
        this.cellModel.setIndepAxisVisible(new Boolean(this.idAxisInsideCell && indepAxisModel.isVisible()));
        this.cellModel.setDepAxisVisible(new Boolean(this.dateAxisInsideCell && depAxisModel.isVisible()));
        this.cellModel.setTableAxisModel(chartMatrixModel.getGanttChartModel().getTableAxisModel());
        this.outerMargin.left = dependentAxisCellModel.getResAxisAdj().intValue();
        this.cellModel.setOuterMargin(this.outerMargin);
        StringToNumericMapper independentAxisMapper = new StringToNumericMapper();
        StringPipe IdFormattedValue = this.taskGtkVar instanceof StringVariable ? ((StringVariable)this.taskGtkVar).formattedValue : (this.taskGtkVar instanceof NumericVariable ? ((NumericVariable)this.taskGtkVar).formattedValue : null);
        independentAxisMapper.input.connectFrom(IdFormattedValue);
        int valueCount = independentAxisMapper.getUniqueValueCount();
        double len = valueCount * indepAxisTickStride;
        Double axisLength = this.dateAxisInsideCell ? new Double(len) : new Double(len + dependentAxisCellModel.getCatAxisAdj());
        independentAxisCellModel.setLength(axisLength);
        independentAxisCellModel.setPreferredLength(axisLength);
        independentAxisCellModel.setIdealPreferredLength(axisLength);
        this.margin.height = indepAxisTickStride / 2;
        if (indepAxisModel.isReverseDirection()) {
            independentAxisMapper.setStartValue(indepAxisOrigin + len);
            independentAxisMapper.setStrideValue((double)(-indepAxisTickStride));
        } else {
            independentAxisMapper.setStartValue(indepAxisOrigin);
            independentAxisMapper.setStrideValue((double)indepAxisTickStride);
        }
        independentAxisCellModel.setMapper((NumericMapper)independentAxisMapper);
        this.cellModel.setDependentAxisCellModel(dependentAxisCellModel);
        this.cellModel.setIndependentAxisCellModel(independentAxisCellModel);
        this.cellModel.setGanttChartModel(chartMatrixModel.getGanttChartModel());
        int frameVisibilityPolicy = chartMatrixModel.getGanttChartModel().getFrameLineStyle().getVisibilityPolicy();
        if (frameVisibilityPolicy == 10200) {
            this.cellModel.setFrameVisible(Boolean.TRUE);
        } else {
            this.cellModel.setFrameVisible(frameVisibilityPolicy == 10201 ? Boolean.TRUE : Boolean.FALSE);
        }
        DataElementStyles dataElementStyles = chartMatrixModel.getGanttChartModel().getDataElementStyles();
        FillStyle[] fillStyles = null;
        MarkerStyle targetStyle = null;
        Color[] cycleColors = null;
        LineStyle outlineLineStyle = null;
        MarkerStyle milestoneStyle = null;
        FillStyle breakTimeStyle = null;
        Variable styleByVariable = this.gcTableDataModel.getStyleByVariable();
        if (dataElementStyles != null) {
            if (styleByVariable == null) {
                fillStyles = new FillStyle[]{dataElementStyles.getNormalFillStyle(), dataElementStyles.getSlackFillStyle(), dataElementStyles.getCriticalFillStyle(), dataElementStyles.getActualFillStyle(), dataElementStyles.getResourceFillStyle(), dataElementStyles.getBaselineFillStyle(), dataElementStyles.getCustomSchedule1FillStyle(), dataElementStyles.getCustomSchedule2FillStyle(), dataElementStyles.getBreakTimeFillStyle()};
            } else if (dataElementStyles.getFillStyles() != null || dataElementStyles.getFillStyles().length >= 1) {
                fillStyles = dataElementStyles.getFillStyles();
            }
            if (dataElementStyles.getTargetMarkerStyle() != null) {
                targetStyle = dataElementStyles.getTargetMarkerStyle();
            }
            if (dataElementStyles.getDiscreteFillColors() != null || dataElementStyles.getDiscreteFillColors().length >= 1) {
                cycleColors = dataElementStyles.getDiscreteFillColors();
            }
            outlineLineStyle = dataElementStyles.getOutlineLineStyle();
            milestoneStyle = dataElementStyles.getMilestoneMarkerStyle();
            breakTimeStyle = dataElementStyles.getBreakTimeFillStyle();
        }
        if (outlineLineStyle == null) {
            outlineLineStyle = new LineStyle(new Color(128, 128, 128));
        }
        if (milestoneStyle == null) {
            milestoneStyle = new MarkerStyle(118);
        }
        if (breakTimeStyle == null) {
            breakTimeStyle = new FillStyle(new Color(102, 102, 102));
        }
        this.isMilestoneLegendPresent = this.durationGtkVar != null && milestoneStyle != null && milestoneStyle.isVisible();
        this.isTargetLegendPresent = this.targetGtkVar != null && targetStyle != null && targetStyle.isVisible();
        GanttChartModel ganttChartModel = chartMatrixModel.getGanttChartModel();
        String[] legValue = ganttChartModel.getLegendModel().getCategories();
        if (styleByVariable != null) {
            StringPipe sbValue;
            LinkedHashSet<String> sbUniqueValues = new LinkedHashSet<String>();
            if (legValue != null) {
                int size = legValue.length;
                for (int ii = 0; ii < size; ++ii) {
                    String s = legValue[ii];
                    sbUniqueValues.add(s);
                }
            }
            com.sas.graphics.util.gtk.Variable sbv = dataSource.getVariable(chartMatrixModel.getStyleByRole(), 0);
            String missingLabel = null;
            if (sbv instanceof StringVariable) {
                sbValue = ((StringVariable)sbv).value;
                int uniqueValueCnt = sbv.getUniqueValueCount();
                for (int i = 0; i < uniqueValueCnt; ++i) {
                    try {
                        String s = ((StringVariable)sbv).uniqueValue.getValue(i);
                        sbUniqueValues.add(s);
                        continue;
                    }
                    catch (MissingValueException e) {
                        missingLabel = ValueMap.getDefaultMissingValueLabel((MissingValues)e.getMissingValue());
                        sbUniqueValues.add(missingLabel);
                    }
                }
            } else {
                StringVariable tv = new StringVariable();
                tv.connectFrom((NumericVariable)sbv);
                sbValue = tv.value;
                int uniqueValueCnt = tv.getUniqueValueCount();
                legValue = new String[uniqueValueCnt];
                for (int i = 0; i < uniqueValueCnt; ++i) {
                    try {
                        sbUniqueValues.add(tv.uniqueValue.getValue(i));
                        continue;
                    }
                    catch (MissingValueException e) {
                        missingLabel = ValueMap.getDefaultMissingValueLabel((MissingValues)e.getMissingValue());
                        sbUniqueValues.add(missingLabel);
                    }
                }
            }
            if (!sbUniqueValues.isEmpty() && (legValue = sbUniqueValues.toArray(new String[0])) != null && legValue.length > 0) {
                LegendCellModel lcm = this._createLegendCellModel(ganttChartModel, styleByVariable.getLabel(), outlineLineStyle, antialiasedGraphics, antialiasedText);
                StringToColorMapper mapper = GTKUtil.MapperFactory.newStringToColorMapper(legValue, fillStyles, cycleColors);
                if (missingLabel != null) {
                    int size = legValue.length;
                    for (int i = 0; i < size; ++i) {
                        if (!legValue[i].equals(missingLabel)) continue;
                        mapper.setMissingReplacement(cycleColors[i]);
                        mapper.setReplaceMissingValues(true);
                        break;
                    }
                }
                if (sbv instanceof StringVariable) {
                    sbValue = ((StringVariable)sbv).formattedValue;
                } else {
                    StringVariable tv = new StringVariable();
                    tv.connectFrom((NumericVariable)sbv);
                    sbValue = tv.formattedValue;
                }
                mapper.input.connectFrom(sbValue);
                this.cellModel.setColorMapper((ColorMapper)mapper);
                if (ganttChartModel.getLegendModel().getCategories() != null) {
                    legValue = ganttChartModel.getLegendModel().getCategories();
                }
                this._addLegend(lcm, ganttChartModel, legValue, fillStyles, cycleColors, milestoneStyle, targetStyle);
            }
        } else {
            LegendCellModel lcm = this._createLegendCellModel(ganttChartModel, null, outlineLineStyle, antialiasedGraphics, antialiasedText);
            if (!ganttChartModel.isSlackTimeEnabled()) {
                this._addWithoutSlackTimeLegend(lcm, ganttChartModel, fillStyles, milestoneStyle, targetStyle, breakTimeStyle, legValue);
            } else {
                this._addLegend(lcm, ganttChartModel, fillStyles, milestoneStyle, targetStyle, breakTimeStyle, legValue);
            }
        }
        this.cellModel.setTable((Object)this.treeTable);
        DataSource[] ds = new DataSource[]{dataSource, this.getAnnoDataSource(), this.getBreaktimeDataSource()};
        this.ganttCells = this.addMatrixCellComponents(new GanttCellFactory(), this.cellModel, ds);
        if (!this.dateAxisInsideCell) {
            this.depAxisCells = this.addColumnTabletCellComponents(new DependentAxisCellFactory(), dependentAxisCellModel, null, false);
            dependentAxisCellModel.computeParameters(((CompoundTimeAxisCell)this.depAxisCells.get(0)).getChannel());
        }
        if (!this.idAxisInsideCell) {
            this.addColumnTabletCellComponents(new IndependentAxisCellFactory(), independentAxisCellModel, null, false);
        }
        if (this.treeTableHadFocus && this.treeTable != null) {
            try {
                this.treeTable.requestFocus();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void fireGraphActionEvent(GraphActionEvent e) {
    }

    public synchronized void addLinkListener(ActionListener l) {
        this.linkListeners = AWTEventMulticaster.add(this.linkListeners, l);
    }

    public synchronized void removeLinkListener(ActionListener l) {
        this.linkListeners = AWTEventMulticaster.remove(this.linkListeners, l);
    }

    private void fireLinkActionEvent(CellActionEvent e) {
        this.linkListeners.actionPerformed((ActionEvent)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnnoDataSource(DataSource ds) {
        if (this.annoDataSource != ds) {
            if (this.annoDataSource != null) {
                Vector vector = this.dataSourceTrashBin;
                synchronized (vector) {
                    this.dataSourceTrashBin.add(this.annoDataSource);
                }
            }
            this.annoDataSource = ds;
            this.reconstruct();
        }
    }

    public DataSource getAnnoDataSource() {
        return this.annoDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreaktimeDataSource(DataSource ds) {
        if (this.breaktimeDataSource != ds) {
            if (this.breaktimeDataSource != null) {
                Vector vector = this.dataSourceTrashBin;
                synchronized (vector) {
                    this.dataSourceTrashBin.add(this.breaktimeDataSource);
                }
            }
            this.breaktimeDataSource = ds;
            this.reconstruct();
        }
    }

    public DataSource getBreaktimeDataSource() {
        return this.breaktimeDataSource;
    }

    public Collection getTreeExpansionState() {
        TreeTableModel ttModel;
        ArrayList<Object> rows = new ArrayList<Object>();
        Collection getTempTreeState = null;
        if (this.treeTable != null && (ttModel = (TreeTableModel)this.treeTable.getTreeModel()) != null) {
            if (ttModel.getRootVisible() && ttModel.getRowAt(0).isCollapsed()) {
                rows.add(ttModel.getRowAt(0));
                return rows;
            }
            getTempTreeState = ((TreeTableModel)this.treeTable.getTreeModel()).getTreeExpansionState();
            for (TreeTableRow ttrow : getTempTreeState) {
                int task_Idx = this._findColumnIndex(this.taskGtkVar.getColumnName(), ttModel.getColumnNames());
                rows.add(ttrow.getTableRow()[task_Idx]);
            }
        }
        return rows;
    }

    public void setTreeExpansionState(Collection expanRows) {
        TreeTableModel ttModel;
        if (this.treeTable != null && (ttModel = (TreeTableModel)this.treeTable.getTreeModel()) != null) {
            TreeTableRow r;
            Iterator iter = expanRows.iterator();
            ArrayList<TreeTableRow> rows = new ArrayList<TreeTableRow>();
            block0: while (iter.hasNext()) {
                String temp = iter.next().toString();
                int task_Idx = this._findColumnIndex(this.taskGtkVar.getColumnName(), ttModel.getColumnNames());
                for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
                    TreeTableRow r2 = ttModel.getRowAt(i, false);
                    if (!r2.getTableRow()[task_Idx].equals(temp.trim())) continue;
                    rows.add(r2);
                    continue block0;
                }
            }
            if (expanRows.size() == 0 && this.treeTable.isRootVisible() && ttModel != null) {
                TreePath path = this.treeTable.getPathForRow(0);
                if (path != null) {
                    ttModel.expandToDepth(0, false);
                }
                TreeTableModel treeTableModel = (TreeTableModel)ttModel.getTreeTable().getTreeModel();
                treeTableModel.rebuildMaps();
                treeTableModel.setTreeExpansionState(rows);
            } else if (expanRows.size() == 0 && !this.treeTable.isRootVisible() && ttModel != null) {
                r = ttModel.getRowAt(0, false);
                rows.add(r);
                ttModel.setTreeExpansionState(rows);
            } else if (expanRows.size() == 1 && this.treeTable.isRootVisible() && ttModel != null) {
                GanttTreeTable tt = this.treeTable;
                TreePath path = tt.getPathForRow(0);
                if (path != null) {
                    tt.collapsePath(path);
                }
                ttModel = (TreeTableModel)tt.getTreeModel();
                ttModel.rebuildMaps();
            } else if (expanRows.size() == 1 && !this.treeTable.isRootVisible() && ttModel != null) {
                r = ttModel.getRowAt(0, false);
                rows.add(r);
                ttModel.setTreeExpansionState(rows);
            } else {
                r = ttModel.getRowAt(0, false);
                rows.add(r);
                ttModel.setTreeExpansionState(rows);
            }
        }
    }

    public void setRowSelectionColor(Color newColor) {
        GanttTreeTable tt = this.treeTable;
        if (tt != null) {
            tt.setSelectionBackground(newColor);
        }
    }

    public void setFontForegroundColor(Color newColor) {
        GanttTreeTable tt = this.treeTable;
        if (tt != null) {
            tt.setFontForeground(newColor, true);
        }
    }

    public void setRowSelectionFont(Font newFont) {
        if (this.treeTable != null) {
            this.treeTable.setFont(newFont, true);
        }
    }

    public Color getRowSelectionColor() {
        return this.treeTable.getSelectionBackground();
    }

    public void setSortEnable(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        if (this.treeTable != null) {
            this.treeTable.setSortEnabled(sortEnabled);
        }
    }

    public boolean isSortEnabled() {
        boolean tempSort = true;
        if (this.treeTable != null) {
            tempSort = this.treeTable.isSortEnabled();
        }
        return tempSort;
    }

    private void setLegendCategoryColors(ColorVector colorVector) {
        if (colorVector != null && colorVector.size() > 0) {
            this.colorByLegendColors = new Color[colorVector.size()];
            for (int i = 0; i < colorVector.size(); ++i) {
                try {
                    this.colorByLegendColors[i] = colorVector.getValue(i);
                    continue;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Color[] getLegendCategoryColors() {
        return this.colorByLegendColors;
    }

    private void setLegendCategoryValues(StringVector catLegendValues) {
        if (catLegendValues != null && catLegendValues.size() > 0) {
            this.colorByLegendValues = new String[catLegendValues.size()];
            for (int i = 0; i < catLegendValues.size(); ++i) {
                try {
                    this.colorByLegendValues[i] = catLegendValues.getValue(i);
                    continue;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String[] getLegendCategoryValues() {
        return this.colorByLegendValues;
    }

    public int _findColumnIndex(String label, String[] colNames) {
        int nCol = colNames.length;
        for (int ii = 0; ii < nCol; ++ii) {
            if (colNames[ii].compareTo(label) != 0) continue;
            return ii;
        }
        return -1;
    }

    private boolean _createTable(Object tableModel, TableAxisModel tam, ListSelectionModel selectionModel, Locale locale, int sortStrategy) {
        TreeTableModel ttm;
        boolean creationSuccessful = false;
        GanttExpansionState expansionState = null;
        Vector<Object> selectedTaskNames = new Vector<Object>();
        if (this.treeTable != null) {
            TableModel ttm2 = this.treeTable.getModel();
            if (selectionModel != null) {
                int i0 = selectionModel.getMinSelectionIndex();
                int i1 = selectionModel.getMaxSelectionIndex();
                if (i0 >= 0) {
                    for (int i = i0; i <= i1; ++i) {
                        if (!selectionModel.isSelectedIndex(i)) continue;
                        selectedTaskNames.addElement(ttm2.getValueAt(i, this.taskIdx));
                    }
                }
                this.treeTable.setSelectionModel(new DefaultListSelectionModel());
            }
            if (this.treeSortListener != null) {
                this.treeTable.removeSortListener(this.treeSortListener);
            }
            if (ttm2 != null && ttm2 instanceof TreeTableModel) {
                expansionState = new GanttExpansionState(((TreeTableModel)ttm2).getTreeExpansionState());
            }
        }
        int tam_TreeExpansionDepth = tam.getPreferredExpansionDepth() != Integer.MAX_VALUE ? tam.getPreferredExpansionDepth() : this.treeTableInitialDepth;
        TableModel tm = (TableModel)tableModel;
        int tm_RowCount = tm.getRowCount();
        if (tm instanceof TreeTableModel && (tm_RowCount = (ttm = (TreeTableModel)tm).getRowCount(false)) > 0 && tam_TreeExpansionDepth == 0 && !tam.isRootVisible()) {
            tm_RowCount = 0;
        }
        if (tm_RowCount > 0 && tm.getColumnCount() > 0) {
            TableModel treeTableModel;
            if (tableModel instanceof TreeTableModel) {
                boolean b;
                TreeCellRenderer cr;
                this.treeTable = new GanttTreeTable((TreeTableModel)tableModel, tam);
                if (this.isSortEnabled()) {
                    this.treeTable._sort(this.isSortEnabled());
                }
                this.treeTable.expandToDepth(tam_TreeExpansionDepth, false);
                this.treeTable.setShowsRootHandles(true);
                TreeExpansionListener tel = new TreeExpansionListener(){

                    @Override
                    public void treeExpanded(TreeExpansionEvent e) {
                        GanttChartMatrix.this.reconstruct();
                    }

                    @Override
                    public void treeCollapsed(TreeExpansionEvent e) {
                        GanttChartMatrix.this.reconstruct();
                    }
                };
                this.treeTable.addTreeExpansionListener(tel);
                TreeIconModel tim = tam.getHierarchyModel().getTreeIconModel();
                if (tim != null && (cr = this.treeTable.getTreeCellRenderer()) instanceof DefaultTreeCellRenderer) {
                    DefaultTreeCellRenderer dcr = (DefaultTreeCellRenderer)cr;
                    if (tim.getOpenIcon() != null) {
                        dcr.setOpenIcon(tim.getOpenIcon());
                    }
                    if (tim.getLeafIcon() != null) {
                        dcr.setLeafIcon(tim.getLeafIcon());
                    }
                    if (tim.getClosedIcon() != null) {
                        dcr.setClosedIcon(tim.getClosedIcon());
                    }
                }
                for (String taskName : tam.keySetTableRowEditable()) {
                    b = tam.getTableRowEditable(taskName);
                    this._setTableRowEditable(taskName, b);
                }
                for (String colName : tam.keySetTableColumnEditable()) {
                    b = tam.getTableColumnEditable(colName);
                    this._setTableColumnEditable(colName, b);
                }
                Iterator i = tam.getAllLinkedTasks();
                while (i.hasNext()) {
                    String taskName;
                    taskName = (String)i.next();
                    String link = tam.getTaskLink(taskName);
                    TreeTableRow row = this._findTreeTableRow(taskName, this.treeTable.getModel());
                    row.setLinkCommand(0, link);
                }
            } else {
                this.treeTable = new GanttTreeTable((TableModel)tableModel, tam);
            }
            this.treeTable.setSortEnabled(this.sortEnabled);
            if (sortStrategy == 10475) {
                this.treeTable.setSortLocale(locale);
            } else {
                this.treeTable.setSortLocale(null);
            }
            if (this.treeSortListener == null) {
                this.treeSortListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GanttChartMatrix.this._getSortInfoFromTable();
                    }
                };
            }
            this.treeTable.addSortListener(this.treeSortListener);
            this.treeTable.setDisplayedAsTree(tam.getHierarchyModel().isEnabled());
            this._setTableEditable();
            this._setTablePopupEnabled();
            if (this.getGraphModel().getCustomOptions() == GraphConstants.CUSTOM_OPTION_TABLEAXISMODEL_AUTORESIZE_ENABLED) {
                this.treeTable.setAutoResizeMode(2);
            } else {
                this.treeTable.setAutoResizeMode(0);
            }
            this.treeTable.setRootVisible(tam.isRootVisible());
            TableColumnModel columnModel = this.treeTable.getColumnModel();
            if (this.componentVariableArrayList == null || this.componentVariableArrayList.size() > columnModel.getColumnCount()) {
                creationSuccessful = false;
                return false;
            }
            TableColumn column = null;
            Variable var = null;
            if (columnModel.getColumnCount() >= this.componentVariableArrayList.size()) {
                for (int ii = 0; ii < this.componentVariableArrayList.size(); ++ii) {
                    column = columnModel.getColumn(ii);
                    var = (Variable)this.componentVariableArrayList.get(ii);
                    column.setIdentifier(var);
                    if (var.getLabel() == null) continue;
                    column.setHeaderValue(var.getLabel());
                }
            } else {
                creationSuccessful = false;
                return false;
            }
            if (tam.getColumns() != null) {
                this._applySort(tam, columnModel, locale);
            }
            this.treeTable.clearZones();
            this.treeTable.setZonesEnabled(false);
            this.treeTable.setShowGrid(true);
            if (tam.getZones() != null) {
                this._applyZones(tam);
            }
            int numVisColumns = 0;
            if (tam.getColumns() != null) {
                numVisColumns = this._applyColumnAttrs(tam, columnModel, locale);
            }
            while (columnModel.getColumnCount() > numVisColumns) {
                column = columnModel.getColumn(numVisColumns);
                columnModel.removeColumn(column);
            }
            int cc = columnModel.getColumnCount();
            if (cc > 0) {
                ListSelectionModel lsm = columnModel.getSelectionModel();
                lsm.removeSelectionInterval(0, cc - 1);
            }
            if (expansionState != null && (treeTableModel = this.treeTable.getModel()) instanceof TreeTableModel) {
                ((TreeTableModel)treeTableModel).setTreeExpansionState((Collection)expansionState);
            }
            if (selectionModel != null) {
                selectionModel.clearSelection();
                this.treeTable.setSelectionModel(selectionModel);
                TableModel ttm3 = this.treeTable.getModel();
                Object selectedTask = null;
                for (int i = 0; i < selectedTaskNames.size(); ++i) {
                    Object rowName;
                    int rx;
                    Object selName;
                    selectedTask = selectedTaskNames.elementAt(i);
                    if (selectedTask instanceof String) {
                        selName = selectedTask;
                        for (rx = 0; rx < this.treeTable.getRowCount(); ++rx) {
                            rowName = (String)ttm3.getValueAt(rx, this.taskIdx);
                            if (rowName == null || !((String)rowName).equals(selName)) continue;
                            selectionModel.addSelectionInterval(rx, rx);
                        }
                        continue;
                    }
                    if (selectedTask instanceof Integer) {
                        selName = selectedTask;
                        for (rx = 0; rx < this.treeTable.getRowCount(); ++rx) {
                            rowName = (Integer)ttm3.getValueAt(rx, this.taskIdx);
                            if (rowName == null || !((Integer)rowName).equals(selName)) continue;
                            selectionModel.addSelectionInterval(rx, rx);
                        }
                        continue;
                    }
                    if (!(selectedTask instanceof Double)) continue;
                    selName = selectedTask;
                    for (rx = 0; rx < this.treeTable.getRowCount(); ++rx) {
                        rowName = (Double)ttm3.getValueAt(rx, this.taskIdx);
                        if (rowName == null || !((Double)rowName).equals(selName)) continue;
                        selectionModel.addSelectionInterval(rx, rx);
                    }
                }
            } else {
                this.treeTable.setSelectionModel(new DefaultListSelectionModel());
            }
            columnModel.addColumnModelListener(new TableColumnModelListener(){
                ArrayList colOrder = null;

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent evt) {
                    TableAxisColumn movedColumn = null;
                    int from = evt.getFromIndex();
                    int to = evt.getToIndex();
                    if (to != from && GanttChartMatrix.this.cellModel != null && GanttChartMatrix.this.cellModel.getGanttChartModel() != null && GanttChartMatrix.this.cellModel.getGanttChartModel().getTableAxisModel() != null) {
                        TableAxisModel tam = GanttChartMatrix.this.cellModel.getGanttChartModel().getTableAxisModel();
                        TableAxisColumn[] columnList = tam.getColumns();
                        int visColIndex = -1;
                        int fromColumnIndex = -1;
                        int toColumnIndex = -1;
                        for (int i = 0; i < columnList.length; ++i) {
                            if (!columnList[i].isVisible()) continue;
                            if (++visColIndex == from) {
                                fromColumnIndex = i;
                            }
                            if (visColIndex == to) {
                                toColumnIndex = i;
                            }
                            if (fromColumnIndex >= 0 && toColumnIndex >= 0) break;
                        }
                        if (to > from) {
                            ++toColumnIndex;
                        }
                        movedColumn = columnList[fromColumnIndex];
                        if (this.colOrder == null) {
                            this.colOrder = GanttChartMatrix.this.convertToArrayList(columnList);
                        }
                        this.colOrder.remove(fromColumnIndex);
                        if (to > from) {
                            --toColumnIndex;
                        }
                        this.colOrder.add(toColumnIndex, movedColumn);
                        TableAxisColumn[] newOrder = GanttChartMatrix.this.convertToArray(this.colOrder);
                        tam.disablePropertyChange();
                        tam.setColumns(newOrder);
                        tam.enablePropertyChange();
                    }
                }

                @Override
                public void columnMarginChanged(ChangeEvent evt) {
                    Object source = evt.getSource();
                    if (source instanceof DefaultTableColumnModel) {
                        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)source;
                        if (GanttChartMatrix.this.cellModel != null && GanttChartMatrix.this.cellModel.getGanttChartModel() != null && GanttChartMatrix.this.cellModel.getGanttChartModel().getTableAxisModel() != null) {
                            TableAxisModel tam = GanttChartMatrix.this.cellModel.getGanttChartModel().getTableAxisModel();
                            TableAxisColumn[] columnList = tam.getColumns();
                            for (int ii = 0; ii < columnList.length; ++ii) {
                                int colIdx = -1;
                                try {
                                    if (columnList[ii].getVariable() != null) {
                                        colIdx = columnModel.getColumnIndex(columnList[ii].getVariable());
                                    }
                                }
                                catch (IllegalArgumentException ex) {
                                    colIdx = -1;
                                }
                                if (colIdx == -1) continue;
                                BaseLength width = new BaseLength((double)columnModel.getColumn(colIdx).getPreferredWidth(), "px");
                                if (columnList[ii].getWidth().getMagnitude((Object)"px") == (double)columnModel.getColumn(colIdx).getPreferredWidth()) continue;
                                tam.disablePropertyChange();
                                columnList[ii].setWidth(width);
                                tam.enablePropertyChange();
                            }
                        }
                    }
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
            this.treeTable.removeAllCellPopupItems();
            for (int i = 0; i < tam.getTableCellPopupMenuItemCount(); ++i) {
                CellAction a = tam.getTableCellPopupMenuItem(i);
                this.treeTable.addCellPopupItem(a);
            }
            creationSuccessful = tm.getRowCount() > 0 && tm.getColumnCount() > 0;
        } else {
            creationSuccessful = false;
        }
        return creationSuccessful;
    }

    private void _setTableEditable() {
        if (this.treeTable != null) {
            boolean editableSet = this.getModel().getGanttChartModel().getTableAxisModel().isTableEditableSet();
            boolean editable = this.getModel().getGanttChartModel().getTableAxisModel().isTableEditable();
            if (editableSet) {
                this.treeTable.setEditable(editable);
            } else {
                this.treeTable.unsetEditable();
            }
        }
    }

    private void _setTableRowEditable(String taskName, boolean b) {
        TreeTableRow row = this._findTreeTableRow(taskName, this.treeTable.getModel());
        if (row != null) {
            row.setEditable(b);
        }
    }

    private void _setAllTableRowsEditable(boolean b) {
        TableModel tm = this.treeTable.getModel();
        if (tm instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)tm;
            int r1 = ttm.getRowCount(false);
            for (int rx = 0; rx < r1; ++rx) {
                ttm.getRowAt(rx, false).setEditable(b);
            }
        }
    }

    private void _setTableColumnEditable(String colName, boolean b) {
        TableModel tm = this.treeTable.getModel();
        if (tm instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)tm;
            int c1 = ttm.getColumnCount();
            for (int cx = 0; cx < c1; ++cx) {
                if (!ttm.getColumnName(cx).equals(colName)) continue;
                ttm.setColumnEditable(cx, b);
                break;
            }
        }
    }

    private void _setAllTableColumnsEditable(boolean b) {
        TableModel tm = this.treeTable.getModel();
        if (tm instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)tm;
            int c1 = ttm.getColumnCount();
            for (int cx = 0; cx < c1; ++cx) {
                ttm.setColumnEditable(cx, b);
            }
        }
    }

    public void _setTablePopupEnabled() {
        if (this.treeTable != null) {
            boolean enabled = this.getModel().getGanttChartModel().getTableAxisModel().isTableCellPopupMenuEnabled();
            this.treeTable.setCellPopupEnabled(enabled);
        }
    }

    private void _getSortInfoFromTable() {
        if (this.cellModel == null || this.inhibitTableSettings) {
            return;
        }
        this.inhibitTableSettings = true;
        TableAxisModel m = this.cellModel.getTableAxisModel();
        TableAxisColumn[] columns = m.getColumns();
        for (int i = 0; i < this.treeTable.getSortLength(); ++i) {
            int columnIndex = this.treeTable.getSortField(i);
            int columnPosition = this.treeTable.getColumnPosition(columnIndex);
            if (columnPosition < 0) continue;
            int visColNum = -1;
            TableAxisColumn col = null;
            for (int cx = 0; cx < columns.length; ++cx) {
                if (!columns[cx].isVisible() || ++visColNum != columnPosition) continue;
                col = columns[cx];
                break;
            }
            boolean ascending = this.treeTable.getSortAscending(i);
            boolean formatted = this.treeTable.getSortFormatter(i) != null;
            col.setSortIndex(i);
            col.setSort(ascending ? (formatted ? 10403 : 10405) : (formatted ? 10404 : 10406));
        }
        this.inhibitTableSettings = false;
    }

    private ArrayList convertToArrayList(TableAxisColumn[] colList) {
        if (colList == null) {
            return null;
        }
        ArrayList<TableAxisColumn> newList = new ArrayList<TableAxisColumn>();
        for (int ii = 0; ii < colList.length; ++ii) {
            newList.add(ii, colList[ii]);
        }
        return newList.size() > 0 ? newList : null;
    }

    private TableAxisColumn[] convertToArray(ArrayList colList) {
        if (colList == null) {
            return null;
        }
        TableAxisColumn[] newList = new TableAxisColumn[colList.size()];
        for (int ii = 0; ii < colList.size(); ++ii) {
            newList[ii] = (TableAxisColumn)colList.get(ii);
        }
        return newList.length > 0 ? newList : null;
    }

    private void _applyZones(TableAxisModel tam) {
        TableAxisZone[] zoneList = tam.getZones();
        if (zoneList != null) {
            boolean found = false;
            for (int ii = 0; ii < zoneList.length; ++ii) {
                if (zoneList[ii] == null) continue;
                if (zoneList[ii].getVariable() != null) {
                    this.treeTable.addDataZone(zoneList[ii].getVariable());
                    found = true;
                }
                if (zoneList[ii].getTreeLevel() <= -1) continue;
                this.treeTable.addTreeZone(zoneList[ii].getTreeLevel());
                found = true;
            }
            if (found) {
                this.treeTable.setZonesEnabled(true);
                this.treeTable.setShowHorizontalLines(false);
                this.treeTable.setShowVerticalLines(true);
            }
        }
    }

    private void _applySort(TableAxisModel tam, TableColumnModel columnModel, Locale locale) {
        SortColumn head = null;
        TableAxisColumn[] columnList = tam.getColumns();
        if (columnList != null) {
            for (int ii = 0; ii < columnList.length; ++ii) {
                SASFormat sasFormat = null;
                String format = columnList[ii].getVariable().getFormat();
                if (format != null) {
                    sasFormat = Util.newSASFormat(format, locale);
                }
                if (columnList[ii].getSort() == 10400) continue;
                boolean inserted = false;
                int idx = columnList[ii].getSortIndex();
                if (head == null) {
                    head = new SortColumn(columnList[ii].getVariable(), sasFormat, idx, columnList[ii].getSort());
                    continue;
                }
                for (SortColumn node = head; node != null && !inserted; node = node.getNext()) {
                    SortColumn temp;
                    if (idx >= node.sortIdx) {
                        if (node.getNext() != null) {
                            if (idx >= node.getNext().sortIdx) continue;
                            temp = node.getNext();
                            node.setNext(new SortColumn(columnList[ii].getVariable(), sasFormat, idx, columnList[ii].getSort()));
                            node.getNext().setNext(temp);
                            inserted = true;
                            continue;
                        }
                        node.setNext(new SortColumn(columnList[ii].getVariable(), sasFormat, idx, columnList[ii].getSort()));
                        inserted = true;
                        continue;
                    }
                    temp = head;
                    head = new SortColumn(columnList[ii].getVariable(), sasFormat, idx, columnList[ii].getSort());
                    head.setNext(temp);
                    inserted = true;
                }
            }
            if (!this.inhibitTableSettings) {
                this.treeTable.clearSortFields();
                if (head != null) {
                    this.treeTable.disableSortEvents();
                    for (SortColumn node = head; node != null; node = node.getNext()) {
                        if (node.sasFormat != null && node.sortType != 10405 && node.sortType != 10406) {
                            if (node.sortType == 10403 || node.sortType == 10401) {
                                this.treeTable.addSortField(node.variable, true, node.sasFormat);
                                continue;
                            }
                            if (node.sortType != 10404 && node.sortType != 10402) continue;
                            this.treeTable.addSortField(node.variable, false, node.sasFormat);
                            continue;
                        }
                        if (node.sortType == 10403 || node.sortType == 10405 || node.sortType == 10401) {
                            this.treeTable.addSortField(node.variable, true);
                            continue;
                        }
                        if (node.sortType != 10404 && node.sortType != 10406 && node.sortType != 10402) continue;
                        this.treeTable.addSortField(node.variable, false);
                    }
                    this.treeTable.sort();
                    this.treeTable.enableSortEvents();
                }
            }
        }
    }

    private int _applyColumnAttrs(TableAxisModel tam, TableColumnModel columnModel, Locale locale) {
        int nextColumn = 0;
        BaseLength requestedWidth = null;
        int numVisColumns = 0;
        int colIdx = -1;
        TableAxisColumn[] columnList = tam.getColumns();
        if (columnList != null) {
            SasCellRenderer r = null;
            SasCellEditor e = null;
            for (int ii = 0; ii < columnList.length; ++ii) {
                SASFormat sasFormat = null;
                String format = columnList[ii].getVariable().getFormat();
                if (format != null) {
                    sasFormat = Util.newSASFormat(format, locale);
                }
                colIdx = -1;
                try {
                    if (columnList[ii].getVariable() != null) {
                        colIdx = columnModel.getColumnIndex(columnList[ii].getVariable());
                    }
                }
                catch (IllegalArgumentException x) {
                    colIdx = -1;
                }
                if (colIdx == -1) continue;
                r = null;
                e = null;
                if (columnModel.getColumn(colIdx).getModelIndex() != 0 && sasFormat != null) {
                    r = new SasCellRenderer(sasFormat);
                    e = new SasCellEditor(sasFormat);
                }
                if (columnList[ii].isVisible()) {
                    Font cf;
                    ++numVisColumns;
                    requestedWidth = columnList[ii].getWidth();
                    if (requestedWidth != null) {
                        columnModel.getColumn(colIdx).setPreferredWidth((int)requestedWidth.getMagnitude((Object)"px"));
                    }
                    TableColumn tc = columnModel.getColumn(colIdx);
                    if (r != null) {
                        tc.setCellRenderer((TableCellRenderer)r);
                    }
                    if (e != null) {
                        tc.setCellEditor((TableCellEditor)e);
                    }
                    if ((cf = tam.getValueTextStyle().getFont()) != null) {
                        TableCellEditor tce;
                        TableCellRenderer tcr;
                        if (r == null && (tcr = tc.getCellRenderer()) instanceof SasCellRenderer) {
                            r = (SasCellRenderer)tcr;
                        }
                        if (r != null) {
                            r.setFont(cf);
                        }
                        if (e == null && (tce = tc.getCellEditor()) instanceof SasCellEditor) {
                            e = (SasCellEditor)tce;
                        }
                        if (e != null) {
                            e.setFont(cf);
                        }
                    }
                    columnModel.moveColumn(colIdx, nextColumn++);
                    continue;
                }
                columnModel.removeColumn(columnModel.getColumn(colIdx));
            }
        }
        return numVisColumns;
    }

    private LegendCellModel _createLegendCellModel(GanttChartModel ganttChartModel, String styleByLabel, LineStyle outlineLineStyle, Boolean antialiasedGraphics, Boolean antialiasedText) {
        LegendCellModel lcm = new LegendCellModel();
        lcm.setAntialiasedGraphics(antialiasedGraphics);
        lcm.setAntialiasedText(antialiasedText);
        lcm.setMarkerOutlineLineStyle(outlineLineStyle);
        LegendModel legModel = ganttChartModel.getLegendModel();
        if (legModel.getLabelTextStyle().isVisible()) {
            if (legModel.getLabel() != null) {
                lcm.setDefaultLabel(legModel.getLabel().trim());
            } else if (styleByLabel != null) {
                lcm.setDefaultLabel(styleByLabel.trim());
            }
        }
        lcm.setLegendModel(ganttChartModel.getLegendModel());
        int placement = legModel.getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
        lcm.setPlacement(new Integer(placement));
        return lcm;
    }

    private void _addLegend(LegendCellModel lcm, GanttChartModel ganttChartModel, FillStyle[] fillStyles, MarkerStyle milestone, MarkerStyle target, FillStyle breakTime, String[] text) {
        StringVector stringVector = this._makeStringVector(target, milestone, ganttChartModel, breakTime, text);
        if (stringVector.getValueCount() > 0) {
            ColorVector colorVector = this._makeColorVector(fillStyles, milestone, target, breakTime, ganttChartModel);
            IntegerVector mkrVector = this._makeMarkerVector(milestone, target);
            lcm.setColorVector(colorVector);
            lcm.setStringVector(stringVector);
            lcm.setMarkerVector(mkrVector);
            LegendCell lc = new LegendCell(lcm, this.getChannel());
            this.addLegend(lc, lcm.getPlacement());
            String[] arr = this.getStringArray(stringVector);
            ganttChartModel.getLegendModel().setLegendValues(arr);
        }
    }

    private void _addWithoutSlackTimeLegend(LegendCellModel lcm, GanttChartModel ganttChartModel, FillStyle[] fillStyles, MarkerStyle milestone, MarkerStyle target, FillStyle breakTime, String[] text) {
        StringVector stringSlackVector = this._makeStringVectorWithOutSlackTime(target, milestone, ganttChartModel, breakTime, text);
        if (stringSlackVector.getValueCount() > 0) {
            ColorVector colorVector = this._makeColorVectorWithOutSlackTime(fillStyles, milestone, target, breakTime, ganttChartModel);
            IntegerVector mkrVector = this._makeMarkerVectorWithOutSlackTime(milestone, target);
            lcm.setColorVector(colorVector);
            lcm.setStringVector(stringSlackVector);
            lcm.setMarkerVector(mkrVector);
            LegendCell lc = new LegendCell(lcm, this.getChannel());
            this.addLegend(lc, lcm.getPlacement());
            String[] arr = this.getStringArray(stringSlackVector);
            ganttChartModel.getLegendModel().setLegendValues(arr);
        }
    }

    private void _addLegend(LegendCellModel lcm, GanttChartModel ganttChartModel, String[] values, FillStyle[] fillStyles, Color[] cyclecolors, MarkerStyle milestone, MarkerStyle target) {
        StringVector stringVector = this._makeStringVector(values, ganttChartModel, milestone, target);
        String[] arr = this.getStringArray(stringVector);
        ganttChartModel.getLegendModel().setLegendValues(arr);
        ColorVector colorVector = this._makeColorVector(values, ganttChartModel, fillStyles, cyclecolors, milestone, target);
        IntegerVector mkrVector = this._makeMarkerVectorCOLOR_BY(values, ganttChartModel, milestone, target);
        lcm.setColorVector(colorVector);
        lcm.setStringVector(stringVector);
        lcm.setMarkerVector(mkrVector);
        LegendCell lc = new LegendCell(lcm, this.getChannel());
        this.addLegend(lc, lcm.getPlacement());
    }

    private StringVector _makeStringVector(MarkerStyle target, MarkerStyle milestone, GanttChartModel gcm, FillStyle breakTimeFillStyle, String[] text) {
        StringVector strVector = new StringVector();
        LegendModel lm = gcm.getLegendModel();
        if (lm.getIsFirstTime()) {
            lm.setIsFirstTime(0);
            strVector = this.getInitialStringVectorForLegendValues(target, milestone, gcm, breakTimeFillStyle, text);
        } else {
            strVector = this.getStringVectorForLegendValues(target, milestone, gcm, breakTimeFillStyle, text);
        }
        return strVector;
    }

    private StringVector getInitialStringVectorForLegendValues(MarkerStyle target, MarkerStyle milestone, GanttChartModel gcm, FillStyle breakTimeFillStyle, String[] text) {
        String str;
        int strVectorSize;
        StringVector strVector = new StringVector();
        LegendModel lm = gcm.getLegendModel();
        int textSize = 0;
        boolean isTextNotNull = false;
        if (text != null) {
            isTextNotNull = true;
            textSize = text.length;
        }
        if (gcm.isGanttBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 1) {
                str = text[0];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "normalJob.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "normalJob.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("0", "" + strVectorSize);
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 2) {
                str = text[1];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "slackTime.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "slackTime.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("1", "" + strVectorSize);
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 3) {
                str = text[2];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "criticalJob.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "criticalJob.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("2", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("0", "-1");
            lm.addEntryToLegendValuesIndexMap("1", "-1");
            lm.addEntryToLegendValuesIndexMap("2", "-1");
        }
        if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null && gcm.isActualBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 4) {
                str = text[3];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "actual.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "actual.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("3", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("3", "-1");
        }
        if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null && gcm.isResourceBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 5) {
                str = text[4];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "resource.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "resource.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("4", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("4", "-1");
        }
        if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null && gcm.isBaselineBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 6) {
                str = text[5];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "baseline.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "baseline.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("5", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("5", "-1");
        }
        if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null && gcm.isCustomBar1Enabled()) {
            strVectorSize = strVector.size();
            str = gcm.getCustomSchedule1Label();
            strVector.addValue(str);
            lm.addEntryToLegendValuesIndexMap("-1", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("-1", "-1");
        }
        if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null && gcm.isCustomBar2Enabled()) {
            strVectorSize = strVector.size();
            str = gcm.getCustomSchedule2Label();
            strVector.addValue(str);
            lm.addEntryToLegendValuesIndexMap("-2", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("-2", "-1");
        }
        if (this.calendarGtkVar != null && this.breaktimeDataSource != null && breakTimeFillStyle != null && breakTimeFillStyle.isVisible()) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 7) {
                str = text[6];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "breaktime.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "breaktime.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("6", "" + strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("6", "-1");
        }
        if (this.isMilestoneLegendPresent) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 8) {
                str = text[7];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "milestone.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "milestone.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("7", "" + strVectorSize);
            lm.setMilestoneMarkerIndex(strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("7", "-1");
        }
        if (this.isTargetLegendPresent) {
            strVectorSize = strVector.size();
            if (isTextNotNull && textSize >= 9) {
                str = text[8];
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "target.txt");
                    strVector.addValue(str);
                }
            } else {
                str = RB.getStringResource(RB_KEY, "target.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("8", "" + strVectorSize);
            lm.setTargetMarkerIndex(strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("8", "-1");
        }
        this.numLegendEntries = strVector.size();
        return strVector;
    }

    private StringVector getStringVectorForLegendValues(MarkerStyle target, MarkerStyle milestone, GanttChartModel gcm, FillStyle breakTimeFillStyle, String[] text) {
        String str;
        int strVectorSize;
        StringVector strVector = new StringVector();
        LegendModel lm = gcm.getLegendModel();
        boolean isTextNotNull = false;
        if (text != null) {
            isTextNotNull = true;
        }
        if (gcm.isGanttBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "0", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "normalJob.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("0", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "normalJob.txt");
                strVector.addValue(str);
            }
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "1", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "slackTime.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("1", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "slackTime.txt");
                strVector.addValue(str);
            }
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "2", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "criticalJob.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("2", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "criticalJob.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("0", "-1");
            lm.addEntryToLegendValuesIndexMap("1", "-1");
            lm.addEntryToLegendValuesIndexMap("2", "-1");
        }
        if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null && gcm.isActualBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "3", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "actual.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("3", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "actual.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("3", "-1");
        }
        if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null && gcm.isResourceBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "4", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "resource.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("4", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "resource.txt");
                strVector.addValue(str);
            }
            strVectorSize = strVector.size();
        } else {
            lm.addEntryToLegendValuesIndexMap("4", "-1");
        }
        if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null && gcm.isBaselineBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "5", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "baseline.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("5", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "baseline.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("5", "-1");
        }
        if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null && gcm.isCustomBar1Enabled()) {
            strVectorSize = strVector.size();
            str = this.chkAndGetLegendValue(text, "-1", strVectorSize);
            if (str == null) {
                str = gcm.getCustomSchedule1Label();
            }
            strVector.addValue(str);
        } else {
            lm.addEntryToLegendValuesIndexMap("-1", "-1");
        }
        if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null && gcm.isCustomBar2Enabled()) {
            strVectorSize = strVector.size();
            str = this.chkAndGetLegendValue(text, "-2", strVectorSize);
            if (str == null) {
                str = gcm.getCustomSchedule2Label();
            }
            strVector.addValue(str);
        } else {
            lm.addEntryToLegendValuesIndexMap("-2", "-1");
        }
        if (this.calendarGtkVar != null && this.breaktimeDataSource != null && breakTimeFillStyle != null && breakTimeFillStyle.isVisible()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "6", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "breaktime.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("6", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "breaktime.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("6", "-1");
        }
        if (this.isMilestoneLegendPresent) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "7", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "milestone.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("7", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "milestone.txt");
                strVector.addValue(str);
            }
            lm.setMilestoneMarkerIndex(strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("7", "-1");
        }
        if (this.isTargetLegendPresent) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "8", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "target.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("8", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "target.txt");
                strVector.addValue(str);
            }
            lm.setTargetMarkerIndex(strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("8", "-1");
        }
        this.numLegendEntries = strVector.size();
        return strVector;
    }

    private String chkAndGetLegendValue(String[] text, String originalIndexStr, int currStrVectorSize) {
        LegendModel lm = this.model.getGanttChartModel().getLegendModel();
        if (text != null) {
            int textSize = text.length;
            String keyValue = lm.getValueFromLegendValuesIndexMap(originalIndexStr);
            if (keyValue != null) {
                int keyValueInt = Integer.parseInt(keyValue);
                if (keyValueInt >= 0 && keyValueInt < textSize) {
                    String str = text[keyValueInt];
                    if (keyValueInt != currStrVectorSize) {
                        lm.addEntryToLegendValuesIndexMap(originalIndexStr, "" + currStrVectorSize);
                    }
                    return str;
                }
                if (keyValueInt == -1) {
                    lm.addEntryToLegendValuesIndexMap(originalIndexStr, "" + currStrVectorSize);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap(originalIndexStr, "" + currStrVectorSize);
                int originalIndexInt = Integer.parseInt(originalIndexStr);
                if (originalIndexInt >= 0 && originalIndexInt < textSize) {
                    String str = text[originalIndexInt];
                    return str;
                }
            }
        }
        return null;
    }

    private String[] getStringArray(StringVector strVector) {
        int strVectorSize = strVector.size();
        String[] newLegendValues = new String[strVectorSize];
        try {
            for (int i = 0; i < strVectorSize; ++i) {
                newLegendValues[i] = strVector.getValue(i);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return newLegendValues;
    }

    private StringVector _makeStringVector(String[] values, GanttChartModel gcm, MarkerStyle milestone, MarkerStyle target) {
        StringVector strVector = new StringVector();
        LegendModel lm = gcm.getLegendModel();
        if (lm.getFirstTimeStringVectorCOLOR_BY()) {
            lm.setFirstTimeStringVectorCOLOR_BY(0);
            strVector = this.getInitialStringVectorForCOLOR_BY(values, gcm, milestone, target);
        } else {
            strVector = this.getStringVectorForCOLOR_BY(values, gcm, milestone, target);
        }
        return strVector;
    }

    private StringVector getInitialStringVectorForCOLOR_BY(String[] values, GanttChartModel gcm, MarkerStyle milestone, MarkerStyle target) {
        int legendSize = values.length;
        gcm.getLegendModel().setActualCOLOR_BYLegendSize(legendSize);
        StringVector stringVector = new StringVector();
        for (int ii = 0; ii < legendSize; ++ii) {
            String str = values[ii];
            stringVector.addValue(str);
        }
        this.setLegendCategoryValues(stringVector);
        if (this.durationGtkVar != null && milestone != null && milestone.isVisible()) {
            String milestoneStr = RB.getStringResource(RB_KEY, "milestone.txt");
            stringVector.addValue(milestoneStr);
            int index = stringVector.size() - 1;
            this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerIndex(index);
        }
        if (this.targetGtkVar != null && target != null && target.isVisible()) {
            String targetStr = RB.getStringResource(RB_KEY, "target.txt");
            stringVector.addValue(targetStr);
            int index = stringVector.size() - 1;
            this.model.getGanttChartModel().getLegendModel().setTargetMarkerIndex(index);
        }
        this.numLegendEntries = stringVector.size();
        return stringVector;
    }

    private StringVector getStringVectorForCOLOR_BY(String[] values, GanttChartModel gcm, MarkerStyle milestone, MarkerStyle target) {
        int valuesSize = values.length;
        StringVector stringVector = new StringVector();
        int milestoneIndex = this.model.getGanttChartModel().getLegendModel().getMilestoneMarkerIndex();
        int targetIndex = this.model.getGanttChartModel().getLegendModel().getTargetMarkerIndex();
        int legendSize = gcm.getLegendModel().getActualCOLOR_BYLegendSize();
        if (legendSize > valuesSize) {
            legendSize = valuesSize;
        }
        for (int ii = 0; ii < legendSize; ++ii) {
            String str = values[ii];
            stringVector.addValue(str);
        }
        this.setLegendCategoryValues(stringVector);
        legendSize = values.length - 1;
        if (this.durationGtkVar != null && milestone != null && milestone.isVisible()) {
            int index;
            String milestoneStr;
            if (milestoneIndex != -1 && legendSize >= milestoneIndex) {
                milestoneStr = values[milestoneIndex];
                if (milestoneStr != null) {
                    stringVector.addValue(milestoneStr);
                    index = stringVector.size() - 1;
                    this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerIndex(index);
                } else {
                    milestoneStr = RB.getStringResource(RB_KEY, "milestone.txt");
                    stringVector.addValue(milestoneStr);
                    index = stringVector.size() - 1;
                    this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerIndex(index);
                }
            } else {
                milestoneStr = RB.getStringResource(RB_KEY, "milestone.txt");
                stringVector.addValue(milestoneStr);
                index = stringVector.size() - 1;
                this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerIndex(index);
            }
            this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerFlag(true);
        } else {
            int index = -1;
            this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerIndex(index);
            this.model.getGanttChartModel().getLegendModel().setMilestoneMarkerFlag(false);
        }
        if (this.targetGtkVar != null && target != null && target.isVisible()) {
            if (targetIndex != -1 && legendSize >= targetIndex) {
                String targetStr = values[targetIndex];
                if (targetStr != null) {
                    stringVector.addValue(targetStr);
                    int index = stringVector.size() - 1;
                    this.model.getGanttChartModel().getLegendModel().setTargetMarkerIndex(index);
                } else {
                    targetStr = RB.getStringResource(RB_KEY, "target.txt");
                    stringVector.addValue(targetStr);
                    int index = stringVector.size() - 1;
                    this.model.getGanttChartModel().getLegendModel().setTargetMarkerIndex(index);
                }
            } else {
                String targetStr = RB.getStringResource(RB_KEY, "target.txt");
                stringVector.addValue(targetStr);
                int index = stringVector.size() - 1;
                this.model.getGanttChartModel().getLegendModel().setTargetMarkerIndex(index);
            }
            this.model.getGanttChartModel().getLegendModel().setTargetMarkerFlag(true);
        } else {
            int index = -1;
            this.model.getGanttChartModel().getLegendModel().setTargetMarkerIndex(index);
            this.model.getGanttChartModel().getLegendModel().setTargetMarkerFlag(false);
        }
        return stringVector;
    }

    private StringVector _makeStringVectorWithOutSlackTime(MarkerStyle target, MarkerStyle milestone, GanttChartModel gcm, FillStyle breakTimeFillStyle, String[] text) {
        String str;
        int strVectorSize;
        StringVector strVector = new StringVector();
        LegendModel lm = gcm.getLegendModel();
        boolean isTextNotNull = false;
        if (text != null) {
            isTextNotNull = true;
        }
        if (gcm.isGanttBarEnabled() && !gcm.isSlackTimeEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "0", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "normalJob.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("0", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "normalJob.txt");
                strVector.addValue(str);
            }
            lm.addEntryToLegendValuesIndexMap("1", "-1");
            lm.addEntryToLegendValuesIndexMap("2", "-1");
        } else {
            lm.addEntryToLegendValuesIndexMap("0", "-1");
            lm.addEntryToLegendValuesIndexMap("1", "-1");
            lm.addEntryToLegendValuesIndexMap("2", "-1");
        }
        if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null && gcm.isActualBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "3", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "actual.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("3", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "actual.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("3", "-1");
        }
        if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null && gcm.isResourceBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "4", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "resource.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("4", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "resource.txt");
                strVector.addValue(str);
            }
            strVectorSize = strVector.size();
        } else {
            lm.addEntryToLegendValuesIndexMap("4", "-1");
        }
        if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null && gcm.isBaselineBarEnabled()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "5", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "baseline.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("5", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "baseline.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("5", "-1");
        }
        if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null && gcm.isCustomBar1Enabled()) {
            strVectorSize = strVector.size();
            str = this.chkAndGetLegendValue(text, "-1", strVectorSize);
            if (str == null) {
                str = gcm.getCustomSchedule1Label();
            }
            strVector.addValue(str);
        } else {
            lm.addEntryToLegendValuesIndexMap("-1", "-1");
        }
        if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null && gcm.isCustomBar2Enabled()) {
            strVectorSize = strVector.size();
            str = this.chkAndGetLegendValue(text, "-2", strVectorSize);
            if (str == null) {
                str = gcm.getCustomSchedule2Label();
            }
            strVector.addValue(str);
        } else {
            lm.addEntryToLegendValuesIndexMap("-2", "-1");
        }
        if (this.calendarGtkVar != null && this.breaktimeDataSource != null && breakTimeFillStyle != null && breakTimeFillStyle.isVisible()) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "6", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "breaktime.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("6", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "breaktime.txt");
                strVector.addValue(str);
            }
        } else {
            lm.addEntryToLegendValuesIndexMap("6", "-1");
        }
        if (this.isMilestoneLegendPresent) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "7", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "milestone.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("7", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "milestone.txt");
                strVector.addValue(str);
            }
            lm.setMilestoneMarkerIndex(strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("7", "-1");
        }
        if (this.isTargetLegendPresent) {
            strVectorSize = strVector.size();
            if (isTextNotNull) {
                str = this.chkAndGetLegendValue(text, "8", strVectorSize);
                if (str != null) {
                    strVector.addValue(str);
                } else {
                    str = RB.getStringResource(RB_KEY, "target.txt");
                    strVector.addValue(str);
                }
            } else {
                lm.addEntryToLegendValuesIndexMap("8", "" + strVectorSize);
                str = RB.getStringResource(RB_KEY, "target.txt");
                strVector.addValue(str);
            }
            lm.setTargetMarkerIndex(strVectorSize);
        } else {
            lm.addEntryToLegendValuesIndexMap("8", "-1");
        }
        this.numSlackLegendEntries = strVector.size();
        return strVector;
    }

    private ColorVector _makeColorVectorWithOutSlackTime(FillStyle[] fillStyles, MarkerStyle milestone, MarkerStyle target, FillStyle breakTime, GanttChartModel gcm) {
        Color fc = null;
        ColorVector colorVector = new ColorVector(this.numSlackLegendEntries);
        int ii = 0;
        int index = 0;
        if (gcm.isGanttBarEnabled() && !gcm.isSlackTimeEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(175, 193, 122);
            colorVector.insertValueAt(fc, ii++);
        }
        index += 3;
        if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null && gcm.isActualBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(156, 167, 199);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null && gcm.isResourceBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(171, 145, 169);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null && gcm.isBaselineBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(195, 210, 213);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null && gcm.isCustomBar1Enabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(255, 255, 119);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null && gcm.isCustomBar2Enabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(192, 192, 192);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.calendarGtkVar != null && this.breaktimeDataSource != null && breakTime != null && breakTime.isVisible()) {
            if (breakTime != null) {
                fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(195, 210, 213);
            }
            colorVector.insertValueAt(fc, ii++);
        }
        if (this.isMilestoneLegendPresent) {
            fc = milestone.getColor();
            colorVector.insertValueAt(fc, ii++);
        }
        if (this.isTargetLegendPresent) {
            fc = target.getColor();
            colorVector.insertValueAt(fc, ii++);
        }
        return colorVector;
    }

    private IntegerVector _makeMarkerVectorWithOutSlackTime(MarkerStyle milestone, MarkerStyle target) {
        int mkr;
        int ii = 0;
        IntegerVector intVector = new IntegerVector(this.numSlackLegendEntries);
        int num = this.numSlackLegendEntries;
        if (this.isMilestoneLegendPresent) {
            --num;
        }
        if (this.isTargetLegendPresent) {
            --num;
        }
        for (ii = 0; ii < num; ++ii) {
            mkr = 19;
            intVector.insertValueAt(mkr, ii);
        }
        if (this.isMilestoneLegendPresent) {
            intVector.insertValueAt(milestone.getSymbol(), ii++);
        }
        if (this.isTargetLegendPresent) {
            mkr = target.getSymbol();
            intVector.insertValueAt(mkr, ii);
        }
        return intVector;
    }

    private ColorVector _makeColorVector(String[] values, GanttChartModel gcm, FillStyle[] fillStyles, Color[] cycleColors, MarkerStyle milestone, MarkerStyle target) {
        ColorVector colorVector = new ColorVector();
        LegendModel lm = gcm.getLegendModel();
        if (lm.getFirstTimeColorVectorCOLOR_BY()) {
            lm.setFirstTimeColorVectorCOLOR_BY(0);
            colorVector = this.getInitialColorVectorForCOLOR_BY(values, gcm, fillStyles, cycleColors, milestone, target);
        } else {
            colorVector = this.getColorVectorForCOLOR_BY(values, gcm, fillStyles, cycleColors, milestone, target);
        }
        return colorVector;
    }

    private ColorVector getInitialColorVectorForCOLOR_BY(String[] values, GanttChartModel gcm, FillStyle[] fillStyles, Color[] cycleColors, MarkerStyle milestone, MarkerStyle target) {
        Color color = null;
        ColorVector colorVector = new ColorVector();
        boolean isVisible = true;
        int legendSize = gcm.getLegendModel().getActualCOLOR_BYLegendSize();
        for (int ii = 0; ii < legendSize; ++ii) {
            color = INVISIBLE_COLOR;
            if (fillStyles != null && ii < fillStyles.length && fillStyles[ii] != null) {
                color = fillStyles[ii].getSolidFillColor();
                isVisible = fillStyles[ii].isVisible();
                if (!isVisible) {
                    color = INVISIBLE_COLOR;
                }
            } else if (ii / fillStyles.length > 0) {
                color = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, ii);
            }
            colorVector.insertValueAt(color, ii);
        }
        this.setLegendCategoryColors(colorVector);
        if (this.durationGtkVar != null && milestone != null && milestone.isVisible()) {
            color = milestone.getColor();
            colorVector.addValue(color);
        }
        if (this.targetGtkVar != null && target != null && target.isVisible()) {
            color = target.getColor();
            colorVector.addValue(color);
        }
        return colorVector;
    }

    private ColorVector getColorVectorForCOLOR_BY(String[] values, GanttChartModel gcm, FillStyle[] fillStyles, Color[] cycleColors, MarkerStyle milestone, MarkerStyle target) {
        Color color = null;
        ColorVector colorVector = new ColorVector();
        boolean isVisible = true;
        int valuesSize = values.length;
        int legendSize = gcm.getLegendModel().getActualCOLOR_BYLegendSize();
        if (legendSize > valuesSize) {
            legendSize = valuesSize;
        }
        for (int ii = 0; ii < legendSize; ++ii) {
            color = INVISIBLE_COLOR;
            if (fillStyles != null && ii < fillStyles.length && fillStyles[ii] != null) {
                color = fillStyles[ii].getSolidFillColor();
                isVisible = fillStyles[ii].isVisible();
                if (!isVisible) {
                    color = INVISIBLE_COLOR;
                }
            } else if (ii / fillStyles.length > 0) {
                color = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, ii);
            }
            colorVector.addValue(color);
        }
        this.setLegendCategoryColors(colorVector);
        if (this.durationGtkVar != null && milestone != null && milestone.isVisible()) {
            color = milestone.getColor();
            colorVector.addValue(color);
        }
        if (this.targetGtkVar != null && target != null && target.isVisible()) {
            color = target.getColor();
            colorVector.addValue(color);
        }
        return colorVector;
    }

    private ColorVector _makeColorVector(FillStyle[] fillStyles, MarkerStyle milestone, MarkerStyle target, FillStyle breakTime, GanttChartModel gcm) {
        Color fc = null;
        ColorVector colorVector = new ColorVector(this.numLegendEntries);
        int ii = 0;
        int index = 0;
        if (gcm.isGanttBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(175, 193, 122);
            colorVector.insertValueAt(fc, ii++);
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[++index].getSolidFillColor() : new Color(242, 229, 157);
            colorVector.insertValueAt(fc, ii++);
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[++index].getSolidFillColor() : new Color(218, 123, 123);
            colorVector.insertValueAt(fc, ii++);
            ++index;
        } else {
            index += 3;
        }
        if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null && gcm.isActualBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(156, 167, 199);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null && gcm.isResourceBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(171, 145, 169);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null && gcm.isBaselineBarEnabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(195, 210, 213);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null && gcm.isCustomBar1Enabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(255, 255, 119);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null && gcm.isCustomBar2Enabled()) {
            fc = fillStyles != null && fillStyles.length > index && fillStyles[index] != null ? fillStyles[index].getSolidFillColor() : new Color(192, 192, 192);
            colorVector.insertValueAt(fc, ii++);
        }
        ++index;
        if (this.calendarGtkVar != null && this.breaktimeDataSource != null && breakTime != null && breakTime.isVisible()) {
            fc = breakTime != null ? breakTime.getSolidFillColor() : new Color(195, 210, 213);
            colorVector.insertValueAt(fc, ii++);
        }
        if (this.isMilestoneLegendPresent) {
            fc = milestone.getColor();
            colorVector.insertValueAt(fc, ii++);
        }
        if (this.isTargetLegendPresent) {
            fc = target.getColor();
            colorVector.insertValueAt(fc, ii++);
        }
        return colorVector;
    }

    private IntegerVector _makeMarkerVector(MarkerStyle milestone, MarkerStyle target) {
        int mkr;
        int ii = 0;
        IntegerVector intVector = new IntegerVector(this.numLegendEntries);
        int num = this.numLegendEntries;
        if (this.isMilestoneLegendPresent) {
            --num;
        }
        if (this.isTargetLegendPresent) {
            --num;
        }
        for (ii = 0; ii < num; ++ii) {
            mkr = 19;
            intVector.insertValueAt(mkr, ii);
        }
        if (this.isMilestoneLegendPresent) {
            intVector.insertValueAt(milestone.getSymbol(), ii++);
        }
        if (this.isTargetLegendPresent) {
            mkr = target.getSymbol();
            intVector.insertValueAt(mkr, ii);
        }
        return intVector;
    }

    private IntegerVector _makeMarkerVectorCOLOR_BY(String[] values, GanttChartModel gcm, MarkerStyle milestone, MarkerStyle target) {
        int mkr;
        IntegerVector intVector = new IntegerVector();
        int valuesSize = values.length;
        int legendSize = gcm.getLegendModel().getActualCOLOR_BYLegendSize();
        if (legendSize > valuesSize) {
            legendSize = valuesSize;
        }
        for (int ii = 0; ii < legendSize; ++ii) {
            mkr = 19;
            intVector.insertValueAt(mkr, ii);
        }
        if (this.durationGtkVar != null && milestone != null && milestone.isVisible()) {
            mkr = milestone.getSymbol();
            intVector.addValue(mkr);
        }
        if (this.targetGtkVar != null && target != null && target.isVisible()) {
            mkr = target.getSymbol();
            intVector.addValue(mkr);
        }
        return intVector;
    }

    @Override
    public void validateTree() {
        if (this.outerMargin == null) {
            super.validateTree();
            return;
        }
        Insets oldOuterMargin = (Insets)this.outerMargin.clone();
        Dimension oldMargin = (Dimension)this.margin.clone();
        super.validateTree();
        Double newAxisAdj = new Double(this.outerMargin.top);
        if (newAxisAdj.intValue() == 0) {
            this.outerMargin.left = oldOuterMargin.left;
            this.outerMargin.top = oldOuterMargin.top;
            this.outerMargin.right = oldOuterMargin.right;
            this.outerMargin.bottom = oldOuterMargin.bottom;
            if (this.margin != null) {
                this.margin.height = oldMargin.height;
                this.margin.width = oldMargin.width;
            }
        }
    }

    public void _findDateAxisRange() {
        if (this.earlyStartGtkVar != null && this.earlyFinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.earlyStartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.earlyStartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.earlyFinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.earlyFinishGtkVar).getMax());
            if (this.lateStartGtkVar != null && this.lateFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.lateStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.lateStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.lateFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.lateFinishGtkVar).getMax());
            }
            if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.actualStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.actualStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.actualFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.actualFinishGtkVar).getMax());
            }
            if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceFinishGtkVar).getMax());
            }
            if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineFinishGtkVar).getMax());
            }
            if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom1StartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom1StartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom1FinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom1FinishGtkVar).getMax());
            }
            if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom2StartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom2StartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom2FinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom2FinishGtkVar).getMax());
            }
        } else if (this.lateStartGtkVar != null && this.lateFinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.lateStartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.lateStartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.lateFinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.lateFinishGtkVar).getMax());
            if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.actualStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.actualStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.actualFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.actualFinishGtkVar).getMax());
            }
            if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceFinishGtkVar).getMax());
            }
            if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineFinishGtkVar).getMax());
            }
            if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom1StartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom1StartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom1FinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom1FinishGtkVar).getMax());
            }
            if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom2StartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom2StartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom2FinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom2FinishGtkVar).getMax());
            }
        } else if (this.actualStartGtkVar != null && this.actualFinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.actualStartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.actualStartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.actualFinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.actualFinishGtkVar).getMax());
            if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null) {
                this.rangeMin = ((NumericVariable)this.resourceStartGtkVar).getMin();
                this.rangeMax = ((NumericVariable)this.resourceStartGtkVar).getMax();
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceFinishGtkVar).getMax());
            }
            if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineFinishGtkVar).getMax());
            }
        } else if (this.custom1StartGtkVar != null && this.custom1FinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.custom1StartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.custom1StartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom1FinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom1FinishGtkVar).getMax());
            if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null) {
                this.rangeMin = ((NumericVariable)this.resourceStartGtkVar).getMin();
                this.rangeMax = ((NumericVariable)this.resourceStartGtkVar).getMax();
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceFinishGtkVar).getMax());
            }
            if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineFinishGtkVar).getMax());
            }
        } else if (this.custom2StartGtkVar != null && this.custom2FinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.custom2StartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.custom2StartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.custom2FinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.custom2FinishGtkVar).getMax());
            if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null) {
                this.rangeMin = ((NumericVariable)this.resourceStartGtkVar).getMin();
                this.rangeMax = ((NumericVariable)this.resourceStartGtkVar).getMax();
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceFinishGtkVar).getMax());
            }
            if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineFinishGtkVar).getMax());
            }
        } else if (this.resourceStartGtkVar != null && this.resourceFinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.resourceStartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.resourceStartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.resourceFinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.resourceFinishGtkVar).getMax());
            if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineStartGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineStartGtkVar).getMax());
                this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.baselineFinishGtkVar).getMin());
                this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.baselineFinishGtkVar).getMax());
            }
        } else if (this.baselineStartGtkVar != null && this.baselineFinishGtkVar != null) {
            this.rangeMin = ((NumericVariable)this.actualStartGtkVar).getMin();
            this.rangeMax = ((NumericVariable)this.actualStartGtkVar).getMax();
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.actualFinishGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.actualFinishGtkVar).getMax());
        } else {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noStartFinishPairSpecified.ex.txt"));
        }
        if (this.targetGtkVar != null) {
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.targetGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.targetGtkVar).getMax());
        }
        if (this.markerPosGtkVar != null) {
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.markerPosGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.markerPosGtkVar).getMax());
        }
        if (this.annoPosGtkVar != null) {
            this.rangeMin = Math.min(this.rangeMin, ((NumericVariable)this.annoPosGtkVar).getMin());
            this.rangeMax = Math.max(this.rangeMax, ((NumericVariable)this.annoPosGtkVar).getMax());
        }
    }

    private GTKFormat _checkForFormatConflict(GTKFormat gtkFormat1, com.sas.graphics.util.gtk.Variable var) {
        GTKFormat gtkFormat2 = null;
        String sasFormatName2 = null;
        SASFormat sasFormat1 = null;
        SASFormat sasFormat2 = null;
        if (var != null) {
            if (gtkFormat1 == null) {
                gtkFormat1 = var.getFormat();
                if (gtkFormat1 != null) {
                    this.sasFormatName1 = var.getSASFormatName();
                }
            } else {
                gtkFormat2 = var.getFormat();
                if (gtkFormat2 != null) {
                    sasFormatName2 = var.getSASFormatName();
                }
            }
            if (this.sasFormatName1 != null && sasFormatName2 != null) {
                sasFormat1 = SASFormat.getInstance((String)this.sasFormatName1);
                sasFormat2 = SASFormat.getInstance((String)sasFormatName2);
                if (sasFormat1.isDateFormat() != sasFormat2.isDateFormat() || sasFormat1.isDateTimeFormat() != sasFormat2.isDateTimeFormat() || sasFormat1.isTimeFormat() != sasFormat2.isTimeFormat()) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "formatConflict.ex.txt"));
                }
            }
        }
        return gtkFormat1;
    }

    private GTKFormat _validate(GTKFormat gtkFormat, com.sas.graphics.util.gtk.Variable var) {
        if (gtkFormat == null) {
            gtkFormat = this._checkForFormatConflict(null, var);
        } else {
            this._checkForFormatConflict(gtkFormat, var);
        }
        return gtkFormat;
    }

    public GTKFormat _findValidDateAxisFormat() {
        GTKFormat gtkFormat = null;
        gtkFormat = this._validate(gtkFormat, this.earlyStartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.earlyFinishGtkVar);
        gtkFormat = this._validate(gtkFormat, this.lateStartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.lateFinishGtkVar);
        gtkFormat = this._validate(gtkFormat, this.actualStartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.actualFinishGtkVar);
        gtkFormat = this._validate(gtkFormat, this.custom1StartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.custom1FinishGtkVar);
        gtkFormat = this._validate(gtkFormat, this.custom2StartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.custom2FinishGtkVar);
        gtkFormat = this._validate(gtkFormat, this.resourceStartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.resourceFinishGtkVar);
        gtkFormat = this._validate(gtkFormat, this.baselineStartGtkVar);
        gtkFormat = this._validate(gtkFormat, this.baselineFinishGtkVar);
        return gtkFormat;
    }

    public ArrayList getComponentVariableOrderList() {
        return this.componentVariableArrayList;
    }

    public ArrayList getComponentSuccessorVariables() {
        return this.componentSuccessorVariableArrayList;
    }

    public void setTableDataModel(GanttTableDataModel gctdm) {
        this.gcTableDataModel = gctdm;
    }

    public GanttTableDataModel getTableDataModel() {
        return this.gcTableDataModel;
    }

    public void clearComponentVariableArrayList() {
        this.componentVariableArrayList = null;
    }

    public void addToComponentVariableArrayList(Object role, Variable suppVar) {
        String str = (String)role;
        int idx = -1;
        if (this.componentVariableArrayList == null) {
            this.componentVariableArrayList = new ArrayList();
        }
        if (str.toString().compareTo("TaskVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getTaskVariable());
        } else if (str.toString().compareTo("DescriptionVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getDescriptionVariable());
        } else if (str.toString().compareTo("durationVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getDurationVariable());
        } else if (str.toString().compareTo("earlyStartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getEarlyStartVariable());
        } else if (str.toString().compareTo("earlyFinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getEarlyFinishVariable());
        } else if (str.toString().compareTo("lateStartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getLateStartVariable());
        } else if (str.toString().compareTo("lateFinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getLateFinishVariable());
        } else if (str.toString().compareTo("baselineStartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getBaselineStartVariable());
        } else if (str.toString().compareTo("baselineFinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getBaselineFinishVariable());
        } else if (str.toString().compareTo("actualStartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getActualStartVariable());
        } else if (str.toString().compareTo("actualFinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getActualFinishVariable());
        } else if (str.toString().compareTo("custom1StartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getCustom1StartVariable());
        } else if (str.toString().compareTo("custom1FinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getCustom1FinshVariable());
        } else if (str.toString().compareTo("custom2StartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getCustom2StartVariable());
        } else if (str.toString().compareTo("custom2FinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getCustom2FinshVariable());
        } else if (str.toString().compareTo("resourceStartVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getResourceStartVariable());
        } else if (str.toString().compareTo("resourceFinishVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getResourceFinishVariable());
        } else if (str.toString().compareTo("targetVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getTargetVariable());
        } else if (str.toString().compareTo("colorVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getColorVariable());
        } else if (str.toString().compareTo("parentVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getParentVariable());
        } else if (str.toString().compareTo("markerTaskVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationTaskVariable());
        } else if (str.toString().compareTo("markerLocationVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationLocationVariable());
        } else if (str.toString().compareTo("markerPositionVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationPositionVariable());
        } else if (str.toString().compareTo("markerSymbolVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationSymbolVariable());
        } else if (str.toString().compareTo("markerSymbolColorVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationSymbolColorVariable());
        } else if (str.toString().compareTo("markerTextColorVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationLabelColorVariable());
        } else if (str.toString().compareTo("markerTextVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getAnnotationLabelVariable());
        } else if (str.toString().compareTo("supplementaryVariable") == 0) {
            this.componentVariableArrayList.add(suppVar);
        } else if (str.toString().compareTo("replaceWithChildrenVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getReplaceWithChildrenVariable());
        } else if (str.toString().compareTo("styleByVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getStyleByVariable());
        } else if (str.toString().compareTo("drawBarVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getDrawBarVariable());
        } else if (str.toString().compareTo("calendarVariable") == 0) {
            this.componentVariableArrayList.add(this.gcTableDataModel.getCalendarVariable());
        } else if (str.toString().compareTo("SuccessorVariable") == 0) {
            Variable var = this.gcTableDataModel.getSuccessorVariable();
            if (this.componentSuccessorVariableArrayList == null) {
                this.componentSuccessorVariableArrayList = new ArrayList();
            }
            this.componentVariableArrayList.add(var);
            this.componentSuccessorVariableArrayList.add(var);
        } else {
            idx = str.toString().indexOf("datatipVariable");
            if (idx > -1) {
                String index = new String();
                idx = str.toString().indexOf("e");
                index = str.toString().substring(idx + 1, str.length());
                Integer ii = new Integer(index);
                int iii = ii;
                Variable[] dataTipVars = this.gcTableDataModel.getDataTipVariables();
                this.componentVariableArrayList.add(dataTipVars[iii]);
            } else {
                idx = str.toString().indexOf("auxiliaryVariable");
                if (idx > -1) {
                    String index = new String();
                    idx = str.toString().indexOf("e");
                    index = str.toString().substring(idx + 1, str.length());
                    Integer ii = new Integer(index);
                    int iii = ii;
                    Variable[] auxVars = this.gcTableDataModel.getAuxiliaryVariables();
                    this.componentVariableArrayList.add(auxVars[iii]);
                }
            }
        }
    }

    @Override
    protected List getCells() {
        return this.ganttCells;
    }

    @Override
    public Component getBrushableComponent() {
        GanttChartComposite ganttCell;
        if (this.ganttCells != null && (ganttCell = (GanttChartComposite)this.ganttCells.get(0)) != null) {
            return ganttCell.getBrushableComponent();
        }
        return this;
    }

    private TreeTableRow _findTreeTableRow(String taskName, TableModel tm) {
        if (tm instanceof TreeTableModel) {
            TreeTableModel ttm = (TreeTableModel)tm;
            int r1 = ttm.getRowCount(false);
            for (int rx = 0; rx < r1; ++rx) {
                TreeTableRow row = ttm.getRowAt(rx, false);
                if (!row.getTableRow()[this.taskIdx].equals(taskName)) continue;
                return row;
            }
        }
        return null;
    }

    private class TableAxisModelToTreeTableRelay
    implements PropertyChangeListener {
        TableAxisModel tam;

        public void setTableAxisModel(TableAxisModel m) {
            if (this.tam != null) {
                this.tam.removePropertyChangeListener(this);
            }
            this.tam = m;
            if (this.tam != null) {
                this.tam.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            block13: {
                String name;
                block31: {
                    Object x1;
                    String subname;
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    String newLink;
                                    String taskName;
                                    block27: {
                                        block25: {
                                            int newDepth;
                                            block22: {
                                                String newName;
                                                String oldName;
                                                block24: {
                                                    block23: {
                                                        block19: {
                                                            String newName2;
                                                            String oldName2;
                                                            block21: {
                                                                block20: {
                                                                    block18: {
                                                                        block17: {
                                                                            block14: {
                                                                                String newName3;
                                                                                String oldName3;
                                                                                block16: {
                                                                                    block15: {
                                                                                        name = e.getPropertyName();
                                                                                        subname = "";
                                                                                        int dp = name.indexOf(".");
                                                                                        if (dp >= 0) {
                                                                                            subname = name.substring(dp + 1);
                                                                                            name = name.substring(0, dp);
                                                                                        }
                                                                                        if (this.tam == null || name == null || GanttChartMatrix.this.treeTable == null) {
                                                                                            return;
                                                                                        }
                                                                                        if (!name.equals("TableCellPopupMenu")) break block14;
                                                                                        oldName3 = (String)e.getOldValue();
                                                                                        newName3 = (String)e.getNewValue();
                                                                                        if (oldName3 != null || newName3 != null) break block15;
                                                                                        GanttChartMatrix.this.treeTable.removeAllCellPopupItems();
                                                                                        break block13;
                                                                                    }
                                                                                    if (oldName3 != null || newName3 == null) break block16;
                                                                                    CellAction a = null;
                                                                                    for (int i = 0; i < this.tam.getTableCellPopupMenuItemCount(); ++i) {
                                                                                        a = this.tam.getTableCellPopupMenuItem(i);
                                                                                        if (!a.getName().equals(newName3)) continue;
                                                                                        GanttChartMatrix.this.treeTable.addCellPopupItem(a);
                                                                                        break block13;
                                                                                    }
                                                                                    break block13;
                                                                                }
                                                                                if (oldName3 == null || newName3 != null) break block13;
                                                                                GanttChartMatrix.this.treeTable.removeCellPopupItem(oldName3);
                                                                                break block13;
                                                                            }
                                                                            if (!name.equals("TableCellPopupMenuEnabled")) break block17;
                                                                            GanttChartMatrix.this._setTablePopupEnabled();
                                                                            break block13;
                                                                        }
                                                                        if (!name.equals("TableEditable")) break block18;
                                                                        if (this.tam.isTableEditableSet()) {
                                                                            GanttChartMatrix.this.treeTable.setEditable(this.tam.isTableEditable());
                                                                        } else {
                                                                            GanttChartMatrix.this.treeTable.unsetEditable();
                                                                        }
                                                                        break block13;
                                                                    }
                                                                    if (!name.equals("TableRowsEditable")) break block19;
                                                                    oldName2 = (String)e.getOldValue();
                                                                    newName2 = (String)e.getNewValue();
                                                                    if (oldName2 != null || newName2 != null) break block20;
                                                                    GanttChartMatrix.this._setAllTableRowsEditable(true);
                                                                    break block13;
                                                                }
                                                                if (oldName2 != null || newName2 == null) break block21;
                                                                GanttChartMatrix.this._setTableRowEditable(newName2, this.tam.getTableRowEditable(newName2));
                                                                break block13;
                                                            }
                                                            if (oldName2 == null || newName2 != null) break block13;
                                                            GanttChartMatrix.this._setTableRowEditable(newName2, true);
                                                            break block13;
                                                        }
                                                        if (!name.equals("TableColumnsEditable")) break block22;
                                                        oldName = (String)e.getOldValue();
                                                        newName = (String)e.getNewValue();
                                                        if (oldName != null || newName != null) break block23;
                                                        GanttChartMatrix.this._setAllTableColumnsEditable(true);
                                                        break block13;
                                                    }
                                                    if (oldName != null || newName == null) break block24;
                                                    GanttChartMatrix.this._setTableColumnEditable(newName, this.tam.getTableColumnEditable(newName));
                                                    break block13;
                                                }
                                                if (oldName == null || newName != null) break block13;
                                                GanttChartMatrix.this._setTableColumnEditable(newName, true);
                                                break block13;
                                            }
                                            if (!name.equals("TreeExpansionDepth")) break block25;
                                            GanttChartMatrix.this.treeTableInitialDepth = newDepth = ((Integer)e.getNewValue()).intValue();
                                            GanttChartMatrix.this.treeTable.expandToDepth(newDepth, true);
                                            break block13;
                                        }
                                        if (!name.equals("taskLinks")) break block26;
                                        taskName = subname;
                                        String oldLink = (String)e.getOldValue();
                                        newLink = (String)e.getNewValue();
                                        if (!taskName.equals("*") || !oldLink.equals("*") || newLink != null) break block27;
                                        TreeTableModel ttm = null;
                                        if (GanttChartMatrix.this.treeTable.getModel() instanceof TreeTableModel) {
                                            ttm = (TreeTableModel)GanttChartMatrix.this.treeTable.getModel();
                                        }
                                        int r1 = ttm.getRowCount(false);
                                        for (int rx = 0; rx < r1; ++rx) {
                                            TreeTableRow row = ttm.getRowAt(rx, false);
                                            if (row == null) continue;
                                            row.setLinkCommand(0, null);
                                        }
                                        break block13;
                                    }
                                    TreeTableRow row = GanttChartMatrix.this._findTreeTableRow(taskName, GanttChartMatrix.this.treeTable.getModel());
                                    if (row == null) break block13;
                                    row.setLinkCommand(0, newLink);
                                    break block13;
                                }
                                if (!name.equals("treeOpenIcon")) break block28;
                                TreeCellRenderer cr = GanttChartMatrix.this.treeTable.getTreeCellRenderer();
                                if (!(cr instanceof DefaultTreeCellRenderer)) break block13;
                                DefaultTreeCellRenderer dcr = (DefaultTreeCellRenderer)cr;
                                if (this.tam.getHierarchyModel().getTreeIconModel() != null) {
                                    dcr.setOpenIcon(this.tam.getHierarchyModel().getTreeIconModel().getOpenIcon());
                                }
                                break block13;
                            }
                            if (!name.equals("treeClosedIcon")) break block29;
                            TreeCellRenderer cr = GanttChartMatrix.this.treeTable.getTreeCellRenderer();
                            if (!(cr instanceof DefaultTreeCellRenderer)) break block13;
                            DefaultTreeCellRenderer dcr = (DefaultTreeCellRenderer)cr;
                            if (this.tam.getHierarchyModel().getTreeIconModel() != null) {
                                dcr.setClosedIcon(this.tam.getHierarchyModel().getTreeIconModel().getClosedIcon());
                            }
                            break block13;
                        }
                        if (!name.equals("treeLeafIcon")) break block30;
                        TreeCellRenderer cr = GanttChartMatrix.this.treeTable.getTreeCellRenderer();
                        if (!(cr instanceof DefaultTreeCellRenderer)) break block13;
                        DefaultTreeCellRenderer dcr = (DefaultTreeCellRenderer)cr;
                        if (this.tam.getHierarchyModel().getTreeIconModel() != null) {
                            dcr.setLeafIcon(this.tam.getHierarchyModel().getTreeIconModel().getLeafIcon());
                        }
                        break block13;
                    }
                    if (!name.equals("valueTreeIconModel")) break block31;
                    String taskName = subname;
                    TreeIconModel tim = this.tam.getHierarchyModel().getTreeIconModel(taskName);
                    if (tim == null || (x1 = e.getNewValue()) != null && !(x1 instanceof TreeIconModel)) break block13;
                    TreeTableRow r1 = GanttChartMatrix.this._findTreeTableRow(taskName, GanttChartMatrix.this.treeTable.getModel());
                    TreeTableRow r2 = GanttChartMatrix.this._findTreeTableRow(taskName, (TableModel)GanttChartMatrix.this.dataSource.getModel());
                    TreeIconModel newTim = (TreeIconModel)x1;
                    r1.setOpenIcon(newTim.getOpenIcon());
                    r1.setClosedIcon(newTim.getClosedIcon());
                    r1.setLeafIcon(newTim.getLeafIcon());
                    r2.setOpenIcon(newTim.getOpenIcon());
                    r2.setClosedIcon(newTim.getClosedIcon());
                    r2.setLeafIcon(newTim.getLeafIcon());
                    break block13;
                }
                if (name.equals("clearTreeIconModel")) {
                    for (int i = 0; i < 2; ++i) {
                        TableModel tm;
                        TableModel tableModel = i == 0 ? GanttChartMatrix.this.treeTable.getModel() : (tm = i == 1 ? (TableModel)GanttChartMatrix.this.dataSource.getModel() : null);
                        if (tm == null || !(tm instanceof TreeTableModel)) continue;
                        TreeTableModel ttm = (TreeTableModel)tm;
                        int rx1 = ttm.getRowCount(false);
                        for (int rx = 0; rx < rx1; ++rx) {
                            TreeTableRow ttr = ttm.getRowAt(rx, false);
                            ttr.setIcon(null);
                            ttr.setOpenIcon(null);
                            ttr.setClosedIcon(null);
                            ttr.setLeafIcon(null);
                        }
                    }
                }
            }
        }
    }

    private class SortColumn {
        public SASFormat sasFormat = null;
        public Variable variable = null;
        public int sortType = 10400;
        public int sortIdx = 0;
        public SortColumn next = null;

        public SortColumn(Variable var, SASFormat fmt, int idx, int type) {
            this.sasFormat = fmt;
            this.sortIdx = idx;
            this.sortType = type;
            this.variable = var;
        }

        public void setNext(SortColumn nxt) {
            this.next = nxt;
        }

        public SortColumn getNext() {
            return this.next;
        }
    }

    private class GanttExpansionState
    extends ArrayList {
        private static final long serialVersionUID = 1L;
        ArrayList tasks = null;

        public GanttExpansionState(Collection expansionState) {
            if (expansionState != null && expansionState instanceof ArrayList && ((ArrayList)expansionState).size() > 0) {
                this.tasks = new ArrayList();
                String taskName = null;
                TreeTableRow ttr = null;
                Object[] rows = null;
                for (int ii = 0; ii < expansionState.size(); ++ii) {
                    ttr = (TreeTableRow)((ArrayList)expansionState).get(ii);
                    rows = ttr.getTableRow();
                    if (rows == null || rows.length <= 0) continue;
                    taskName = rows[GanttChartMatrix.this.taskIdx].toString();
                    this.tasks.add(taskName);
                }
            }
        }

        @Override
        public boolean contains(Object o) {
            if (this.tasks != null && o != null && o instanceof TreeTableRow && ((TreeTableRow)o).getTableRow() != null && ((TreeTableRow)o).getTableRow().length > 0) {
                String taskName = null;
                Object[] rows = ((TreeTableRow)o).getTableRow();
                if (rows != null && rows.length > 0 && this.tasks.contains(taskName = rows[GanttChartMatrix.this.taskIdx].toString())) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class IndependentAxisCellFactory
    implements Matrix.CellFactoryInterface {
        private IndependentAxisCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            return new AxisCell((AxisCellModel)cellModel, channel);
        }
    }

    private static class DependentAxisCellFactory
    implements Matrix.CellFactoryInterface {
        private DependentAxisCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            return new CompoundTimeAxisCell((CompoundTimeAxisCellModel)cellModel, channel);
        }
    }

    private static class GanttCellFactory
    implements Matrix.CellFactoryInterface {
        private GanttCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSources, Channel channel) {
            if (dataSources != null && dataSources.length > 0) {
                DataSource[] newDataSources = new DataSource[dataSources.length];
                for (int ii = 0; ii < dataSources.length; ++ii) {
                    if (dataSources[ii] == null) continue;
                    newDataSources[ii] = dataSources[ii].newDataSourceWhere(null);
                }
                return new GanttChartComposite((GanttChartCellModel)cellModel, newDataSources, channel);
            }
            return null;
        }
    }

    private class CellActionRelay
    implements ActionListener {
        private CellActionRelay() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e instanceof CellActionEvent) {
                GanttChartMatrix.this.fireLinkActionEvent((CellActionEvent)e);
            }
        }
    }

    private class DoubleClickToGraphActionRelay
    extends MouseAdapter {
        private DoubleClickToGraphActionRelay() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getID() == 500 && e.getButton() == 1 && e.getClickCount() == 2 && (row = GanttChartMatrix.this.treeTable.rowAtPoint(e.getPoint())) >= 0) {
                TableModel ttm = GanttChartMatrix.this.treeTable.getModel();
                Object value = ttm.getValueAt(row, GanttChartMatrix.this.taskIdx);
                String formattedValue = GanttChartMatrix.this.dataSource.getVariable(GanttChartMatrix.this.model.getTaskRole(), 0).getFormatter().format(value).trim();
                Hashtable<String, Object> labelValue = new Hashtable<String, Object>();
                labelValue.put(PickInfo.VALUE, value);
                labelValue.put(PickInfo.FORMATTED_VALUE, formattedValue);
                Vector[] labelValueCollection = new Vector[]{new Vector()};
                labelValueCollection[0].addElement(labelValue);
                PickInfo pi = new PickInfo(labelValueCollection, row, null, e.getX(), e.getY(), e);
                GraphActionEvent gae = new GraphActionEvent((Object)GanttChartMatrix.this.treeTable, pi);
                GanttChartMatrix.this.fireGraphActionEvent(gae);
            }
        }
    }
}

