/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.barlinechart;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.util.barlinechart.BarLineChartModel;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AxisCell;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.GridDimension;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.LabelPane;
import com.sas.graphics.util.cell.MatrixContainer2;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.barlinechart.BarLineChartCell;
import com.sas.graphics.util.cell.barlinechart.BarLineChartCellModel;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BarLineChartMatrixContainer
extends MatrixContainer2 {
    private static final int PLACEMENT_SPECIAL = -11302;
    private static final int MIN_RESPONSE_AXIS_LENGTH = (int)((double)Util.MIN_FONT_HEIGHT * 2.5);
    private static final int NORTH = 0;
    private static final int MATRIX = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 0;
    private static final int EAST = 2;
    private final transient ValueTree columnTree;
    private final transient ValueTree rowTree;
    private final transient ValueTree integratedTree;
    private final transient boolean isRowEast;
    private final transient boolean isColumnRotationEnabled;
    private static final boolean forceColumnRotationForDebugging = false;
    private final transient CellPane matrixCellPane;
    private final transient CellPane responseAxisCellPane;
    private transient LabelPane responseAxisLabelPane;
    private final transient CellPane response2AxisCellPane;
    private transient LabelPane response2AxisLabelPane;
    private final transient ValuePane columnMatrixAxisValuePane;
    private final transient LabelPane columnMatrixAxisLabelPane;
    private final transient ValuePane rowMatrixAxisValuePane;
    private final transient LabelPane rowMatrixAxisLabelPane;
    private final transient LabelPane categoryAxisLabelPane;
    private final transient JComponent messagesComponent;
    private final transient boolean isVertical;
    private final transient boolean isColumnActive;
    private final transient boolean isRowActive;
    private final transient AxisModel responseAxisModel;
    private final transient AxisModel response2AxisModel;
    private final transient AxisModel categoryAxisModel;
    private transient LayoutCache layoutCache;
    private final transient ZoomScrollBar columnScrollBar;
    private final transient ZoomScrollBar rowScrollBar;
    private final transient MatrixContainer2.ScrollModelProjection columnScrollModelProjection;
    private final transient MatrixContainer2.ScrollModelProjection rowScrollModelProjection;
    private final transient boolean imageMapInfoState_columnIsIntegrated;
    private final transient boolean imageMapInfoState_rowIsIntegrated;

    public BarLineChartMatrixContainer(BarLineChartMatrixModel barLineChartMatrixModel, DataSource dataSource, ValueTree columnTree, ValueTree rowTree, ValueTree integratedTree, CellPane.CellComponentFactory barLineChartCellFactory, CellPane.CellComponentFactory responseAxisCellFactory, CellPane.CellComponentFactory response2AxisCellFactory, MessageModel messageModel, Object categoryRole, SwingActionProvider actionProvider, boolean isRowEast, boolean isAntiAliasingEnabled, boolean isTextAntiAliasingEnabled, Channel channel) {
        super(isAntiAliasingEnabled, isTextAntiAliasingEnabled, channel);
        this.setLayout(null);
        this.setOpaque(false);
        BarLineChartModel graphModel = null;
        this.columnTree = columnTree;
        this.rowTree = rowTree;
        this.integratedTree = integratedTree;
        if (barLineChartMatrixModel == null || dataSource == null || columnTree == null || rowTree == null || barLineChartCellFactory == null) {
            throw new IllegalStateException("required parameter is null");
        }
        graphModel = barLineChartMatrixModel.getBarLineChartModel();
        this.isColumnActive = !columnTree.getRoot().isLeaf();
        this.isRowActive = !rowTree.getRoot().isLeaf();
        this.isColumnRotationEnabled = integratedTree != null && dataSource.isRelationalData();
        this.isVertical = graphModel.getOrientation() == 1;
        this.responseAxisModel = graphModel.getResponseAxisModel();
        this.response2AxisModel = graphModel.getResponse2AxisModel();
        this.categoryAxisModel = graphModel.getCategoryAxisModel();
        this.matrixCellPane = new CellPane(columnTree, rowTree, barLineChartCellFactory, channel);
        ValueTree tree = this.isVertical && integratedTree != null ? integratedTree : columnTree;
        GraphMatrixAxisModel axisModel = graphModel.getColumnAxisModel();
        HierarchicalPane[] cmap = Util.newMatrixAxisPanes(tree, axisModel, dataSource.getDataSourceSelectionModel(), actionProvider, channel);
        this.columnMatrixAxisLabelPane = (LabelPane)cmap[0];
        this.columnMatrixAxisValuePane = (ValuePane)cmap[1];
        tree = !this.isVertical && integratedTree != null ? integratedTree : rowTree;
        axisModel = graphModel.getRowAxisModel();
        HierarchicalPane[] rmap = Util.newMatrixAxisPanes(tree, axisModel, dataSource.getDataSourceSelectionModel(), actionProvider, channel);
        this.rowMatrixAxisLabelPane = (LabelPane)rmap[0];
        this.rowMatrixAxisValuePane = (ValuePane)rmap[1];
        Object[] roles = new Object[]{barLineChartMatrixModel.getBarRole(), barLineChartMatrixModel.getLineRole()};
        Variable[] labelVariables = BarLineChartMatrixContainer.newLabelVariables(this.responseAxisModel, dataSource, roles);
        HierarchicalPane[] rap = this.isVertical ? Util.newRowWiseAxisPanes(rowTree, this.responseAxisModel, responseAxisCellFactory, labelVariables, null, channel) : Util.newColumnWiseAxisPanes(columnTree, this.responseAxisModel, responseAxisCellFactory, labelVariables, null, channel);
        this.responseAxisLabelPane = (LabelPane)rap[0];
        this.responseAxisCellPane = (CellPane)rap[1];
        roles = new Object[]{barLineChartMatrixModel.getBar2Role(), barLineChartMatrixModel.getLine2Role()};
        labelVariables = BarLineChartMatrixContainer.newLabelVariables(this.response2AxisModel, dataSource, roles);
        HierarchicalPane[] r2ap = this.isVertical ? Util.newRowWiseAxisPanes(rowTree, this.response2AxisModel, response2AxisCellFactory, labelVariables, null, channel) : Util.newColumnWiseAxisPanes(columnTree, this.response2AxisModel, response2AxisCellFactory, labelVariables, null, channel);
        this.response2AxisLabelPane = (LabelPane)r2ap[0];
        this.response2AxisCellPane = (CellPane)r2ap[1];
        LegendModel legendModel = graphModel.getLegendModel();
        if (legendModel.isVisible()) {
            if (this.responseAxisLabelPane != null && this.response2AxisLabelPane == null) {
                if (this.responseAxisModel.getLabelPlacementPolicy() == 10200 && this.responseAxisLabelPane.getContentPanelComponentCount() > 1) {
                    this.responseAxisLabelPane = this.responseAxisModel.isAdjustValueMagnitudeEnabled() ? new LabelPane(rowTree, this.responseAxisModel.getLabelTextStyle(), channel) : null;
                }
            } else if (this.responseAxisLabelPane == null && this.response2AxisLabelPane != null && this.response2AxisModel.getLabelPlacementPolicy() == 10200 && this.response2AxisLabelPane.getContentPanelComponentCount() > 1) {
                this.response2AxisLabelPane = this.response2AxisModel.isAdjustValueMagnitudeEnabled() ? new LabelPane(rowTree, this.response2AxisModel.getLabelTextStyle(), channel) : null;
            }
        }
        if (this.isVertical) {
            if (this.rowMatrixAxisValuePane == null) {
                isRowEast = this.responseAxisCellPane == null && this.response2AxisCellPane != null;
            }
            this.isRowEast = isRowEast;
        } else {
            this.isRowEast = false;
        }
        if (integratedTree != null || !graphModel.getCategoryAxisModel().isVisible() || !graphModel.getCategoryAxisModel().getLabelTextStyle().isVisible()) {
            this.categoryAxisLabelPane = null;
        } else {
            AxisModel axisModel2 = graphModel.getCategoryAxisModel();
            labelVariables = BarLineChartMatrixContainer.newLabelVariables(axisModel2, dataSource, new Object[]{categoryRole});
            this.categoryAxisLabelPane = new LabelPane(labelVariables, graphModel.getCategoryAxisModel().getLabelTextStyle(), channel);
        }
        if (barLineChartMatrixModel.getDisplayPolicy() == 10002) {
            ZoomScrollBar[] zsba = BarLineChartMatrixContainer.newColumnRowZoomScrollBars();
            this.columnScrollModelProjection = this.putScrollModel(zsba[0].getModel());
            this.rowScrollModelProjection = this.putScrollModel(zsba[1].getModel());
            this.columnScrollBar = zsba[0];
            this.add((JScrollBar)this.columnScrollBar, "columnScrollBar");
            this.rowScrollBar = zsba[1];
            this.add((JScrollBar)this.rowScrollBar, "rowScrollBar");
        } else {
            this.columnScrollModelProjection = this.putScrollModel(new DefaultBoundedRangeModel(0, 100, 0, 100));
            this.rowScrollModelProjection = this.putScrollModel(new DefaultBoundedRangeModel(0, 100, 0, 100));
            this.rowScrollBar = null;
            this.columnScrollBar = null;
        }
        this.messagesComponent = Util.Message.createMessageComponent(messageModel, channel);
        this.imageMapInfoState_columnIsIntegrated = this.isVertical && integratedTree != null;
        this.imageMapInfoState_rowIsIntegrated = !this.isVertical && integratedTree != null;
        this.add((Component)this.messagesComponent, (Object)"message");
        this.add(this.responseAxisCellPane, "ResponseAxisCellPane");
        this.add(this.responseAxisLabelPane, "ResponseAxisLabelPane");
        this.add(this.response2AxisCellPane, "Response2AxisCellPane");
        this.add(this.response2AxisLabelPane, "Response2AxisLabelPane");
        this.add(this.rowMatrixAxisValuePane, "RowMatrixAxisValuePane");
        this.add(this.rowMatrixAxisLabelPane, "RowMatrixAxisLabelPane");
        this.add(this.columnMatrixAxisValuePane, "ColumnMatrixAxisValuePane");
        this.add(this.columnMatrixAxisLabelPane, "ColumnMatrixAxisLabelPane");
        this.add(this.categoryAxisLabelPane, "CategoryAxisLabelPane");
        this.add(this.matrixCellPane, "MatrixCellPane");
    }

    @Override
    public void dispose() {
        this.removeAll();
    }

    @Override
    public void removeAll() {
        this.disposeOfCells();
        super.removeAll();
    }

    private void disposeOfCells() {
        if (this.matrixCellPane != null) {
            this.matrixCellPane.dispose();
        }
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixCellPane != null) {
            return this.matrixCellPane;
        }
        return this;
    }

    public MatrixContainer2.ScrollModelProjection getColumnScrollModelProjection() {
        return this.columnScrollModelProjection;
    }

    public MatrixContainer2.ScrollModelProjection getRowScrollModelProjection() {
        return this.rowScrollModelProjection;
    }

    public void addSpecialResponseAxisLabel(String specialLabel) {
        if (this.layoutCache != null) {
            throw new IllegalStateException("");
        }
        this.responseAxisLabelPane = BarLineChartMatrixContainer.addSpecialAxisLabel(this.responseAxisLabelPane, this.responseAxisModel, specialLabel, this.getChannel());
        this.add(this.responseAxisLabelPane, "ResponseAxisLabelPane");
    }

    public void addSpecialResponse2AxisLabel(String specialLabel) {
        if (this.layoutCache != null) {
            throw new IllegalStateException("");
        }
        this.response2AxisLabelPane = BarLineChartMatrixContainer.addSpecialAxisLabel(this.response2AxisLabelPane, this.response2AxisModel, specialLabel, this.getChannel());
        this.add(this.response2AxisLabelPane, "Response2AxisLabelPane");
    }

    private static LabelPane addSpecialAxisLabel(LabelPane axisLabelPane, AxisModel axisModel, String specialLabel, Channel channel) {
        if (specialLabel != null) {
            Variable[] labelVariables = axisLabelPane == null ? null : axisLabelPane.getVariables();
            LabelPane.LabelComponentFactory labelComponentFactory = BarLineChartMatrixContainer.newSpecialLabelingLabelComponentFactory(axisModel, channel);
            labelVariables = BarLineChartMatrixContainer.addSpecialLabeling(labelVariables, specialLabel);
            axisLabelPane = new LabelPane(labelVariables, labelComponentFactory, channel);
        }
        return axisLabelPane;
    }

    private LayoutCache _layoutCache() {
        if (this.layoutCache == null) {
            this.layoutCache = new LayoutCache();
        }
        return this.layoutCache;
    }

    @Override
    public void layout() {
        if (this.isVertical) {
            new VerticalLayout(this, this._layoutCache()).layout();
        } else {
            new HorizontalLayout(this, this._layoutCache()).layout();
        }
    }

    private static int _rotate(ValuePane valuePane, int angle) {
        int preferredHeight = -1;
        ValueTree t = valuePane.getTree();
        DefaultMutableTreeNode[] l = t.getLeafNodes();
        for (int ii = 0; ii < l.length; ++ii) {
            JComponent sc = valuePane.getValueComponent(l[ii]);
            if (!(sc instanceof StringComponent)) continue;
            ((StringComponent)sc).setTextAngle(angle);
            int ph = ((StringComponent)sc).getPreferredSize().height;
            if (preferredHeight >= ph) continue;
            preferredHeight = ph;
        }
        return preferredHeight;
    }

    private static Dimension _getLastLevelPreferredSize(GridDimension d) {
        Dimension cr = d.getGridSize();
        int ncols = cr.width;
        int nrows = cr.height;
        int preferredHeight = d.getRowHeight(nrows - 1);
        int preferredWidth = -1;
        for (int i = 0; i < ncols; ++i) {
            int pw = d.getColWidth(i);
            if (pw <= preferredWidth) continue;
            preferredWidth = pw;
        }
        return new Dimension(preferredWidth, preferredHeight);
    }

    @Override
    public Component[] getMatrixCellComponents() {
        if (this.matrixCellPane == null) {
            return new JComponent[0];
        }
        return this.matrixCellPane.getContentPanelComponents();
    }

    public Component[] getResponseAxisCellComponents() {
        if (this.responseAxisCellPane == null) {
            return new JComponent[0];
        }
        return this.responseAxisCellPane.getContentPanelComponents();
    }

    public Component[] getResponse2AxisCellComponents() {
        if (this.response2AxisCellPane == null) {
            return new JComponent[0];
        }
        return this.response2AxisCellPane.getContentPanelComponents();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._layoutCache().getPreferredSize();
    }

    public ZoomScrollBar getColumnScrollBar() {
        return this.columnScrollBar;
    }

    public ZoomScrollBar getRowScrollBar() {
        return this.rowScrollBar;
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        LabelZoneList columnLabelZoneList = this.columnMatrixAxisLabelPane == null ? null : this.columnMatrixAxisLabelPane.toLabelZoneList(this);
        LabelZoneList rowLabelZoneList = this.rowMatrixAxisLabelPane == null ? null : this.rowMatrixAxisLabelPane.toLabelZoneList(this);
        LabelZoneList categoryLabelZoneList = this.categoryAxisLabelPane == null ? null : this.categoryAxisLabelPane.toLabelZoneList(this);
        LabelZoneList subgroupLabelZoneList = null;
        LabelZoneList responseLabelZoneList = this.responseAxisLabelPane == null ? null : this.responseAxisLabelPane.toLabelZoneList(this);
        LabelZoneList response2LabelZoneList = this.response2AxisLabelPane == null ? null : this.response2AxisLabelPane.toLabelZoneList(this);
        ChartValueZone[] columnValueZones = null;
        ChartValueZone[] rowValueZones = null;
        ChartValueZone[] categoryValueZones = null;
        ChartValueZone[] subgroupValueZones = null;
        ChartValueZone[] dataElementValueZones = null;
        if (this.imageMapInfoState_columnIsIntegrated) {
            columnValueZones = this.columnMatrixAxisValuePane == null ? null : this.columnMatrixAxisValuePane.toChartValueZones_ExcludeCategoryValues(this, 0);
            categoryValueZones = this.columnMatrixAxisValuePane == null ? null : this.columnMatrixAxisValuePane.toChartValueZones_IncludeOnlyCategoryValues(this, 0);
            columnLabelZoneList = this.columnMatrixAxisLabelPane == null ? null : this.columnMatrixAxisLabelPane.toLabelZoneList_ExcludeCategoryLabels(this);
            categoryLabelZoneList = this.columnMatrixAxisLabelPane == null ? null : this.columnMatrixAxisLabelPane.toLabelZoneList_IncludeOnlyCategoryLabels(this);
        } else {
            ChartValueZone[] chartValueZoneArray = columnValueZones = this.columnMatrixAxisValuePane == null ? null : this.columnMatrixAxisValuePane.toChartValueZones(this, 0);
        }
        if (this.imageMapInfoState_rowIsIntegrated) {
            rowValueZones = this.rowMatrixAxisValuePane == null ? null : this.rowMatrixAxisValuePane.toChartValueZones_ExcludeCategoryValues(this, 1);
            categoryValueZones = this.rowMatrixAxisValuePane == null ? null : this.rowMatrixAxisValuePane.toChartValueZones_IncludeOnlyCategoryValues(this, 1);
            rowLabelZoneList = this.rowMatrixAxisLabelPane == null ? null : this.rowMatrixAxisLabelPane.toLabelZoneList_ExcludeCategoryLabels(this);
            categoryLabelZoneList = this.rowMatrixAxisLabelPane == null ? null : this.rowMatrixAxisLabelPane.toLabelZoneList_IncludeOnlyCategoryLabels(this);
        } else {
            rowValueZones = this.rowMatrixAxisValuePane == null ? null : this.rowMatrixAxisValuePane.toChartValueZones(this, 1);
        }
        ChartImageMapInfo2 imageMapInfo = new ChartImageMapInfo2(columnValueZones, rowValueZones, categoryValueZones, subgroupValueZones, dataElementValueZones, columnLabelZoneList, rowLabelZoneList, categoryLabelZoneList, subgroupLabelZoneList, responseLabelZoneList, response2LabelZoneList);
        imageMapInfo.source = this;
        return imageMapInfo;
    }

    private class LayoutCache {
        private final Dimension mps;
        private final Dimension raps;
        private final Dimension ralps;
        private final Dimension r2aps;
        private final Dimension r2alps;
        private final Dimension calps;
        private final GridDimension cmaps;
        private final GridDimension cmalps;
        private final GridDimension rmaps;
        private final GridDimension rmalps;
        private final int responseAxisLabelPlacement;
        private final int response2AxisLabelPlacement;
        private final int categoryAxisLabelPlacement;
        private final int responseAxisLineThickness;
        private final int response2AxisLineThickness;
        private final int columnLeafCount;
        private final int rowLeafCount;
        private final int maxCategoryLeafCount;
        private final int elementClusterCount;
        private final int responseLevelCount;
        private final int response2LevelCount;
        private final int categoryLevelCount;
        private final int integratedLevelCount;
        private final int columnLevelCount;
        private final int rowLevelCount;
        private final HashMap matrixLeafToMaxCategoryLeafCount;
        private final Dimension preferredSize;
        private final int responseAxisLabelPlacementPolicy;
        private final int response2AxisLabelPlacementPolicy;
        private final int categoryAxisLabelPlacementPolicy;
        private final boolean scrollBarsEnabled;
        private final boolean isVertical;

        public LayoutCache() {
            boolean isResponse2AxisPresent;
            boolean isResponseAxisPresent;
            this.isVertical = BarLineChartMatrixContainer.this.isVertical;
            this.scrollBarsEnabled = BarLineChartMatrixContainer.this.columnScrollBar != null;
            this.responseAxisLabelPlacementPolicy = BarLineChartMatrixContainer.this.responseAxisModel.getLabelPlacementPolicy();
            this.response2AxisLabelPlacementPolicy = BarLineChartMatrixContainer.this.response2AxisModel.getLabelPlacementPolicy();
            this.categoryAxisLabelPlacementPolicy = BarLineChartMatrixContainer.this.categoryAxisModel.getLabelPlacementPolicy();
            this.responseAxisLineThickness = (int)BarLineChartMatrixContainer.this.responseAxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px");
            this.response2AxisLineThickness = (int)BarLineChartMatrixContainer.this.response2AxisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px");
            this.integratedLevelCount = BarLineChartMatrixContainer.this.integratedTree != null ? Math.max(1, BarLineChartMatrixContainer.this.integratedTree.getVariableCount()) : 0;
            this.responseLevelCount = BarLineChartMatrixContainer.this.responseAxisLabelPane == null ? 0 : BarLineChartMatrixContainer.this.responseAxisLabelPane.getContentPanelComponents().length;
            this.response2LevelCount = BarLineChartMatrixContainer.this.response2AxisLabelPane == null ? 0 : BarLineChartMatrixContainer.this.response2AxisLabelPane.getContentPanelComponents().length;
            this.categoryLevelCount = BarLineChartMatrixContainer.this.categoryAxisLabelPane == null ? 0 : BarLineChartMatrixContainer.this.categoryAxisLabelPane.getContentPanelComponents().length;
            this.columnLevelCount = BarLineChartMatrixContainer.this.columnTree.getVariableCount();
            this.rowLevelCount = BarLineChartMatrixContainer.this.rowTree.getVariableCount();
            if (this.isVertical) {
                this.responseAxisLabelPlacement = this.responseAxisLabelPlacementPolicy == 10200 ? 11303 : (this.responseAxisLabelPlacementPolicy == 11306 && !BarLineChartMatrixContainer.this.isRowEast && BarLineChartMatrixContainer.this.isRowActive ? 11303 : this.responseAxisLabelPlacementPolicy);
                switch (this.responseAxisLabelPlacement) {
                    case 11303: {
                        break;
                    }
                    case 11306: {
                        Util.rotateStringComponents(BarLineChartMatrixContainer.this.responseAxisLabelPane, 90.0);
                        break;
                    }
                    case 11302: {
                        break;
                    }
                }
            } else {
                this.responseAxisLabelPlacement = this.responseAxisLabelPlacementPolicy == 10200 ? (BarLineChartMatrixContainer.this.isColumnActive ? 11303 : 11306) : (BarLineChartMatrixContainer.this.isColumnActive && this.responseAxisLabelPlacementPolicy == 11306 ? 11303 : this.responseAxisLabelPlacementPolicy);
            }
            if (this.isVertical) {
                this.response2AxisLabelPlacement = this.response2AxisLabelPlacementPolicy == 10200 ? 11303 : (this.response2AxisLabelPlacementPolicy == 11306 && BarLineChartMatrixContainer.this.isRowEast && BarLineChartMatrixContainer.this.isRowActive ? 11303 : this.response2AxisLabelPlacementPolicy);
                switch (this.response2AxisLabelPlacement) {
                    case 11303: {
                        break;
                    }
                    case 11306: {
                        Util.rotateStringComponents(BarLineChartMatrixContainer.this.response2AxisLabelPane, 270.0);
                        break;
                    }
                    case 11302: {
                        break;
                    }
                }
            } else {
                this.response2AxisLabelPlacement = this.response2AxisLabelPlacementPolicy == 10200 ? (BarLineChartMatrixContainer.this.isColumnActive ? 11303 : 11306) : (BarLineChartMatrixContainer.this.isColumnActive && this.response2AxisLabelPlacementPolicy == 11306 ? 11303 : this.response2AxisLabelPlacementPolicy);
            }
            boolean bl = BarLineChartMatrixContainer.this.responseAxisCellPane == null ? false : (isResponseAxisPresent = BarLineChartMatrixContainer.this.responseAxisCellPane.getContentPanelComponents().length > 0);
            boolean bl2 = BarLineChartMatrixContainer.this.response2AxisCellPane == null ? false : (isResponse2AxisPresent = BarLineChartMatrixContainer.this.response2AxisCellPane.getContentPanelComponents().length > 0);
            if (this.isVertical) {
                this.categoryAxisLabelPlacement = this.columnLevelCount > 0 ? -11302 : 11306;
            } else {
                this.categoryAxisLabelPlacement = this.rowLevelCount > 0 ? (isResponse2AxisPresent ? 11302 : 11303) : (isResponse2AxisPresent ? 11306 : (this.categoryAxisLabelPlacementPolicy == 11306 ? 11306 : 11303));
                switch (this.categoryAxisLabelPlacement) {
                    case 11303: {
                        break;
                    }
                    case 11306: {
                        Util.rotateStringComponents(BarLineChartMatrixContainer.this.categoryAxisLabelPane, 90.0);
                        break;
                    }
                    case 11302: {
                        break;
                    }
                }
            }
            this.mps = CellPane.getUniformPreferredSize(BarLineChartMatrixContainer.this.matrixCellPane);
            this.raps = CellPane.getUniformPreferredSize(BarLineChartMatrixContainer.this.responseAxisCellPane);
            this.ralps = LabelPane.getPreferredSize(BarLineChartMatrixContainer.this.responseAxisLabelPane, this.isVertical && this.responseAxisLabelPlacement == 11306 ? 3 : 5);
            this.r2aps = CellPane.getUniformPreferredSize(BarLineChartMatrixContainer.this.response2AxisCellPane);
            this.r2alps = LabelPane.getPreferredSize(BarLineChartMatrixContainer.this.response2AxisLabelPane, this.isVertical && this.response2AxisLabelPlacement == 11306 ? 3 : 5);
            this.calps = LabelPane.getPreferredSize(BarLineChartMatrixContainer.this.categoryAxisLabelPane, 1);
            this.cmaps = ValuePane.getPreferredGridSize(BarLineChartMatrixContainer.this.columnMatrixAxisValuePane, 1);
            this.cmalps = LabelPane.getPreferredGridSize(BarLineChartMatrixContainer.this.columnMatrixAxisLabelPane, 1);
            this.rmaps = ValuePane.getPreferredGridSize(BarLineChartMatrixContainer.this.rowMatrixAxisValuePane, 3);
            this.rmalps = LabelPane.getPreferredGridSize(BarLineChartMatrixContainer.this.rowMatrixAxisLabelPane, 3);
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(BarLineChartMatrixContainer.this.columnTree);
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(BarLineChartMatrixContainer.this.rowTree);
            this.columnLeafCount = colTreeLeaves.length;
            this.rowLeafCount = rowTreeLeaves.length;
            if (this.responseLevelCount + this.response2LevelCount > 1) {
                this.elementClusterCount = this.responseLevelCount + this.response2LevelCount;
            } else {
                int maxBarsPerCategory = 1;
                Component[] cells = BarLineChartMatrixContainer.this.matrixCellPane.getContentPanelComponents();
                if (cells != null) {
                    for (int ii = 0; ii < cells.length; ++ii) {
                        if (!(cells[ii] instanceof BarLineChartCell)) continue;
                        maxBarsPerCategory = Math.max(maxBarsPerCategory, ((BarLineChartCell)cells[ii]).getMaxBarsPerCategory());
                    }
                }
                this.elementClusterCount = maxBarsPerCategory;
            }
            if (this.isVertical) {
                this.matrixLeafToMaxCategoryLeafCount = new HashMap(colTreeLeaves.length);
                int sumOfColumnCategoryCount = 0;
                for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                    int columnCategoryCount = 0;
                    for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                        JComponent component = BarLineChartMatrixContainer.this.matrixCellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                        if (!(component instanceof BarLineChartCell)) continue;
                        columnCategoryCount = Math.max(columnCategoryCount, ((BarLineChartCell)component).getCategoryUniqueValueCount());
                    }
                    this.matrixLeafToMaxCategoryLeafCount.put(colTreeLeaves[ii], new Integer(columnCategoryCount));
                    sumOfColumnCategoryCount += columnCategoryCount;
                }
                this.maxCategoryLeafCount = BarLineChartMatrixContainer.this.integratedTree != null ? BarLineChartMatrixContainer.this.integratedTree.getLeafNodeCount() : sumOfColumnCategoryCount;
                this.preferredSize = this._getVerticalPreferredSize();
            } else {
                this.matrixLeafToMaxCategoryLeafCount = new HashMap(rowTreeLeaves.length);
                int sumOfRowCategoryCount = 0;
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    int rowCategoryCount = 0;
                    for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                        JComponent component = BarLineChartMatrixContainer.this.matrixCellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                        if (!(component instanceof BarLineChartCell)) continue;
                        rowCategoryCount = Math.max(rowCategoryCount, ((BarLineChartCell)component).getCategoryUniqueValueCount());
                    }
                    this.matrixLeafToMaxCategoryLeafCount.put(rowTreeLeaves[jj], new Integer(rowCategoryCount));
                    sumOfRowCategoryCount += rowCategoryCount;
                }
                this.maxCategoryLeafCount = BarLineChartMatrixContainer.this.integratedTree != null ? BarLineChartMatrixContainer.this.integratedTree.getLeafNodeCount() : sumOfRowCategoryCount;
                this.preferredSize = this._getHorizontalPreferredSize();
            }
        }

        private Dimension _newDimension(Dimension d) {
            return new Dimension(d);
        }

        private GridDimension _newGridDimension(GridDimension d) {
            return new GridDimension(d);
        }

        private Dimension _getVerticalPreferredSize() {
            int[] widths = VerticalLayout.computeVertical_Widths(this.mps, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, BarLineChartMatrixContainer.this.isRowEast, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement, this.categoryAxisLabelPlacement, true);
            int w = widths[0] + widths[1] + widths[2];
            w += Util.MIN_FONT_WIDTH * 2;
            int[] heights = VerticalLayout.computeVertical_Heights(this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.mps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement, this.categoryAxisLabelPlacement);
            int h = heights[0] + heights[1] + heights[2];
            Insets insets = BarLineChartMatrixContainer.this.getInsets();
            w += insets.top + insets.bottom;
            h += insets.left + insets.right;
            if (BarLineChartMatrixContainer.this.messagesComponent != null) {
                Dimension wps = BarLineChartMatrixContainer.this.messagesComponent.getPreferredSize();
                w = Math.max(w, wps.width);
                h = Math.max(h, wps.height);
            }
            return new Dimension(w, h);
        }

        private Dimension _getHorizontalPreferredSize() {
            int[] widths = HorizontalLayout.computeHorizontal_Widths(this.mps, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.categoryAxisLabelPlacement, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement);
            int w = widths[0] + widths[1] + widths[2];
            int[] heights = HorizontalLayout.computeHorizontal_Heights(this.mps, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.categoryAxisLabelPlacement, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement);
            int h = heights[0] + heights[1] + heights[2];
            if (BarLineChartMatrixContainer.this.messagesComponent != null) {
                Dimension wps = BarLineChartMatrixContainer.this.messagesComponent.getPreferredSize();
                w = Math.max(w, wps.width);
                h = Math.max(h, wps.height);
            }
            Insets insets = BarLineChartMatrixContainer.this.getInsets();
            return new Dimension(w += insets.top + insets.bottom, h += insets.left + insets.right);
        }

        public Dimension getPreferredSize() {
            return this._newDimension(this.preferredSize);
        }

        public Dimension getMatrixPreferredSize() {
            return this._newDimension(this.mps);
        }

        public Dimension getResponseAxisPreferredSize() {
            return this._newDimension(this.raps);
        }

        public Dimension getResponseAxisLabelPreferredSize() {
            return this._newDimension(this.ralps);
        }

        public Dimension getResponse2AxisPreferredSize() {
            return this._newDimension(this.r2aps);
        }

        public Dimension getResponse2AxisLabelPreferredSize() {
            return this._newDimension(this.r2alps);
        }

        public Dimension getCategoryAxisLabelPreferredSize() {
            return this._newDimension(this.calps);
        }

        public GridDimension getColumnMatrixAxisPreferredSize() {
            return this._newGridDimension(this.cmaps);
        }

        public GridDimension getColumnMatrixAxisLabelPreferredSize() {
            return this._newGridDimension(this.cmalps);
        }

        public GridDimension getRowMatrixAxisPreferredSize() {
            return this._newGridDimension(this.rmaps);
        }

        public GridDimension getRowMatrixAxisLabelPreferredSize() {
            return this._newGridDimension(this.rmalps);
        }

        public HashMap getMatrixLeafToMaxCategoryLeafCount() {
            return this.matrixLeafToMaxCategoryLeafCount;
        }

        public int getMaxCategoryLeafCount() {
            return this.maxCategoryLeafCount;
        }

        public int getElementClusterCount() {
            return this.elementClusterCount;
        }

        public int getColumnLeafCount() {
            return this.columnLeafCount;
        }

        public int getIntegratedLevelCount() {
            return this.integratedLevelCount;
        }

        public int getColumnLevelCount() {
            return this.columnLevelCount;
        }

        public int getRowLeafCount() {
            return this.rowLeafCount;
        }

        public int getRowLevelCount() {
            return this.rowLevelCount;
        }

        public int getResponseAxisLevelCount() {
            return this.responseLevelCount;
        }

        public int getResponse2AxisLevelCount() {
            return this.response2LevelCount;
        }

        public int getCategoryAxisLevelCount() {
            return this.categoryLevelCount;
        }

        public int getResponseAxisLabelPlacement() {
            return this.responseAxisLabelPlacement;
        }

        public int getResponse2AxisLabelPlacement() {
            return this.response2AxisLabelPlacement;
        }

        public int getCategoryAxisLabelPlacement() {
            return this.categoryAxisLabelPlacement;
        }

        public int getResponseAxisLineThickness() {
            return this.responseAxisLineThickness;
        }

        public int getResponse2AxisLineThickness() {
            return this.response2AxisLineThickness;
        }

        public boolean isRowEast() {
            return BarLineChartMatrixContainer.this.isRowEast;
        }

        public CellPane getMatrixCellPane() {
            return BarLineChartMatrixContainer.this.matrixCellPane;
        }

        public CellPane getResponseAxisCellPane() {
            return BarLineChartMatrixContainer.this.responseAxisCellPane;
        }

        public LabelPane getResponseAxisLabelPane() {
            return BarLineChartMatrixContainer.this.responseAxisLabelPane;
        }

        public CellPane getResponse2AxisCellPane() {
            return BarLineChartMatrixContainer.this.response2AxisCellPane;
        }

        public LabelPane getResponse2AxisLabelPane() {
            return BarLineChartMatrixContainer.this.response2AxisLabelPane;
        }

        public ValuePane getColumnMatrixAxisValuePane() {
            return BarLineChartMatrixContainer.this.columnMatrixAxisValuePane;
        }

        public LabelPane getColumnMatrixAxisLabelPane() {
            return BarLineChartMatrixContainer.this.columnMatrixAxisLabelPane;
        }

        public ValuePane getRowMatrixAxisValuePane() {
            return BarLineChartMatrixContainer.this.rowMatrixAxisValuePane;
        }

        public LabelPane getRowMatrixAxisLabelPane() {
            return BarLineChartMatrixContainer.this.rowMatrixAxisLabelPane;
        }

        public LabelPane getCategoryAxisLabelPane() {
            return BarLineChartMatrixContainer.this.categoryAxisLabelPane;
        }

        public JComponent getMessagesComponent() {
            return BarLineChartMatrixContainer.this.messagesComponent;
        }

        public ZoomScrollBar getColumnScrollBar() {
            return BarLineChartMatrixContainer.this.columnScrollBar;
        }

        public ZoomScrollBar getRowScrollBar() {
            return BarLineChartMatrixContainer.this.rowScrollBar;
        }

        public MatrixContainer2.ScrollModelProjection getColumnScrollModelProjection() {
            return BarLineChartMatrixContainer.this.columnScrollModelProjection;
        }

        public MatrixContainer2.ScrollModelProjection getRowScrollModelProjection() {
            return BarLineChartMatrixContainer.this.rowScrollModelProjection;
        }

        public ValueTree getIntegratedTree() {
            return BarLineChartMatrixContainer.this.integratedTree;
        }

        public boolean isColumnRotationEnabled() {
            return BarLineChartMatrixContainer.this.isColumnRotationEnabled;
        }

        public boolean isScrollBarsEnabled() {
            return this.scrollBarsEnabled;
        }
    }

    private static class HorizontalLayout
    extends BarLineChartLayout {
        public HorizontalLayout(MatrixContainer2 container, LayoutCache layoutCache) {
            super(container, layoutCache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layout() {
            int leafGrowthDirection;
            int minCellWidth;
            int minElementHeight;
            Rectangle b = this.getBounds();
            Insets i = this.getInsets();
            if (this.layoutCache.isScrollBarsEnabled()) {
                i.left += 13;
                b.width -= 13;
            }
            Rectangle r = new Rectangle(i.left, i.top, b.width - (i.left + i.right), b.height - (i.top + i.bottom));
            if (b.width <= 0 || b.height <= 0) {
                this.disablePanes("InsufficientDisplaySpace.ex.txt");
                return;
            }
            if (this.maxCategoryLeafCount < 1) {
                this.disablePanes("BlankMessage.txt");
                return;
            }
            double elementHeight = this._computeHorizontal_ElementHeight(r);
            if (elementHeight < (double)(minElementHeight = this.elementClusterCount * Util.MIN_FONT_WIDTH)) {
                if (this.cmalps.height > this.cmaps.height) {
                    this.cmalps.height = this.cmaps.height;
                    elementHeight = this._computeHorizontal_ElementHeight(r);
                }
                if (this.responseAxisLabelPlacement == 11306) {
                    int responseAxisLabelCount;
                    int n = responseAxisLabelCount = this.responseAxisLabelPane != null ? this.responseAxisLabelPane.getContentPanelComponents().length : 0;
                    if (responseAxisLabelCount > 1) {
                        this.responseAxisLabelPlacement = 11303;
                    }
                }
                if (this.response2AxisLabelPlacement == 11306) {
                    int response2AxisLabelCount;
                    int n = response2AxisLabelCount = this.response2AxisLabelPane != null ? this.response2AxisLabelPane.getContentPanelComponents().length : 0;
                    if (response2AxisLabelCount > 1) {
                        this.response2AxisLabelPlacement = 11303;
                    }
                }
                if ((elementHeight = this._computeHorizontal_ElementHeight(r)) < (double)(minElementHeight = this.elementClusterCount) && elementHeight < (double)minElementHeight) {
                    if (this.categoryAxisLabelPlacement == 11303) {
                        this.calps.height = 0;
                        this.calps.width = 0;
                    }
                    this.rmalps.height = 0;
                    this.rmalps.width = 0;
                    this.r2alps.height = 0;
                    this.r2alps.width = 0;
                    this.r2aps.height = 0;
                    this.r2aps.width = 0;
                    this.ralps.height = 0;
                    this.ralps.width = 0;
                    this.raps.height = 0;
                    this.raps.width = 0;
                    elementHeight = this._computeHorizontal_ElementHeight(r);
                    if (elementHeight < (double)minElementHeight) {
                        this.cmalps.height = 0;
                        this.cmalps.width = 0;
                        this.cmaps.height = 0;
                        this.cmaps.width = 0;
                        elementHeight = this._computeHorizontal_ElementHeight(r);
                        if (elementHeight < 1.0) {
                            this.disablePanes("InsufficientDisplaySpace.ex.txt");
                            return;
                        }
                    }
                }
            }
            int matrixHeight = (int)elementHeight * this.maxCategoryLeafCount;
            if (this.categoryAxisLabelPlacement == 11306 && this.calps.height > matrixHeight) {
                this.calps.height = matrixHeight;
            }
            this.cmaps.height = this.cmalps.height = Math.max(this.cmaps.height, this.cmalps.height) / this.columnCount * this.columnCount;
            int cellWidth = this._computeHorizontal_CellWidth(r.width);
            if (cellWidth < (minCellWidth = MIN_RESPONSE_AXIS_LENGTH)) {
                if (this.cmalps.width > this.rmaps.width) {
                    this.cmalps.width = this.rmaps.width;
                }
                if (this.rmalps.width > this.rmaps.width) {
                    this.rmalps.width = this.rmaps.width;
                }
                if ((cellWidth = this._computeHorizontal_CellWidth(r.width)) < minCellWidth) {
                    boolean isResponseAxisLabelCullingEnabled = this.responseAxisLabelPlacement != 11306;
                    boolean isResponse2AxisLabelCullingEnabled = this.response2AxisLabelPlacement != 11306;
                    GridDimension altrmalps = new GridDimension(this.rmalps);
                    Dimension altralps = new Dimension(this.ralps);
                    Dimension altr2alps = new Dimension(this.r2alps);
                    if (isResponseAxisLabelCullingEnabled) {
                        this.ralps.height = 0;
                        this.ralps.width = 0;
                    }
                    if (isResponse2AxisLabelCullingEnabled) {
                        this.r2alps.height = 0;
                        this.r2alps.width = 0;
                    }
                    if ((cellWidth = this._computeHorizontal_CellWidth(r.width)) < minCellWidth) {
                        this.cmalps.height = 0;
                        this.cmalps.width = 0;
                        this.rmaps.height = 0;
                        this.rmaps.width = 0;
                        this.rmalps.height = 0;
                        this.rmalps.width = 0;
                        if (this.columnLevelCount > 0) {
                            if (this.responseAxisLabelPlacement == 11306) {
                                this.ralps.height = 0;
                                this.ralps.width = 0;
                            }
                            if (this.response2AxisLabelPlacement == 11306) {
                                this.r2alps.height = 0;
                                this.r2alps.width = 0;
                            }
                        } else {
                            this.ralps.width = altralps.width;
                            this.ralps.height = altralps.height;
                            this.r2alps.width = altr2alps.width;
                            this.r2alps.height = altr2alps.height;
                        }
                        this.rmalps.apply(altrmalps);
                        cellWidth = this._computeHorizontal_CellWidth(r.width);
                        if (cellWidth < minCellWidth) {
                            if (isResponseAxisLabelCullingEnabled) {
                                this.ralps.height = 0;
                                this.ralps.width = 0;
                            }
                            if (isResponse2AxisLabelCullingEnabled) {
                                this.r2alps.height = 0;
                                this.r2alps.width = 0;
                            }
                            cellWidth = this._computeHorizontal_CellWidth(r.width);
                        }
                    }
                }
            }
            if (cellWidth < minCellWidth) {
                this.disablePanes("InsufficientDisplaySpace.ex.txt");
                return;
            }
            int matrixWidth = cellWidth * this.columnLeafCount;
            if (this.categoryAxisLabelPlacement == 11303 && this.calps.width > matrixWidth) {
                this.calps.width = matrixWidth;
            }
            GridDimension.mergeWidths(this.rmalps, this.rmaps);
            if (this.cmaps.getColWidth(0) != cellWidth) {
                this.cmaps.setColWidth(0, cellWidth);
            }
            int raTweak = Math.min(1, this.responseAxisLineThickness);
            int r2aTweak = Math.min(3, this.response2AxisLineThickness + 1);
            Insets margin = new Insets(0, 0, 0, 0);
            int[] widths = this._computeHorizontal_Widths();
            int westWidth = widths[0];
            int matrixWidth2 = cellWidth * this.columnLeafCount;
            int eastWidth = widths[2];
            int excessPixels = r.width - (westWidth + matrixWidth2 + eastWidth);
            margin.left = excessPixels / 2;
            margin.right = excessPixels - margin.left;
            int startX = r.x + margin.left;
            int matrixStartX = startX + westWidth;
            int calpsWidth = this.categoryAxisLabelPlacement == 11306 ? this.calps.width : 0;
            this.rmalb.width = this.rmalps.width;
            this.rmalb.x = matrixStartX - this.rmalb.width - calpsWidth;
            this.rmab.width = this.rmaps.width;
            this.rmab.x = matrixStartX - this.rmab.width - calpsWidth;
            this.cmalb.width = this.cmalps.width;
            this.cmalb.x = matrixStartX - this.cmalb.width;
            this.calb.width = this.calps.width;
            this.calb.x = matrixStartX - calpsWidth;
            this.r2ab.width = matrixWidth2;
            this.r2ab.x = matrixStartX;
            this.mb.width = matrixWidth2;
            this.mb.x = matrixStartX;
            this.rab.width = matrixWidth2;
            this.rab.x = matrixStartX;
            this.cmab.width = matrixWidth2;
            this.cmab.x = matrixStartX;
            this.ralb.width = this.ralps.width;
            this.ralb.x = this.responseAxisLabelPlacement == 11306 ? this.mb.x + (this.mb.width - this.ralb.width) / 2 : this.mb.x + this.mb.width;
            this.r2alb.width = this.r2alps.width;
            this.r2alb.x = this.response2AxisLabelPlacement == 11306 ? this.mb.x + (this.mb.width - this.r2alb.width) / 2 : this.mb.x + this.mb.width;
            int[] heights = this._computeHorizontal_Heights();
            int northHeight = heights[0];
            int matrixHeight2 = (int)elementHeight * this.maxCategoryLeafCount;
            int southHeight = heights[2];
            excessPixels = r.height - (northHeight + matrixHeight2 + southHeight);
            margin.top = excessPixels / 2;
            margin.bottom = excessPixels - margin.top;
            int startY = r.y + margin.top;
            int topOfMatrixY = startY + northHeight;
            this.r2ab.height = this.r2aps.height + r2aTweak;
            this.r2ab.y = topOfMatrixY - this.r2ab.height + r2aTweak;
            this.rmalb.height = this.rmalps.height;
            this.rmalb.y = topOfMatrixY - this.rmalb.height;
            this.calb.height = this.calps.height;
            this.calb.y = this.categoryAxisLabelPlacement == 11306 ? topOfMatrixY + (matrixHeight2 - this.calb.height) / 2 : topOfMatrixY - this.calb.height;
            this.rmab.height = matrixHeight2;
            this.rmab.y = topOfMatrixY;
            this.mb.height = matrixHeight2;
            this.mb.y = topOfMatrixY;
            this.rab.height = this.raps.height;
            this.rab.y = this.mb.y + this.mb.height - raTweak;
            this.cmab.height = this.cmaps.height;
            this.cmab.y = this.rab.y + this.rab.height;
            this.cmalb.height = this.cmalps.height;
            this.cmalb.y = this.rab.y + this.rab.height;
            this.ralb.height = this.ralps.height;
            switch (this.responseAxisLabelPlacement) {
                default: {
                    this.ralb.y = this.mb.y + this.mb.height - this.ralb.height + this.rab.height;
                    break;
                }
                case 11301: {
                    this.ralb.y = this.mb.y + this.mb.height - this.ralb.height;
                    break;
                }
                case 11302: {
                    this.ralb.y = this.mb.y + this.mb.height;
                    break;
                }
                case 11306: {
                    this.ralb.y = this.rab.y + this.rab.height;
                }
            }
            this.r2alb.height = this.r2alps.height;
            switch (this.response2AxisLabelPlacement) {
                default: {
                    this.r2alb.y = this.mb.y - this.r2ab.height;
                    break;
                }
                case 11301: {
                    this.r2alb.y = this.mb.y;
                    break;
                }
                case 11302: {
                    this.r2alb.y = this.mb.y - this.r2alb.height;
                    break;
                }
                case 11306: {
                    this.r2alb.y = this.r2ab.y - this.r2alb.height;
                }
            }
            MatrixContainer2.applyPaneBounds(this.matrixCellPane, this.mb);
            MatrixContainer2.applyPaneBounds(this.columnMatrixAxisValuePane, this.cmab);
            MatrixContainer2.applyPaneBounds(this.columnMatrixAxisLabelPane, this.cmalb);
            MatrixContainer2.applyPaneBounds(this.rowMatrixAxisValuePane, this.rmab);
            MatrixContainer2.applyPaneBounds(this.rowMatrixAxisLabelPane, this.rmalb);
            MatrixContainer2.applyPaneBounds(this.responseAxisCellPane, this.rab);
            MatrixContainer2.applyPaneBounds(this.responseAxisLabelPane, this.ralb);
            MatrixContainer2.applyPaneBounds(this.response2AxisCellPane, this.r2ab);
            MatrixContainer2.applyPaneBounds(this.response2AxisLabelPane, this.r2alb);
            MatrixContainer2.applyPaneBounds(this.categoryAxisLabelPane, this.calb);
            if (this.messagesComponent != null) {
                int x1 = this.mb.x;
                int x2 = this.mb.x + this.mb.width;
                int y1 = this.r2ab.y;
                int y2 = this.rab.y + this.rab.height;
                Rectangle display = new Rectangle(x1, y1, x2 - x1, y2 - y1);
                Dimension wps = this.messagesComponent.getPreferredSize();
                Rectangle wmb = new Rectangle();
                wmb.width = Math.min(wps.width, display.width);
                wmb.height = Math.min(wps.height, display.height);
                wmb.x = display.x + (display.width - wmb.width) / 2;
                wmb.y = display.y + (display.height - wmb.height) / 2;
                MatrixContainer2.applyBounds(this.messagesComponent, wmb);
            }
            if (this.columnScrollBar != null) {
                Rectangle csbb = null;
                csbb = new Rectangle(this.mb.x, this.mb.y + this.mb.height, this.mb.width, 13);
                this.columnScrollBar.setBounds(csbb.x, csbb.y, csbb.width, csbb.height);
            }
            if (this.rowScrollBar != null) {
                Rectangle rsbb = new Rectangle(this.rmab.x - 13, this.rmab.y, 13, this.rmab.height);
                this.rowScrollBar.setBounds(rsbb.x, rsbb.y, rsbb.width, rsbb.height);
            }
            this.columnScrollModelProjection.setViewportSize(this.mb.width);
            this.rowScrollModelProjection.setViewportSize(this.mb.height);
            elementHeight = this.rowScrollModelProjection.calculateViewSize() / this.maxCategoryLeafCount;
            this._conveyCategoryAxisStrideLength(elementHeight);
            cellWidth = this.columnScrollModelProjection.calculateViewSize() / this.columnLeafCount;
            int scrollX = this.columnScrollModelProjection.calculateViewScroll();
            int scrollY = this.rowScrollModelProjection.calculateViewScroll();
            int matrixScrollX = scrollX;
            int matrixScrollY = scrollY;
            boolean rowScrollX = false;
            int rowScrollY = matrixScrollY;
            int colScrollX = matrixScrollX;
            boolean colScrollY = false;
            if (this.categoryAxisLevelCount > 0) {
                leafGrowthDirection = 1;
                LabelPane.doLayout(this.categoryAxisLabelPane, leafGrowthDirection, this.calb.width, this.calb.height / this.categoryAxisLevelCount);
            }
            this.rab.width = cellWidth;
            CellPane.doLayout(this.responseAxisCellPane, this.rac, colScrollX, 0);
            if (this.responseAxisLevelCount > 0) {
                LabelPane.doLayout(this.responseAxisLabelPane, 1, this.ralb.width, this.ralb.height / this.responseAxisLevelCount);
            }
            this.r2ab.width = cellWidth;
            CellPane.doLayout(this.response2AxisCellPane, this.r2ac, colScrollX, 0);
            if (this.response2AxisLevelCount > 0) {
                LabelPane.doLayout(this.response2AxisLabelPane, 1, this.r2alb.width, this.r2alb.height / this.response2AxisLevelCount);
            }
            leafGrowthDirection = 1;
            GridDimension.mergeHeights(this.cmaps, this.cmalps);
            ValuePane.doLayout(this.columnMatrixAxisValuePane, leafGrowthDirection, this.cmaps, colScrollX, 0);
            LabelPane.doLayout(this.columnMatrixAxisLabelPane, leafGrowthDirection, this.cmalps);
            HashMap rowToCategoryCount = this.layoutCache.getMatrixLeafToMaxCategoryLeafCount();
            if (this.integratedTree == null && this.rowMatrixAxisValuePane != null && this.rowMatrixAxisValuePane.getTree() != null) {
                DataTreeGroupNode root = (DataTreeGroupNode)this.rowMatrixAxisValuePane.getTree().getRoot();
                DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
                int nrows = rowToCategoryCount.size();
                this.rmaps.setGridSize(this.rmaps.getGridSize().width, false, nrows, false);
                for (int rx = 0; rx < nrows; ++rx) {
                    int h = (int)elementHeight * (Integer)rowToCategoryCount.get(leaves[rx]);
                    this.rmaps.setRowHeight(rx, h);
                }
            } else {
                this.rmaps.setRowHeight(0, (int)elementHeight);
            }
            HashMap<Object, Integer> rowToRowHeight = new HashMap<Object, Integer>(rowToCategoryCount.size());
            Object[] keys = rowToCategoryCount.keySet().toArray();
            for (int ii = 0; ii < keys.length; ++ii) {
                Integer rowCategoryCount = (Integer)rowToCategoryCount.get(keys[ii]);
                Integer rowHeight = new Integer((int)elementHeight * rowCategoryCount);
                rowToRowHeight.put(keys[ii], rowHeight);
            }
            int leafGrowthDirection2 = 3;
            GridDimension.mergeWidths(this.rmaps, this.rmalps);
            ValuePane.doLayout(this.rowMatrixAxisValuePane, leafGrowthDirection2, this.rmaps, 0, rowScrollY);
            LabelPane.doLayout(this.rowMatrixAxisLabelPane, leafGrowthDirection2, this.rmalps);
            if (this.matrixCellPane != null && this.matrixCellPane.getContentPanelComponentCount() > 0) {
                HorizontalLayout horizontalLayout = this;
                synchronized (horizontalLayout) {
                    double newCategoryAxisAdjustment;
                    Dimension response2AxisInnerMargin;
                    Dimension responseAxisInnerMargin;
                    Component[] components;
                    Component[] components2;
                    BarLineChartCell barLineChartCell = (BarLineChartCell)this.matrixCellPane.getContentPanelComponents()[0];
                    BarLineChartCellModel barLineChartCellModel = barLineChartCell.getBarLineChartCellModel();
                    Insets outerMargin = barLineChartCellModel.getOuterMargin();
                    boolean orientationIsVertical = this.layoutCache.isVertical;
                    ArrayList<Component> axisCells = null;
                    if (this.responseAxisCellPane != null && (components2 = this.responseAxisCellPane.getContentPanelComponents()) != null && components2.length > 0) {
                        axisCells = new ArrayList<Component>(components2.length);
                        for (int ii = 0; ii < components2.length; ++ii) {
                            axisCells.add(components2[ii]);
                        }
                    }
                    ArrayList<Component> axis2Cells = null;
                    if (this.response2AxisCellPane != null && (components = this.response2AxisCellPane.getContentPanelComponents()) != null && components.length > 0) {
                        axis2Cells = new ArrayList<Component>(components.length);
                        for (int ii = 0; ii < components.length; ++ii) {
                            axis2Cells.add(components[ii]);
                        }
                    }
                    double oldCategoryAxisAdjustment = orientationIsVertical ? (double)outerMargin.bottom : (double)outerMargin.left;
                    outerMargin.left = 0;
                    outerMargin.top = 0;
                    outerMargin.right = 0;
                    outerMargin.bottom = 0;
                    if (axisCells != null && (responseAxisInnerMargin = ((AxisCell)axisCells.get(0)).getAxisModel().getMargin()) != null) {
                        responseAxisInnerMargin.width = 0;
                        responseAxisInnerMargin.height = 0;
                    }
                    if (axis2Cells != null && (response2AxisInnerMargin = ((AxisCell)axis2Cells.get(0)).getAxisModel().getMargin()) != null) {
                        response2AxisInnerMargin.width = 0;
                        response2AxisInnerMargin.height = 0;
                    }
                    barLineChartCellModel.setCommonBarWidth(null);
                    AlignableComponentConstraints constraints = new AlignableComponentConstraints();
                    constraints.getBounds().width = cellWidth;
                    if (this.columnLeafCount > 1 || this.rowLeafCount > 1) {
                        this._resetValueFont(rowToRowHeight, false);
                        CellPane.doLayoutByRow(this.matrixCellPane, constraints, rowToRowHeight, matrixScrollX, matrixScrollY);
                        Font smallestFontUsed = this._findSmallestValueFontUsed(rowToRowHeight, false);
                        if (smallestFontUsed != null) {
                            this._forceValueFont(rowToRowHeight, smallestFontUsed, false);
                            CellPane.doLayoutByRow(this.matrixCellPane, constraints, rowToRowHeight, matrixScrollX, matrixScrollY);
                        } else {
                            CellPane.doLayoutByRow(this.matrixCellPane, constraints, rowToRowHeight, matrixScrollX, matrixScrollY);
                        }
                    } else {
                        CellPane.doLayoutByRow(this.matrixCellPane, constraints, rowToRowHeight, matrixScrollX, matrixScrollY);
                    }
                    double d = newCategoryAxisAdjustment = orientationIsVertical ? (double)outerMargin.bottom : (double)outerMargin.left;
                    if (newCategoryAxisAdjustment != oldCategoryAxisAdjustment) {
                        int axis2CellCount;
                        int ii;
                        Rectangle axisBounds;
                        int axisCellCount;
                        Double categoryAxisAdjustment = new Double(newCategoryAxisAdjustment);
                        int n = axisCellCount = axisCells != null ? axisCells.size() : 0;
                        if (axisCellCount > 0) {
                            axisBounds = ((AxisCell)axisCells.get(0)).getBounds();
                            if (axisBounds.width + axisBounds.height > 0) {
                                for (ii = 0; ii < axisCellCount; ++ii) {
                                    AxisCell axisCell = (AxisCell)axisCells.get(ii);
                                    AxisCellModel axisCellModel = axisCell.getAxisModel();
                                    if (orientationIsVertical) {
                                        axisCellModel.setCatAxisAdj(categoryAxisAdjustment);
                                        axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getHeight());
                                        continue;
                                    }
                                    axisCellModel.setResAxisAdj(categoryAxisAdjustment);
                                    axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getWidth());
                                }
                            }
                        }
                        int n2 = axis2CellCount = axis2Cells != null ? axis2Cells.size() : 0;
                        if (axis2CellCount > 0) {
                            axisBounds = ((AxisCell)axis2Cells.get(0)).getBounds();
                            if (axisBounds.width + axisBounds.height > 0) {
                                for (ii = 0; ii < axis2CellCount; ++ii) {
                                    AxisCell axis2Cell = (AxisCell)axis2Cells.get(ii);
                                    AxisCellModel axis2CellModel = axis2Cell.getAxisModel();
                                    if (orientationIsVertical) {
                                        axis2CellModel.setCatAxisAdj(categoryAxisAdjustment);
                                        axis2CellModel.computeParameters(axis2Cell.getChannel(), axis2Cell.getHeight());
                                        continue;
                                    }
                                    axis2CellModel.setResAxisAdj(categoryAxisAdjustment);
                                    axis2CellModel.computeParameters(axis2Cell.getChannel(), axis2Cell.getWidth());
                                }
                            }
                        }
                    }
                }
            }
        }

        public static int[] computeHorizontal_Heights(Dimension mps, Dimension raps, Dimension ralps, Dimension r2aps, Dimension r2alps, Dimension calps, GridDimension cmaps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int categoryAxisLabelPlacement, int responseAxisLabelPlacement, int response2AxisLabelPlacement) {
            int northHeight = 0;
            switch (response2AxisLabelPlacement) {
                default: {
                    northHeight = Math.max(r2aps.height, rmalps.height);
                    break;
                }
                case 11306: {
                    northHeight = r2alps.height + Math.max(r2aps.height, rmalps.height);
                    break;
                }
                case 11302: {
                    northHeight = Math.max(Math.max(r2aps.height, r2alps.height), rmalps.height);
                }
            }
            if (categoryAxisLabelPlacement == 11303 && northHeight < calps.height) {
                northHeight = calps.height;
            }
            int southHeight = 0;
            switch (responseAxisLabelPlacement) {
                default: {
                    southHeight = raps.height + Math.max(cmaps.height, cmalps.height);
                    break;
                }
                case 11306: {
                    southHeight = raps.height + ralps.height + Math.max(cmaps.height, cmalps.height);
                    break;
                }
                case 11302: {
                    southHeight = Math.max(raps.height, ralps.height) + Math.max(cmaps.height, cmalps.height);
                }
            }
            int matrixHeight = 0;
            if (mps != null) {
                matrixHeight = Math.max(rmaps.height, mps.height);
                int ralpsHeight = responseAxisLabelPlacement == 11306 ? 0 : ralps.height;
                int r2alpsHeight = response2AxisLabelPlacement == 11306 ? 0 : r2alps.height;
                int spacer = ralpsHeight > 0 && r2alpsHeight > 0 ? Util.MIN_FONT_WIDTH * 2 : 0;
                int responseAxesHeight = ralpsHeight + ralpsHeight + spacer;
                if (matrixHeight < responseAxesHeight) {
                    matrixHeight = responseAxesHeight;
                }
                if (categoryAxisLabelPlacement == 11306 && matrixHeight < calps.height) {
                    matrixHeight = calps.height;
                }
            }
            return new int[]{northHeight, matrixHeight, southHeight};
        }

        private int[] _computeHorizontal_Heights() {
            return HorizontalLayout.computeHorizontal_Heights(this.mps, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.categoryAxisLabelPlacement, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement);
        }

        private double _computeHorizontal_ElementHeight(Rectangle r) {
            int[] heights = HorizontalLayout.computeHorizontal_Heights(null, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.categoryAxisLabelPlacement, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement);
            return (r.height - (heights[0] + heights[2])) / this.maxCategoryLeafCount;
        }

        public static int[] computeHorizontal_Widths(Dimension mps, Dimension raps, Dimension ralps, Dimension r2aps, Dimension r2alps, Dimension calps, GridDimension cmaps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int categoryAxisLabelPlacement, int responseAxisLabelPlacement, int response2AxisLabelPlacement) {
            int calpsWidth = categoryAxisLabelPlacement == 11306 ? calps.width : 0;
            int rmaps_prefWidth = 0;
            int i1 = rmaps.getGridSize().width;
            for (int i = 0; i < i1; ++i) {
                rmaps_prefWidth += Math.max(rmaps.getColWidth(i), rmalps.getColWidth(i));
            }
            int westWidth = Math.max(rmaps_prefWidth + calpsWidth, cmalps.width);
            int ralpsWidth = responseAxisLabelPlacement == 11306 ? 0 : ralps.width;
            int r2alpsWidth = response2AxisLabelPlacement == 11306 ? 0 : r2alps.width;
            int eastWidth = Math.max(ralpsWidth, r2alpsWidth);
            int matrixWidth = 0;
            if (mps != null) {
                matrixWidth = Math.max(Math.max(mps.width, cmaps.width), Math.max(raps.width, r2aps.width));
                if (categoryAxisLabelPlacement == 11303 && matrixWidth < calps.width) {
                    matrixWidth = calps.width;
                }
                if (responseAxisLabelPlacement == 11306 && matrixWidth < ralps.width) {
                    matrixWidth = ralps.width;
                }
                if (response2AxisLabelPlacement == 11306 && matrixWidth < r2alps.width) {
                    matrixWidth = r2alps.width;
                }
            }
            return new int[]{westWidth, matrixWidth, eastWidth};
        }

        private int[] _computeHorizontal_Widths() {
            return HorizontalLayout.computeHorizontal_Widths(null, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.categoryAxisLabelPlacement, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement);
        }

        private int _computeHorizontal_CellWidth(int displayWidth) {
            int[] widths = this._computeHorizontal_Widths();
            return (displayWidth - (widths[0] + widths[2])) / this.columnLeafCount;
        }
    }

    private static class VerticalLayout
    extends BarLineChartLayout {
        public VerticalLayout(MatrixContainer2 container, LayoutCache layoutCache) {
            super(container, layoutCache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layout() {
            int leafGrowthDirection;
            int maxCenteringWidth;
            int width;
            int eastWidth;
            int minElementWidth;
            Rectangle b = this.getBounds();
            if (this.layoutCache.isScrollBarsEnabled()) {
                b.height -= 17;
            }
            Insets i = this.getInsets();
            Rectangle r = new Rectangle(i.left, i.top, b.width - (i.left + i.right), b.height - (i.top + i.bottom));
            if (b.width <= 0 || b.height <= 0) {
                this.disablePanes("InsufficientDisplaySpace.ex.txt");
                return;
            }
            if (this.maxCategoryLeafCount < 1) {
                this.disablePanes("BlankMessage.txt");
                return;
            }
            Dimension columnMatrixAxisLastLevelps = null;
            if (this.isColumnRotationEnabled && this.columnMatrixAxisValuePane != null) {
                BarLineChartMatrixContainer._rotate(this.columnMatrixAxisValuePane, 0);
                columnMatrixAxisLastLevelps = BarLineChartMatrixContainer._getLastLevelPreferredSize(this.cmaps);
            }
            int cmaLevelCount = this.columnMatrixAxisLabelPane == null ? 0 : this.columnMatrixAxisLabelPane.getVariables().length;
            double elementWidth = this._computeVertical_CategoryWidth(r);
            if (elementWidth < (double)(minElementWidth = this.elementClusterCount * Util.MIN_FONT_WIDTH)) {
                if (this.rmaps.width > 0 && this.restrictCategoryAndColumnLabelWidths()) {
                    elementWidth = this._computeVertical_CategoryWidth(r);
                }
                if (elementWidth < (double)minElementWidth) {
                    if (this.ralps.width > this.raps.width && this.responseAxisLabelPlacement == 11302) {
                        this.responseAxisLabelPlacement = 11303;
                    }
                    if (this.r2alps.width > this.r2aps.width && this.response2AxisLabelPlacement == 11302) {
                        this.response2AxisLabelPlacement = 11303;
                    }
                    if (this.rmaps.width > 0) {
                        this.restrictCategoryAndColumnLabelWidths();
                    }
                    if ((elementWidth = this._computeVertical_CategoryWidth(r)) < (double)minElementWidth && this.restrictCategoryAndColumnLabelWidths()) {
                        elementWidth = this._computeVertical_CategoryWidth(r);
                    }
                    if (elementWidth < (double)minElementWidth && this.rmalps.width > this.rmaps.width) {
                        this.rmalps.width = this.rmaps.width;
                        if (this.restrictCategoryAndColumnLabelWidths()) {
                            elementWidth = this._computeVertical_CategoryWidth(r);
                        }
                    }
                    if (elementWidth < (double)(minElementWidth = this.elementClusterCount)) {
                        Dimension alt_raps = new Dimension(this.raps.width, this.raps.height);
                        Dimension alt_ralps = new Dimension(this.ralps.width, this.ralps.height);
                        Dimension alt_r2aps = new Dimension(this.r2aps.width, this.r2aps.height);
                        Dimension alt_r2alps = new Dimension(this.r2alps.width, this.r2alps.height);
                        this.ralps.height = 0;
                        this.ralps.width = 0;
                        this.raps.height = 0;
                        this.raps.width = 0;
                        this.r2alps.height = 0;
                        this.r2alps.width = 0;
                        this.r2aps.height = 0;
                        this.r2aps.width = 0;
                        this.restrictCategoryAndColumnLabelWidths();
                        elementWidth = this._computeVertical_CategoryWidth(r);
                        if (elementWidth < (double)minElementWidth) {
                            this.rmalps.height = 0;
                            this.rmalps.width = 0;
                            this.rmaps.height = 0;
                            this.rmaps.width = 0;
                            this.raps.width = alt_raps.width;
                            this.raps.height = alt_raps.height;
                            this.ralps.width = alt_ralps.width;
                            this.ralps.height = alt_ralps.height;
                            this.r2aps.width = alt_r2aps.width;
                            this.r2aps.height = alt_r2aps.height;
                            this.r2alps.width = alt_r2alps.width;
                            this.r2alps.height = alt_r2alps.height;
                            this.restrictCategoryAndColumnLabelWidths();
                            elementWidth = this._computeVertical_CategoryWidth(r);
                            if (elementWidth < (double)minElementWidth) {
                                this.ralps.height = 0;
                                this.ralps.width = 0;
                                this.raps.height = 0;
                                this.raps.width = 0;
                                this.r2alps.height = 0;
                                this.r2alps.width = 0;
                                this.r2aps.height = 0;
                                this.r2aps.width = 0;
                                this.calps.height = 0;
                                this.calps.width = 0;
                                this.cmalps.height = 0;
                                this.cmalps.width = 0;
                                elementWidth = this._computeVertical_CategoryWidth(r);
                            }
                            if (elementWidth < 1.0) {
                                this.disablePanes("InsufficientDisplaySpace.ex.txt");
                                return;
                            }
                        }
                    }
                }
            }
            GridDimension.mergeWidths(this.rmaps, this.rmalps);
            int cmapsLastLevelHeight = -1;
            int cmapsLevelHeight = cmaLevelCount > 0 ? this.cmaps.height / cmaLevelCount : 0;
            int cmalpsLevelHeight = cmaLevelCount > 0 ? this.cmalps.height / cmaLevelCount : 0;
            int cmaLevelHeight = Math.max(cmapsLevelHeight, cmalpsLevelHeight);
            if (this.isColumnRotationEnabled && columnMatrixAxisLastLevelps != null && (double)columnMatrixAxisLastLevelps.width > elementWidth && columnMatrixAxisLastLevelps.width > cmaLevelHeight) {
                cmapsLastLevelHeight = BarLineChartMatrixContainer._rotate(this.columnMatrixAxisValuePane, 90);
                this.cmaps.setRowHeight(this.cmaps.getGridSize().height - 1, cmapsLastLevelHeight);
            }
            GridDimension.mergeHeights(this.cmaps, this.cmalps);
            this._applyAutomaticJustification();
            int cellHeight = this._computeVertical_CellHeight(r.height);
            int minCellHeight = MIN_RESPONSE_AXIS_LENGTH;
            if (this.categoryAxisLabelPane != null && this.categoryAxisLabelPlacement == -11302) {
                minCellHeight += this.calps.height;
            }
            if (cellHeight < minCellHeight) {
                if (cmalpsLevelHeight > cmapsLevelHeight) {
                    cmaLevelHeight = Math.min(cmapsLevelHeight, cmalpsLevelHeight);
                    this.cmalps.height = cmaLevelHeight * cmaLevelCount;
                    this.cmaps.height = cmapsLastLevelHeight == -1 ? this.cmalps.height : cmaLevelHeight * (cmaLevelCount - 1) + cmapsLastLevelHeight;
                    cellHeight = this._computeVertical_CellHeight(r.height);
                }
                if (cellHeight < minCellHeight) {
                    boolean isResponseAxisLabelCullingEnabled = this.responseAxisLabelPlacement != 11306;
                    boolean isResponse2AxisLabelCullingEnabled = this.response2AxisLabelPlacement != 11306;
                    GridDimension altrmalps = new GridDimension(this.rmalps);
                    Dimension altralps = new Dimension(this.ralps);
                    Dimension altr2alps = new Dimension(this.r2alps);
                    this.rmalps.height = 0;
                    this.rmalps.width = 0;
                    if (isResponseAxisLabelCullingEnabled) {
                        this.ralps.height = 0;
                        this.ralps.width = 0;
                    }
                    if (isResponse2AxisLabelCullingEnabled) {
                        this.r2alps.height = 0;
                        this.r2alps.width = 0;
                    }
                    if ((cellHeight = this._computeVertical_CellHeight(r.height)) < minCellHeight) {
                        this.cmaps.height = 0;
                        this.cmaps.width = 0;
                        this.cmalps.height = 0;
                        this.cmalps.width = 0;
                        cmaLevelHeight = 0;
                        this.ralps.width = altralps.width;
                        this.ralps.height = altralps.height;
                        this.r2alps.width = altr2alps.width;
                        this.r2alps.height = altr2alps.height;
                        this.rmalps.apply(altrmalps);
                        cellHeight = this._computeVertical_CellHeight(r.height);
                        if (cellHeight < minCellHeight) {
                            this.rmalps.height = 0;
                            this.rmalps.width = 0;
                            if (isResponseAxisLabelCullingEnabled) {
                                this.ralps.height = 0;
                                this.ralps.width = 0;
                            }
                            if (isResponse2AxisLabelCullingEnabled) {
                                this.r2alps.height = 0;
                                this.r2alps.width = 0;
                            }
                            cellHeight = this._computeVertical_CellHeight(r.height);
                        }
                        if (cellHeight < minCellHeight) {
                            this.disablePanes("InsufficientDisplaySpace.ex.txt");
                            return;
                        }
                    }
                }
            }
            int raTweak = Math.min(1, this.responseAxisLineThickness);
            int r2aTweak = Math.min(3, this.response2AxisLineThickness + 1);
            Insets margin = new Insets(0, 0, 0, 0);
            int matrixWidth = (int)elementWidth * this.maxCategoryLeafCount;
            int responseAxisAreaWidth = VerticalLayout._computeVertical_ResponseWidth(this.raps, this.ralps, this.responseAxisLabelPlacement);
            int[] widths = this._computeVertical_Widths();
            int westWidth = widths[0];
            int totalPaneWidth = westWidth + matrixWidth + (eastWidth = widths[2]);
            if (totalPaneWidth > r.width) {
                matrixWidth = Math.max(0, (r.width - (westWidth + eastWidth)) / this.maxCategoryLeafCount * this.maxCategoryLeafCount);
                totalPaneWidth = westWidth + matrixWidth + eastWidth;
            }
            int maxSpacer = Util.MIN_FONT_WIDTH / 2;
            int excessPixels = r.width - totalPaneWidth;
            int rmaGap = Math.min(maxSpacer, excessPixels);
            margin.left = (excessPixels -= rmaGap) / 2;
            margin.right = excessPixels - margin.left;
            int salGap = 0;
            int salpsWidth = this.cmalps.width;
            if (this.categoryAxisLabelPlacement == -11302) {
                salpsWidth = Math.max(salpsWidth, this.calps.width);
            }
            if (this.isRowEast) {
                if ((eastWidth += rmaGap) > salpsWidth) {
                    salGap = Math.min(maxSpacer, eastWidth - salpsWidth);
                }
            } else if ((westWidth += rmaGap) > salpsWidth) {
                salGap = Math.min(maxSpacer, westWidth - salpsWidth);
            }
            int startX = r.x + margin.left;
            int matrixStartX = startX + westWidth;
            if (this.isRowEast) {
                this.mb.width = this.cmab.width = matrixWidth;
                this.mb.x = this.cmab.x = matrixStartX;
                this.rab.width = this.raps.width;
                this.rab.x = this.mb.x - this.rab.width + raTweak;
                this.cmalb.width = this.cmalps.width;
                this.cmalb.x = this.cmab.x + this.cmab.width + salGap;
                this.r2ab.width = this.r2aps.width;
                this.r2ab.x = this.mb.x + this.mb.width - r2aTweak;
                this.rmab.width = this.rmalb.width = this.rmaps.width;
                this.rmab.x = this.rmalb.x = this.r2ab.x + this.r2ab.width + rmaGap;
                switch (this.categoryAxisLabelPlacement) {
                    case -11302: 
                    case 11301: 
                    case 11302: 
                    case 11303: {
                        width = eastWidth - salGap > 0 ? eastWidth - salGap : eastWidth;
                        this.calb.width = Math.min(this.calps.width, width);
                        this.calb.x = this.mb.x + this.mb.width + salGap;
                        break;
                    }
                    case 11306: {
                        maxCenteringWidth = this.mb.width + 2 * Math.min(eastWidth, westWidth);
                        this.calb.width = Math.min(maxCenteringWidth, this.calps.width);
                        this.calb.x = this.mb.x + this.mb.width / 2 - this.calb.width / 2;
                    }
                }
            } else {
                this.mb.width = this.cmab.width = matrixWidth;
                this.mb.x = this.cmab.x = matrixStartX;
                this.rab.width = this.raps.width;
                this.rab.x = this.mb.x - this.rab.width + raTweak;
                this.rmab.width = this.rmalb.width = this.rmaps.width;
                this.rmab.x = this.rmalb.x = matrixStartX - responseAxisAreaWidth - rmaGap - this.rmab.width;
                this.cmalb.width = this.cmalps.width;
                this.cmalb.x = matrixStartX - this.cmalb.width - salGap;
                this.r2ab.width = this.r2aps.width;
                this.r2ab.x = this.mb.x + this.mb.width - r2aTweak;
                switch (this.categoryAxisLabelPlacement) {
                    case -11302: 
                    case 11301: 
                    case 11302: 
                    case 11303: {
                        width = westWidth - salGap > 0 ? westWidth - salGap : westWidth;
                        this.calb.width = Math.min(this.calps.width, width);
                        this.calb.x = this.mb.x - this.calb.width - salGap;
                        break;
                    }
                    case 11306: {
                        maxCenteringWidth = this.mb.width + 2 * Math.min(eastWidth, westWidth);
                        this.calb.width = Math.min(maxCenteringWidth, this.calps.width);
                        this.calb.x = this.mb.x + this.mb.width / 2 - this.calb.width / 2;
                    }
                }
            }
            int[] responseAxesWidths = this._computeVertical_ResponseAxesLabelMaxWidths(matrixWidth);
            int maxResponseAxisLabelWidth = responseAxesWidths[0];
            int maxResponse2AxisLabelWidth = responseAxesWidths[1];
            this.ralb.width = Math.min(this.ralps.width, maxResponseAxisLabelWidth);
            switch (this.responseAxisLabelPlacement) {
                case 11306: {
                    this.ralb.x = this.rab.x - this.ralb.width;
                    break;
                }
                default: {
                    if (this.ralb.width < this.rab.width) {
                        this.ralb.x = this.rab.x + this.rab.width - this.ralb.width;
                        break;
                    }
                    this.ralb.x = this.rab.x;
                    break;
                }
                case 11301: {
                    this.ralb.x = this.mb.x;
                    break;
                }
                case 11302: {
                    this.ralb.x = this.mb.x - this.ralb.width;
                }
            }
            this.r2alb.width = Math.min(this.r2alps.width, maxResponse2AxisLabelWidth);
            switch (this.response2AxisLabelPlacement) {
                case 11306: {
                    this.r2alb.x = this.r2ab.x + this.r2ab.width;
                    break;
                }
                default: {
                    if (this.r2alb.width < this.r2ab.width) {
                        this.r2alb.x = this.r2ab.x;
                        break;
                    }
                    this.r2alb.x = this.r2ab.x + this.r2ab.width - this.r2alb.width;
                    break;
                }
                case 11301: {
                    this.r2alb.x = this.r2ab.x - this.r2alb.width;
                    break;
                }
                case 11302: {
                    this.r2alb.x = this.r2ab.x;
                }
            }
            int[] heights = this._computeVertical_Heights();
            int northHeight = heights[0];
            int matrixHeight = cellHeight * this.rowLeafCount;
            int southHeight = heights[2];
            int excessPixels2 = r.height - (matrixHeight + northHeight + southHeight);
            margin.top = excessPixels2 / 2;
            margin.bottom = excessPixels2 - margin.top;
            int startY = r.y + margin.top;
            int topOfMatrixY = startY + northHeight;
            this.ralb.height = this.ralps.height;
            switch (this.responseAxisLabelPlacement) {
                case 11301: 
                case 11302: 
                case 11303: {
                    this.ralb.y = topOfMatrixY - this.ralps.height;
                    break;
                }
                case 11306: {
                    this.ralb.height = Math.min(this.ralps.height, matrixHeight);
                    this.ralb.y = topOfMatrixY + matrixHeight / 2 - this.ralb.height / 2;
                }
            }
            this.r2alb.height = this.r2alps.height;
            switch (this.response2AxisLabelPlacement) {
                case 11301: 
                case 11302: 
                case 11303: {
                    this.r2alb.y = topOfMatrixY - this.r2alps.height;
                    break;
                }
                case 11306: {
                    this.r2alb.height = Math.min(this.r2alps.height, matrixHeight);
                    this.r2alb.y = topOfMatrixY + matrixHeight / 2 - this.r2alb.height / 2;
                }
            }
            this.rmalb.y = topOfMatrixY - this.rmalps.height;
            this.rmalb.height = this.rmalps.height;
            this.r2ab.y = this.rmab.y = topOfMatrixY;
            this.rab.y = this.rmab.y;
            this.mb.y = this.rmab.y;
            this.r2ab.height = this.rmab.height = matrixHeight;
            this.rab.height = this.rmab.height;
            this.mb.height = this.rmab.height;
            this.cmalb.height = this.cmalps.height;
            this.cmab.height = this.cmaps.height;
            this.calb.height = this.calps.height;
            switch (this.categoryAxisLabelPlacement) {
                case -11302: 
                case 11301: 
                case 11302: 
                case 11303: {
                    this.calb.y = topOfMatrixY + matrixHeight - this.calb.height;
                    this.cmab.y = topOfMatrixY + matrixHeight;
                    this.cmalb.y = this.cmab.y + this.cmab.height - this.cmalb.height;
                    break;
                }
                case 11306: {
                    this.calb.y = topOfMatrixY + matrixHeight;
                    this.cmab.y = this.calb.y + this.calb.height;
                    this.cmalb.y = this.cmab.y + this.cmab.height - this.cmalb.height;
                }
            }
            MatrixContainer2.applyPaneBounds(this.matrixCellPane, this.mb);
            MatrixContainer2.applyPaneBounds(this.columnMatrixAxisValuePane, this.cmab);
            MatrixContainer2.applyPaneBounds(this.columnMatrixAxisLabelPane, this.cmalb);
            MatrixContainer2.applyPaneBounds(this.rowMatrixAxisValuePane, this.rmab);
            MatrixContainer2.applyPaneBounds(this.rowMatrixAxisLabelPane, this.rmalb);
            MatrixContainer2.applyPaneBounds(this.responseAxisCellPane, this.rab);
            MatrixContainer2.applyPaneBounds(this.responseAxisLabelPane, this.ralb);
            MatrixContainer2.applyPaneBounds(this.response2AxisCellPane, this.r2ab);
            MatrixContainer2.applyPaneBounds(this.response2AxisLabelPane, this.r2alb);
            MatrixContainer2.applyPaneBounds(this.categoryAxisLabelPane, this.calb);
            if (this.messagesComponent != null) {
                int x1 = this.rab.x;
                int x2 = this.r2ab.x + this.r2ab.width;
                int y1 = this.mb.y;
                int y2 = this.mb.y + this.mb.height;
                Rectangle display = new Rectangle(x1, y1, x2 - x1, y2 - y1);
                Dimension wps = this.messagesComponent.getPreferredSize();
                Rectangle wmb = new Rectangle();
                wmb.width = Math.min(wps.width, display.width);
                wmb.height = Math.min(wps.height, display.height);
                wmb.x = display.x + (display.width - wmb.width) / 2;
                wmb.y = display.y + (display.height - wmb.height) / 2;
                MatrixContainer2.applyBounds(this.messagesComponent, wmb);
            }
            if (this.columnScrollBar != null) {
                Rectangle csbb = null;
                csbb = this.cmab.height > 0 ? new Rectangle(this.cmab.x, this.cmab.y + this.cmab.height, this.cmab.width, 13) : new Rectangle(this.mb.x, this.mb.y + this.mb.height + this.calb.height, this.mb.width, 13);
                this.columnScrollBar.setBounds(csbb.x, csbb.y, csbb.width, csbb.height);
            }
            if (this.rowScrollBar != null) {
                Rectangle rsbb = this.responseAxisCellPane == null && this.response2AxisCellPane != null ? new Rectangle(this.mb.x + this.mb.width + 1, this.mb.y, 13, this.mb.height) : new Rectangle(this.mb.x - 13, this.mb.y, 13, this.mb.height);
                this.rowScrollBar.setBounds(rsbb.x, rsbb.y, rsbb.width, rsbb.height);
            }
            this.columnScrollModelProjection.setViewportSize(this.mb.width);
            this.rowScrollModelProjection.setViewportSize(this.mb.height);
            elementWidth = this.columnScrollModelProjection.calculateViewSize() / this.maxCategoryLeafCount;
            this._conveyCategoryAxisStrideLength(elementWidth);
            cellHeight = this.rowScrollModelProjection.calculateViewSize() / this.rowLeafCount;
            int scrollX = this.columnScrollModelProjection.calculateViewScroll();
            int scrollY = this.rowScrollModelProjection.calculateViewScroll();
            int matrixScrollX = scrollX;
            int matrixScrollY = scrollY;
            boolean rowScrollX = false;
            int rowScrollY = matrixScrollY;
            int colScrollX = matrixScrollX;
            boolean colScrollY = false;
            this.rab.height = cellHeight;
            CellPane.doLayout(this.responseAxisCellPane, this.rac, 0, rowScrollY);
            if (this.responseAxisLevelCount > 0) {
                if (this.responseAxisLabelPlacement == 11306) {
                    LabelPane.doLayout(this.responseAxisLabelPane, 3, this.ralb.width / this.responseAxisLevelCount, this.ralb.height);
                } else {
                    LabelPane.doLayout(this.responseAxisLabelPane, 5, this.ralb.width, this.ralb.height / this.responseAxisLevelCount);
                }
            }
            this.r2ab.height = cellHeight;
            CellPane.doLayout(this.response2AxisCellPane, this.r2ac, 0, rowScrollY);
            if (this.response2AxisLevelCount > 0) {
                if (this.response2AxisLabelPlacement == 11306) {
                    LabelPane.doLayout(this.response2AxisLabelPane, 7, this.r2alb.width / this.response2AxisLevelCount, this.r2alb.height);
                } else {
                    LabelPane.doLayout(this.response2AxisLabelPane, 5, this.r2alb.width, this.r2alb.height / this.response2AxisLevelCount);
                }
            }
            if (this.categoryAxisLevelCount > 0) {
                leafGrowthDirection = 1;
                LabelPane.doLayout(this.categoryAxisLabelPane, leafGrowthDirection, this.calb.width, this.calb.height / this.categoryAxisLevelCount);
            }
            leafGrowthDirection = this.isRowEast ? 7 : 3;
            this.rmaps.setRowHeight(0, cellHeight);
            GridDimension.mergeWidths(this.rmaps, this.rmalps);
            ValuePane.doLayout(this.rowMatrixAxisValuePane, leafGrowthDirection, this.rmaps, 0, rowScrollY);
            LabelPane.doLayout(this.rowMatrixAxisLabelPane, leafGrowthDirection, this.rmalps);
            HashMap columnToCategoryCount = this.layoutCache.getMatrixLeafToMaxCategoryLeafCount();
            if (this.integratedTree == null && this.columnMatrixAxisValuePane != null && this.columnMatrixAxisValuePane.getTree() != null) {
                DataTreeGroupNode root = (DataTreeGroupNode)this.columnMatrixAxisValuePane.getTree().getRoot();
                DefaultMutableTreeNode[] leaves = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
                int ncols = columnToCategoryCount.size();
                this.cmaps.setGridSize(ncols, false, this.cmaps.getGridSize().height, false);
                for (int cx = 0; cx < ncols; ++cx) {
                    int w = (int)elementWidth * (Integer)columnToCategoryCount.get(leaves[cx]);
                    this.cmaps.setColWidth(cx, w);
                }
            } else {
                this.cmaps.setColWidth(0, (int)elementWidth);
            }
            HashMap<Object, Integer> columnToColumnWidth = new HashMap<Object, Integer>(columnToCategoryCount.size());
            Object[] keys = columnToCategoryCount.keySet().toArray();
            for (int ii = 0; ii < keys.length; ++ii) {
                Integer columnCategoryCount = (Integer)columnToCategoryCount.get(keys[ii]);
                Integer columnWidth = new Integer((int)elementWidth * columnCategoryCount);
                columnToColumnWidth.put(keys[ii], columnWidth);
            }
            int leafGrowthDirection2 = 1;
            GridDimension.mergeHeights(this.cmaps, this.cmalps);
            ValuePane.doLayout(this.columnMatrixAxisValuePane, leafGrowthDirection2, this.cmaps, colScrollX, 0);
            LabelPane.doLayout(this.columnMatrixAxisLabelPane, leafGrowthDirection2, this.cmalps);
            if (this.matrixCellPane != null && this.matrixCellPane.getContentPanelComponentCount() > 0) {
                VerticalLayout verticalLayout = this;
                synchronized (verticalLayout) {
                    double newCategoryAxisAdjustment;
                    Dimension response2AxisInnerMargin;
                    Dimension responseAxisInnerMargin;
                    Component[] components;
                    Component[] components2;
                    BarLineChartCell barLineChartCell = (BarLineChartCell)this.matrixCellPane.getContentPanelComponents()[0];
                    BarLineChartCellModel barLineChartCellModel = barLineChartCell.getBarLineChartCellModel();
                    Insets outerMargin = barLineChartCellModel.getOuterMargin();
                    boolean orientationIsVertical = this.layoutCache.isVertical;
                    ArrayList<Component> axisCells = null;
                    if (this.responseAxisCellPane != null && (components2 = this.responseAxisCellPane.getContentPanelComponents()) != null && components2.length > 0) {
                        axisCells = new ArrayList<Component>(components2.length);
                        for (int ii = 0; ii < components2.length; ++ii) {
                            axisCells.add(components2[ii]);
                        }
                    }
                    ArrayList<Component> axis2Cells = null;
                    if (this.response2AxisCellPane != null && (components = this.response2AxisCellPane.getContentPanelComponents()) != null && components.length > 0) {
                        axis2Cells = new ArrayList<Component>(components.length);
                        for (int ii = 0; ii < components.length; ++ii) {
                            axis2Cells.add(components[ii]);
                        }
                    }
                    double oldCategoryAxisAdjustment = orientationIsVertical ? (double)outerMargin.bottom : (double)outerMargin.left;
                    outerMargin.left = 0;
                    outerMargin.top = 0;
                    outerMargin.right = 0;
                    outerMargin.bottom = 0;
                    if (axisCells != null && (responseAxisInnerMargin = ((AxisCell)axisCells.get(0)).getAxisModel().getMargin()) != null) {
                        responseAxisInnerMargin.width = 0;
                        responseAxisInnerMargin.height = 0;
                    }
                    if (axis2Cells != null && (response2AxisInnerMargin = ((AxisCell)axis2Cells.get(0)).getAxisModel().getMargin()) != null) {
                        response2AxisInnerMargin.width = 0;
                        response2AxisInnerMargin.height = 0;
                    }
                    barLineChartCellModel.setCommonBarWidth(null);
                    AlignableComponentConstraints constraints = new AlignableComponentConstraints();
                    constraints.getBounds().height = cellHeight;
                    if (this.columnLeafCount > 1) {
                        this._resetForceFit(columnToColumnWidth);
                        this._resetValueFont(columnToColumnWidth, true);
                        CellPane.doLayoutByColumn(this.matrixCellPane, constraints, columnToColumnWidth, matrixScrollX, matrixScrollY);
                        String fitUsed = this._findFitUsed(columnToColumnWidth);
                        Font smallestFontUsed = this._findSmallestValueFontUsed(columnToColumnWidth, true);
                        if (fitUsed != null || smallestFontUsed != null) {
                            if (fitUsed != null) {
                                this._forceFit(columnToColumnWidth, fitUsed);
                            }
                            if (smallestFontUsed != null) {
                                this._forceValueFont(columnToColumnWidth, smallestFontUsed, true);
                            }
                            CellPane.doLayoutByColumn(this.matrixCellPane, constraints, columnToColumnWidth, matrixScrollX, matrixScrollY);
                        } else {
                            CellPane.doLayoutByColumn(this.matrixCellPane, constraints, columnToColumnWidth, matrixScrollX, matrixScrollY);
                        }
                    } else {
                        CellPane.doLayoutByColumn(this.matrixCellPane, constraints, columnToColumnWidth, matrixScrollX, matrixScrollY);
                    }
                    double d = newCategoryAxisAdjustment = orientationIsVertical ? (double)outerMargin.bottom : (double)outerMargin.left;
                    if (newCategoryAxisAdjustment != oldCategoryAxisAdjustment) {
                        int axis2CellCount;
                        int ii;
                        Rectangle axisBounds;
                        int axisCellCount;
                        Double categoryAxisAdjustment = new Double(newCategoryAxisAdjustment);
                        int n = axisCellCount = axisCells != null ? axisCells.size() : 0;
                        if (axisCellCount > 0) {
                            axisBounds = ((AxisCell)axisCells.get(0)).getBounds();
                            if (axisBounds.width + axisBounds.height > 0) {
                                for (ii = 0; ii < axisCellCount; ++ii) {
                                    AxisCell axisCell = (AxisCell)axisCells.get(ii);
                                    AxisCellModel axisCellModel = axisCell.getAxisModel();
                                    if (orientationIsVertical) {
                                        axisCellModel.setCatAxisAdj(categoryAxisAdjustment);
                                        axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getHeight());
                                        continue;
                                    }
                                    axisCellModel.setResAxisAdj(categoryAxisAdjustment);
                                    axisCellModel.computeParameters(axisCell.getChannel(), axisCell.getWidth());
                                }
                            }
                        }
                        int n2 = axis2CellCount = axis2Cells != null ? axis2Cells.size() : 0;
                        if (axis2CellCount > 0) {
                            axisBounds = ((AxisCell)axis2Cells.get(0)).getBounds();
                            if (axisBounds.width + axisBounds.height > 0) {
                                for (ii = 0; ii < axis2CellCount; ++ii) {
                                    AxisCell axis2Cell = (AxisCell)axis2Cells.get(ii);
                                    AxisCellModel axis2CellModel = axis2Cell.getAxisModel();
                                    if (orientationIsVertical) {
                                        axis2CellModel.setCatAxisAdj(categoryAxisAdjustment);
                                        axis2CellModel.computeParameters(axis2Cell.getChannel(), axis2Cell.getHeight());
                                        continue;
                                    }
                                    axis2CellModel.setResAxisAdj(categoryAxisAdjustment);
                                    axis2CellModel.computeParameters(axis2Cell.getChannel(), axis2Cell.getWidth());
                                }
                            }
                        }
                    }
                }
            }
        }

        private void _resetForceFit(HashMap columnToColumnWidth) {
            this._fitConsistency(columnToColumnWidth, null, true);
        }

        private String _findFitUsed(HashMap columnToColumnWidth) {
            return this._fitConsistency(columnToColumnWidth, null, false);
        }

        private String _forceFit(HashMap columnToColumnWidth, String forceFitToUse) {
            return this._fitConsistency(columnToColumnWidth, forceFitToUse, false);
        }

        private String _fitConsistency(HashMap columnToColumnWidth, String forceFitToUse, boolean resetForceFit) {
            String fitUsed = null;
            int indexOfFitUsed = -1;
            int tempIndex = -1;
            if (this.matrixCellPane != null && columnToColumnWidth != null) {
                DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(this.matrixCellPane.getColumnTree());
                DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(this.matrixCellPane.getRowTree());
                if (colTreeLeaves != null && rowTreeLeaves != null) {
                    for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                        Integer width = (Integer)columnToColumnWidth.get(colTreeLeaves[ii]);
                        if (width == null) continue;
                        for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                            String used;
                            BarLineChartCell cellComponent = (BarLineChartCell)this.matrixCellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                            if (cellComponent == null) continue;
                            if (forceFitToUse != null) {
                                cellComponent.getBarLineChartCellModel().getOuterMargin().bottom = 0;
                                cellComponent.getCategoryAxisCellModel().setForceFitAlgorithm(forceFitToUse);
                                continue;
                            }
                            if (resetForceFit) {
                                cellComponent.getCategoryAxisCellModel().setForceFitAlgorithm(null);
                                continue;
                            }
                            if (cellComponent.getCategoryAxisCellModel() == null || cellComponent.getCategoryAxisCellModel().getFitAlgorithmUsed() == null || (used = cellComponent.getCategoryAxisCellModel().getFitAlgorithmUsed()) == null || used.length() <= 0) continue;
                            String[] fitAlg = cellComponent.getCategoryAxisCellModel().getFitAlgorithm();
                            for (int xx = 0; xx < fitAlg.length; ++xx) {
                                if (fitAlg[xx].indexOf(used) < 0) continue;
                                tempIndex = xx;
                            }
                            if (tempIndex <= indexOfFitUsed) continue;
                            indexOfFitUsed = tempIndex;
                            fitUsed = fitAlg[indexOfFitUsed];
                        }
                    }
                }
            }
            return fitUsed;
        }

        private boolean restrictCategoryAndColumnLabelWidths() {
            int maxSLWidth;
            int responseWidth = VerticalLayout._computeVertical_ResponseWidth(this.raps, this.ralps, this.responseAxisLabelPlacement);
            int response2Width = VerticalLayout._computeVertical_ResponseWidth(this.r2aps, this.r2alps, this.response2AxisLabelPlacement);
            int slpsWidth = Math.max(this.categoryAxisLabelPlacement == -11302 ? this.calps.width : 0, this.cmalps.width);
            if (slpsWidth > (maxSLWidth = Math.max(this.rmaps.width, this.rmalps.width) + (this.isRowEast ? response2Width : responseWidth))) {
                this.cmalps.width = Math.min(this.cmalps.width, maxSLWidth);
                if (this.categoryAxisLabelPlacement == -11302) {
                    this.calps.width = Math.min(this.calps.width, maxSLWidth);
                }
                return true;
            }
            return false;
        }

        private int[] _computeVertical_ResponseAxesLabelMaxWidths(int matrixWidth) {
            boolean response2AxisClaim;
            int maxResponseAxisLabelWidth = this.ralps.width;
            int maxResponse2AxisLabelWidth = this.r2alps.width;
            boolean responseAxisClaim = this.ralps.width > 0 && (this.responseAxisLabelPlacement == 11301 || this.responseAxisLabelPlacement == 11303);
            boolean bl = response2AxisClaim = this.r2alps.width > 0 && (this.response2AxisLabelPlacement == 11301 || this.response2AxisLabelPlacement == 11303);
            if (responseAxisClaim && !response2AxisClaim) {
                maxResponseAxisLabelWidth = matrixWidth;
                if (this.responseAxisLabelPlacement == 11303) {
                    maxResponseAxisLabelWidth += this.rab.width;
                }
            } else if (!responseAxisClaim && response2AxisClaim) {
                maxResponse2AxisLabelWidth = matrixWidth;
                if (this.response2AxisLabelPlacement == 11303) {
                    maxResponse2AxisLabelWidth += this.r2ab.width;
                }
            } else if (responseAxisClaim && response2AxisClaim) {
                int desiredResponseAxisMatrixWidth = this.ralps.width;
                if (this.responseAxisLabelPlacement == 11303) {
                    desiredResponseAxisMatrixWidth -= this.rab.width;
                }
                int desiredResponse2AxisMatrixWidth = this.r2alps.width;
                if (this.response2AxisLabelPlacement == 11303) {
                    desiredResponse2AxisMatrixWidth -= this.r2ab.width;
                }
                if (desiredResponseAxisMatrixWidth + desiredResponse2AxisMatrixWidth < matrixWidth) {
                    maxResponseAxisLabelWidth = this.ralps.width;
                    maxResponse2AxisLabelWidth = this.r2alps.width;
                } else if (desiredResponseAxisMatrixWidth < matrixWidth / 2) {
                    maxResponseAxisLabelWidth = this.ralps.width;
                    maxResponse2AxisLabelWidth = matrixWidth - desiredResponseAxisMatrixWidth;
                    if (this.response2AxisLabelPlacement == 11303) {
                        maxResponse2AxisLabelWidth += this.r2ab.width;
                    }
                } else if (desiredResponse2AxisMatrixWidth < matrixWidth / 2) {
                    maxResponse2AxisLabelWidth = this.r2alps.width;
                    maxResponseAxisLabelWidth = matrixWidth - desiredResponse2AxisMatrixWidth;
                    if (this.responseAxisLabelPlacement == 11303) {
                        maxResponseAxisLabelWidth += this.rab.width;
                    }
                } else {
                    maxResponseAxisLabelWidth = matrixWidth / 2;
                    if (this.responseAxisLabelPlacement == 11303) {
                        maxResponseAxisLabelWidth += this.rab.width;
                    }
                    maxResponse2AxisLabelWidth = matrixWidth / 2;
                    if (this.response2AxisLabelPlacement == 11303) {
                        maxResponse2AxisLabelWidth += this.r2ab.width;
                    }
                }
            }
            return new int[]{maxResponseAxisLabelWidth, maxResponse2AxisLabelWidth};
        }

        private static int _computeVertical_ResponseWidth(Dimension raps, Dimension ralps, int responseAxisLabelPlacement) {
            int responseWidth = 0;
            switch (responseAxisLabelPlacement) {
                default: {
                    responseWidth = raps.width;
                    break;
                }
                case 11306: {
                    responseWidth = ralps.width + raps.width;
                    break;
                }
                case 11302: {
                    responseWidth = Math.max(raps.width, ralps.width);
                }
            }
            return responseWidth;
        }

        public static int[] computeVertical_Widths(Dimension mps, Dimension raps, Dimension ralps, Dimension r2aps, Dimension r2alps, Dimension calps, GridDimension cmaps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, boolean isRowEast, int responseAxisLabelPlacement, int response2AxisLabelPlacement, int categoryAxisLabelPlacement, boolean considerResponseLabelLength) {
            int calpsHeight;
            int westWidth = VerticalLayout._computeVertical_ResponseWidth(raps, ralps, responseAxisLabelPlacement);
            int eastWidth = VerticalLayout._computeVertical_ResponseWidth(r2aps, r2alps, response2AxisLabelPlacement);
            int n = calpsHeight = categoryAxisLabelPlacement == 11306 ? 0 : calps.width;
            if (isRowEast) {
                eastWidth = Math.max(eastWidth + Math.max(rmaps.width, rmalps.width), Math.max(cmalps.width, calpsHeight));
            } else {
                westWidth = Math.max(westWidth + Math.max(rmaps.width, rmalps.width), Math.max(cmalps.width, calpsHeight));
            }
            int matrixWidth = 0;
            if (mps != null) {
                matrixWidth = Math.max(mps.width, cmaps.width);
                if (considerResponseLabelLength) {
                    int spacer;
                    int responselabelMatrixWidth = 0;
                    if (responseAxisLabelPlacement == 11301) {
                        responselabelMatrixWidth = ralps.width;
                    } else if (responseAxisLabelPlacement == 11303) {
                        responselabelMatrixWidth = Math.max(0, ralps.width - raps.width);
                    }
                    int response2labelMatrixWidth = 0;
                    if (response2AxisLabelPlacement == 11301) {
                        response2labelMatrixWidth = r2alps.width;
                    } else if (response2AxisLabelPlacement == 11303) {
                        response2labelMatrixWidth = Math.max(0, r2alps.width - r2aps.width);
                    }
                    int n2 = spacer = responselabelMatrixWidth > 0 && response2labelMatrixWidth > 0 ? Util.MIN_FONT_WIDTH * 2 : 0;
                    if (responselabelMatrixWidth + response2labelMatrixWidth + spacer > matrixWidth) {
                        matrixWidth = responselabelMatrixWidth + response2labelMatrixWidth + spacer;
                    }
                    if (categoryAxisLabelPlacement == 11306 && calps.width > matrixWidth) {
                        matrixWidth = calps.width;
                    }
                }
            }
            return new int[]{westWidth, matrixWidth, eastWidth};
        }

        private int[] _computeVertical_Widths() {
            return VerticalLayout.computeVertical_Widths(null, this.raps, this.ralps, this.r2aps, this.r2alps, this.calps, null, this.cmalps, this.rmaps, this.rmalps, this.isRowEast, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement, this.categoryAxisLabelPlacement, false);
        }

        private double _computeVertical_CategoryWidth(Rectangle r) {
            int[] widths = this._computeVertical_Widths();
            return (r.width - (widths[0] + widths[2])) / this.maxCategoryLeafCount;
        }

        public static int[] computeVertical_Heights(Dimension raps, Dimension ralps, Dimension r2aps, Dimension r2alps, Dimension calps, Dimension mps, GridDimension cmaps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int responseAxisLabelPlacement, int response2AxisLabelPlacement, int categoryAxisLabelPlacement) {
            int ralph = responseAxisLabelPlacement == 11306 ? 0 : ralps.height;
            int r2alph = response2AxisLabelPlacement == 11306 ? 0 : r2alps.height;
            int northHeight = Math.max(Math.max(ralph, r2alph), rmalps.height);
            int calpsHeight = categoryAxisLabelPlacement == 11306 ? calps.height : 0;
            int southHeight = Math.max(cmaps.height, cmalps.height) + calpsHeight;
            int matrixHeight = 0;
            if (mps != null) {
                matrixHeight = Math.max(Math.max(raps.height, r2aps.height), Math.max(mps.height, rmaps.height));
                int responselabelMatrixHeight = 0;
                if (responseAxisLabelPlacement == 11306) {
                    responselabelMatrixHeight = ralps.height;
                }
                int response2labelMatrixHeight = 0;
                if (response2AxisLabelPlacement == 11306) {
                    response2labelMatrixHeight = r2alps.height;
                }
                if (Math.max(responselabelMatrixHeight, response2labelMatrixHeight) > matrixHeight) {
                    matrixHeight = Math.max(responselabelMatrixHeight, response2labelMatrixHeight);
                }
            }
            return new int[]{northHeight, matrixHeight, southHeight};
        }

        private int[] _computeVertical_Heights() {
            return VerticalLayout.computeVertical_Heights(null, this.ralps, null, this.r2alps, this.calps, null, this.cmaps, this.cmalps, null, this.rmalps, this.responseAxisLabelPlacement, this.response2AxisLabelPlacement, this.categoryAxisLabelPlacement);
        }

        private int _computeVertical_CellHeight(int displayHeight) {
            int[] heights = this._computeVertical_Heights();
            return (displayHeight - (heights[0] + heights[2])) / this.rowLeafCount;
        }

        private void _applyAutomaticJustification() {
            switch (this.responseAxisLabelPlacement) {
                case 11306: {
                    StringComponent.applyAutomaticJustification(this.responseAxisLabelPane, 0);
                    break;
                }
                default: {
                    StringComponent.applyAutomaticJustification(this.responseAxisLabelPane, 2);
                    break;
                }
                case 11301: {
                    StringComponent.applyAutomaticJustification(this.responseAxisLabelPane, 2);
                    break;
                }
                case 11302: {
                    StringComponent.applyAutomaticJustification(this.responseAxisLabelPane, 4);
                }
            }
            switch (this.response2AxisLabelPlacement) {
                case 11306: {
                    StringComponent.applyAutomaticJustification(this.response2AxisLabelPane, 0);
                    break;
                }
                default: {
                    StringComponent.applyAutomaticJustification(this.response2AxisLabelPane, 4);
                    break;
                }
                case 11301: {
                    StringComponent.applyAutomaticJustification(this.response2AxisLabelPane, 4);
                    break;
                }
                case 11302: {
                    StringComponent.applyAutomaticJustification(this.response2AxisLabelPane, 2);
                }
            }
            switch (this.categoryAxisLabelPlacement) {
                case 11306: {
                    StringComponent.applyAutomaticJustification(this.categoryAxisLabelPane, 0);
                    break;
                }
                default: {
                    StringComponent.applyAutomaticJustification(this.categoryAxisLabelPane, this.isRowEast ? 2 : 4);
                    break;
                }
                case 11301: 
                case 11302: 
                case 11303: {
                    StringComponent.applyAutomaticJustification(this.categoryAxisLabelPane, 4);
                }
            }
            StringComponent.applyAutomaticJustification(this.columnMatrixAxisLabelPane, this.isRowEast ? 2 : 4);
        }
    }

    private static abstract class BarLineChartLayout
    extends MatrixContainer2.LayoutStrategy {
        final LayoutCache layoutCache;
        final ValueTree integratedTree;
        final boolean isRowEast;
        final boolean isColumnRotationEnabled;
        final int integratedLevelCount;
        final int columnLevelCount;
        final int rowLevelCount;
        final int columnLeafCount;
        final int rowLeafCount;
        final int maxCategoryLeafCount;
        final int elementClusterCount;
        final int responseAxisLevelCount;
        final int response2AxisLevelCount;
        final int categoryAxisLevelCount;
        final int categoryAxisLabelPlacement;
        int responseAxisLabelPlacement;
        int response2AxisLabelPlacement;
        final int responseAxisLineThickness;
        final int response2AxisLineThickness;
        final int columnCount;
        final int rowCount;
        final Dimension mps;
        final Dimension raps;
        final Dimension ralps;
        final Dimension r2aps;
        final Dimension r2alps;
        final Dimension calps;
        GridDimension cmaps;
        final GridDimension cmalps;
        final GridDimension rmaps;
        final GridDimension rmalps;
        final AlignableComponentConstraints mc;
        final AlignableComponentConstraints rac;
        final AlignableComponentConstraints ralc;
        final AlignableComponentConstraints r2ac;
        final AlignableComponentConstraints r2alc;
        final AlignableComponentConstraints calc;
        final AlignableComponentConstraints cmac;
        final AlignableComponentConstraints cmalc;
        final AlignableComponentConstraints rmac;
        final AlignableComponentConstraints rmalc;
        final Rectangle mb;
        final Rectangle rab;
        final Rectangle ralb;
        final Rectangle r2ab;
        final Rectangle r2alb;
        final Rectangle calb;
        final Rectangle cmab;
        final Rectangle cmalb;
        final Rectangle rmab;
        final Rectangle rmalb;
        final CellPane matrixCellPane;
        final CellPane responseAxisCellPane;
        final LabelPane responseAxisLabelPane;
        final CellPane response2AxisCellPane;
        final LabelPane response2AxisLabelPane;
        final ValuePane columnMatrixAxisValuePane;
        final LabelPane columnMatrixAxisLabelPane;
        final ValuePane rowMatrixAxisValuePane;
        final LabelPane rowMatrixAxisLabelPane;
        final LabelPane categoryAxisLabelPane;
        final JComponent messagesComponent;
        final ZoomScrollBar columnScrollBar;
        final ZoomScrollBar rowScrollBar;
        final MatrixContainer2.ScrollModelProjection columnScrollModelProjection;
        final MatrixContainer2.ScrollModelProjection rowScrollModelProjection;

        public BarLineChartLayout(MatrixContainer2 container, LayoutCache layoutCache) {
            super(container);
            this.layoutCache = layoutCache;
            this.integratedTree = layoutCache.getIntegratedTree();
            this.matrixCellPane = layoutCache.getMatrixCellPane();
            this._clearBarLineChartCellSizes();
            this.responseAxisCellPane = layoutCache.getResponseAxisCellPane();
            this.responseAxisLabelPane = layoutCache.getResponseAxisLabelPane();
            this.response2AxisCellPane = layoutCache.getResponse2AxisCellPane();
            this.response2AxisLabelPane = layoutCache.getResponse2AxisLabelPane();
            this.columnMatrixAxisValuePane = layoutCache.getColumnMatrixAxisValuePane();
            this.columnMatrixAxisLabelPane = layoutCache.getColumnMatrixAxisLabelPane();
            this.rowMatrixAxisValuePane = layoutCache.getRowMatrixAxisValuePane();
            this.rowMatrixAxisLabelPane = layoutCache.getRowMatrixAxisLabelPane();
            this.categoryAxisLabelPane = layoutCache.getCategoryAxisLabelPane();
            this.messagesComponent = layoutCache.getMessagesComponent();
            this.columnScrollBar = layoutCache.getColumnScrollBar();
            this.rowScrollBar = layoutCache.getRowScrollBar();
            this.columnScrollModelProjection = layoutCache.getColumnScrollModelProjection();
            this.rowScrollModelProjection = layoutCache.getRowScrollModelProjection();
            this.integratedLevelCount = layoutCache.getIntegratedLevelCount();
            this.columnLevelCount = layoutCache.getColumnLevelCount();
            this.rowLevelCount = layoutCache.getRowLevelCount();
            this.columnLeafCount = layoutCache.getColumnLeafCount();
            this.rowLeafCount = layoutCache.getRowLeafCount();
            this.maxCategoryLeafCount = layoutCache.getMaxCategoryLeafCount();
            this.elementClusterCount = layoutCache.getElementClusterCount();
            this.responseAxisLevelCount = layoutCache.getResponseAxisLevelCount();
            this.response2AxisLevelCount = layoutCache.getResponse2AxisLevelCount();
            this.categoryAxisLevelCount = layoutCache.getCategoryAxisLevelCount();
            this.categoryAxisLabelPlacement = layoutCache.getCategoryAxisLabelPlacement();
            this.responseAxisLabelPlacement = layoutCache.getResponseAxisLabelPlacement();
            this.response2AxisLabelPlacement = layoutCache.getResponse2AxisLabelPlacement();
            this.responseAxisLineThickness = layoutCache.getResponseAxisLineThickness();
            this.response2AxisLineThickness = layoutCache.getResponse2AxisLineThickness();
            this.isRowEast = layoutCache.isRowEast();
            this.isColumnRotationEnabled = layoutCache.isColumnRotationEnabled();
            this.columnCount = Math.max(1, layoutCache.getColumnLevelCount());
            this.rowCount = Math.max(1, layoutCache.getRowLevelCount());
            this.mps = layoutCache.getMatrixPreferredSize();
            this.raps = layoutCache.getResponseAxisPreferredSize();
            this.ralps = layoutCache.getResponseAxisLabelPreferredSize();
            this.r2aps = layoutCache.getResponse2AxisPreferredSize();
            this.r2alps = layoutCache.getResponse2AxisLabelPreferredSize();
            this.calps = layoutCache.getCategoryAxisLabelPreferredSize();
            this.cmaps = layoutCache.getColumnMatrixAxisPreferredSize();
            this.cmalps = layoutCache.getColumnMatrixAxisLabelPreferredSize();
            this.rmaps = layoutCache.getRowMatrixAxisPreferredSize();
            this.rmalps = layoutCache.getRowMatrixAxisLabelPreferredSize();
            this.mc = new AlignableComponentConstraints();
            this.rac = new AlignableComponentConstraints();
            this.ralc = new AlignableComponentConstraints();
            this.r2ac = new AlignableComponentConstraints();
            this.r2alc = new AlignableComponentConstraints();
            this.calc = new AlignableComponentConstraints();
            this.cmac = new AlignableComponentConstraints();
            this.cmalc = new AlignableComponentConstraints();
            this.rmac = new AlignableComponentConstraints();
            this.rmalc = new AlignableComponentConstraints();
            this.mb = this.mc.getBounds();
            this.rab = this.rac.getBounds();
            this.ralb = this.ralc.getBounds();
            this.r2ab = this.r2ac.getBounds();
            this.r2alb = this.r2alc.getBounds();
            this.calb = this.calc.getBounds();
            this.cmab = this.cmac.getBounds();
            this.cmalb = this.cmalc.getBounds();
            this.rmab = this.rmac.getBounds();
            this.rmalb = this.rmalc.getBounds();
        }

        protected void _conveyCategoryAxisStrideLength(double categoryAxisStride) {
            if (this.integratedTree != null) {
                Component[] cells = this.matrixCellPane.getContentPanelComponents();
                for (int ii = 0; ii < cells.length; ++ii) {
                    if (!(cells[ii] instanceof BarLineChartCell)) continue;
                    ((BarLineChartCell)cells[ii]).setCategoryAxisStrideLength(categoryAxisStride);
                }
            }
        }

        protected void _clearBarLineChartCellSizes() {
            Component[] cells;
            if (this.matrixCellPane != null && (cells = this.matrixCellPane.getContentPanelComponents()) != null) {
                for (int ii = 0; ii < cells.length; ++ii) {
                    if (!(cells[ii] instanceof BarLineChartCell)) continue;
                    ((BarLineChartCell)cells[ii]).setBounds(0, 0, 0, 0);
                }
            }
        }

        protected void _resetValueFont(HashMap columnToColumnWidth, boolean vertical) {
            Font forceFontToUse = null;
            boolean reset = true;
            this._fontConsistency(columnToColumnWidth, forceFontToUse, reset, vertical);
        }

        protected Font _findSmallestValueFontUsed(HashMap columnToColumnWidth, boolean vertical) {
            Font forceFontToUse = null;
            boolean reset = false;
            return this._fontConsistency(columnToColumnWidth, forceFontToUse, reset, vertical);
        }

        protected void _forceValueFont(HashMap columnToColumnWidth, Font forceFontToUse, boolean vertical) {
            boolean reset = false;
            this._fontConsistency(columnToColumnWidth, forceFontToUse, reset, vertical);
        }

        private Font _fontConsistency(HashMap widthHashMap, Font forceFontToUse, boolean resetForceFont, boolean vertical) {
            Font smallestFontUsed = null;
            AxisCellModel axisCellModel = null;
            if (this.matrixCellPane != null && widthHashMap != null) {
                DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(this.matrixCellPane.getColumnTree());
                DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(this.matrixCellPane.getRowTree());
                if (colTreeLeaves != null && colTreeLeaves != null) {
                    for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                        for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                            BarLineChartCell cellComponent = (BarLineChartCell)this.matrixCellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                            if (cellComponent == null || cellComponent.getCategoryAxisCellModel() == null) continue;
                            axisCellModel = cellComponent.getCategoryAxisCellModel();
                            if (forceFontToUse != null) {
                                axisCellModel.setValueFontForced(forceFontToUse);
                                continue;
                            }
                            if (resetForceFont) {
                                axisCellModel.setValueFontForced(null);
                                continue;
                            }
                            Font valueFont = axisCellModel.getValueFontUsed();
                            if (valueFont == null || smallestFontUsed != null && valueFont.getSize() >= smallestFontUsed.getSize()) continue;
                            smallestFontUsed = valueFont;
                        }
                    }
                }
            }
            return smallestFontUsed;
        }
    }
}

