/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.barlinechart;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.DiscreteStyle;
import com.sas.graphics.components.DiscreteStyleMapModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ReferenceBandModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.ScrollModelInterface;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueZone;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.util.barlinechart.BarLineChartModel;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.AxisCell;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.CategorizationInfo;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ColorRampLegendCellModel;
import com.sas.graphics.util.cell.CustomMarker;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.DrilldownMarker;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalLegendCell;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixContainer;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.barlinechart.BIPBarSkinFactory;
import com.sas.graphics.util.cell.barlinechart.BarLineChartCell;
import com.sas.graphics.util.cell.barlinechart.BarLineChartCellModel;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrixContainer;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.measures.BaseLength;
import com.sas.util.NumericRangeSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BarLineChartMatrix
extends Matrix {
    public static final String RB_KEY = "BarLineChartMatrix.";
    private static final int DATA_LABEL_SPACER_X = (int)new BaseLength(6.0, "pt").getMagnitude((Object)"px");
    private static final int DATA_LABEL_SPACER_Y = (int)new BaseLength(6.0, "pt").getMagnitude((Object)"py");
    private static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);
    private transient ArrayList cells;
    private transient ArrayList axisCells;
    private transient ArrayList axis2Cells;
    private transient BarLineChartMatrixModel model;
    private transient BarLineChartCellModel barLineChartCellModel;
    private transient LegendCell styleByLegend;
    private transient LegendCell multiResponseLegend;
    private transient Insets outerMargin = new Insets(0, 0, 0, 0);
    private transient DrilldownMarker drillMarker = new DrilldownMarker();
    private transient ValueTree subgroupValueTree;
    private transient BarLineChartMatrixContainer matrixContainer;
    private transient ValueTree integratedAxis;
    private ValueTree integratedValueTree;
    int numLegendEntries = 0;

    public BarLineChartMatrix(Channel channel) {
        this(null, channel);
    }

    public BarLineChartMatrix(BarLineChartMatrixModel model, Channel channel) {
        super(channel);
        this._setModel(model);
    }

    public void setModel(BarLineChartMatrixModel newModel) {
        this._setModel(newModel);
    }

    private void _setModel(BarLineChartMatrixModel newModel) {
        if (this.model != newModel) {
            this.model = newModel;
            this.reconstruct();
        }
    }

    public BarLineChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    public void removeAllLegends() {
        this.removeAll();
        if (this.matrixContainer != null) {
            this.add((Component)this.matrixContainer, "Center");
        }
    }

    @Override
    protected void cleanMatrixContainer() {
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        this.cells = null;
        this.axisCells = null;
        this.axis2Cells = null;
        this.barLineChartCellModel = null;
        this.styleByLegend = null;
        this.multiResponseLegend = null;
        this.integratedAxis = null;
    }

    @Override
    protected synchronized void construct() {
        int frameVisibilityPolicy;
        Dimension prefMargin;
        int line2ResponseCount;
        BarLineChartCell blcc;
        int ii;
        boolean line2Valid;
        BarLineChartMatrixModel matrixModel = this.getModel();
        if (matrixModel.getGraphModel() != null) {
            this.setAntialiasedTextEnabled(matrixModel.getGraphModel().isAntialiasedText());
        }
        Boolean adjustAxisForZoomScrollBar = new Boolean(!this.getFitToScreen());
        if (this.getFitToScreen()) {
            matrixModel.setDisplayPolicy(new Integer(10000));
        } else {
            matrixModel.setDisplayPolicy(new Integer(10002));
        }
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        Variable categoryVariable = dataSource.getVariable(matrixModel.getCategoryRole(), 0);
        if (categoryVariable == null) {
            throw new IllegalStateException(RB.getStringResource("categoryVariableNotSpecified.ex.txt"));
        }
        if (categoryVariable.getValueCount() < 1) {
            return;
        }
        Variable[] barVariableArray = dataSource.getVariable(matrixModel.getBarRole());
        Variable[] lineVariableArray = dataSource.getVariable(matrixModel.getLineRole());
        Variable[] bar2VariableArray = dataSource.getVariable(matrixModel.getBar2Role());
        Variable[] line2VariableArray = dataSource.getVariable(matrixModel.getLine2Role());
        BarLineChartModel barLineChartModel = matrixModel.getBarLineChartModel();
        matrixModel.setRowModel(barLineChartModel.getRowAxisModel());
        matrixModel.setColumnModel(barLineChartModel.getColumnAxisModel());
        boolean isVerticalOrientation = barLineChartModel.getOrientation() == 1;
        Boolean antialiasedGraphics = matrixModel.getGraphModel().isAntialiasedGraphics() ? Boolean.TRUE : Boolean.FALSE;
        Boolean antialiasedText = matrixModel.getGraphModel().isAntialiasedText() ? Boolean.TRUE : Boolean.FALSE;
        boolean barValid = barVariableArray != null && barVariableArray.length > 0;
        boolean bar2Valid = bar2VariableArray != null && bar2VariableArray.length > 0;
        boolean lineValid = lineVariableArray != null && lineVariableArray.length > 0;
        boolean bl = line2Valid = line2VariableArray != null && line2VariableArray.length > 0;
        if (!(barValid || bar2Valid || lineValid || line2Valid)) {
            return;
        }
        this.barLineChartCellModel = new BarLineChartCellModel();
        this.barLineChartCellModel.setAnimationKeyFrameRole(matrixModel.getAnimationKeyFrameRole());
        this.barLineChartCellModel.setCategoryRole(matrixModel.getCategoryRole());
        this.barLineChartCellModel.setCategorySortRole(matrixModel.getCategorySortRole());
        this.barLineChartCellModel.setStyleByRole(matrixModel.getStyleByRole());
        this.barLineChartCellModel.setSubgroupRole(matrixModel.getSubgroupRole());
        this.barLineChartCellModel.setBarRole(matrixModel.getBarRole());
        this.barLineChartCellModel.setBar2Role(matrixModel.getBar2Role());
        this.barLineChartCellModel.setLineRole(matrixModel.getLineRole());
        this.barLineChartCellModel.setLine2Role(matrixModel.getLine2Role());
        this.barLineChartCellModel.setOutsideBarLabelRole(matrixModel.getOutsideBarLabelRole());
        this.barLineChartCellModel.setInsideBarLabelRole(matrixModel.getInsideBarLabelRole());
        this.barLineChartCellModel.setOutsideMarkerLabelRole(matrixModel.getOutsideMarkerLabelRole());
        this.barLineChartCellModel.setSelectionRole(matrixModel.getSelectionRole());
        this.barLineChartCellModel.setBarSelectionRole(matrixModel.getBarSelectionRole());
        this.barLineChartCellModel.setBar2SelectionRole(matrixModel.getBar2SelectionRole());
        this.barLineChartCellModel.setLineSelectionRole(matrixModel.getLineSelectionRole());
        this.barLineChartCellModel.setLine2SelectionRole(matrixModel.getLine2SelectionRole());
        this.barLineChartCellModel.setAuxiliaryRole(matrixModel.getAuxiliaryRole());
        this.barLineChartCellModel.setDataTipRole(matrixModel.getDataTipRole());
        this.barLineChartCellModel.setGraphModel(matrixModel.getGraphModel());
        this.barLineChartCellModel.setRuleTargetIdentifier(matrixModel.getRuleTargetIdentifier());
        this.barLineChartCellModel.setBarLineChartModel(barLineChartModel);
        this.barLineChartCellModel.setAntialiasedGraphics(antialiasedGraphics);
        this.barLineChartCellModel.setAntialiasedText(antialiasedText);
        boolean isOLAPData = dataSource.isOLAPData();
        if (!isOLAPData && !barLineChartModel.isZeroHeightBarsVisible()) {
            String nz;
            int ii2;
            double baseline;
            StringVariable subgroupVariable = (StringVariable)dataSource.getVariable(matrixModel.getSubgroupRole(), 0);
            int barVariableCount = barVariableArray == null ? 0 : barVariableArray.length;
            int bar2VariableCount = bar2VariableArray == null ? 0 : bar2VariableArray.length;
            int totalBarVariableCount = barVariableCount + bar2VariableCount;
            int stackBarPolicy = barLineChartModel.getStackBarPolicy();
            boolean stackBars = subgroupVariable != null && totalBarVariableCount > 1 || stackBarPolicy == 10200 && subgroupVariable != null || stackBarPolicy == 10201 && (totalBarVariableCount > 1 || subgroupVariable != null);
            String notZero = null;
            if (barVariableArray != null) {
                baseline = stackBars ? 0.0 : barLineChartModel.getResponseAxisBaselineModel().getPosition();
                for (ii2 = 0; ii2 < barVariableArray.length; ++ii2) {
                    if (barVariableArray[ii2] == null) continue;
                    nz = "(  " + barVariableArray[ii2].getName() + " ^= " + baseline + ")";
                    notZero = notZero == null ? nz : notZero + " or " + nz;
                }
            }
            if (bar2VariableArray != null) {
                baseline = stackBars ? 0.0 : barLineChartModel.getResponse2AxisBaselineModel().getPosition();
                for (ii2 = 0; ii2 < bar2VariableArray.length; ++ii2) {
                    if (bar2VariableArray[ii2] == null) continue;
                    nz = "(  " + bar2VariableArray[ii2].getName() + " ^= " + baseline + ")";
                    notZero = notZero == null ? nz : notZero + " or " + nz;
                }
            }
            dataSource = this.resetDataSource(dataSource.newDataSourceWhere(notZero));
        }
        int _up = barLineChartModel.getUniformPolicy();
        if (barLineChartModel.isWaterfallEnabled()) {
            boolean isInitialEnabled;
            boolean bl2 = isInitialEnabled = !Double.isNaN(barLineChartModel.getWaterfallInitialBarHeight()) && !Double.isInfinite(barLineChartModel.getWaterfallInitialBarHeight());
            _up = isInitialEnabled || barLineChartModel.isWaterfallFinalBarEnabled() ? 10202 : 10200;
        } else if (isOLAPData) {
            if (_up != 10200) {
                // empty if block
            }
            _up = 10200;
        } else if (_up != 10202) {
            VariableDefinition categoryVariableDefinition;
            Integer categorySort;
            Variable categorySortVariable = dataSource.getVariable(matrixModel.getCategorySortRole(), 0);
            if (categorySortVariable != null && ((categorySort = (categoryVariableDefinition = dataSource.getVariableDefinition(matrixModel.getCategoryRole(), 0)).getSort()) == null || categorySort != 10400)) {
                Variable[] rowVaraibles = dataSource.getVariable(matrixModel.getRowRole());
                Variable[] columnVaraibles = dataSource.getVariable(matrixModel.getColumnRole());
                if (_up == 10201 && (rowVaraibles != null || columnVaraibles != null)) {
                    System.err.println(RB.getStringResource(RB_KEY, "uniformNotSupportedWithCategorySortVariable.txt"));
                }
                _up = 10202;
            }
            if (_up != 10202) {
                VariableDefinition barVariables = dataSource.getVariableDefinition(matrixModel.getBarRole());
                VariableDefinition bar2Variables = dataSource.getVariableDefinition(matrixModel.getBar2Role());
                VariableDefinition lineVariables = dataSource.getVariableDefinition(matrixModel.getLineRole());
                VariableDefinition line2Variables = dataSource.getVariableDefinition(matrixModel.getLine2Role());
                if (BarLineChartMatrix._hasCumulativeStatistic(barVariables) || BarLineChartMatrix._hasCumulativeStatistic(bar2Variables) || BarLineChartMatrix._hasCumulativeStatistic(lineVariables) || BarLineChartMatrix._hasCumulativeStatistic(line2Variables)) {
                    if (_up == 10201) {
                        System.err.println(RB.getStringResource(RB_KEY, "uniformNotSupportedWithCumulativeStatistic.txt"));
                    }
                    _up = 10202;
                }
            }
        }
        int uniformPolicy = _up;
        if (isOLAPData && (!barLineChartModel.isWaterfallEnabled() || barLineChartModel.isWaterfallEnabled() && uniformPolicy != 10202)) {
            this.integratedAxis = this.getIntegratedValueTree(isVerticalOrientation, false);
        } else if (uniformPolicy == 10200 || uniformPolicy == 10201) {
            Variable[] columnVariables = dataSource.getVariable(matrixModel.getColumnRole());
            Variable[] rowVariables = dataSource.getVariable(matrixModel.getRowRole());
            if (columnVariables != null && rowVariables != null || isVerticalOrientation && rowVariables != null || !isVerticalOrientation && columnVariables != null) {
                this.integratedAxis = this.getIntegratedValueTree(isVerticalOrientation, uniformPolicy == 10201);
                uniformPolicy = 10200;
            }
        }
        this.barLineChartCellModel.setIntegratedAxisEnabled(this.integratedAxis == null ? Boolean.FALSE : Boolean.TRUE);
        if (uniformPolicy == 10201) {
            this.barLineChartCellModel.setUniformCategoryAxisMapper(BarLineChartMatrix._newUniformCategoryAxisMapper(dataSource, null, matrixModel));
        } else if (uniformPolicy == 10200) {
            StringToNumericMapper uniformCategoryAxisMapper;
            if (isVerticalOrientation) {
                Variable[] rowVariables = dataSource.getVariable(matrixModel.getRowRole());
                if (isOLAPData || rowVariables != null) {
                    Variable[] colVariables = dataSource.getVariable(matrixModel.getColumnRole());
                    if (colVariables == null) {
                        this.barLineChartCellModel.setUniformCategoryAxisMapper(BarLineChartMatrix._newUniformCategoryAxisMapper(dataSource, null, matrixModel));
                    } else {
                        ValueTree columnTree = this.getColumnValueTree();
                        DefaultMutableTreeNode[] columnLeaves = columnTree.getLeafNodes();
                        if (columnLeaves != null) {
                            Hashtable<DefaultMutableTreeNode, StringToNumericMapper> categoryAxisMappers = new Hashtable<DefaultMutableTreeNode, StringToNumericMapper>(columnLeaves.length);
                            this.barLineChartCellModel.setUniformCategoryAxisMappers(categoryAxisMappers);
                            for (int ii3 = 0; ii3 < columnLeaves.length; ++ii3) {
                                DefaultMutableTreeNode ordinal = columnLeaves[ii3];
                                uniformCategoryAxisMapper = BarLineChartMatrix._newUniformCategoryAxisMapper(dataSource, ordinal, matrixModel);
                                categoryAxisMappers.put(ordinal, uniformCategoryAxisMapper);
                            }
                        }
                    }
                }
            } else {
                Variable[] colVariables = dataSource.getVariable(matrixModel.getColumnRole());
                if (isOLAPData || colVariables != null) {
                    Variable[] rowVariables = dataSource.getVariable(matrixModel.getRowRole());
                    if (rowVariables == null) {
                        this.barLineChartCellModel.setUniformCategoryAxisMapper(BarLineChartMatrix._newUniformCategoryAxisMapper(dataSource, null, matrixModel));
                    } else {
                        ValueTree rowTree = this.getRowValueTree();
                        DefaultMutableTreeNode[] rowLeaves = rowTree.getLeafNodes();
                        if (rowLeaves != null) {
                            Hashtable<DefaultMutableTreeNode, StringToNumericMapper> categoryAxisMappers = new Hashtable<DefaultMutableTreeNode, StringToNumericMapper>(rowLeaves.length);
                            this.barLineChartCellModel.setUniformCategoryAxisMappers(categoryAxisMappers);
                            for (int ii4 = 0; ii4 < rowLeaves.length; ++ii4) {
                                DefaultMutableTreeNode ordinal = rowLeaves[ii4];
                                uniformCategoryAxisMapper = BarLineChartMatrix._newUniformCategoryAxisMapper(dataSource, ordinal, matrixModel);
                                categoryAxisMappers.put(ordinal, uniformCategoryAxisMapper);
                            }
                        }
                    }
                }
            }
        }
        int rowCount = this.getRowValueTree().getLeafNodeCount();
        int columnCount = this.getColumnValueTree().getLeafNodeCount();
        Integer maxVertCount = rowCount == 1 ? new Integer(Integer.MAX_VALUE) : new Integer(Math.max(2, 21 / rowCount));
        Integer maxHorzCount = columnCount == 1 ? new Integer(Integer.MAX_VALUE) : new Integer(Math.max(2, 21 / columnCount));
        AxisCellModel categoryAxisCellModel = new AxisCellModel();
        categoryAxisCellModel.setLocale(dataSource.getLocale());
        if (this.integratedAxis != null) {
            AxisModel dupCategoryAxisModel = new AxisModel();
            dupCategoryAxisModel.apply(barLineChartModel.getCategoryAxisModel());
            dupCategoryAxisModel.setVisible(false);
            categoryAxisCellModel.setAxisModel(dupCategoryAxisModel);
        } else {
            categoryAxisCellModel.setAxisModel(barLineChartModel.getCategoryAxisModel());
        }
        categoryAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
        categoryAxisCellModel.setAntialiasedText(antialiasedText);
        categoryAxisCellModel.setReferenceLinesVisible(Boolean.FALSE);
        categoryAxisCellModel.setTitleMarker(this.drillMarker);
        categoryAxisCellModel.setReverse(new Boolean(!isVerticalOrientation));
        if (isVerticalOrientation) {
            categoryAxisCellModel.setAxisOrientation("East");
            categoryAxisCellModel.setCellCount(new Integer(rowCount));
        } else {
            categoryAxisCellModel.setAxisOrientation("North");
            categoryAxisCellModel.setCellCount(new Integer(columnCount));
        }
        if (barLineChartModel.getCategoryAxisModel().getMajorTickStyle().getLineStyle().getVisibilityPolicy() == 10200) {
            categoryAxisCellModel.setMajorTickVisible(Boolean.FALSE);
        }
        Dimension depth = new Dimension(0, 0);
        if (barLineChartModel.getDimension() == 10101) {
            depth.width = (int)barLineChartModel.getBarWidth().getMagnitude((Object)"px");
        }
        categoryAxisCellModel.setDepth(depth);
        Variable columnVariable = dataSource.getVariable(matrixModel.getColumnRole(), 0);
        if (columnVariable != null && this.integratedAxis == null && barLineChartModel.getCategoryAxisModel().isVisible() && barLineChartModel.getCategoryAxisModel().getLabelTextStyle().isVisible()) {
            double minCatAxisAdj = (int)new BaseLength((double)barLineChartModel.getCategoryAxisModel().getLabelTextStyle().getFont().getSize(), "pt").getMagnitude((Object)"py");
            if (barLineChartModel.getResponseAxisModel().getValueTextStyle().isVisible() && barLineChartModel.getResponseAxisModel().isVisible()) {
                minCatAxisAdj += (double)((int)(new BaseLength((double)barLineChartModel.getResponseAxisModel().getValueTextStyle().getFont().getSize(), "pt").getMagnitude((Object)"py") * 0.5));
            }
            this.barLineChartCellModel.setMinCatAxisAdj(new Double(minCatAxisAdj));
        }
        this.barLineChartCellModel.setCategoryAxisCellModel(categoryAxisCellModel);
        this.barLineChartCellModel.setOuterMargin(this.outerMargin);
        Channel channel = this.getChannel();
        this.updateChannel();
        if (matrixModel.getGraphModel().isAntialiasedText()) {
            channel.glEnable(14);
        } else {
            channel.glDisable(14);
        }
        AxisCellModel responseAxisCellModel = new AxisCellModel();
        responseAxisCellModel.setCellCount(new Integer(0));
        this.barLineChartCellModel.setResponseAxisCellModel(responseAxisCellModel);
        responseAxisCellModel.setAxisModel(barLineChartModel.getResponseAxisModel());
        responseAxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
        AxisCellModel response2AxisCellModel = new AxisCellModel();
        response2AxisCellModel.setCellCount(new Integer(0));
        response2AxisCellModel.setAxisModel(barLineChartModel.getResponse2AxisModel());
        this.barLineChartCellModel.setResponse2AxisCellModel(response2AxisCellModel);
        response2AxisCellModel.setZoomScrollBarsVisible(adjustAxisForZoomScrollBar);
        this.cells = this.addMatrixCellComponents(new BarCellFactory(), this.barLineChartCellModel, new DataSource[]{dataSource}, this.integratedAxis);
        int numCells = this.cells.size();
        for (int i = 0; i < numCells; ++i) {
            BarLineChartCell bar = (BarLineChartCell)this.cells.get(i);
            categoryAxisCellModel.addPropertyChangeListener(bar);
        }
        double responseAxisMin = Double.POSITIVE_INFINITY;
        double responseAxisMax = Double.NEGATIVE_INFINITY;
        double response2AxisMin = Double.POSITIVE_INFINITY;
        double response2AxisMax = Double.NEGATIVE_INFINITY;
        int maxRow = -1;
        int maxColumn = -1;
        int maxBarsPerCategory = 1;
        int maxPreferredCategoryAxisStride = 0;
        for (ii = this.cells.size() - 1; ii >= 0; --ii) {
            blcc = (BarLineChartCell)this.cells.get(ii);
            if (blcc.getResponseAxisRangeMin() < responseAxisMin) {
                responseAxisMin = blcc.getResponseAxisRangeMin();
            }
            if (blcc.getResponseAxisRangeMax() > responseAxisMax) {
                responseAxisMax = blcc.getResponseAxisRangeMax();
            }
            if (blcc.getResponse2AxisRangeMin() < response2AxisMin) {
                response2AxisMin = blcc.getResponse2AxisRangeMin();
            }
            if (blcc.getResponse2AxisRangeMax() > response2AxisMax) {
                response2AxisMax = blcc.getResponse2AxisRangeMax();
            }
            if (blcc.getMaxBarsPerCategory() > maxBarsPerCategory) {
                maxBarsPerCategory = blcc.getMaxBarsPerCategory();
            }
            if (blcc.getPreferredCategoryAxisStride() > maxPreferredCategoryAxisStride) {
                maxPreferredCategoryAxisStride = blcc.getPreferredCategoryAxisStride();
            }
            if (maxRow < blcc.getRow()) {
                maxRow = blcc.getRow();
            }
            if (maxColumn >= blcc.getColumn()) continue;
            maxColumn = blcc.getColumn();
        }
        this.barLineChartCellModel.setMaxRow(new Integer(maxRow));
        this.barLineChartCellModel.setMaxColumn(new Integer(maxColumn));
        for (ii = this.cells.size() - 1; ii >= 0; --ii) {
            blcc = (BarLineChartCell)this.cells.get(ii);
            blcc.setMaxPreferredCategoryAxisStride(maxPreferredCategoryAxisStride);
        }
        this.barLineChartCellModel.setMaxBarsPerCategory(new Integer(maxBarsPerCategory));
        if (barVariableArray != null || lineVariableArray != null) {
            responseAxisCellModel.setLocale(dataSource.getLocale());
            ContinuousRangeToNumericMapper responseAxisMapper = new ContinuousRangeToNumericMapper();
            responseAxisMapper.setInputMin(responseAxisMin);
            responseAxisMapper.setInputMax(responseAxisMax);
            responseAxisMapper.setLabelRanges(barLineChartModel.getResponseAxisModel().getContinuousValuePlacementPolicy() == 12202);
            int cft_bar = dataSource.getComputedFormatState(matrixModel.getBarRole());
            int cft_line = dataSource.getComputedFormatState(matrixModel.getLineRole());
            if (barVariableArray != null && lineVariableArray != null) {
                if (cft_bar == 0 && cft_line == 0) {
                    responseAxisMapper.setFormat(GTKUtil.getAxisFormat(barVariableArray, lineVariableArray));
                } else if (cft_bar == 2 && cft_line == 2) {
                    responseAxisCellModel.setFormatState(new Integer(2));
                }
            } else if (barVariableArray != null) {
                if (cft_bar == 0) {
                    responseAxisMapper.setFormat(GTKUtil.getAxisFormat(barVariableArray));
                } else if (cft_bar == 2) {
                    responseAxisCellModel.setFormatState(new Integer(2));
                }
            } else if (lineVariableArray != null) {
                if (cft_line == 0) {
                    responseAxisMapper.setFormat(GTKUtil.getAxisFormat(lineVariableArray));
                } else if (cft_line == 2) {
                    responseAxisCellModel.setFormatState(new Integer(2));
                }
            }
            AxisModel responseAxisModel = barLineChartModel.getResponseAxisModel();
            responseAxisCellModel.setAxisModel(responseAxisModel);
            if (isVerticalOrientation) {
                responseAxisCellModel.setAxisOrientation("North");
                responseAxisCellModel.setCellCount(new Integer(rowCount));
                responseAxisCellModel.setMaximumValueCount(maxVertCount);
            } else {
                responseAxisCellModel.setAxisOrientation("East");
                responseAxisCellModel.setCellCount(new Integer(columnCount));
                responseAxisCellModel.setMaximumValueCount(maxHorzCount);
            }
            responseAxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
            responseAxisCellModel.setMapper((NumericMapper)responseAxisMapper);
            responseAxisCellModel.setDepth(depth);
            responseAxisCellModel.setMargin(categoryAxisCellModel.getMargin());
            responseAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
            responseAxisCellModel.setAntialiasedText(antialiasedText);
            responseAxisCellModel.computeParameters(channel);
            if (isVerticalOrientation) {
                this.outerMargin.left = responseAxisCellModel.getResAxisAdj().intValue();
            } else {
                this.outerMargin.bottom = responseAxisCellModel.getCatAxisAdj().intValue();
            }
            responseAxisCellModel.setPrimary(Boolean.TRUE);
            this.axisCells = isVerticalOrientation ? this.addRowTabletCellComponents(new DependentAxisCellFactory(), responseAxisCellModel, null, responseAxisCellModel.getPrimary()) : this.addColumnTabletCellComponents(new DependentAxisCellFactory(), responseAxisCellModel, null, responseAxisCellModel.getPrimary());
            responseAxisCellModel.setCellCount(new Integer(this.axisCells.size()));
            categoryAxisCellModel.setCellCount(new Integer(this.cells.size() / this.axisCells.size()));
        }
        if (bar2VariableArray != null || line2VariableArray != null) {
            response2AxisCellModel.setLocale(dataSource.getLocale());
            ContinuousRangeToNumericMapper response2AxisMapper = new ContinuousRangeToNumericMapper();
            response2AxisMapper.setInputMin(response2AxisMin);
            response2AxisMapper.setInputMax(response2AxisMax);
            response2AxisMapper.setLabelRanges(barLineChartModel.getResponseAxisModel().getContinuousValuePlacementPolicy() == 12202);
            int cft_bar2 = dataSource.getComputedFormatState(matrixModel.getBar2Role());
            int cft_line2 = dataSource.getComputedFormatState(matrixModel.getLine2Role());
            if (bar2VariableArray != null && line2VariableArray != null) {
                if (cft_bar2 == 0 && cft_line2 == 0) {
                    response2AxisMapper.setFormat(GTKUtil.getAxisFormat(bar2VariableArray, line2VariableArray));
                } else if (cft_bar2 == 2 && cft_line2 == 2) {
                    response2AxisCellModel.setFormatState(new Integer(2));
                }
            } else if (bar2VariableArray != null) {
                if (cft_bar2 == 0) {
                    response2AxisMapper.setFormat(GTKUtil.getAxisFormat(bar2VariableArray));
                } else if (cft_bar2 == 2) {
                    response2AxisCellModel.setFormatState(new Integer(2));
                }
            } else if (line2VariableArray != null) {
                if (cft_line2 == 0) {
                    response2AxisMapper.setFormat(GTKUtil.getAxisFormat(line2VariableArray));
                } else if (cft_line2 == 2) {
                    response2AxisCellModel.setFormatState(new Integer(2));
                }
            }
            AxisModel response2AxisModel = barLineChartModel.getResponse2AxisModel();
            response2AxisCellModel.setAxisModel(response2AxisModel);
            if (isVerticalOrientation) {
                response2AxisCellModel.setAxisOrientation("North");
                response2AxisCellModel.setCellCount(new Integer(rowCount));
                response2AxisCellModel.setMaximumValueCount(maxVertCount);
            } else {
                response2AxisCellModel.setAxisOrientation("East");
                response2AxisCellModel.setCellCount(new Integer(columnCount));
                response2AxisCellModel.setMaximumValueCount(maxHorzCount);
            }
            response2AxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
            response2AxisCellModel.setMapper((NumericMapper)response2AxisMapper);
            response2AxisCellModel.setPrimary(Boolean.FALSE);
            response2AxisCellModel.setDepth(depth);
            response2AxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
            response2AxisCellModel.setAntialiasedText(antialiasedText);
            response2AxisCellModel.setMargin(categoryAxisCellModel.getMargin());
            if (response2AxisCellModel != null) {
                response2AxisCellModel.computeParameters(channel);
                if (responseAxisCellModel != null && (barValid || lineValid) && (bar2Valid || line2Valid)) {
                    response2AxisCellModel.setValueCount(responseAxisCellModel.getValueCount());
                    response2AxisCellModel.computeSecondaryParameters(channel);
                }
            }
            if (isVerticalOrientation) {
                this.outerMargin.right = response2AxisCellModel.getResAxisAdj().intValue();
            } else {
                this.outerMargin.top = response2AxisCellModel.getCatAxisAdj().intValue();
            }
            response2AxisCellModel.setPrimary(Boolean.FALSE);
            this.barLineChartCellModel.setResponse2AxisCellModel(response2AxisCellModel);
            this.axis2Cells = isVerticalOrientation ? this.addRowTabletCellComponents(new DependentAxisCellFactory(), response2AxisCellModel, null, response2AxisCellModel.getPrimary()) : this.addColumnTabletCellComponents(new DependentAxisCellFactory(), response2AxisCellModel, null, response2AxisCellModel.getPrimary());
            response2AxisCellModel.setCellCount(new Integer(this.axis2Cells.size()));
            if (this.axisCells == null) {
                categoryAxisCellModel.setCellCount(new Integer(this.cells.size() / this.axis2Cells.size()));
            }
        }
        if (this.barLineChartCellModel.getResponseAxisCellModel().getTitleAddition() != null) {
            this.matrixContainer.addSpecialResponseAxisLabel(this.barLineChartCellModel.getResponseAxisCellModel().getTitleAddition());
        }
        if (this.barLineChartCellModel.getResponse2AxisCellModel().getTitleAddition() != null) {
            this.matrixContainer.addSpecialResponse2AxisLabel(this.barLineChartCellModel.getResponse2AxisCellModel().getTitleAddition());
        }
        double tallestOutsideHeight = 0.0;
        double longestOutsideLength = 0.0;
        Variable[] outsideBarLabelVariableArray = dataSource.getVariable(matrixModel.getOutsideBarLabelRole());
        Variable[] insideBarLabelVariableArray = dataSource.getVariable(matrixModel.getInsideBarLabelRole());
        Variable[] outsideMarkerLabelVariableArray = dataSource.getVariable(matrixModel.getOutsideMarkerLabelRole());
        DataLabelSize dataLabelSize = new DataLabelSize();
        if (BarLineChartMatrix._calcDataLabelSize(channel, barLineChartModel.getOutsideBarLabelContent(), barLineChartModel.getOutsideBarLabelTextStyle().getFont(), dataLabelSize, barVariableArray, bar2VariableArray, outsideBarLabelVariableArray, matrixModel, true, dataSource)) {
            this.barLineChartCellModel.setLongestOutsideBarLabel(dataLabelSize.longestLabel);
            tallestOutsideHeight = Math.max(dataLabelSize.tallestHeight, tallestOutsideHeight);
            longestOutsideLength = Math.max(dataLabelSize.longestLength, longestOutsideLength);
        }
        this._reset(dataLabelSize);
        if (BarLineChartMatrix._calcDataLabelSize(channel, barLineChartModel.getInsideBarLabelContent(), barLineChartModel.getInsideBarLabelTextStyle().getFont(), dataLabelSize, barVariableArray, bar2VariableArray, insideBarLabelVariableArray, matrixModel, false, dataSource)) {
            this.barLineChartCellModel.setLongestInsideBarLabel(dataLabelSize.longestLabel);
        }
        this._reset(dataLabelSize);
        if (BarLineChartMatrix._calcDataLabelSize(channel, barLineChartModel.getOutsideMarkerLabelContent(), barLineChartModel.getOutsideMarkerLabelTextStyle().getFont(), dataLabelSize, lineVariableArray, line2VariableArray, outsideMarkerLabelVariableArray, matrixModel, true, dataSource)) {
            this.barLineChartCellModel.setLongestOutsideMarkerLabel(dataLabelSize.longestLabel);
            tallestOutsideHeight = Math.max(dataLabelSize.tallestHeight, tallestOutsideHeight);
            longestOutsideLength = Math.max(dataLabelSize.longestLength, longestOutsideLength);
        }
        this.barLineChartCellModel.setTallestOutsideLabel(dataLabelSize.tallestLabel);
        Dimension refLabelSize = this._calcCategoryReferenceLabelSize(channel);
        this.barLineChartCellModel.setReferenceLabelSize(refLabelSize);
        int fontSize = responseAxisCellModel != null ? responseAxisCellModel.getAxisModel().getValueTextStyle().getFont().getSize() : response2AxisCellModel.getAxisModel().getValueTextStyle().getFont().getSize();
        int minMarginHeight = Math.max((int)tallestOutsideHeight + DATA_LABEL_SPACER_Y, fontSize / 2);
        int minMarginWidth = Math.max((int)longestOutsideLength + DATA_LABEL_SPACER_X, fontSize / 2);
        if (refLabelSize != null) {
            minMarginHeight = Math.max(minMarginHeight, refLabelSize.height);
            minMarginWidth = Math.max(minMarginWidth, refLabelSize.width);
        }
        int lineResponseCount = lineVariableArray != null ? lineVariableArray.length : 0;
        int n = line2ResponseCount = line2VariableArray != null ? line2VariableArray.length : 0;
        if (lineResponseCount + line2ResponseCount > 0) {
            boolean markers = barLineChartModel.isMarkerEnabled();
            int markerSize = 0;
            if (markers) {
                MarkerStyle[] styles = matrixModel.getGraphModel().getDataElementStyles().getMarkerStyles();
                for (int ii5 = 0; ii5 < styles.length; ++ii5) {
                    BaseLength gl = styles[ii5].getSize();
                    markerSize = (int)Math.max((double)markerSize, gl.getMagnitude((Object)"px"));
                }
            }
            minMarginHeight += markerSize / 2;
            minMarginWidth += markerSize / 2;
        }
        boolean extendToMargin = false;
        boolean extendToEndMargin = false;
        boolean extendToStartMargin = false;
        if (responseAxisCellModel != null) {
            double baseValue = barLineChartModel.getResponseAxisBaselineModel().getPosition();
            if (barVariableArray == null && bar2VariableArray == null) {
                extendToMargin = true;
            } else if (responseAxisMin < baseValue) {
                if (responseAxisMax > baseValue) {
                    extendToMargin = true;
                } else {
                    extendToStartMargin = true;
                }
            } else {
                extendToEndMargin = true;
            }
        }
        if (response2AxisCellModel != null) {
            if (!extendToMargin) {
                double baseValue = barLineChartModel.getResponse2AxisBaselineModel().getPosition();
                if (response2AxisMin < baseValue) {
                    if (extendToEndMargin || response2AxisMax > baseValue) {
                        extendToStartMargin = false;
                        extendToEndMargin = false;
                        extendToMargin = true;
                    } else {
                        extendToStartMargin = true;
                    }
                } else if (extendToStartMargin) {
                    extendToStartMargin = false;
                    extendToEndMargin = false;
                    extendToMargin = true;
                } else {
                    extendToEndMargin = true;
                }
            }
            response2AxisCellModel.setExtendToEndMargin(new Boolean(extendToEndMargin));
            response2AxisCellModel.setExtendToStartMargin(new Boolean(extendToStartMargin));
            response2AxisCellModel.setExtendToMargin(new Boolean(extendToMargin));
            Dimension minMargin = response2AxisCellModel.getMinimumMargin();
            if (isVerticalOrientation) {
                minMargin.height = minMarginHeight;
            } else {
                minMargin.width = minMarginWidth;
            }
            prefMargin = response2AxisCellModel.getPreferredMargin();
            prefMargin.width = Math.max(prefMargin.width, minMargin.width);
            prefMargin.height = Math.max(prefMargin.height, minMargin.height);
        }
        if (responseAxisCellModel != null) {
            responseAxisCellModel.setExtendToEndMargin(new Boolean(extendToEndMargin));
            responseAxisCellModel.setExtendToStartMargin(new Boolean(extendToStartMargin));
            responseAxisCellModel.setExtendToMargin(new Boolean(extendToMargin));
            Dimension minMargin = responseAxisCellModel.getMinimumMargin();
            if (isVerticalOrientation) {
                minMargin.height = minMarginHeight;
            } else {
                minMargin.width = minMarginWidth;
            }
            prefMargin = responseAxisCellModel.getPreferredMargin();
            prefMargin.width = Math.max(prefMargin.width, minMargin.width);
            prefMargin.height = Math.max(prefMargin.height, minMargin.height);
        }
        if ((frameVisibilityPolicy = matrixModel.getGraphModel().getFrameLineStyle().getVisibilityPolicy()) == 10200) {
            Boolean vis = dataSource.getVariable(matrixModel.getColumnRole()) != null || dataSource.getVariable(matrixModel.getRowRole()) != null ? Boolean.TRUE : Boolean.FALSE;
            this.barLineChartCellModel.setFrameVisible(vis);
        } else {
            this.barLineChartCellModel.setFrameVisible(frameVisibilityPolicy == 10201 ? Boolean.TRUE : Boolean.FALSE);
        }
        DataElementStyles dataElementStyles = matrixModel.getGraphModel().getDataElementStyles();
        if (dataSource != null && dataElementStyles != null && dataElementStyles.getFillStyles() != null && dataElementStyles.getFillStyles().length >= 1) {
            FillStyle[] fillStyles = dataElementStyles.getFillStyles();
            StrokeLineStyle[] lineStyles = dataElementStyles.getLineStyles();
            MarkerStyle[] markerStyles = dataElementStyles.getMarkerStyles();
            Color[] cycleColors = dataElementStyles.getDiscreteFillColors();
            Color barOutlineColor = dataElementStyles.getOutlineLineStyle().getVisibilityPolicy() == 10202 ? new Color(0, true) : dataElementStyles.getOutlineLineStyle().getColor();
            LineStyle markerOutline = dataElementStyles.getOutlineLineStyle();
            if (markerOutline.getVisibilityPolicy() != 10201) {
                markerOutline = new LineStyle();
                markerOutline.setColor(INVISIBLE_COLOR);
            }
            int barResponseCount = barVariableArray != null ? barVariableArray.length : 0;
            int bar2ResponseCount = bar2VariableArray != null ? bar2VariableArray.length : 0;
            int lineResponseCount2 = lineVariableArray != null ? lineVariableArray.length : 0;
            int line2ResponseCount2 = line2VariableArray != null ? line2VariableArray.length : 0;
            int totalVariableCount = barResponseCount + lineResponseCount2 + bar2ResponseCount + line2ResponseCount2;
            StringVariable subgroupVariable = (StringVariable)dataSource.getVariable(matrixModel.getSubgroupRole(), 0);
            Variable styleByVariable = dataSource.getVariable(matrixModel.getStyleByRole(), 0);
            if (subgroupVariable != null || totalVariableCount < 2 && styleByVariable != null) {
                Hashtable<String, FillStyle> formattedValue2FillStyle = null;
                Hashtable<String, StrokeLineStyle> formattedValue2LineStyle = null;
                Hashtable<String, MarkerStyle> formattedValue2MarkerStyle = null;
                if (styleByVariable instanceof StringVariable) {
                    StrokeLineStyle lineStyle;
                    FillStyle backgroundFillStyle;
                    Container parent;
                    Variable ordered_styleByVariable = styleByVariable;
                    NumericVariable nbv = dataSource.getBaseVariable((StringVariable)ordered_styleByVariable);
                    if (nbv != null) {
                        ordered_styleByVariable = GTKUtil.newStringVariableFromFormattedUniqueValues(nbv);
                        ordered_styleByVariable.setLabel(nbv.getLabel());
                        ordered_styleByVariable.init();
                    }
                    boolean markerOn = lineResponseCount2 + line2ResponseCount2 > 0 && barLineChartModel.isMarkerEnabled();
                    boolean lineOn = lineResponseCount2 + line2ResponseCount2 > 0 && barLineChartModel.isInterpolationEnabled();
                    boolean fillOn = barResponseCount + bar2ResponseCount > 0 || lineResponseCount2 + line2ResponseCount2 > 0 && barLineChartModel.isFillAreaEnabled();
                    SwingActionProvider actionProvider = null;
                    for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
                    }
                    if (parent instanceof Graph) {
                        actionProvider = ((Graph)parent).getActionProvider();
                    }
                    Color backgroundColor = (backgroundFillStyle = matrixModel.getBarLineChartModel().getLegendModel().getBackgroundFillStyle()).isVisible() ? backgroundFillStyle.getSolidFillColor() : null;
                    ValuePane.MultiStyleValueComponentFactory valueComponentFactory = null;
                    if (subgroupVariable != null && dataSource.isOLAPData()) {
                        AbstractMarkerSkinFactory factory = this.createMarkerSkinFactory();
                        valueComponentFactory = Util.createMultiStyleValueComponentFactory(this.getSubgroupValueTree(), matrixModel.getBarLineChartModel().getLegendModel().getValueTextStyle(), dataElementStyles, fillOn, markerOn, lineOn, dataSource.getDataSourceSelectionModel(), actionProvider, (StringVariable)ordered_styleByVariable, 1, this, backgroundColor, channel, factory);
                        formattedValue2FillStyle = valueComponentFactory.getFormattedValue2FillStyleMap() != null ? new Hashtable<String, FillStyle>(valueComponentFactory.getFormattedValue2FillStyleMap()) : null;
                        formattedValue2LineStyle = valueComponentFactory.getFormattedValue2LineStyleMap() != null ? new Hashtable<String, StrokeLineStyle>(valueComponentFactory.getFormattedValue2LineStyleMap()) : null;
                        formattedValue2MarkerStyle = valueComponentFactory.getFormattedValue2MarkerStyleMap() != null ? new Hashtable<String, MarkerStyle>(valueComponentFactory.getFormattedValue2MarkerStyleMap()) : null;
                    } else {
                        int uvc = ordered_styleByVariable.getUniqueValueCount();
                        styleByVariable.init();
                        formattedValue2FillStyle = fillOn ? new Hashtable<String, FillStyle>(uvc) : null;
                        formattedValue2LineStyle = lineOn ? new Hashtable<String, StrokeLineStyle>(uvc) : null;
                        formattedValue2MarkerStyle = markerOn || lineOn ? new Hashtable<String, MarkerStyle>(uvc) : null;
                        FillStyle[] resultingFillStyles = formattedValue2FillStyle != null ? new FillStyle[uvc] : null;
                        StrokeLineStyle[] resultingLineStyles = formattedValue2LineStyle != null ? new StrokeLineStyle[uvc] : null;
                        MarkerStyle[] resultingMarkerStyles = formattedValue2MarkerStyle != null ? new MarkerStyle[uvc] : null;
                        DiscreteStyleMapModel styleMap = Util.rawObjectValueStyleMapToFormattedValueStyleMap(dataSource, styleByVariable, dataElementStyles.getDiscreteStyleMapModel());
                        for (int ii6 = 0; ii6 < uvc; ++ii6) {
                            DiscreteStyle discreteStyle;
                            FillStyle fillStyle = formattedValue2FillStyle != null ? Util.newCycledFillStyle(fillStyles, cycleColors, ii6) : null;
                            lineStyle = formattedValue2LineStyle != null ? Util.newCycledLineStyle(lineStyles, cycleColors, ii6) : null;
                            MarkerStyle markerStyle = formattedValue2MarkerStyle != null ? Util.newCycledMarkerStyle(markerStyles, cycleColors, ii6) : null;
                            String key = GTKUtil.VariableAccess.getFormattedUniqueValue((StringVariable)ordered_styleByVariable, ii6);
                            if (styleMap != null && (discreteStyle = styleMap.get(key)) != null) {
                                if (discreteStyle.getFillStyle() != null) {
                                    fillStyle = discreteStyle.getFillStyle();
                                }
                                if (discreteStyle.getLineStyle() != null) {
                                    lineStyle = discreteStyle.getLineStyle();
                                }
                                if (discreteStyle.getMarkerStyle() != null) {
                                    markerStyle = discreteStyle.getMarkerStyle();
                                }
                            }
                            if (resultingFillStyles != null) {
                                resultingFillStyles[ii6] = fillStyle;
                            }
                            if (resultingLineStyles != null) {
                                resultingLineStyles[ii6] = lineStyle;
                            }
                            if (resultingMarkerStyles != null) {
                                resultingMarkerStyles[ii6] = markerStyle;
                            }
                            if (formattedValue2FillStyle != null) {
                                formattedValue2FillStyle.put(key, fillStyle);
                            }
                            if (formattedValue2LineStyle != null) {
                                formattedValue2LineStyle.put(key, lineStyle);
                            }
                            if (formattedValue2MarkerStyle == null) continue;
                            formattedValue2MarkerStyle.put(key, markerStyle);
                        }
                        if (resultingFillStyles != null) {
                            fillStyles = resultingFillStyles;
                        }
                        if (resultingLineStyles != null) {
                            lineStyles = resultingLineStyles;
                        }
                        if (resultingMarkerStyles != null) {
                            markerStyles = resultingMarkerStyles;
                        }
                    }
                    this.barLineChartCellModel.setFormattedValueToFillStyle(formattedValue2FillStyle);
                    this.barLineChartCellModel.setFormattedValueToLineStyle(formattedValue2LineStyle);
                    this.barLineChartCellModel.setFormattedValueToMarkerStyle(formattedValue2MarkerStyle);
                    LegendCellModel lcm = new LegendCellModel(this.createMarkerSkinFactory());
                    lcm.setLegendModel(matrixModel.getBarLineChartModel().getLegendModel());
                    lcm.setAntialiasedGraphics(antialiasedGraphics);
                    lcm.setAntialiasedText(antialiasedText);
                    lcm.setMarkerOutlineLineStyle(markerOn ? markerOutline : dataElementStyles.getOutlineLineStyle());
                    lcm.setDefaultLabel(styleByVariable.getLabel());
                    lcm.setTitleMarker(this.drillMarker);
                    if (fillOn && !lineOn && !markerOn) {
                        lcm.setColorMapper((ColorMapper)GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(ordered_styleByVariable, fillStyles, cycleColors));
                    } else {
                        lcm.setColorMapper((ColorMapper)GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(ordered_styleByVariable, markerStyles, cycleColors));
                        if (markerOn && !fillOn && !lineOn) {
                            lcm.setMarkerMapper(GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper(ordered_styleByVariable, markerStyles));
                        }
                    }
                    int placement = matrixModel.getBarLineChartModel().getLegendModel().getPlacement();
                    if (placement == 10200) {
                        placement = 5;
                    }
                    lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
                    lcm.setPlacement(new Integer(placement));
                    if (dataSource.isRelationalData()) {
                        this.styleByLegend = new LegendCell(lcm, channel);
                        this.addLegend(this.styleByLegend, placement);
                    } else {
                        HierarchicalLegendCell legendCell = new HierarchicalLegendCell(this.getSubgroupValueTree(), lcm, valueComponentFactory, actionProvider, 3, channel);
                        this.styleByLegend = legendCell;
                        this.addLegend(legendCell, placement);
                    }
                    int uvc = styleByVariable.getUniqueValueCount();
                    if (lineOn || (fillOn ? 1 : 0) + (markerOn ? 1 : 0) > 1 || fillOn && BarLineChartMatrix.isCustomFillStyle(formattedValue2FillStyle)) {
                        Channel ch = this.styleByLegend.getJLegendChannel();
                        Integer[] cm = new Integer[uvc];
                        GTKUtil.LineAttributes la = null;
                        for (int ii7 = 0; ii7 < uvc; ++ii7) {
                            MarkerStyle ms;
                            lineStyle = null;
                            FillStyle fillStyle = null;
                            int symbol = -1;
                            String key = GTKUtil.VariableAccess.getFormattedUniqueValue((StringVariable)ordered_styleByVariable, ii7);
                            if (markerOn) {
                                ms = (MarkerStyle)formattedValue2MarkerStyle.get(key);
                                int n2 = symbol = ms != null && ms.isVisible() ? ms.getSymbol() : -1;
                            }
                            if (lineOn) {
                                ms = (MarkerStyle)formattedValue2MarkerStyle.get(key);
                                lineStyle = (StrokeLineStyle)formattedValue2LineStyle.get(key);
                                la = lineStyle != null && lineStyle.getVisibilityPolicy() != 10202 && ms != null && ms.getInterpolation() != 40000 ? GTKUtil.getLineAttributes(lineStyle) : null;
                            }
                            if (fillOn) {
                                fillStyle = (FillStyle)formattedValue2FillStyle.get(key);
                            }
                            CustomMarker cMarker = null;
                            if (la != null) {
                                cMarker = new CustomMarker(ch, symbol, fillStyle, barOutlineColor, la.stipplePattern, la.stippleFactor, lineStyle.getColor());
                                cMarker.setMarkerSkinFactory(this.createMarkerSkinFactory());
                                cm[ii7] = new Integer(ch.addCustomMarker((CustomMarkerInterface)cMarker));
                            } else {
                                cMarker = new CustomMarker(ch, symbol, fillStyle, barOutlineColor);
                                cMarker.setMarkerSkinFactory(this.createMarkerSkinFactory());
                                cm[ii7] = new Integer(ch.addCustomMarker((CustomMarkerInterface)cMarker));
                            }
                            cMarker.setAntialiasingOn(antialiasedGraphics);
                        }
                        this.styleByLegend.setMarkerMapper(GTKUtil.MapperFactory.newFormattedValueStringToNumberMapper(ordered_styleByVariable, cm));
                    }
                } else if (styleByVariable instanceof NumericVariable) {
                    if (dataSource.isCategorized(styleByVariable)) {
                        LegendCellModel lcm = null;
                        RangeInfo[] rangeInfos = dataSource.categorize(styleByVariable);
                        SegmentedRangeStyle altSegmentedRangeStyle = new SegmentedRangeStyle();
                        altSegmentedRangeStyle.setDataElementStyles(dataElementStyles);
                        altSegmentedRangeStyle.setPaletteType(12102);
                        SegmentedRangeStyle segmentedRangeStyle = dataSource.getSegmentedRangeStyle(styleByVariable);
                        CategorizationInfo categorizationInfo = new CategorizationInfo(dataSource.getCategorizationModel(styleByVariable), segmentedRangeStyle, altSegmentedRangeStyle, rangeInfos);
                        if (categorizationInfo != null && rangeInfos != null) {
                            DiscreteRangeToColorMapper mapper;
                            Util.collate(categorizationInfo);
                            DiscreteRangeToColorMapper discreteColorMapper = mapper = GTKUtil.MapperFactory.newNonContinuousColorMapper(categorizationInfo);
                            discreteColorMapper.input.connectFrom(((NumericVariable)styleByVariable).value);
                            this.barLineChartCellModel.setFormattedValueToDiscreteColor(discreteColorMapper);
                            lcm = new LegendCellModel(this.createMarkerSkinFactory());
                            lcm.setLegendModel(matrixModel.getBarLineChartModel().getLegendModel());
                            lcm.setAntialiasedGraphics(antialiasedGraphics);
                            lcm.setAntialiasedText(antialiasedText);
                            lcm.setDefaultLabel(styleByVariable.getLabel());
                            lcm.setTitleMarker(this.drillMarker);
                            lcm.setColorMapper((ColorMapper)discreteColorMapper);
                        }
                        if (lcm != null) {
                            int placement = matrixModel.getBarLineChartModel().getLegendModel().getPlacement();
                            if (placement == 10200) {
                                placement = 5;
                            }
                            lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
                            lcm.setPlacement(new Integer(placement));
                            this.styleByLegend = new LegendCell(lcm, channel);
                            this.addLegend(this.styleByLegend, placement);
                        }
                    } else {
                        double legendBaseline;
                        LegendModel legendModel = matrixModel.getBarLineChartModel().getLegendModel();
                        double modelMin = legendModel.getMinimum();
                        double modelMax = legendModel.getMaximum();
                        if (this.isDefined(modelMax) && this.isDefined(modelMin) && modelMin > modelMax) {
                            double swap = modelMin;
                            modelMin = modelMax;
                            modelMax = swap;
                        }
                        double modelBaseline = legendModel.getBaseline();
                        double dataMin = ((NumericVariable)styleByVariable).getMin();
                        double dataMax = ((NumericVariable)styleByVariable).getMax();
                        double legendMin = modelMin;
                        double legendMax = modelMax;
                        if (matrixModel.getBarLineChartModel().getLegendModel().isSymmetricEnabled()) {
                            legendMin = dataMin;
                            legendMax = dataMax;
                        }
                        if (Double.isNaN(legendMax)) {
                            legendMax = dataMax;
                            if (this.isDefined(modelBaseline)) {
                                legendMax = Math.max(legendMax, modelBaseline);
                            }
                            if (this.isDefined(modelMin)) {
                                legendMax = Math.max(legendMax, modelMin);
                            }
                        }
                        if (Double.isNaN(legendMin)) {
                            legendMin = dataMin;
                            if (this.isDefined(modelBaseline)) {
                                legendMin = Math.min(legendMin, modelBaseline);
                            }
                            if (this.isDefined(modelMax)) {
                                legendMin = Math.min(legendMin, modelMax);
                            }
                        }
                        double d = legendBaseline = Double.isNaN(modelBaseline) ? (legendMax - legendMin) / 2.0 + legendMin : modelBaseline;
                        if (this.isDefined(modelBaseline) && legendModel.isSymmetricEnabled() && (!this.isDefined(modelMax) || !this.isDefined(modelMin))) {
                            if (this.isDefined(modelMax)) {
                                if (legendMax - legendBaseline > legendBaseline - legendMin) {
                                    legendMin = legendBaseline - (legendMax - legendBaseline);
                                }
                            } else if (legendBaseline - legendMin > legendMax - legendBaseline) {
                                legendMax = legendBaseline + (legendBaseline - legendMin);
                            }
                        }
                        if (matrixModel.getBarLineChartModel().getLegendModel().isSymmetricEnabled()) {
                            double v1 = legendMax - legendBaseline;
                            double v2 = legendBaseline - legendMin;
                            if (v1 > v2) {
                                legendMin = legendBaseline - v1;
                            } else if (v2 > v1) {
                                legendMax = legendBaseline + v2;
                            }
                        }
                        this.barLineChartCellModel.setResultingLegendBaseline(new Double(legendBaseline));
                        Double normalizedMin = new Double(0.0);
                        Double normalizedBaseline = new Double(legendMax - legendMin == 0.0 ? 0.0 : (legendBaseline - legendMin) / (legendMax - legendMin));
                        Double normalizedMax = new Double(1.0);
                        double[] rangeValues = null;
                        Double[] normalizedRangeValues = null;
                        Color[] colorScheme = null;
                        Color outOfRangeLowColor = null;
                        Color outOfRangeHighColor = null;
                        NumericRangeSegment[] rangeSegments = null;
                        Color outOfRangeColor = null;
                        switch (matrixModel.getBarLineChartModel().getColorPaletteType()) {
                            default: {
                                double rangeMin = legendMin;
                                double rangeMax = legendMax;
                                if (!(Double.isNaN(modelMin) ^ Double.isNaN(modelMax)) || !legendModel.isSymmetricEnabled()) {
                                    if (Double.isNaN(modelMin)) {
                                        rangeMin = Double.NEGATIVE_INFINITY;
                                    }
                                    if (Double.isNaN(modelMax)) {
                                        rangeMax = Double.POSITIVE_INFINITY;
                                    }
                                }
                                if (rangeMin == rangeMax) {
                                    NumericRangeSegment range = new NumericRangeSegment(rangeMin, rangeMin, false, false, (Object)dataElementStyles.getContinuousFillTwoColorStartColor());
                                    rangeSegments = new NumericRangeSegment[]{range};
                                } else {
                                    boolean baseline = true;
                                    if (legendMin >= legendBaseline) {
                                        legendBaseline = legendMin;
                                        baseline = false;
                                    }
                                    if (legendMax <= legendBaseline) {
                                        legendBaseline = legendMax;
                                        baseline = false;
                                    }
                                    NumericRangeSegment negativeRange = null;
                                    NumericRangeSegment positiveRange = null;
                                    if (baseline) {
                                        negativeRange = new NumericRangeSegment(rangeMin, legendBaseline, false, true, (Object)dataElementStyles.getContinuousFillTwoColorStartColor());
                                        positiveRange = new NumericRangeSegment(legendBaseline, rangeMax, false, false, (Object)dataElementStyles.getContinuousFillTwoColorEndColor());
                                    } else {
                                        negativeRange = new NumericRangeSegment(rangeMin, legendBaseline, false, false, (Object)dataElementStyles.getContinuousFillTwoColorStartColor());
                                        positiveRange = new NumericRangeSegment(legendBaseline, rangeMax, true, false, (Object)dataElementStyles.getContinuousFillTwoColorEndColor());
                                    }
                                    rangeSegments = new NumericRangeSegment[]{negativeRange, positiveRange};
                                }
                                outOfRangeColor = dataElementStyles.getOutOfRangeFillStyle().getSolidFillColor();
                                break;
                            }
                            case 11801: {
                                rangeValues = new double[]{legendMin, legendMax};
                                normalizedRangeValues = new Double[]{normalizedMin, normalizedMax};
                                colorScheme = new Color[]{dataElementStyles.getContinuousFillTwoColorStartColor(), dataElementStyles.getContinuousFillTwoColorEndColor()};
                                outOfRangeLowColor = dataElementStyles.getContinuousFillTwoColorStartColor();
                                outOfRangeHighColor = dataElementStyles.getContinuousFillTwoColorEndColor();
                                break;
                            }
                            case 11802: 
                            case 11804: {
                                double rangeMin = legendMin;
                                double rangeMax = legendMax;
                                if (!(Double.isNaN(modelMin) ^ Double.isNaN(modelMax)) || !legendModel.isSymmetricEnabled()) {
                                    if (Double.isNaN(modelMin)) {
                                        rangeMin = Double.NEGATIVE_INFINITY;
                                    }
                                    if (Double.isNaN(modelMax)) {
                                        rangeMax = Double.POSITIVE_INFINITY;
                                    }
                                }
                                if (rangeMin == rangeMax) {
                                    NumericRangeSegment range = new NumericRangeSegment(rangeMin, rangeMin, false, false, (Object)dataElementStyles.getContinuousFillThreeColorStartColor());
                                    rangeSegments = new NumericRangeSegment[]{range};
                                } else {
                                    boolean baseline = true;
                                    if (legendMin >= legendBaseline) {
                                        legendBaseline = legendMin;
                                        baseline = false;
                                    }
                                    if (legendMax <= legendBaseline) {
                                        legendBaseline = legendMax;
                                        baseline = false;
                                    }
                                    NumericRangeSegment negativeRange = null;
                                    NumericRangeSegment positiveRange = null;
                                    if (baseline) {
                                        NumericRangeSegment baselineRange = null;
                                        negativeRange = new NumericRangeSegment(rangeMin, legendBaseline, false, true, (Object)dataElementStyles.getContinuousFillThreeColorStartColor());
                                        positiveRange = new NumericRangeSegment(legendBaseline, rangeMax, true, false, (Object)dataElementStyles.getContinuousFillThreeColorEndColor());
                                        baselineRange = new NumericRangeSegment(legendBaseline, legendBaseline, false, false, (Object)dataElementStyles.getContinuousFillThreeColorNeutralColor());
                                        rangeSegments = new NumericRangeSegment[]{negativeRange, baselineRange, positiveRange};
                                    } else {
                                        negativeRange = new NumericRangeSegment(rangeMin, legendBaseline, false, false, (Object)dataElementStyles.getContinuousFillThreeColorStartColor());
                                        positiveRange = new NumericRangeSegment(legendBaseline, rangeMax, true, false, (Object)dataElementStyles.getContinuousFillThreeColorEndColor());
                                        rangeSegments = new NumericRangeSegment[]{negativeRange, positiveRange};
                                    }
                                }
                                outOfRangeColor = dataElementStyles.getOutOfRangeFillStyle().getSolidFillColor();
                                break;
                            }
                            case 11803: 
                            case 11805: {
                                if (!legendModel.isSymmetricEnabled() && legendMin > Double.MIN_VALUE) {
                                    if (legendBaseline > legendMin && legendBaseline < legendMax) {
                                        rangeValues = new double[]{legendMin, legendBaseline, legendMax};
                                        normalizedRangeValues = new Double[]{normalizedMin, normalizedBaseline, normalizedMax};
                                        colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorStartColor(), dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
                                        outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                        outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                        break;
                                    }
                                    if (legendBaseline >= legendMax) {
                                        rangeValues = new double[]{legendMin, legendMax};
                                        normalizedRangeValues = new Double[]{normalizedMin, normalizedMax};
                                        colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorStartColor(), dataElementStyles.getContinuousFillThreeColorNeutralColor()};
                                        outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                        outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                        break;
                                    }
                                    rangeValues = new double[]{legendBaseline, legendMax};
                                    normalizedRangeValues = new Double[]{normalizedBaseline, normalizedMax};
                                    colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
                                    outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                    outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                    break;
                                }
                                if (!legendModel.isSymmetricEnabled() && legendMin < Double.MIN_VALUE) {
                                    if (legendBaseline > legendMin && legendBaseline < legendMax) {
                                        rangeValues = new double[]{legendMin, legendBaseline, legendMax};
                                        normalizedRangeValues = new Double[]{normalizedMin, normalizedBaseline, normalizedMax};
                                        colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorStartColor(), dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
                                        outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                        outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                        break;
                                    }
                                    if (legendMin <= legendMax) {
                                        rangeValues = new double[]{legendMin, legendMax};
                                        normalizedRangeValues = new Double[]{normalizedMin, normalizedMax};
                                        colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
                                        outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                        outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                        break;
                                    }
                                    rangeValues = new double[]{legendBaseline, legendMax};
                                    normalizedRangeValues = new Double[]{normalizedBaseline, normalizedMax};
                                    colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
                                    outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                    outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                    break;
                                }
                                rangeValues = new double[]{legendMin, legendBaseline, legendMax};
                                normalizedRangeValues = new Double[]{normalizedMin, normalizedBaseline, normalizedMax};
                                colorScheme = new Color[]{dataElementStyles.getContinuousFillThreeColorStartColor(), dataElementStyles.getContinuousFillThreeColorNeutralColor(), dataElementStyles.getContinuousFillThreeColorEndColor()};
                                outOfRangeLowColor = dataElementStyles.getContinuousFillThreeColorStartColor();
                                outOfRangeHighColor = dataElementStyles.getContinuousFillThreeColorEndColor();
                                break;
                            }
                            case 11806: {
                                ColorPosition[] colorSpectrum = dataElementStyles.getContinuousColorSpectrum();
                                rangeValues = new double[colorSpectrum.length];
                                normalizedRangeValues = new Double[colorSpectrum.length];
                                colorScheme = new Color[colorSpectrum.length];
                                double range = legendMax - legendMin;
                                for (int ii8 = 0; ii8 < colorSpectrum.length; ++ii8) {
                                    rangeValues[ii8] = range * colorSpectrum[ii8].getPosition() + legendMin;
                                    normalizedRangeValues[ii8] = new Double(colorSpectrum[ii8].getPosition());
                                    colorScheme[ii8] = colorSpectrum[ii8].getColor();
                                }
                                outOfRangeLowColor = dataElementStyles.getContinuousFillTwoColorStartColor();
                                outOfRangeHighColor = dataElementStyles.getContinuousFillTwoColorEndColor();
                            }
                        }
                        LegendCellModel lcm = null;
                        if (rangeSegments != null) {
                            DiscreteRangeToColorMapper discreteColorMapper = new DiscreteRangeToColorMapper();
                            discreteColorMapper.input.connectFrom(((NumericVariable)styleByVariable).value);
                            discreteColorMapper.setReplaceMissingValues(false);
                            discreteColorMapper.setRangeSegments(rangeSegments);
                            discreteColorMapper.setOutOfRangeColor(outOfRangeColor);
                            this.barLineChartCellModel.setFormattedValueToDiscreteColor(discreteColorMapper);
                            lcm = new LegendCellModel(this.createMarkerSkinFactory());
                            lcm.setLegendModel(matrixModel.getBarLineChartModel().getLegendModel());
                            lcm.setAntialiasedGraphics(antialiasedGraphics);
                            lcm.setAntialiasedText(antialiasedText);
                            lcm.setDefaultLabel(styleByVariable.getLabel());
                            lcm.setTitleMarker(this.drillMarker);
                            lcm.setColorMapper((ColorMapper)discreteColorMapper);
                        } else {
                            ContinuousRangeToColorMapper continuousColorMapper = new ContinuousRangeToColorMapper();
                            continuousColorMapper.input.connectFrom(((NumericVariable)styleByVariable).value);
                            continuousColorMapper.setColorSpectrumValues(rangeValues);
                            continuousColorMapper.setColorSpectrumColors(colorScheme);
                            continuousColorMapper.setOutOfRangeHighColor(outOfRangeHighColor);
                            continuousColorMapper.setOutOfRangeLowColor(outOfRangeLowColor);
                            this.barLineChartCellModel.setValueToContinuousColor(continuousColorMapper);
                            lcm = new ColorRampLegendCellModel();
                            lcm.setLegendModel(matrixModel.getBarLineChartModel().getLegendModel());
                            lcm.setAntialiasedGraphics(antialiasedGraphics);
                            lcm.setAntialiasedText(antialiasedText);
                            lcm.setMarkerOutlineLineStyle(matrixModel.getGraphModel().getDataElementStyles().getOutlineLineStyle());
                            lcm.setDefaultLabel(styleByVariable.getLabel());
                            lcm.setTitleMarker(this.drillMarker);
                            ((ColorRampLegendCellModel)lcm).setLowValue(new Double(legendMin));
                            ((ColorRampLegendCellModel)lcm).setHighValue(new Double(legendMax));
                            ((ColorRampLegendCellModel)lcm).setColors(colorScheme);
                            ((ColorRampLegendCellModel)lcm).setColorValues(normalizedRangeValues);
                            ((ColorRampLegendCellModel)lcm).setValueFormat(styleByVariable.getFormat());
                        }
                        int placement = matrixModel.getBarLineChartModel().getLegendModel().getPlacement();
                        if (placement == 10200) {
                            placement = 5;
                        }
                        lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
                        lcm.setPlacement(new Integer(placement));
                        this.styleByLegend = new LegendCell(lcm, channel);
                        this.addLegend(this.styleByLegend, placement);
                    }
                }
            } else if (totalVariableCount > 1) {
                int ii9;
                boolean markerOn = lineResponseCount2 + line2ResponseCount2 > 0 && barLineChartModel.isMarkerEnabled();
                boolean lineOn = lineResponseCount2 + line2ResponseCount2 > 0 && barLineChartModel.isInterpolationEnabled();
                boolean areaFillOn = lineResponseCount2 + line2ResponseCount2 > 0 && barLineChartModel.isFillAreaEnabled();
                boolean barFillOn = barResponseCount + bar2ResponseCount > 0;
                boolean fillOn = barFillOn || areaFillOn;
                FillStyle[] variableFillStyles = fillOn ? new FillStyle[totalVariableCount] : null;
                StrokeLineStyle[] variableLineStyles = lineOn ? new StrokeLineStyle[totalVariableCount] : null;
                int[] interpolation = lineOn ? new int[totalVariableCount] : null;
                MarkerStyle[] variableMarkerStyles = markerOn || lineOn ? new MarkerStyle[totalVariableCount] : null;
                String[] variableNames = new String[totalVariableCount];
                String[] variableLabels = new String[totalVariableCount];
                for (int ii10 = 0; ii10 < barResponseCount; ++ii10) {
                    if (barVariableArray[ii10] == null) continue;
                    variableNames[ii10] = barVariableArray[ii10].getName();
                    variableLabels[ii10] = barVariableArray[ii10].getLabel();
                    variableFillStyles[ii10] = Util.newCycledFillStyle(fillStyles, cycleColors, ii10);
                }
                int lastIndex = barResponseCount;
                for (ii9 = 0; ii9 < bar2ResponseCount; ++ii9) {
                    if (bar2VariableArray[ii9] == null) continue;
                    variableNames[ii9 + lastIndex] = bar2VariableArray[ii9].getName();
                    variableLabels[ii9 + lastIndex] = bar2VariableArray[ii9].getLabel();
                    variableFillStyles[ii9 + lastIndex] = Util.newCycledFillStyle(fillStyles, cycleColors, ii9 + lastIndex);
                }
                lastIndex += bar2ResponseCount;
                for (ii9 = 0; ii9 < lineResponseCount2; ++ii9) {
                    if (lineVariableArray[ii9] == null) continue;
                    variableNames[ii9 + lastIndex] = lineVariableArray[ii9].getName();
                    variableLabels[ii9 + lastIndex] = lineVariableArray[ii9].getLabel();
                    if (areaFillOn) {
                        variableFillStyles[ii9 + lastIndex] = Util.newCycledFillStyle(fillStyles, cycleColors, ii9 + lastIndex);
                    }
                    if (lineOn) {
                        variableLineStyles[ii9 + lastIndex] = Util.newCycledLineStyle(lineStyles, cycleColors, ii9 + lastIndex);
                        interpolation[ii9 + lastIndex] = Util.newCycledMarkerStyle(markerStyles, cycleColors, ii9 + lastIndex).getInterpolation();
                    }
                    if (!markerOn) continue;
                    variableMarkerStyles[ii9 + lastIndex] = Util.newCycledMarkerStyle(markerStyles, cycleColors, ii9 + lastIndex);
                }
                lastIndex += lineResponseCount2;
                for (ii9 = 0; ii9 < line2ResponseCount2; ++ii9) {
                    if (line2VariableArray[ii9] == null) continue;
                    variableNames[ii9 + lastIndex] = line2VariableArray[ii9].getName();
                    variableLabels[ii9 + lastIndex] = line2VariableArray[ii9].getLabel();
                    if (areaFillOn) {
                        variableFillStyles[ii9 + lastIndex] = Util.newCycledFillStyle(fillStyles, cycleColors, ii9 + lastIndex);
                    }
                    if (lineOn) {
                        variableLineStyles[ii9 + lastIndex] = Util.newCycledLineStyle(lineStyles, cycleColors, ii9 + lastIndex);
                        interpolation[ii9 + lastIndex] = Util.newCycledMarkerStyle(markerStyles, cycleColors, ii9 + lastIndex).getInterpolation();
                    }
                    if (!markerOn) continue;
                    variableMarkerStyles[ii9 + lastIndex] = Util.newCycledMarkerStyle(markerStyles, cycleColors, ii9 + lastIndex);
                }
                LegendCellModel lcm = new LegendCellModel(this.createMarkerSkinFactory());
                lcm.setLegendModel(matrixModel.getBarLineChartModel().getLegendModel());
                lcm.setAntialiasedGraphics(antialiasedGraphics);
                lcm.setAntialiasedText(antialiasedText);
                lcm.setMarkerOutlineLineStyle(markerOn ? markerOutline : dataElementStyles.getOutlineLineStyle());
                lcm.setTitleMarker(this.drillMarker);
                int placement = matrixModel.getBarLineChartModel().getLegendModel().getPlacement();
                if (placement == 10200) {
                    placement = 5;
                }
                lcm.setOrientation(new Integer(placement == 7 || placement == 3 ? 1 : 0));
                lcm.setPlacement(new Integer(placement));
                int numLegendEntries = variableNames.length;
                String[] legValue = matrixModel.getBarLineChartModel().getLegendModel().getCategories();
                if (legValue != null) {
                    numLegendEntries = legValue.length;
                }
                StringVector varNameVector = new StringVector(numLegendEntries);
                ColorVector colorVector = new ColorVector(numLegendEntries);
                IntegerVector markerVector = new IntegerVector(numLegendEntries);
                IntegerVector cmVector = new IntegerVector(numLegendEntries);
                for (int ii11 = 0; ii11 < variableNames.length; ++ii11) {
                    int idx = -1;
                    if (legValue != null) {
                        if ((idx = this.findIndex(variableNames, legValue, ii11, idx)) == -1) {
                            continue;
                        }
                    } else {
                        idx = ii11;
                    }
                    varNameVector.addValue(variableLabels[idx]);
                    if (fillOn && !lineOn && !markerOn) {
                        FillStyle fs = variableFillStyles[idx];
                        colorVector.addValue(fs != null && fs.isVisible() ? fs.getSolidFillColor() : INVISIBLE_COLOR);
                        continue;
                    }
                    MarkerStyle ms = variableMarkerStyles[idx];
                    colorVector.addValue(ms != null && ms.isVisible() ? ms.getColor() : INVISIBLE_COLOR);
                    if (!markerOn || fillOn || lineOn) continue;
                    markerVector.addValue(ms != null && ms.isVisible() ? ms.getSymbol() : -1);
                }
                lcm.setStringVector(varNameVector);
                lcm.setColorVector(colorVector);
                if (!markerVector.isEmpty()) {
                    lcm.setMarkerVector(markerVector);
                }
                this.multiResponseLegend = new LegendCell(lcm, channel);
                this.addLegend(this.multiResponseLegend, placement);
                Channel ch = this.multiResponseLegend.getJLegendChannel();
                for (int ii12 = 0; ii12 < variableNames.length; ++ii12) {
                    FillStyle fs;
                    MarkerStyle ms;
                    int idx = -1;
                    if (legValue != null) {
                        if ((idx = this.findIndex(variableNames, legValue, ii12, idx)) == -1) {
                            continue;
                        }
                    } else {
                        idx = ii12;
                    }
                    if (!lineOn && (fillOn ? 1 : 0) + (markerOn ? 1 : 0) <= 1 && (!fillOn || !BarLineChartMatrix.isCustomFillStyle(variableFillStyles))) continue;
                    GTKUtil.LineAttributes la = null;
                    StrokeLineStyle lineStyle = null;
                    FillStyle fillStyle = null;
                    int symbol = -1;
                    if (markerOn && (ms = variableMarkerStyles[idx]) != null && ms.isVisible()) {
                        symbol = ms.getSymbol();
                    }
                    if (lineOn && (lineStyle = variableLineStyles[idx]) != null && lineStyle.getVisibilityPolicy() != 10202 && interpolation[idx] != 40000) {
                        la = GTKUtil.getLineAttributes(lineStyle);
                    }
                    if (fillOn && (fs = variableFillStyles[idx]) != null && fs.isVisible()) {
                        fillStyle = variableFillStyles[idx];
                    }
                    CustomMarker cMarker = null;
                    if (la != null) {
                        cMarker = new CustomMarker(ch, symbol, fillStyle, barOutlineColor, la.stipplePattern, la.stippleFactor, lineStyle.getColor());
                        cMarker.setMarkerSkinFactory(this.createMarkerSkinFactory());
                        cmVector.addValue(new Integer(ch.addCustomMarker((CustomMarkerInterface)cMarker)).intValue());
                    } else {
                        cMarker = new CustomMarker(ch, symbol, fillStyle, barOutlineColor);
                        cMarker.setMarkerSkinFactory(this.createMarkerSkinFactory());
                        cmVector.addValue(new Integer(ch.addCustomMarker((CustomMarkerInterface)cMarker)).intValue());
                    }
                    cMarker.setAntialiasingOn(antialiasedGraphics);
                }
                if (!cmVector.isEmpty()) {
                    this.multiResponseLegend.setMarkerVector(cmVector);
                }
            }
        }
    }

    private int findIndex(String[] variableNames, String[] legValue, int ii, int idx) {
        for (int nn = 0; nn < legValue.length; ++nn) {
            if (!legValue[nn].equals(variableNames[ii])) continue;
            idx = ii;
            break;
        }
        return idx;
    }

    private boolean isDefined(double value) {
        return !Double.isNaN(value);
    }

    private static boolean _hasCumulativeStatistic(VariableDefinition varDef) {
        if (varDef != null) {
            while (varDef != null) {
                Integer statistic;
                if (varDef instanceof AnalysisVariableDefinition && (statistic = ((AnalysisVariableDefinition)varDef).getStatistic()) != null) {
                    switch (statistic) {
                        case 10504: 
                        case 10505: 
                        case 10508: 
                        case 10509: {
                            return true;
                        }
                    }
                }
                varDef = varDef.getNext();
            }
        }
        return false;
    }

    private static StringToNumericMapper _newUniformCategoryAxisMapper(DataSource _dataSource, DefaultMutableTreeNode ordinal, BarLineChartMatrixModel _matrixModel) {
        String whereClause;
        String string = whereClause = ordinal instanceof DataTreeGroupNode ? DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)ordinal), null) : null;
        if (whereClause != null) {
            _dataSource = _dataSource.newDataSourceWhere(whereClause);
        }
        StringVariable sortedCategoryVariable = null;
        StringVariable categoryVariable = (StringVariable)_dataSource.getVariable(_matrixModel.getCategoryRole(), 0);
        NumericVariable baseCategoryVariable = _dataSource.getBaseVariable(categoryVariable);
        sortedCategoryVariable = baseCategoryVariable != null ? GTKUtil.newStringVariableFromFormattedUniqueValues(baseCategoryVariable) : categoryVariable;
        StringToNumericMapper uniformCategoryAxisMapper = new StringToNumericMapper();
        uniformCategoryAxisMapper.input.connectFrom(sortedCategoryVariable.formattedValue);
        return uniformCategoryAxisMapper;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.barLineChartCellModel != null) {
            this.barLineChartCellModel.setChartAreaWidth(new Integer(w));
            this.barLineChartCellModel.setChartAreaHeight(new Integer(h));
        }
        super.setBounds(x, y, w, h);
    }

    public ChartImageMapInfo2[] getImageMapInfo() {
        int cellCount;
        ChartImageMapInfo2[] barChartImageMapInfos = null;
        if (this.dataSource != null && this.dataSource.getValueCount() > 0 && this.model != null && this.cells != null && (cellCount = this.cells.size()) > 0) {
            ArrayList l = new ArrayList();
            this.addVariableListImageMapInfo(l);
            Util.addCellImageMapInfo(this.cells, l);
            this.addResponseAxesImageMapInfo(l);
            this.addLegendImageMapInfo(l);
            this.addMatrixAxesImageMapInfo(l);
            barChartImageMapInfos = ChartImageMapInfo2.listToArray(l);
        }
        return barChartImageMapInfos;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixContainer != null) {
            return this.matrixContainer.getBrushableComponent();
        }
        return this;
    }

    private void addMatrixAxesImageMapInfo(List imageMapInfoList) {
        if (this.matrixContainer != null) {
            imageMapInfoList.add(this.matrixContainer.getImageMapInfo());
        }
    }

    private void addVariableListImageMapInfo(List imageMapInfoList) {
        VariableList columnVariableList = Util.newVariablelist(this.dataSource, this.model.getColumnRole());
        VariableList rowVariableList = Util.newVariablelist(this.dataSource, this.model.getRowRole());
        VariableList categoryVariableList = Util.newVariablelist(this.dataSource, this.model.getCategoryRole());
        VariableList subgroupVariableList = Util.newVariablelist(this.dataSource, this.model.getSubgroupRole());
        VariableList responseVariableList = Util.newVariablelist(this.dataSource, new Object[]{this.model.getBarRole(), this.model.getLineRole()});
        VariableList response2VariableList = Util.newVariablelist(this.dataSource, new Object[]{this.model.getBar2Role(), this.model.getLine2Role()});
        VariableList dataTipVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getDataTipRole());
        VariableList auxiliaryVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getAuxiliaryRole());
        if (this.dataSource.isOLAPData()) {
            columnVariableList = Util.newVariablelist(this.dataSource, new Object[]{this.model.getCategoryRole(), this.model.getColumnRole()});
            categoryVariableList = null;
        }
        imageMapInfoList.add(new ChartImageMapInfo2(columnVariableList, rowVariableList, categoryVariableList, subgroupVariableList, responseVariableList, response2VariableList, dataTipVariableList, auxiliaryVariableList));
    }

    private void addResponseAxesImageMapInfo(List imageMapInfoList) {
        ChartImageMapInfo2 tempInfo = null;
        int axisSize = this.axisCells == null ? 0 : this.axisCells.size();
        int axis2Size = this.axis2Cells == null ? 0 : this.axis2Cells.size();
        for (int jj = 0; jj < 2; ++jj) {
            int as = 0;
            ArrayList ac = null;
            LabelZoneList[] responseList = new LabelZoneList[2];
            if (jj == 0) {
                if (axisSize == 0) continue;
                as = axisSize;
                ac = this.axisCells;
                responseList[1] = null;
            } else {
                if (axis2Size == 0) continue;
                as = axis2Size;
                ac = this.axis2Cells;
                responseList[0] = null;
            }
            for (int ii = 0; ii < as; ++ii) {
                AxisCell cell = (AxisCell)ac.get(ii);
                if (cell == null) continue;
                responseList[jj] = cell.getLabelAndValueZones().getLabelZone();
                tempInfo = new ChartImageMapInfo2(null, null, null, null, responseList[0], responseList[1]);
                tempInfo.source = cell;
                imageMapInfoList.add(tempInfo);
            }
        }
    }

    private void addLegendImageMapInfo(List imageMapInfoList) {
        Util.LabelAndValueZones labelAndValueZones;
        ValueZone[] legendValueZones;
        if (this.styleByLegend != null) {
            if (this.styleByLegend instanceof HierarchicalLegendCell) {
                imageMapInfoList.add(((HierarchicalLegendCell)this.styleByLegend).getImageMapInfo());
            } else {
                Util.LabelAndValueZones valueAndLabelZones = this.styleByLegend.getLabelAndValueZones();
                ValueZone[] legendValueZones2 = valueAndLabelZones.getValueZones();
                if (legendValueZones2 != null) {
                    ChartValueZone[] subgroupValueZones = new ChartValueZone[legendValueZones2.length];
                    for (int kk = 0; kk < legendValueZones2.length; ++kk) {
                        subgroupValueZones[kk] = new ChartValueZone(legendValueZones2[kk].getShape(), null, null, null, legendValueZones2[kk].getValue());
                    }
                    ChartImageMapInfo2 tempInfo = new ChartImageMapInfo2(null, null, null, subgroupValueZones, null, null, null, null, valueAndLabelZones.getLabelZone(), null, null);
                    tempInfo.source = this.styleByLegend;
                    imageMapInfoList.add(tempInfo);
                }
            }
        } else if (this.multiResponseLegend != null && (legendValueZones = (labelAndValueZones = this.multiResponseLegend.getLabelAndValueZones()).getValueZones()) != null) {
            Variable[] line2VariableArray;
            int line2ResponseCount;
            Variable[] bar2VariableArray;
            int bar2ResponseCount;
            Variable[] lineVariableArray;
            int lineResponseCount;
            LabelZoneList responseLabelZoneList = null;
            LabelZoneList response2LabelZoneList = null;
            BarLineChartMatrixModel matrixModel = this.getModel();
            Variable[] barVariableArray = this.dataSource.getVariable(matrixModel.getBarRole());
            int barResponseCount = barVariableArray != null ? barVariableArray.length : 0;
            int totalVariableCount = barResponseCount + (lineResponseCount = (lineVariableArray = this.dataSource.getVariable(matrixModel.getLineRole())) != null ? lineVariableArray.length : 0) + (bar2ResponseCount = (bar2VariableArray = this.dataSource.getVariable(matrixModel.getBar2Role())) != null ? bar2VariableArray.length : 0) + (line2ResponseCount = (line2VariableArray = this.dataSource.getVariable(matrixModel.getLine2Role())) != null ? line2VariableArray.length : 0);
            if (legendValueZones.length == totalVariableCount) {
                int ii;
                Shape shape = null;
                String variableLabel = null;
                String variableName = null;
                int lastIndex = 0;
                for (ii = 0; ii < barResponseCount; ++ii) {
                    if (barVariableArray[ii] == null) continue;
                    variableName = barVariableArray[ii].getColumnName();
                    variableLabel = barVariableArray[ii].getLabel();
                    shape = legendValueZones[lastIndex + ii].getShape();
                    responseLabelZoneList = new LabelZoneList(shape, variableName, variableLabel, responseLabelZoneList);
                }
                lastIndex += barResponseCount;
                for (ii = 0; ii < bar2ResponseCount; ++ii) {
                    if (bar2VariableArray[ii] == null) continue;
                    variableName = bar2VariableArray[ii].getColumnName();
                    variableLabel = bar2VariableArray[ii].getLabel();
                    shape = legendValueZones[lastIndex + ii].getShape();
                    response2LabelZoneList = new LabelZoneList(shape, variableName, variableLabel, response2LabelZoneList);
                }
                lastIndex += bar2ResponseCount;
                for (ii = 0; ii < lineResponseCount; ++ii) {
                    if (lineVariableArray[ii] == null) continue;
                    variableName = lineVariableArray[ii].getColumnName();
                    variableLabel = lineVariableArray[ii].getLabel();
                    shape = legendValueZones[lastIndex + ii].getShape();
                    responseLabelZoneList = new LabelZoneList(shape, variableName, variableLabel, responseLabelZoneList);
                }
                lastIndex += lineResponseCount;
                for (ii = 0; ii < line2ResponseCount; ++ii) {
                    if (line2VariableArray[ii] == null) continue;
                    variableName = line2VariableArray[ii].getColumnName();
                    variableLabel = line2VariableArray[ii].getLabel();
                    shape = legendValueZones[lastIndex + ii].getShape();
                    response2LabelZoneList = new LabelZoneList(shape, variableName, variableLabel, response2LabelZoneList);
                }
            }
            if (responseLabelZoneList != null || response2LabelZoneList != null) {
                ChartImageMapInfo2 tempInfo = new ChartImageMapInfo2(null, null, null, null, null, null, null, null, null, responseLabelZoneList, response2LabelZoneList);
                tempInfo.source = this.multiResponseLegend;
                imageMapInfoList.add(tempInfo);
            }
        }
    }

    protected ValueTree getSubgroupValueTree() {
        if (this.subgroupValueTree == null) {
            this.createSubgroupTree();
        }
        return this.subgroupValueTree;
    }

    private void createSubgroupTree() {
        ValueTree[] trees = ValueTree.createTrees(this.dataSource, ((BarLineChartMatrixModel)this.getMatrixModel()).getSubgroupRole(), null);
        this.subgroupValueTree = trees[0];
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.cells != null) {
            for (int ii = 0; ii < this.cells.size(); ++ii) {
                ((BarLineChartCell)this.cells.get(ii)).setAnimationFrame(animationPosition);
            }
        }
    }

    protected ArrayList addMatrixCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, ValueTree integratedAxis) {
        Container parent;
        if (this.matrixContainer != null) {
            this.matrixContainer.dispose();
            this.remove(this.matrixContainer);
            this.matrixContainer = null;
        }
        SwingActionProvider actionProvider = null;
        for (parent = this; parent != null && !(parent instanceof Graph); parent = parent.getParent()) {
        }
        if (parent instanceof Graph) {
            actionProvider = ((Graph)parent).getActionProvider();
        }
        BarLineChartMatrixModel barLineChartMatrixModel = (BarLineChartMatrixModel)this.getMatrixModel();
        this.matrixContainer = new BarLineChartMatrixContainer(barLineChartMatrixModel, dataSource[0], this.getColumnValueTree(), this.getRowValueTree(), integratedAxis, new BarLineChartCellComponentFactory(this.getChannel(), this.barLineChartCellModel, dataSource[0]), new AxisCell.AxisCellComponentFactory(this.barLineChartCellModel.getResponseAxisCellModel(), this.getChannel()), new AxisCell.AxisCellComponentFactory(this.barLineChartCellModel.getResponse2AxisCellModel(), this.getChannel()), this.getMessageModel(), ((BarLineChartMatrixModel)this.getMatrixModel()).getCategoryRole(), actionProvider, false, barLineChartMatrixModel.getGraphModel().isAntialiasedGraphics(), barLineChartMatrixModel.getGraphModel().isAntialiasedText(), this.getChannel());
        this.add((Component)this.matrixContainer, "Center");
        ArrayList<Component> cells = new ArrayList<Component>();
        Component[] components = this.matrixContainer.getMatrixCellComponents();
        for (int i = 0; i < components.length; ++i) {
            cells.add(components[i]);
        }
        return cells;
    }

    @Override
    protected ArrayList addRowTabletCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        ArrayList<JComponent> cellList = new ArrayList<JComponent>();
        if (this.matrixContainer != null) {
            DefaultMutableTreeNode[] rowOrdinals = this.getRowValueTree() != null ? this.getRowValueTree().getLeafNodes() : null;
            int rowCount = rowOrdinals == null ? 1 : rowOrdinals.length;
            for (int jj = 0; jj < rowCount; ++jj) {
                DefaultMutableTreeNode rowOrdinal = rowOrdinals == null ? null : rowOrdinals[jj];
                JComponent cell = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
                MatrixContainer.TabletCellIdentifier tabletCellIdentifier = new MatrixContainer.TabletCellIdentifier();
                tabletCellIdentifier.ordinal = rowOrdinal;
                cellList.add(cell);
            }
        } else if (this.matrixContainer != null) {
            JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
            this.matrixContainer.add((Component)cellComponent, (Object)(primary ? "West" : "East"));
            cellList.add(cellComponent);
        }
        return cellList;
    }

    @Override
    protected ArrayList addColumnTabletCellComponents(Matrix.CellFactoryInterface cellFactory, SimpleModelInterface cellModel, DataSource[] dataSource, boolean primary) {
        ArrayList<JComponent> cellList = new ArrayList<JComponent>();
        if (this.matrixContainer != null) {
            DefaultMutableTreeNode[] columnOrdinals = this.getColumnValueTree() != null ? this.getColumnValueTree().getLeafNodes() : null;
            int columnCount = columnOrdinals == null ? 1 : columnOrdinals.length;
            for (int jj = 0; jj < columnCount; ++jj) {
                DefaultMutableTreeNode columnOrdinal = columnOrdinals == null ? null : columnOrdinals[jj];
                JComponent cell = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
                MatrixContainer.TabletCellIdentifier tabletCellIdentifier = new MatrixContainer.TabletCellIdentifier();
                tabletCellIdentifier.ordinal = columnOrdinal;
                cellList.add(cell);
            }
        } else if (this.matrixContainer != null) {
            JComponent cellComponent = cellFactory.newCellComponent(cellModel, dataSource, this.getChannel());
            this.matrixContainer.add((Component)cellComponent, (Object)(primary ? "West" : "East"));
            cellList.add(cellComponent);
        }
        return cellList;
    }

    @Override
    public ScrollModelInterface getScrollModel() {
        return null;
    }

    @Override
    public void setAntialiasedTextEnabled(boolean b) {
    }

    @Override
    public void setMatrixCellOutlineLineStyle(LineStyle lineStyle) {
    }

    @Override
    public void setMatrixCellOutlineVisible(boolean b) {
    }

    @Override
    protected void resetTrees() {
        super.resetTrees();
        this.integratedValueTree = null;
        this.subgroupValueTree = null;
    }

    protected ValueTree getIntegratedValueTree(boolean isVerticalOrientation, boolean forceUniformCategories) {
        if (this.integratedValueTree == null) {
            ArrayList<Object> roles = new ArrayList<Object>();
            roles.add(isVerticalOrientation ? this.getMatrixModel().getColumnRole() : this.getMatrixModel().getRowRole());
            roles.add(this.getMatrixModel().getCategoryRole());
            this.integratedValueTree = ValueTree.createMultipleHierarchyTree(this.dataSource, roles);
            BarLineChartModel barLineChartModel = this.model.getBarLineChartModel();
            if (barLineChartModel.getCategoryAxisModel().isReverseDirection()) {
                this.integratedValueTree.reverse();
            }
        }
        return this.integratedValueTree;
    }

    @Override
    protected List getCells() {
        return this.cells;
    }

    private void _reset(DataLabelSize dls) {
        dls.longestLength = 0.0;
        dls.longestLabel = "";
    }

    private static void _findMaxFormattedValueSize(Channel channel, Font f, DataLabelSize dataLabelSize, StringVariable var, boolean calHeight) {
        channel.glSelect2DFont(f);
        String[] uniqueValueStrings = GTKUtil.PipeAccess.getValues_as_StringArray(var.formattedUniqueValue);
        for (int ii = 0; ii < uniqueValueStrings.length; ++ii) {
            String currentString = uniqueValueStrings[ii].trim();
            double currentLength = channel.glGetTextWidth(currentString);
            if (currentLength > dataLabelSize.longestLength) {
                dataLabelSize.longestLabel = currentString;
                dataLabelSize.longestLength = currentLength;
            }
            double currentHeight = channel.glGetTextHeight(currentString);
            if (!calHeight || !(currentHeight > dataLabelSize.tallestHeight)) continue;
            dataLabelSize.tallestLabel = currentString;
            dataLabelSize.tallestHeight = currentHeight;
        }
    }

    private static boolean _findMaxFormattedValueSize(Channel channel, Font font, DataLabelSize dataLabelSize, Variable[] array, boolean calHeight) {
        StringVariable dataLabelVariable = null;
        if (array != null) {
            for (int ii = 0; ii < array.length; ++ii) {
                Variable var = array[ii];
                if (var instanceof StringVariable) {
                    dataLabelVariable = (StringVariable)var;
                } else if (var instanceof NumericVariable) {
                    dataLabelVariable = new StringVariable();
                    dataLabelVariable.connectFrom((NumericVariable)var);
                }
                if (dataLabelVariable == null) continue;
                BarLineChartMatrix._findMaxFormattedValueSize(channel, font, dataLabelSize, dataLabelVariable, calHeight);
            }
        }
        return dataLabelVariable != null;
    }

    private static boolean _calcDataLabelSize(Channel channel, int dataLabelContent, Font font, DataLabelSize dataLabelSize, Variable[] resp1Array, Variable[] resp2Array, Variable[] labelArray, BarLineChartMatrixModel matrixModel, boolean calHeight, DataSource dataSource) {
        boolean dataLabelContentFound = false;
        if (dataLabelContent == 10603) {
            dataLabelContentFound |= BarLineChartMatrix._findMaxFormattedValueSize(channel, font, dataLabelSize, resp1Array, calHeight);
            dataLabelContentFound |= BarLineChartMatrix._findMaxFormattedValueSize(channel, font, dataLabelSize, resp2Array, calHeight);
        } else if (dataLabelContent == 10602) {
            dataLabelContentFound |= BarLineChartMatrix._findMaxFormattedValueSize(channel, font, dataLabelSize, new Variable[]{dataSource.getVariable(matrixModel.getCategoryRole(), 0)}, calHeight);
        } else if (dataLabelContent != 10601) {
            dataLabelContentFound |= BarLineChartMatrix._findMaxFormattedValueSize(channel, font, dataLabelSize, labelArray, calHeight);
        }
        return dataLabelContentFound;
    }

    private static Dimension _calcCategoryReferenceLineLabelSize(Dimension size, ReferenceLineModel[] rlma, TextStyle categoryAxisValueTextStyle, Channel channel) {
        if (size == null) {
            size = new Dimension(0, 0);
        }
        if (rlma != null) {
            for (int i = 0; i < rlma.length; ++i) {
                TextStyle textStyle = rlma[i].getTextStyle();
                if (textStyle == null) {
                    textStyle = categoryAxisValueTextStyle;
                }
                if (rlma[i] == null || rlma[i].getLabel() == null || !rlma[i].isVisible()) continue;
                int placement = rlma[i].getLabelPlacement();
                int justification = textStyle.getJustification();
                if (placement != 11301 && placement != 10200 || justification != 10200 && justification != 4) continue;
                channel.glSelect2DFont(textStyle.getFont());
                size.width = Math.max(size.width, (int)channel.glGetTextWidth(rlma[i].getLabel().toString()));
                size.height = Math.max(size.height, (int)channel.glGetTextHeight(rlma[i].getLabel().toString()));
            }
        }
        return size;
    }

    private Dimension _calcCategoryReferenceLabelSize(Channel channel) {
        AxisModel categoryAxisModel = this.getModel().getBarLineChartModel().getCategoryAxisModel();
        ReferenceLineModel[] rlma = categoryAxisModel.getReferenceLineModels();
        Dimension size = BarLineChartMatrix._calcCategoryReferenceLineLabelSize(null, rlma, categoryAxisModel.getValueTextStyle(), channel);
        ReferenceBandModel[] rbma = categoryAxisModel.getReferenceBandModels();
        if (rbma != null) {
            for (int i = 0; i < rbma.length; ++i) {
                TextStyle textStyle = rbma[i].getTextStyle();
                if (textStyle == null) {
                    textStyle = categoryAxisModel.getValueTextStyle();
                }
                if (rbma[i] != null && rbma[i].getLabel() != null && rbma[i].isVisible()) {
                    channel.glSelect2DFont(textStyle.getFont());
                    size.width = Math.max(size.width, (int)channel.glGetTextWidth(rbma[i].getLabel().toString()));
                    size.height = Math.max(size.height, (int)channel.glGetTextHeight(rbma[i].getLabel().toString()));
                }
                size = BarLineChartMatrix._calcCategoryReferenceLineLabelSize(size, Util.getReferenceLineModels(rbma), categoryAxisModel.getValueTextStyle(), channel);
            }
        }
        return size;
    }

    private static boolean isCustomFillStyle(Hashtable valueFillStyles) {
        if (valueFillStyles != null) {
            Enumeration fse = valueFillStyles.elements();
            while (fse.hasMoreElements()) {
                Object o = fse.nextElement();
                if (!(o instanceof FillStyle) || ((FillStyle)o).getFillType() == 20000) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCustomFillStyle(FillStyle[] variableFillStyles) {
        if (variableFillStyles != null) {
            for (int ii = 0; ii < variableFillStyles.length; ++ii) {
                if (variableFillStyles[ii].getFillType() == 20000) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isZoomedRowScrollBar() {
        boolean zoomed = false;
        if (this.matrixContainer != null) {
            zoomed = this.matrixContainer.getRowScrollModelProjection().isZoomed();
        }
        return zoomed;
    }

    public boolean isZoomedColumnScrollBar() {
        boolean zoomed = false;
        if (this.matrixContainer != null) {
            zoomed = this.matrixContainer.getColumnScrollModelProjection().isZoomed();
        }
        return zoomed;
    }

    public ZoomScrollBar getRowScrollBar() {
        ZoomScrollBar zsb = null;
        if (this.matrixContainer != null) {
            zsb = this.matrixContainer.getRowScrollBar();
        }
        return zsb;
    }

    public ZoomScrollBar getColumnScrollBar() {
        ZoomScrollBar zsb = null;
        if (this.matrixContainer != null) {
            zsb = this.matrixContainer.getColumnScrollBar();
        }
        return zsb;
    }

    private void _addLegend(LegendCellModel lcm, String[] values, FillStyle[] fillStyles, Color[] cyclecolors) {
        StringVector stringVector = this._makeStringVector(values);
        ColorVector colorVector = this._makeColorVector(fillStyles, cyclecolors);
        IntegerVector mkrVector = this._makeMarkerVector(null, null);
        lcm.setColorVector(colorVector);
        lcm.setStringVector(stringVector);
        lcm.setMarkerVector(mkrVector);
        LegendCell lc = new LegendCell(lcm, this.getChannel());
        this.addLegend(lc, lcm.getPlacement());
    }

    private StringVector _makeStringVector(String[] values) {
        StringVector stringVector = new StringVector(values.length);
        int ii = 0;
        for (ii = 0; ii < values.length; ++ii) {
            stringVector.insertValueAt(values[ii], ii);
        }
        this.numLegendEntries = ii;
        return stringVector;
    }

    private ColorVector _makeColorVector(FillStyle[] fillStyles, Color[] cycleColors) {
        Color color = null;
        ColorVector colorVector = new ColorVector(this.numLegendEntries);
        boolean isVisible = true;
        for (int ii = 0; ii < this.numLegendEntries; ++ii) {
            color = INVISIBLE_COLOR;
            if (fillStyles != null && ii < fillStyles.length && fillStyles[ii] != null) {
                color = fillStyles[ii].getSolidFillColor();
                isVisible = fillStyles[ii].isVisible();
                if (!isVisible) {
                    color = INVISIBLE_COLOR;
                }
            } else {
                color = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, ii);
            }
            colorVector.insertValueAt(color, ii);
        }
        return colorVector;
    }

    private IntegerVector _makeMarkerVector(MarkerStyle milestone, MarkerStyle target) {
        int ii = 0;
        IntegerVector intVector = new IntegerVector(this.numLegendEntries);
        int num = this.numLegendEntries;
        for (ii = 0; ii < num; ++ii) {
            int mkr = 19;
            intVector.insertValueAt(mkr, ii);
        }
        return intVector;
    }

    private AbstractMarkerSkinFactory createMarkerSkinFactory() {
        BarLineChartModel model = this.getModel().getBarLineChartModel();
        int skin = model.getSkin();
        if (skin == 12302 || skin == 12301) {
            boolean is3D = model.getDimension() == 10101;
            boolean isVertical = model.getOrientation() == 1;
            return BIPBarSkinFactory.getInstance(skin, is3D, isVertical);
        }
        return null;
    }

    private static class DataLabelSize {
        String longestLabel = "";
        String tallestLabel = "";
        double longestLength = 0.0;
        double tallestHeight = 0.0;

        private DataLabelSize() {
        }
    }

    private static class BarLineChartCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final Channel channel;
        private final DataSource dataSource;
        private final BarLineChartCellModel cellModel;
        private final Object animationKeyFrameRole;
        private final Object animationIDRole;

        public BarLineChartCellComponentFactory(Channel channel, BarLineChartCellModel cellModel, DataSource dataSource) {
            if (channel == null) {
                throw new IllegalStateException("null Channel not supported.");
            }
            this.channel = channel;
            if (cellModel == null) {
                throw new IllegalStateException("null BarLineChartCellModel not supported.");
            }
            this.cellModel = cellModel;
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            Variable[] animationKeyFrameVariables = dataSource.getVariable(cellModel.getAnimationKeyFrameRole());
            if (animationKeyFrameVariables == null) {
                this.animationKeyFrameRole = null;
                this.animationIDRole = null;
            } else {
                Variable subgroupVariable = dataSource.getVariable(cellModel.getSubgroupRole(), 0);
                this.animationKeyFrameRole = cellModel.getAnimationKeyFrameRole();
                this.animationIDRole = subgroupVariable != null ? cellModel.getSubgroupRole() : cellModel.getCategoryRole();
            }
            this.dataSource = dataSource;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            throw new IllegalStateException("Not yet Supported");
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            if (columnNode instanceof DataTreeGroupNode && rowNode instanceof DataTreeGroupNode) {
                String whereClause = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)columnNode), (DataTreeGroupNode)((DataTreeGroupNode)rowNode));
                DataSource cellDataSource = this.dataSource.newDataSourceWhere(whereClause);
                if (this.animationKeyFrameRole != null && this.animationIDRole != null) {
                    cellDataSource = cellDataSource.newAnimationDataSource(this.animationKeyFrameRole, this.animationIDRole);
                }
                return new BarLineChartCell(this.cellModel, cellDataSource, columnNode, rowNode, this.channel);
            }
            return null;
        }
    }

    private static class DependentAxisCellFactory
    implements Matrix.CellFactoryInterface {
        private DependentAxisCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            return new AxisCell((AxisCellModel)cellModel, channel);
        }
    }

    private class BarCellFactory
    implements Matrix.CellFactoryInterface,
    Matrix.CellFactoryInterface2 {
        private BarCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            BarLineChartCell barLineChartCell = null;
            if (dataSource != null && dataSource.length > 0) {
                barLineChartCell = new BarLineChartCell((BarLineChartCellModel)cellModel, dataSource[0], null, null, channel);
            }
            return barLineChartCell;
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Matrix.MatrixInfo matrixInfo, Channel channel) {
            BarLineChartCell barLineChartCell = null;
            if (dataSource != null && dataSource.length > 0) {
                barLineChartCell = matrixInfo != null ? new BarLineChartCell((BarLineChartCellModel)cellModel, dataSource[0], matrixInfo.getColumnOrdinal(), matrixInfo.getRowOrdinal(), channel) : new BarLineChartCell((BarLineChartCellModel)cellModel, dataSource[0], null, null, channel);
            }
            return barLineChartCell;
        }
    }
}

