/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.areabarchart;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;

class AreaBarStepper
extends PropertyContainer
implements NumericPipe {
    private double[] sum;
    public final NumericProperty input = new NumericProperty((PropertyContainer)this, true);
    public final IntegerProperty category = new IntegerProperty((PropertyContainer)this, true);
    public final NumericPipe value = this;

    AreaBarStepper() {
    }

    public void init(AInitAction initAction) {
        super.init(initAction);
        if (initAction.beenInitialized((PropertyContainer)this)) {
            return;
        }
        int vc = initAction.getValueCount();
        if (this.sum == null || vc > this.sum.length) {
            this.sum = new double[vc];
        }
        double total = 0.0;
        double prevV = 0.0;
        int prevC = 0;
        try {
            prevC = this.category.getValue(0);
            prevV = this.input.getValue(0);
            this.sum[prevC] = 0.0;
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        for (int i = 0; i < vc; ++i) {
            try {
                int c = this.category.getValue(i);
                if (c == prevC) continue;
                prevC = c;
                this.sum[c] = total += prevV;
                prevV = this.input.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    public double getValue(int i) throws MissingValueException {
        return this.sum[this.category.getValue(i)];
    }
}

