/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.areabarchart;

import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.areabarchart.AreaBarChartModel;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.AxisCell;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.areabarchart.AreaBarChartCell;
import com.sas.graphics.util.cell.areabarchart.AreaBarChartCellModel;
import com.sas.graphics.util.cell.areabarchart.AreaBarChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class AreaBarChartMatrix
extends Matrix {
    private static final String RB_KEY_MATRIX = "Matrix.";
    private AreaBarChartMatrixModel model;
    private List cellList;
    private OverlayAxisCell[] hAxisCells;
    private OverlayAxisCell[] vAxisCells;
    private AreaBarChartCell[][] chartCells;

    public AreaBarChartMatrix(Channel channel) {
        super(channel);
    }

    public void setModel(AreaBarChartMatrixModel newModel) {
        if (this.model != newModel) {
            AreaBarChartMatrixModel oldModel = this.model;
            this.model = newModel;
            this.reconstruct();
            this.firePropertyChange("model", oldModel, newModel);
        }
    }

    public AreaBarChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    protected synchronized void construct() {
        double[] cellRange;
        AreaBarChartCellModel bccm;
        AreaBarChartCell cell;
        int r;
        boolean frameVisible;
        int frameVisibilityPolicy;
        AxisCellModel verticalAxisCellModel;
        AxisCellModel horizontalAxisCellModel;
        boolean heightFound;
        boolean categoryFound;
        AreaBarChartMatrixModel matrixModel = this.getModel();
        if (matrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        AreaBarChartModel graphModel = matrixModel.getAreabarChartModel();
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource("dataSourceNotSpecified.ex.txt"));
        }
        boolean bl = categoryFound = dataSource.getVariable(matrixModel.getCategoryRole()) != null;
        if (!categoryFound) {
            throw new IllegalStateException(RB.getStringResource("categoryVariableNotSpecified.ex.txt"));
        }
        boolean widthFound = dataSource.getVariable(matrixModel.getWidthRole()) != null;
        boolean bl2 = heightFound = dataSource.getVariable(matrixModel.getHeightRole()) != null;
        if (!widthFound) {
            dataSource.setVariableDefinition(matrixModel.getWidthRole(), new FreqVariableDefinition());
        }
        if (!heightFound) {
            dataSource.setVariableDefinition(matrixModel.getHeightRole(), (VariableDefinition)dataSource.getVariableDefinition(matrixModel.getWidthRole()).clone());
        }
        DataSource rangeDataSource = dataSource;
        Boolean antialiasedGraphics = new Boolean(matrixModel.getAreabarChartModel().isAntialiasedGraphics());
        Boolean antialiasedText = new Boolean(matrixModel.getAreabarChartModel().isAntialiasedText());
        Variable categoryVariable = rangeDataSource.getVariable(matrixModel.getCategoryRole(), 0);
        Variable heightVariable = rangeDataSource.getVariable(matrixModel.getHeightRole(), 0);
        double heightMax = 0.0;
        if (heightVariable instanceof NumericVariable) {
            BidirectionalAccumulatorByCategory acc = new BidirectionalAccumulatorByCategory();
            acc.category.connectFrom(((StringVariable)categoryVariable).category);
            acc.input.connectFrom(((NumericVariable)heightVariable).value);
            heightMax = Math.max(heightMax, acc.getAccumulation()[1]);
        }
        Variable widthVariable = rangeDataSource.getVariable(matrixModel.getWidthRole(), 0);
        double widthMax = 0.0;
        if (widthVariable instanceof NumericVariable) {
            widthMax = Math.max(widthMax, ((NumericVariable)widthVariable).getSum());
        }
        double widthAxisLength = 500.0;
        int widthAxisLabelCount = 5;
        double heightAxisLength = 500.0;
        int heightAxisLabelCount = 5;
        boolean vertical = graphModel.getOrientation() == 1;
        Dimension depth = new Dimension(0, 0);
        AxisCellModel widthAxisCellModel = new AxisCellModel();
        widthAxisCellModel.setLocale(dataSource.getLocale());
        widthAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
        widthAxisCellModel.setAntialiasedText(antialiasedText);
        widthAxisCellModel.setLength(new Double(widthAxisLength));
        widthAxisCellModel.setExtendToMargin(Boolean.FALSE);
        widthAxisCellModel.setDepth(depth);
        widthAxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
        widthAxisCellModel.setAxisModel(graphModel.getWidthAxisModel());
        if (dataSource.getVariable(matrixModel.getRowRole()) == null) {
            boolean titleOn = graphModel.getWidthAxisModel().getLabelTextStyle().isVisible();
            widthAxisCellModel.setTitleOn(titleOn ? Boolean.TRUE : Boolean.FALSE);
            String label = graphModel.getWidthAxisModel().getLabel();
            if (label == null) {
                label = widthVariable.getLabel();
            }
            if (label == null) {
                label = widthVariable.getName();
            }
            widthAxisCellModel.setTitle(label);
        }
        ContinuousRangeToNumericMapper widthAxisMapper = new ContinuousRangeToNumericMapper();
        widthAxisMapper.setInputMin(0.0);
        widthAxisMapper.setInputMax(widthMax);
        widthAxisMapper.setLabelCount(widthAxisLabelCount);
        widthAxisMapper.setLabelRanges(graphModel.getWidthAxisModel().getContinuousValuePlacementPolicy() == 12202);
        if (widthVariable != null) {
            widthAxisMapper.setFormat(widthVariable.getFormat());
        }
        widthAxisCellModel.setMapper((NumericMapper)widthAxisMapper);
        AxisCellModel heightAxisCellModel = new AxisCellModel();
        heightAxisCellModel.setLocale(dataSource.getLocale());
        heightAxisCellModel.setAntialiasedGraphics(antialiasedGraphics);
        heightAxisCellModel.setAntialiasedText(antialiasedText);
        heightAxisCellModel.setLength(new Double(heightAxisLength));
        heightAxisCellModel.setExtendToMargin(Boolean.FALSE);
        heightAxisCellModel.setDepth(depth);
        heightAxisCellModel.setReferenceLinesVisible(Boolean.TRUE);
        heightAxisCellModel.setAxisModel(graphModel.getHeightAxisModel());
        if (dataSource.getVariable(matrixModel.getColumnRole()) == null) {
            boolean titleOn = graphModel.getHeightAxisModel().getLabelTextStyle().isVisible();
            heightAxisCellModel.setTitleOn(titleOn ? Boolean.TRUE : Boolean.FALSE);
            String label = graphModel.getHeightAxisModel().getLabel();
            if (label == null) {
                label = heightVariable.getLabel();
            }
            if (label == null) {
                label = heightVariable.getName();
            }
            heightAxisCellModel.setTitle(label);
        }
        ContinuousRangeToNumericMapper heightAxisMapper = new ContinuousRangeToNumericMapper();
        heightAxisMapper.setInputMin(0.0);
        heightAxisMapper.setInputMax(heightMax);
        heightAxisMapper.setLabelCount(heightAxisLabelCount);
        heightAxisMapper.setLabelRanges(graphModel.getWidthAxisModel().getContinuousValuePlacementPolicy() == 12202);
        if (heightVariable != null) {
            heightAxisMapper.setFormat(heightVariable.getFormat());
        }
        heightAxisCellModel.setMapper((NumericMapper)heightAxisMapper);
        if (vertical) {
            horizontalAxisCellModel = widthAxisCellModel;
            verticalAxisCellModel = heightAxisCellModel;
        } else {
            horizontalAxisCellModel = heightAxisCellModel;
            verticalAxisCellModel = widthAxisCellModel;
        }
        horizontalAxisCellModel.setAxisOrientation("East");
        verticalAxisCellModel.setAxisOrientation("North");
        if (graphModel.getDimension() == 10101) {
            double depthZ = widthAxisLength * matrixModel.getDepthRatio();
            double angleInRadians = Math.toRadians(matrixModel.getRecedingAngle());
            depth.width = (int)(depthZ * Math.cos(angleInRadians));
            depth.height = (int)(depthZ * Math.sin(angleInRadians));
        }
        if ((frameVisibilityPolicy = graphModel.getFrameLineStyle().getVisibilityPolicy()) == 10200) {
            Variable[] colRoles = dataSource.getVariable(matrixModel.getColumnRole());
            Variable[] rowRoles = dataSource.getVariable(matrixModel.getRowRole());
            frameVisible = colRoles != null || rowRoles != null;
        } else {
            frameVisible = frameVisibilityPolicy == 10201;
        }
        StringToColorMapper colorMapper = this._addLegend(dataSource, matrixModel, graphModel);
        if (colorMapper == null) {
            colorMapper = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(dataSource.getVariable(matrixModel.getCategoryRole(), 0), graphModel.getDataElementStyles().getFillStyles(), graphModel.getDataElementStyles().getDiscreteFillColors());
        }
        AreaBarChartCellModel areaBarChartCellModel = new AreaBarChartCellModel();
        areaBarChartCellModel.setAntialiasedGraphics(antialiasedGraphics);
        areaBarChartCellModel.setAntialiasedText(antialiasedText);
        areaBarChartCellModel.setCategoryRole(matrixModel.getCategoryRole());
        areaBarChartCellModel.setSubgroupRole(matrixModel.getSubgroupRole());
        areaBarChartCellModel.setHeightRole(matrixModel.getHeightRole());
        areaBarChartCellModel.setWidthRole(matrixModel.getWidthRole());
        areaBarChartCellModel.setInsideBarLabelRole(matrixModel.getInsideBarLabelRole());
        areaBarChartCellModel.setOutsideBarLabelRole(matrixModel.getOutsideBarLabelRole());
        areaBarChartCellModel.setAuxiliaryRole(matrixModel.getAuxiliaryRole());
        areaBarChartCellModel.setDataTipRole(matrixModel.getDataTipRole());
        areaBarChartCellModel.setHeightAxisCellModel(heightAxisCellModel);
        areaBarChartCellModel.setWidthAxisCellModel(widthAxisCellModel);
        areaBarChartCellModel.setAreabarChartModel(matrixModel.getAreabarChartModel());
        areaBarChartCellModel.setFrameVisible(frameVisible ? Boolean.TRUE : Boolean.FALSE);
        areaBarChartCellModel.setStringToColorMapper(colorMapper);
        areaBarChartCellModel.setDepthRatio(matrixModel.getDepthRatio());
        areaBarChartCellModel.setRecedingAngle(matrixModel.getRecedingAngle());
        this.cellList = this.addMatrixCellComponents(new AreabarCellFactory(), areaBarChartCellModel, new DataSource[]{dataSource});
        ArrayList hAxisCellList = this.addColumnTabletCellComponents(new AxisCellFactory(), horizontalAxisCellModel, null, true);
        ArrayList vAxisCellList = this.addRowTabletCellComponents(new AxisCellFactory(), verticalAxisCellModel, null, true);
        this.hAxisCells = hAxisCellList.toArray(new OverlayAxisCell[0]);
        this.vAxisCells = vAxisCellList.toArray(new OverlayAxisCell[0]);
        int rows = this.vAxisCells.length;
        int cols = this.hAxisCells.length;
        AreaBarChartCell[] chartCell1DArray = this.cellList.toArray(new AreaBarChartCell[0]);
        this.chartCells = new AreaBarChartCell[rows][];
        for (r = 0; r < rows; ++r) {
            this.chartCells[r] = new AreaBarChartCell[cols];
            for (int c = 0; c < cols; ++c) {
                this.chartCells[r][c] = chartCell1DArray[r * cols + c];
            }
        }
        for (r = 0; r < rows; ++r) {
            ContinuousRangeToNumericMapper rowFirstMapper = (ContinuousRangeToNumericMapper)this.vAxisCells[r].getAxisModel().getMapper();
            cell = this.chartCells[r][0];
            double[] rowVerticalRange = vertical ? cell.getHeightRange() : cell.getWidthRange();
            for (int c = 0; c < cols; ++c) {
                cell = this.chartCells[r][c];
                bccm = cell.getAreaBarChartCellModel();
                AxisCellModel vcm = vertical ? bccm.getHeightAxisCellModel() : bccm.getWidthAxisCellModel();
                ((ContinuousRangeToNumericMapper)vcm.getMapper()).shareMap(rowFirstMapper);
                double[] dArray = cellRange = vertical ? cell.getHeightRange() : cell.getWidthRange();
                if (cellRange[0] < rowVerticalRange[0]) {
                    rowVerticalRange[0] = cellRange[0];
                }
                if (!(cellRange[1] > rowVerticalRange[1])) continue;
                rowVerticalRange[1] = cellRange[1];
            }
            rowFirstMapper.setInputMin(rowVerticalRange[0]);
            rowFirstMapper.setInputMax(rowVerticalRange[1]);
        }
        for (int c = 0; c < cols; ++c) {
            ContinuousRangeToNumericMapper colFirstMapper = (ContinuousRangeToNumericMapper)this.hAxisCells[c].getAxisModel().getMapper();
            cell = this.chartCells[0][c];
            double[] colHorizontalRange = vertical ? cell.getWidthRange() : cell.getHeightRange();
            for (int r2 = 0; r2 < rows; ++r2) {
                cell = this.chartCells[r2][c];
                bccm = cell.getAreaBarChartCellModel();
                AxisCellModel hcm = vertical ? bccm.getWidthAxisCellModel() : bccm.getHeightAxisCellModel();
                ((ContinuousRangeToNumericMapper)hcm.getMapper()).shareMap(colFirstMapper);
                double[] dArray = cellRange = vertical ? cell.getWidthRange() : cell.getHeightRange();
                if (cellRange[0] < colHorizontalRange[0]) {
                    colHorizontalRange[0] = cellRange[0];
                }
                if (!(cellRange[1] > colHorizontalRange[1])) continue;
                colHorizontalRange[1] = cellRange[1];
            }
            colFirstMapper.setInputMin(colHorizontalRange[0]);
            colFirstMapper.setInputMax(colHorizontalRange[1]);
        }
        Channel channel = this.getChannel();
        channel.glViewport(0, 0, 1, 1);
        channel.glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
        verticalAxisCellModel.computeParameters(channel);
        horizontalAxisCellModel.computeParameters(channel);
    }

    @Override
    public void validateTree() {
        int r;
        int cellHeight;
        int cellWidth;
        int hah;
        int vaw;
        AxisCellModel verticalAxisCellModel;
        AxisCellModel horizontalAxisCellModel;
        boolean threeD;
        AreaBarChartMatrixModel matrixModel;
        int w = this.getWidth();
        int h = this.getHeight();
        if (w <= 20 || h <= 20) {
            AreaBarChartMatrix.notEnoughSpace();
        }
        if ((matrixModel = this.getModel()) == null) {
            return;
        }
        AreaBarChartModel graphModel = matrixModel.getAreabarChartModel();
        AreaBarChartCell cell = (AreaBarChartCell)this.cellList.get(0);
        AreaBarChartCellModel cellModel = cell.getAreaBarChartCellModel();
        AxisCellModel heightAxisCellModel = cellModel.getHeightAxisCellModel();
        AxisCellModel widthAxisCellModel = cellModel.getWidthAxisCellModel();
        boolean vertical = graphModel.getOrientation() == 1;
        boolean bl = threeD = cellModel.getAreabarChartModel().getDimension() == 10101;
        if (vertical) {
            horizontalAxisCellModel = widthAxisCellModel;
            verticalAxisCellModel = heightAxisCellModel;
        } else {
            horizontalAxisCellModel = heightAxisCellModel;
            verticalAxisCellModel = widthAxisCellModel;
        }
        Channel channel = this.getChannel();
        int i = 0;
        int hah2 = (int)(horizontalAxisCellModel.getCatAxisAdj() + 0.999);
        int vaw2 = (int)(verticalAxisCellModel.getResAxisAdj() + 0.999);
        do {
            vaw = vaw2;
            hah = hah2;
            ++i;
            cellWidth = (w - vaw) / this.hAxisCells.length;
            horizontalAxisCellModel.setResAxisAdj(new Double(vaw));
            horizontalAxisCellModel.setMaximumSize(new Vec3d((double)cellWidth, (double)h / 3.0, 0.0));
            horizontalAxisCellModel.computeParameters(channel, cellWidth, h / 3);
            hah2 = (int)(horizontalAxisCellModel.getCatAxisAdj() + 0.999);
            Dimension applicableLegendSize = new Dimension(0, 0);
            int legendPlacement = graphModel.getLegendModel().getPlacement();
            JComponent legend = this.getLegend(legendPlacement);
            switch (legendPlacement) {
                default: {
                    applicableLegendSize.height = legend.getHeight();
                    break;
                }
                case 3: 
                case 7: {
                    applicableLegendSize.width = legend.getWidth();
                }
            }
            cellHeight = (h - hah - applicableLegendSize.height) / this.vAxisCells.length - verticalAxisCellModel.getTitleHeight().intValue();
            verticalAxisCellModel.setMaximumSize(new Vec3d((double)w / 3.0, (double)cellHeight, 0.0));
            verticalAxisCellModel.computeParameters(channel, w / 3, cellHeight);
        } while ((vaw != (vaw2 = (int)(verticalAxisCellModel.getResAxisAdj() + 0.999)) || hah != hah2) && i <= 10);
        if (threeD) {
            double ch;
            double cw;
            Dimension depth = widthAxisCellModel.getDepth();
            double ccw = w - vaw;
            double angle = matrixModel.getRecedingAngle();
            double angleInRadians = Math.toRadians(angle);
            double xRatio = Math.cos(angleInRadians) * cellModel.getDepthRatio();
            double yRatio = Math.sin(angleInRadians) * cellModel.getDepthRatio();
            if (vertical) {
                cw = Math.min((double)cellWidth / (1.0 + xRatio), (double)(cellWidth - 10) / yRatio);
                depth.width = (int)(cw * xRatio);
                depth.height = (int)(cw * yRatio);
                ch = cellHeight - depth.height;
            } else {
                ch = Math.min((double)cellHeight / (1.0 + yRatio), (ccw - 10.0) / xRatio);
                depth.width = (int)(ch * xRatio);
                depth.height = (int)(ch * yRatio);
                cw = cellWidth - depth.width;
            }
            if (cw < 20.0 || ch < 20.0) {
                AreaBarChartMatrix.notEnoughSpace();
            }
        }
        verticalAxisCellModel.setCatAxisAdj(new Double(0.0));
        int lineThickness = (int)verticalAxisCellModel.getAxisModel().getAxisLineStyle().getThickness().getMagnitude((Object)"px");
        horizontalAxisCellModel.setResAxisAdj(new Double(vaw + lineThickness));
        int rows = this.vAxisCells.length;
        int cols = this.hAxisCells.length;
        for (r = 0; r < rows; ++r) {
            this.vAxisCells[r].invalidate();
        }
        for (int c = 0; c < cols; ++c) {
            this.hAxisCells[c].invalidate();
        }
        for (r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                this.chartCells[r][c].invalidate();
            }
        }
        super.validateTree();
    }

    private static void notEnoughSpace() {
        throw new IllegalStateException(RB.getStringResource(RB_KEY_MATRIX, "InsufficientDisplaySpace.ex.txt"));
    }

    @Override
    public void paintChildren(Graphics g) {
        int r;
        int c;
        int nr = this.vAxisCells.length;
        int nc = this.hAxisCells.length;
        for (c = 0; c < nc; ++c) {
            this.hAxisCells[c].startPainting();
        }
        for (r = 0; r < nr; ++r) {
            this.vAxisCells[r].startPainting();
        }
        super.paintChildren(g);
        for (c = 0; c < nc; ++c) {
            this.hAxisCells[c].endPainting();
        }
        for (r = 0; r < nr; ++r) {
            this.vAxisCells[r].endPainting();
        }
    }

    private StringToColorMapper _addLegend(DataSource ds, AreaBarChartMatrixModel matrixModel, AreaBarChartModel graphModel) {
        DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
        if (ds == null || dataElementStyles == null || dataElementStyles.getFillStyles() == null || dataElementStyles.getFillStyles().length < 1) {
            return null;
        }
        StringToColorMapper colorMapper = null;
        Variable subgroupVariable = ds.getVariable(matrixModel.getSubgroupRole(), 0);
        Variable categoryVariable = ds.getVariable(matrixModel.getCategoryRole(), 0);
        colorMapper = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(subgroupVariable != null ? subgroupVariable : categoryVariable, dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors());
        LegendCellModel lcm = new LegendCellModel();
        lcm.setColorMapper((ColorMapper)colorMapper);
        lcm.setLegendModel(graphModel.getLegendModel());
        lcm.setAntialiasedText(new Boolean(graphModel.isAntialiasedText()));
        lcm.setAntialiasedGraphics(new Boolean(graphModel.isAntialiasedGraphics()));
        LegendCell lc = new LegendCell(lcm, this.getChannel());
        int placement = graphModel.getLegendModel().getPlacement();
        if (placement == 10200) {
            placement = 5;
        }
        lcm.setPlacement(new Integer(placement));
        int orientation = placement == 7 || placement == 3 ? 1 : 0;
        lcm.setOrientation(new Integer(orientation));
        this.addLegend(lc, placement);
        return colorMapper;
    }

    @Override
    protected List getCells() {
        return this.cellList;
    }

    private static class AreabarCellFactory
    implements Matrix.CellFactoryInterface {
        private AreabarCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface m, DataSource[] ds, Channel ch) {
            return ds != null && ds.length > 0 ? new AreaBarChartCell((AreaBarChartCellModel)m, ds[0], ch) : null;
        }
    }

    private static class OverlayAxisCell
    extends AxisCell {
        boolean painting = false;

        public OverlayAxisCell(AxisCellModel m, Channel ch) {
            super(m, ch);
        }

        public void startPainting() {
            this.painting = true;
        }

        public void endPainting() {
            this.painting = false;
        }

        @Override
        public Rectangle getBounds(Rectangle r) {
            super.getBounds(r);
            if (this.painting) {
                int rx = r.x;
                int ry = r.y;
                Rectangle pb = this.getParent().getBounds(r);
                r.x = rx;
                r.y = ry;
                r.width = pb.width - rx;
                r.height = pb.height - ry;
            }
            return r;
        }

        @Override
        public void construct() {
            super.construct();
            String dir = this.getAxisModel().getAxisOrientation();
            boolean horz = dir.equalsIgnoreCase("east") || dir.equalsIgnoreCase("west");
            NumericProperty ty = this.getComposite().transform.translateY;
            NumericProperty tx = this.getComposite().transform.translateX;
            if (horz) {
                ty.setValue(ty.getValue() + 1.0);
            } else {
                tx.setValue(tx.getValue() + 1.0);
            }
        }
    }

    private static class AxisCellFactory
    implements Matrix.CellFactoryInterface {
        private AxisCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface m, DataSource[] ds, Channel ch) {
            return new OverlayAxisCell((AxisCellModel)m, ch);
        }
    }
}

