/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.storage.olap.OLAPException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ValueTree {
    public static final String RB_KEY = "ValueTree.";
    private transient DataTreeGroupNode root = null;
    private transient DataTreeInfo info;
    private transient DefaultMutableTreeNode[] leafNodeArray = null;

    private ValueTree(DataTreeGroupNode root) {
        this.root = root;
        if (root != null) {
            this.info = (DataTreeInfo)root.getValue();
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public int getVariableCount() {
        if (this.info == null) {
            return 0;
        }
        return this.info.getGroupVariableCount();
    }

    public Variable getVariableAt(int i) {
        if (this.info == null) {
            return null;
        }
        return this.info.getGroupVariableAt(i);
    }

    public int getDepthCount() {
        if (this.info == null) {
            return 0;
        }
        return this.info.getGroupVariableCount();
    }

    public String createWhereClause(TreeNode node) {
        String result = null;
        if (node instanceof DataTreeGroupNode) {
            result = DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)node));
        }
        return result;
    }

    public DefaultMutableTreeNode[] getLeafNodes() {
        if (this.leafNodeArray == null) {
            this.leafNodeArray = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)this.root);
            if (this.leafNodeArray.length == 0) {
                this.leafNodeArray = new DefaultMutableTreeNode[]{this.root};
            }
        }
        return this.leafNodeArray;
    }

    public int getLeafNodeCount() {
        return this.getLeafNodes().length;
    }

    public static ValueTree[] createTrees(DataSource dataSource, Object columnId, Object rowId) {
        ValueTree[] valueTrees = new ValueTree[2];
        DataTreeGroupNode[] trees = null;
        if (dataSource != null) {
            try {
                trees = dataSource.createTrees(columnId, rowId);
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        } else {
            trees = VariableProcessor.createRowColumnTrees(null, null);
        }
        if (trees != null) {
            valueTrees[0] = new ValueTree(trees[0]);
            valueTrees[1] = new ValueTree(trees[1]);
        }
        return valueTrees;
    }

    public static ValueTree createMultipleHierarchyTree(DataSource dataSource, List roles) {
        try {
            return new ValueTree(dataSource.createTrees(roles, null)[0]);
        }
        catch (OLAPException e) {
            e.printStackTrace();
            return new ValueTree(null);
        }
    }

    public void reverse() {
        ValueTree.reverse(this.root);
    }

    private static void reverse(DataTreeGroupNode root) {
        List reverseNodes = ValueTree.findReverseNodes(root);
        int n = reverseNodes.size();
        ArrayList scratch = new ArrayList();
        for (int i = 0; i < n; ++i) {
            DataTreeGroupNode node = (DataTreeGroupNode)reverseNodes.get(i);
            ValueTree.reverseChildrenRecursively(node, scratch);
        }
    }

    private static void reverseChildrenRecursively(DataTreeGroupNode node, List scratchList) {
        int i;
        int n = node.getChildCount();
        for (i = 0; i < n; ++i) {
            DataTreeGroupNode child = (DataTreeGroupNode)node.getChildAt(i);
            ValueTree.reverseChildrenRecursively(child, scratchList);
        }
        scratchList.clear();
        for (i = 0; i < n; ++i) {
            scratchList.add(node.getChildAt(i));
        }
        node.removeAllChildren();
        for (i = 0; i < n; ++i) {
            node.add((MutableTreeNode)((DataTreeGroupNode)scratchList.get(n - i - 1)));
        }
    }

    private static List findReverseNodes(DataTreeGroupNode root) {
        ArrayList<Object> reverseList;
        block5: {
            DataTreeInfo dti;
            block4: {
                reverseList = new ArrayList<Object>();
                dti = (DataTreeInfo)root.getValue();
                boolean isOlap = dti.getGroupVariableAt(0) instanceof OLAPLevelVariable;
                if (!isOlap) break block4;
                int groupVariabelCount = dti.getGroupVariableCount();
                OLAPLevelVariable lv = (OLAPLevelVariable)dti.getGroupVariableAt(groupVariabelCount - 1);
                String hierarchyToReverse = lv.getHierachyName();
                int level = -1;
                int i = 0;
                while (i < groupVariabelCount && !(lv = (OLAPLevelVariable)dti.getGroupVariableAt(i)).getHierachyName().equals(hierarchyToReverse)) {
                    level = i++;
                }
                DefaultMutableTreeNode[] leaf = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
                for (i = 0; i < leaf.length; ++i) {
                    DataTreeGroupNode node = (DataTreeGroupNode)leaf[i];
                    while (node.getLevelIndex() > level) {
                        node = (DataTreeGroupNode)node.getParent();
                    }
                    if (reverseList.contains(node)) continue;
                    reverseList.add(node);
                }
                break block5;
            }
            int levelCount = dti.getGroupVariableCount();
            if (levelCount <= 0) break block5;
            DataTreeGroupNode leftMost = DataTreeUtil.getLeftMostNodeAtLevel((DataTreeGroupNode)root, (int)(levelCount - 2));
            DataTreeGroupNode p = (DataTreeGroupNode)leftMost.getParent();
            int n = p.getChildCount();
            for (int i = 0; i < n; ++i) {
                reverseList.add(p.getChildAt(i));
            }
        }
        return reverseList;
    }
}

