/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.util.DateTimeTickSpacer;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.SimpleModel;
import com.sas.graphics.util.cell.SimplePropertyBag;
import com.sas.graphics.util.cell.SimplePropertyBagInterface;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Dimension;
import java.awt.Font;

public class TimeAxisCellModel
extends AxisCellModel {
    static final String[] TimeHorzFitAlg = new String[]{"Split", "Stagger", "Angle90TruncateShrinkThinkeepend"};
    public static final Object DISCRETE = "discrete";
    public static final Object MIN_INCREMENT = "minIncrement";
    public static final Object UNIT_LENGTH = "unitLength";
    protected DateTimeTickSpacer tickSpacer;
    protected double min;
    protected double max;
    protected double adjustedMin;
    protected double adjustedMax;
    protected double[] values;
    protected int labelWidth;
    protected boolean day;
    protected String week;
    protected GTKFormat outputFormat;

    public void setDiscrete(Boolean v) {
        this.properties.set(DISCRETE, v);
    }

    public Boolean getDiscrete() {
        return SimplePropertyBag.Util.getBoolean(this.properties, DISCRETE, this.propertyDefaults);
    }

    public void setMinIncrement(Double v) {
        this.properties.set(MIN_INCREMENT, v);
    }

    public Double getMinIncrement() {
        return SimplePropertyBag.Util.getDouble(this.properties, MIN_INCREMENT, this.propertyDefaults);
    }

    public void setUnitLength(Double v) {
        this.properties.set(UNIT_LENGTH, v);
    }

    public Double getUnitLength() {
        return SimplePropertyBag.Util.getDouble(this.properties, UNIT_LENGTH, this.propertyDefaults);
    }

    public TimeAxisCellModel() {
        this.setDiscrete(Boolean.FALSE);
        this.setUnitLength(new Double(0.0));
    }

    public TimeAxisCellModel(SimplePropertyBagInterface delegate, SimpleModel ancestor) {
        super(delegate, ancestor);
        this.setDiscrete(Boolean.FALSE);
        this.setUnitLength(new Double(0.0));
    }

    @Override
    public void computeParameters(Channel channel) {
        TextStyle tsl;
        Font tf;
        NumericMapper mapper = this.getMapper();
        if (mapper == null) {
            return;
        }
        if (!(mapper instanceof ContinuousRangeToNumericMapper)) {
            super.computeParameters(channel);
            return;
        }
        ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)mapper;
        GTKFormat format = cm.getFormat();
        SASFormat sasFormat = null;
        if (format == null || !(format.getFormats()[0] instanceof SASDateTimeFormat)) {
            super.computeParameters(channel);
            return;
        }
        sasFormat = (SASFormat)format.getFormats()[0];
        this.day = sasFormat.isDateFormat();
        AxisModel axisModel = this.getAxisModel();
        TextStyle tsv = axisModel.getValueTextStyle();
        Font font = tsv.getFont();
        if (font == null) {
            font = FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)12);
        }
        if ((tf = (tsl = axisModel.getLabelTextStyle()).getFont()) == null) {
            tf = FontManager.getFont((String)font.getFamily(), (int)1, (int)((int)((double)font.getSize() * 1.2)));
        }
        this.min = cm.getInputMin();
        this.max = cm.getInputMax();
        this.tickSpacer = new DateTimeTickSpacer();
        this.tickSpacer.getTickSpacingInfo().setFormat(sasFormat);
        this.tickSpacer.setDataMin(this.min);
        this.tickSpacer.setDataMax(this.max);
        int maxTicks = 12;
        if (this.getDiscrete().booleanValue()) {
            int uniqueCount = (int)((this.max - this.min) / this.getMinIncrement()) + 1;
            maxTicks = Math.min(maxTicks, uniqueCount);
        }
        this.tickSpacer.getTickSpacingInfo().setMaxTicks(maxTicks);
        if (axisModel.getMajorTickTimeInterval() == 10820) {
            this.tickSpacer.getPreference().setAutoInterval(true);
        } else {
            this.tickSpacer.getPreference().setAutoInterval(false);
            int timeInterval = axisModel.getMajorTickTimeInterval();
            ZxAxis.Interval intvl = this.computeInterval(timeInterval);
            this.tickSpacer.getTickSpacingInfo().setInterval(intvl);
        }
        this.tickSpacer.doTickSpacing();
        int labelCount = this.tickSpacer.getNumTicks();
        this.adjustedMin = this.tickSpacer.getTickMin();
        this.adjustedMax = this.tickSpacer.getTickMax();
        this.values = this.tickSpacer.getTickValues();
        this.outputFormat = sasFormat != null ? this.newGTKFormat(this.tickSpacer.getFormatName(true)) : null;
        cm.setInputMin(this.adjustedMin);
        cm.setInputMax(this.adjustedMax);
        cm.setLabelCount(labelCount);
        Dimension depth = this.getDepth();
        if (depth == null) {
            depth = new Dimension(0, 0);
            this.setDepth(depth);
        }
        StringVector tickLabels = new StringVector();
        labelCount = 0;
        for (int ii = 0; ii < this.values.length; ++ii) {
            if (!(this.values[ii] >= this.adjustedMin) || !(this.values[ii] <= this.adjustedMax)) continue;
            if (this.outputFormat != null) {
                tickLabels.addValue(this.outputFormat.format((Object)new Double(this.values[ii])));
            } else {
                tickLabels.addValue(new Double(this.values[ii]).toString());
            }
            ++labelCount;
        }
        this.setValueCount(new Integer(labelCount));
        this.setValueLabels((StringPipe)tickLabels);
        Dimension margin = this.getMargin();
        Dimension minMargin = this.getMinimumMargin();
        String orient = this.getAxisOrientation();
        if (orient == "East" || orient == "West") {
            double minLength;
            RectangularAxis axis = RectangularAxis.getXAxis((NumericMapper)cm, (double)0.0);
            AxisStyle axisStyle = axis.getStyle();
            com.sas.graphics.util.gtk.TextStyle titleTextStyle = axisStyle.getTitleStyle();
            titleTextStyle.setAngle(this.getTitleAngle().doubleValue());
            axisStyle.setLabelStaggerSpace(0.2);
            TextStyle valueTextStyle = axisModel.getValueTextStyle();
            TextStyle labelTextStyle = axisModel.getLabelTextStyle();
            if (labelTextStyle != null) {
                titleTextStyle.setFont(labelTextStyle.getFont());
            }
            com.sas.graphics.util.gtk.TextStyle value = axisStyle.getLabelStyle();
            value.setFont(valueTextStyle.getFont());
            value.setFit(true);
            axisStyle.setTitleOn(this.getTitleOn().booleanValue());
            String title = this.getTitle();
            axis.title.setValue(title);
            axis.labels.connectFrom((StringPipe)tickLabels);
            axis.setFitAlgorithm(TimeHorzFitAlg);
            AxisMetrics metrics = axis.getPreferredMetrics(channel);
            double offset = Math.ceil(metrics.getLowExtender());
            double length = minLength = metrics.getLineLength();
            channel.glSelect2DFont(value.getFont());
            length += (double)(labelCount - 1) * channel.glGetTextWidth(RB.getStringResource("fiveSpaces.txt")) / 2.0;
            if (this.getDiscrete().booleanValue()) {
                if (this.adjustedMin != this.adjustedMax) {
                    double left = (this.min - this.adjustedMin) / (this.adjustedMax - this.adjustedMin) * length;
                    double right = (this.adjustedMax - this.max) / (this.adjustedMax - this.adjustedMin) * length;
                    double graphLength = length - left - right;
                    int uniqueCount = (int)((this.max - this.min) / this.getMinIncrement()) + 1;
                    double unitSpace = graphLength / (double)uniqueCount;
                    unitSpace = Math.min(Math.max(1.0, unitSpace), length);
                    margin.width = this.getMaximizeSpace() != false ? (int)(unitSpace * 0.5) : (int)Math.max(unitSpace * 0.5, offset);
                    margin.width = Math.max(margin.width, minMargin.width);
                    this.setUnitLength(new Double(unitSpace));
                }
            } else {
                margin.width = (int)Math.max(offset, (double)minMargin.width);
            }
            this.setPreferredLength(new Double(minLength));
            this.setIdealPreferredLength(new Double(length));
            cm.setOutputMax(cm.getOutputMin() + length);
            this.setLength(new Double(length));
            this.setCatAxisAdj(new Double(metrics.getOutsideLength()));
            this.setResAxisAdj(new Double(0.0));
        }
        this.setFitAlgorithm(TimeHorzFitAlg);
    }

    @Override
    public void computeParameters(Channel channel, double newLength) {
        boolean horzAxis;
        String axisOrientation = this.getAxisOrientation();
        boolean bl = horzAxis = axisOrientation == "East" || axisOrientation == "West";
        if (horzAxis) {
            this.computeParameters(channel, newLength, Double.POSITIVE_INFINITY);
        } else {
            this.computeParameters(channel, Double.POSITIVE_INFINITY, newLength);
        }
    }

    @Override
    public void computeParameters(Channel channel, double width, double height) {
        if (width == 0.0 || height == 0.0) {
            return;
        }
        NumericMapper mapper = this.getMapper();
        if (mapper == null) {
            return;
        }
        if (!(mapper instanceof ContinuousRangeToNumericMapper)) {
            super.computeParameters(channel, width, height);
            return;
        }
        ContinuousRangeToNumericMapper cm = (ContinuousRangeToNumericMapper)mapper;
        GTKFormat format = cm.getFormat();
        if (format == null || !(format.getFormats()[0] instanceof SASDateTimeFormat)) {
            super.computeParameters(channel, width, height);
            return;
        }
        String orient = this.getAxisOrientation();
        boolean horzAxis = orient == "East" || orient == "West";
        double newLength = horzAxis ? width : height;
        Dimension margin = this.getMargin();
        Dimension minMargin = this.getMinimumMargin();
        if (horzAxis) {
            int resAxisAdj = this.getResAxisAdj().intValue();
            double len = newLength - (double)resAxisAdj;
            RectangularAxis axis = RectangularAxis.getXAxis((NumericMapper)cm, (double)len);
            AxisStyle axisStyle = axis.getStyle();
            com.sas.graphics.util.gtk.TextStyle titleTextStyle = axisStyle.getTitleStyle();
            titleTextStyle.setAngle(this.getTitleAngle().doubleValue());
            axisStyle.setLabelStaggerSpace(0.2);
            AxisModel axisModel = this.getAxisModel();
            TextStyle valueTextStyle = axisModel.getValueTextStyle();
            TextStyle labelTextStyle = axisModel.getLabelTextStyle();
            if (labelTextStyle != null) {
                titleTextStyle.setFont(labelTextStyle.getFont());
            }
            com.sas.graphics.util.gtk.TextStyle value = axisStyle.getLabelStyle();
            value.setFont(valueTextStyle.getFont());
            value.setFit(true);
            axisStyle.setTitleOn(this.getTitleOn().booleanValue());
            String title = this.getTitle();
            axis.title.setValue(title);
            cm.setOutputMax(cm.getOutputMin() + len);
            NumericVector tickValues = new NumericVector();
            StringVector tickLabels = new StringVector();
            for (int ii = 0; ii < this.values.length; ++ii) {
                if (!(this.values[ii] >= this.adjustedMin) || !(this.values[ii] <= this.adjustedMax)) continue;
                double aValue = cm.getValue(this.values[ii]);
                tickValues.addValue(aValue);
                if (this.outputFormat != null) {
                    tickLabels.addValue(this.outputFormat.format((Object)new Double(this.values[ii])));
                    continue;
                }
                tickLabels.addValue(new Double(this.values[ii]).toString());
            }
            axis.labelOffset.connectFrom((NumericPipe)tickValues);
            axis.labels.connectFrom((StringPipe)tickLabels);
            axis.setFitAlgorithm(TimeHorzFitAlg);
            axis.setTruncateStartCount(10);
            axis.setTruncateEndCount(10);
            axis.setStaggerThreshold(20);
            Vec3d maxSize = new Vec3d(width, height, 0.0);
            axis.setMaximumSize(maxSize);
            this.setMaximumSize(maxSize);
            AxisMetrics metrics = axis.getMetrics(channel);
            double offset = Math.ceil(metrics.getLowExtender());
            double length = metrics.getLineLength();
            if (this.getDiscrete().booleanValue()) {
                double unitSpace;
                if (this.adjustedMin == this.adjustedMax) {
                    unitSpace = newLength;
                    margin.width = (int)(unitSpace * 0.5);
                } else {
                    double left = (this.min - this.adjustedMin) / (this.adjustedMax - this.adjustedMin) * length;
                    double right = (this.adjustedMax - this.max) / (this.adjustedMax - this.adjustedMin) * length;
                    double graphLength = length - left - right;
                    int uniqueCount = (int)((this.max - this.min) / this.getMinIncrement()) + 1;
                    unitSpace = graphLength / (double)uniqueCount;
                    unitSpace = Math.min(Math.max(1.0, unitSpace), length);
                    margin.width = this.getMaximizeSpace() != false ? (int)(unitSpace * 0.5) : (int)Math.max(unitSpace * 0.5, offset);
                }
                margin.width = Math.max(margin.width, minMargin.width);
                this.setUnitLength(new Double(unitSpace));
            } else {
                margin.width = (int)Math.max(offset, (double)minMargin.width);
            }
            cm.setOutputMax(cm.getOutputMin() + (length -= (double)(2 * margin.width)));
            this.setLength(new Double(length));
            this.setCatAxisAdj(new Double(metrics.getOutsideLength()));
        }
        NumericVector tickValues = new NumericVector();
        StringVector tickLabels = new StringVector();
        for (int ii = 0; ii < this.values.length; ++ii) {
            if (!(this.values[ii] >= this.adjustedMin) || !(this.values[ii] <= this.adjustedMax)) continue;
            double aValue = cm.getValue(this.values[ii]);
            tickValues.addValue(aValue);
            if (this.outputFormat != null) {
                tickLabels.addValue(this.outputFormat.format((Object)new Double(this.values[ii])));
                continue;
            }
            tickLabels.addValue(new Double(this.values[ii]).toString());
        }
        this.setValues((NumericPipe)tickValues);
        this.setValueLabels((StringPipe)tickLabels);
        this.setFitAlgorithm(TimeHorzFitAlg);
    }

    protected ZxAxis.Interval computeInterval(int timeIntervalValue) {
        ZxAxis.Interval intvl = new ZxAxis.Interval();
        intvl.units = (char)(this.day ? 100 : 115);
        switch (timeIntervalValue) {
            case 10830: {
                intvl.intcode = 10;
                break;
            }
            case 10835: {
                intvl.intcode = 15;
                break;
            }
            case 10840: {
                intvl.intcode = 20;
                break;
            }
            case 10855: {
                intvl.intcode = 25;
                break;
            }
            case 10865: {
                intvl.intcode = 35;
                break;
            }
            case 10860: {
                intvl.intcode = 30;
                break;
            }
            case 10875: {
                intvl.intcode = 45;
                break;
            }
            case 10880: {
                intvl.intcode = 50;
                break;
            }
            case 10890: {
                intvl.intcode = 60;
            }
        }
        return intvl;
    }

    public boolean isDateValue() {
        return this.day;
    }
}

