/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.SummarizedVariableDefinition;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericTableModelVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.RelationalListSelectionVariable;
import com.sas.graphics.util.gtk.StringTableModelVariable;
import com.sas.graphics.util.gtk.SummarizedDataTableModelVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableException;
import com.sas.table.FormattedInterface;
import com.sas.text.Message;
import com.sas.text.SASUserDefinedFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.swing.table.TableModel;

public class TableModelVariableFactory
extends VariableFactory {
    public static final String RB_KEY = "TableModelVariableFactory.";
    private static int categorizationFormatIndex = 0;
    TableModel tableModel;

    public static SummarizedDataTableModelVariable newSummarizedDataTableModelVariable() {
        SummarizedDataTableModelVariable summarizedVariable = new SummarizedDataTableModelVariable();
        TableModelVariableFactory.applyNewVariableDefaults((Variable)summarizedVariable);
        return summarizedVariable;
    }

    public static NumericTableModelVariable newNumericTableModelVariable() {
        NumericTableModelVariable numericVariable = new NumericTableModelVariable();
        TableModelVariableFactory.applyNewVariableDefaults((Variable)numericVariable);
        return numericVariable;
    }

    public static StringTableModelVariable newStringTableModelVariable() {
        StringTableModelVariable stringVariable = new StringTableModelVariable();
        TableModelVariableFactory.applyNewVariableDefaults((Variable)stringVariable);
        return stringVariable;
    }

    public TableModelVariableFactory(TableModel newTableModel) {
        this(newTableModel, null, 10475);
    }

    public TableModelVariableFactory(TableModel newTableModel, Locale locale, int sortStrategy) {
        super(TableModelVariableFactory._determineFormatLocale(newTableModel, locale), sortStrategy);
        this.tableModel = newTableModel;
        TableModelVariableFactory.validate(this.tableModel);
    }

    @Override
    public boolean isOLAPData() {
        return false;
    }

    @Override
    public boolean isRelationalData() {
        return true;
    }

    private static Locale _determineFormatLocale(TableModel tm, Locale locale) {
        if (tm != null && "com.sas.storage.iquery.BusinessQueryToTableModelAdapter".equals(tm.getClass().getName())) {
            try {
                Method m = tm.getClass().getMethod("getFormatLocale", null);
                return (Locale)m.invoke((Object)tm, null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return locale;
    }

    private static void validate(TableModel tm) throws IllegalStateException {
    }

    @Override
    public Object getModel() {
        return this.tableModel;
    }

    @Override
    public Variable newVariable(VariableDefinition varDef) throws IllegalStateException {
        FrequencyVariable v = null;
        if (this.tableModel != null && varDef != null) {
            if (varDef instanceof FreqVariableDefinition) {
                v = this._newFrequencyVariable(varDef.getFormat(), varDef.getColumnLabel());
            } else if (varDef instanceof SelectionVariableDefinition) {
                v = new RelationalListSelectionVariable();
                ((RelationalListSelectionVariable)v).connectFrom(((SelectionVariableDefinition)varDef).getSelectionModel());
            } else {
                if (varDef.getColumnName() == null && varDef.getColumnIndex() == null) {
                    throw new IllegalStateException(Message.format((String)RB.getStringResource(RB_KEY, "unableToLocateDataColumn.fmt.txt"), (Object)null));
                }
                varDef.setColumnModelColumnInfo(new VariableDefinition.ModelColumnInfo());
                if (varDef instanceof SummarizedVariableDefinition) {
                    v = TableModelVariableFactory._newVariable(this.tableModel, this.getLocale(), this.getSortStrategy(), varDef.getColumnName(), varDef.getColumnIndex(), varDef.getFormat(), varDef.getInformat(), varDef.getColumnLabel(), ((SummarizedVariableDefinition)varDef).getFreqColumnName(), ((SummarizedVariableDefinition)varDef).getFreqColumnIndex(), ((SummarizedVariableDefinition)varDef).getVariableStatistic(), varDef.getVariant(), varDef.getColumnModelColumnInfo());
                } else {
                    RangeInfo[] rangeInfos;
                    CategorizationModel categorizationModel;
                    v = TableModelVariableFactory._newVariable(this.tableModel, this.getLocale(), this.getSortStrategy(), varDef.getColumnName(), varDef.getColumnIndex(), varDef.getFormat(), varDef.getInformat(), varDef.getColumnLabel(), varDef.getVariant(), varDef.getColumnModelColumnInfo());
                    if (varDef instanceof ClassificationVariableDefinition && (categorizationModel = varDef.getCategorizationModel()) != null && v instanceof NumericVariable && (rangeInfos = Util.categorize((NumericVariable)v, categorizationModel, this.getLocale())) != null) {
                        String catFormatName = "catFormat" + categorizationFormatIndex++ + "x";
                        String catFormatDef = "value " + catFormatName + " other = 'Out of Range'";
                        for (int ii = 0; ii < rangeInfos.length; ++ii) {
                            RangeInfo rangeInfo = rangeInfos[ii];
                            String rangeSpec = " " + rangeInfo.getStartValue() + "-" + rangeInfo.getEndValue() + "='" + rangeInfo.getFormattedRangeValue() + "'";
                            catFormatDef = catFormatDef + rangeSpec;
                        }
                        try {
                            SASUserDefinedFormat.createFormat((String)catFormatDef);
                            TableModelVariableFactory._applyFormat((Variable)v, catFormatName, this.getLocale());
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return v;
    }

    @Override
    public NumericVariable newHighVariable(VariableDefinition varDef) throws IllegalStateException {
        Variable v = null;
        if (varDef != null) {
            varDef.setHighColumnModelColumnInfo(new VariableDefinition.ModelColumnInfo());
            v = TableModelVariableFactory._newVariable(this.tableModel, this.getLocale(), this.getSortStrategy(), varDef.getHighColumnName(), varDef.getHighColumnIndex(), varDef.getFormat(), varDef.getInformat(), varDef.getHighLabel(), varDef.getVariant(), varDef.getHighColumnModelColumnInfo());
        }
        return (NumericVariable)(v instanceof NumericVariable ? v : null);
    }

    @Override
    public NumericVariable newLowVariable(VariableDefinition varDef) throws IllegalStateException {
        Variable v = null;
        if (varDef != null) {
            varDef.setLowColumnModelColumnInfo(new VariableDefinition.ModelColumnInfo());
            v = TableModelVariableFactory._newVariable(this.tableModel, this.getLocale(), this.getSortStrategy(), varDef.getLowColumnName(), varDef.getLowColumnIndex(), varDef.getFormat(), varDef.getInformat(), varDef.getLowLabel(), varDef.getVariant(), varDef.getLowColumnModelColumnInfo());
        }
        return (NumericVariable)(v instanceof NumericVariable ? v : null);
    }

    @Override
    public NumericVariable newTargetVariable(VariableDefinition varDef) throws IllegalStateException {
        Variable v = null;
        if (varDef != null) {
            varDef.setTargetColumnModelColumnInfo(new VariableDefinition.ModelColumnInfo());
            v = TableModelVariableFactory._newVariable(this.tableModel, this.getLocale(), this.getSortStrategy(), varDef.getTargetColumnName(), varDef.getTargetColumnIndex(), varDef.getFormat(), varDef.getInformat(), varDef.getTargetLabel(), varDef.getVariant(), varDef.getLowColumnModelColumnInfo());
        }
        return (NumericVariable)(v instanceof NumericVariable ? v : null);
    }

    private FrequencyVariable _newFrequencyVariable(String formatName, String label) {
        FrequencyVariable freq = new FrequencyVariable();
        freq.setLabel(label != null ? label : RB.getStringResource("frequency.txt"));
        TableModelVariableFactory._applyFormat((Variable)freq, formatName, this.getLocale());
        return freq;
    }

    private static Variable _newVariable(TableModel tableModel, Locale locale, int sortStrategy, String columnName, Integer columnIndex, String formatName, String informat, String label, int variant, VariableDefinition.ModelColumnInfo modelColumnInfo) throws IllegalStateException {
        return TableModelVariableFactory._newVariable(tableModel, locale, sortStrategy, columnName, columnIndex, formatName, informat, label, null, null, null, variant, modelColumnInfo);
    }

    private static int _validateDataColumn(TableModel tableModel, String columnName, Integer columnIndex) {
        int index = -1;
        if (tableModel != null) {
            int columnCount = tableModel.getColumnCount();
            if (columnName != null) {
                for (int ii = 0; index < 0 && ii < columnCount; ++ii) {
                    if (!columnName.equalsIgnoreCase(tableModel.getColumnName(ii))) continue;
                    index = ii;
                }
                if (index < 0) {
                    throw new IllegalStateException(Message.format((String)RB.getStringResource(RB_KEY, "unableToLocateDataColumn.fmt.txt"), (Object)columnName));
                }
            } else if (columnIndex != null) {
                index = columnIndex;
                if (index >= columnCount) {
                    index = -1;
                }
                if (index < 0) {
                    throw new IllegalStateException(Message.format((String)RB.getStringResource(RB_KEY, "unableToLocateDataColumnNumber.fmt.txt"), (Object)columnIndex));
                }
            }
        }
        return index;
    }

    private static Variable _newVariable(TableModel tableModel, Locale locale, int sortStrategy, String columnName, Integer columnIndex, String formatName, String informat, String label, String freqColumnName, Integer freqColumnIndex, Integer summarizedVariableStatistic, int variant, VariableDefinition.ModelColumnInfo modelColumnInfo) throws IllegalStateException {
        StringTableModelVariable v = null;
        if (tableModel != null) {
            boolean isNumericData;
            int index = TableModelVariableFactory._validateDataColumn(tableModel, columnName, columnIndex);
            if (index == -1) {
                return null;
            }
            Class columnType = Util.getTableModelColumnClass(tableModel, index);
            boolean bl = isNumericData = columnType == Date.class || columnType == Time.class || columnType == Timestamp.class || columnType == Number.class;
            if (isNumericData || (variant & 1) != 0 || informat != null && !"discrete".equals(informat)) {
                int index2 = TableModelVariableFactory._validateDataColumn(tableModel, freqColumnName, freqColumnIndex);
                if (index2 >= 0) {
                    SummarizedDataTableModelVariable summarizedVariable = TableModelVariableFactory.newSummarizedDataTableModelVariable();
                    TableModelVariableFactory.applySortStrategy((Variable)summarizedVariable, sortStrategy, locale);
                    summarizedVariable.setFormat(null);
                    summarizedVariable.setStatisticType(AnalysisVariableDefinition.asGTKStatistic(summarizedVariableStatistic));
                    try {
                        summarizedVariable.connectFrom(tableModel, index, index2);
                        v = summarizedVariable;
                    }
                    catch (VariableException e) {
                        System.err.println(e.getMessage());
                    }
                } else {
                    NumericTableModelVariable numericVariable = TableModelVariableFactory.newNumericTableModelVariable();
                    TableModelVariableFactory.applySortStrategy((Variable)numericVariable, sortStrategy, locale);
                    if (informat != null) {
                        try {
                            numericVariable.setInformat(informat);
                        }
                        catch (IllegalArgumentException e) {
                            String message = Message.format((String)RB.getStringResource("inFormatNotSupported.fmt.txt"), (Object)informat.trim());
                            throw new IllegalStateException(message);
                        }
                    }
                    try {
                        numericVariable.connectFrom(tableModel, index);
                        v = numericVariable;
                    }
                    catch (VariableException e) {
                        System.err.println(e.getMessage());
                    }
                }
            } else {
                StringTableModelVariable stringVariable = TableModelVariableFactory.newStringTableModelVariable();
                TableModelVariableFactory.applySortStrategy((Variable)stringVariable, sortStrategy, locale);
                try {
                    stringVariable.connectFrom(tableModel, index);
                    v = stringVariable;
                }
                catch (VariableException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (v != null) {
                String message;
                String dataSetFormat;
                v.setCalculateUniqueValuesByFormattedValue((variant & 0x10) == 0);
                if (modelColumnInfo != null) {
                    modelColumnInfo.setColumnIndex(index);
                    modelColumnInfo.setColumnName(tableModel.getColumnName(index));
                }
                v.setLabel(label != null ? label : tableModel.getColumnName(index));
                GTKFormat appliedFormat = TableModelVariableFactory._applyFormat((Variable)v, formatName, locale);
                if (appliedFormat == null && tableModel instanceof FormattedInterface && (dataSetFormat = ((FormattedInterface)tableModel).getFormat(index)) != null && (appliedFormat = TableModelVariableFactory._applyFormat((Variable)v, dataSetFormat, locale)) != null) {
                    if (modelColumnInfo != null) {
                        modelColumnInfo.setColumnFormat(dataSetFormat);
                    }
                    if (formatName != null && formatName.trim().length() > 0) {
                        message = Message.format((String)RB.getStringResource(RB_KEY, "formatNotSupportedRevertToFormattedInterfaceFormat.fmt.txt"), (Object)formatName.trim(), (Object)dataSetFormat.trim());
                        System.err.println(message);
                    }
                }
                if (appliedFormat == null) {
                    String defaultFormat = null;
                    if (columnType == Number.class) {
                        defaultFormat = "Best";
                    } else if (columnType == Date.class) {
                        defaultFormat = "Date9";
                    } else if (columnType == Time.class || columnType == Timestamp.class) {
                        defaultFormat = "DateTime18";
                    }
                    if (defaultFormat != null && (appliedFormat = TableModelVariableFactory._applyFormat((Variable)v, defaultFormat, locale)) != null && formatName != null && formatName.trim().length() > 0) {
                        message = Message.format((String)RB.getStringResource(RB_KEY, "formatNotSupportedRevertToDefaultFormat.fmt.txt"), (Object)formatName.trim(), (Object)defaultFormat.trim());
                        System.err.println(message);
                    }
                }
            }
        }
        return v;
    }

    @Override
    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="this is legacy code and require major restructuring for this violation")
    public Object clone() {
        return new TableModelVariableFactory(this.tableModel, this.getLocale(), this.getSortStrategy());
    }
}

