/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.NetworkComponent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;

public class StringComponent
extends NetworkComponent
implements MouseListener {
    private final transient String text;
    private final transient TextStyle textStyle;
    private final transient ListSelectionModel selectionModel;
    private final transient int[] selectionIndexes;
    private final transient ActionUIFactory actionUIFactory;
    private final transient ActionSupportFilter actionSupportFilter;
    private final transient SwingActionProvider actionProvider;
    private final transient Map actionSupportFilterAttributes;
    private final transient OLAPDataSetInterface olapDataSet;
    private transient int textAngle = 0;
    private transient int automaticJustification = 0;
    private final transient CellNodeInfo cellNodeInfo;
    private RasterLabel rasterLabel;
    protected Image skin;
    private Dimension minimumSize = null;
    private Dimension preferredSizeCache = null;

    public StringComponent(String text, Channel channel) {
        this(text, null, null, null, null, null, null, null, null, null, channel);
    }

    public StringComponent(String text, TextStyle textStyle, CellNodeInfo cellNodeInfo, Channel channel) {
        this(text, textStyle, null, null, null, null, null, null, null, cellNodeInfo, channel);
    }

    public StringComponent(String text, TextStyle textStyle, CellNodeInfo cellNodeInfo, Channel channel, Image skin) {
        this(text, textStyle, null, null, null, null, null, null, null, cellNodeInfo, channel);
        this.skin = skin;
        if (skin != null) {
            this.setOpaque(false);
        }
    }

    public StringComponent(String text, TextStyle textStyle, ListSelectionModel selectionModel, int[] selectionIndexes, ActionUIFactory actionUIFactory, ActionSupportFilter actionSupportFilter, SwingActionProvider actionProvider, Map actionSupportFilterAttributes, OLAPDataSetInterface olapDataSet, CellNodeInfo cellNodeInfo, Channel channel) {
        super(channel);
        if (textStyle == null) {
            textStyle = new TextStyle();
        }
        this.text = text = textStyle.isVisible() && text != null ? text.trim() : null;
        this.textStyle = textStyle;
        this.selectionModel = selectionModel;
        this.selectionIndexes = selectionIndexes;
        this.actionUIFactory = actionUIFactory;
        this.actionSupportFilter = actionSupportFilter;
        this.actionProvider = actionProvider;
        this.actionSupportFilterAttributes = actionSupportFilterAttributes;
        this.olapDataSet = olapDataSet;
        CellNodeInfo cellNodeInfo2 = this.cellNodeInfo = cellNodeInfo != null ? cellNodeInfo : new CellNodeInfo(this.getBackground(), false, false);
        if (this.cellNodeInfo.backgroundColor != null) {
            this.setBackground(this.cellNodeInfo.backgroundColor);
            this.setOpaque(this.cellNodeInfo.backgroundColor.getAlpha() == 255);
        } else {
            this.setOpaque(false);
        }
        this.addMouseListener(this);
        this.setToolTipText(" " + text + " ");
        this.rasterLabel = StringComponent._newRasterLabel(text, textStyle, this.textAngle, this.cellNodeInfo.isAssumeWeKnowMoreAboutTheTextColorThanTheUserEnabled);
        if (this.textStyle instanceof AdvancedTextStyle) {
            this._applyTextAngle(((AdvancedTextStyle)this.textStyle).getBaselineAngle());
        }
        this.getComposite().addElement((Element)this.rasterLabel);
    }

    private void _applyTextAngle(double angle) {
        if (Double.isNaN(angle) || Double.isInfinite(angle)) {
            angle = 0.0;
        }
        switch ((int)(Math.round(angle / 90.0) * 90L)) {
            case 90: {
                angle = 90.0;
                break;
            }
            case 270: {
                angle = 270.0;
                break;
            }
            default: {
                angle = 0.0;
            }
        }
        if ((double)this.textAngle != angle) {
            this.textAngle = (int)angle;
            this.rasterLabel.angle.setValue((double)this.textAngle);
            this.preferredSizeCache = null;
        }
    }

    public boolean setTextAngle(double angle) {
        double a;
        if (this.textStyle instanceof AdvancedTextStyle && !Double.isNaN(a = ((AdvancedTextStyle)this.textStyle).getBaselineAngle()) && !Double.isInfinite(a)) {
            return Util.Evaluate.isEqual(a, angle);
        }
        this._applyTextAngle(angle);
        return true;
    }

    @Override
    public void setTextAntiAliasingEnabled(boolean b) {
        boolean old = this.isTextAntiAliasingEnabled();
        super.setTextAntiAliasingEnabled(b);
        if (old != this.isTextAntiAliasingEnabled()) {
            this.preferredSizeCache = null;
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("border".equals(propertyName)) {
            this.preferredSizeCache = null;
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final void setAutomaticJustification(int automaticJustification) {
        switch (automaticJustification) {
            case 0: 
            case 2: 
            case 4: {
                this.automaticJustification = automaticJustification;
            }
        }
    }

    public final int getAutomaticJustification() {
        return this.automaticJustification;
    }

    @Override
    public String getName() {
        return this.text;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g != null && this.cellNodeInfo.backgroundColor != null && !this.isOpaque()) {
            Rectangle b = this.getBounds();
            Insets i = this.getInsets();
            if (b != null) {
                if (i != null) {
                    b.x = i.left;
                    b.y = i.top;
                    b.width = b.width - i.left - i.right;
                    b.height = b.height - i.top - i.bottom;
                } else {
                    b.x = 0;
                    b.y = 0;
                    --b.width;
                    --b.height;
                }
                g.setColor(this.cellNodeInfo.backgroundColor);
                g.fillRect(b.x, b.y, b.width, b.height);
            }
        }
        this.paintSkin(g);
        super.paintComponent(g);
    }

    public void paintSkin(Graphics g) {
        if (g == null || this.skin == null) {
            return;
        }
        Rectangle b = this.getBounds();
        Insets i = this.getInsets();
        if (b == null) {
            return;
        }
        if (i != null) {
            b.x = i.left;
            b.y = i.top;
            b.width = b.width - i.left - i.right;
            b.height = b.height - i.top - i.bottom;
        } else {
            b.x = 0;
            b.y = 0;
            --b.width;
            --b.height;
        }
        if (this.skin != null) {
            Color c = g.getColor();
            g.setColor(this.cellNodeInfo.backgroundColor);
            g.fillRect(b.x, b.y, b.width, b.height);
            g.drawImage(this.skin, b.x, b.y, b.width, b.height, this);
            g.setColor(c);
        }
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public String getText() {
        return this.text;
    }

    protected void updateNetwork() {
        int displayText_Extent;
        int availExtent;
        Rectangle b = this.getBounds();
        Channel channel = this.getChannel();
        if (channel == null || b.width < 1 || b.height < 1) {
            return;
        }
        this.updateChannel();
        Rectangle r = new Rectangle(0, 0, b.width, b.height);
        Insets insets = this.getInsets();
        r.x = insets.left;
        r.y = insets.top;
        r.width -= insets.left + insets.right;
        r.height -= insets.top + insets.bottom;
        Insets innerMargin = null;
        if (this.getAlignableComponentConstraints() != null) {
            innerMargin = this.getAlignableComponentConstraints().getInnerMargin();
            Insets outerMargin = this.getAlignableComponentConstraints().getOuterMargin();
            if (outerMargin != null) {
                r.x += outerMargin.left;
                r.y += outerMargin.top;
                r.width -= outerMargin.left + outerMargin.right;
                r.height -= outerMargin.top + outerMargin.bottom;
            }
        }
        int n = availExtent = this.textAngle == 0 ? r.width : r.height;
        if (innerMargin != null) {
            availExtent = this.textAngle == 0 ? (availExtent -= innerMargin.left + innerMargin.right) : (availExtent -= innerMargin.top + innerMargin.bottom);
        }
        this.rasterLabel.string.setValue(this.text);
        this.rasterLabel.horizontalJustification.setValue(1);
        this.rasterLabel.maxWidth.setValue((double)r.width);
        this.rasterLabel.maxHeight.setValue((double)r.height);
        Dimension rasterLabelSize = this._computeRasterLabelSize(this.rasterLabel);
        String displayText = this.text;
        int n2 = displayText_Extent = this.textAngle == 0 ? (displayText_Extent = rasterLabelSize.width) : rasterLabelSize.height;
        if (displayText != null) {
            int text_CharacterCount;
            int displayText_CharacterCount = text_CharacterCount = this.text != null ? this.text.length() : 0;
            int displayText_PrefixCharacterCount = (displayText_CharacterCount + 1) / 2;
            int displayText_PostfixCharacterCount = displayText_CharacterCount - displayText_PrefixCharacterCount;
            while (displayText_Extent > availExtent && displayText_CharacterCount > 0) {
                if (text_CharacterCount <= --displayText_CharacterCount) continue;
                displayText_PrefixCharacterCount = (displayText_CharacterCount + 1) / 2;
                displayText_PostfixCharacterCount = displayText_CharacterCount - displayText_PrefixCharacterCount;
                displayText = this.text.substring(0, displayText_PrefixCharacterCount) + "..." + this.text.substring(this.text.length() - displayText_PostfixCharacterCount, this.text.length());
                this.rasterLabel.string.setValue(displayText);
                rasterLabelSize = this._computeRasterLabelSize(this.rasterLabel);
                displayText_Extent = this.textAngle == 0 ? rasterLabelSize.width : rasterLabelSize.height;
            }
        }
        double transX = 0.0;
        double transY = 0.0;
        transY = (double)r.y + (double)r.height / 2.0;
        double halfLabelSizeX = (double)rasterLabelSize.width / 2.0;
        switch (this.textStyle.getJustification()) {
            default: {
                transX = (double)r.x + (double)r.width / 2.0;
                if (innerMargin == null || !(transX - halfLabelSizeX < (double)(r.x + innerMargin.left))) break;
                transX = (double)(r.x + innerMargin.left) + halfLabelSizeX;
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                transX = (double)(r.x + r.width) - halfLabelSizeX;
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                transX = (double)(innerMargin != null ? r.x + innerMargin.left : r.x) + halfLabelSizeX;
            }
        }
        transY = (double)b.height - transY;
        if (this.textAngle == 0) {
            transY += 1.0;
        } else if (this.textAngle == 90) {
            transX -= 1.0;
        }
        this.rasterLabel.transform.translateX.setValue(transX);
        this.rasterLabel.transform.translateY.setValue(transY);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.updateNetwork();
    }

    private static RasterLabel _newRasterLabel(String textString, TextStyle textStyle, int textAngle, boolean assumeWeKnowMoreAboutTheTextColorThanTheUser) {
        RasterLabel rl = new RasterLabel();
        rl.string.setValue(textString);
        rl.setFont(textStyle.getFont());
        ShadowStyle shadowStyle = textStyle.getShadowStyle();
        rl.shadowOn.setValue(shadowStyle.isVisible());
        if (shadowStyle.isVisible()) {
            rl.shadowColor.setValue(shadowStyle.getColor());
            rl.shadowOffsetX.setValue((int)Math.round(shadowStyle.getOffsetX().getMagnitude((Object)"px")));
            rl.shadowOffsetY.setValue((int)Math.round(shadowStyle.getOffsetY().getMagnitude((Object)"py")));
        }
        rl.color.setValue(StringComponent._newTextColor(textStyle.getColor(), assumeWeKnowMoreAboutTheTextColorThanTheUser));
        rl.angle.setValue((double)textAngle);
        rl.verticalJustification.setValue(1);
        rl.fit.setValue(false);
        return rl;
    }

    private static Color _newTextColor(Color color, boolean assumeWeKnowMoreAboutTheTextColorThanTheUser) {
        float lum;
        if (assumeWeKnowMoreAboutTheTextColorThanTheUser && (lum = 0.299f * (float)color.getRed() + 0.587f * (float)color.getGreen() + 0.114f * (float)color.getBlue()) > 145.0f) {
            return Color.white;
        }
        return color;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            if (this.textStyle.getFont().getSize() > 8) {
                TextStyle minTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(this.textStyle, new TextStyle());
                Font f = minTextStyle.getFont();
                f = new Font(f.getFontName(), f.getStyle(), 8);
                minTextStyle.setFont(f);
                RasterLabel minRasterLabel = StringComponent._newRasterLabel(this.text, minTextStyle, this.textAngle, this.cellNodeInfo.isAssumeWeKnowMoreAboutTheTextColorThanTheUserEnabled);
                this.minimumSize = this._computeComponentSize(minRasterLabel);
            } else {
                this.minimumSize = this.getPreferredSize();
            }
        }
        return this.minimumSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSizeCache == null) {
            this.preferredSizeCache = this._computeComponentSize(this.rasterLabel);
        }
        return this.preferredSizeCache;
    }

    private Dimension _computeComponentSize(RasterLabel rl) {
        Dimension size = this._computeRasterLabelSize(rl);
        Insets insets = this.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        size.width += size.width % 2;
        size.height += size.height % 2;
        return size;
    }

    private Dimension _computeRasterLabelSize(RasterLabel rl) {
        Channel channel = this.getChannel();
        this.updateChannel();
        if (this.isTextAntiAliasingEnabled()) {
            this.getChannel().glEnable(14);
        } else {
            this.getChannel().glDisable(14);
        }
        ComputeBoundingBoxAction action = new ComputeBoundingBoxAction(channel);
        try {
            rl.getBoundingBox((AComputeBoundingBoxAction)action);
        }
        catch (MissingValueException e) {
            return new Dimension(0, 0);
        }
        int spacer = 2;
        Vec3d elemSize = action.getElementBoundingBox().getSize();
        if (this.textAngle == 0) {
            return new Dimension((int)Math.round(elemSize.x) + spacer, (int)Math.round(elemSize.y));
        }
        return new Dimension((int)Math.round(elemSize.x), (int)Math.round(elemSize.y) + spacer);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.performSelection(e);
        } else if (e.getButton() == 3 && this.olapDataSet != null) {
            this.performOLAPAction(e);
        }
    }

    private void performSelection(MouseEvent e) {
        if (this.selectionModel != null && this.selectionIndexes != null) {
            if ((e.getModifiers() & 2) == 0) {
                this.selectionModel.clearSelection();
            }
            this.selectionModel.setValueIsAdjusting(true);
            for (int ii = 0; ii < this.selectionIndexes.length; ++ii) {
                this.selectionModel.addSelectionInterval(this.selectionIndexes[ii], this.selectionIndexes[ii]);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }
    }

    private void performOLAPAction(MouseEvent e) {
        try {
            if (this.actionProvider != null) {
                this.actionSupportFilter.setAttribute("model", (Object)this.olapDataSet);
                this.actionSupportFilter.setAttributes(this.actionSupportFilterAttributes);
                ActionList actions = this.actionProvider.getActions(this.actionSupportFilter);
                JPopupMenu popup = this.actionUIFactory.getPopupMenu((com.sas.swing.util.ActionList)actions);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        catch (AttributeSetException exp) {
            exp.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = super.createToolTip();
        Color background = new Color(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue());
        toolTip.setBackground(background);
        if (this.textStyle != null) {
            toolTip.setForeground(this.textStyle.getColor());
            toolTip.setFont(this.textStyle.getFont());
        }
        return toolTip;
    }

    public static void applyAutomaticJustification(HierarchicalPane pane, int automaticJustification) {
        if (pane != null) {
            int componentCount = pane.contentPanel.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                JComponent component = (JComponent)pane.contentPanel.getComponent(i);
                if (!(component instanceof StringComponent)) continue;
                ((StringComponent)component).setAutomaticJustification(automaticJustification);
            }
        }
    }

    protected boolean canFrameBeTurnedOff() {
        return this.cellNodeInfo.backgroundRepresentsValue;
    }

    static class CellNodeInfo {
        public final Color backgroundColor;
        public final boolean isAssumeWeKnowMoreAboutTheTextColorThanTheUserEnabled;
        public final boolean backgroundRepresentsValue;

        public CellNodeInfo(Color backgroundColor, boolean backgroundRepresentsValue, boolean isAssumeWeKnowMoreAboutTheTextColorThanTheUserEnabled) {
            this.backgroundColor = backgroundColor;
            this.backgroundRepresentsValue = backgroundRepresentsValue;
            this.isAssumeWeKnowMoreAboutTheTextColorThanTheUserEnabled = isAssumeWeKnowMoreAboutTheTextColorThanTheUserEnabled;
        }
    }
}

