/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericTableModelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.rpf.ContextInterface;
import com.sas.rpf.RuleInterface;
import com.sas.rpf.data.DataVector;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.NumericValue;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.Variable;
import com.sas.rpf.expr.EvaluateException;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.ChainedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class RPFUtil {
    public static String applyExceptionHighlighting(DataSource dataSource, ContextInterface rulesContext) {
        if (dataSource == null || rulesContext == null) {
            return null;
        }
        DataSource rootDataSource = dataSource.getRootDataSource();
        rootDataSource.setRulesContext(rulesContext);
        ListSelectionModel rootSelectionModel = rootDataSource.getSelectionModel();
        String rv = null;
        rv = rootDataSource.getModel() instanceof OLAPDataSetInterface ? RPFUtil.applyExceptionHighlighting((OLAPDataSetInterface)rootDataSource.getModel(), rootDataSource, rulesContext, rootSelectionModel) : RPFUtil.applyExceptionHighlighting((TableModel)rootDataSource.getModel(), rulesContext, rootSelectionModel);
        return rv;
    }

    private static String applyExceptionHighlighting(TableModel data, ContextInterface rulesContext, ListSelectionModel selectionList) {
        if (data == null || rulesContext == null || selectionList == null) {
            return null;
        }
        selectionList.clearSelection();
        if (rulesContext.isEmpty()) {
            return null;
        }
        boolean useResultSetID = true;
        selectionList.setValueIsAdjusting(true);
        Collection rules = rulesContext.getRules();
        for (RuleInterface curRule : rules) {
            if (curRule == null) continue;
            Set ruleVars = null;
            try {
                ruleVars = curRule.extractVariables();
            }
            catch (EvaluateException e1) {
                e1.printStackTrace();
            }
            NumericTableModelVariable[] gtkVars = new NumericTableModelVariable[ruleVars.size()];
            Iterator varIt = ruleVars.iterator();
            int varNum = 0;
            while (varIt.hasNext()) {
                Variable curRPFVar = (Variable)varIt.next();
                gtkVars[varNum] = new NumericTableModelVariable();
                String colName = RPFUtil.getValidColumnName(data, curRPFVar.getName());
                if (RPFUtil.findColumnIndex(data, colName) < 0) {
                    rulesContext.remove(curRule);
                    return null;
                }
                gtkVars[varNum].connectFrom(data, colName);
                ++varNum;
            }
            int numCols = gtkVars.length;
            for (int i = 0; i < data.getRowCount(); ++i) {
                DataVector dataVec = new DataVector();
                for (int j = 0; j < numCols; ++j) {
                    String name = gtkVars[j].getResultSetId();
                    if (name == null) {
                        name = gtkVars[j].getName();
                        useResultSetID = false;
                    }
                    MissingValue value = null;
                    try {
                        value = new NumericValue(gtkVars[j].value.getValue(i));
                    }
                    catch (MissingValueException e2) {
                        value = new MissingValue();
                    }
                    dataVec.setValue(name, (ValueInterface)value);
                }
                try {
                    if (!curRule.execute((DataVectorInterface)dataVec)) continue;
                    selectionList.addSelectionInterval(i, i);
                    continue;
                }
                catch (ChainedException chainedException) {
                    // empty catch block
                }
            }
        }
        selectionList.setValueIsAdjusting(false);
        return (useResultSetID ? "_R_" : "_L_") + RPFUtil.getTargetRPFVariable(rulesContext).getName();
    }

    private static int findColumnIndex(TableModel data, String colName) {
        for (int i = 0; i < data.getColumnCount(); ++i) {
            if (!colName.equals(data.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    private static String getValidColumnName(TableModel data, String name) {
        String colName = NumericTableModelVariable.getColumnName((TableModel)data, (String)name);
        if (colName == null) {
            colName = name;
        }
        return colName;
    }

    private static String getValidColumnName(OLAPVariableFactory ovf, String name) {
        String colName = ovf.getUniqueLevelName(name);
        if (colName == null) {
            colName = name;
        }
        return colName;
    }

    private static String applyExceptionHighlighting(OLAPDataSetInterface data, DataSource dataSource, ContextInterface rulesContext, ListSelectionModel selectionList) {
        if (data == null || rulesContext == null || selectionList == null) {
            return null;
        }
        if (dataSource == null || !dataSource.isOLAPData()) {
            return null;
        }
        selectionList.clearSelection();
        if (rulesContext.isEmpty()) {
            return null;
        }
        boolean useResultSetID = true;
        selectionList.setValueIsAdjusting(true);
        DataSource rootDataSource = dataSource.getRootDataSource();
        OLAPVariableFactory ovf = rootDataSource.getRootDataSource().getGTKOLAPVariableFactory();
        List allMeasureNames = ovf.getMeasureNames();
        Collection rules = rulesContext.getRules();
        for (RuleInterface curRule : rules) {
            Set ruleVars = null;
            try {
                ruleVars = curRule.extractVariables();
            }
            catch (EvaluateException e1) {
                e1.printStackTrace();
            }
            OLAPMeasureVariable[] gtkVars = new OLAPMeasureVariable[ruleVars.size()];
            Iterator varIt = ruleVars.iterator();
            int varNum = 0;
            while (varIt.hasNext()) {
                Variable curRPFVar = (Variable)varIt.next();
                gtkVars[varNum] = new OLAPMeasureVariable();
                String measureName = RPFUtil.getValidColumnName(ovf, curRPFVar.getName());
                if (!allMeasureNames.contains(measureName)) {
                    rulesContext.remove(curRule);
                    selectionList.setValueIsAdjusting(false);
                    return null;
                }
                gtkVars[varNum] = ovf.newMeasureVariable(measureName);
                ++varNum;
            }
            int numVars = gtkVars.length;
            for (int i = 0; i < gtkVars[0].getValueCount(); ++i) {
                int j;
                DataVector dataVec = new DataVector();
                for (j = 0; j < numVars; ++j) {
                    String name = gtkVars[j].getResultSetId();
                    if (name == null) {
                        name = gtkVars[j].getName();
                        useResultSetID = false;
                    }
                    MissingValue value = null;
                    try {
                        value = new NumericValue(gtkVars[j].value.getValue(i));
                    }
                    catch (MissingValueException e4) {
                        value = new MissingValue();
                    }
                    dataVec.setValue(name, (ValueInterface)value);
                }
                for (j = 0; j < numVars; ++j) {
                    int cellIndex = gtkVars[j].getCellIndex(i);
                    try {
                        ResultSetMetadataInterface rsMeta = data.getResultSetMetadata();
                        int[] tupleCoords = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)rsMeta, (int)cellIndex);
                        AxisInterface[] axes = rsMeta.getAxes(0, -1);
                        for (int axisIndex = 0; axisIndex < tupleCoords.length; ++axisIndex) {
                            AxisInterface axis = axes[axisIndex];
                            TupleInterface t = axis.getTuple(tupleCoords[axisIndex]);
                            TupleElementInterface[] tes = t.getElements(0, -1);
                            RPFUtil.addLevels(dataVec, tes);
                        }
                    }
                    catch (OLAPException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (!curRule.execute((DataVectorInterface)dataVec)) continue;
                        selectionList.addSelectionInterval(cellIndex, cellIndex);
                        continue;
                    }
                    catch (ChainedException chainedException) {
                        // empty catch block
                    }
                }
            }
        }
        selectionList.setValueIsAdjusting(false);
        return (useResultSetID ? "_R_" : "_L_") + RPFUtil.getTargetRPFVariable(rulesContext).getName();
    }

    private static void addLevels(DataVector dataVector, TupleElementInterface[] tuples) throws OLAPException {
        for (int i = 0; i < tuples.length; ++i) {
            TupleElementInterface tuple = tuples[i];
            if (tuple.getType() == TupleElementType.MEASURE) continue;
            String uLevelName = tuple.getUniqueLevelName();
            int index1 = uLevelName.indexOf(93, 1);
            String dim = uLevelName.substring(1, index1);
            int index2 = uLevelName.indexOf(93, index1 + 1);
            String hierarchy = uLevelName.substring(index1 + 3, index2);
            int index3 = uLevelName.indexOf(93, index2 + 1);
            String level = null;
            if (index3 < 0) {
                level = hierarchy;
                hierarchy = "*";
                String startingDim = uLevelName.substring(0, index1 + 1);
                hierarchy = RPFUtil.findHierarchyForDimension(tuple, startingDim);
            } else {
                level = uLevelName.substring(index2 + 3, index3);
            }
            dataVector.setDrillLevel(dim, hierarchy, level);
        }
    }

    private static String findHierarchyForDimension(TupleElementInterface tuple, String startingDim) throws OLAPException {
        String[] hiers = tuple.getTuple().getAxis().getHierarchyNames();
        for (int j = 0; j < hiers.length; ++j) {
            String hier = hiers[j];
            if (!hier.startsWith(startingDim)) continue;
            return hier.substring(startingDim.length() + 2, hier.length() - 1);
        }
        return null;
    }

    public static Variable getTargetRPFVariable(ContextInterface rulesContext) {
        if (rulesContext == null || rulesContext.isEmpty()) {
            return null;
        }
        Collection rules = rulesContext.getRules();
        Iterator ruleIt = rules.iterator();
        RuleInterface curRule = null;
        if (ruleIt.hasNext()) {
            curRule = (RuleInterface)ruleIt.next();
        }
        Set ruleVars = null;
        try {
            ruleVars = curRule.extractVariables();
        }
        catch (EvaluateException e1) {
            e1.printStackTrace();
        }
        Iterator varIt = ruleVars.iterator();
        Variable firstVar = null;
        if (varIt.hasNext()) {
            firstVar = (Variable)varIt.next();
        }
        return firstVar;
    }

    public static String containsRuleTargetVariableNameID(DataSource dataSource, String role, String prefixedRuleTargetVariableNameID) {
        String[] variableNameIDs;
        if (dataSource == null || role == null || prefixedRuleTargetVariableNameID == null) {
            return null;
        }
        String[] variableColumnNames = dataSource.getVariableColumnNames(role);
        Object object = prefixedRuleTargetVariableNameID.startsWith("_L_") ? variableColumnNames : (variableNameIDs = prefixedRuleTargetVariableNameID.startsWith("_R_") ? dataSource.getVariableResultSetIDs(role) : null);
        if (variableNameIDs == null) {
            return null;
        }
        String ruleVariableNameID = prefixedRuleTargetVariableNameID.substring(3);
        for (int i = 0; i < variableNameIDs.length; ++i) {
            if (!ruleVariableNameID.equals(variableNameIDs[i])) continue;
            return variableColumnNames[i];
        }
        return null;
    }

    public static String containsRuleTargetVariableNameID(DataSource dataSource, String[] roles, String prefixedRuleTargetVariableNameID) {
        String ruleVariableNameID = null;
        if (roles != null) {
            for (int i = 0; ruleVariableNameID == null && i < roles.length; ++i) {
                ruleVariableNameID = RPFUtil.containsRuleTargetVariableNameID(dataSource, roles[i], prefixedRuleTargetVariableNameID);
            }
        }
        return ruleVariableNameID;
    }
}

