/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.RB;
import com.sas.text.Message;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.JScrollBar;

public class MatrixLayout
implements LayoutManager2,
Serializable {
    public static final String RB_KEY = "MatrixLayout.";
    int hgap;
    int vgap;
    public static final String NORTH = "North";
    public static final String NORTH1 = "North";
    public static final String NORTH2 = "North2";
    public static final String NORTH3 = "North3";
    public static final String NORTH4 = "North4";
    public static final String NORTH5 = "North5";
    private static final String[] NORTHS = new String[]{"North", "North2", "North3", "North4", "North5"};
    public static final String SOUTH = "South";
    public static final String SOUTH1 = "South";
    public static final String SOUTH2 = "South2";
    public static final String SOUTH3 = "South3";
    public static final String SOUTH4 = "South4";
    public static final String SOUTH5 = "South5";
    private static final String[] SOUTHS = new String[]{"South", "South2", "South3", "South4", "South5"};
    public static final String EAST = "East";
    public static final String EAST1 = "East";
    public static final String EAST2 = "East2";
    public static final String EAST3 = "East3";
    public static final String EAST4 = "East4";
    public static final String EAST5 = "East5";
    private static final String[] EASTS = new String[]{"East", "East2", "East3", "East4", "East5"};
    public static final String WEST = "West";
    public static final String WEST1 = "West";
    public static final String WEST2 = "West2";
    public static final String WEST3 = "West3";
    public static final String WEST4 = "West4";
    public static final String WEST5 = "West5";
    private static final String[] WESTS = new String[]{"West", "West2", "West3", "West4", "West5"};
    public static final String CENTER = "Center";
    Component[] norths = new Component[NORTHS.length];
    Component[] wests = new Component[WESTS.length];
    Component[] easts = new Component[EASTS.length];
    Component[] souths = new Component[SOUTHS.length];
    Component center;
    private boolean scrollBarsEnabled = true;
    int prefCenterWidth;
    int prefCenterHeight;

    public MatrixLayout() {
        this(0, 0);
    }

    public MatrixLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void setScrollBarsEnabled(boolean b) {
        this.scrollBarsEnabled = b;
    }

    public boolean getScrollBarsEnabled() {
        return this.scrollBarsEnabled;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException(RB.getStringResource("notAStringConstraint.ex.txt"));
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    private int _indexOf(String[] sa, String v) {
        if (sa != null && v != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                if (!v.equals(sa[ii])) continue;
                return ii;
            }
        }
        return -1;
    }

    private int _indexOf(Component[] sa, Component v) {
        if (sa != null && v != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                if (v != sa[ii]) continue;
                return ii;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int index = -1;
            if (name == null || CENTER.equals(name)) {
                this.center = comp;
            } else {
                index = this._indexOf(NORTHS, name);
                if (index >= 0) {
                    this.norths[index] = comp;
                } else {
                    index = this._indexOf(SOUTHS, name);
                    if (index >= 0) {
                        this.souths[index] = comp;
                    } else {
                        index = this._indexOf(EASTS, name);
                        if (index >= 0) {
                            this.easts[index] = comp;
                        } else {
                            index = this._indexOf(WESTS, name);
                            if (index >= 0) {
                                this.wests[index] = comp;
                            } else {
                                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "unknownConstraint.ex.txt") + name);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int index = -1;
            if (comp == this.center) {
                this.center = null;
            } else {
                index = this._indexOf(this.norths, comp);
                if (index >= 0) {
                    this.norths[index] = null;
                } else {
                    index = this._indexOf(this.souths, comp);
                    if (index >= 0) {
                        this.souths[index] = null;
                    } else {
                        index = this._indexOf(this.easts, comp);
                        if (index >= 0) {
                            this.easts[index] = null;
                        } else {
                            index = this._indexOf(this.wests, comp);
                            if (index >= 0) {
                                this.wests[index] = null;
                            }
                        }
                    }
                }
            }
        }
    }

    private Dimension _maxPreferredSize(Component[] sa) {
        return this._maxSize(true, sa);
    }

    private Dimension _maxMinimumSize(Component[] sa) {
        return this._maxSize(false, sa);
    }

    private Dimension _maxSize(boolean preferred, Component[] sa) {
        int w = 0;
        int h = 0;
        if (sa != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                if (sa[ii] == null || !sa[ii].isVisible()) continue;
                Dimension size = preferred ? sa[ii].getPreferredSize() : sa[ii].getMinimumSize();
                w = Math.max(size.width, w);
                h = Math.max(size.height, h);
            }
        }
        return new Dimension(w, h);
    }

    private Dimension _sumPreferredSize(Component[] sa) {
        return this._sumSize(true, sa);
    }

    private Dimension _sumMinimumSize(Component[] sa) {
        return this._sumSize(false, sa);
    }

    private Dimension _sumSize(boolean preferred, Component[] sa) {
        int w = 0;
        int h = 0;
        if (sa != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                if (sa[ii] == null || !sa[ii].isVisible()) continue;
                Dimension size = preferred ? sa[ii].getPreferredSize() : sa[ii].getMinimumSize();
                w += size.width;
                h += size.height;
            }
        }
        return new Dimension(w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            Dimension northSum = this._sumMinimumSize(this.norths);
            Dimension southSum = this._sumMinimumSize(this.souths);
            Dimension eastSum = this._sumMinimumSize(this.easts);
            Dimension westSum = this._sumMinimumSize(this.wests);
            Dimension northMax = this._maxMinimumSize(this.norths);
            Dimension southMax = this._maxMinimumSize(this.souths);
            Dimension eastMax = this._maxMinimumSize(this.easts);
            Dimension westMax = this._maxMinimumSize(this.wests);
            Dimension centerMin = this.center != null && this.center.isVisible() ? this.center.getMinimumSize() : new Dimension(0, 0);
            d.width = westSum.width + eastSum.width + Math.max(Math.max(northMax.width, southMax.width), centerMin.width);
            d.height = northSum.height + southSum.height + Math.max(Math.max(eastMax.height, westMax.height), centerMin.height);
            Insets insets = target.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            Dimension northSum = this._sumPreferredSize(this.norths);
            Dimension southSum = this._sumPreferredSize(this.souths);
            Dimension eastSum = this._sumPreferredSize(this.easts);
            Dimension westSum = this._sumPreferredSize(this.wests);
            Dimension northMax = this._maxPreferredSize(this.norths);
            Dimension southMax = this._maxPreferredSize(this.souths);
            Dimension eastMax = this._maxPreferredSize(this.easts);
            Dimension westMax = this._maxPreferredSize(this.wests);
            Dimension centerPre = this.center != null && this.center.isVisible() ? this.center.getPreferredSize() : new Dimension(0, 0);
            d.width = westSum.width + eastSum.width + Math.max(Math.max(northMax.width, southMax.width), centerPre.width);
            d.height = northSum.height + southSum.height + Math.max(Math.max(eastMax.height, westMax.height), centerPre.height);
            Insets insets = target.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            return d;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private void _setNorthBounds(Component[] sa, int x, int y, int w, int h) {
        if (sa != null) {
            for (int ii = sa.length - 1; ii >= 0; --ii) {
                if (sa[ii] == null || !sa[ii].isVisible()) continue;
                Dimension p = sa[ii].getPreferredSize();
                if (h >= p.height) {
                    sa[ii].setSize(w, p.height);
                    sa[ii].setBounds(x, y, w, p.height);
                    h -= p.height;
                    y += p.height;
                    continue;
                }
                sa[ii].setSize(0, 0);
                sa[ii].setBounds(0, 0, 0, 0);
            }
        }
    }

    private void _setSouthBounds(Component[] sa, int x, int y, int w, int h) {
        if (sa != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                if (sa[ii] == null || !sa[ii].isVisible()) continue;
                Dimension p = sa[ii].getPreferredSize();
                if (h >= p.height) {
                    sa[ii].setSize(w, p.height);
                    sa[ii].setBounds(x, y, w, p.height);
                    h -= p.height;
                    y += p.height;
                    continue;
                }
                sa[ii].setSize(0, 0);
                sa[ii].setBounds(0, 0, 0, 0);
            }
        }
    }

    private void _setEastBounds(Component[] sa, int x, int y, int w, int h) {
        if (sa != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                if (sa[ii] == null || !sa[ii].isVisible()) continue;
                Dimension p = sa[ii].getPreferredSize();
                if (w >= p.width) {
                    sa[ii].setSize(p.width, h);
                    sa[ii].setBounds(x, y, p.width, h);
                    w -= p.width;
                    x += p.width;
                    continue;
                }
                sa[ii].setSize(0, 0);
                sa[ii].setBounds(0, 0, 0, 0);
            }
        }
    }

    private void _setWestBounds(Component[] sa, int x, int y, int w, int h) {
        if (sa != null) {
            for (int ii = sa.length - 1; ii >= 0; --ii) {
                if (sa[ii] == null || !sa[ii].isVisible()) continue;
                Dimension p = sa[ii].getPreferredSize();
                if (w >= p.width) {
                    sa[ii].setSize(p.width, h);
                    sa[ii].setBounds(x, y, p.width, h);
                    w -= p.width;
                    x += p.width;
                    continue;
                }
                sa[ii].setSize(0, 0);
                sa[ii].setBounds(0, 0, 0, 0);
            }
        }
    }

    private boolean _validateScrollBars(Component[] sa, Dimension centerDim) {
        boolean modified = false;
        if (sa != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                int displayLength;
                if (!(sa[ii] instanceof JScrollBar)) continue;
                JScrollBar scrollBar = (JScrollBar)sa[ii];
                if (scrollBar.isVisible()) {
                    int n = displayLength = scrollBar.getOrientation() == 0 ? scrollBar.getSize().width : scrollBar.getSize().height;
                    if (!this.scrollBarsEnabled || scrollBar.getModel().getMaximum() <= displayLength) {
                        scrollBar.setVisible(false);
                        modified = true;
                    }
                } else {
                    int scrollableLength;
                    displayLength = scrollBar.getOrientation() == 0 ? centerDim.width : centerDim.height;
                    int n = scrollableLength = scrollBar.getOrientation() == 0 ? this.prefCenterWidth : this.prefCenterHeight;
                    if (this.scrollBarsEnabled && scrollableLength > displayLength) {
                        scrollBar.setVisible(true);
                        modified = true;
                    }
                }
                if (!scrollBar.isVisible()) continue;
                int skipSize = scrollBar.getOrientation() == 0 ? centerDim.width : centerDim.height;
                scrollBar.setBlockIncrement(skipSize);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            boolean adjust;
            Dimension centerDim;
            int tries = 0;
            do {
                ++tries;
                adjust = false;
                centerDim = this._layoutContainer(target);
                adjust |= this._validateScrollBars(this.norths, centerDim);
                adjust |= this._validateScrollBars(this.souths, centerDim);
                adjust |= this._validateScrollBars(this.easts, centerDim);
            } while ((adjust |= this._validateScrollBars(this.wests, centerDim)) && tries < 3);
            if (adjust) {
                this._layoutContainer(target);
            }
        }
    }

    private Dimension _layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension targetSize = target.getSize();
        int top = insets.top;
        int bottom = targetSize.height - insets.bottom;
        int left = insets.left;
        int right = targetSize.width - insets.right;
        Dimension northSum = this._sumPreferredSize(this.norths);
        Dimension southSum = this._sumPreferredSize(this.souths);
        Dimension eastSum = this._sumPreferredSize(this.easts);
        Dimension westSum = this._sumPreferredSize(this.wests);
        Dimension northMax = this._maxPreferredSize(this.norths);
        Dimension southMax = this._maxPreferredSize(this.souths);
        Dimension eastMax = this._maxPreferredSize(this.easts);
        Dimension westMax = this._maxPreferredSize(this.wests);
        Dimension centerPre = this.center != null && this.center.isVisible() ? this.center.getPreferredSize() : new Dimension(0, 0);
        int northHeight = northSum.height;
        int southHeight = southSum.height;
        int eastWidth = eastSum.width;
        int westWidth = westSum.width;
        int centerWidth = Math.max(Math.max(northMax.width, southMax.width), centerPre.width);
        int centerHeight = Math.max(Math.max(eastMax.height, westMax.height), centerPre.height);
        int availCenterWidth = Math.max(0, right - left - westWidth - eastWidth);
        int availCenterHeight = Math.max(0, bottom - top - northHeight - southHeight);
        this.prefCenterWidth = centerWidth;
        this.prefCenterHeight = centerHeight;
        centerWidth = availCenterWidth;
        centerHeight = availCenterHeight;
        int adjustX = Math.max(0, (right - left - (centerWidth + westWidth + eastWidth)) / 2);
        int adjustY = Math.max(0, (bottom - top - (centerHeight + northHeight + southHeight)) / 2);
        top += adjustY;
        left += adjustX;
        Dimension northDim = new Dimension(centerWidth, northSum.height);
        Dimension southDim = new Dimension(centerWidth, southSum.height);
        Dimension eastDim = new Dimension(eastSum.width, centerHeight);
        Dimension westDim = new Dimension(westSum.width, centerHeight);
        Dimension centerDim = new Dimension(centerWidth, centerHeight);
        this._setNorthBounds(this.norths, left + westDim.width, top, northDim.width, northDim.height);
        this._setSouthBounds(this.souths, left + westDim.width, top + northDim.height + centerDim.height, southDim.width, southDim.height);
        this._setWestBounds(this.wests, left, top + northDim.height, westDim.width, westDim.height);
        this._setEastBounds(this.easts, left + westDim.width + centerDim.width, top + northDim.height, eastDim.width, eastDim.height);
        this.center.setSize(centerDim.width, centerDim.height);
        this.center.setBounds(left + westDim.width, top + northDim.height, centerDim.width, centerDim.height);
        return centerDim;
    }

    public String toString() {
        return Message.format((String)RB.getStringResource("layoutToString.txt"), (Object)this.getClass().getName(), (Object)new Integer(this.hgap), (Object)new Integer(this.vgap));
    }
}

