/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.ZoomScrollBarUI;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.LabelPane;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class MatrixContainer2
extends JPanel {
    public static final String INSUFFICIENT_SPACE = "InsufficientDisplaySpace.ex.txt";
    public static final String BLANK_MESSAGE = "BlankMessage.txt";
    protected static final int scrollBarSize = 13;
    protected static final int scrollBarHandleSize = 6;
    private static final boolean scrollBarNewLook = true;
    private static final boolean scrollBarButtons = false;
    private final transient boolean isTextAntiAliasingEnabled;
    private final transient boolean isAntiAliasingEnabled;
    private final Channel channel;
    private Hashtable scrollModel2ScrollModelProjection = null;
    static final String ADD_NOT_SUPPORTED = "add assignment not supported for this class.";
    static final String REMOVE_NOT_SUPPORTED = "remove assignment not supported for this class.";

    public MatrixContainer2(boolean isAntiAliasingEnabled, boolean isTextAntiAliasingEnabled, Channel channel) {
        this.isAntiAliasingEnabled = isAntiAliasingEnabled;
        this.isTextAntiAliasingEnabled = isTextAntiAliasingEnabled;
        this.channel = channel;
    }

    protected Channel getChannel() {
        return this.channel;
    }

    public abstract Component[] getMatrixCellComponents();

    public abstract Component getBrushableComponent();

    protected static Variable[] newLabelVariables(AxisModel axisModel, DataSource dataSource, Object role) {
        return MatrixContainer2.newLabelVariables(axisModel, dataSource, new Object[]{role});
    }

    protected static Variable[] newLabelVariables(AxisModel axisModel, DataSource dataSource, Object[] roles) {
        if (roles != null) {
            Variable[] labelVariables = null;
            for (int ii = 0; ii < roles.length; ++ii) {
                labelVariables = MatrixContainer2._mergeVariables(labelVariables, dataSource.getVariable(roles[ii]));
            }
            if (labelVariables != null && axisModel.getLabel() != null) {
                NumericVariable labelVariable = new NumericVariable();
                labelVariable.setLabel(axisModel.getLabel());
                return new Variable[]{labelVariable};
            }
            return labelVariables;
        }
        return null;
    }

    protected static Variable[] addSpecialLabeling(Variable[] labelVariables, String specialLabel) {
        NumericVariable specialVariable = new NumericVariable();
        specialVariable.setName("_SPECIAL_LABELING_");
        specialVariable.setLabel(specialLabel);
        Variable[] lva = null;
        if (labelVariables == null) {
            lva = new Variable[1];
        } else {
            lva = new Variable[labelVariables.length + 1];
            System.arraycopy(labelVariables, 0, lva, 0, labelVariables.length);
        }
        labelVariables = lva;
        labelVariables[labelVariables.length - 1] = specialVariable;
        return labelVariables;
    }

    protected static LabelPane.LabelComponentFactory newSpecialLabelingLabelComponentFactory(AxisModel axisModel, Channel channel) {
        AdvancedTextStyle specialTextStyle = new AdvancedTextStyle();
        Util.Conveyer.applyTextStyle(axisModel.getLabelTextStyle(), specialTextStyle);
        specialTextStyle.setVisible(true);
        Font labelFont = axisModel.getLabelTextStyle().getFont();
        Font valueFont = axisModel.getValueTextStyle().getFont();
        specialTextStyle.setFont(FontManager.getFont((String)labelFont.getFamily(), (int)labelFont.getStyle(), (int)Math.max(valueFont.getSize(), 8)));
        LabelPane.DefaultLabelComponentFactory labelComponentFactory = new LabelPane.DefaultLabelComponentFactory(axisModel.getLabelTextStyle(), null, null, channel);
        labelComponentFactory.setSpecialTextStyle(specialTextStyle);
        return labelComponentFactory;
    }

    private static Variable[] _mergeVariables(Variable[] v1, Variable[] v2) {
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            return v2;
        }
        Variable[] v = new Variable[v1.length + v2.length];
        System.arraycopy(v1, 0, v, 0, v1.length);
        System.arraycopy(v2, 0, v, v1.length, v2.length);
        return v;
    }

    public JScrollBar add(JScrollBar c, String name) {
        if (c != null) {
            c.setName(name);
            return (JScrollBar)super.add(c);
        }
        return null;
    }

    public HierarchicalPane add(HierarchicalPane comp, String name) {
        if (comp != null) {
            comp.setName(name);
            comp.applyAntialiasing(this.isAntiAliasingEnabled, this.isTextAntiAliasingEnabled);
            return (HierarchicalPane)super.add(comp);
        }
        return null;
    }

    public static void applyPaneBounds(HierarchicalPane c, Rectangle b) {
        MatrixContainer2.applyBounds(c, b);
    }

    public static void applyBounds(Component c, Rectangle b) {
        if (c != null && b != null) {
            if (b.width < 0) {
                b.width = 0;
            }
            if (b.height < 0) {
                b.height = 0;
            }
            c.setVisible(b.width > 0 && b.height > 0);
            c.setBounds(b.x, b.y, b.width, b.height);
        }
    }

    public static void applyScrollBarBounds(JScrollBar c, Rectangle b) {
        if (c != null && b != null) {
            if (b.width < 0) {
                b.width = 0;
            }
            if (b.height < 0) {
                b.height = 0;
            }
            c.setVisible(b.width > 0 && b.height > 0);
            c.setBounds(b.x, b.y, b.width, b.height);
        }
    }

    public void disablePanes(String messageID) throws RuntimeException {
        this.disablePanes();
        if (messageID != null) {
            throw new RuntimeException(new Matrix.MatrixLayoutErrorMessage(messageID));
        }
    }

    protected void disablePanes() {
        Component[] children = this.getComponents();
        if (children != null && children.length > 0) {
            Rectangle invisible = new Rectangle(0, 0, 0, 0);
            for (int ii = 0; ii < children.length; ++ii) {
                if (!(children[ii] instanceof HierarchicalPane)) continue;
                MatrixContainer2.applyPaneBounds((HierarchicalPane)children[ii], invisible);
            }
        }
    }

    public static ZoomScrollBar[] newColumnRowZoomScrollBars() {
        Color shadowColor = UIManager.getColor("ScrollBar.shadow");
        Color highlightColor = UIManager.getColor("ScrollBar.highlight");
        Color darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        Color thumbColor = UIManager.getColor("ScrollBar.thumb");
        Color thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        Color thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        Color trackColor = UIManager.getColor("ScrollBar.track");
        Color trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        int alpha = 255;
        UIManager.put("ScrollBar.shadow", Util.newColor(shadowColor, alpha));
        UIManager.put("ScrollBar.highlight", Util.newColor(highlightColor, alpha));
        UIManager.put("ScrollBar.darkShadow", Util.newColor(darkShadowColor, alpha));
        UIManager.put("ScrollBar.thumb", Util.newColor(thumbColor, alpha));
        UIManager.put("ScrollBar.thumbShadow", Util.newColor(thumbShadow, alpha));
        UIManager.put("ScrollBar.thumbHighlight", Util.newColor(thumbHighlightColor, alpha));
        alpha = 150;
        UIManager.put("ScrollBar.track", Util.newColor(trackColor, alpha));
        alpha = 20;
        UIManager.put("ScrollBar.darkShadow", Util.newColor(darkShadowColor, 0));
        UIManager.put("ScrollBar.trackHighlight", Util.newColor(trackHighlightColor, alpha));
        ZoomScrollBar columnScrollBar = new ZoomScrollBar(0);
        columnScrollBar.setOpaque(false);
        columnScrollBar.getModel().setRangeProperties(0, 100, 0, 100, false);
        columnScrollBar.setVisible(false);
        ZoomScrollBarUI zsbUI = (ZoomScrollBarUI)columnScrollBar.getUI();
        zsbUI.setShowArrows(false);
        zsbUI.setShowNewLook(true);
        zsbUI.setHandleSize(6);
        ZoomScrollBar rowScrollBar = new ZoomScrollBar(1);
        rowScrollBar.getModel().setRangeProperties(0, 100, 0, 100, false);
        rowScrollBar.setOpaque(false);
        rowScrollBar.setVisible(false);
        zsbUI = (ZoomScrollBarUI)rowScrollBar.getUI();
        zsbUI.setShowArrows(false);
        zsbUI.setShowNewLook(true);
        zsbUI.setHandleSize(6);
        UIManager.put("ScrollBar.shadow", shadowColor);
        UIManager.put("ScrollBar.highlight", highlightColor);
        UIManager.put("ScrollBar.darkShadow", darkShadowColor);
        UIManager.put("ScrollBar.thumb", thumbColor);
        UIManager.put("ScrollBar.thumbShadow", thumbShadow);
        UIManager.put("ScrollBar.thumbHighlight", thumbHighlightColor);
        UIManager.put("ScrollBar.track", trackColor);
        UIManager.put("ScrollBar.trackHighlight", trackHighlightColor);
        return new ZoomScrollBar[]{columnScrollBar, rowScrollBar};
    }

    public ScrollModelProjection putScrollModel(BoundedRangeModel model) {
        if (model != null) {
            ScrollModelProjection scrollModelProjection;
            if (this.scrollModel2ScrollModelProjection == null) {
                this.scrollModel2ScrollModelProjection = new Hashtable();
            } else {
                scrollModelProjection = (ScrollModelProjection)this.scrollModel2ScrollModelProjection.get(model);
                if (scrollModelProjection != null) {
                    return scrollModelProjection;
                }
            }
            scrollModelProjection = new ScrollModelProjection(model);
            this.scrollModel2ScrollModelProjection.put(model, scrollModelProjection);
            return scrollModelProjection;
        }
        return null;
    }

    public ScrollModelProjection removeScrollModel(BoundedRangeModel model) {
        if (model != null && this.scrollModel2ScrollModelProjection != null) {
            ScrollModelProjection oldScrollModelProjection = (ScrollModelProjection)this.scrollModel2ScrollModelProjection.remove(model);
            if (oldScrollModelProjection != null) {
                oldScrollModelProjection.detach();
            }
            return oldScrollModelProjection;
        }
        return null;
    }

    public void removeAllScrollModels() {
        if (this.scrollModel2ScrollModelProjection != null) {
            Enumeration keys = this.scrollModel2ScrollModelProjection.keys();
            while (keys.hasMoreElements()) {
                this.removeScrollModel((BoundedRangeModel)keys.nextElement());
            }
        }
    }

    @Override
    public Component add(Component comp) {
        throw new IllegalStateException(ADD_NOT_SUPPORTED);
    }

    @Override
    public Component add(Component comp, int index) {
        throw new IllegalStateException(ADD_NOT_SUPPORTED);
    }

    @Override
    public Component add(String name, Component comp) {
        throw new IllegalStateException(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (constraints instanceof String && "message".equals(constraints)) {
            if (comp != null) {
                super.add(comp);
            }
        } else {
            throw new IllegalStateException(ADD_NOT_SUPPORTED);
        }
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new IllegalStateException(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(PopupMenu menu) {
        throw new IllegalStateException(ADD_NOT_SUPPORTED);
    }

    public abstract void dispose();

    @Override
    public void remove(Component comp) {
        throw new IllegalStateException(REMOVE_NOT_SUPPORTED);
    }

    @Override
    public void remove(int comp) {
        throw new IllegalStateException(REMOVE_NOT_SUPPORTED);
    }

    @Override
    public void remove(MenuComponent menu) {
        throw new IllegalStateException(REMOVE_NOT_SUPPORTED);
    }

    public class ScrollModelProjection {
        private BoundedRangeModel scrollModel = null;
        private double scale = -1.0;
        private double scroll = -1.0;
        private int viewportSize = -1;
        private boolean isValid = false;
        private ChangeListener scrollModelListener = null;

        private ScrollModelProjection(BoundedRangeModel scrollModel) {
            this.scrollModel = scrollModel;
            if (this.scrollModel != null) {
                this.scrollModelListener = new ScrollModelListener();
                this.scrollModel.addChangeListener(this.scrollModelListener);
            }
        }

        public BoundedRangeModel getModel() {
            return this.scrollModel;
        }

        private void detach() {
            if (this.scrollModel != null) {
                if (this.scrollModelListener != null) {
                    this.scrollModel.removeChangeListener(this.scrollModelListener);
                    this.scrollModelListener = null;
                }
                this.scrollModel = null;
            }
        }

        public void invalidate() {
            this.isValid = false;
        }

        private boolean updateState() {
            if (this.scrollModel != null) {
                int range = this.scrollModel.getMaximum() - this.scrollModel.getMinimum();
                int value = this.scrollModel.getValue();
                int extent = this.scrollModel.getExtent();
                this.scale = Math.max(1.0, (double)range / (double)extent);
                if (range > extent) {
                    this.scroll = Math.max(0.0, Math.min(1.0, (double)value / (double)(range - extent)));
                }
                return true;
            }
            return false;
        }

        public boolean isZoomed() {
            if (this.scrollModel == null) {
                return false;
            }
            return this.scrollModel.getMaximum() - this.scrollModel.getMinimum() > this.scrollModel.getExtent();
        }

        public void setViewportSize(int size) {
            this.viewportSize = Math.max(0, size);
        }

        public int getViewportSize() {
            return this.viewportSize;
        }

        public int calculateViewSize() {
            if (!this.isValid) {
                this.updateState();
            }
            return (int)(this.scale * (double)this.viewportSize);
        }

        public int calculateViewScroll() {
            if (!this.isValid) {
                this.updateState();
            }
            int viewSize = (int)(this.scale * (double)this.viewportSize);
            return (int)(-(((double)viewSize - (double)viewSize / this.scale) * this.scroll));
        }
    }

    class ScrollModelListener
    implements ChangeListener {
        ScrollModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScrollModelProjection smp = (ScrollModelProjection)MatrixContainer2.this.scrollModel2ScrollModelProjection.get(e.getSource());
            if (smp != null) {
                smp.invalidate();
                MatrixContainer2.this.revalidate();
                MatrixContainer2.this.repaint();
            }
        }
    }

    public static abstract class LayoutStrategy {
        final MatrixContainer2 container;

        public LayoutStrategy(MatrixContainer2 container) {
            this.container = container;
        }

        public abstract void layout();

        protected Rectangle getBounds() {
            if (this.container != null) {
                return this.container.getBounds();
            }
            return new Rectangle(0, 0, 0, 0);
        }

        protected Insets getInsets() {
            if (this.container != null) {
                return this.container.getInsets();
            }
            return new Insets(0, 0, 0, 0);
        }

        protected void disablePanes(String messageID) throws RuntimeException {
            if (this.container != null) {
                this.container.disablePanes(messageID);
            }
        }
    }
}

