/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AlignableComponentInterface;
import com.sas.graphics.util.cell.GenericActionProviderView;
import com.sas.graphics.util.cell.GridDimension;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;

public class LabelPane
extends HierarchicalPane {
    private final LabelComponentFactory labelComponentFactory;
    private final Variable[] variables;
    private static final int NODE_PROCESSING_POLICY_INCLUDE_ALL_LABELS = 0;
    private static final int NODE_PROCESSING_POLICY_EXCLUDE_CATEGORY_LABELS = 1;
    private static final int NODE_PROCESSING_POLICY_INCLUDE_ONLY_CATEGORY_LABELS = 2;

    public LabelPane(ValueTree tree, TextStyle textStyle, Channel channel) {
        this(tree, null, textStyle, null, channel);
    }

    public LabelPane(ValueTree tree, TextStyle textStyle, SwingActionProvider actionProvider, Channel channel) {
        this(null, tree, null, textStyle, actionProvider, channel);
    }

    public LabelPane(String labelOverride, ValueTree tree, TextStyle textStyle, SwingActionProvider actionProvider, Channel channel) {
        this(labelOverride, tree, null, textStyle, actionProvider, channel);
    }

    public LabelPane(ValueTree tree, LabelComponentFactory labelComponentFactory, Channel channel) {
        this(tree, labelComponentFactory, null, null, channel);
    }

    private LabelPane(ValueTree tree, LabelComponentFactory labelComponentFactory, TextStyle textStyle, SwingActionProvider actionProvider, Channel channel) {
        this(null, tree, labelComponentFactory, textStyle, actionProvider, channel);
    }

    private LabelPane(String labelOverride, ValueTree tree, LabelComponentFactory labelComponentFactory, TextStyle textStyle, SwingActionProvider actionProvider, Channel channel) {
        super(tree);
        this.labelComponentFactory = labelComponentFactory != null ? labelComponentFactory : new DefaultLabelComponentFactory(labelOverride, textStyle, actionProvider, this, channel);
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo info = (DataTreeInfo)root.getValue();
        int variableCount = info.getGroupVariableCount();
        this.variables = new Variable[variableCount];
        for (int ii = 0; ii < variableCount; ++ii) {
            Variable variable;
            this.variables[ii] = variable = info.getGroupVariableAt(ii);
            JComponent labelComponent = this.labelComponentFactory.newLabelComponent(variable);
            if (labelComponent == null) continue;
            this.contentPanel.add(labelComponent);
            this.componentMap.put(variable, labelComponent);
        }
    }

    public LabelPane(Variable[] variables, TextStyle textStyle, Channel channel) {
        this(variables, (LabelComponentFactory)new DefaultLabelComponentFactory(textStyle, channel), channel);
    }

    public LabelPane(Variable[] variables, LabelComponentFactory labelComponentFactory, Channel channel) {
        super(null);
        this.labelComponentFactory = labelComponentFactory != null ? labelComponentFactory : new DefaultLabelComponentFactory(null, null, null, channel);
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new Variable[variables.length];
        System.arraycopy(variables, 0, this.variables, 0, variables.length);
        for (int ii = 0; ii < variables.length; ++ii) {
            Variable variable = variables[ii];
            JComponent labelComponent = this.labelComponentFactory.newLabelComponent(variable);
            if (labelComponent == null) continue;
            this.contentPanel.add(labelComponent);
            this.componentMap.put(variable, labelComponent);
        }
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public JComponent getLabelComponent(Variable variable) {
        return (JComponent)this.componentMap.get(variable);
    }

    public LabelZoneList toLabelZoneList(Component ancestor) {
        return this.toLabelZoneList(ancestor, 0);
    }

    public LabelZoneList toLabelZoneList_IncludeOnlyCategoryLabels(Component ancestor) {
        return this.toLabelZoneList(ancestor, 2);
    }

    public LabelZoneList toLabelZoneList_ExcludeCategoryLabels(Component ancestor) {
        return this.toLabelZoneList(ancestor, 1);
    }

    private LabelZoneList toLabelZoneList(Component ancestor, int nodeProcessingPolicy) {
        Variable aCategoryVariable;
        Container parent;
        if (this.variables == null || !this.isVisible()) {
            return null;
        }
        Rectangle bounds = this.getBounds();
        if (bounds.width < 1 || bounds.height < 1) {
            return null;
        }
        int xAdj = bounds.x;
        int yAdj = bounds.y;
        for (parent = this.getParent(); parent != null && parent != ancestor; parent = parent.getParent()) {
            bounds = parent.getBounds();
            xAdj += bounds.x;
            yAdj += bounds.y;
        }
        if (parent == null) {
            xAdj = 0;
            yAdj = 0;
        }
        bounds = this.contentPanel.getBounds();
        xAdj += bounds.x;
        yAdj += bounds.y;
        String categoryHierarchyName = null;
        if (nodeProcessingPolicy != 0 && (aCategoryVariable = this.variables[this.variables.length - 1]) instanceof OLAPLevelVariable) {
            categoryHierarchyName = ((OLAPLevelVariable)aCategoryVariable).getHierachyName();
        }
        LabelZoneList labelZoneList = null;
        for (int ii = this.variables.length - 1; ii >= 0; --ii) {
            JComponent labelComponent;
            Variable variable = this.variables[ii];
            if (nodeProcessingPolicy != 0) {
                boolean isCategoryVariable = false;
                if (variable instanceof OLAPLevelVariable) {
                    String hierarchyName = ((OLAPLevelVariable)variable).getHierachyName();
                    if (hierarchyName != null && categoryHierarchyName != null) {
                        isCategoryVariable = hierarchyName.equals(categoryHierarchyName);
                    }
                } else {
                    boolean bl = isCategoryVariable = ii == this.variables.length - 1;
                }
                if (nodeProcessingPolicy == 1 && isCategoryVariable || nodeProcessingPolicy == 2 && !isCategoryVariable) continue;
            }
            if ((labelComponent = this.getLabelComponent(variable)) == null) continue;
            bounds = labelComponent.getBounds();
            bounds.x += xAdj;
            bounds.y += yAdj;
            labelZoneList = new LabelZoneList(bounds, variable.getColumnName(), variable.getLabel(), null, labelZoneList);
        }
        return labelZoneList;
    }

    public static GridDimension getPreferredGridSize(LabelPane labelPane, int direction) {
        int labelCount;
        GridDimension size = new GridDimension();
        if (labelPane == null) {
            return size;
        }
        boolean isVertical = direction == 1 || direction == 5;
        Component[] labels = labelPane.getContentPanelComponents();
        if (labels != null && (labelCount = labels.length) > 0) {
            if (isVertical) {
                size.setGridSize(1, labelCount);
            } else {
                size.setGridSize(labelCount, 1);
            }
            for (int i = 0; i < labelCount; ++i) {
                Dimension labelSize = labels[i].getPreferredSize();
                if (isVertical) {
                    size.setRowHeight(i, labelSize.height);
                    size.mergeColWidth(0, labelSize.width);
                    continue;
                }
                size.setColWidth(i, labelSize.width);
                size.mergeRowHeight(0, labelSize.height);
            }
        }
        return size;
    }

    public static Dimension getPreferredSize(LabelPane labelPane, int direction) {
        if (labelPane != null) {
            int labelCount;
            Dimension preferredSize = HierarchicalPane.getMaxContentPanelComponentPreferredSize(labelPane);
            Component[] components = labelPane.getContentPanelComponents();
            if (components != null && (labelCount = components.length) > 0) {
                switch (direction) {
                    case 3: 
                    case 7: {
                        return new Dimension(labelCount * preferredSize.width, preferredSize.height);
                    }
                    case 1: 
                    case 5: {
                        return new Dimension(preferredSize.width, labelCount * preferredSize.height);
                    }
                }
            }
        }
        return new Dimension(0, 0);
    }

    public static Dimension getMinimumSize(LabelPane labelPane, int direction) {
        if (labelPane != null) {
            int labelCount;
            Dimension minimumSize = HierarchicalPane.getMaxContentPanelComponentMinimumSize(labelPane);
            Component[] components = labelPane.getContentPanelComponents();
            if (components != null && (labelCount = components.length) > 0) {
                switch (direction) {
                    case 3: 
                    case 7: {
                        return new Dimension(labelCount * minimumSize.width, minimumSize.height);
                    }
                    case 1: 
                    case 5: {
                        return new Dimension(minimumSize.width, labelCount * minimumSize.height);
                    }
                }
            }
        }
        return new Dimension(0, 0);
    }

    public static void doLayout(LabelPane labelPane, int direction, GridDimension componentSize) {
        boolean reverse;
        if (labelPane == null) {
            return;
        }
        Component[] labels = labelPane.getContentPanelComponents();
        if (labels == null || labels.length == 0) {
            return;
        }
        int labelCount = labels.length;
        boolean isVertical = direction == 1 || direction == 5;
        int cellY = 0;
        int cellX = 0;
        int cellW = componentSize.getColWidth(0);
        int cellH = componentSize.getRowHeight(0);
        for (int i = 0; i < labelCount; ++i) {
            Rectangle labelBounds;
            Component labelComponent = labels[i];
            if (labelComponent == null) continue;
            if (isVertical) {
                cellH = componentSize.getRowHeight(i);
                int labelH = labelComponent.getPreferredSize().height;
                labelBounds = new Rectangle(cellX, cellY, cellW, labelH);
                cellY += cellH;
            } else {
                cellW = componentSize.getColWidth(i);
                labelBounds = new Rectangle(cellX, cellY, cellW, cellH);
                cellX += cellW;
            }
            if (labelComponent instanceof AlignableComponentInterface) {
                AlignableComponentConstraints constraints = new AlignableComponentConstraints();
                constraints.setBounds(labelBounds);
                ((AlignableComponentInterface)((Object)labelComponent)).setAlignableComponentConstraints(constraints);
                continue;
            }
            labelComponent.setBounds(labelBounds);
        }
        labelPane.setContentPanelBounds(0, 0, componentSize.width, componentSize.height);
        Rectangle paneBounds = labelPane.getBounds();
        boolean paneBoundsChanged = false;
        if (paneBounds.height < componentSize.height) {
            paneBounds.height = componentSize.height;
            paneBoundsChanged = true;
        }
        if (paneBounds.width < componentSize.width) {
            paneBounds.width = componentSize.width;
            paneBoundsChanged = true;
        }
        if (paneBoundsChanged) {
            labelPane.setBounds(paneBounds);
        }
        boolean bl = reverse = direction == 1 || direction == 7;
        if (reverse) {
            if (isVertical) {
                labelPane.flipY();
            } else {
                labelPane.flipX();
            }
        }
    }

    public static void doLayout(LabelPane labelPane, int direction, int componentWidth, int componentHeight) {
        boolean isReverse;
        if (labelPane == null) {
            return;
        }
        Component[] components = labelPane.getContentPanelComponents();
        if (components == null || components.length == 0) {
            return;
        }
        int labelCount = components.length;
        int labelY = 0;
        int labelX = 0;
        boolean isVertical = direction == 1 || direction == 5;
        int width = componentWidth;
        int height = componentHeight;
        if (isVertical) {
            height *= labelCount;
        } else {
            width *= labelCount;
        }
        for (int i = 0; i < labelCount; ++i) {
            AlignableComponentConstraints constraints = new AlignableComponentConstraints();
            Component labelComponent = components[i];
            if (labelComponent == null) continue;
            if (isVertical) {
                constraints.setBounds(new Rectangle(labelX, labelY, width, componentHeight));
                labelY += componentHeight;
            } else {
                constraints.setBounds(new Rectangle(labelX, labelY, componentWidth, height));
                labelX += componentWidth;
            }
            if (labelComponent instanceof AlignableComponentInterface) {
                ((AlignableComponentInterface)((Object)labelComponent)).setAlignableComponentConstraints(constraints);
                continue;
            }
            labelComponent.setBounds(constraints.getBounds());
        }
        labelPane.setContentPanelBounds(0, 0, width, height);
        boolean bl = isReverse = direction == 1 || direction == 7;
        if (isReverse) {
            if (isVertical) {
                labelPane.flipY();
            } else {
                labelPane.flipX();
            }
        }
    }

    public static class DefaultLabelComponentFactory
    implements LabelComponentFactory {
        public static final String SPECIAL_LABELING = "_SPECIAL_LABELING_";
        private boolean overrideStateEnabled;
        private final String labelOverride;
        private final TextStyle textStyle;
        private AdvancedTextStyle specialTextStyle;
        private final Channel channel;
        private final SwingActionProvider actionProvider;
        private final ActionUIFactory actionUIFactory;
        private final ActionSupportFilter actionSupportFilter;
        private final GenericActionProviderView actionProviderView;

        public DefaultLabelComponentFactory(TextStyle textStyle, Channel channel) {
            this(textStyle, null, null, channel);
        }

        public DefaultLabelComponentFactory(TextStyle textStyle, SwingActionProvider actionProvider, JComponent parentedComponent, Channel channel) {
            this(null, textStyle, actionProvider, parentedComponent, channel);
        }

        public DefaultLabelComponentFactory(String labelOverride, TextStyle textStyle, SwingActionProvider actionProvider, JComponent parentedComponent, Channel channel) {
            AdvancedTextStyle ts = new AdvancedTextStyle();
            Util.Conveyer.applyTextStyle(textStyle, ts);
            this.labelOverride = labelOverride;
            this.overrideStateEnabled = this.labelOverride != null;
            this.textStyle = ts;
            this.actionProvider = actionProvider;
            this.channel = channel;
            if (this.actionProvider != null) {
                this.actionUIFactory = new ActionUIFactory();
                this.actionProviderView = new GenericActionProviderView(parentedComponent);
                this.actionSupportFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "TITLE_AREA", (ActionProviderViewInterface)this.actionProviderView);
            } else {
                this.actionUIFactory = null;
                this.actionProviderView = null;
                this.actionSupportFilter = null;
            }
        }

        @Override
        public JComponent newLabelComponent(Variable variable) {
            OLAPDataSetInterface olapDataSet = null;
            HashMap<String, Object> actionSupportFilterAttributes = null;
            if (variable instanceof OLAPLevelVariable) {
                OLAPLevelVariable levelVariable = (OLAPLevelVariable)variable;
                olapDataSet = (OLAPDataSetInterface)levelVariable.getFactory().getResultSet();
                if (olapDataSet instanceof GraphOLAPDataSet) {
                    olapDataSet = ((GraphOLAPDataSet)olapDataSet).getDelegateModel();
                }
                actionSupportFilterAttributes = new HashMap<String, Object>();
                actionSupportFilterAttributes.put("model", olapDataSet);
                actionSupportFilterAttributes.put("uniqueLevelName", variable.getColumnName());
                actionSupportFilterAttributes.put("isMeasure", Boolean.FALSE);
                if (variable instanceof OLAPLevelVariable) {
                    try {
                        AxisInterface axis;
                        OLAPLevelVariable olapLevelVariable = (OLAPLevelVariable)variable;
                        actionSupportFilterAttributes.put("axisLabel", olapLevelVariable.getHierachyLabel());
                        actionSupportFilterAttributes.put("levelLabel", olapLevelVariable.getLabel());
                        int axisNum = olapLevelVariable.getFactory().getAxisNumber(olapLevelVariable.getName());
                        if (axisNum > -1 && (axis = olapDataSet.getResultSetMetadata().getAxis(axisNum)) != null) {
                            actionSupportFilterAttributes.put("axis", axis);
                        }
                    }
                    catch (OLAPException olapLevelVariable) {
                        // empty catch block
                    }
                }
                if (olapDataSet instanceof BusinessQueryToOLAPDataSetAdapter) {
                    try {
                        Method getBusinessQueryMethod = olapDataSet.getClass().getMethod("getBusinessQuery", null);
                        Object businessQuery = getBusinessQueryMethod.invoke((Object)olapDataSet, null);
                        Class<?> olapCellRendererManagerClass = Class.forName("com.sas.swing.visuals.olaptableview.OLAPCellRendererManager");
                        Class[] classes = new Class[]{Class.forName("com.sas.iquery.metadata.business.BusinessQuery"), OLAPDataSetInterface.class, String.class};
                        Method findDataItemMethod = olapCellRendererManagerClass.getMethod("findDataItem", classes);
                        Object dataItem = findDataItemMethod.invoke(null, businessQuery, olapDataSet, variable.getColumnName());
                        actionSupportFilterAttributes.put("dataItem", dataItem);
                    }
                    catch (SecurityException getBusinessQueryMethod) {
                    }
                    catch (NoSuchMethodException getBusinessQueryMethod) {
                    }
                    catch (IllegalArgumentException getBusinessQueryMethod) {
                    }
                    catch (IllegalAccessException getBusinessQueryMethod) {
                    }
                    catch (InvocationTargetException getBusinessQueryMethod) {
                    }
                    catch (ClassNotFoundException getBusinessQueryMethod) {
                        // empty catch block
                    }
                }
            }
            Color backgroundColor = null;
            ListSelectionModel selectionModel = null;
            int[] selectionIndexes = null;
            TextStyle labelTextStyle = this.textStyle;
            if (this.specialTextStyle != null && SPECIAL_LABELING.equals(variable.getName())) {
                labelTextStyle = this.specialTextStyle;
            }
            String labelText = variable.getLabel();
            if (this.labelOverride != null) {
                if (this.overrideStateEnabled) {
                    labelText = this.labelOverride;
                    this.overrideStateEnabled = false;
                } else {
                    labelText = "";
                }
            }
            return new StringComponent(labelText, labelTextStyle, selectionModel, selectionIndexes, this.actionUIFactory, this.actionSupportFilter, this.actionProvider, actionSupportFilterAttributes, olapDataSet, new StringComponent.CellNodeInfo(backgroundColor, false, false), this.channel);
        }

        public AdvancedTextStyle getSpecialTextStyle() {
            return this.specialTextStyle;
        }

        public void setSpecialTextStyle(AdvancedTextStyle specialTextStyle) {
            this.specialTextStyle = specialTextStyle;
        }
    }

    public static interface LabelComponentFactory {
        public JComponent newLabelComponent(Variable var1);
    }
}

