/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.HierarchicalLayout;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

class HierarchicalGrid
extends JPanel {
    private MatteBorder highlightedBorder = new MatteBorder(1, 1, 1, 1, Color.yellow);
    private DataSource dataSource;
    private JPanel valuePanel;
    private JPanel variableLabelPanel;
    private Hashtable labelTable;
    private Channel channel;
    public static final int SUBGROUP_ROLE = 1;
    public static final int CATEGORY_ROLE = 2;
    public static final int ROW_ROLE = 3;
    public static final int COLUMN_ROLE = 4;

    public HierarchicalGrid(DataSource dataSource, ValueTree tree, SwingActionProvider actionProvider, TextStyle valueTextStyle, TextStyle labelTextStyle, String title, boolean reverse, boolean verticalGrid, boolean verticalText, boolean showLabels, int titleTextAngle, boolean frameLineVisible, boolean backgroundVisible, Channel channel) {
        this.dataSource = dataSource;
        this.channel = channel;
        this.labelTable = new Hashtable();
        this.createActionFilters();
        this.setLayout(new BorderLayout());
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new HierarchicalLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo info = (DataTreeInfo)root.getValue();
        this.setOpaque(false);
        int depth = 0;
        Enumeration nodeDFE = root.depthFirstEnumeration();
        while (nodeDFE.hasMoreElements()) {
            depth = Math.max(((DataTreeGroupNode)nodeDFE.nextElement()).getLevelIndex() + 1, depth);
        }
        Enumeration nodeBFE = root.breadthFirstEnumeration();
        HashMap<DataTreeGroupNode, Point> nodeToPointMap = new HashMap<DataTreeGroupNode, Point>();
        nodeToPointMap.put(root, new Point(0, 0));
        while (nodeBFE.hasMoreElements()) {
            int i;
            DataTreeGroupNode node;
            Object n = nodeBFE.nextElement();
            if (n instanceof DataTreeGroupNode && (node = (DataTreeGroupNode)n).getFormattedValue() != null) {
                Color color;
                int extraHeightBelow;
                int extraHeightAbove;
                int maxLevelIndex;
                DataTreeGroupNode topRoot;
                int extra2;
                int extra1;
                int leafCount;
                int childCount;
                Point point;
                LabelComponent2 labelComponent = new LabelComponent2(node, valueTextStyle);
                if (verticalText) {
                    labelComponent.setAngle(90.0);
                }
                if (verticalGrid) {
                    constraints.gridx = reverse ? depth - node.getLevelIndex() - 1 : node.getLevelIndex();
                    point = (Point)nodeToPointMap.get(node.getParent());
                    constraints.gridy = point.y;
                    nodeToPointMap.put(node, new Point(constraints.gridx, constraints.gridy));
                    childCount = node.getChildCount();
                    leafCount = node.getLeafCount();
                    int height = 1;
                    if (leafCount > 0) {
                        height = leafCount;
                    }
                    extra1 = node.getLevelIndex() - ((DataTreeGroupNode)node.getParent()).getLevelIndex() - 1;
                    extra2 = Integer.MAX_VALUE;
                    if (childCount == 0) {
                        topRoot = root;
                        while (topRoot.getParent() != null) {
                            topRoot = (DataTreeGroupNode)topRoot.getParent();
                        }
                        maxLevelIndex = ((DataTreeInfo)topRoot.getValue()).getGroupVariableCount() - 1;
                        extra2 = maxLevelIndex - node.getLevelIndex();
                    }
                    if (reverse) {
                        extraHeightAbove = extra2 < Integer.MAX_VALUE ? extra2 : 0;
                        extraHeightBelow = extra1;
                    } else {
                        extraHeightAbove = extra1;
                        extraHeightBelow = extra2 < Integer.MAX_VALUE ? extra2 : 0;
                    }
                    constraints.gridheight = height;
                    constraints.gridwidth = 1;
                    if (point != null) {
                        ((Point)nodeToPointMap.get((Object)node.getParent())).y += height;
                    }
                    if (backgroundVisible) {
                        labelComponent.setOpaque(true);
                        labelComponent.setBackground((Color)node.getUserObject());
                    }
                    if ((color = (Color)node.getUserObject()) != null) {
                        float[] hsb = new float[3];
                        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
                        if ((double)hsb[2] < 0.48) {
                            labelComponent.getTextStyle().setColor(Color.white);
                        }
                    }
                    if (extraHeightAbove > 0 && frameLineVisible) {
                        labelComponent.setBorder(new MatteBorder(1, 0, 0, 0, Color.black));
                    } else if (frameLineVisible) {
                        labelComponent.setBorder(new MatteBorder(1, 1, 0, 0, Color.black));
                    }
                    labelComponent.setMargin(new Insets(2, 2, 3, 3));
                    this.valuePanel.add((Component)labelComponent, constraints);
                    this.labelTable.put(labelComponent.getLabel(), labelComponent);
                    if (extraHeightBelow > 0) {
                        constraints.gridheight = height;
                        constraints.gridwidth = extraHeightBelow;
                        ++constraints.gridx;
                        JLabel label = new JLabel();
                        if (backgroundVisible) {
                            label.setOpaque(true);
                            label.setBackground((Color)node.getUserObject());
                        }
                        if (frameLineVisible) {
                            label.setBorder(new MatteBorder(1, 0, 0, 0, Color.black));
                        }
                        this.valuePanel.add((Component)label, constraints);
                        --constraints.gridx;
                    }
                    if (extraHeightAbove > 0) {
                        constraints.gridheight = height;
                        constraints.gridwidth = extraHeightAbove;
                        constraints.gridx -= extraHeightAbove;
                        JLabel label = new JLabel();
                        if (backgroundVisible) {
                            label.setOpaque(true);
                            label.setBackground((Color)node.getUserObject());
                        }
                        if (frameLineVisible) {
                            label.setBorder(new MatteBorder(1, 1, 0, 0, Color.black));
                        }
                        this.valuePanel.add((Component)label, constraints);
                    }
                } else {
                    constraints.gridy = reverse ? depth - node.getLevelIndex() - 1 : node.getLevelIndex();
                    point = (Point)nodeToPointMap.get(node.getParent());
                    constraints.gridx = point.x;
                    nodeToPointMap.put(node, new Point(constraints.gridx, constraints.gridy));
                    childCount = node.getChildCount();
                    leafCount = node.getLeafCount();
                    int width = 1;
                    if (leafCount > 0) {
                        width = leafCount;
                    }
                    extra1 = node.getLevelIndex() - ((DataTreeGroupNode)node.getParent()).getLevelIndex() - 1;
                    extra2 = Integer.MAX_VALUE;
                    if (childCount == 0) {
                        topRoot = root;
                        while (topRoot.getParent() != null) {
                            topRoot = (DataTreeGroupNode)topRoot.getParent();
                        }
                        maxLevelIndex = ((DataTreeInfo)topRoot.getValue()).getGroupVariableCount() - 1;
                        extra2 = maxLevelIndex - node.getLevelIndex();
                    }
                    if (reverse) {
                        extraHeightAbove = extra2 < Integer.MAX_VALUE ? extra2 : 0;
                        extraHeightBelow = extra1;
                    } else {
                        extraHeightAbove = extra1;
                        extraHeightBelow = extra2 < Integer.MAX_VALUE ? extra2 : 0;
                    }
                    constraints.gridheight = 1;
                    constraints.gridwidth = width;
                    if (point != null) {
                        ((Point)nodeToPointMap.get((Object)node.getParent())).x += width;
                    }
                    if (backgroundVisible) {
                        labelComponent.setOpaque(true);
                        labelComponent.setBackground((Color)node.getUserObject());
                    }
                    if ((color = (Color)node.getUserObject()) != null) {
                        float[] hsb = new float[3];
                        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
                        if ((double)hsb[2] < 0.48) {
                            labelComponent.getTextStyle().setColor(Color.white);
                        }
                    }
                    if (extraHeightAbove > 0 && frameLineVisible) {
                        labelComponent.setBorder(new MatteBorder(0, 0, 0, 1, Color.black));
                    } else if (frameLineVisible) {
                        labelComponent.setBorder(new MatteBorder(1, 0, 0, 1, Color.black));
                    }
                    labelComponent.setMargin(new Insets(2, 2, 3, 3));
                    this.valuePanel.add((Component)labelComponent, constraints);
                    this.labelTable.put(labelComponent.getLabel(), labelComponent);
                    if (extraHeightBelow > 0) {
                        constraints.gridheight = extraHeightBelow;
                        constraints.gridwidth = width;
                        ++constraints.gridy;
                        JLabel label = new JLabel();
                        if (backgroundVisible) {
                            label.setOpaque(true);
                            label.setBackground((Color)node.getUserObject());
                        }
                        if (frameLineVisible) {
                            label.setBorder(new MatteBorder(0, 0, 0, 1, Color.black));
                        }
                        this.valuePanel.add((Component)label, constraints);
                        --constraints.gridy;
                    }
                    if (extraHeightAbove > 0) {
                        constraints.gridheight = extraHeightAbove;
                        constraints.gridwidth = width;
                        constraints.gridy -= extraHeightAbove;
                        JLabel label = new JLabel();
                        if (backgroundVisible) {
                            label.setOpaque(true);
                            label.setBackground((Color)node.getUserObject());
                        }
                        if (frameLineVisible) {
                            label.setBorder(new MatteBorder(1, 0, 0, 1, Color.black));
                        }
                        this.valuePanel.add((Component)label, constraints);
                    }
                }
            }
            if (verticalGrid && frameLineVisible) {
                this.valuePanel.setBorder(new MatteBorder(0, 0, 1, 1, Color.black));
            } else if (frameLineVisible) {
                this.valuePanel.setBorder(new MatteBorder(0, 1, 1, 0, Color.black));
            }
            this.valuePanel.setOpaque(false);
            JPanel gridPanel = new JPanel();
            gridPanel.setLayout(new BorderLayout());
            gridPanel.add((Component)this.valuePanel, "Center");
            gridPanel.setOpaque(false);
            this.add((Component)gridPanel, "Center");
            LabelComponent label = new LabelComponent(title, labelTextStyle, channel);
            label.setAngle(titleTextAngle);
            if (verticalGrid) {
                label.setBorder(new EmptyBorder(0, 3, 0, 0));
            }
            label.setMargin(new Insets(2, 2, 3, 3));
            label.setOpaque(false);
            if (showLabels) {
                String constraint = reverse ? (verticalGrid ? "East" : "South") : (verticalGrid ? "West" : "North");
                this.add((Component)label, constraint);
            }
            this.variableLabelPanel = new JPanel();
            if (verticalGrid) {
                this.variableLabelPanel.setLayout(new GridLayout(1, 0, 0, 0));
            } else {
                this.variableLabelPanel.setLayout(new GridLayout(0, 1, 0, 0));
            }
            AdvancedTextStyle textStyle = new AdvancedTextStyle();
            Util.Conveyer.applyTextStyle(labelTextStyle, textStyle);
            textStyle.setJustification(2);
            if (!showLabels) continue;
            if (reverse) {
                for (i = info.getGroupVariableCount() - 1; i >= 0; --i) {
                    LabelComponent2 variableLabel = new LabelComponent2(info.getGroupVariableAt(i), root, (TextStyle)textStyle);
                    this.variableLabelPanel.add(variableLabel);
                    variableLabel.setOpaque(false);
                }
            } else {
                for (i = 0; i < info.getGroupVariableCount(); ++i) {
                    LabelComponent2 variableLabel = new LabelComponent2(info.getGroupVariableAt(i), root, (TextStyle)textStyle);
                    this.variableLabelPanel.add(variableLabel);
                    variableLabel.setOpaque(false);
                    this.variableLabelPanel.add(variableLabel);
                }
            }
            this.variableLabelPanel.setOpaque(false);
            if (verticalGrid) {
                this.variableLabelPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
                gridPanel.add((Component)this.variableLabelPanel, "North");
                continue;
            }
            this.variableLabelPanel.setBorder(new EmptyBorder(0, 0, 0, 3));
            gridPanel.add((Component)this.variableLabelPanel, "West");
        }
    }

    public ChartImageMapInfo2 getImageMapInfo(StringVariable variable, int role) {
        ChartImageMapInfo2 legendImageMapInfo = null;
        ArrayList<ChartValueZone> valueZones = new ArrayList<ChartValueZone>();
        LabelZoneList labelZoneList = null;
        Rectangle startBounds = this.valuePanel.getBounds();
        Rectangle gridBounds = this.valuePanel.getParent().getBounds();
        startBounds.x += gridBounds.x;
        startBounds.y += gridBounds.y;
        if (variable != null) {
            int uvcount = variable.getUniqueValueCount();
            for (int ii = 0; ii < uvcount; ++ii) {
                Object value = GTKUtil.VariableAccess.getUniqueValue(variable, ii);
                String formattedValue = GTKUtil.VariableAccess.getFormattedUniqueValue(variable, ii);
                ValueList valueList = new ValueList(value, formattedValue, null);
                Rectangle labelBounds = ((LabelComponent)this.labelTable.get(formattedValue)).getBounds();
                labelBounds.x += startBounds.x;
                labelBounds.y += startBounds.y;
                ChartValueZone valueZone = new ChartValueZone(labelBounds, null, null, valueList, null);
                valueZones.add(valueZone);
            }
            for (int i = 0; i < this.variableLabelPanel.getComponentCount(); ++i) {
                if (!(this.variableLabelPanel.getComponent(i) instanceof LabelComponent)) continue;
                LabelComponent label = (LabelComponent)this.variableLabelPanel.getComponent(i);
                Rectangle labelBounds = label.getBounds();
                labelBounds.x += gridBounds.x;
                labelBounds.y += gridBounds.y;
                labelZoneList = new LabelZoneList(labelBounds, ((LabelComponent)this.variableLabelPanel.getComponent(i)).getLabel(), ((LabelComponent)this.variableLabelPanel.getComponent(i)).getLabel(), null, labelZoneList);
            }
        }
        ChartValueZone[] columnValueZones = null;
        ChartValueZone[] rowValueZones = null;
        ChartValueZone[] categoryValueZones = null;
        ChartValueZone[] subgroupValueZones = null;
        LabelZoneList columnLabelZoneList = null;
        LabelZoneList rowLabelZoneList = null;
        LabelZoneList categoryLabelZoneList = null;
        LabelZoneList subgroupLabelZoneList = null;
        switch (role) {
            case 4: {
                columnValueZones = valueZones.toArray(new ChartValueZone[0]);
                columnLabelZoneList = labelZoneList;
                break;
            }
            case 3: {
                rowValueZones = valueZones.toArray(new ChartValueZone[0]);
                rowLabelZoneList = labelZoneList;
                break;
            }
            case 2: {
                categoryValueZones = valueZones.toArray(new ChartValueZone[0]);
                categoryLabelZoneList = labelZoneList;
                break;
            }
            default: {
                subgroupValueZones = valueZones.toArray(new ChartValueZone[0]);
                subgroupLabelZoneList = labelZoneList;
            }
        }
        legendImageMapInfo = new ChartImageMapInfo2(columnValueZones, rowValueZones, categoryValueZones, subgroupValueZones, null, columnLabelZoneList, rowLabelZoneList, categoryLabelZoneList, subgroupLabelZoneList, null, null);
        legendImageMapInfo.source = this;
        return legendImageMapInfo;
    }

    private void createActionFilters() {
    }

    private class LabelComponent2
    extends LabelComponent
    implements MouseListener {
        private DataTreeGroupNode node;
        protected Border regularBorder;
        private JWindow window;

        public LabelComponent2(Variable variable, DataTreeGroupNode root, TextStyle aStyle) {
            super(variable.getLabel(), new AdvancedTextStyle(), HierarchicalGrid.this.channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        public LabelComponent2(String text, DataTreeGroupNode root, TextStyle aStyle) {
            super(text, new AdvancedTextStyle(), HierarchicalGrid.this.channel);
            this.apply(aStyle);
            this.addMouseListener(this);
        }

        public LabelComponent2(DataTreeGroupNode node, TextStyle aStyle) {
            super(node.getFormattedValue().trim(), new AdvancedTextStyle(), HierarchicalGrid.this.channel);
            this.apply(aStyle);
            this.node = node;
            this.addMouseListener(this);
        }

        public LabelComponent2(DataTreeGroupNode node, TextStyle aStyle, int displayMode) {
            super(node.getFormattedValue().trim(), new AdvancedTextStyle(), displayMode, HierarchicalGrid.this.channel);
            this.apply(aStyle);
            this.node = node;
            this.addMouseListener(this);
        }

        public LabelComponent2(DataTreeGroupNode node, TextStyle aStyle, Channel channel) {
            super(node.getFormattedValue().trim(), new AdvancedTextStyle(), channel);
            this.apply(aStyle);
            this.node = node;
            this.addMouseListener(this);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension sps = super.getMinimumSize();
            if (this.getAngle() == 0.0) {
                return new Dimension(1, sps.height);
            }
            return new Dimension(sps.width, 1);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }

        protected synchronized void buildNetwork(Graphics g) {
            int glJust;
            Channel channel = this.getChannel();
            Rectangle r = this.getBounds();
            if (channel == null || r.width == 0 || r.height == 0) {
                return;
            }
            this.updateChannel();
            channel.setSingleBufferGraphics(g);
            this.getComposite().removeAllElements();
            int height = r.height;
            int width = r.width;
            int marginLeft = 0;
            int marginRight = 0;
            int marginTop = 0;
            int marginBottom = 0;
            Insets margin = this.getMargin();
            if (margin != null) {
                height -= margin.top + margin.bottom;
                width -= margin.left + margin.right;
                marginLeft = margin.left;
                marginRight = margin.right;
                marginTop = margin.top;
                marginBottom = margin.bottom;
            }
            TextStyle textStyle = this.getTextStyle();
            double angle = this.getAngle();
            if (textStyle instanceof AdvancedTextStyle) {
                angle = Math.round(Util.resolveBaselineAngle(textStyle) / 90.0) * 90L;
            }
            String label = this.getLabel();
            ShadowStyle shadow = textStyle.getShadowStyle();
            RasterLabel rl = new RasterLabel();
            if (shadow.isVisible()) {
                rl.shadowColor.setValue(shadow.getColor());
                rl.shadowOn.setValue(shadow.isVisible());
                rl.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
                rl.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
            }
            rl.string.setValue(label);
            rl.setFont(textStyle.getFont());
            rl.color.setValue(textStyle.getColor());
            rl.angle.setValue(angle);
            rl.maxWidth.setValue((double)r.width);
            rl.maxHeight.setValue((double)r.height);
            int justification = textStyle.getJustification();
            switch (justification) {
                case 3: 
                case 4: 
                case 11: {
                    glJust = 2;
                    break;
                }
                default: {
                    glJust = 1;
                    break;
                }
                case 2: 
                case 7: 
                case 10: {
                    glJust = 0;
                }
            }
            rl.horizontalJustification.setValue(glJust);
            double transX = 0.0;
            double transY = 0.0;
            BoundingBox box = new BoundingBox();
            RasterLabel.computeBoundingBox((BoundingBox)box, (Channel)channel, (String)label, (double)angle, (int)0, (int)1, (boolean)false, (boolean)false, (double)width, (double)height, (Font)textStyle.getFont());
            int boxx = (int)box.getSize().x;
            int boxy = (int)box.getSize().y;
            int curExtent = 0;
            int availExtent = 0;
            if (angle == 0.0) {
                curExtent = boxx;
                availExtent = width;
            } else {
                curExtent = boxy;
                availExtent = height;
                glJust = 1;
                rl.verticalJustification.setValue(glJust);
                rl.horizontalJustification.setValue(glJust);
            }
            int startCount = label.length();
            int endCount = 0;
            while (curExtent > availExtent && startCount > 0) {
                String newLabel;
                if (label.length() <= --startCount + endCount) continue;
                label = newLabel = label.substring(0, startCount) + "..." + label.substring(label.length() - endCount, label.length());
                box.makeEmpty();
                RasterLabel.computeBoundingBox((BoundingBox)box, (Channel)channel, (String)label, (double)angle, (int)0, (int)1, (boolean)false, (boolean)false, (double)width, (double)height, (Font)textStyle.getFont());
                curExtent = angle == 0.0 ? (int)box.getSize().x : (int)box.getSize().y;
            }
            rl.string.setValue(label);
            if (Math.sin((double)((int)angle) * (Math.PI / 180)) == 0.0) {
                rl.fit.setValue(false);
                rl.verticalJustification.setValue(1);
                transY = r.height / 2;
                transX = glJust == 1 ? (double)(marginLeft + width / 2) : (glJust == 2 ? (double)(r.width - marginRight) : (double)marginLeft);
            } else if (glJust == 1) {
                transX = width / 2 + marginLeft;
                transY = angle == 0.0 ? (double)(height / 2 + marginBottom - boxy / 2) : (double)(height / 2 + marginBottom);
            } else if (glJust == 2) {
                transX = r.width - marginRight;
                transY = r.height - marginTop - boxy;
            } else {
                transX = marginLeft;
                transY = marginBottom;
            }
            rl.transform.translateX.setValue(transX);
            rl.transform.translateY.setValue(transY);
            this.getComposite().addElement((Element)rl);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && this.node != null) {
                this.performSelection(e);
            } else if (e.getButton() == 3) {
                this.performOLAPAction(e);
            }
        }

        private void performSelection(MouseEvent e) {
            ListSelectionModel selectionModel;
            if (HierarchicalGrid.this.dataSource != null && (selectionModel = HierarchicalGrid.this.dataSource.getDataSourceSelectionModel()) != null) {
                if ((e.getModifiers() & 2) == 0) {
                    selectionModel.clearSelection();
                    this.clearLabelHighlighting();
                }
                Iterator iter = this.node.getValueIndexIterator();
                selectionModel.setValueIsAdjusting(true);
                while (iter.hasNext()) {
                    Integer i = (Integer)iter.next();
                    selectionModel.addSelectionInterval(i, i);
                    this.setBorderSelected();
                }
                selectionModel.setValueIsAdjusting(false);
                this.repaint();
            }
        }

        private void clearLabelHighlighting() {
            int n = HierarchicalGrid.this.valuePanel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JComponent c = (JComponent)HierarchicalGrid.this.valuePanel.getComponent(i);
                if (!(c instanceof LabelComponent2)) continue;
                LabelComponent2 lc = (LabelComponent2)c;
                lc.setBorder(lc.regularBorder);
            }
        }

        @Override
        public void setBorder(Border b) {
            super.setBorder(b);
            this.regularBorder = b;
        }

        public void setBorderSelected() {
            super.setBorder(HierarchicalGrid.this.highlightedBorder);
        }

        private void performOLAPAction(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TextStyle textStyle = this.getTextStyle();
            Container parent = this;
            while (parent.getParent() != null && !((parent = parent.getParent()) instanceof Window)) {
            }
            this.window = new JWindow((Window)parent);
            JLabel label = new JLabel(" " + this.getLabel() + " ");
            label.setBorder(new MatteBorder(1, 1, 1, 1, Color.BLACK));
            label.setForeground(textStyle.getColor());
            this.window.getContentPane().setBackground(this.getBackground());
            this.window.getContentPane().add(label);
            this.window.pack();
            this.window.setLocationRelativeTo(this);
            int yloc = this.window.getY() - this.getBounds().height / 2 + e.getY() - 20;
            this.window.setLocation(this.window.getX(), yloc);
            this.window.setVisible(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.window != null) {
                this.window.dispose();
            }
        }
    }
}

