/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import java.awt.Dimension;

public class GridDimension
extends Dimension {
    private int[] widths;
    private int[] heights;
    private int cachedWidth;
    private int cachedHeight;
    private int equalWidthCount;
    private int equalHeightCount;
    private boolean equalWidths;
    private boolean equalHeights;

    public GridDimension() {
        this._init(0, 0);
    }

    public GridDimension(Dimension d) {
        this.apply((GridDimension)d);
    }

    public GridDimension(int width, int height) {
        this._init(width, height);
    }

    public void apply(Dimension d) {
        if (d == null) {
            return;
        }
        if (d instanceof GridDimension) {
            int i;
            GridDimension that = (GridDimension)d;
            that._enforceTotals();
            this.width = that.width;
            this.height = that.height;
            if (this.widths == null || this.widths.length != that.widths.length) {
                this.widths = new int[that.widths.length];
            }
            for (i = 0; i < this.widths.length; ++i) {
                this.widths[i] = that.widths[i];
            }
            if (this.heights == null || this.heights.length != that.heights.length) {
                this.heights = new int[that.heights.length];
            }
            for (i = 0; i < this.heights.length; ++i) {
                this.heights[i] = that.heights[i];
            }
            this.equalWidthCount = that.equalWidthCount;
            this.equalHeightCount = that.equalHeightCount;
            this.equalWidths = that.equalWidths;
            this.equalHeights = that.equalHeights;
            this._cacheSums();
        } else {
            this._init(d.width, d.height);
        }
    }

    private void _init(int w, int h) {
        this.widths = new int[1];
        this.heights = new int[1];
        this.cachedWidth = this.widths[0] = w;
        this.width = this.widths[0];
        this.cachedHeight = this.heights[0] = h;
        this.height = this.heights[0];
        this.equalHeightCount = 0;
        this.equalWidthCount = 0;
        this.equalHeights = false;
        this.equalWidths = false;
    }

    public static void mergeHeights(GridDimension d0, GridDimension d1) {
        if (d0 == null || d1 == null) {
            return;
        }
        d0._enforceTotals();
        d1._enforceTotals();
        if (d0.equalHeights != d1.equalHeights) {
            int i;
            int h = Math.max(d0._maxRowHeight(), d1._maxRowHeight());
            for (i = 0; i < d0.heights.length; ++i) {
                d0.setRowHeight(i, h);
            }
            for (i = 0; i < d1.heights.length; ++i) {
                d1.setRowHeight(i, h);
            }
        } else {
            int i1 = Math.max(d0.heights.length, d1.heights.length);
            for (int i = 0; i < i1; ++i) {
                int h = Math.max(d0.getRowHeight(i), d1.getRowHeight(i));
                d0.setRowHeight(i, h);
                d1.setRowHeight(i, h);
            }
        }
        d0._cacheSums();
        d1._cacheSums();
    }

    public static void mergeWidths(GridDimension d0, GridDimension d1) {
        if (d0 == null || d1 == null) {
            return;
        }
        d0._enforceTotals();
        d1._enforceTotals();
        if (d0.equalWidths != d1.equalWidths) {
            int i;
            int w = Math.max(d0._maxColWidth(), d1._maxColWidth());
            for (i = 0; i < d0.widths.length; ++i) {
                d0.setColWidth(i, w);
            }
            for (i = 0; i < d1.widths.length; ++i) {
                d1.setColWidth(i, w);
            }
        } else {
            int i1 = Math.max(d0.widths.length, d1.widths.length);
            for (int i = 0; i < i1; ++i) {
                int w = Math.max(d0.getColWidth(i), d1.getColWidth(i));
                d0.setColWidth(i, w);
                d1.setColWidth(i, w);
            }
        }
        d0._cacheSums();
        d1._cacheSums();
    }

    public void setRowHeight(int rowIndex, int rowHeight) {
        if (rowIndex < 0 || rowIndex >= this._numRows()) {
            throw new IllegalArgumentException();
        }
        int rx = this.equalHeights ? 0 : rowIndex;
        this.heights[rx] = rowHeight;
        this._cacheSums();
    }

    public int getRowHeight(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this._numRows()) {
            throw new IllegalArgumentException();
        }
        this._enforceTotals();
        if (this.equalHeights) {
            int h0;
            int remainder = this.height - this.equalHeightCount * (h0 = this.heights[0]);
            return h0 + (rowIndex < remainder ? 1 : 0);
        }
        return this.heights[rowIndex];
    }

    public void mergeRowHeight(int rowIndex, int rowHeight) {
        int rx;
        if (rowIndex < 0 || rowIndex >= this._numRows()) {
            throw new IllegalArgumentException();
        }
        this._enforceTotals();
        int n = rx = this.equalHeights ? 0 : rowIndex;
        if (rowHeight > this.heights[rx]) {
            this.heights[rx] = rowHeight;
            this._cacheSums();
        }
    }

    public void setColWidth(int colIndex, int colWidth) {
        if (colIndex < 0 || colIndex >= this._numCols()) {
            throw new IllegalArgumentException();
        }
        this._enforceTotals();
        int cx = this.equalWidths ? 0 : colIndex;
        this.widths[cx] = colWidth;
        this._cacheSums();
    }

    public int getColWidth(int colIndex) {
        if (colIndex < 0 || colIndex >= this._numCols()) {
            throw new IllegalArgumentException();
        }
        this._enforceTotals();
        if (this.equalWidths) {
            int w0;
            int remainder = this.width - this.equalWidthCount * (w0 = this.widths[0]);
            return w0 + (colIndex < remainder ? 1 : 0);
        }
        return this.widths[colIndex];
    }

    public void mergeColWidth(int colIndex, int colWidth) {
        int cx;
        if (colIndex < 0 || colIndex >= this._numCols()) {
            throw new IllegalArgumentException();
        }
        this._enforceTotals();
        int n = cx = this.equalWidths ? 0 : colIndex;
        if (colWidth > this.widths[cx]) {
            this.widths[cx] = colWidth;
            this._cacheSums();
        }
    }

    public Dimension getGridSize() {
        return new Dimension(this.widths.length, this.heights.length);
    }

    public void setGridSize(Dimension gridSize) {
        this.setGridSize(gridSize.width, gridSize.height);
    }

    public void setGridSize(int colCount, int rowCount) {
        this.setGridSize(colCount, this.equalWidths, rowCount, this.equalHeights);
    }

    public void setGridSize(int colCount, boolean equalColWidths, int rowCount, boolean equalRowHeights) {
        int i;
        int i2;
        int i1;
        int remainder;
        if (rowCount <= 0) {
            throw new IllegalArgumentException();
        }
        if (colCount <= 0) {
            throw new IllegalArgumentException();
        }
        if (equalColWidths == this.equalWidths && colCount == this._numCols() && equalRowHeights == this.equalHeights && rowCount == this._numRows()) {
            return;
        }
        this._enforceTotals();
        if (equalRowHeights != this.equalHeights || rowCount != this._numRows()) {
            int newCachedHeight;
            if (equalRowHeights) {
                if (this.equalHeights) {
                    int h0 = this.heights[0];
                    remainder = this.height - this.equalHeightCount * h0;
                    this.cachedHeight = h0 * rowCount + Math.min(remainder, rowCount);
                } else {
                    int[] newHeights = new int[1];
                    newCachedHeight = 0;
                    i1 = Math.min(rowCount, this.heights.length);
                    for (i2 = 0; i2 < i1; ++i2) {
                        newCachedHeight += this.getRowHeight(i2);
                    }
                    this.cachedHeight = newCachedHeight;
                    this.heights = newHeights;
                }
                this.height = this.cachedHeight;
                this.heights[0] = this.height / rowCount;
                this.equalHeightCount = rowCount;
                this.equalHeights = true;
            } else {
                int[] newHeights = new int[rowCount];
                newCachedHeight = 0;
                for (i = 0; i < rowCount; ++i) {
                    newHeights[i] = i < this._numRows() ? this.getRowHeight(i) : 0;
                    newCachedHeight += newHeights[i];
                }
                this.height = this.cachedHeight = newCachedHeight;
                this.heights = newHeights;
                this.equalHeightCount = 0;
                this.equalHeights = false;
            }
        }
        if (equalColWidths != this.equalWidths || colCount != this._numCols()) {
            int newCachedWidth;
            if (equalColWidths) {
                if (this.equalWidths) {
                    int w0 = this.widths[0];
                    remainder = this.width - this.equalWidthCount * w0;
                    this.cachedWidth = w0 * colCount + Math.min(remainder, colCount);
                } else {
                    int[] newWidths = new int[1];
                    newCachedWidth = 0;
                    i1 = Math.min(colCount, this.widths.length);
                    for (i2 = 0; i2 < i1; ++i2) {
                        newCachedWidth += this.getColWidth(i2);
                    }
                    this.cachedWidth = newCachedWidth;
                    this.widths = newWidths;
                }
                this.width = this.cachedWidth;
                this.widths[0] = this.width / colCount;
                this.equalWidthCount = colCount;
                this.equalWidths = true;
            } else {
                int[] newWidths = new int[colCount];
                newCachedWidth = 0;
                for (i = 0; i < colCount; ++i) {
                    newWidths[i] = i < this._numCols() ? this.getColWidth(i) : 0;
                    newCachedWidth += newWidths[i];
                }
                this.width = this.cachedWidth = newCachedWidth;
                this.widths = newWidths;
                this.equalWidthCount = 0;
                this.equalWidths = false;
            }
        }
    }

    private void _enforceTotals() {
        int i;
        if (this.height != this.cachedHeight) {
            if (this.equalHeights) {
                this.heights[0] = this.height / this.equalHeightCount;
            } else {
                int h = this.height;
                for (i = 0; i < this.heights.length; ++i) {
                    if (h < this.heights[i]) {
                        this.heights[i] = h;
                    }
                    h -= this.heights[i];
                }
                int n = this.heights.length - 1;
                this.heights[n] = this.heights[n] + h;
            }
            this.cachedHeight = this.height;
        }
        if (this.width != this.cachedWidth) {
            if (this.equalWidths) {
                this.widths[0] = this.width / this.equalWidthCount;
            } else {
                int w = this.width;
                for (i = 0; i < this.widths.length; ++i) {
                    if (w < this.widths[i]) {
                        this.widths[i] = w;
                    }
                    w -= this.widths[i];
                }
                int n = this.widths.length - 1;
                this.widths[n] = this.widths[n] + w;
            }
            this.cachedWidth = this.width;
        }
    }

    private void _cacheSums() {
        int i;
        if (this.equalHeights) {
            this.cachedHeight = this.equalHeightCount * this.heights[0];
        } else {
            this.cachedHeight = 0;
            for (i = 0; i < this.heights.length; ++i) {
                this.cachedHeight += this.heights[i];
            }
        }
        if (this.equalWidths) {
            this.cachedWidth = this.equalWidthCount * this.widths[0];
        } else {
            this.cachedWidth = 0;
            for (i = 0; i < this.widths.length; ++i) {
                this.cachedWidth += this.widths[i];
            }
        }
        this.height = this.cachedHeight;
        this.width = this.cachedWidth;
    }

    private int _numRows() {
        return this.equalHeights ? this.equalHeightCount : this.heights.length;
    }

    private int _numCols() {
        return this.equalWidths ? this.equalWidthCount : this.widths.length;
    }

    private int _maxRowHeight() {
        int h = 0;
        if (this.equalHeights) {
            h = this.heights[0];
            if (this.height > this.equalHeightCount * h) {
                ++h;
            }
        } else {
            for (int i = 0; i < this.heights.length; ++i) {
                h = Math.max(h, this.heights[i]);
            }
        }
        return h;
    }

    private int _maxColWidth() {
        int w = 0;
        if (this.equalWidths) {
            w = this.widths[0];
            if (this.width > this.equalWidthCount * w) {
                ++w;
            }
        } else {
            for (int i = 0; i < this.widths.length; ++i) {
                w = Math.max(w, this.widths[i]);
            }
        }
        return w;
    }
}

