/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.MissingValues;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.cell.CategorizationInfo;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericTableModelVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringTableModelVariable;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.BaseBar;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.text.SASFormat;
import com.sas.util.NumericRangeSegment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.Format;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class GTKUtil {
    private static final Color INVISIBLE_COLOR = new Color(0, 0, 0, 0);
    private static final Double sample = new Double(12.3456789);

    public static RendererUtil.DataLabel getDataLabel(int value) {
        switch (value) {
            case 10602: {
                return RendererUtil.DataLabel.CATEGORY;
            }
            case 10610: {
                return RendererUtil.DataLabel.CATEGORY_PERCENT;
            }
            case 10609: {
                return RendererUtil.DataLabel.CATEGORY_RESPONSE;
            }
            case 10611: {
                return RendererUtil.DataLabel.CATEGORY_RESPONSE_PERCENT;
            }
            case 10607: {
                return RendererUtil.DataLabel.COLOR;
            }
            case 10618: {
                return RendererUtil.DataLabel.HEIGHT;
            }
            case 10619: {
                return RendererUtil.DataLabel.HEIGHT_PERCENT;
            }
            case 10620: {
                return RendererUtil.DataLabel.ID;
            }
            case 10615: {
                return RendererUtil.DataLabel.MEAN;
            }
            case 10608: {
                return RendererUtil.DataLabel.PERCENT;
            }
            case 10603: {
                return RendererUtil.DataLabel.RESPONSE;
            }
            case 10612: {
                return RendererUtil.DataLabel.RESPONSE_PERCENT;
            }
            case 10606: {
                return RendererUtil.DataLabel.SIZE;
            }
            case 10613: {
                return RendererUtil.DataLabel.SUBPERCENT;
            }
            case 10614: {
                return RendererUtil.DataLabel.SUM;
            }
            case 10616: {
                return RendererUtil.DataLabel.WIDTH;
            }
            case 10617: {
                return RendererUtil.DataLabel.WIDTH_PERCENT;
            }
            case 10604: {
                return RendererUtil.DataLabel.X;
            }
            case 10605: {
                return RendererUtil.DataLabel.Y;
            }
            case 3: {
                return RendererUtil.DataLabel.EAST;
            }
            case 7: {
                return RendererUtil.DataLabel.WEST;
            }
        }
        return RendererUtil.DataLabel.NONE;
    }

    public static LineStyle convertToGTKLineStyle(com.sas.graphics.components.LineStyle bipLineStyle) {
        LineStyle gtkLineStyle = new LineStyle();
        gtkLineStyle.setColor(bipLineStyle.getColor());
        gtkLineStyle.setVisible(bipLineStyle.getVisibilityPolicy() != 10202);
        gtkLineStyle.setWidth((int)bipLineStyle.getThickness().getMagnitude());
        return gtkLineStyle;
    }

    public static StringVariable newStringVariableFromFormattedUniqueValues(NumericVariable nv) {
        StringVectorVariable stringVariable = new StringVectorVariable();
        stringVariable.connectFrom(nv.formattedUniqueValue);
        return stringVariable;
    }

    public static LineAttributes getLineAttributes(StrokeLineStyle lineStyle) {
        int stippleFactor;
        int stipplePattern;
        int lineWidth = (int)lineStyle.getThickness().getMagnitude((Object)"px");
        if (lineStyle.getSASGraphLineStyle() != 30000) {
            int lineID = lineStyle.getSASGraphLineStyle() - 30001 + 1;
            stipplePattern = SASLinePatterns.getStipplePattern((int)lineID);
            stippleFactor = SASLinePatterns.getStippleFactor((int)lineID);
        } else {
            stipplePattern = 0;
            stippleFactor = 1;
            BasicStroke stroke = lineStyle.getStroke();
            float[] dashes = stroke.getDashArray();
            if (dashes != null) {
                int ii;
                int ofShifts = 0;
                int count = 0;
                stippleFactor = (int)dashes[0];
                for (ii = 1; ii < dashes.length; ++ii) {
                    if (!(dashes[ii] < (float)stippleFactor)) continue;
                    stippleFactor = (int)dashes[ii];
                }
                for (ii = 0; ii < dashes.length; ii += 2) {
                    int onShifts = Math.max(1, (int)dashes[ii] / stippleFactor);
                    int mask = (int)Math.pow(2.0, onShifts) - 1;
                    stipplePattern <<= onShifts;
                    stipplePattern |= mask;
                    ofShifts = ii + 1 == dashes.length ? 0 : (int)dashes[ii + 1] / stippleFactor;
                    stipplePattern <<= ofShifts;
                    count += onShifts + ofShifts;
                }
                int mask = stipplePattern;
                int num = count;
                while (count + num <= 16) {
                    stipplePattern <<= num;
                    stipplePattern |= mask;
                    count += num;
                }
            }
        }
        return new LineAttributes(lineWidth, stipplePattern, stippleFactor);
    }

    public static GTKFormat newGTKFormat(String formatName, Locale locale) {
        SASFormat sasFormat;
        GTKFormat theGTKFormat = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((sasFormat = Util.newSASFormat(formatName, locale)) != null) {
            theGTKFormat = new GTKFormat((Format)sasFormat);
        }
        return theGTKFormat;
    }

    public static GTKFormat newGTKFormat_BEST() {
        return new GTKFormat((Format)SASFormat.getInstance((String)"Best"));
    }

    public static GTKFormat getAxisFormat(Variable[] variables1, Variable[] variables2) {
        Integer formatIndex1 = GTKUtil.getCommonFormatIndex(variables1);
        Integer formatIndex2 = GTKUtil.getCommonFormatIndex(variables2);
        GTKFormat format = null;
        if (formatIndex1 != null || formatIndex2 != null) {
            if (formatIndex1 != null && formatIndex2 != null) {
                if (formatIndex1 >= 0 && formatIndex2 >= 0) {
                    GTKFormat format2;
                    GTKFormat format1 = variables1[formatIndex1].getFormat();
                    if (GTKUtil.equal(format1, format2 = variables2[formatIndex2].getFormat())) {
                        format = format1;
                    } else {
                        int ii;
                        boolean stringVariableExists = false;
                        for (ii = 0; !stringVariableExists && ii < variables1.length - 1; ++ii) {
                            stringVariableExists = variables1[ii] instanceof StringVariable;
                        }
                        for (ii = 0; !stringVariableExists && ii < variables2.length - 1; ++ii) {
                            stringVariableExists = variables2[ii] instanceof StringVariable;
                        }
                        if (!stringVariableExists) {
                            format = GTKUtil.newGTKFormat_BEST();
                        }
                    }
                } else if (formatIndex1 == -1 && formatIndex2 == -1) {
                    format = GTKUtil.newGTKFormat_BEST();
                }
            } else if (formatIndex1 != null) {
                if (formatIndex1 >= 0) {
                    format = variables1[formatIndex1].getFormat();
                } else if (formatIndex1 == -1) {
                    format = GTKUtil.newGTKFormat_BEST();
                }
            } else if (formatIndex2 != null) {
                if (formatIndex2 >= 0) {
                    format = variables2[formatIndex2].getFormat();
                } else if (formatIndex2 == -1) {
                    format = GTKUtil.newGTKFormat_BEST();
                }
            }
        }
        return format;
    }

    public static GTKFormat getAxisFormat(Variable[] variables) {
        Integer formatIndex = GTKUtil.getCommonFormatIndex(variables);
        if (formatIndex != null) {
            int index = formatIndex;
            if (index >= 0) {
                return variables[index].getFormat();
            }
            if (index == -1) {
                return GTKUtil.newGTKFormat_BEST();
            }
            if (index == -2) {
                return new GTKFormat((Format)SASFormat.getInstance((String)"$32767"));
            }
        }
        return null;
    }

    private static Integer getCommonFormatIndex(Variable[] variables) {
        int index = -3;
        if (variables != null) {
            int ii;
            boolean stringVariableExists = false;
            for (ii = 0; !stringVariableExists && ii < variables.length - 1; ++ii) {
                stringVariableExists = variables[ii] instanceof StringVariable;
            }
            for (ii = 0; ii < variables.length; ++ii) {
                if (variables[ii] == null) continue;
                if (index < 0) {
                    index = ii;
                    continue;
                }
                if (GTKUtil.equal(variables[index].getFormat(), variables[ii].getFormat())) continue;
                return stringVariableExists ? new Integer(-2) : new Integer(-1);
            }
        }
        return index == -3 ? null : new Integer(index);
    }

    private static boolean equal(GTKFormat format1, GTKFormat format2) {
        if (format1 != null && format2 != null) {
            boolean format1IsSASFormat = format1.getFormats()[0] instanceof SASFormat;
            boolean format2IsSASFormat = format2.getFormats()[0] instanceof SASFormat;
            if (format1IsSASFormat && format2IsSASFormat) {
                String format1Name = ((SASFormat)format1.getFormats()[0]).getName();
                String format2Name = ((SASFormat)format2.getFormats()[0]).getName();
                if (format1Name != null && format2Name != null) {
                    return format1Name.equalsIgnoreCase(format2Name);
                }
                return format1Name == null && format2Name == null;
            }
            if (!format1IsSASFormat && !format2IsSASFormat) {
                try {
                    String samp1 = format1.format((Object)sample);
                    String samp2 = format2.format((Object)sample);
                    return !samp1.equals(samp2);
                }
                catch (IllegalArgumentException e) {
                    return format1.toString().equals(format2.toString());
                }
            }
            return false;
        }
        return format1 == null && format2 == null;
    }

    public static ValueList toValueList(Variable v, int obsIndex) {
        return GTKUtil.toValueList(v, obsIndex, null);
    }

    public static ValueList toValueList(Variable v, int obsIndex, ValueList valueList) {
        if (v instanceof StringVariable) {
            String formattedValue = VariableAccess.getFormattedValue((StringVariable)v, obsIndex);
            Variable rootVariable = v.getRootVariable();
            Object value = null;
            if (rootVariable instanceof OLAPLevelVariable) {
                value = ((OLAPLevelVariable)rootVariable).getTupleElement(formattedValue);
            } else if (v.getConnection() instanceof NumericVariable) {
                NumericVariable baseVariable = (NumericVariable)v.getConnection();
                value = VariableAccess.getValue(baseVariable, obsIndex);
            } else {
                value = VariableAccess.getValue((StringVariable)v, obsIndex);
            }
            valueList = new ValueList(value, formattedValue, valueList);
        } else if (v instanceof NumericVariable) {
            valueList = new ValueList(VariableAccess.getValue((NumericVariable)v, obsIndex), VariableAccess.getFormattedValue((NumericVariable)v, obsIndex), valueList);
        }
        return valueList;
    }

    public static ValueList toValueList(StringPipe stringPipe, Variable v, int obsIndex, ValueList valueList) {
        String formattedValue = (String)PipeAccess.getValue(stringPipe, obsIndex);
        Variable rootVariable = v.getRootVariable();
        Object value = null;
        value = rootVariable instanceof OLAPLevelVariable ? ((OLAPLevelVariable)rootVariable).getTupleElement(formattedValue) : PipeAccess.getValue(stringPipe, obsIndex);
        valueList = new ValueList(value, formattedValue, valueList);
        return valueList;
    }

    public static ValueList toValueList(Variable[] variableArray, int obsIndex) {
        return GTKUtil.toValueList(variableArray, obsIndex, null);
    }

    public static ValueList toValueList(Variable[] variableArray, int obsIndex, ValueList valueList) {
        if (variableArray != null) {
            for (int ii = variableArray.length - 1; ii >= 0; --ii) {
                Variable variable = variableArray[ii];
                valueList = GTKUtil.toValueList(variable, obsIndex, valueList);
            }
        }
        return valueList;
    }

    public static DataTreeGroupNode[] getLeafNodes(ValueTree tree) {
        if (tree == null) {
            return null;
        }
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DefaultMutableTreeNode[] temp = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)root);
        if (temp.length < 1) {
            return new DataTreeGroupNode[]{root};
        }
        DataTreeGroupNode[] leaves = new DataTreeGroupNode[temp.length];
        System.arraycopy(temp, 0, leaves, 0, temp.length);
        return leaves;
    }

    public static void applyFillStyle(Grid grid, FillStyle fillStyle) {
        if (grid != null && fillStyle != null) {
            GridStyle gridStyle = grid.getStyle();
            gridStyle.setBorderOn(false);
            gridStyle.setBackgroundOn(fillStyle.isVisible());
            if (gridStyle.isBackgroundOn()) {
                if (fillStyle.getFillType() == 20000 || fillStyle.getFillType() == 20003) {
                    gridStyle.setBackgroundColor(fillStyle.getSolidFillColor());
                }
                if (fillStyle.getFillType() == 20001 || fillStyle.getFillType() == 20004) {
                    gridStyle.setGradientOn(true);
                    int gradientDirection = 1;
                    switch (fillStyle.getGradientFill()) {
                        case 20104: {
                            gradientDirection = 3;
                            break;
                        }
                        case 20103: {
                            gradientDirection = 2;
                            break;
                        }
                        case 20100: {
                            gradientDirection = 0;
                        }
                    }
                    if (gradientDirection == 1) {
                        gridStyle.setBackgroundColor(fillStyle.getGradientFillEndColor());
                        gridStyle.setBackgroundColor2(fillStyle.getGradientFillBeginColor());
                    } else {
                        gridStyle.setBackgroundColor(fillStyle.getGradientFillBeginColor());
                        gridStyle.setBackgroundColor2(fillStyle.getGradientFillEndColor());
                    }
                    gridStyle.setGradientDirection(gradientDirection);
                }
                if ((fillStyle.getFillType() == 20002 || fillStyle.getFillType() == 20003 || fillStyle.getFillType() == 20004) && fillStyle.getImageIcon() != null) {
                    gridStyle.setBackgroundImage(fillStyle.getImageIcon().getImage());
                }
            }
        }
    }

    public static com.sas.graphics.util.gtk.TextStyle mapToGTKTextStyle(TextStyle bipTextStyle) {
        if (bipTextStyle == null) {
            return null;
        }
        com.sas.graphics.util.gtk.TextStyle gtkTextStyle = new com.sas.graphics.util.gtk.TextStyle();
        gtkTextStyle.setFont(bipTextStyle.getFont());
        gtkTextStyle.setColor(bipTextStyle.getColor());
        gtkTextStyle.setHorizontalJustification(bipTextStyle.getJustification());
        ShadowStyle shadow = bipTextStyle.getShadowStyle();
        if (shadow != null) {
            gtkTextStyle.setShadowOn(shadow.isVisible());
            gtkTextStyle.setShadowColor(shadow.getColor());
            gtkTextStyle.setShadowOffsetX((int)shadow.getOffsetX().getMagnitude((Object)"px"));
            gtkTextStyle.setShadowOffsetY((int)shadow.getOffsetY().getMagnitude((Object)"px"));
            gtkTextStyle.setShadowSoftness((float)shadow.getSoftness());
        }
        return gtkTextStyle;
    }

    public static com.sas.graphics.util.gtk.TextStyle mapAdvancedTextStyleToGTKTextStyle(AdvancedTextStyle bipTextStyle) {
        if (bipTextStyle == null) {
            return null;
        }
        com.sas.graphics.util.gtk.TextStyle gtkTextStyle = GTKUtil.mapToGTKTextStyle(bipTextStyle);
        if (gtkTextStyle == null) {
            return null;
        }
        gtkTextStyle.setAngle(bipTextStyle.getBaselineAngle());
        return gtkTextStyle;
    }

    public static LineStyle mapToGTKLineStyle(com.sas.graphics.components.LineStyle bipLineStyle) {
        if (bipLineStyle == null) {
            return null;
        }
        LineStyle gtkLineStyle = new LineStyle();
        gtkLineStyle.setColor(bipLineStyle.getColor());
        if (bipLineStyle.getVisibilityPolicy() != 10202) {
            gtkLineStyle.setVisible(true);
        } else {
            gtkLineStyle.setVisible(false);
        }
        gtkLineStyle.setWidth((int)bipLineStyle.getThickness().getMagnitude((Object)"px"));
        return gtkLineStyle;
    }

    public static class BarAttributes {
        public static void applyFillStyle(Bar bar, FillStyle fillStyle) {
            bar.fillOn.setValue(fillStyle.isVisible());
            if (fillStyle.isVisible()) {
                int fillType = fillStyle.getFillType();
                bar.color1.setValue(fillStyle.getSolidFillColor());
                boolean gradientFillEnabled = fillType == 20001 || fillType == 20004;
                bar.gradientOn.setValue(gradientFillEnabled);
                if (gradientFillEnabled) {
                    switch (fillStyle.getGradientFill()) {
                        default: {
                            bar.gradientDirection.setValue(1);
                            break;
                        }
                        case 20104: {
                            bar.gradientDirection.setValue(3);
                            break;
                        }
                        case 20103: {
                            bar.gradientDirection.setValue(2);
                            break;
                        }
                        case 20100: {
                            bar.gradientDirection.setValue(0);
                        }
                    }
                    if (fillStyle.getGradientFill() == 20101) {
                        bar.color1.setValue(fillStyle.getGradientFillEndColor());
                        bar.color2.setValue(fillStyle.getGradientFillBeginColor());
                    } else {
                        bar.color1.setValue(fillStyle.getGradientFillBeginColor());
                        bar.color2.setValue(fillStyle.getGradientFillEndColor());
                    }
                }
                boolean imageFillEnabled = fillStyle.getImageIcon() != null && fillStyle.getImageIcon().getImage() != null && (fillType == 20002 || fillType == 20003 || fillType == 20004);
                bar.textureOn.setValue(imageFillEnabled);
                if (imageFillEnabled) {
                    bar.textureMode.setValue(fillType == 20003 ? 3 : 2);
                    bar.textureStyle.setValue(fillStyle.getImageFill() == 20200 ? 4 : 5);
                    bar.setTextureImage(new BufferedImage[]{BaseBar.convertImageToBufferedImage((Image)fillStyle.getImageIcon().getImage())});
                    bar.textureIndex.setValue(0);
                    if (fillType == 20003) {
                        bar.color1.setValue(fillStyle.getSolidBlendColor());
                    } else if (fillType == 20004) {
                        if (fillStyle.getGradientFill() == 20101) {
                            bar.color1.setValue(fillStyle.getGradientBlendEndColor());
                            bar.color2.setValue(fillStyle.getGradientBlendBeginColor());
                        } else {
                            bar.color1.setValue(fillStyle.getGradientBlendBeginColor());
                            bar.color2.setValue(fillStyle.getGradientBlendEndColor());
                        }
                    }
                }
            }
        }
    }

    public static class LineAttributes {
        public final int lineWidth;
        public final int stipplePattern;
        public final int stippleFactor;

        private LineAttributes(int w, int p, int f) {
            this.lineWidth = w;
            this.stipplePattern = p;
            this.stippleFactor = f;
        }
    }

    public static abstract class VariableAccess {
        private static void _validateVaraible(Variable v) {
            if (v == null) {
                throw new IllegalArgumentException("null variable not allowed");
            }
        }

        public static Object getRootValue(Variable v, int obsIndex) {
            Variable rv;
            if (v == null) {
                return null;
            }
            VariableAccess._validateVaraible(v);
            if (v instanceof StringVariable && (rv = ((StringVariable)v).getRootVariable()) != null) {
                v = rv;
            }
            return VariableAccess.getValue(v, obsIndex);
        }

        private static StringPipe _valuePipe(StringVariable sv) {
            VariableAccess._validateVaraible((Variable)sv);
            return sv.value;
        }

        private static NumericPipe _valuePipe(NumericVariable nv) {
            VariableAccess._validateVaraible((Variable)nv);
            return nv.value;
        }

        private static StringPipe _uniqueValuePipe(StringVariable sv) {
            VariableAccess._validateVaraible((Variable)sv);
            return sv.uniqueValue;
        }

        private static NumericPipe _uniqueValuePipe(NumericVariable nv) {
            VariableAccess._validateVaraible((Variable)nv);
            return nv.uniqueValue;
        }

        private static StringPipe _formattedValuePipe(StringVariable sv) {
            VariableAccess._validateVaraible((Variable)sv);
            return sv.formattedValue;
        }

        private static StringPipe _formattedValuePipe(NumericVariable nv) {
            VariableAccess._validateVaraible((Variable)nv);
            return nv.formattedValue;
        }

        private static StringPipe _formattedUniqueValuePipe(StringVariable sv) {
            VariableAccess._validateVaraible((Variable)sv);
            return sv.formattedUniqueValue;
        }

        private static StringPipe _formattedUniqueValuePipe(NumericVariable nv) {
            VariableAccess._validateVaraible((Variable)nv);
            return nv.formattedUniqueValue;
        }

        public static Object getValue(Variable v, int obsIndex) {
            if (v == null) {
                return null;
            }
            if (v instanceof StringVariable) {
                return VariableAccess.getValue((StringVariable)v, obsIndex);
            }
            if (v instanceof NumericVariable) {
                return VariableAccess.getValue((NumericVariable)v, obsIndex);
            }
            throw new UnsupportedOperationException("Unrecognized Variable type.");
        }

        public static Object getValue(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return PipeAccess.getValue(VariableAccess._valuePipe(sv), obsIndex);
        }

        public static Object getValue(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                return null;
            }
            return PipeAccess.getValue(VariableAccess._valuePipe(nv), obsIndex);
        }

        public static String getValue_as_String(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return PipeAccess.getValue_as_String(VariableAccess._valuePipe(sv), obsIndex);
        }

        public static String getValue_as_StringTrim(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return PipeAccess.getValue_as_String(VariableAccess._valuePipe(sv), obsIndex).trim();
        }

        public static double getValue_as_double(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                throw new IllegalArgumentException("null variable not allowed");
            }
            return PipeAccess.getValue_as_double(VariableAccess._valuePipe(nv), obsIndex);
        }

        public static String getFormattedValue(Variable v, int obsIndex) {
            if (v == null) {
                return null;
            }
            if (v instanceof StringVariable) {
                return VariableAccess.getFormattedValue((StringVariable)v, obsIndex);
            }
            if (v instanceof NumericVariable) {
                return VariableAccess.getFormattedValue((NumericVariable)v, obsIndex);
            }
            throw new UnsupportedOperationException("Unrecognized Variable type.");
        }

        public static String getFormattedValue(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return VariableAccess._getFormattedValue(sv, obsIndex, false);
        }

        public static String getFormattedValue(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                return null;
            }
            return VariableAccess._getFormattedValue(nv, obsIndex, false);
        }

        public static String getFormattedValueTrim(Variable v, int obsIndex) {
            if (v == null) {
                return null;
            }
            if (v instanceof StringVariable) {
                return VariableAccess.getFormattedValueTrim((StringVariable)v, obsIndex);
            }
            if (v instanceof NumericVariable) {
                return VariableAccess.getFormattedValueTrim((NumericVariable)v, obsIndex);
            }
            throw new UnsupportedOperationException("Unrecognized Variable type.");
        }

        public static String getFormattedValueTrim(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return VariableAccess._getFormattedValue(sv, obsIndex, true);
        }

        public static String getFormattedValueTrim(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                return null;
            }
            return VariableAccess._getFormattedValue(nv, obsIndex, true);
        }

        private static String _getFormattedValue(StringVariable sv, int obsIndex, boolean trimEnabled) {
            if (sv == null) {
                return null;
            }
            String formattedValue = PipeAccess.getValue_as_String(VariableAccess._formattedValuePipe(sv), obsIndex);
            if (formattedValue != null && trimEnabled) {
                formattedValue = formattedValue.trim();
            }
            return formattedValue;
        }

        private static String _getFormattedValue(NumericVariable nv, int obsIndex, boolean trimEnabled) {
            String formattedValue = PipeAccess.getValue_as_String(VariableAccess._formattedValuePipe(nv), obsIndex);
            if (formattedValue != null && trimEnabled) {
                formattedValue = formattedValue.trim();
            }
            return formattedValue;
        }

        public static Object getUniqueValue(Variable v, int obsIndex) {
            if (v == null) {
                return null;
            }
            if (v instanceof StringVariable) {
                return VariableAccess.getUniqueValue((StringVariable)v, obsIndex);
            }
            if (v instanceof NumericVariable) {
                return VariableAccess.getUniqueValue((NumericVariable)v, obsIndex);
            }
            throw new UnsupportedOperationException("Unrecognized Variable type.");
        }

        public static Object getUniqueValue(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return PipeAccess.getValue(VariableAccess._uniqueValuePipe(sv), obsIndex);
        }

        public static Object getUniqueValue(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                return null;
            }
            return PipeAccess.getValue(VariableAccess._uniqueValuePipe(nv), obsIndex);
        }

        public static String getUniqueValue_as_String(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return PipeAccess.getValue_as_String(VariableAccess._uniqueValuePipe(sv), obsIndex);
        }

        public static String getUniqueValue_as_StringTrim(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return PipeAccess.getValue_as_String(VariableAccess._uniqueValuePipe(sv), obsIndex).trim();
        }

        public static double getUniqueValue_as_double(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                throw new IllegalArgumentException("null variable not allowed");
            }
            return PipeAccess.getValue_as_double(VariableAccess._uniqueValuePipe(nv), obsIndex);
        }

        public static String getFormattedUniqueValue(Variable v, int obsIndex) {
            if (v == null) {
                return null;
            }
            if (v instanceof StringVariable) {
                return VariableAccess.getFormattedUniqueValue((StringVariable)v, obsIndex);
            }
            if (v instanceof NumericVariable) {
                return VariableAccess.getFormattedUniqueValue((NumericVariable)v, obsIndex);
            }
            throw new UnsupportedOperationException("Unrecognized Variable type.");
        }

        public static String getFormattedUniqueValue(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return VariableAccess._getFormattedUniqueValue(sv, obsIndex, false);
        }

        public static String getFormattedUniqueValue(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                return null;
            }
            return VariableAccess._getFormattedUniqueValue(nv, obsIndex, false);
        }

        public static String getFormattedUniqueValueTrim(Variable v, int obsIndex) {
            if (v == null) {
                return null;
            }
            if (v instanceof StringVariable) {
                return VariableAccess.getFormattedUniqueValueTrim((StringVariable)v, obsIndex);
            }
            if (v instanceof NumericVariable) {
                return VariableAccess.getFormattedUniqueValueTrim((NumericVariable)v, obsIndex);
            }
            throw new UnsupportedOperationException("Unrecognized Variable type.");
        }

        public static String getFormattedUniqueValueTrim(StringVariable sv, int obsIndex) {
            if (sv == null) {
                return null;
            }
            return VariableAccess._getFormattedUniqueValue(sv, obsIndex, true);
        }

        public static String getFormattedUniqueValueTrim(NumericVariable nv, int obsIndex) {
            if (nv == null) {
                return null;
            }
            return VariableAccess._getFormattedUniqueValue(nv, obsIndex, true);
        }

        private static String _getFormattedUniqueValue(StringVariable sv, int obsIndex, boolean trimEnabled) {
            if (sv == null) {
                return null;
            }
            String formattedUniqueValue = PipeAccess.getValue_as_String(VariableAccess._formattedUniqueValuePipe(sv), obsIndex);
            if (formattedUniqueValue != null && trimEnabled) {
                formattedUniqueValue = formattedUniqueValue.trim();
            }
            return formattedUniqueValue;
        }

        private static String _getFormattedUniqueValue(NumericVariable nv, int obsIndex, boolean trimEnabled) {
            if (nv == null) {
                return null;
            }
            String formattedUniqueValue = PipeAccess.getValue_as_String(VariableAccess._formattedUniqueValuePipe(nv), obsIndex);
            if (formattedUniqueValue != null && trimEnabled) {
                formattedUniqueValue = formattedUniqueValue.trim();
            }
            return formattedUniqueValue;
        }

        public static Object asValue(StringTableModelVariable sv, Object valueAsObject) {
            if (sv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)sv);
            try {
                return sv.getValue(valueAsObject);
            }
            catch (MissingValueException e) {
                return e.getMissingValue();
            }
        }

        public static String asValue_as_String(StringTableModelVariable sv, Object valueAsObject) {
            if (sv == null) {
                return null;
            }
            Object value = VariableAccess.asValue(sv, valueAsObject);
            if (value instanceof String) {
                return (String)value;
            }
            return ValueMap.getDefaultMissingValueLabel((MissingValues)MissingValues._BLANK_);
        }

        public static Object asValue(NumericTableModelVariable nv, Object valueAsObject) {
            if (nv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)nv);
            try {
                return new Double(nv.getValue(valueAsObject));
            }
            catch (MissingValueException e) {
                return e.getMissingValue();
            }
        }

        public static double asValue_as_double(NumericTableModelVariable nv, Object valueAsObject) {
            if (nv == null) {
                throw new IllegalArgumentException("null variable not allowed");
            }
            VariableAccess._validateVaraible((Variable)nv);
            try {
                return nv.getValue(valueAsObject);
            }
            catch (MissingValueException e) {
                return Double.NaN;
            }
        }

        public static Object asValue(OLAPMeasureVariable nv, Object valueAsObject) {
            if (nv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)nv);
            try {
                return new Double(nv.getValue(valueAsObject));
            }
            catch (MissingValueException e) {
                return e.getMissingValue();
            }
        }

        public static double asValue_as_double(OLAPMeasureVariable nv, Object valueAsObject) {
            if (nv == null) {
                throw new IllegalArgumentException("null variable not allowed");
            }
            VariableAccess._validateVaraible((Variable)nv);
            try {
                return nv.getValue(valueAsObject);
            }
            catch (MissingValueException e) {
                return Double.NaN;
            }
        }

        public static Object asValue(OLAPLevelVariable sv, Object valueAsObject) {
            if (sv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)sv);
            if (valueAsObject instanceof String) {
                return sv.getValue((String)valueAsObject);
            }
            throw new UnsupportedOperationException("Unsupported type, only string values can be processed by OLAPLevelVariable.");
        }

        public static String asFormattedValue(StringTableModelVariable sv, Object valueAsObject) {
            if (sv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)sv);
            return sv.getFormattedValue(valueAsObject);
        }

        public static String asFormattedValueTrim(StringTableModelVariable sv, Object valueAsObject) {
            if (sv == null) {
                return null;
            }
            return VariableAccess.asFormattedValue(sv, valueAsObject).trim();
        }

        public static String asFormattedValue(NumericTableModelVariable nv, Object valueAsObject) {
            if (nv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)nv);
            return nv.getFormattedValue(valueAsObject);
        }

        public static String asFormattedValueTrim(NumericTableModelVariable nv, Object valueAsObject) {
            if (nv == null) {
                return null;
            }
            return VariableAccess.asFormattedValue(nv, valueAsObject).trim();
        }

        public static String asFormattedValue(OLAPMeasureVariable nv, Object valueAsObject) {
            if (nv == null) {
                return null;
            }
            VariableAccess._validateVaraible((Variable)nv);
            return nv.getFormattedValue(valueAsObject);
        }

        public static String asFormattedValueTrim(OLAPMeasureVariable nv, Object valueAsObject) {
            return VariableAccess.asFormattedValue(nv, valueAsObject).trim();
        }
    }

    public static abstract class PipeAccess {
        private static int _init(Pipe p) {
            if (p == null) {
                throw new IllegalArgumentException("null pipe not allowed");
            }
            AInitAction ia = new AInitAction();
            p.init(ia);
            return ia.getValueCount();
        }

        public static void init(Pipe p) {
            PipeAccess._init(p);
        }

        public static int count(Pipe p) {
            return PipeAccess._init(p);
        }

        public static Object getValue(StringPipe sp, int obsIndex) {
            PipeAccess.init((Pipe)sp);
            return PipeAccess._getValueNoInit(sp, obsIndex);
        }

        private static Object _getValueNoInit(StringPipe sp, int obsIndex) {
            try {
                return sp.getValue(obsIndex);
            }
            catch (MissingValueException e) {
                return e.getMissingValue();
            }
        }

        public static String getValue_as_String(StringPipe sp, int obsIndex) {
            Object value = PipeAccess.getValue(sp, obsIndex);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof MissingValues) {
                return ValueMap.getDefaultMissingValueLabel((MissingValues)MissingValues._BLANK_);
            }
            return null;
        }

        public static String[] getValues_as_StringArray(StringPipe sp) {
            int count = PipeAccess.count((Pipe)sp);
            String[] array = new String[count];
            for (int ii = 0; ii < count; ++ii) {
                Object value = PipeAccess._getValueNoInit(sp, ii);
                array[ii] = value instanceof String ? (String)value : ValueMap.getDefaultMissingValueLabel((MissingValues)MissingValues._BLANK_);
            }
            return array;
        }

        public static Vector getValues_as_Vector(StringPipe sp) {
            int count = PipeAccess.count((Pipe)sp);
            Vector<Object> vector = new Vector<Object>(count);
            for (int ii = 0; ii < count; ++ii) {
                vector.add(PipeAccess._getValueNoInit(sp, ii));
            }
            return vector;
        }

        public static String getFormattedValue(StringPipe sp, int obsIndex) {
            return PipeAccess._getFormattedValue(sp, obsIndex, false);
        }

        public static String getFormattedValueTrim(StringPipe sp, int obsIndex) {
            return PipeAccess._getFormattedValue(sp, obsIndex, false);
        }

        private static String _getFormattedValue(StringPipe sp, int obsIndex, boolean trimEnabled) {
            PipeAccess.init((Pipe)sp);
            String formattedValue = sp.getFormatter().format(PipeAccess.getValue(sp, obsIndex));
            if (trimEnabled && formattedValue != null) {
                formattedValue = formattedValue.trim();
            }
            return formattedValue;
        }

        public static Object getValue(NumericPipe np, int obsIndex) {
            PipeAccess.init((Pipe)np);
            return PipeAccess._getValueNoInit(np, obsIndex);
        }

        private static Object _getValueNoInit(NumericPipe np, int obsIndex) {
            try {
                return new Double(np.getValue(obsIndex));
            }
            catch (MissingValueException e) {
                return e.getMissingValue();
            }
        }

        public static double getValue_as_double(NumericPipe np, int obsIndex) {
            PipeAccess.init((Pipe)np);
            return PipeAccess.getValue_as_double_NoInit(np, obsIndex);
        }

        private static double getValue_as_double_NoInit(NumericPipe np, int obsIndex) {
            try {
                return np.getValue(obsIndex);
            }
            catch (MissingValueException e) {
                return Double.NaN;
            }
        }

        public static double[] getValues_as_doubleArray(NumericPipe np) {
            int count = PipeAccess.count((Pipe)np);
            double[] array = new double[count];
            for (int ii = 0; ii < count; ++ii) {
                array[ii] = PipeAccess.getValue_as_double_NoInit(np, ii);
            }
            return array;
        }

        public static Double getValue_as_Double(NumericPipe np, int obsIndex) {
            PipeAccess.init((Pipe)np);
            return PipeAccess.getValue_as_Double_NoInit(np, obsIndex);
        }

        private static Double getValue_as_Double_NoInit(NumericPipe np, int obsIndex) {
            try {
                return new Double(np.getValue(obsIndex));
            }
            catch (MissingValueException e) {
                return new Double(Double.NaN);
            }
        }

        public static Double[] getValues_as_DoubleArray(NumericPipe np) {
            int count = PipeAccess.count((Pipe)np);
            Double[] array = new Double[count];
            for (int ii = 0; ii < count; ++ii) {
                array[ii] = PipeAccess.getValue_as_Double_NoInit(np, ii);
            }
            return array;
        }

        public static Vector getValues_as_Vector(NumericPipe np) {
            int count = PipeAccess.count((Pipe)np);
            Vector<Object> vector = new Vector<Object>(count);
            for (int ii = 0; ii < count; ++ii) {
                vector.add(PipeAccess._getValueNoInit(np, ii));
            }
            return vector;
        }

        public static Object getValue(IntegerPipe ip, int obsIndex) {
            PipeAccess.init((Pipe)ip);
            return PipeAccess._getValueNoInit(ip, obsIndex);
        }

        private static Object _getValueNoInit(IntegerPipe ip, int obsIndex) {
            try {
                return new Double(ip.getValue(obsIndex));
            }
            catch (MissingValueException e) {
                return e.getMissingValue();
            }
        }

        public static int getValue_as_int(IntegerPipe ip, int obsIndex, int missingValueReplacement) {
            PipeAccess.init((Pipe)ip);
            return PipeAccess.getValue_as_int_NoInit(ip, obsIndex, missingValueReplacement);
        }

        private static int getValue_as_int_NoInit(IntegerPipe ip, int obsIndex, int missingValueReplacement) {
            try {
                return ip.getValue(obsIndex);
            }
            catch (MissingValueException e) {
                return missingValueReplacement;
            }
        }

        public static int[] getValues_as_intArray(IntegerPipe ip, int missingValueReplacement) {
            int count = PipeAccess.count((Pipe)ip);
            int[] array = new int[count];
            for (int ii = 0; ii < count; ++ii) {
                array[ii] = PipeAccess.getValue_as_int_NoInit(ip, ii, missingValueReplacement);
            }
            return array;
        }

        public static Integer getValue_as_Integer(IntegerPipe ip, int obsIndex, Integer missingValueReplacement) {
            PipeAccess.init((Pipe)ip);
            return PipeAccess.getValue_as_Integer_NoInit(ip, obsIndex, missingValueReplacement);
        }

        private static Integer getValue_as_Integer_NoInit(IntegerPipe ip, int obsIndex, Integer missingValueReplacement) {
            try {
                return new Integer(ip.getValue(obsIndex));
            }
            catch (MissingValueException e) {
                return missingValueReplacement;
            }
        }

        public static Integer[] getValues_as_IntegerArray(IntegerPipe ip, Integer missingValueReplacement) {
            int count = PipeAccess.count((Pipe)ip);
            Integer[] array = new Integer[count];
            for (int ii = 0; ii < count; ++ii) {
                array[ii] = PipeAccess.getValue_as_Integer_NoInit(ip, ii, missingValueReplacement);
            }
            return array;
        }

        public static Vector getValues_as_Vector(IntegerPipe ip) {
            int count = PipeAccess.count((Pipe)ip);
            Vector<Object> vector = new Vector<Object>(count);
            for (int ii = 0; ii < count; ++ii) {
                vector.add(PipeAccess._getValueNoInit(ip, ii));
            }
            return vector;
        }

        public static String getFormattedValue(NumericPipe np, int obsIndex) {
            return PipeAccess._getFormattedValue(np, obsIndex, false);
        }

        public static String getFormattedValueTrim(NumericPipe np, int obsIndex) {
            return PipeAccess._getFormattedValue(np, obsIndex, false);
        }

        private static String _getFormattedValue(NumericPipe np, int obsIndex, boolean trimEnabled) {
            PipeAccess.init((Pipe)np);
            String formattedValue = np.getFormatter().format(PipeAccess.getValue(np, obsIndex));
            if (trimEnabled && formattedValue != null) {
                formattedValue = formattedValue.trim();
            }
            return formattedValue;
        }
    }

    public static class MapperFactory {
        public static StringToColorMapper newFormattedValueStringToColorMapper(Variable variable, FillStyle[] fillStyles, Color[] cycleColors) {
            return MapperFactory._newFormattedValueStringToColorMapper(variable, fillStyles, cycleColors);
        }

        public static StringToColorMapper newFormattedValueStringToColorMapper(Variable variable, com.sas.graphics.components.LineStyle[] lineStyles, Color[] cycleColors) {
            return MapperFactory._newFormattedValueStringToColorMapper(variable, lineStyles, cycleColors);
        }

        public static StringToColorMapper newFormattedValueStringToColorMapper(Variable variable, MarkerStyle[] markerStyles, Color[] cycleColors) {
            return MapperFactory._newFormattedValueStringToColorMapper(variable, markerStyles, cycleColors);
        }

        public static StringToColorMapper newFormattedValueStringToColorMapper(Variable variable, Color[] colors, Color[] cycleColors) {
            return MapperFactory._newFormattedValueStringToColorMapper(variable, colors, cycleColors);
        }

        public static StringToColorMapper newStringToColorMapper(String[] values, FillStyle[] fillStyles, Color[] cycleColors) {
            return MapperFactory._newStringToColorMapper(values, fillStyles, cycleColors);
        }

        private static StringToColorMapper _newFormattedValueStringToColorMapper(Variable variable, Object[] colors, Color[] cycleColors) {
            if (variable == null || colors == null || colors.length < 1) {
                return null;
            }
            StringVariable stringVariable = null;
            if (variable instanceof NumericVariable) {
                stringVariable = GTKUtil.newStringVariableFromFormattedUniqueValues((NumericVariable)variable);
            } else if (variable instanceof StringVariable) {
                stringVariable = (StringVariable)variable;
            }
            StringToColorMapper colorMapper = new StringToColorMapper();
            int uvc = stringVariable.getUniqueValueCount();
            for (int ii = 0; ii < uvc; ++ii) {
                Object colorObj = colors[ii % colors.length];
                Color color = INVISIBLE_COLOR;
                if (colorObj instanceof Color) {
                    color = (Color)colorObj;
                } else if (colorObj instanceof FillStyle) {
                    color = ((FillStyle)colorObj).getSolidFillColor();
                } else if (colorObj instanceof com.sas.graphics.components.LineStyle) {
                    color = ((com.sas.graphics.components.LineStyle)colorObj).getColor();
                } else if (colorObj instanceof MarkerStyle) {
                    color = ((MarkerStyle)colorObj).getColor();
                }
                boolean isVisible = false;
                if (colorObj instanceof Color) {
                    isVisible = true;
                } else if (colorObj instanceof FillStyle) {
                    isVisible = ((FillStyle)colorObj).isVisible();
                } else if (colorObj instanceof com.sas.graphics.components.LineStyle) {
                    isVisible = ((com.sas.graphics.components.LineStyle)colorObj).getVisibilityPolicy() != 10202;
                } else if (colorObj instanceof MarkerStyle) {
                    isVisible = ((MarkerStyle)colorObj).isVisible();
                }
                if (isVisible && ii / colors.length > 0) {
                    color = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, ii);
                }
                colorMapper.add(VariableAccess.getFormattedUniqueValue(stringVariable, ii), color);
            }
            colorMapper.input.connectFrom(stringVariable.formattedValue);
            return colorMapper;
        }

        private static StringToColorMapper _newStringToColorMapper(String[] values, Object[] colors, Color[] cycleColors) {
            if (values == null || colors == null || colors.length < 1) {
                return null;
            }
            StringToColorMapper colorMapper = new StringToColorMapper();
            StringVector sv = new StringVector(values.length);
            for (int ii = 0; ii < values.length; ++ii) {
                Color color = INVISIBLE_COLOR;
                boolean isVisible = false;
                Object colorObj = colors[ii % colors.length];
                if (colorObj instanceof Color) {
                    color = (Color)colorObj;
                    isVisible = true;
                } else if (colorObj instanceof FillStyle) {
                    color = ((FillStyle)colorObj).getSolidFillColor();
                    isVisible = ((FillStyle)colorObj).isVisible();
                }
                if (isVisible && ii / colors.length > 0) {
                    color = com.sas.graphics.components.util.Util.newCycledColor(cycleColors, ii);
                }
                colorMapper.add(values[ii], color);
                sv.addValue(values[ii]);
            }
            colorMapper.input.connectFrom((StringPipe)sv);
            return colorMapper;
        }

        public static StringToNumberMapper newFormattedValueStringToNumberMapper(Variable variable, FillStyle[] fillStyles) {
            return MapperFactory._newFormattedValueStringToNumberMapper(variable, fillStyles);
        }

        public static StringToNumberMapper newFormattedValueStringToNumberMapper(Variable variable, com.sas.graphics.components.LineStyle[] lineStyles) {
            return MapperFactory._newFormattedValueStringToNumberMapper(variable, lineStyles);
        }

        public static StringToNumberMapper newFormattedValueStringToNumberMapper(Variable variable, MarkerStyle[] markerStyles) {
            return MapperFactory._newFormattedValueStringToNumberMapper(variable, markerStyles);
        }

        public static StringToNumberMapper newFormattedValueStringToNumberMapper(Variable variable, Integer[] numbers) {
            return MapperFactory._newFormattedValueStringToNumberMapper(variable, numbers);
        }

        private static StringToNumberMapper _newFormattedValueStringToNumberMapper(Variable variable, Object[] numbers) {
            if (variable == null || numbers == null || numbers.length < 1) {
                return null;
            }
            StringVariable stringVariable = null;
            if (variable instanceof NumericVariable) {
                stringVariable = GTKUtil.newStringVariableFromFormattedUniqueValues((NumericVariable)variable);
            } else if (variable instanceof StringVariable) {
                stringVariable = (StringVariable)variable;
            }
            StringToNumberMapper numberMapper = new StringToNumberMapper();
            int uvc = stringVariable.getUniqueValueCount();
            Integer number = null;
            for (int ii = 0; ii < uvc; ++ii) {
                Object obj = numbers[ii % numbers.length];
                number = obj instanceof Integer ? (Integer)obj : (obj instanceof MarkerStyle ? new Integer(((MarkerStyle)obj).getSymbol()) : new Integer(ii));
                numberMapper.add(VariableAccess.getFormattedUniqueValue(stringVariable, ii), (Number)number);
            }
            numberMapper.input.connectFrom(stringVariable.formattedValue);
            return numberMapper;
        }

        public static ContinuousRangeToColorMapper newContinuousColorMapper(CategorizationInfo categorizationInfo) {
            ContinuousRangeToColorMapper result = null;
            return result;
        }

        public static DiscreteRangeToColorMapper newNonContinuousColorMapper(CategorizationInfo categorizationInfo) {
            return MapperFactory.newNonContinuousColorMapper(categorizationInfo, false);
        }

        public static DiscreteRangeToColorMapper newNonContinuousColorMapper(CategorizationInfo categorizationInfo, boolean isOnlyColorEnabled) {
            SegmentedRangeStyle segmentedRangeStyle;
            if (categorizationInfo == null) {
                return null;
            }
            DiscreteRangeToColorMapper mapper = null;
            RangeInfo[] rangeInfos = categorizationInfo.getRangeInfos();
            if (rangeInfos != null && (segmentedRangeStyle = categorizationInfo.getSegmentedRangeStyle()) != null) {
                SegmentedRangeStyle altSegmentedRangeStyle;
                DataElementStyles dataElementStyles = segmentedRangeStyle.getDataElementStyles();
                if (dataElementStyles == null && (altSegmentedRangeStyle = categorizationInfo.getAltSegmentedRangeStyle()) != null) {
                    dataElementStyles = altSegmentedRangeStyle.getDataElementStyles();
                }
                if (dataElementStyles != null) {
                    switch (segmentedRangeStyle.getPaletteType()) {
                        default: {
                            Color outOfRangeColor = dataElementStyles.getOutOfRangeFillStyle().getSolidFillColor();
                            NumericRangeSegment[] numericRangeSegments = new NumericRangeSegment[rangeInfos.length];
                            for (int ii = 0; ii < rangeInfos.length; ++ii) {
                                numericRangeSegments[ii] = new NumericRangeSegment(rangeInfos[ii].getStartValue(), rangeInfos[ii].getEndValue(), !rangeInfos[ii].isStartValueIncluded(), !rangeInfos[ii].isEndValueIncluded(), (Object)rangeInfos[ii].getFillStyle().getSolidFillColor());
                            }
                            DiscreteRangeToColorMapper discreteColorMapper = new DiscreteRangeToColorMapper();
                            discreteColorMapper.setReplaceMissingValues(false);
                            discreteColorMapper.setRangeSegments(numericRangeSegments);
                            discreteColorMapper.setOutOfRangeColor(outOfRangeColor);
                            mapper = discreteColorMapper;
                            break;
                        }
                        case 12101: 
                        case 12102: {
                            Color outOfRangeColor = dataElementStyles.getOutOfRangeFillStyle().getSolidFillColor();
                            NumericRangeSegment[] numericRangeSegments = new NumericRangeSegment[rangeInfos.length];
                            for (int ii = 0; ii < rangeInfos.length; ++ii) {
                                numericRangeSegments[ii] = new NumericRangeSegment(rangeInfos[ii].getStartValue(), rangeInfos[ii].getEndValue(), !rangeInfos[ii].isStartValueIncluded(), !rangeInfos[ii].isEndValueIncluded(), (Object)rangeInfos[ii].getColor());
                            }
                            DiscreteRangeToColorMapper discreteColorMapper = new DiscreteRangeToColorMapper();
                            discreteColorMapper.setReplaceMissingValues(false);
                            discreteColorMapper.setRangeSegments(numericRangeSegments);
                            discreteColorMapper.setOutOfRangeColor(outOfRangeColor);
                            mapper = discreteColorMapper;
                        }
                    }
                }
            }
            return mapper;
        }
    }

    public static class PickInfoAccess {
        public static Vector addLabelValuePairs(Vector labelValuePairs, Object role, Variable variable, int obsIndex, boolean visible) {
            return PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variable, obsIndex, visible, false, true);
        }

        public static Vector addLabelValuePairs_IgnoreMissing(Vector labelValuePairs, Object role, Variable variable, int obsIndex, boolean visible) {
            return PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variable, obsIndex, visible, false, false);
        }

        private static Vector addLabelValuePairs(Vector labelValuePairs, Object role, Variable variable, int obsIndex, boolean visible, boolean onlyNumericVariablesEnabled, boolean missingEnabled) {
            if ((variable instanceof NumericVariable || !onlyNumericVariablesEnabled) && variable != null && role != null && obsIndex >= 0) {
                if (labelValuePairs == null) {
                    labelValuePairs = new Vector();
                }
                Object value = VariableAccess.getRootValue(variable, obsIndex);
                Hashtable<String, Object> entry = new Hashtable<String, Object>();
                entry.put(PickInfo.VISIBLE, visible ? Boolean.TRUE : Boolean.FALSE);
                entry.put(PickInfo.ID, role.toString());
                entry.put(PickInfo.LABEL, variable.getLabel());
                entry.put(PickInfo.VALUE, value);
                entry.put(PickInfo.FORMATTED_VALUE, VariableAccess.getFormattedValueTrim(variable, obsIndex));
                if (missingEnabled || !(value instanceof MissingValues)) {
                    labelValuePairs.add(entry);
                }
            }
            return labelValuePairs;
        }

        public static Vector addLabelValuePairs(Vector labelValuePairs, Object role, Variable[] variableArray, int obsIndex, boolean visible) {
            return PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variableArray, obsIndex, visible, false, false, true);
        }

        public static Vector addLabelValuePairs_IgnoreMissing(Vector labelValuePairs, Object role, Variable[] variableArray, int obsIndex, boolean visible) {
            return PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variableArray, obsIndex, visible, false, false, false);
        }

        public static Vector addLabelValuePairs_ReverseOrder(Vector labelValuePairs, Object role, Variable[] variableArray, int obsIndex, boolean visible) {
            return PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variableArray, obsIndex, visible, true, false, true);
        }

        public static Vector addLabelValuePairs_NumericOnly(Vector labelValuePairs, Object role, Variable[] variableArray, int obsIndex, boolean visible) {
            return PickInfoAccess.addLabelValuePairs(labelValuePairs, role, variableArray, obsIndex, visible, false, true, true);
        }

        private static Vector addLabelValuePairs(Vector labelValuePairs, Object role, Variable[] variableArray, int obsIndex, boolean visible, boolean reverseOrderEnabled, boolean onlyNumericVariablesEnabled, boolean missingEnabled) {
            if (variableArray != null && variableArray.length > 0 && role != null && obsIndex >= 0) {
                int inc = 1;
                int start = 0;
                int end = variableArray.length;
                if (reverseOrderEnabled) {
                    inc = -1;
                    start = variableArray.length - 1;
                    end = -1;
                }
                for (int ii = start; ii != end; ii += inc) {
                    String _role_ = variableArray.length == 1 ? role.toString() : role.toString() + ii;
                    Variable _variable_ = variableArray[ii];
                    labelValuePairs = PickInfoAccess.addLabelValuePairs(labelValuePairs, _role_, _variable_, obsIndex, visible, onlyNumericVariablesEnabled, missingEnabled);
                }
            }
            return labelValuePairs;
        }
    }

    public static class GtkVariable {
        public static double[] calcMinMax(Variable[][] numericVariableArrays) {
            return GtkVariable.calcMinMax(null, numericVariableArrays);
        }

        public static double[] calcMinMax(double[] minMax, Variable[][] numericVariableArrays) {
            if (numericVariableArrays == null || numericVariableArrays.length < 1) {
                return GtkVariable.calcMinMax(minMax, (Variable[])null);
            }
            for (int ii = 0; ii < numericVariableArrays.length; ++ii) {
                minMax = GtkVariable.calcMinMax(minMax, numericVariableArrays[ii]);
            }
            return minMax;
        }

        public static double[] calcMinMax(Variable[] numericVariableArray) {
            return GtkVariable.calcMinMax(null, numericVariableArray);
        }

        public static double[] calcMinMax(double[] minMax, Variable[] numericVariableArray) {
            if (minMax == null || minMax.length < 2) {
                minMax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            }
            if (Double.isNaN(minMax[0])) {
                minMax[0] = Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(minMax[1])) {
                minMax[1] = Double.NEGATIVE_INFINITY;
            }
            if (numericVariableArray != null) {
                double min = minMax[0];
                double max = minMax[1];
                for (int ii = 0; ii < numericVariableArray.length; ++ii) {
                    if (!(numericVariableArray[ii] instanceof NumericVariable)) continue;
                    min = Math.min(min, ((NumericVariable)numericVariableArray[ii]).getMin());
                    max = Math.max(max, ((NumericVariable)numericVariableArray[ii]).getMax());
                }
                minMax[0] = min;
                minMax[1] = max;
            }
            return minMax;
        }
    }
}

