/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

public class DataSourceVariableFactory
extends VariableFactory {
    private DataSource dataSource;
    private final boolean animationEnabled;

    public DataSourceVariableFactory(DataSource newDataSource) {
        this(newDataSource, false);
    }

    public DataSourceVariableFactory(DataSource newDataSource, boolean isAnimationEnabled) {
        this.dataSource = newDataSource;
        if (this.dataSource != null) {
            this.setLocale(this.dataSource.getLocale());
            this.setSortStrategy(this.dataSource.getSortStrategy());
        }
        this.animationEnabled = isAnimationEnabled;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    @Override
    public boolean isOLAPData() {
        if (this.dataSource == null) {
            throw new IllegalStateException("null DataSource");
        }
        return this.dataSource.isOLAPData();
    }

    @Override
    public boolean isRelationalData() {
        if (this.dataSource == null) {
            throw new IllegalStateException("null DataSource");
        }
        return this.dataSource.isRelationalData();
    }

    @Override
    public Object getModel() {
        return this.dataSource == null ? null : this.dataSource.getModel();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Variable newVariable(VariableDefinition varDef) {
        NumericVariable bv;
        Variable v = null;
        if (this.dataSource != null && varDef != null && (v = this.dataSource.getVariable(varDef)) instanceof StringVariable && (bv = this.dataSource.getBaseVariable((StringVariable)v)) != null) {
            v = DataSourceVariableFactory._newVariable((Variable)bv, this.animationEnabled);
            v.setCalculateUniqueValuesByFormattedValue((varDef.getVariant() & 0x10) == 0);
            return v;
        }
        if ((v = DataSourceVariableFactory._newVariable(v, this.animationEnabled)) != null && varDef != null) {
            v.setCalculateUniqueValuesByFormattedValue((varDef.getVariant() & 0x10) == 0);
        }
        return v;
    }

    @Override
    public NumericVariable newHighVariable(VariableDefinition varDef) {
        return (NumericVariable)(this.dataSource != null && varDef != null ? DataSourceVariableFactory._newVariable(this.dataSource.getHighVariable(varDef), this.animationEnabled) : null);
    }

    @Override
    public NumericVariable newLowVariable(VariableDefinition varDef) {
        return (NumericVariable)(this.dataSource != null && varDef != null ? DataSourceVariableFactory._newVariable(this.dataSource.getLowVariable(varDef), this.animationEnabled) : null);
    }

    @Override
    public NumericVariable newTargetVariable(VariableDefinition varDef) {
        return (NumericVariable)(this.dataSource != null && varDef != null ? DataSourceVariableFactory._newVariable(this.dataSource.getTargetVariable(varDef), this.animationEnabled) : null);
    }

    private static Variable _newVariable(Variable dataSourceVariable, boolean animationEnabled) {
        StringVariable v = null;
        if (dataSourceVariable instanceof StringVariable) {
            v = animationEnabled ? DataSourceVariableFactory.newStringAnimationVariable(dataSourceVariable) : DataSourceVariableFactory.newStringVariable(dataSourceVariable);
        } else if (dataSourceVariable instanceof NumericVariable) {
            v = animationEnabled ? DataSourceVariableFactory.newNumericAnimationVariable((NumericVariable)dataSourceVariable) : DataSourceVariableFactory.newNumericVariable((NumericVariable)dataSourceVariable);
        }
        return v;
    }

    @Override
    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="This is legacy code and require major restructuring for this violation")
    public Object clone() {
        return new DataSourceVariableFactory(this.dataSource);
    }
}

