/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSourceVariableFactory;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Categorizer;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericAnimationVariable;
import com.sas.graphics.util.gtk.NumericTableModelVariable;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.StringTableModelVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataSource
implements Cloneable {
    private static final String PERCENT_FLAG = "percentFlag";
    private final VariableProcessor variableProcessor = new VariableProcessor();
    private final Categorizer categorizer = new Categorizer();
    private NumericVariable selectedPercentageVariable;
    private final Hashtable role2VarDef = new Hashtable();
    private final Hashtable varDef2Variable = new Hashtable();
    private final Hashtable varDef2HighVariable = new Hashtable();
    private final Hashtable varDef2LowVariable = new Hashtable();
    private final Hashtable varDef2TargetVariable = new Hashtable();
    private final Hashtable variable2CategorizationModel = new Hashtable();
    private final Hashtable variable2SegmentedRangeStyle = new Hashtable();
    private final Vector groupVariables = new Vector();
    private final Vector nonUserFormattedVariables = new Vector();
    private final Hashtable stringVariable2numericVariable = this.varDef2Variable;
    private String removeIfAllMissingClause;
    private String removeIfAnyMissingClause;
    private String removeIfAllLEZeroClause;
    private String userSpecifiedWhereClause;
    private final VariableFactory variableFactory;
    private final boolean sortEnabled;
    private final boolean summarizationEnabled;
    private boolean autoFormatEnabled = true;
    private ListSelectionModel listSelectionModel;
    private ContextInterface rulesContext;
    private boolean selectionModelSubsettingEnabled = false;
    private Object[] removeIfAllMissingRoles;
    private Object[] removeIfAnyMissingRoles;
    private Object[] removeIfAllLEZeroRoles;
    private Object sortByRole;
    private int sortByRoleIndex = -1;
    private int sortByOrder = -1;
    private Object legendRole = null;
    private Object legendFromRole = null;
    private boolean inheritancePending = false;
    private boolean formatAssignmentsPending = false;
    private boolean groupVariableAssignmentsPending = false;
    private boolean initializeVariablesPending = false;
    private VariableRegistry variableRegistry = new VariableRegistry();
    ListSelectionModel dataSourceListSelectionModel;
    private static final int[] NOTHING_SELECTED = new int[0];
    private DataSourceListSelectionListener dataSourceListSelectionListener;
    public static final int FORMAT_STATE_USER_SPECIFIED = 0;
    public static final int FORMAT_STATE_COMPUTED = 1;
    public static final int FORMAT_STATE_COMPUTED_PERCENT = 2;
    public static final int FORMAT_STATE_MIXED = 3;
    Boolean animationEnabled = null;
    private AnimationPosition animationPosition;
    private static final Variable[] VARIABLE_ARRAY = new Variable[0];

    public DataSource(VariableFactory newVariableFactory) {
        this(newVariableFactory, true, true);
    }

    public DataSource(VariableFactory newVariableFactory, boolean newSortEnabled, boolean newSummarizationEnabled) {
        this.variableFactory = newVariableFactory;
        this.sortEnabled = newSortEnabled;
        this.summarizationEnabled = newSummarizationEnabled;
        this.variableProcessor.setAnimationEnabled(this.isAnimationEnabled());
    }

    public DataSource(DataSource originalDataSource, VariableFactory newVariableFactory) {
        this(newVariableFactory, originalDataSource.sortEnabled, originalDataSource.summarizationEnabled);
        this.autoFormatEnabled = originalDataSource.autoFormatEnabled;
        this.setSelectionModel(originalDataSource.getDataSourceSelectionModel(), originalDataSource.selectionModelSubsettingEnabled);
        this.setRulesContext(originalDataSource.getRulesContext());
        Object[] roles = originalDataSource.getRoles();
        if (roles != null) {
            for (int ii = 0; ii < roles.length; ++ii) {
                Object role = roles[ii];
                if (role == null || role == originalDataSource.legendRole) continue;
                this.setVariableDefinition(role, originalDataSource.getVariableDefinition(role));
            }
        }
        if (originalDataSource.legendRole != null) {
            this.setLegendVariable(originalDataSource.legendRole, originalDataSource.legendFromRole);
        }
        if (originalDataSource.removeIfAnyMissingRoles != null) {
            this.removeObservationsWhereAnyMissing(originalDataSource.removeIfAnyMissingRoles);
        }
        if (originalDataSource.removeIfAllMissingRoles != null) {
            this.removeObservationsWhereAllMissing(originalDataSource.removeIfAllMissingRoles);
        }
        if (originalDataSource.removeIfAllLEZeroRoles != null) {
            this.removeObservationsWhereAllLEZero(originalDataSource.removeIfAllLEZeroRoles);
        }
        if (originalDataSource.getWhereClause() != null) {
            this.setWhereClause(originalDataSource.getWhereClause());
        }
        if (originalDataSource.sortByRole != null) {
            if (originalDataSource.sortByRoleIndex != -1 && originalDataSource.sortByOrder != -1) {
                this.sortBy(originalDataSource.sortByRole, originalDataSource.sortByRoleIndex, originalDataSource.sortByOrder);
            } else {
                this.sortBy(originalDataSource.sortByRole);
            }
        }
    }

    public int getValueCount() {
        this._bindAsNeeded();
        VariableProcessor.VariableEntry[] variableEntries = this.variableProcessor.getVariables();
        if (variableEntries != null) {
            for (int ii = 0; ii < variableEntries.length; ++ii) {
                int valueCount;
                if (variableEntries[ii] == null || variableEntries[ii].variable == null || (valueCount = variableEntries[ii].variable.getValueCount()) == -1) continue;
                return valueCount;
            }
        }
        return 0;
    }

    public NumericVariable getSelectedPercentageVariable() {
        if (this.selectedPercentageVariable == null) {
            if (!this.isRoot()) {
                NumericVariable parentSelectedPercentageVariable = this.getParentDataSource().getSelectedPercentageVariable();
                if (parentSelectedPercentageVariable != null) {
                    if (this.isAnimationEnabled()) {
                        boolean isInterpolationEnabled = false;
                        this.selectedPercentageVariable = new NumericAnimationVariable(isInterpolationEnabled);
                        this.selectedPercentageVariable.connectFrom(parentSelectedPercentageVariable);
                    } else {
                        this.selectedPercentageVariable = VariableFactory.newNumericVariable(parentSelectedPercentageVariable);
                    }
                    this.variableProcessor.addVariable((Variable)this.selectedPercentageVariable);
                }
            } else if (this.isRelationalData()) {
                this.selectedPercentageVariable = this.variableProcessor.newSelectedPercentageVariable();
            }
        }
        return this.selectedPercentageVariable;
    }

    public Object getModel() {
        return this.variableFactory != null ? this.variableFactory.getModel() : null;
    }

    public Object getRootModel() {
        if (!this.isRoot()) {
            return this.getRootDataSource().getRootModel();
        }
        return this.getModel();
    }

    public Locale getLocale() {
        return this.variableFactory != null ? this.variableFactory.getLocale() : Locale.getDefault();
    }

    public int getSortStrategy() {
        return this.variableFactory != null ? this.variableFactory.getSortStrategy() : 10475;
    }

    public SASFormat newLocalizedSASFormat(String formatName) {
        return Util.newSASFormat(formatName, this.getLocale());
    }

    public GTKFormat newLocalizedGTKFormat(String formatName) {
        return GTKUtil.newGTKFormat(formatName, this.getLocale());
    }

    public void setSelectionModel(ListSelectionModel ls) {
        this.setSelectionModel(ls, false);
    }

    public void setSelectionModel(ListSelectionModel ls, boolean isSubsettingEnabled) {
        this.selectionModelSubsettingEnabled = isSubsettingEnabled;
        if (this.listSelectionModel != ls) {
            if (this.listSelectionModel != null && this.dataSourceListSelectionListener != null) {
                this.listSelectionModel.removeListSelectionListener(this.dataSourceListSelectionListener);
            }
            this.listSelectionModel = ls;
            this.dataSourceListSelectionModel = null;
            if (this.listSelectionModel != null) {
                if (isSubsettingEnabled) {
                    if (this.dataSourceListSelectionListener == null) {
                        this.dataSourceListSelectionListener = new DataSourceListSelectionListener();
                    } else {
                        this.dataSourceListSelectionListener.setSubsetDataOnSelection(false);
                    }
                    this.listSelectionModel.addListSelectionListener(this.dataSourceListSelectionListener);
                    this.dataSourceListSelectionListener.setSubsetDataOnSelection(isSubsettingEnabled);
                } else {
                    this.dataSourceListSelectionModel = new DataSourceListSelectionModel(this.listSelectionModel);
                }
            }
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.listSelectionModel;
    }

    public ListSelectionModel getRootSelectionModel() {
        if (!this.isRoot()) {
            return this.getRootDataSource().getRootSelectionModel();
        }
        return this.getSelectionModel();
    }

    public ListSelectionModel getDataSourceSelectionModel() {
        return this.dataSourceListSelectionModel;
    }

    public void setLegendVariable(Object newLegendRole, Object newLegendFromRole) {
        if (this.isRoot()) {
            Variable[] fromVariables;
            VariableDefinition fromVariableDefinition;
            this._removeRole(this.legendRole);
            if (newLegendRole != null && newLegendFromRole != null && !newLegendRole.equals(newLegendFromRole) && (fromVariableDefinition = this.getVariableDefinition(newLegendFromRole)) != null && (fromVariables = this._getVariable(newLegendFromRole)) != null) {
                this._createLegendVariables(newLegendRole, fromVariableDefinition.asLegendVariableDefinition(), fromVariables);
                this.legendFromRole = newLegendFromRole;
            }
        }
    }

    public void setVariableDefinition(Object role, VariableDefinition varDef) {
        if (role != null) {
            if (!this.isRoot()) {
                this._bindAsNeeded();
            }
            this._removeRole(role);
            this._bindVariableDefinition(role, varDef);
        }
    }

    private void _bindVariableDefinition(Object role, VariableDefinition varDef) {
        if (role != null && varDef != null) {
            this._createVariables(role, varDef);
        }
    }

    public synchronized VariableDefinition getVariableDefinition(Object role, int index) {
        int ii = 0;
        for (VariableDefinition varDef = this.getVariableDefinition(role); varDef != null; varDef = varDef.getNext()) {
            if (ii == index) {
                return varDef;
            }
            ++ii;
        }
        return null;
    }

    public synchronized Object[] getRoles() {
        if (this.inheritancePending) {
            return this.getRootDataSource().getRoles();
        }
        return this.role2VarDef.keySet().toArray();
    }

    public synchronized VariableDefinition getVariableDefinition(Object role) {
        if (role == null) {
            return null;
        }
        if (this.inheritancePending) {
            return this.getRootDataSource().getVariableDefinition(role);
        }
        return (VariableDefinition)this.role2VarDef.get(role);
    }

    public synchronized void removeAllVariableDefinitions() {
        this._disconnectAndRemoveAllVariablesFromVariableProcessor();
        this.inheritancePending = false;
        this.formatAssignmentsPending = false;
        this.groupVariableAssignmentsPending = false;
        this.varDef2Variable.clear();
        this.varDef2HighVariable.clear();
        this.varDef2LowVariable.clear();
        this.varDef2TargetVariable.clear();
        this.role2VarDef.clear();
        this.variable2CategorizationModel.clear();
        this.variable2SegmentedRangeStyle.clear();
        this.groupVariables.clear();
        this.nonUserFormattedVariables.clear();
        this.stringVariable2numericVariable.clear();
        this.legendRole = null;
        this.legendFromRole = null;
        this.selectedPercentageVariable = null;
        this.userSpecifiedWhereClause = null;
        this.removeIfAllMissingClause = null;
        this.removeIfAnyMissingClause = null;
        this.removeIfAllLEZeroClause = null;
        this.removeIfAllMissingRoles = null;
        this.removeIfAnyMissingRoles = null;
        this.removeIfAllLEZeroRoles = null;
        this.rulesContext = null;
        this.sortByRole = null;
        this.sortByRoleIndex = -1;
        this.sortByOrder = -1;
    }

    public synchronized void dispose() {
        this.removeAllVariableDefinitions();
        if (this.listSelectionModel != null && this.dataSourceListSelectionListener != null) {
            this.listSelectionModel.removeListSelectionListener(this.dataSourceListSelectionListener);
        }
    }

    public synchronized void disposeRecursively() {
        DataSource parent = this.getParentDataSource();
        this.dispose();
        if (parent != null) {
            parent.disposeRecursively();
        }
    }

    public synchronized void remove(Object role) {
        if (role != null) {
            if (!this.isRoot()) {
                this._bindAsNeeded();
            }
            this._removeRole(role);
        }
    }

    private void _removeRole(Object role) {
        if (role != null) {
            if (this.legendFromRole != null && this.legendFromRole.equals(role)) {
                this._removeVariableDefinition((VariableDefinition)this.role2VarDef.remove(this.legendRole));
                this.legendRole = null;
                this.legendFromRole = null;
            }
            this._removeVariableDefinition((VariableDefinition)this.role2VarDef.remove(role));
            if (this.legendRole != null && this.legendRole.equals(role)) {
                this.legendRole = null;
                this.legendFromRole = null;
            }
        }
    }

    private void _removeVariableDefinition(VariableDefinition varDef) {
        if (varDef != null) {
            VariableDefinition vd = varDef;
            do {
                this._disconnectAndRemoveVariable(this.varDef2Variable, vd);
                this._disconnectAndRemoveVariable(this.varDef2HighVariable, vd);
                this._disconnectAndRemoveVariable(this.varDef2LowVariable, vd);
                this._disconnectAndRemoveVariable(this.varDef2TargetVariable, vd);
            } while ((vd = vd.getNext()) != null);
        }
    }

    private void _disconnectAndRemoveAllVariablesFromVariableProcessor() {
        VariableProcessor.VariableEntry[] variableEntries = this.variableProcessor.getVariables();
        if (variableEntries != null) {
            for (int ii = 0; ii < variableEntries.length; ++ii) {
                if (variableEntries[ii] == null || variableEntries[ii].variable == null) continue;
                variableEntries[ii].variable.disconnect();
            }
        }
        this.variableProcessor.removeAllVariables();
        this.categorizer.removeAllVariables();
    }

    private void _disconnectAndRemoveVariable(Hashtable varDef2Var, VariableDefinition varDef) {
        Variable v;
        if (varDef2Var != null && varDef != null && (v = (Variable)varDef2Var.remove(varDef)) != null) {
            if (varDef2Var.containsKey(v)) {
                v.disconnect();
                v = (Variable)varDef2Var.remove(v);
            }
            this.groupVariables.remove(v);
            this.variable2CategorizationModel.remove(v);
            this.variable2SegmentedRangeStyle.remove(v);
            int index = this.nonUserFormattedVariables.indexOf(v);
            if (index >= 0) {
                Object pretext;
                Object v0 = pretext = index > 0 ? this.nonUserFormattedVariables.get(index - 1) : null;
                if (pretext == PERCENT_FLAG) {
                    this.nonUserFormattedVariables.remove(index - 1);
                }
                this.nonUserFormattedVariables.remove(v);
            }
            v.disconnect();
            this.variableProcessor.removeVariable(v);
            if (varDef instanceof ClassificationVariableDefinition) {
                this.categorizer.removeVariable(v);
            }
        }
    }

    public void removeVariable(Variable v) {
        if (!(this._seekAndDestroyThisVariable(v, this.varDef2Variable) || this._seekAndDestroyThisVariable(v, this.varDef2HighVariable) || this._seekAndDestroyThisVariable(v, this.varDef2LowVariable))) {
            this._seekAndDestroyThisVariable(v, this.varDef2TargetVariable);
        }
    }

    private boolean _seekAndDestroyThisVariable(Variable v, Hashtable varDef2Var) {
        Enumeration varDefs = varDef2Var.keys();
        while (varDefs.hasMoreElements()) {
            VariableDefinition varDef;
            Object key = varDefs.nextElement();
            if (!(key instanceof VariableDefinition) || v != (Variable)varDef2Var.get(varDef = (VariableDefinition)key)) continue;
            this._disconnectAndRemoveVariable(varDef2Var, varDef);
            return true;
        }
        return false;
    }

    public static synchronized boolean isNumericVariable(Variable[] vars) {
        boolean isNumeric = false;
        if (vars != null) {
            for (int ii = 0; ii < vars.length; ++ii) {
                if (vars[ii] == null || !(vars[ii] instanceof NumericVariable)) {
                    return false;
                }
                isNumeric = true;
            }
        }
        return isNumeric;
    }

    public static synchronized boolean isStringVariable(Variable[] vars) {
        boolean isString = false;
        if (vars != null) {
            for (int ii = 0; ii < vars.length; ++ii) {
                if (vars[ii] == null || !(vars[ii] instanceof StringVariable)) {
                    return false;
                }
                isString = true;
            }
        }
        return isString;
    }

    public synchronized int getComputedFormatState(Object role) {
        if (!this.isRoot()) {
            return this.getRootDataSource().getComputedFormatState(role);
        }
        int computedFormatState = 0;
        Variable[] v = this.getVariable(role);
        if (v != null) {
            block13: for (int jj = 0; jj < v.length; ++jj) {
                int vComputedFormatState = 0;
                boolean percentFormatFlag = false;
                for (int ii = 0; ii < this.nonUserFormattedVariables.size(); ++ii) {
                    Object o = this.nonUserFormattedVariables.get(ii);
                    if (o instanceof String && PERCENT_FLAG.equals(o)) {
                        percentFormatFlag = true;
                        continue;
                    }
                    if (o instanceof NumericVariable && (Variable)o == v[jj]) {
                        vComputedFormatState = percentFormatFlag ? 2 : 1;
                        break;
                    }
                    percentFormatFlag = false;
                }
                block0 : switch (computedFormatState) {
                    case 0: {
                        computedFormatState = vComputedFormatState;
                        continue block13;
                    }
                    case 3: {
                        continue block13;
                    }
                    case 1: {
                        switch (vComputedFormatState) {
                            case 0: {
                                computedFormatState = 3;
                                continue block13;
                            }
                        }
                        continue block13;
                    }
                    case 2: {
                        switch (vComputedFormatState) {
                            case 0: {
                                computedFormatState = 3;
                                break block0;
                            }
                            case 1: {
                                computedFormatState = 1;
                                break block0;
                            }
                        }
                    }
                }
            }
        }
        return computedFormatState;
    }

    public synchronized NumericVariable getBaseVariable(StringVariable v) {
        if (v == null) {
            return null;
        }
        return (NumericVariable)this.stringVariable2numericVariable.get(v);
    }

    public Variable[] getBaseVariables(StringVariable[] sva) {
        if (sva == null) {
            return null;
        }
        NumericVariable[] nva = new NumericVariable[sva.length];
        for (int ii = 0; ii < sva.length; ++ii) {
            nva[ii] = this.getBaseVariable(sva[ii]);
        }
        return nva;
    }

    public Variable[] getVariablesReplaceWithBaseVariablesWhereApplicable(Object role) {
        return this.replaceWithBaseVariableWhereApplicable(this.getVariable(role));
    }

    public Variable[] replaceWithBaseVariableWhereApplicable(Variable[] va) {
        if (va == null) {
            return null;
        }
        for (int ii = 0; ii < va.length; ++ii) {
            NumericVariable bv;
            if (!(va[ii] instanceof StringVariable) || (bv = this.getBaseVariable((StringVariable)va[ii])) == null) continue;
            va[ii] = bv;
        }
        return va;
    }

    public synchronized SegmentedRangeStyle getSegmentedRangeStyle(Variable variable) {
        if (variable == null) {
            return null;
        }
        return (SegmentedRangeStyle)this.variable2SegmentedRangeStyle.get(variable);
    }

    public synchronized boolean isCategorized(Variable variable) {
        return this.getCategorizationModel(variable) != null;
    }

    public Object asValue(Object role, Object rawObjectValue) {
        return this.asValue(role, 0, rawObjectValue);
    }

    public Object asValue(Object role, int index, Object rawObjectValue) {
        Variable v = this.getVariable(role, index);
        if (v == null) {
            String id = role != null ? role.toString() : "";
            throw new IllegalStateException("0 variables have been defined for role: \"" + id + "\"");
        }
        return DataSource.asValue(v, rawObjectValue);
    }

    public static Object asValue(Variable v, Object rawObjectValue) {
        if (v == null) {
            throw new IllegalArgumentException("null variable not allowed");
        }
        if (v instanceof StringVariable) {
            return DataSource._asValue((StringVariable)v, rawObjectValue);
        }
        if (v instanceof NumericVariable) {
            return DataSource._asValue((NumericVariable)v, rawObjectValue);
        }
        throw new UnsupportedOperationException("Unrecognized Variable type.");
    }

    public String asFormattedValue(Object role, Object rawObjectValue) {
        return this.asFormattedValue(role, 0, rawObjectValue);
    }

    public String asFormattedValue(Object role, int index, Object rawObjectValue) {
        Variable v = this.getVariable(role, index);
        if (v == null) {
            String id = role != null ? role.toString() : "";
            throw new IllegalStateException("0 variables have been defined for role: \"" + id + "\"");
        }
        return DataSource.asFormattedValue(v, rawObjectValue);
    }

    public static String asFormattedValue(Variable v, Object rawObjectValue) {
        if (v == null) {
            throw new IllegalArgumentException("null variable not allowed");
        }
        if (v instanceof StringVariable) {
            return (String)DataSource._asFormattedValue((StringVariable)v, rawObjectValue);
        }
        if (v instanceof NumericVariable) {
            return (String)DataSource._asFormattedValue((NumericVariable)v, rawObjectValue);
        }
        throw new UnsupportedOperationException("Unrecognized Variable type.");
    }

    private static Object _asFormattedValue(NumericVariable v, Object rawObjectValue) {
        return DataSource._asValue_(v, rawObjectValue, true);
    }

    private static Object _asValue(NumericVariable v, Object rawObjectValue) {
        return DataSource._asValue_(v, rawObjectValue, false);
    }

    private static Object _asValue_(NumericVariable v, Object rawObjectValue, boolean applyFormat) {
        if (v == null) {
            throw new IllegalArgumentException("null variable not allowed");
        }
        Object value = null;
        Variable rootVariable = v.getRootVariable();
        if (rootVariable instanceof OLAPMeasureVariable) {
            value = applyFormat ? GTKUtil.VariableAccess.asFormattedValue((OLAPMeasureVariable)rootVariable, rawObjectValue) : GTKUtil.VariableAccess.asValue((OLAPMeasureVariable)rootVariable, rawObjectValue);
        } else if (rootVariable instanceof NumericTableModelVariable) {
            value = applyFormat ? GTKUtil.VariableAccess.asFormattedValue((NumericTableModelVariable)rootVariable, rawObjectValue) : GTKUtil.VariableAccess.asValue((NumericTableModelVariable)rootVariable, rawObjectValue);
        } else {
            throw new UnsupportedOperationException("Unsupported Variable type.");
        }
        return value;
    }

    private static Object _asFormattedValue(StringVariable v, Object rawObjectValue) {
        return DataSource._asValue_(v, rawObjectValue, true);
    }

    private static Object _asValue(StringVariable v, Object rawObjectValue) {
        return DataSource._asValue_(v, rawObjectValue, false);
    }

    private static Object _asValue_(StringVariable v, Object rawObjectValue, boolean applyFormat) {
        if (v == null) {
            throw new IllegalArgumentException("null variable not allowed");
        }
        Object value = null;
        Variable rootVariable = v.getRootVariable();
        if (rootVariable instanceof OLAPLevelVariable) {
            value = GTKUtil.VariableAccess.asValue((OLAPLevelVariable)rootVariable, rawObjectValue);
        } else if (rootVariable instanceof NumericTableModelVariable) {
            value = GTKUtil.VariableAccess.asFormattedValue((NumericTableModelVariable)rootVariable, rawObjectValue);
        } else if (rootVariable instanceof StringTableModelVariable) {
            value = applyFormat ? GTKUtil.VariableAccess.asFormattedValue((StringTableModelVariable)rootVariable, rawObjectValue) : GTKUtil.VariableAccess.asValue((StringTableModelVariable)rootVariable, rawObjectValue);
        } else {
            throw new UnsupportedOperationException("Unsupported Variable type.");
        }
        return value;
    }

    public synchronized CategorizationModel getCategorizationModel(Variable variable) {
        if (variable == null) {
            return null;
        }
        return (CategorizationModel)this.variable2CategorizationModel.get(variable);
    }

    public synchronized RangeInfo[] categorize(Variable variable) {
        CategorizationModel categorizationModel;
        if (variable instanceof NumericVariable && (categorizationModel = this.getCategorizationModel(variable)) != null) {
            return Util.categorize((NumericVariable)variable, categorizationModel, this.getLocale());
        }
        return null;
    }

    public synchronized Variable getVariable(Object role, int index) {
        if (role != null) {
            this._bindAsNeeded();
        }
        return this._getVariable(role, index);
    }

    public synchronized Variable[] getVariable(Object role) {
        if (role != null) {
            this._bindAsNeeded();
        }
        return this._getVariable(role);
    }

    private synchronized Variable _getVariable(Object role, int index) {
        Variable[] variableArray = this._getVariable(role);
        if (variableArray == null || variableArray.length <= index) {
            return null;
        }
        return variableArray[index];
    }

    private synchronized Variable[] _getVariable(Object role) {
        Variable[] vars = DataSource._getVariable(this.getVariableDefinition(role), this.varDef2Variable, false, this.varDef2Variable);
        if (vars != null) {
            for (int ii = 0; ii < vars.length; ++ii) {
                if (vars[ii] == null) continue;
                return vars;
            }
        }
        return null;
    }

    public synchronized boolean isDefined(Object role) {
        return this.getVariableNames(role) != null;
    }

    public synchronized String[] getVariableNames(Object role) {
        VariableDefinition varDef;
        if (this.inheritancePending) {
            return this.getRootDataSource().getVariableNames(role);
        }
        if (role != null && (varDef = this.getVariableDefinition(role)) != null) {
            int size = 0;
            for (VariableDefinition vd = varDef; vd != null; vd = vd.getNext()) {
                ++size;
            }
            if (size > 0) {
                String[] variableNames = new String[size];
                int ii = 0;
                VariableDefinition vd = varDef;
                while (vd != null) {
                    Variable v = (Variable)this.varDef2Variable.get(vd);
                    if (v != null) {
                        variableNames[ii] = v.getName();
                    }
                    vd = vd.getNext();
                    ++ii;
                }
                return variableNames;
            }
        }
        return null;
    }

    public synchronized String[] getVariableColumnNames(Object role) {
        VariableDefinition varDef;
        if (this.inheritancePending) {
            return this.getRootDataSource().getVariableColumnNames(role);
        }
        if (role != null && (varDef = this.getVariableDefinition(role)) != null) {
            int size = 0;
            for (VariableDefinition vd = varDef; vd != null; vd = vd.getNext()) {
                ++size;
            }
            if (size > 0) {
                String[] variableNames = new String[size];
                int ii = 0;
                VariableDefinition vd = varDef;
                while (vd != null) {
                    Variable v = (Variable)this.varDef2Variable.get(vd);
                    if (v != null) {
                        variableNames[ii] = v.getRootVariable().getColumnName();
                    }
                    vd = vd.getNext();
                    ++ii;
                }
                return variableNames;
            }
        }
        return null;
    }

    public synchronized String[] getVariableResultSetIDs(Object role) {
        VariableDefinition varDef;
        if (this.inheritancePending) {
            return this.getRootDataSource().getVariableResultSetIDs(role);
        }
        if (role != null && (varDef = this.getVariableDefinition(role)) != null) {
            int size = 0;
            for (VariableDefinition vd = varDef; vd != null; vd = vd.getNext()) {
                ++size;
            }
            if (size > 0) {
                String[] variableNames = new String[size];
                int ii = 0;
                VariableDefinition vd = varDef;
                while (vd != null) {
                    Variable v = (Variable)this.varDef2Variable.get(vd);
                    if (v != null) {
                        if ((v = v.getRootVariable()) instanceof NumericTableModelVariable) {
                            variableNames[ii] = ((NumericTableModelVariable)v).getResultSetId();
                        } else if (v instanceof OLAPMeasureVariable) {
                            variableNames[ii] = ((OLAPMeasureVariable)v).getResultSetId();
                        }
                    }
                    vd = vd.getNext();
                    ++ii;
                }
                return variableNames;
            }
        }
        return null;
    }

    public synchronized NumericVariable getHighVariable(Object role, int index) {
        NumericVariable[] variableArray = this.getHighVariable(role);
        if (variableArray == null || variableArray.length <= index) {
            return null;
        }
        return variableArray[index];
    }

    public synchronized NumericVariable[] getHighVariable(Object role) {
        if (role == null) {
            return null;
        }
        this._bindAsNeeded();
        return (NumericVariable[])DataSource._getVariable(this.getVariableDefinition(role), this.varDef2HighVariable, true, this.varDef2Variable);
    }

    public synchronized NumericVariable getLowVariable(Object role, int index) {
        NumericVariable[] variableArray = this.getLowVariable(role);
        if (variableArray == null || variableArray.length <= index) {
            return null;
        }
        return variableArray[index];
    }

    public synchronized NumericVariable[] getLowVariable(Object role) {
        if (role == null) {
            return null;
        }
        this._bindAsNeeded();
        return (NumericVariable[])DataSource._getVariable(this.getVariableDefinition(role), this.varDef2LowVariable, true, this.varDef2Variable);
    }

    public synchronized NumericVariable getTargetVariable(Object role, int index) {
        NumericVariable[] variableArray = this.getTargetVariable(role);
        if (variableArray == null || variableArray.length <= index) {
            return null;
        }
        return variableArray[index];
    }

    public synchronized NumericVariable[] getTargetVariable(Object role) {
        if (role == null) {
            return null;
        }
        this._bindAsNeeded();
        return (NumericVariable[])DataSource._getVariable(this.getVariableDefinition(role), this.varDef2TargetVariable, true, this.varDef2Variable);
    }

    private static Variable[] _getVariable(VariableDefinition varDef, Hashtable specificVarDef2Var, boolean isNumeric, Hashtable primaryVarDef2Var) {
        NumericVariable[] variableArray = null;
        if (varDef != null) {
            VariableDefinition vd;
            int size = 0;
            for (vd = varDef; vd != null && primaryVarDef2Var.get(vd) != null; vd = vd.getNext()) {
                ++size;
            }
            if (size > 0) {
                variableArray = isNumeric ? new NumericVariable[size] : new Variable[size];
                vd = varDef;
                for (int ii = 0; ii < variableArray.length; ++ii) {
                    variableArray[ii] = (Variable)specificVarDef2Var.get(vd);
                    vd = vd.getNext();
                }
            }
        }
        return variableArray;
    }

    protected synchronized Variable getVariable(VariableDefinition varDef) {
        this._bindAsNeeded();
        return (Variable)this.varDef2Variable.get(varDef);
    }

    protected synchronized Variable getHighVariable(VariableDefinition varDef) {
        this._bindAsNeeded();
        return (Variable)this.varDef2HighVariable.get(varDef);
    }

    protected synchronized Variable getLowVariable(VariableDefinition varDef) {
        this._bindAsNeeded();
        return (Variable)this.varDef2LowVariable.get(varDef);
    }

    protected synchronized Variable getTargetVariable(VariableDefinition varDef) {
        this._bindAsNeeded();
        return (Variable)this.varDef2TargetVariable.get(varDef);
    }

    public ContextInterface getRulesContext() {
        return this.rulesContext;
    }

    public void setRulesContext(ContextInterface rulesContext) {
        this.rulesContext = rulesContext;
    }

    public boolean isAnimationEnabled() {
        if (this.animationEnabled == null) {
            this.animationEnabled = this.variableFactory instanceof DataSourceVariableFactory && ((DataSourceVariableFactory)this.variableFactory).isAnimationEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.animationEnabled == Boolean.TRUE;
    }

    public boolean setAnimationPosition(AnimationPosition animationPosition) {
        if (this.isAnimationEnabled() && this.animationPosition != animationPosition && animationPosition != null && !animationPosition.equals(this.animationPosition)) {
            this.animationPosition = animationPosition;
            Object keyFrame1 = animationPosition.getKeyFrame1();
            Object keyFrame2 = animationPosition.getKeyFrame2();
            double interpolationPercent = animationPosition.getInterpolationPercent();
            this.variableProcessor.setAnimationFrame(keyFrame1, keyFrame2, interpolationPercent);
            return true;
        }
        return false;
    }

    public AnimationPosition getAnimationPosition() {
        if (this.isAnimationEnabled()) {
            return this.animationPosition;
        }
        return null;
    }

    public DataSource newAnimationDataSource(Object animationKeyFrameRole, Object animationIDRole) {
        DataSource ads = null;
        Variable myAnimationKeyFrameVariable = this.getVariable(animationKeyFrameRole, 0);
        if (myAnimationKeyFrameVariable != null) {
            Variable animationIDVariable;
            NumericVariable baseAnimationKeyFrameVariable;
            ads = this.newDataSourceWhere(null, this.sortEnabled, false, true);
            ads._bindInheritence();
            Variable animationKeyFrameVariable = ads._getVariable(animationKeyFrameRole, 0);
            if (animationKeyFrameVariable instanceof StringVariable && (baseAnimationKeyFrameVariable = ads.getBaseVariable((StringVariable)animationKeyFrameVariable)) != null) {
                animationKeyFrameVariable = baseAnimationKeyFrameVariable;
            }
            ads.variableProcessor.setAnimationKeyFrameVariable(animationKeyFrameVariable);
            if (animationIDRole != null && (animationIDVariable = ads._getVariable(animationIDRole, 0)) != null) {
                NumericVariable baseAnimationIDVariable;
                if (animationIDVariable instanceof StringVariable && (baseAnimationIDVariable = ads.getBaseVariable((StringVariable)animationIDVariable)) != null) {
                    animationIDVariable = baseAnimationIDVariable;
                }
                ads.variableProcessor.setAnimationIdentificationVariable(animationIDVariable);
            }
        }
        return ads;
    }

    public DataSource newDataSourceWhere(String clause) {
        return this.newDataSourceWhere(clause, this.sortEnabled, false, this.isAnimationEnabled());
    }

    public DataSource newDataSourceWhere(String clause, boolean sortEnabled, boolean summarizationEnabled, boolean animationEnabled) {
        DataSource newDataSource = new DataSource(new DataSourceVariableFactory(this, animationEnabled), sortEnabled, summarizationEnabled);
        newDataSource.inheritancePending = true;
        newDataSource.autoFormatEnabled = false;
        newDataSource.setSelectionModel(this.getDataSourceSelectionModel(), false);
        newDataSource.setRulesContext(this.getRulesContext());
        newDataSource.setWhereClause(clause);
        return newDataSource;
    }

    public boolean isRoot() {
        return this.getParentDataSource() == null;
    }

    public DataSource getRootDataSource() {
        DataSource parent = this.getParentDataSource();
        return parent == null ? this : parent.getRootDataSource();
    }

    public DataSource getParentDataSource() {
        if (this.variableFactory instanceof DataSourceVariableFactory) {
            return ((DataSourceVariableFactory)this.variableFactory).getDataSource();
        }
        return null;
    }

    public void setWhereClause(String clause) {
        this.userSpecifiedWhereClause = clause;
        this._applyWhereClause();
    }

    public String getWhereClause() {
        return this.userSpecifiedWhereClause;
    }

    public void removeObservationsWhereAllLEZero(Object[] roles) {
        this.removeIfAllLEZeroRoles = roles;
        this.removeIfAllLEZeroClause = null;
        if (roles != null) {
            for (int ii = 0; ii < roles.length; ++ii) {
                String[] variableNames;
                if (roles[ii] == null || (variableNames = this.getVariableNames(roles[ii])) == null) continue;
                for (int jj = 0; jj < variableNames.length; ++jj) {
                    if (variableNames[jj] == null) continue;
                    String nm = "(" + variableNames[jj] + " LE 0)";
                    this.removeIfAllLEZeroClause = this.removeIfAllLEZeroClause != null ? this.removeIfAllLEZeroClause + " and " + nm : nm;
                }
            }
        }
        if (this.removeIfAllLEZeroClause != null) {
            this.removeIfAllLEZeroClause = "(not (" + this.removeIfAllLEZeroClause + "))";
        }
        this._applyWhereClause();
    }

    public void removeObservationsWhereAllMissing(Object[] roles) {
        this.removeIfAllMissingRoles = roles;
        this.removeIfAllMissingClause = null;
        if (roles != null) {
            for (int ii = 0; ii < roles.length; ++ii) {
                String[] variableNames;
                if (roles[ii] == null || (variableNames = this.getVariableNames(roles[ii])) == null) continue;
                for (int jj = 0; jj < variableNames.length; ++jj) {
                    if (variableNames[jj] == null) continue;
                    String nm = "(" + variableNames[jj] + " is missing)";
                    this.removeIfAllMissingClause = this.removeIfAllMissingClause != null ? this.removeIfAllMissingClause + " and " + nm : nm;
                }
            }
        }
        if (this.removeIfAllMissingClause != null) {
            this.removeIfAllMissingClause = "(not (" + this.removeIfAllMissingClause + "))";
        }
        this._applyWhereClause();
    }

    public void removeObservationsWhereAnyMissing(Object[] roles) {
        this.removeIfAnyMissingRoles = roles;
        this.removeIfAnyMissingClause = null;
        if (roles != null) {
            for (int ii = 0; ii < roles.length; ++ii) {
                String[] variableNames;
                if (roles[ii] == null || (variableNames = this.getVariableNames(roles[ii])) == null) continue;
                for (int jj = 0; jj < variableNames.length; ++jj) {
                    if (variableNames[jj] == null) continue;
                    String nm = "(" + variableNames[jj] + " is missing)";
                    this.removeIfAnyMissingClause = this.removeIfAnyMissingClause != null ? this.removeIfAnyMissingClause + " or " + nm : nm;
                }
            }
        }
        if (this.removeIfAnyMissingClause != null) {
            this.removeIfAnyMissingClause = "(not (" + this.removeIfAnyMissingClause + "))";
        }
        this._applyWhereClause();
    }

    private void _applyWhereClause() {
        String wc;
        String string = wc = this.userSpecifiedWhereClause != null ? "(" + this.userSpecifiedWhereClause + ")" : null;
        if (this.removeIfAllMissingClause != null) {
            String string2 = wc = wc == null ? this.removeIfAllMissingClause : wc + " and " + this.removeIfAllMissingClause;
        }
        if (this.removeIfAnyMissingClause != null) {
            String string3 = wc = wc == null ? this.removeIfAnyMissingClause : wc + " and " + this.removeIfAnyMissingClause;
        }
        if (this.removeIfAllLEZeroClause != null) {
            wc = wc == null ? this.removeIfAllLEZeroClause : wc + " and " + this.removeIfAllLEZeroClause;
        }
        this.variableProcessor.setWhereExpression(wc);
    }

    public void dumpData() {
        this._bindAsNeeded();
        System.out.println("Data type: " + (this.isOLAPData() ? "OLAP" : "Relational"));
        System.out.println("Summarization enabled: " + this.summarizationEnabled);
        System.out.println("Aniumation enabled: " + this.animationEnabled);
        System.out.println("DataSource Role specification: (\"role\" ==> [var1Name, var2Name, etc.])");
        Object[] roles = this.getRoles();
        for (int ii = 0; ii < roles.length; ++ii) {
            Object role = roles[ii];
            if (role == null) continue;
            Variable[] variables = this.getVariable(role);
            if (variables != null) {
                String variableNames = null;
                for (int jj = 0; jj < variables.length; ++jj) {
                    Variable variable = variables[jj];
                    String variableName = variable != null ? variable.getName() : "null";
                    variableNames = variableNames == null ? "[" + variableName : variableNames + ", " + variableName;
                }
                variableNames = variableNames + "]";
                System.out.println("     \"" + role + "\" ==> " + variableNames);
                continue;
            }
            System.out.println("     <no valid roles have been specified>");
        }
        System.out.println("\n\nData values:\n");
        this.variableProcessor.dump();
        System.out.println("\n\nUnique values:\n");
        this.variableProcessor.dumpUniqueValues();
    }

    public List getIndicesPriorToProcessing(int index) {
        this._bindAsNeeded();
        return this.variableProcessor.getIndicesPriorToProcessing(index);
    }

    public int getAnIndexPriorToProcessing(int index) {
        this._bindAsNeeded();
        List l = this.variableProcessor.getIndicesPriorToProcessing(index);
        if (l == null || l.size() < 1) {
            return index;
        }
        Object o = l.get(0);
        if (!(o instanceof Integer)) {
            return index;
        }
        Integer i = (Integer)o;
        return i;
    }

    public int getIndexPriorToAllProcessing(int index) {
        this._bindAsNeeded();
        index = this.getAnIndexPriorToProcessing(index);
        DataSource parent = this.getParentDataSource();
        if (parent != null) {
            return parent.getIndexPriorToAllProcessing(index);
        }
        return index;
    }

    public boolean isSummarizationEnabled() {
        return this.summarizationEnabled;
    }

    public void linkCategoryValues(DataSource d2) {
        if (d2 == null) {
            this.categorizer.linkTo(null);
        } else {
            this.categorizer.linkTo(d2.getCategorizer());
        }
    }

    public Categorizer getCategorizer() {
        return this.categorizer;
    }

    private void _createVariables(Object role, VariableDefinition varDef) {
        if (varDef != null && this.variableFactory != null) {
            boolean isRoot = this.isRoot();
            boolean modify_groupVariableAssignmentsPending_Enabled = isRoot && !this.groupVariableAssignmentsPending;
            boolean modify_formatAssignmentsPending_Enabled = isRoot && !this.formatAssignmentsPending;
            int initialGroupVariablesSize = modify_groupVariableAssignmentsPending_Enabled ? this.groupVariables.size() : 0;
            int initialNonUserFormattedVariablesSize = modify_formatAssignmentsPending_Enabled ? this.nonUserFormattedVariables.size() : 0;
            VariableDefinition vd = varDef;
            do {
                boolean primaryVariableSuccessful;
                if (primaryVariableSuccessful = DataSource._connectVariable(this.variableFactory.newVariable(vd), vd, this.varDef2Variable, this.variable2CategorizationModel, this.variable2SegmentedRangeStyle, this.variableProcessor, this.categorizer, this.sortEnabled, this.summarizationEnabled, this.groupVariables, this.nonUserFormattedVariables, this.isRelationalData(), this.variableRegistry)) {
                    DataSource._connectVariable((Variable)this.variableFactory.newHighVariable(vd), vd, this.varDef2HighVariable, this.variableProcessor, this.categorizer, this.sortEnabled, this.summarizationEnabled, this.groupVariables, this.nonUserFormattedVariables, this.isRelationalData(), this.variableRegistry);
                    DataSource._connectVariable((Variable)this.variableFactory.newLowVariable(vd), vd, this.varDef2LowVariable, this.variableProcessor, this.categorizer, this.sortEnabled, this.summarizationEnabled, this.groupVariables, this.nonUserFormattedVariables, this.isRelationalData(), this.variableRegistry);
                    DataSource._connectVariable((Variable)this.variableFactory.newTargetVariable(vd), vd, this.varDef2TargetVariable, this.variableProcessor, this.categorizer, this.sortEnabled, this.summarizationEnabled, this.groupVariables, this.nonUserFormattedVariables, this.isRelationalData(), this.variableRegistry);
                    this.initializeVariablesPending = true;
                }
                if (!(vd instanceof SelectionVariableDefinition)) continue;
                this.getSelectedPercentageVariable();
            } while ((vd = vd.getNext()) != null);
            this.initializeVariablesPending = true;
            if (modify_groupVariableAssignmentsPending_Enabled) {
                boolean bl = this.groupVariableAssignmentsPending = this.groupVariables.size() != initialGroupVariablesSize;
            }
            if (modify_formatAssignmentsPending_Enabled) {
                this.formatAssignmentsPending = this.nonUserFormattedVariables.size() != initialNonUserFormattedVariablesSize;
            }
            this.role2VarDef.put(role, varDef);
        }
    }

    private void _createLegendVariables(Object newLegendRole, VariableDefinition legendVariableDefinition, Variable[] fromVariables) {
        VariableDefinition vd = legendVariableDefinition;
        for (int ii = 0; ii < fromVariables.length && vd != null; ++ii, vd = vd.getNext()) {
            Object sr;
            Variable fv = fromVariables[ii];
            NumericVariable baseLegendVariable = null;
            NumericVariable legendVariable = null;
            if (fv instanceof StringVariable) {
                StringVariable sv;
                NumericVariable baseNV = this.getBaseVariable((StringVariable)fv);
                if (baseNV == null) {
                    sv = VariableFactory.newStringVariable(fv);
                    sv.setUniqueValueSort(1);
                    sv.setSortByFormattedValues(true);
                    legendVariable = sv;
                } else {
                    baseLegendVariable = VariableFactory.newNumericVariable(baseNV);
                    baseLegendVariable.setUniqueValueSort(1);
                    baseLegendVariable.setSortByFormattedValues(false);
                    baseLegendVariable.setLabel(fv.getLabel());
                    sv = VariableFactory.newStringVariable((Variable)baseLegendVariable);
                    sv.setUniqueValueSort(0);
                    legendVariable = sv;
                    this.stringVariable2numericVariable.put(legendVariable, baseLegendVariable);
                }
            } else if (fv instanceof NumericVariable) {
                NumericVariable nv = VariableFactory.newNumericVariable((NumericVariable)fv);
                nv.setUniqueValueSort(1);
                nv.setSortByFormattedValues(false);
                legendVariable = nv;
            } else {
                throw new UnsupportedOperationException("Unrecognized variable type.");
            }
            if (legendVariable == null) continue;
            NumericVariable v = baseLegendVariable != null ? baseLegendVariable : legendVariable;
            Object cm = this.variable2CategorizationModel.get(fv);
            if (cm != null) {
                this.variable2CategorizationModel.put(v, cm);
            }
            if ((sr = this.variable2SegmentedRangeStyle.get(fv)) != null) {
                this.variable2SegmentedRangeStyle.put(v, sr);
            }
            this.varDef2Variable.put(vd, legendVariable);
        }
        this.legendRole = newLegendRole;
        this.role2VarDef.put(this.legendRole, legendVariableDefinition);
    }

    private void _bindAsNeeded() {
        if (this.inheritancePending) {
            this._bindInheritence();
        }
        if (this.summarizationEnabled) {
            this._bindForSummarization();
        }
        if (this.formatAssignmentsPending) {
            this._bindFormatAssignments();
        }
        if (this.initializeVariablesPending) {
            this._initializeAllVariables();
        }
    }

    private void _bindInheritence() {
        if (this.inheritancePending) {
            DataSource parentDataSource = this.getParentDataSource();
            Object[] roles = parentDataSource.getRoles();
            if (roles != null) {
                for (int ii = 0; ii < roles.length && !Thread.currentThread().isInterrupted(); ++ii) {
                    Object role = roles[ii];
                    if (role == null) continue;
                    this._bindVariableDefinition(role, parentDataSource.getVariableDefinition(role));
                }
            }
            this.inheritancePending = false;
        }
    }

    private void _bindForSummarization() {
        if (this.summarizationEnabled) {
            if (this.groupVariableAssignmentsPending) {
                this._bindGroupVariableAssignments();
            }
            if (this.variableProcessor.getGroupVariableCount() < 1) {
                this.variableProcessor.addGroupVariable((Variable)new FrequencyVariable());
            }
        }
    }

    private void _bindGroupVariableAssignments() {
        if (this.groupVariableAssignmentsPending) {
            for (int ii = 0; ii < this.groupVariables.size(); ++ii) {
                this.variableProcessor.addGroupVariable((Variable)this.groupVariables.get(ii));
            }
            this.groupVariables.removeAllElements();
            this.groupVariableAssignmentsPending = false;
        }
    }

    private void _bindFormatAssignments() {
        if (this.autoFormatEnabled && this.formatAssignmentsPending) {
            boolean percentFormatFlag = false;
            for (int ii = 0; ii < this.nonUserFormattedVariables.size(); ++ii) {
                NumericVariable numericVariable;
                Object o = this.nonUserFormattedVariables.get(ii);
                if (o instanceof String && PERCENT_FLAG.equals(o)) {
                    percentFormatFlag = true;
                    continue;
                }
                if (o instanceof NumericVariable && (numericVariable = (NumericVariable)o).getFormat() == null) {
                    double[] values = GTKUtil.PipeAccess.getValues_as_doubleArray(numericVariable.uniqueValue);
                    String formatName = NumericFormat.getFormatName((double[])values, (int)-1, (boolean)percentFormatFlag);
                    GTKFormat gtkFormat = formatName != null ? this.newLocalizedGTKFormat(formatName) : GTKUtil.newGTKFormat_BEST();
                    numericVariable.setFormat(gtkFormat);
                }
                percentFormatFlag = false;
            }
            this._bindLegendVariableFormatAssignments();
            this.formatAssignmentsPending = false;
        }
    }

    private void _bindLegendVariableFormatAssignments() {
        if (this.legendRole != null && this.legendFromRole != null) {
            Variable[] legendVariables = this.replaceWithBaseVariableWhereApplicable(this._getVariable(this.legendRole));
            Variable[] legendFromVariables = this.replaceWithBaseVariableWhereApplicable(this._getVariable(this.legendFromRole));
            if (legendVariables != null && legendFromVariables != null) {
                int length = Math.min(legendVariables.length, legendFromVariables.length);
                for (int ii = 0; ii < length; ++ii) {
                    if (legendVariables[ii] == null || legendFromVariables[ii] == null) continue;
                    legendVariables[ii].setFormat(legendFromVariables[ii].getFormat());
                }
            }
        }
    }

    private void _initializeAllVariables() {
        if (this.initializeVariablesPending) {
            this._initializeVariables(this.varDef2Variable);
            this._initializeVariables(this.varDef2HighVariable);
            this._initializeVariables(this.varDef2LowVariable);
            this._initializeVariables(this.varDef2TargetVariable);
            this.initializeVariablesPending = false;
        }
    }

    private void _initializeVariables(Hashtable vht) {
        if (vht != null && !vht.isEmpty()) {
            try {
                this._initializeVariables(vht.values().toArray(VARIABLE_ARRAY));
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
    }

    private void _initializeVariables(Variable[] va) {
        if (va != null) {
            for (int ii = 0; ii < va.length && !Thread.currentThread().isInterrupted(); ++ii) {
                if (va[ii] instanceof NumericVariable) {
                    ((NumericVariable)va[ii]).value.init(new AInitAction());
                    continue;
                }
                if (!(va[ii] instanceof StringVariable)) continue;
                va[ii].init();
            }
        }
    }

    private static boolean _connectVariable(Variable variable, VariableDefinition varDef, Hashtable varDef2Var, Hashtable variable2CategorizationModel, Hashtable variable2SegmentedRangeStyle, VariableProcessor variableProcessor, Categorizer categorizer, boolean sortEnabled, boolean summarizationEnabled, Vector groupVariables, Vector nonUserFormattedVariables, boolean isRelationalData, VariableRegistry variableRegistry) {
        boolean successful = DataSource._connectVariable(variable, varDef, varDef2Var, variableProcessor, categorizer, sortEnabled, summarizationEnabled, groupVariables, nonUserFormattedVariables, isRelationalData, variableRegistry);
        if (variable instanceof NumericVariable && varDef != null && varDef.getCategorizationModel() != null) {
            variable2CategorizationModel.put(variable, varDef.getCategorizationModel());
            if (varDef.getSegmentedRangeStyle() != null) {
                variable2SegmentedRangeStyle.put(variable, varDef.getSegmentedRangeStyle());
            }
        }
        return successful;
    }

    private static boolean _connectVariable(Variable variable, VariableDefinition varDef, Hashtable varDef2Var, VariableProcessor variableProcessor, Categorizer categorizer, boolean sortEnabled, boolean summarizationEnabled, Vector groupVariables, Vector nonUserFormattedVariables, boolean isRelationalData, VariableRegistry variableRegistry) {
        boolean successful = false;
        if (variable != null) {
            variableRegistry.register(variable);
            if (sortEnabled && varDef.getSort() != null) {
                variable.setUniqueValueSort(varDef.asGTKSort());
                variable.setSortByFormattedValues(varDef.isSortByFormattedValue(variable));
            }
            if (varDef instanceof ClassificationVariableDefinition) {
                if (summarizationEnabled && (varDef.getVariant() & 4) == 0) {
                    groupVariables.add(variable);
                } else {
                    variableProcessor.addVariable(variable);
                }
                if (variable.getFormat() == null && variable instanceof NumericVariable) {
                    variable.setFormat(GTKUtil.newGTKFormat_BEST());
                }
                categorizer.addVariable(variable);
            } else if (varDef instanceof AnalysisVariableDefinition) {
                int gtkStat = ((AnalysisVariableDefinition)varDef).asGTKStatistic();
                if (varDef.getColumnName() != null || varDef.getColumnIndex() != null) {
                    switch (gtkStat) {
                        case 2: {
                            ((NumericVariable)variable).setFreqVariable(true);
                            gtkStat = 6;
                            break;
                        }
                        case 4: {
                            ((NumericVariable)variable).setFreqVariable(true);
                            gtkStat = 8;
                            break;
                        }
                        case 3: {
                            ((NumericVariable)variable).setFreqVariable(true);
                            gtkStat = 7;
                            break;
                        }
                        case 5: {
                            ((NumericVariable)variable).setFreqVariable(true);
                            gtkStat = 9;
                            break;
                        }
                    }
                }
                if (summarizationEnabled) {
                    variableProcessor.addVariable(variable, gtkStat);
                } else {
                    variableProcessor.addVariable(variable);
                }
                switch (gtkStat) {
                    default: {
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        boolean isPercent;
                        GTKFormat formats = variable.getFormat();
                        String pattern = formats != null && formats.getFormats()[0] instanceof SASFormat ? ((SASFormat)formats.getFormats()[0]).getName().toUpperCase() : "";
                        boolean bl = isPercent = pattern.startsWith("PERCENT") || pattern.startsWith("NLPCT");
                        if (formats != null && isPercent) break;
                        nonUserFormattedVariables.add(PERCENT_FLAG);
                        variable.setFormat(null);
                    }
                }
                if (variable.getFormat() == null) {
                    nonUserFormattedVariables.add(variable);
                }
            } else if (varDef instanceof SelectionVariableDefinition && isRelationalData) {
                variableProcessor.setSelectionVariable((NumericVariable)variable);
            } else {
                variableProcessor.addVariable(variable);
                if (!summarizationEnabled && variable.getFormat() == null && variable instanceof NumericVariable) {
                    variable.setFormat(GTKUtil.newGTKFormat_BEST());
                }
            }
            if ((varDef.getVariant() & 2) > 0 && variable instanceof NumericVariable) {
                StringVariable stringVariable = VariableFactory.newStringVariable(variable);
                varDef2Var.put(stringVariable, variable);
                variable = stringVariable;
            }
            if ((varDef.getVariant() & 8) > 0) {
                variableProcessor.setSubgroupStyleCumulativeStatistics(true);
            }
            varDef2Var.put(varDef, variable);
            successful = true;
        }
        return successful;
    }

    public boolean isOLAPData() {
        return this.variableFactory.isOLAPData();
    }

    public com.sas.graphics.util.gtk.OLAPVariableFactory getGTKOLAPVariableFactory() {
        if (this.isOLAPData()) {
            if (!this.isRoot()) {
                return this.getRootDataSource().getGTKOLAPVariableFactory();
            }
            if (this.variableFactory instanceof OLAPVariableFactory) {
                return ((OLAPVariableFactory)this.variableFactory).getGTKOLAPVariableFactory();
            }
        }
        return null;
    }

    public DataTreeGroupNode[] createTrees(Object columnRole, Object rowRole) throws OLAPException {
        DataTreeGroupNode[] dt = null;
        if (this.isOLAPData()) {
            com.sas.graphics.util.gtk.OLAPVariableFactory ovf = this.getGTKOLAPVariableFactory();
            if (ovf != null) {
                List rowNames = this._asList(this.getVariableNames(rowRole));
                List columnNames = this._asList(this.getVariableNames(columnRole));
                dt = ovf.createRowColumnTrees(rowNames, columnNames);
            }
        } else if (this.isRelationalData()) {
            Variable[] rowVariables = this.getVariablesReplaceWithBaseVariablesWhereApplicable(rowRole);
            Variable[] columnVariables = this.getVariablesReplaceWithBaseVariablesWhereApplicable(columnRole);
            dt = VariableProcessor.createRowColumnTrees((Variable[])rowVariables, (Variable[])columnVariables);
        }
        if (dt != null) {
            void t = dt[0];
            dt[0] = dt[1];
            dt[1] = t;
        }
        return dt;
    }

    public DataTreeGroupNode[] createTrees(List columnRoles, List rowRoles) throws OLAPException {
        DataTreeGroupNode[] dt = null;
        if (this.isOLAPData()) {
            com.sas.graphics.util.gtk.OLAPVariableFactory ovf = this.getGTKOLAPVariableFactory();
            if (ovf != null) {
                ArrayList rowNames = new ArrayList();
                if (rowRoles != null) {
                    for (int ii = 0; ii < rowRoles.size(); ++ii) {
                        rowNames.addAll(this._asList(this.getVariableNames(rowRoles.get(ii))));
                    }
                }
                ArrayList columnNames = new ArrayList();
                if (columnRoles != null) {
                    for (int ii = 0; ii < columnRoles.size(); ++ii) {
                        columnNames.addAll(this._asList(this.getVariableNames(columnRoles.get(ii))));
                    }
                }
                dt = ovf.createRowColumnTrees(rowNames, columnNames);
            }
        } else if (this.isRelationalData()) {
            Variable[] rowVariables = new Variable[]{};
            if (rowRoles != null) {
                ArrayList al = new ArrayList();
                for (int ii = 0; ii < rowRoles.size(); ++ii) {
                    al.addAll(this._asList(this.getVariablesReplaceWithBaseVariablesWhereApplicable(rowRoles.get(ii))));
                }
                if (al.size() > 0) {
                    rowVariables = al.toArray(rowVariables);
                }
            }
            Variable[] columnVariables = new Variable[]{};
            if (columnRoles != null) {
                ArrayList al = new ArrayList();
                for (int ii = 0; ii < columnRoles.size(); ++ii) {
                    al.addAll(this._asList(this.getVariablesReplaceWithBaseVariablesWhereApplicable(columnRoles.get(ii))));
                }
                if (al.size() > 0) {
                    columnVariables = al.toArray(columnVariables);
                }
            }
            dt = VariableProcessor.createRowColumnTrees((Variable[])rowVariables, (Variable[])columnVariables);
        }
        if (dt != null) {
            void t = dt[0];
            dt[0] = dt[1];
            dt[1] = t;
        }
        return dt;
    }

    private List _asList(Variable[] va) {
        ArrayList<Variable> al = new ArrayList<Variable>();
        if (va != null) {
            for (int ii = 0; ii < va.length; ++ii) {
                al.add(va[ii]);
            }
        }
        return al;
    }

    private List _asList(String[] sa) {
        ArrayList<String> al = new ArrayList<String>();
        if (sa != null) {
            for (int ii = 0; ii < sa.length; ++ii) {
                al.add(sa[ii]);
            }
        }
        return al;
    }

    public boolean isRelationalData() {
        return this.variableFactory.isRelationalData();
    }

    public void sortBy(Object role) {
        Variable variable;
        this.sortByRole = role;
        this.sortByRoleIndex = -1;
        this.sortByOrder = -1;
        VariableDefinition varDef = this.getVariableDefinition(role);
        if (varDef != null && (variable = this.getVariable(varDef)) != null) {
            this.variableProcessor.setSort(variable, varDef.asGTKSort());
        }
    }

    public void sortByVar(Variable variable, int sortOrder) {
        if (variable != null) {
            this.variableProcessor.setSort(variable, sortOrder);
        }
    }

    public void sortBy(Object role, int index, int sortOrder) {
        this.sortByRole = role;
        this.sortByRoleIndex = index;
        this.sortByOrder = sortOrder;
        Variable variable = this.getVariable(role, index);
        if (variable != null) {
            switch (this.sortByOrder) {
                default: {
                    variable.setSortByFormattedValues(false);
                    break;
                }
                case 10403: 
                case 10404: {
                    variable.setSortByFormattedValues(true);
                    break;
                }
                case 10401: 
                case 10402: {
                    variable.setSortByFormattedValues(variable instanceof StringVariable);
                }
            }
            this.variableProcessor.setSort(variable, VariableDefinition.asGTKSort(this.sortByOrder));
        }
    }

    public int[] getSelectedIndexes() {
        NumericVariable sv;
        if (!this.isOLAPData() && (sv = this.variableProcessor.getSelectionVariable()) instanceof NumericVariable) {
            ArrayList<Integer> al = new ArrayList<Integer>();
            NumericVariable nsv = sv;
            int obs = this.getValueCount();
            for (int ii = 0; ii < obs; ++ii) {
                try {
                    if (nsv.value.getValue(ii) == 0.0) continue;
                    al.add(new Integer(ii));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            int[] iobsa = null;
            if (al.size() > 0) {
                iobsa = new int[al.size()];
                for (int ii = 0; ii < al.size(); ++ii) {
                    iobsa[ii] = (Integer)al.get(ii);
                }
            }
            return iobsa;
        }
        return null;
    }

    public class DataSourceListSelectionModel
    implements ListSelectionModel {
        private static final int ADD = 0;
        private static final int SET = 1;
        private static final int REMOVE = 2;
        ListSelectionModel delegate;
        private final List temp = new ArrayList();
        private final List temp2 = new ArrayList();
        private List scratchNameList = new ArrayList();

        DataSourceListSelectionModel(ListSelectionModel dlsm) {
            this.delegate = dlsm;
        }

        @Override
        public void setSelectionInterval(int s, int e) {
            List indexList = this._asIndicesPriorToProcessing(s, e, null);
            this.updateSelection(indexList, null, 1);
        }

        public void setSelectionInterval(int s, int e, String name) {
            List indexList = this._asIndicesPriorToProcessing(s, e, name);
            this.updateSelection(indexList, name, 1);
        }

        @Override
        public void addSelectionInterval(int s, int e) {
            List indexList = this._asIndicesPriorToProcessing(s, e, null);
            this.updateSelection(indexList, null, 0);
        }

        public void addSelectionInterval(int s, int e, String name) {
            List indexList = this._asIndicesPriorToProcessing(s, e, name);
            this.updateSelection(indexList, name, 0);
        }

        @Override
        public void removeSelectionInterval(int s, int e) {
            List indexList = this._asIndicesPriorToProcessing(s, e, null);
            this.updateSelection(indexList, null, 2);
        }

        public void removeSelectionInterval(int s, int e, String name) {
            List indexList = this._asIndicesPriorToProcessing(s, e, null);
            this.updateSelection(indexList, name, 2);
        }

        @Override
        public void removeIndexInterval(int s, int e) {
        }

        private void updateSelection(List indexList, String name, int updateType) {
            if (updateType == 1) {
                this.delegate.clearSelection();
            }
            this.delegate.setValueIsAdjusting(true);
            int n = indexList.size();
            block8: for (int i = 0; i < n; ++i) {
                int index = (Integer)indexList.get(i);
                if (this.delegate instanceof DataSourceListSelectionModel) {
                    switch (updateType) {
                        case 0: 
                        case 1: {
                            ((DataSourceListSelectionModel)this.delegate).addSelectionInterval(index, index, name);
                            break;
                        }
                        case 2: {
                            ((DataSourceListSelectionModel)this.delegate).removeSelectionInterval(index, index, name);
                        }
                    }
                    continue;
                }
                switch (updateType) {
                    case 0: 
                    case 1: {
                        this.delegate.addSelectionInterval(index, index);
                        continue block8;
                    }
                    case 2: {
                        this.delegate.removeSelectionInterval(index, index);
                    }
                }
            }
        }

        private boolean isSelectedIndex(List indexList, String name) {
            boolean isSelectedIndex = false;
            int n = indexList.size();
            for (int i = 0; i < n; ++i) {
                int index = (Integer)indexList.get(i);
                isSelectedIndex = this.delegate instanceof DataSourceListSelectionModel ? isSelectedIndex || ((DataSourceListSelectionModel)this.delegate).isSelectedIndex(index, name) : isSelectedIndex || this.delegate.isSelectedIndex(index);
            }
            return isSelectedIndex;
        }

        private List _asIndicesPriorToProcessing(int s, int e, String name) {
            int i;
            this.temp.clear();
            for (i = s; i <= e; ++i) {
                List l = DataSource.this.variableProcessor.getIndicesPriorToProcessing(i);
                this.temp.addAll(l);
            }
            if (DataSource.this.variableFactory instanceof OLAPVariableFactory) {
                List measureNames;
                if (name != null) {
                    this.scratchNameList.clear();
                    this.scratchNameList.add(name);
                    measureNames = this.scratchNameList;
                } else {
                    measureNames = ((OLAPVariableFactory)DataSource.this.variableFactory).getGTKOLAPVariableFactory().getMeasureNames();
                }
                int nameCount = measureNames.size();
                int indexCount = this.temp.size();
                this.temp2.clear();
                for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                    String measureName = (String)measureNames.get(nameIndex);
                    for (i = 0; i < indexCount; ++i) {
                        int valueIndex = (Integer)this.temp.get(i);
                        int cellIndex = ((OLAPVariableFactory)DataSource.this.variableFactory).getCellIndex(valueIndex, measureName);
                        this.temp2.add(new Integer(cellIndex));
                    }
                }
                this.temp.clear();
                this.temp.addAll(this.temp2);
            }
            return this.temp;
        }

        @Override
        public void clearSelection() {
            this.delegate.clearSelection();
        }

        @Override
        public void setValueIsAdjusting(boolean v) {
            this.delegate.setValueIsAdjusting(v);
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.delegate.getValueIsAdjusting();
        }

        @Override
        public void setSelectionMode(int m) {
            this.delegate.setSelectionMode(m);
        }

        @Override
        public int getSelectionMode() {
            return this.delegate.getSelectionMode();
        }

        @Override
        public void insertIndexInterval(int a, int b, boolean c) {
        }

        @Override
        public boolean isSelectedIndex(int a) {
            List indexList = this._asIndicesPriorToProcessing(a, a, null);
            return this.isSelectedIndex(indexList, null);
        }

        public boolean isSelectedIndex(int a, String name) {
            List indexList = this._asIndicesPriorToProcessing(a, a, name);
            return this.isSelectedIndex(indexList, name);
        }

        @Override
        public boolean isSelectionEmpty() {
            return true;
        }

        @Override
        public void setAnchorSelectionIndex(int a) {
        }

        @Override
        public int getAnchorSelectionIndex() {
            return -1;
        }

        @Override
        public int getLeadSelectionIndex() {
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            return -1;
        }

        @Override
        public int getMinSelectionIndex() {
            return -1;
        }

        @Override
        public void setLeadSelectionIndex(int l) {
            this.delegate.setLeadSelectionIndex(l);
        }

        @Override
        public void addListSelectionListener(ListSelectionListener l) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener l) {
        }
    }

    private class DataSourceListSelectionListener
    implements ListSelectionListener {
        private int[] isSelected;
        private int isSelectedLength;
        private boolean isSubsetDataOnSelection = false;

        private DataSourceListSelectionListener() {
        }

        public void setSubsetDataOnSelection(boolean subsetDataOnSelection) {
            if (subsetDataOnSelection != this.isSubsetDataOnSelection) {
                this.isSubsetDataOnSelection = subsetDataOnSelection;
                if (this.isSubsetDataOnSelection) {
                    this.isSelected = NOTHING_SELECTED;
                    this.isSelectedLength = 0;
                    DataSource.this.variableProcessor.setSubsetByObservation(this.isSelected, this.isSelectedLength);
                }
            }
        }

        public boolean isSubsetDataOnSelection() {
            return this.isSubsetDataOnSelection;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.isSubsetDataOnSelection) {
                this.subsetSelectedObservations(e);
            }
        }

        private void subsetSelectedObservations(ListSelectionEvent e) {
            int first = e.getFirstIndex();
            int last = e.getLastIndex() + 1;
            boolean isSortNeeded = false;
            int sc = 0;
            if (this.isSelected == null) {
                this.isSelected = new int[last - first];
            } else {
                for (int ii = 0; ii < this.isSelectedLength; ++ii) {
                    if (this.isSelected[ii] >= first && this.isSelected[ii] < last) continue;
                    if (sc != ii) {
                        this.isSelected[sc] = this.isSelected[ii];
                    }
                    if (!isSortNeeded && this.isSelected[sc] >= last) {
                        isSortNeeded = true;
                    }
                    ++sc;
                }
            }
            this.isSelectedLength = sc;
            for (int ii = first; ii < last; ++ii) {
                if (!DataSource.this.listSelectionModel.isSelectedIndex(ii)) continue;
                if (this.isSelectedLength >= this.isSelected.length) {
                    int[] s = new int[this.isSelected.length + last - ii];
                    System.arraycopy(this.isSelected, 0, s, 0, this.isSelected.length);
                    this.isSelected = s;
                }
                this.isSelected[this.isSelectedLength++] = ii;
            }
            if (isSortNeeded) {
                Util.quickSort(this.isSelected, 0, this.isSelectedLength - 1);
            }
            DataSource.this.variableProcessor.setSubsetByObservation(this.isSelected, this.isSelectedLength);
        }
    }

    private static class VariableRegistry {
        private final HashMap nameMap = new HashMap();

        private VariableRegistry() {
        }

        protected boolean register(Variable v) {
            boolean nameNotModified = true;
            if (v != null) {
                String name = v.getName();
                int inc = 1;
                while (this.nameMap.containsKey(name)) {
                    name = v.getName() + "_" + inc++;
                }
                if (!name.equals(v.getName())) {
                    v.setName(name);
                    nameNotModified = false;
                }
                this.nameMap.put(name, v);
            }
            return nameNotModified;
        }
    }
}

