/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.FillStyle;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.lang.ref.SoftReference;

public class CustomMarker
implements CustomMarkerInterface {
    private Channel channel;
    private int marker;
    private int stipplePattern;
    private int stippleFactor;
    private FillStyle fillStyle;
    private Color lineColor;
    private Color outlineColor;
    private final NetworkRoot networkRoot = new NetworkRoot();
    private AbstractMarkerSkinFactory skinFactory;
    private SoftReference[][] scaledSkinCache = null;
    private int SKIN_CACHE_LIMIT = 100;
    private boolean antialiasingOn = false;

    public CustomMarker(Channel ch, int aMarker, int pattern, int factor, Color color) {
        this.channel = ch;
        this.marker = aMarker;
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
        this.lineColor = color;
        this.fillStyle = null;
    }

    public CustomMarker(Channel ch, int aMarker, FillStyle fs, Color outline) {
        this.channel = ch;
        this.marker = aMarker;
        this.stipplePattern = 0;
        this.fillStyle = fs;
        this.outlineColor = outline;
    }

    public CustomMarker(Channel ch, FillStyle aFillStyle, Color outline) {
        this.channel = ch;
        this.marker = -1;
        this.stipplePattern = 0;
        this.stippleFactor = 0;
        this.fillStyle = aFillStyle;
        this.outlineColor = outline;
    }

    public CustomMarker(Channel ch, int aMarker, FillStyle aFillStyle, Color outline, int pattern, int factor, Color color) {
        this.channel = ch;
        this.marker = aMarker;
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
        this.fillStyle = aFillStyle;
        this.lineColor = color;
        this.outlineColor = outline;
    }

    public CustomMarker(Channel ch, FillStyle aFillStyle, int pattern, int factor, Color color) {
        this.channel = ch;
        this.marker = -1;
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
        this.fillStyle = aFillStyle;
        this.lineColor = color;
    }

    public void paint(Graphics g, Color color, Color edgeColor, int x, int y, int w, int h) {
        double[] p2;
        double[] p1;
        double size = w;
        double boxsize = 1.25 * (double)w;
        double midx = (double)x + (double)w / 2.0;
        this.networkRoot.removeAllElements();
        if (this.stipplePattern != 0) {
            size *= 0.75;
            midx = (double)x + 0.125 * (double)w;
            p1 = new double[]{midx - 1.75 * (double)w / 2.0, y + h / 2, 0.0};
            p2 = new double[]{midx + 1.75 * (double)w / 2.0, y + h / 2, 0.0};
            this.channel.gluUnProject(p1, p1);
            this.channel.gluUnProject(p2, p2);
            Color line = this.lineColor != null ? this.lineColor : color;
            LineSegment.drawLineSegment((Channel)this.channel, (double)p1[0], (double)p1[1], (double)p1[2], (double)p2[0], (double)p2[1], (double)p2[2], (Color)line, (double)2.0, (int)this.stipplePattern, (int)this.stippleFactor);
        }
        if (this.fillStyle != null) {
            p1 = new double[]{midx - boxsize / 2.0, y, 0.0};
            p2 = new double[]{midx + boxsize / 2.0, y + h, 0.0};
            this.channel.gluUnProject(p1, p1);
            this.channel.gluUnProject(p2, p2);
            Bar bar = new Bar();
            bar.setTwoD(true);
            bar.thickness.setValue(size);
            bar.verticalOn.setValue(true);
            bar.edgeOn.setValue(true);
            bar.edgeColor.setValue(this.outlineColor);
            bar.edgeWidth.setValue(1.0);
            bar.startValue.setValue(p1[1]);
            bar.endValue.setValue(p2[1]);
            bar.transform.translateX.setValue((p1[0] + p2[0]) / 2.0);
            if (this.skinFactory != null) {
                bar.setSkin(this.skinFactory.getSkinImage(3));
            }
            GTKUtil.BarAttributes.applyFillStyle(bar, this.fillStyle);
            this.networkRoot.addElement((Element)bar);
            this.networkRoot.draw(this.channel);
            size *= 0.75;
        }
        if (this.marker != -1) {
            p1 = new double[]{(int)midx, y + h / 2, 0.0};
            this.channel.gluUnProject(p1, p1);
            if (this.skinFactory != null) {
                Markers.draw((Graphics)g, (Color)color, (Color)edgeColor, (int)this.marker, (int)((int)size), (int)((int)midx), (int)(y + h / 2), (Image)this.skinFactory.getSkinImage(this.marker));
            } else {
                Markers.draw((Graphics)g, (Color)color, (Color)edgeColor, (int)this.marker, (int)((int)size), (int)((int)midx), (int)(y + h / 2), (boolean)false, (int)1, (int)1, (boolean)this.antialiasingOn);
            }
        }
        this.networkRoot.removeAllElements();
    }

    public void setMarkerSkinFactory(AbstractMarkerSkinFactory skinFactory) {
        this.skinFactory = skinFactory;
    }

    public void setAntialiasingOn(boolean b) {
        this.antialiasingOn = b;
    }
}

