/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.ValueZone;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.AxisDetail;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.gtk.gl.Transform;
import com.sas.measures.BaseLength;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class AxisCell
extends Cell {
    AlignableComponentConstraints cachedAlignableComponentConstraints = null;
    Dimension cachedPreferredSize = null;
    private LabelZoneList labelZoneImageMapCache = null;
    private ValueZone[] valueZonesImageMapCache = null;

    public AxisCell(AxisCellModel cellModel, Channel channel) {
        super(cellModel, channel);
    }

    @Override
    protected synchronized void construct() {
        Util.LabelWithPosition result;
        TextStyle textStyle;
        int i;
        int len;
        boolean continuous;
        this.labelZoneImageMapCache = null;
        this.valueZonesImageMapCache = null;
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        AxisModel axisModel = cellModel.getAxisModel();
        NumericMapper mapper = cellModel.getMapper();
        if (mapper == null) {
            return;
        }
        String axisOrientation = cellModel.getAxisOrientation();
        boolean horz = axisOrientation == "East" || axisOrientation == "West";
        boolean primary = cellModel.getPrimary();
        if (axisModel.isVisible()) {
            StringPipe valueLabels;
            NumericPipe values;
            ShadowStyle shadow;
            Font font;
            TextStyle textStyle2;
            RasterLabel label;
            RectangularAxis axis;
            int numMargins;
            Rectangle bounds = this.getBounds();
            int titleMarkerID = this.getChannel().addCustomMarker((CustomMarkerInterface)cellModel.getTitleMarker());
            Double Len = cellModel.getLength();
            double length = Len;
            int catAxisAdj = cellModel.getCatAxisAdj().intValue();
            int resAxisAdj = cellModel.getResAxisAdj().intValue();
            Dimension margin = cellModel.getMargin();
            Dimension depth = cellModel.getDepth();
            boolean dim3D = depth != null && depth.width > 0;
            int placement = cellModel.getTitlePlacementType();
            String title = cellModel.getTitle();
            boolean titleOn = cellModel.getTitleOn();
            BaseLength bl = axisModel.getStartOffset();
            boolean startOffset = bl != null;
            double start = startOffset ? bl.getMagnitude((Object)"px") : 0.0;
            bl = axisModel.getEndOffset();
            boolean endOffset = bl != null;
            double end = endOffset ? bl.getMagnitude((Object)"px") : 0.0;
            boolean extendToMargins = cellModel.getExtendToMargin();
            boolean extendToStartMargin = !startOffset && (extendToMargins || cellModel.getExtendToStartMargin() != false);
            boolean extendToEndMargin = !endOffset && (extendToMargins || cellModel.getExtendToEndMargin() != false);
            double offset = start;
            int n = numMargins = extendToEndMargin ? 1 : 0;
            if (extendToStartMargin) {
                ++numMargins;
                double d = offset = horz ? (double)Math.min(margin.width, bounds.width / 2) : (double)Math.min(margin.height, bounds.height / 2);
            }
            if ((axis = cellModel.getGTKAxis(mapper)) == null) {
                axis = cellModel.createGTKAxis(this.getChannel());
            }
            StrokeLineStyle axisLineStyle = axisModel.getAxisLineStyle();
            int lineThickness = (int)axisLineStyle.getThickness().getMagnitude((Object)"px");
            int lineWidth = axisLineStyle.getVisibilityPolicy() != 10202 && lineThickness > 0 ? lineThickness + 1 : 0;
            int axisLength = (int)(length + start + end);
            if (horz) {
                axis.setLength((double)(axisLength += numMargins * margin.width));
                axis.setLineOffset(-offset);
                if (primary) {
                    this.getComposite().transform.translateX.setValue((double)resAxisAdj + offset);
                } else {
                    this.getComposite().transform.translateX.setValue((double)resAxisAdj + offset + (double)depth.height);
                }
                axisLength = (int)((double)axisLength - offset);
                if (titleOn && (placement == 11302 || placement == 11303)) {
                    label = new RasterLabel();
                    textStyle2 = axisModel.getLabelTextStyle();
                    font = textStyle2.getFont();
                    label.fontName.setValue(font.getName());
                    label.fontSize.setValue(font.getSize());
                    label.fontStyle.setValue(font.getStyle());
                    label.color.setValue(textStyle2.getColor());
                    shadow = textStyle2.getShadowStyle();
                    label.shadowColor.setValue(shadow.getColor());
                    label.shadowOn.setValue(shadow.isVisible());
                    label.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
                    label.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
                    label.horizontalJustification.setValue(0);
                    if (primary) {
                        label.verticalJustification.setValue(0);
                        label.setUserData((Object)"PX");
                    } else {
                        label.verticalJustification.setValue(3);
                        label.setUserData((Object)"SX");
                    }
                    label.transform.translateX.setValue((double)(axisLength + 3));
                    label.string.setValue(title);
                    label.selectEnabled.setValue(true);
                    this.getComposite().addElement((Element)label);
                }
                if (primary) {
                    this.getComposite().transform.translateY.setValue((double)(bounds.height - lineWidth / 2));
                } else {
                    this.getComposite().transform.translateY.setValue(2.0);
                }
            } else {
                axis.setLength((double)(axisLength += numMargins * margin.height));
                axis.setLineOffset(-offset);
                axisLength = (int)((double)axisLength - offset);
                axis.transform.connectFrom((ATransform)new Transform());
                if (primary) {
                    this.getComposite().transform.translateY.setValue((double)catAxisAdj + offset);
                } else {
                    this.getComposite().transform.translateY.setValue((double)catAxisAdj + offset + (double)depth.height);
                }
                if (primary) {
                    this.getComposite().transform.translateX.setValue((double)(bounds.width - lineWidth / 2));
                } else {
                    this.getComposite().transform.translateX.setValue((double)((lineWidth + 1) / 2));
                }
                if (placement == 11302 || placement == 11303) {
                    Integer cutLength;
                    label = new RasterLabel();
                    textStyle2 = axisModel.getLabelTextStyle();
                    font = textStyle2.getFont();
                    label.fontName.setValue(font.getName());
                    label.fontSize.setValue(font.getSize());
                    label.fontStyle.setValue(font.getStyle());
                    label.color.setValue(textStyle2.getColor());
                    shadow = textStyle2.getShadowStyle();
                    label.shadowColor.setValue(shadow.getColor());
                    label.shadowOn.setValue(shadow.isVisible());
                    label.shadowOffsetX.setValue((int)shadow.getOffsetX().getMagnitude((Object)"px"));
                    label.shadowOffsetY.setValue((int)shadow.getOffsetY().getMagnitude((Object)"px"));
                    if (primary) {
                        label.horizontalJustification.setValue(2);
                        cutLength = null;
                        if (placement == 11303 && (cutLength = cellModel.getTitleBreak()) != null) {
                            title = title.substring(0, cutLength);
                        }
                        label.setUserData((Object)"PY");
                    } else {
                        label.horizontalJustification.setValue(0);
                        cutLength = null;
                        if (placement == 11303 && (cutLength = cellModel.getTitleBreak()) != null) {
                            title = title.substring(cutLength);
                        }
                        label.setUserData((Object)"SY");
                    }
                    label.string.setValue(title);
                    label.selectEnabled.setValue(true);
                    if (primary && dim3D) {
                        label.transform.translateY.setValue((double)(axisLength + 2 + depth.height));
                    } else {
                        label.transform.translateY.setValue((double)(axisLength + 2));
                    }
                    label.verticalJustification.setValue(3);
                    this.getComposite().addElement((Element)label);
                }
            }
            AxisStyle axisStyle = axis.getStyle();
            if (axisModel.isDrillIconVisible() && cellModel.getTitleMarker() != null) {
                axisStyle.setTitleMarkerVisible(true);
                axisStyle.setTitleMarkerId(titleMarkerID);
                axisStyle.setTitleMarkerSize(cellModel.getTitleMarker().getSize());
            }
            if ((values = cellModel.getValues()) != null) {
                axis.labelOffset.connectFrom(values);
            }
            if ((valueLabels = cellModel.getValueLabels()) != null) {
                axis.labels.connectFrom(valueLabels);
            }
            axis.selectDetailEnabled.setValue(true);
            axis.selectEnabled.setValue(true);
            if (lineThickness == 0) {
                axis.getStyle().setAxisLineOn(false);
            }
            this.getComposite().addElement((Element)axis);
        }
        if (!(continuous = mapper instanceof ContinuousRangeToNumericMapper)) {
            return;
        }
        ReferenceLineModel[] refLinemodels = axisModel.getReferenceLineModels();
        if (refLinemodels == null) {
            return;
        }
        ContinuousRangeToNumericMapper cmapper = (ContinuousRangeToNumericMapper)mapper;
        TextStyle valueTextStyle = axisModel.getValueTextStyle();
        TextStyle defaultTextStyle = axisModel.getValueTextStyle();
        if (!horz) {
            len = refLinemodels.length;
            for (i = 0; i < len; ++i) {
                double xpos;
                RasterLabel label;
                if (refLinemodels[i] == null) continue;
                textStyle = refLinemodels[i].getTextStyle();
                if (textStyle == null) {
                    textStyle = defaultTextStyle;
                }
                if (!refLinemodels[i].isVisible() || !textStyle.isVisible() || refLinemodels[i].getLabelPlacement() != 11302 && refLinemodels[i].getLabelPlacement() != 10200) continue;
                result = Util.LabelWithPosition.getRefLineLabel(refLinemodels[i], cmapper);
                String text = result.getLabelText();
                double position = result.getPosition();
                if (text == null || Double.isNaN(position)) continue;
                double ypos = cmapper.getValue(position);
                if (primary) {
                    label = new RasterLabel();
                    label.horizontalJustification.setValue(2);
                    xpos = -valueTextStyle.getFont().getSize() / 2;
                } else {
                    label = new RasterLabel();
                    label.horizontalJustification.setValue(0);
                    xpos = valueTextStyle.getFont().getSize() / 2;
                }
                this._setupLabel(label, textStyle, xpos, ypos, text);
                this.getComposite().addElement((Element)label);
            }
        } else {
            len = refLinemodels.length;
            for (i = 0; i < len; ++i) {
                RasterLabel label;
                if (refLinemodels[i] == null) continue;
                textStyle = refLinemodels[i].getTextStyle();
                if (textStyle == null) {
                    textStyle = defaultTextStyle;
                }
                if (!refLinemodels[i].isVisible() || !textStyle.isVisible() || refLinemodels[i].getLabelPlacement() != 11302 && refLinemodels[i].getLabelPlacement() != 10200) continue;
                result = Util.LabelWithPosition.getRefLineLabel(refLinemodels[i], cmapper);
                String text = result.getLabelText();
                double position = result.getPosition();
                if (text == null || Double.isNaN(position)) continue;
                double xpos = cmapper.getValue(position);
                double ypos = 0.0;
                if (primary) {
                    ypos = -valueTextStyle.getFont().getSize() / 2;
                    label = new RasterLabel();
                    label.verticalJustification.setValue(0);
                } else {
                    ypos = valueTextStyle.getFont().getSize() / 2;
                    label = new RasterLabel();
                    label.horizontalJustification.setValue(3);
                }
                this._setupLabel(label, textStyle, xpos, ypos, text);
                this.getComposite().addElement((Element)label);
            }
        }
    }

    private void _setupLabel(RasterLabel label, TextStyle textStyle, double xpos, double ypos, String text) {
        Font font = textStyle.getFont();
        label.fontName.setValue(font.getName());
        label.fontSize.setValue(font.getSize());
        label.fontStyle.setValue(font.getStyle());
        label.color.setValue(textStyle.getColor());
        label.verticalJustification.setValue(1);
        label.shadowColor.setValue(textStyle.getShadowStyle().getColor());
        label.shadowOn.setValue(textStyle.getShadowStyle().isVisible());
        label.shadowOffsetX.setValue((int)textStyle.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
        label.shadowOffsetY.setValue((int)textStyle.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
        if (textStyle instanceof AdvancedTextStyle) {
            label.angle.setValue(Util.resolveBaselineAngle((AdvancedTextStyle)textStyle));
        }
        label.transform.translateX.setValue(xpos);
        label.transform.translateY.setValue(ypos);
        label.string.setValue(text);
    }

    public void doConstruct() {
        this.getComposite().removeAllElements();
        this.construct();
    }

    @Override
    public AlignableComponentConstraints getPreferredAlignableComponentConstraints(Dimension size) {
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        if (this.cachedAlignableComponentConstraints != null && cellModel.getReusePreferredSize().booleanValue()) {
            return this.cachedAlignableComponentConstraints;
        }
        return this._getPreferredAlignableComponentConstraints(size);
    }

    public AlignableComponentConstraints _getPreferredAlignableComponentConstraints(Dimension size) {
        boolean horz;
        AlignableComponentConstraints constraints = new AlignableComponentConstraints();
        Channel channel = this.getChannel();
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        AxisModel axisModel = cellModel.getAxisModel();
        String axisOrientation = cellModel.getAxisOrientation();
        channel.glSelect2DFont(axisModel.getValueTextStyle().getFont());
        boolean bl = horz = axisOrientation == "East" || axisOrientation == "West";
        if (horz) {
            RectangularAxis axis = cellModel.getGTKAxis(cellModel.getMapper());
            if (axis != null) {
                AxisMetrics axisMetrics = axis.getMetrics(channel);
                constraints.setOuterMargin(new Insets(0, (int)Math.ceil(axisMetrics.getLowExtender()), 0, (int)Math.ceil(axisMetrics.getHighExtender())));
            }
        } else {
            int margin = (int)Math.ceil(channel.glGetTextHeight() / 2.0);
            constraints.setOuterMargin(new Insets(margin, 0, margin, 0));
        }
        return constraints;
    }

    @Override
    public Dimension getPreferredSize() {
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        if (cellModel.getReusePreferredSize().booleanValue()) {
            if (this.cachedPreferredSize != null) {
                return this.cachedPreferredSize;
            }
            this.cachedPreferredSize = this._getPreferredSize(false);
            return this.cachedPreferredSize == null ? super.getPreferredSize() : this.cachedPreferredSize;
        }
        return this._getPreferredSize(false);
    }

    @Override
    public Dimension getMinimumSize() {
        return this._getPreferredSize(true);
    }

    private Dimension _getPreferredSize(boolean min) {
        Dimension d;
        int numMargins;
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        AxisModel axisModel = cellModel.getAxisModel();
        NumericMapper mapper = cellModel.getMapper();
        if (!axisModel.isVisible() || mapper == null) {
            return new Dimension(1, 1);
        }
        String orient = cellModel.getAxisOrientation();
        int catAxisAdj = cellModel.getCatAxisAdj().intValue();
        int resAxisAdj = cellModel.getResAxisAdj().intValue();
        if (!cellModel.getAxisVisible().booleanValue() && (mapper instanceof StringToNumericMapper || cellModel.getAxisModel().getReferenceLineModels() == null)) {
            Dimension margin = cellModel.getMargin();
            catAxisAdj = Math.min(4, margin.height);
            resAxisAdj = Math.min(4, margin.width);
        }
        int titleWidth = cellModel.getTitleWidth().intValue();
        int titleHeight = cellModel.getTitleHeight().intValue();
        int len = min ? cellModel.getPreferredLength().intValue() : cellModel.getIdealPreferredLength().intValue();
        Dimension margin = cellModel.getMargin();
        Dimension depth = cellModel.getDepth();
        BaseLength bl = axisModel.getStartOffset();
        boolean startOffset = bl != null;
        int start = startOffset ? (int)bl.getMagnitude((Object)"px") : 0;
        bl = axisModel.getEndOffset();
        boolean endOffset = bl != null;
        int end = endOffset ? (int)bl.getMagnitude((Object)"px") : 0;
        boolean extendToMargins = cellModel.getExtendToStartMargin();
        boolean extendToStartMargin = !endOffset && (extendToMargins || cellModel.getExtendToStartMargin() != false);
        boolean extendToEndMargin = !startOffset && (extendToMargins || cellModel.getExtendToEndMargin() != false);
        int n = numMargins = extendToStartMargin ? 1 : 0;
        if (extendToEndMargin) {
            ++numMargins;
        }
        int lineThickness = (int)axisModel.getAxisLineStyle().getThickness().getMagnitude((Object)"px");
        if (orient == "North" || orient == "South") {
            if (resAxisAdj < 2) {
                resAxisAdj = 2;
            }
            d = new Dimension(resAxisAdj + lineThickness, len + numMargins * margin.height + catAxisAdj + titleHeight + depth.height + start + end);
        } else {
            if (catAxisAdj < 2) {
                catAxisAdj = 2;
            }
            d = new Dimension(len + numMargins * margin.width + resAxisAdj + titleWidth + depth.width + start + end, catAxisAdj + lineThickness);
        }
        return d;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean vertAxis;
        super.setBounds(x, y, width, height);
        if (width == 0 || height == 0) {
            return;
        }
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        String orient = cellModel.getAxisOrientation();
        boolean bl = vertAxis = orient == "North" || orient == "South";
        if (vertAxis) {
            Vec3d maxSize = cellModel.getMaximumSize();
            double adjwidth = maxSize == null || maxSize.x < 2.0 ? 2.5 * (double)width : maxSize.x;
            cellModel.computeParameters(this.getChannel(), adjwidth, height);
            if (cellModel.getResAxisAdj().intValue() > width) {
                cellModel.setLength(new Double(0.0));
                cellModel.setResAxisAdj(new Double(0.0));
                cellModel.computeParameters(this.getChannel(), width, height);
            }
        } else {
            cellModel.setLength(new Double(0.0));
            cellModel.setCatAxisAdj(new Double(0.0));
            cellModel.computeParameters(this.getChannel(), width, height);
        }
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    public AxisCellModel getAxisModel() {
        return (AxisCellModel)super.getModel();
    }

    public Util.LabelAndValueZones getLabelAndValueZones() {
        this._computeSelectableShapes();
        return new Util.LabelAndValueZones(this.labelZoneImageMapCache, this.valueZonesImageMapCache);
    }

    private void _computeSelectableShapes() {
        boolean axisTitle;
        AxisCellModel cellModel = (AxisCellModel)this.getModel();
        NetworkRoot root = this.getNetworkRoot();
        this.updateChannel();
        Vector selectableShapes = root.computeSelectableShapes();
        NumericMapper mapper = cellModel.getMapper();
        Hashtable<String, Shape> values = mapper instanceof StringToNumericMapper ? new Hashtable<String, Shape>() : null;
        boolean bl = axisTitle = cellModel.getTitlePlacementType() == 11306;
        if (selectableShapes != null) {
            int count = selectableShapes.size();
            Shape labelMarkerShape = null;
            Shape labelTitleShape = null;
            ArrayList<ValueZone> valueZonesAL = new ArrayList<ValueZone>(count);
            for (int ii = 0; ii < count; ++ii) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.get(ii);
                SelectResult sr = selectableShape.getSelectResult();
                Element element = sr.getElement();
                try {
                    if (element instanceof RectangularAxis) {
                        AxisDetail ad = (AxisDetail)sr.getDetail();
                        if (ad == null) continue;
                        if (ad.getType() == 0) {
                            String value = ((RectangularAxis)element).labels.getValue(ad.getLabelIndex());
                            if (values != null) {
                                values.put(value, selectableShape.getShape());
                            }
                        }
                        if (ad.getType() == 2) {
                            if (!axisTitle) continue;
                            labelTitleShape = selectableShape.getShape();
                            continue;
                        }
                        if (ad.getType() != 4) continue;
                        labelMarkerShape = selectableShape.getShape();
                        continue;
                    }
                    if (!(element instanceof RasterLabel)) continue;
                    labelTitleShape = selectableShape.getShape();
                    continue;
                }
                catch (MissingValueException ad) {
                    // empty catch block
                }
            }
            if (labelTitleShape != null) {
                this.labelZoneImageMapCache = new LabelZoneList(labelTitleShape, cellModel.getTitle(), cellModel.getTitle(), labelMarkerShape == null ? null : new DataZone(labelMarkerShape), null);
            }
            if (values != null) {
                int uvcount = ((StringToNumericMapper)mapper).getUniqueValueCount();
                for (int ii = 0; ii < uvcount; ++ii) {
                    try {
                        String value = ((StringToNumericMapper)mapper).label.getValue(ii);
                        Shape shape = (Shape)values.get(value);
                        ValueList valueList = new ValueList(value, value, null);
                        valueZonesAL.add(new ValueZone(shape, valueList));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
            valueZonesAL.trimToSize();
            this.valueZonesImageMapCache = valueZonesAL.toArray(new ValueZone[0]);
        }
    }

    public static class AxisCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final AxisCellModel cellModel;
        private final Channel channel;

        public AxisCellComponentFactory(AxisCellModel cellModel, Channel channel) {
            this.cellModel = cellModel;
            this.channel = channel;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            if (node instanceof DataTreeGroupNode && this.cellModel != null) {
                return new AxisCell(this.cellModel, this.channel);
            }
            return null;
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            throw new IllegalStateException("Not Supported");
        }
    }
}

