/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell;

import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.util.cell.VariableDefinition;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

public class AnalysisVariableDefinition
extends VariableDefinition {
    private final Integer statistic;

    public AnalysisVariableDefinition(String newColumnName, String newFormat, VariableDefinition newNext, int newVariant) {
        super(newColumnName, newFormat, newNext, newVariant);
        this.statistic = null;
    }

    public AnalysisVariableDefinition(Integer newColumnIndex, String newFormat, VariableDefinition newNext, int newVariant) {
        super(newColumnIndex, newFormat, newNext, newVariant);
        this.statistic = null;
    }

    @Override
    public VariableDefinition asLegendVariableDefinition() {
        VariableDefinition newNext = this.getNext() != null ? this.getNext().asLegendVariableDefinition() : null;
        Integer newSort = new Integer(10401);
        return new AnalysisVariableDefinition(this, newSort, newNext);
    }

    protected AnalysisVariableDefinition(AnalysisVariableDefinition avd, Integer newSort, VariableDefinition next) {
        super(avd, newSort, avd.getVariant(), next);
        this.statistic = avd.getStatistic();
    }

    public AnalysisVariableDefinition(String newColumnName, String newFormat, String newInformat, String newUserLabel, Integer newSort, Integer newStatistic, String newHighColumnName, String newHighLabel, String newLowColumnName, String newLowLabel, String newTargetColumnName, String newTargetLabel, AnalysisVariableDefinition newNext, int newVariant) {
        super(newColumnName, newFormat, newInformat, newUserLabel, newSort, newHighColumnName, newHighLabel, newLowColumnName, newLowLabel, newTargetColumnName, newTargetLabel, (VariableDefinition)newNext, newVariant);
        this.statistic = newStatistic;
    }

    public AnalysisVariableDefinition(Integer newColumnIndex, String newFormat, String newInformat, String newUserLabel, Integer newSort, Integer newStatistic, Integer newHighColumnIndex, String newHighLabel, Integer newLowColumnIndex, String newLowLabel, Integer newTargetColumnIndex, String newTargetLabel, AnalysisVariableDefinition newNext, int newVariant) {
        super(newColumnIndex, newFormat, newInformat, newUserLabel, newSort, newHighColumnIndex, newHighLabel, newLowColumnIndex, newLowLabel, newTargetColumnIndex, newTargetLabel, (VariableDefinition)newNext, newVariant);
        this.statistic = newStatistic;
    }

    public AnalysisVariableDefinition(String newColumnName, String newFormat, String newInformat, String newUserLabel, Integer newSort, Integer newStatistic, CategorizationModel newCategorizationModel, SegmentedRangeStyle newSegmentedRangeStyle, String newHighColumnName, String newHighLabel, String newLowColumnName, String newLowLabel, String newTargetColumnName, String newTargetLabel, AnalysisVariableDefinition newNext, int newVariant) {
        super(newColumnName, newFormat, newInformat, newUserLabel, newSort, newCategorizationModel, newSegmentedRangeStyle, newHighColumnName, newHighLabel, newLowColumnName, newLowLabel, newTargetColumnName, newTargetLabel, (VariableDefinition)newNext, newVariant);
        this.statistic = newStatistic;
    }

    public AnalysisVariableDefinition(Integer newColumnIndex, String newFormat, String newInformat, String newUserLabel, Integer newSort, Integer newStatistic, CategorizationModel newCategorizationModel, SegmentedRangeStyle newSegmentedRangeStyle, Integer newHighColumnIndex, String newHighLabel, Integer newLowColumnIndex, String newLowLabel, Integer newTargetColumnIndex, String newTargetLabel, AnalysisVariableDefinition newNext, int newVariant) {
        super(newColumnIndex, newFormat, newInformat, newUserLabel, newSort, newCategorizationModel, newSegmentedRangeStyle, newHighColumnIndex, newHighLabel, newLowColumnIndex, newLowLabel, newTargetColumnIndex, newTargetLabel, (VariableDefinition)newNext, newVariant);
        this.statistic = newStatistic;
    }

    @Override
    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="this is legacy code and require major restructuring for this violation")
    public Object clone() {
        if (this.getColumnIndex() != null) {
            return new AnalysisVariableDefinition(this.getColumnIndex(), this.getFormat(), this.getInformat(), this.getColumnLabel(), this.getSort(), this.statistic, this.getHighColumnIndex(), this.getHighLabel(), this.getLowColumnIndex(), this.getLowLabel(), this.getTargetColumnIndex(), this.getTargetLabel(), this.getNext() == null ? null : (AnalysisVariableDefinition)this.getNext().clone(), this.getVariant());
        }
        return new AnalysisVariableDefinition(this.getColumnName(), this.getFormat(), this.getInformat(), this.getColumnLabel(), this.getSort(), this.statistic, this.getHighColumnName(), this.getHighLabel(), this.getLowColumnName(), this.getLowLabel(), this.getTargetColumnName(), this.getTargetLabel(), this.getNext() == null ? null : (AnalysisVariableDefinition)this.getNext().clone(), this.getVariant());
    }

    public Integer getStatistic() {
        return this.statistic;
    }

    public int asGTKStatistic() {
        return AnalysisVariableDefinition.asGTKStatistic(this.statistic);
    }

    public static int asGTKStatistic(Integer statistic) {
        int validStatistic = 6;
        if (statistic != null) {
            switch (statistic) {
                default: {
                    validStatistic = 6;
                    break;
                }
                case 10500: {
                    validStatistic = 0;
                    break;
                }
                case 10501: {
                    validStatistic = 1;
                    break;
                }
                case 10502: {
                    validStatistic = 2;
                    break;
                }
                case 10503: {
                    validStatistic = 3;
                    break;
                }
                case 10504: {
                    validStatistic = 4;
                    break;
                }
                case 10505: {
                    validStatistic = 5;
                    break;
                }
                case 10507: {
                    validStatistic = 7;
                    break;
                }
                case 10508: {
                    validStatistic = 8;
                    break;
                }
                case 10509: {
                    validStatistic = 9;
                    break;
                }
                case 10510: {
                    validStatistic = 10;
                    break;
                }
                case 10511: {
                    validStatistic = 11;
                    break;
                }
                case 10512: {
                    validStatistic = 12;
                }
            }
        }
        return validStatistic;
    }

    public boolean isCompatableStatistic(Integer statistic) {
        return this.isSumStatistic() && AnalysisVariableDefinition.isSumStatistic(statistic) || this.isFrequencyStatistic() && AnalysisVariableDefinition.isFrequencyStatistic(statistic) || this.isPercentSumStatistic() && AnalysisVariableDefinition.isPercentSumStatistic(statistic) || this.isPercentFrequencyStatistic() && AnalysisVariableDefinition.isPercentFrequencyStatistic(statistic);
    }

    public boolean isSumStatistic() {
        return AnalysisVariableDefinition.isSumStatistic(this.statistic);
    }

    public boolean isFrequencyStatistic() {
        return AnalysisVariableDefinition.isFrequencyStatistic(this.statistic);
    }

    public boolean isPercentSumStatistic() {
        return AnalysisVariableDefinition.isPercentSumStatistic(this.statistic);
    }

    public boolean isPercentFrequencyStatistic() {
        return AnalysisVariableDefinition.isPercentFrequencyStatistic(this.statistic);
    }

    public static boolean isSumStatistic(Integer statistic) {
        if (statistic != null) {
            switch (statistic) {
                case 10500: 
                case 10501: 
                case 10506: 
                case 10508: 
                case 10510: 
                case 10511: 
                case 10512: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isFrequencyStatistic(Integer statistic) {
        if (statistic != null) {
            switch (statistic) {
                case 10502: 
                case 10503: 
                case 10504: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPercentSumStatistic(Integer statistic) {
        if (statistic != null) {
            switch (statistic) {
                case 10507: 
                case 10509: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPercentFrequencyStatistic(Integer statistic) {
        if (statistic != null) {
            switch (statistic) {
                case 10503: 
                case 10505: {
                    return true;
                }
            }
        }
        return false;
    }
}

