/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.waterfallchart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.components.waterfallchart.WaterfallChartDataModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class WaterfallChartTableDataModel
extends WaterfallChartDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private boolean statisticEnabled = true;
    private ClassificationVariable columnVariable;
    private ClassificationVariable rowVariable;
    private ClassificationVariable categoryVariable;
    private AnalysisVariable responseVariable;
    private Variable categorySortVariable;
    private Variable styleByVariable;
    private Variable outsideBarLabelVariable;
    private Variable[] auxiliaryVariables = null;
    private Variable[] dataTipVariables = null;

    public void apply(WaterfallChartTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(WaterfallChartTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.statisticEnabled = theOtherModel.statisticEnabled;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.categoryVariable = theOtherModel.categoryVariable;
        this.categorySortVariable = theOtherModel.categorySortVariable;
        this.styleByVariable = theOtherModel.styleByVariable;
        this.responseVariable = theOtherModel.responseVariable;
        this.outsideBarLabelVariable = theOtherModel.outsideBarLabelVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public WaterfallChartTableDataModel() {
    }

    public WaterfallChartTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setStatisticEnabled(boolean newStatisticEnabled) {
        boolean oldValue = this.statisticEnabled;
        this.statisticEnabled = newStatisticEnabled;
        this.firePropertyChange("statisticEnabled", oldValue, newStatisticEnabled);
    }

    public boolean isStatisticEnabled() {
        return this.statisticEnabled;
    }

    public void setColumnVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.columnVariable;
        this.columnVariable = newVariable;
        this.firePropertyChange("columnVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setRowVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.rowVariable;
        this.rowVariable = newVariable;
        this.firePropertyChange("rowVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setCategoryVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.categoryVariable;
        this.categoryVariable = newVariable;
        this.firePropertyChange("categoryVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getCategoryVariable() {
        return this.categoryVariable;
    }

    public void setCategorySortVariable(Variable newVariable) {
        Variable oldVariable = this.categorySortVariable;
        this.categorySortVariable = newVariable;
        this.firePropertyChange("categorySortVariable", oldVariable, newVariable);
    }

    public Variable getCategorySortVariable() {
        return this.categorySortVariable;
    }

    public void setStyleByVariable(Variable newVariable) {
        Variable oldVariable = this.styleByVariable;
        this.styleByVariable = newVariable;
        this.firePropertyChange("styleByVariable", oldVariable, newVariable);
    }

    public Variable getStyleByVariable() {
        return this.styleByVariable;
    }

    public void setResponseVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.responseVariable;
        this.responseVariable = newVariable;
        this.firePropertyChange("responseVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getResponseVariable() {
        return this.responseVariable;
    }

    public void setOutsideBarLabelVariable(Variable newVariable) {
        Variable oldVariable = this.outsideBarLabelVariable;
        this.outsideBarLabelVariable = newVariable;
        this.firePropertyChange("outsideBarLabelVariable", oldVariable, newVariable);
    }

    public Variable getOutsideBarLabelVariable() {
        return this.outsideBarLabelVariable;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        WaterfallChartTableDataModel arg = (WaterfallChartTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.statisticEnabled, arg.statisticEnabled) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.categoryVariable, arg.categoryVariable) && Util.Evaluate.isEqual(this.categorySortVariable, arg.categorySortVariable) && Util.Evaluate.isEqual(this.styleByVariable, arg.styleByVariable) && Util.Evaluate.isEqual(this.responseVariable, arg.responseVariable) && Util.Evaluate.isEqual(this.outsideBarLabelVariable, arg.outsideBarLabelVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

