/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.tilechart;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AnalysisVariableList;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ClassificationVariableList;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.tilechart.TileChartDataModel;
import com.sas.graphics.components.util.Util;
import java.util.HashMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class TileChartTableDataModel
extends TileChartDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private ClassificationVariable tileVariable;
    private AnalysisVariable sizeVariable;
    private AnalysisVariable colorVariable;
    private AnalysisVariable xVariable;
    private AnalysisVariable yVariable;
    private Variable webLinkVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;
    private HashMap variableLabelsMap = new HashMap();

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void apply(TileChartTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(TileChartTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.tileVariable = theOtherModel.tileVariable;
        this.sizeVariable = theOtherModel.sizeVariable;
        this.colorVariable = theOtherModel.colorVariable;
        this.xVariable = theOtherModel.xVariable;
        this.yVariable = theOtherModel.yVariable;
        this.webLinkVariable = theOtherModel.webLinkVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public TileChartTableDataModel() {
    }

    public TileChartTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.getModel();
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setTileVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.getTileVariable();
        this.tileVariable = newVariable;
        newVariable = this.getTileVariable();
        this.firePropertyChange("tileVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getTileVariable() {
        return this.tileVariable;
    }

    public void setIdVariable(ClassificationVariable newVariable) {
        this.setTileVariable(newVariable);
    }

    public ClassificationVariable getIdVariable() {
        return this.getTileVariable();
    }

    public void setVariableLabel(String variableName, String label) {
        this.variableLabelsMap.put(variableName, label);
    }

    public String getVariableLabel(String variableName) {
        return (String)this.variableLabelsMap.get(variableName);
    }

    public void setSizeVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.getSizeVariable();
        this.sizeVariable = newVariable;
        newVariable = this.getSizeVariable();
        this.firePropertyChange("sizeVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getSizeVariable() {
        return this.sizeVariable;
    }

    public void setColorVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.getColorVariable();
        this.colorVariable = newVariable;
        newVariable = this.getColorVariable();
        this.firePropertyChange("colorVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getColorVariable() {
        return this.colorVariable;
    }

    public void setXVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.getXVariable();
        this.xVariable = newVariable;
        newVariable = this.getXVariable();
        this.firePropertyChange("xVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getXVariable() {
        return this.xVariable;
    }

    public void setYVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.getYVariable();
        this.yVariable = newVariable;
        newVariable = this.getYVariable();
        this.firePropertyChange("yVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getYVariable() {
        return this.yVariable;
    }

    public void setAuxVariable(Variable newVariable) {
        if (newVariable != null) {
            if (newVariable instanceof ClassificationVariableList) {
                this.setDataTipVariable(((ClassificationVariableList)newVariable).asArray());
            } else if (newVariable instanceof AnalysisVariableList) {
                this.setDataTipVariable(((AnalysisVariableList)newVariable).asArray());
            } else if (newVariable instanceof VariableList) {
                this.setDataTipVariable(((VariableList)newVariable).asArray());
            }
        } else {
            this.setDataTipVariable(null);
        }
    }

    public Variable getAuxVariable() {
        return new VariableList(this.getDataTipVariable());
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setWebLinkVariable(Variable newVariable) {
        Variable oldVariable = this.getWebLinkVariable();
        this.webLinkVariable = newVariable;
        newVariable = this.getWebLinkVariable();
        this.firePropertyChange("webLinkVariable", oldVariable, newVariable);
    }

    public Variable getWebLinkVariable() {
        return this.webLinkVariable;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TileChartTableDataModel arg = (TileChartTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.tileVariable, arg.tileVariable) && Util.Evaluate.isEqual(this.sizeVariable, arg.sizeVariable) && Util.Evaluate.isEqual(this.colorVariable, arg.colorVariable) && Util.Evaluate.isEqual(this.xVariable, arg.xVariable) && Util.Evaluate.isEqual(this.yVariable, arg.yVariable) && Util.Evaluate.isEqual(this.webLinkVariable, arg.webLinkVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

