/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.tilechart;

import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.tilechart.RB;
import com.sas.graphics.components.tilechart.TileChartHighlightModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import com.sas.measures.BaseLength;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;

public class TileChartModel
extends GraphModel {
    public static final String RB_KEY = "TileChartModel.";
    private LegendModel colorLegendModel = new LegendModel();
    private int colorPaletteType = 11803;
    private int detailLevel = 0;
    private boolean colorByVisibleTiles = false;
    private String otherLabel = RB.getStringResource("TileChartModel.", "otherLabel.txt");
    private double otherThreshold = 0.0;
    private Color missingColor = Color.lightGray;
    private double minimumColorValue = Double.NaN;
    private double maximumColorValue = Double.NaN;
    private boolean discreteColorVariable;
    private boolean numericColorVariable;
    private boolean discreteCategorization;
    private String[] webLinks;
    private String[] webLabels;
    private ArrayList levLabels = new ArrayList();
    private ArrayList highlightList = new ArrayList();
    private TextStyle statusLineTextStyle = new TextStyle();
    private TileChartHighlightModel dataTipHighlightModel = new TileChartHighlightModel();
    private int layoutType = 0;
    public static final int LAYOUT_STANDARD = 0;
    public static final int LAYOUT_TOGGLE = 1;
    public static final int LAYOUT_GEOGRAPHIC = 2;
    public static final int LAYOUT_FLOW = 3;
    public static final ConstantCollection LAYOUT = new ConstantCollection(RB.class, "TileChartModel.", new ConstantCollection.Element[]{new ConstantCollection.Element(0, "LAYOUT_STANDARD", "Standard"), new ConstantCollection.Element(1, "LAYOUT_TOGGLE", "Toggle"), new ConstantCollection.Element(2, "LAYOUT_GEOGRAPHIC", "Geographic"), new ConstantCollection.Element(3, "LAYOUT_FLOW", "Flow")});
    private HashMap tileLabelContentMap = new HashMap();
    private HashMap tileLabelStyleMap = new HashMap();
    private HashMap tileEdgeStyleMap = new HashMap();

    public void apply(TileChartModel theOtherObject) {
        if (theOtherObject != null) {
            this.disablePropertyChange();
            super.apply(theOtherObject);
            this.layoutType = theOtherObject.layoutType;
            this.colorLegendModel.apply(theOtherObject.colorLegendModel);
            this.dataTipHighlightModel.apply(theOtherObject.dataTipHighlightModel);
            this.colorPaletteType = theOtherObject.colorPaletteType;
            this.otherThreshold = theOtherObject.otherThreshold;
            this.tileEdgeStyleMap = theOtherObject.tileEdgeStyleMap;
            this.tileLabelStyleMap = theOtherObject.tileLabelStyleMap;
            this.tileLabelContentMap = theOtherObject.tileLabelContentMap;
            this.highlightList = theOtherObject.highlightList;
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    public TileChartModel() {
        this.setContainedModel("LegendModel", this.colorLegendModel);
        this.setContainedModel("DataTipHighlightModel", this.dataTipHighlightModel);
        this.setDefaultTileLabels();
        this.setDefaultEdges();
    }

    public void setDefaultTileLabels() {
        Font font = FontManager.getFont((String)com.sas.graphics.components.RB.getStringResource("fontHelvetica.lcl"), (int)1, (int)16);
        AdvancedTextStyle ats = new AdvancedTextStyle(font, Color.black, 2, true, 0.0);
        ShadowStyle ss = new ShadowStyle(Color.black, new BaseLength("2 px"), new BaseLength("2 px"), 0.0);
        ss.setVisible(true);
        this.setTileLabelStyle(ats, 1);
    }

    public void setDefaultEdges() {
        this.putOutlineLineStyle(new LineStyle(Color.gray), -1);
        this.putOutlineLineStyle(new LineStyle(Color.black, new BaseLength("3 px"), 10201), 1);
        BaseLength bl = new BaseLength("1 px");
        this.putOutlineLineStyle(new LineStyle(Color.black, bl, 10201), 2);
        this.putOutlineLineStyle(new LineStyle(Color.gray, bl, 10201), 3);
        this.putOutlineLineStyle(new LineStyle(Color.lightGray, bl, 10201), 4);
    }

    public void setLegendModel(LegendModel newModel) throws IllegalArgumentException {
        if (newModel == null) {
            throw new IllegalArgumentException();
        }
        LegendModel oldValue = this.colorLegendModel;
        this.colorLegendModel = newModel;
        this.firePropertyChange("legendModel", oldValue, newModel);
    }

    public LegendModel getLegendModel() {
        return this.colorLegendModel;
    }

    public void setColorPaletteType(int newColorPaletteType) throws IllegalArgumentException {
        GraphConstants.COLOR_PALETTE.validate(newColorPaletteType);
        int oldValue = this.colorPaletteType;
        this.colorPaletteType = newColorPaletteType;
        this.firePropertyChange("colorPaletteType", oldValue, this.colorPaletteType);
    }

    public int getColorPaletteType() {
        return this.colorPaletteType;
    }

    public void setDetailLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException();
        }
        int oldLevel = this.getDetailLevel();
        this.detailLevel = level;
        this.firePropertyChange("detailLevel", oldLevel, level);
    }

    public int getDetailLevel() {
        return this.detailLevel;
    }

    public void setTileLabelStyle(AdvancedTextStyle style, int level) {
        this.tileLabelStyleMap.put(new Integer(level), style);
        this.setContainedModel("TileLabelStyle" + level, style);
        this.firePropertyChange("tileLabelStyle", null, style);
    }

    public AdvancedTextStyle getTileLabelStyle(int level) {
        AdvancedTextStyle style = (AdvancedTextStyle)this.tileLabelStyleMap.get(new Integer(level));
        return style == null ? null : style;
    }

    public void setDataLabelLevel(int level) {
        int oldLevel = (Integer)this.tileLabelStyleMap.keySet().iterator().next();
        AdvancedTextStyle ats = (AdvancedTextStyle)this.tileLabelStyleMap.values().iterator().next();
        this.tileLabelStyleMap.clear();
        this.setTileLabelStyle(ats, level);
        this.firePropertyChange("dataLabelLevel", oldLevel, level);
    }

    public int getDataLabelLevel() {
        return (Integer)this.tileLabelStyleMap.keySet().iterator().next();
    }

    public void setDataLabelTextStyle(AdvancedTextStyle style) {
        AdvancedTextStyle oldStyle = (AdvancedTextStyle)this.tileLabelStyleMap.values().iterator().next();
        int curLevel = (Integer)this.tileLabelStyleMap.keySet().iterator().next();
        this.tileLabelStyleMap.clear();
        this.setTileLabelStyle(style, curLevel);
        this.firePropertyChange("dataLabelTextStyle", oldStyle, style);
    }

    public AdvancedTextStyle getDataLabelTextStyle() {
        return (AdvancedTextStyle)this.tileLabelStyleMap.values().iterator().next();
    }

    public void putOutlineLineStyle(LineStyle style, int level) {
        LineStyle newStyle = new LineStyle();
        newStyle.apply(style);
        this.tileEdgeStyleMap.put(new Integer(level), newStyle);
        this.firePropertyChange("outlineLineStyle" + level, null, newStyle);
    }

    public LineStyle getOutlineLineStyle(int level) {
        LineStyle style = null;
        while (style == null && level >= -1) {
            style = (LineStyle)this.tileEdgeStyleMap.get(new Integer(level--));
        }
        return style == null ? new LineStyle() : style;
    }

    public void setColorVariableNumeric(boolean isNumeric) {
        this.numericColorVariable = isNumeric;
    }

    public boolean isColorVariableNumeric() {
        return this.numericColorVariable;
    }

    public void setStatusLineTextStyle(TextStyle newStyle) {
        TextStyle oldStyle = this.statusLineTextStyle;
        this.statusLineTextStyle = newStyle;
        this.firePropertyChange("statusLineTextStyle", oldStyle, newStyle);
    }

    public TextStyle getStatusLineTextStyle() {
        return this.statusLineTextStyle;
    }

    public void setLayoutType(int newPlacement) {
        switch (newPlacement) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
        }
        int oldPlacement = this.layoutType;
        this.layoutType = newPlacement;
        this.firePropertyChange("layoutType", oldPlacement, newPlacement);
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    public void addHighlightModel(TileChartHighlightModel mod) {
        this.highlightList.add(mod);
        int index = this.highlightList.indexOf(mod);
        this.setContainedModel("HighlightModel" + index, mod);
        this.firePropertyChange("highlightModel", null, this.highlightList);
    }

    public void removeHighlightModel(TileChartHighlightModel mod) {
        int index = this.highlightList.indexOf(mod);
        this.highlightList.remove(mod);
        this.setContainedModel("HighlightModel" + index, null);
        this.firePropertyChange("highlightModel", null, this.highlightList);
    }

    public void removeHighlightModel(String name) {
        TileChartHighlightModel curMod2 = null;
        for (TileChartHighlightModel curMod2 : this.highlightList) {
            if (!curMod2.getName().equals(name)) continue;
            this.removeHighlightModel(curMod2);
            break;
        }
    }

    public void resetHighlightModel() {
        for (int ii = 0; ii < this.highlightList.size(); ++ii) {
            this.setContainedModel("HighlightModel" + ii, null);
        }
        this.highlightList.clear();
        this.firePropertyChange("highlightModel", null, this.highlightList);
    }

    public TileChartHighlightModel[] getHighlightModelList() {
        return this.highlightList.toArray(new TileChartHighlightModel[0]);
    }

    public TileChartHighlightModel getDataTipHighlightModel() {
        return this.dataTipHighlightModel;
    }

    public void setDataTipHighlightModel(TileChartHighlightModel dataTipHighlightModel) {
        this.dataTipHighlightModel = dataTipHighlightModel;
        this.firePropertyChange("dataTipHighlightModel", null, dataTipHighlightModel);
    }

    public void setColorByVisibleTiles(boolean lcr) {
        boolean oldLcr = this.colorByVisibleTiles;
        this.colorByVisibleTiles = lcr;
        this.firePropertyChange("colorByVisibleTiles", oldLcr, lcr);
    }

    public boolean isColorByVisibleTiles() {
        return this.colorByVisibleTiles;
    }

    public void setOtherLabel(String newOtherLabel) {
        String oldOL = this.otherLabel;
        this.otherLabel = newOtherLabel;
        this.firePropertyChange("otherLabel", oldOL, newOtherLabel);
    }

    public String getOtherLabel() {
        return this.otherLabel;
    }

    public void setOtherThreshold(double newOtherThreshold) throws IllegalArgumentException {
        if (this.otherThreshold < 0.0 || this.otherThreshold > 100.0) {
            throw new IllegalArgumentException();
        }
        double oldOT = this.otherThreshold;
        this.otherThreshold = newOtherThreshold;
        this.firePropertyChange("otherThreshold", oldOT, newOtherThreshold);
    }

    public double getOtherThreshold() {
        return this.otherThreshold;
    }

    public void setWebLinks(String[] webLinks) {
        this.webLinks = webLinks;
    }

    public String[] getWebLinks() {
        return this.webLinks;
    }

    public void setWebLabels(String[] webLabels) {
        this.webLabels = webLabels;
    }

    public void setLevLabels(ArrayList levLabels) {
        this.levLabels = levLabels;
    }

    public ArrayList getLevLabels() {
        return this.levLabels;
    }

    public String[] getWebLabels() {
        return this.webLabels;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TileChartModel arg = (TileChartModel)obj;
        return Util.Evaluate.isEqual(this.otherThreshold, arg.otherThreshold) && Util.Evaluate.isEqual(this.colorPaletteType, arg.colorPaletteType) && Util.Evaluate.isEqual(this.colorByVisibleTiles, arg.colorByVisibleTiles) && Util.Evaluate.isEqual(this.detailLevel, arg.detailLevel) && Util.Evaluate.isEqual(this.layoutType, arg.layoutType) && Util.Evaluate.isEqual(this.colorLegendModel, arg.colorLegendModel) && Util.Evaluate.isEqual(this.dataTipHighlightModel, arg.dataTipHighlightModel) && Util.Evaluate.isEqual(this.highlightList, arg.highlightList) && Util.Evaluate.isEqual(this.missingColor, arg.missingColor) && Util.Evaluate.isEqual(this.otherLabel, arg.otherLabel) && Util.Evaluate.isEqual(this.statusLineTextStyle, arg.statusLineTextStyle) && Util.Evaluate.isEqual(this.tileEdgeStyleMap, arg.tileEdgeStyleMap) && Util.Evaluate.isEqual(this.tileLabelContentMap, arg.tileLabelContentMap) && Util.Evaluate.isEqual(this.tileLabelStyleMap, arg.tileLabelStyleMap) && Util.Evaluate.isEqual(this.webLabels, arg.webLabels) && Util.Evaluate.isEqual(this.webLinks, arg.webLinks) && Util.Evaluate.isEqual(this.levLabels, arg.levLabels) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void setMinimumColorValue(double minColorVal) {
        this.minimumColorValue = minColorVal;
    }

    public double getMinimumColorValue() {
        return this.minimumColorValue;
    }

    public void setMaximumColorValue(double maxColorVal) {
        this.maximumColorValue = maxColorVal;
    }

    public double getMaximumColorValue() {
        return this.maximumColorValue;
    }

    public void setDiscreteColorVariable(boolean b) {
        this.discreteColorVariable = b;
    }

    public boolean isDiscreteColorVariable() {
        return this.discreteColorVariable;
    }

    public void setDiscreteCategorization(boolean b) {
        this.discreteCategorization = b;
    }

    public boolean isDiscreteCategorization() {
        return this.discreteCategorization;
    }
}

