/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.tilechart;

import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import javax.swing.ImageIcon;

public class TileChartHighlightModel
extends ModelBase {
    private String name = "";
    private int type = 2;
    private int style = 30;
    private double value = 0.0;
    private int condition = 10;
    private int response = 20;
    private String findStr = "";
    private boolean exactMatch = true;
    private boolean ignoreCase = true;
    private LineStyle outline = new LineStyle();
    private LineStyle secondaryOutline = null;
    private FillStyle background = new FillStyle();
    private TextStyle textStyle = new TextStyle();
    private MarkerStyle markerStyle = new MarkerStyle();
    private int markerPosition = 0;
    private ImageIcon image = null;
    public static final int HIGHLIGHT_OFF = 0;
    public static final int HIGHLIGHT_NUMERIC = 1;
    public static final int HIGHLIGHT_STRING = 2;
    public static final int CONDITION_HIGHEST = 10;
    public static final int CONDITION_LOWEST = 11;
    public static final int CONDITION_EQUALS = 12;
    public static final int CONDITION_GREATER_THAN = 13;
    public static final int CONDITION_LESS_THAN = 14;
    public static final int CONDITION_GREATER_THAN_OR_EQUAL = 15;
    public static final int CONDITION_LESS_THAN_OR_EQUAL = 16;
    public static final int RESPONSE_COLOR = 20;
    public static final int RESPONSE_SIZE = 21;
    public static final int RESPONSE_NONE = 22;
    public static final int STYLE_LOW_DETAIL_BOX = 30;
    public static final int STYLE_HIGH_DETAIL_BOX = 31;
    public static final int STYLE_INSIDE_LABEL = 32;
    public static final int STYLE_MARKER = 33;
    public static final int STYLE_OUTLINE = 34;
    public static final int STYLE_NONE = 35;
    public static final int STYLE_MEDIUM_DETAIL_BOX = 36;
    public static final int STYLE_CUSTOM_DETAIL_BOX = 37;
    public static final int STYLE_IMAGE = 38;

    public TileChartHighlightModel() {
        this.setContainedModel("MarkerStyle", this.markerStyle);
        this.name = "";
        this.type = 0;
    }

    public TileChartHighlightModel(String highlightName, String find) {
        this.setContainedModel("MarkerStyle", this.markerStyle);
        this.name = highlightName;
        this.type = 2;
        this.findStr = find;
        this.ignoreCase = true;
        this.exactMatch = true;
    }

    public TileChartHighlightModel(String highlightName, String find, boolean exact, boolean ignore) {
        this.setContainedModel("MarkerStyle", this.markerStyle);
        this.name = highlightName;
        this.type = 2;
        this.findStr = find;
        this.ignoreCase = ignore;
        this.exactMatch = exact;
    }

    public TileChartHighlightModel(String highlightName, int i, int tb, int cs) {
        this.setContainedModel("MarkerStyle", this.markerStyle);
        this.name = highlightName;
        this.type = 1;
        this.value = i;
        switch (tb) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
        }
        this.condition = tb;
        switch (cs) {
            default: {
                throw new IllegalArgumentException();
            }
            case 20: 
            case 21: 
        }
        this.response = cs;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int newStyle) {
        switch (newStyle) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
        }
        int oldStyle = this.style;
        this.style = newStyle;
        this.firePropertyChange("style", oldStyle, this.style);
    }

    public String getMatch() {
        return this.findStr;
    }

    public double getValue() {
        return this.value;
    }

    public int getCondition() {
        return this.condition;
    }

    public int getResponse() {
        return this.response;
    }

    public int getType() {
        return this.type;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public void setExactMatch(boolean newExactMatch) {
        boolean oldExactMatch = this.exactMatch;
        this.exactMatch = newExactMatch;
        this.firePropertyChange("exactMatch", oldExactMatch, this.exactMatch);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean newIgnoreCase) {
        boolean oldIgnoreCase = this.ignoreCase;
        this.ignoreCase = newIgnoreCase;
        this.firePropertyChange("ignoreCase", oldIgnoreCase, this.ignoreCase);
    }

    public String getFindStr() {
        return this.findStr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange("name", oldName, this.name);
    }

    public FillStyle getBackground() {
        return this.background;
    }

    public void setBackground(FillStyle newBackground) throws IllegalArgumentException {
        if (newBackground == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldValue = this.background;
        this.background = newBackground;
        this.firePropertyChange("background", oldValue, newBackground);
    }

    public MarkerStyle getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(MarkerStyle newMarkerStyle) {
        if (newMarkerStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        MarkerStyle oldValue = this.markerStyle;
        this.markerStyle = newMarkerStyle;
        this.firePropertyChange("markerStyle", oldValue, newMarkerStyle);
    }

    public LineStyle getOutline() {
        return this.outline;
    }

    public void setOutline(LineStyle newOutline) {
        if (newOutline == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        LineStyle oldValue = this.outline;
        this.outline = newOutline;
        this.firePropertyChange("outline", oldValue, newOutline);
    }

    public LineStyle getSecondaryOutline() {
        return this.secondaryOutline;
    }

    public void setSecondaryOutline(LineStyle newSecondaryOutline) {
        LineStyle oldValue = this.secondaryOutline;
        this.secondaryOutline = newSecondaryOutline;
        this.firePropertyChange("secondaryOutline", oldValue, newSecondaryOutline);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle newTextStyle) {
        if (newTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.textStyle;
        this.textStyle = newTextStyle;
        this.firePropertyChange("textStyle", oldValue, newTextStyle);
    }

    public void setFindStr(String newFindStr) {
        if (newFindStr == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        String oldFindStr = this.findStr;
        this.findStr = newFindStr;
        this.firePropertyChange("findStr", oldFindStr, this.findStr);
    }

    public void setValue(double newValue) {
        double oldValue = this.value;
        this.value = newValue;
        this.firePropertyChange("value", oldValue, this.value);
    }

    public void setValue(int newValue) {
        this.setValue((double)newValue);
    }

    public void setCondition(int newCondition) {
        switch (newCondition) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
        }
        int oldCondition = this.condition;
        this.condition = newCondition;
        this.firePropertyChange("condition", oldCondition, this.condition);
    }

    public void setResponse(int newResponse) {
        switch (newResponse) {
            default: {
                throw new IllegalArgumentException();
            }
            case 20: 
            case 21: 
            case 22: 
        }
        int oldResponse = this.response;
        this.response = newResponse;
        this.firePropertyChange("response", oldResponse, this.response);
    }

    public void setType(int newType) {
        switch (newType) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 2: 
        }
        int oldType = this.type;
        this.type = newType;
        this.firePropertyChange("type", oldType, this.type);
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public void setImage(ImageIcon newImage) {
        if (newImage == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ImageIcon oldImage = this.image;
        this.image = newImage;
        this.firePropertyChange("image", oldImage, newImage);
    }

    public int getMarkerPosition() {
        return this.markerPosition;
    }

    public void setMarkerPosition(int newMarkerPosition) {
        switch (newMarkerPosition) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
        }
        int oldMarkerPosition = this.markerPosition;
        this.markerPosition = newMarkerPosition;
        this.firePropertyChange("markerPosition", oldMarkerPosition, this.markerPosition);
    }

    public void apply(TileChartHighlightModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.name = theOtherObject.name;
        this.type = theOtherObject.type;
        this.style = theOtherObject.style;
        this.value = theOtherObject.value;
        this.condition = theOtherObject.condition;
        this.response = theOtherObject.response;
        this.findStr = theOtherObject.findStr;
        this.exactMatch = theOtherObject.exactMatch;
        this.ignoreCase = theOtherObject.ignoreCase;
        this.outline.apply(theOtherObject.outline);
        if (this.secondaryOutline != null) {
            this.secondaryOutline.apply(theOtherObject.secondaryOutline);
        }
        this.background.apply(theOtherObject.background);
        this.textStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.textStyle, this.textStyle);
        this.markerStyle.apply(theOtherObject.markerStyle);
        this.markerPosition = theOtherObject.markerPosition;
        this.image = theOtherObject.image;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TileChartHighlightModel)) {
            return false;
        }
        TileChartHighlightModel arg = (TileChartHighlightModel)obj;
        return Util.Evaluate.isEqual(this.condition, arg.condition) && Util.Evaluate.isEqual(this.exactMatch, arg.exactMatch) && Util.Evaluate.isEqual(this.ignoreCase, arg.ignoreCase) && Util.Evaluate.isEqual(this.findStr, arg.findStr) && Util.Evaluate.isEqual(this.markerPosition, arg.markerPosition) && Util.Evaluate.isEqual(this.name, arg.name) && Util.Evaluate.isEqual(this.response, arg.response) && Util.Evaluate.isEqual(this.style, arg.style) && Util.Evaluate.isEqual(this.type, arg.type) && Util.Evaluate.isEqual(this.value, arg.value) && Util.Evaluate.isEqual(this.image, arg.image) && Util.Evaluate.isEqual(this.markerStyle, arg.markerStyle) && Util.Evaluate.isEqual(this.outline, arg.outline) && Util.Evaluate.isEqual(this.secondaryOutline, arg.secondaryOutline) && Util.Evaluate.isEqual(this.textStyle, arg.textStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

