/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.tilechart;

import com.sas.MissingValues;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.tilechart.TileChartDataModel;
import com.sas.graphics.components.tilechart.TileChartHighlightModel;
import com.sas.graphics.components.tilechart.TileChartModel;
import com.sas.graphics.components.tilechart.TileChartOLAPDataModel;
import com.sas.graphics.components.tilechart.TileChartTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.VariableFactory;
import com.sas.graphics.util.cell.tilechart.TileChartMatrix;
import com.sas.graphics.util.cell.tilechart.TileChartMatrixModel;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import com.sas.measures.BaseLength;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class TileChart
extends Graph {
    private transient TileChartModel tileChartModel;
    private transient TileChartDataModel dataModel;
    private final transient TileChartMatrix matrix;
    private final transient TileChartMatrixModel matrixModel;
    static DefaultMutableTreeNode treeRoot = null;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    private com.sas.graphics.util.gtk.Variable[] prevIdVar = null;
    private int lastx;
    private int lasty;
    private static final String TILE = "tileVariable";
    private static final String ID_HIER = "idHierVariable";
    private static final String SIZE = "sizeVariable";
    private static final String COLOR = "colorVariable";
    private static final String X = "xVariable";
    private static final String Y = "yVariable";
    private static final String WEB_LINK = "webLinkVariable";
    private static final String SIZE_SELECTION = "sizeSelectionVariable";
    private static final String COLOR_SELECTION = "colorSelectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public TileChart() {
        this(null, null);
    }

    public TileChart(TileChartDataModel tileChartDataModel) {
        this(tileChartDataModel, null);
    }

    public TileChart(TileChartDataModel tileChartDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new TileChartMatrixModel();
        this.matrixModel.setTileRole(TILE);
        this.matrixModel.setIdHierRole(ID_HIER);
        this.matrixModel.setSizeRole(SIZE);
        this.matrixModel.setColorRole(COLOR);
        this.matrixModel.setXRole(X);
        this.matrixModel.setYRole(Y);
        this.matrixModel.setWebLinkRole(WEB_LINK);
        this.matrixModel.setSizeSelectionRole(SIZE_SELECTION);
        this.matrixModel.setColorSelectionRole(COLOR_SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new TileChartMatrix(this.getChannel());
        this.matrix.setModel(this.matrixModel);
        this.setGraphModel(new TileChartModel());
        this.applyGraphStyle(defaultGraphStyle == null ? this.getDefaultGraphStyle() : defaultGraphStyle);
        this.dataModelMomento.apply(this.tileChartModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
                dataSource.setVariableDefinition(TILE, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Id")));
                dataSource.setVariableDefinition(SIZE, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Size")));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException dataSource) {
                // empty catch block
            }
        }
        if (tileChartDataModel != null) {
            this.setDataModel(tileChartDataModel);
        }
        this.setGraph(this.matrix);
        this.addMouseListener(new MouseListener(){

            private boolean evaluatePopupMenu(MouseEvent e) {
                int y;
                int x;
                JPopupMenu popupMenu;
                if (e != null && e.isPopupTrigger() && (popupMenu = TileChart.this.newPopupMenu(x = e.getX(), y = e.getY())) != null) {
                    popupMenu.show(TileChart.this, x, y);
                    return true;
                }
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TileChart.this.requestFocusInWindow();
                TileChart.this.lastx = e.getX();
                TileChart.this.lasty = e.getY();
                this.evaluatePopupMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.evaluatePopupMenu(e) && e.getButton() == 1) {
                    int x = e.getX();
                    int y = e.getY();
                    TileChart.this.zoom(x, y);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        InputMap map = this.getInputMap(2);
        map.put(KeyStroke.getKeyStroke(121, 1), "postMenuAction");
        map.put(KeyStroke.getKeyStroke(525, 0), "postMenuAction");
        this.getActionMap().put("postMenuAction", new ActivatePopupMenuAction());
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(TileChartModel newTileChartModel) throws IllegalArgumentException {
        super.setGraphModel(newTileChartModel);
        TileChartModel oldTileChartModel = this.tileChartModel;
        this.tileChartModel = newTileChartModel;
        this.matrixModel.setTileChartModel(this.tileChartModel);
        this.firePropertyChange("graphModel", oldTileChartModel, this.tileChartModel);
    }

    public TileChartModel getGraphModel() {
        return this.tileChartModel;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.tileChartModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    public void setDataModel(TileChartDataModel newDataModel) {
        TileChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
        ChartImageMapInfo cimi = this.getImageMapInfo();
    }

    public TileChartDataModel getDataModel() {
        return this.dataModel;
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    public void setRootPath(String[] tileValues) {
        this.matrix.setCurRootTile(tileValues);
    }

    public String[] getRootPath() {
        String[] ids = this.matrix.getCurRootTile();
        if (ids == null) {
            ids = new String[]{};
        }
        return ids;
    }

    public DefaultMutableTreeNode getRootNode() {
        return treeRoot;
    }

    public void setCurrentRootTile(String[] tileValues) {
        this.setRootPath(tileValues);
    }

    public String[] getCurrentRootTile() {
        return this.getRootPath();
    }

    public void setRootTile(String[] tileValues) {
        this.setCurrentRootTile(tileValues);
    }

    public String[] getRootTile() {
        return this.getCurrentRootTile();
    }

    public String[] getTileAtPosition(Point2D p) {
        String[] ids = this.matrix.getTileAtPosition(p);
        return ids;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        this.matrix.recreateCell();
        this.dataModelMomento.apply(this.tileChartModel);
        try {
            DefaultMutableTreeNode tree = new DefaultMutableTreeNode();
            DataSource dataSource = TileChart._newDataSource(this.dataModel, this.tileChartModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener(), tree);
            this.matrixModel.setColorVariableDiscrete(this.tileChartModel.isDiscreteColorVariable());
            if (dataSource != null) {
                com.sas.graphics.util.gtk.Variable[] idVar = dataSource.getVariable(TILE);
                if (idVar != null && !this.equalVars(idVar, this.prevIdVar)) {
                    this.matrixModel.getTileChartModel().setDetailLevel(idVar.length);
                    this.prevIdVar = idVar;
                }
                if (this.dataModel instanceof TileChartOLAPDataModel) {
                    this.matrixModel.setActionProvider(this.getActionProvider());
                }
            }
            if (this.dataModel instanceof TileChartOLAPDataModel) {
                this.matrixModel.setActionProvider(this.getActionProvider());
            }
            if (!tree.isLeaf()) {
                DataTreeGroupNode root = (DataTreeGroupNode)tree.getChildAt(0);
                this.matrixModel.setDataTree(root);
                if (this.dataModel != null) {
                    RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                }
            }
            this.matrix.setDataSource(dataSource);
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private boolean equalVars(com.sas.graphics.util.gtk.Variable[] v1, com.sas.graphics.util.gtk.Variable[] v2) {
        if (v1 == null || v2 == null || v1.length != v2.length) {
            return false;
        }
        for (int ii = 0; ii > v1.length; ++ii) {
            if (v1[ii].getName().equals(v2[ii].getName())) continue;
            return false;
        }
        return true;
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, TileChartDataModel dataModel, TileChartModel tileChartModel) {
        if (dataSource != null) {
            Object[] removeIfAllLEZero = null;
            if (!(dataSource.getVariableDefinition(SIZE, 0) instanceof FreqVariableDefinition)) {
                removeIfAllLEZero = new Object[]{SIZE};
            }
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(SIZE, 0) instanceof FreqVariableDefinition)) {
                removeIfAllMissing = new Object[]{SIZE};
            }
            if (removeIfAllLEZero != null || removeIfAllMissing != null) {
                dataSource.removeObservationsWhereAllLEZero(removeIfAllLEZero);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(TileChartDataModel dataModel, TileChartModel tileChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener, DefaultMutableTreeNode tree) {
        if (dataModel == null) {
            if (tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof TileChartTableDataModel) {
                dataSource = TileChart._newDataSource((TileChartTableDataModel)dataModel, tileChartModel, locale, formatLocale, listSelectionListener, tree);
            } else if (dataModel instanceof TileChartOLAPDataModel) {
                dataSource = TileChart._newDataSource((TileChartOLAPDataModel)dataModel, tileChartModel, locale, formatLocale, listSelectionListener, tree);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(TileChartTableDataModel tableDataModel, TileChartModel tileChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener, DefaultMutableTreeNode tree) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            DataTreeGroupNode n;
            boolean autoSize;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getModel(), formatLocale, tableDataModel.getSortStrategy()), true, true);
            boolean missingDataColumnMessageEnabled = !tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            Util.setVariableDefinition(dataSource, TILE, "tileRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getTileVariable(), 2), missingDataColumnMessageEnabled);
            String name = "";
            String label = "";
            if (tableDataModel.getColorVariable() != null) {
                name = name + tableDataModel.getColorVariable().getColumnName();
                label = tableDataModel.getColorVariable().getLabel();
            }
            int colCount = tableModel.getColumnCount();
            Class<?> colClass = null;
            for (int i = 0; i < colCount; ++i) {
                if (!name.equals(tableModel.getColumnName(i))) continue;
                colClass = tableModel.getColumnClass(i);
                break;
            }
            if (!(tileChartModel.isDiscreteColorVariable() || colClass != null && colClass != Integer.TYPE && colClass != Long.TYPE && colClass != Float.TYPE && colClass != Double.TYPE && colClass != Byte.TYPE && colClass != Short.TYPE && colClass != Number.class && colClass.getSuperclass() != Number.class)) {
                Util.setVariableDefinition(dataSource, COLOR, "colorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColorVariable(), 1), missingDataColumnMessageEnabled);
                tileChartModel.setDiscreteColorVariable(false);
                tileChartModel.setColorVariableNumeric(colClass != String.class);
            } else {
                AnalysisVariable av = new AnalysisVariable(name, null, null, label, 10512);
                tableDataModel.setColorVariable(av);
                Util.setVariableDefinition(dataSource, COLOR, "colorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColorVariable(), 2), missingDataColumnMessageEnabled);
                tileChartModel.setDiscreteColorVariable(true);
                tileChartModel.setColorVariableNumeric(colClass != String.class);
                com.sas.graphics.util.gtk.Variable colorVar = dataSource.getVariable(COLOR, 0);
                if (colorVar == null || colorVar.getConnection() == null) {
                    colorVar.setUniqueValueSort(1);
                }
            }
            Util.setVariableDefinition(dataSource, X, "xRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getXVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, Y, "yRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getYVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SIZE, "sizeRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSizeVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, WEB_LINK, "webLinkRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getWebLinkVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(TILE) == null) {
                int index = -1;
                index = Util.seekStringColumn(tableModel);
                if (index < 0) {
                    index = Util.seekDateColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNumberColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNonNullColumn(tableModel);
                }
                if (index < 0) {
                    index = 0;
                }
                Util.setVariableDefinition(dataSource, TILE, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 2), missingDataColumnMessageEnabled);
            }
            boolean autoColor = dataSource.getVariableDefinition(COLOR) == null;
            boolean bl = autoSize = dataSource.getVariableDefinition(SIZE) == null;
            if (autoColor || autoSize) {
                int[] avoidSize;
                int colorIndex = autoColor ? -1 : tableModel.getColumnCount();
                int sizeIndex = autoSize ? -1 : tableModel.getColumnCount();
                int[] avoidColor = autoColor ? null : Util.getColumnIndices(tableModel, dataSource.getVariableDefinition(COLOR));
                int[] nArray = avoidSize = autoSize ? null : Util.getColumnIndices(tableModel, dataSource.getVariableDefinition(SIZE));
                if (colorIndex < 0) {
                    int[] nArray2;
                    String colorName = RB.getStringResource("Graph.", "colorRole.txt");
                    colorIndex = Util.seekNamedColumn(tableModel, colorName, avoidSize);
                    if (colorIndex >= 0) {
                        int[] nArray3 = new int[1];
                        nArray2 = nArray3;
                        nArray3[0] = colorIndex;
                    } else {
                        nArray2 = avoidColor = null;
                    }
                }
                if (sizeIndex < 0) {
                    int[] nArray4;
                    String sizeName = RB.getStringResource("Graph.", "sizeRole.txt");
                    sizeIndex = Util.seekNamedColumn(tableModel, sizeName, avoidColor);
                    if (sizeIndex >= 0) {
                        int[] nArray5 = new int[1];
                        nArray4 = nArray5;
                        nArray5[0] = sizeIndex;
                    } else {
                        nArray4 = avoidSize = null;
                    }
                }
                if (colorIndex < 0 && sizeIndex < 0) {
                    int[] nArray6;
                    sizeIndex = Util.seekNumberColumn(tableModel);
                    if (sizeIndex >= 0) {
                        int[] nArray7 = new int[1];
                        nArray6 = nArray7;
                        nArray7[0] = sizeIndex;
                    } else {
                        nArray6 = avoidSize = null;
                    }
                    if (sizeIndex >= 0) {
                        colorIndex = Util.seekNumberColumn(tableModel, avoidSize);
                    }
                } else if (sizeIndex < 0) {
                    sizeIndex = Util.seekNumberColumn(tableModel, avoidColor);
                } else if (colorIndex < 0) {
                    colorIndex = Util.seekNumberColumn(tableModel, avoidSize);
                }
                if (autoColor) {
                    if (colorIndex < 0) {
                        Util.setVariableDefinition(dataSource, COLOR, "colorRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
                    } else {
                        dataSource.setVariableDefinition(COLOR, new VariableDefinition(new Integer(colorIndex), null, null, 0));
                    }
                }
                if (autoSize) {
                    if (sizeIndex < 0) {
                        Util.setVariableDefinition(dataSource, SIZE, "sizeRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
                    } else {
                        dataSource.setVariableDefinition(SIZE, new VariableDefinition(new Integer(sizeIndex), null, null, 0));
                    }
                }
            }
            if ((n = TileChart.createTree(dataSource = TileChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, tileChartModel))) != null) {
                tree.add((MutableTreeNode)n);
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition sizeSelection = new SelectionVariableDefinition("size", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SIZE_SELECTION, null, null, sizeSelection, missingDataColumnMessageEnabled);
                SelectionVariableDefinition colorSelection = new SelectionVariableDefinition("color", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, COLOR_SELECTION, null, null, colorSelection, missingDataColumnMessageEnabled);
            }
            Object[] roles = dataSource.getRoles();
            for (int i = 0; i < roles.length; ++i) {
                com.sas.graphics.util.gtk.Variable[] vars = dataSource.getVariable(roles[i]);
                for (int j = 0; j < vars.length; ++j) {
                    tableDataModel.setVariableLabel(vars[j].getColumnName(), vars[j].getLabel());
                }
            }
            return dataSource;
        }
        return null;
    }

    private static DataTreeGroupNode createTree(DataSource dataSource) {
        VariableProcessor vp = new VariableProcessor();
        dataSource.getValueCount();
        com.sas.graphics.util.gtk.Variable[] idVars = dataSource.getVariable(TILE);
        if (idVars != null) {
            for (int iii = 0; iii < idVars.length; ++iii) {
                vp.addGroupVariable(TileChart.newConnectionVariable(idVars[iii]));
            }
        }
        vp.addVariable(TileChart.newConnectionVariable(dataSource.getVariable(COLOR, 0)));
        vp.addVariable(TileChart.newConnectionVariable(dataSource.getVariable(SIZE, 0)));
        com.sas.graphics.util.gtk.Variable v = dataSource.getVariable(X, 0);
        if (v != null) {
            vp.addVariable(TileChart.newConnectionVariable(v));
        }
        if ((v = dataSource.getVariable(Y, 0)) != null) {
            vp.addVariable(TileChart.newConnectionVariable(v));
        }
        treeRoot = vp.getTree();
        return (DataTreeGroupNode)treeRoot;
    }

    private static DataTreeGroupNode createTreeOLAP(DataSource dataSource) {
        dataSource.getValueCount();
        com.sas.graphics.util.gtk.Variable[] idVars = dataSource.getVariable(ID_HIER);
        ArrayList<String> hierarchyNames = new ArrayList<String>();
        if (idVars != null) {
            for (int i = 0; i < idVars.length; ++i) {
                String hName;
                if (!(idVars[i] instanceof OLAPLevelVariable) || hierarchyNames.indexOf(hName = ((OLAPLevelVariable)idVars[i]).getHierachyName()) >= 0) continue;
                hierarchyNames.add(hName);
            }
        }
        DataTreeGroupNode root = dataSource.getGTKOLAPVariableFactory().createSubTree(hierarchyNames);
        Enumeration en = root.depthFirstEnumeration();
        com.sas.graphics.util.gtk.Variable colorVar = dataSource.getVariable(COLOR, 0);
        com.sas.graphics.util.gtk.Variable sizeVar = dataSource.getVariable(SIZE, 0);
        int obs = 0;
        double colorVal = 0.0;
        double sizeVal = 0.0;
        boolean colorMissing = false;
        while (en.hasMoreElements()) {
            DataTreeGroupNode curNode = (DataTreeGroupNode)en.nextElement();
            if (!curNode.isLeaf()) continue;
            obs = (Integer)curNode.getValueIndexIterator().next();
            try {
                colorVal = ((NumericVariable)colorVar).value.getValue(obs);
            }
            catch (MissingValueException e1) {
                colorMissing = true;
                colorVal = -1.0;
            }
            try {
                sizeVal = ((NumericVariable)sizeVar).value.getValue(obs);
            }
            catch (MissingValueException e1) {
                sizeVal = -1.0;
            }
            DataTreeResponseNode respNode = new DataTreeResponseNode(2);
            respNode.setValue(colorMissing ? MissingValues.Dot : Double.valueOf(colorVal), 0);
            colorMissing = false;
            respNode.setValue((Object)sizeVal, 1);
            curNode.add((MutableTreeNode)respNode);
        }
        DefaultMutableTreeNode curLeaf = root.getFirstLeaf();
        while (curLeaf != null) {
            DataTreeResponseNode curRespNode = (DataTreeResponseNode)curLeaf;
            try {
                sizeVal = curRespNode.getDoubleValue(1);
            }
            catch (MissingValueException e) {
                sizeVal = -1.0;
            }
            DefaultMutableTreeNode nextLeaf = ((DefaultMutableTreeNode)curLeaf.getParent()).getNextLeaf();
            if (sizeVal <= 0.0) {
                DefaultMutableTreeNode nextParent = (DefaultMutableTreeNode)curLeaf.getParent();
                do {
                    DefaultMutableTreeNode curParent = nextParent;
                    nextParent = (DefaultMutableTreeNode)curParent.getParent();
                    curParent.removeFromParent();
                } while (nextParent != null && nextParent.getChildCount() == 0);
            }
            curLeaf = nextLeaf;
        }
        return root;
    }

    private static com.sas.graphics.util.gtk.Variable newConnectionVariable(com.sas.graphics.util.gtk.Variable v) {
        return VariableFactory.newVariable(v);
    }

    private static DataSource _newDataSource(TileChartOLAPDataModel olapDataModel, TileChartModel tileChartModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener, DefaultMutableTreeNode tree) {
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPFactory = (com.sas.graphics.util.gtk.OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    DataTreeGroupNode n;
                    int i;
                    DataSource dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    List columnLevelNames = gtkOLAPFactory.getLevelNames(0);
                    List rowLevelNames = gtkOLAPFactory.getLevelNames(1);
                    ArrayList catSubLevelNames = new ArrayList();
                    ArrayList catHierarchies = new ArrayList();
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    boolean isRaggedOrUnbalanced = false;
                    if (columnLevelNames.size() > 0) {
                        catSubLevelNames.addAll(columnLevelNames);
                        catHierarchies.addAll(columnHierarchyNames);
                        isRaggedOrUnbalanced = gtkOLAPFactory.isRaggedOrUnbalanced(0);
                    }
                    if (rowLevelNames.size() > 0) {
                        catSubLevelNames.addAll(rowLevelNames);
                        catHierarchies.addAll(rowHierarchyNames);
                        isRaggedOrUnbalanced |= gtkOLAPFactory.isRaggedOrUnbalanced(1);
                    }
                    if (catSubLevelNames.size() == 0) {
                        throw new Util.ComponentsMessageException("RequiredIDDataNotFound.txt", locale);
                    }
                    if (catSubLevelNames.size() > 0) {
                        ClassificationVariableDefinition ids = null;
                        for (i = catSubLevelNames.size() - 1; i >= 0; --i) {
                            String levelName = (String)catSubLevelNames.get(i);
                            ids = new ClassificationVariableDefinition(levelName, null, ids, 0);
                        }
                        Util.setVariableDefinition(dataSource, TILE, "idRole.txt", locale, ids, missingDataColumnMessageEnabled);
                    }
                    if (catHierarchies.size() > 0) {
                        ClassificationVariableDefinition hiers = null;
                        for (i = catHierarchies.size() - 1; i >= 0; --i) {
                            hiers = new ClassificationVariableDefinition((String)catHierarchies.get(i), null, hiers, 0);
                        }
                        Util.setVariableDefinition(dataSource, ID_HIER, "idRole.txt", locale, hiers, missingDataColumnMessageEnabled);
                    }
                    List sizeNames = null;
                    List colorNames = null;
                    List measureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getSizeVariable() != null || olapDataModel.getColorVariable() != null) {
                        Variable sizeVariable = olapDataModel.getSizeVariable() != null ? olapDataModel.getSizeVariable() : olapDataModel.getColorVariable();
                        Variable colorVariable = olapDataModel.getColorVariable() != null ? olapDataModel.getColorVariable() : sizeVariable;
                        sizeNames = Util.newValidatedList(sizeVariable, measureNames, gtkOLAPFactory, "sizeRole.txt", locale);
                        colorNames = Util.newValidatedList(colorVariable, measureNames, gtkOLAPFactory, "colorRole.txt", locale);
                    } else if (measureNames.size() > 0) {
                        sizeNames = new ArrayList();
                        colorNames = new ArrayList();
                        colorNames.add(measureNames.get(measureNames.size() - 1));
                        sizeNames.add(measureNames.get(measureNames.size() > 1 ? measureNames.size() - 2 : measureNames.size() - 1));
                    }
                    if (colorNames == null || sizeNames == null) {
                        throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                    }
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (int ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], measureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (int ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], measureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (sizeNames != null || colorNames != null) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, SIZE, sizeNames, "sizeRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, COLOR, colorNames, "colorRole.txt", locale, missingDataColumnMessageEnabled);
                        if (olapDataModel.getSelectionModel() != null) {
                            ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                            dataSource.setSelectionModel(selectionModel, false);
                            Util.setOLAPSelections(dataSource, selectionModel, SIZE_SELECTION, sizeNames, missingDataColumnMessageEnabled);
                            Util.setOLAPSelections(dataSource, selectionModel, COLOR_SELECTION, colorNames, missingDataColumnMessageEnabled);
                        }
                    }
                    if ((n = TileChart.createTreeOLAP(dataSource)) != null) {
                        tree.add((MutableTreeNode)n);
                    }
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (tileChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        LegendModel legendModel = this.tileChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        ColorPosition[] cols = new ColorPosition[]{new ColorPosition(graphStyle.getDataElementStyles().getContinuousFillThreeColorStartColor(), 0.0), new ColorPosition(graphStyle.getDataElementStyles().getContinuousFillThreeColorNeutralColor(), 0.5), new ColorPosition(graphStyle.getDataElementStyles().getContinuousFillThreeColorEndColor(), 1.0)};
        this.tileChartModel.getDataElementStyles().setContinuousColorSpectrum(cols);
        LineStyle ols = graphStyle.getDataElementStyles().getOutlineLineStyle();
        Color olsColor = ols.getColor();
        ols = new LineStyle(olsColor, new BaseLength("3 px"), 10201);
        this.tileChartModel.putOutlineLineStyle(ols, 1);
        LineStyle ls = new LineStyle(ols.getColor(), new BaseLength("1 px"), 10201);
        this.tileChartModel.putOutlineLineStyle(ls, 2);
        float[] hsbValue = Color.RGBtoHSB(olsColor.getRed(), olsColor.getGreen(), olsColor.getBlue(), null);
        if ((double)hsbValue[2] < 0.4) {
            hsbValue[1] = hsbValue[1] / 4.0f;
            hsbValue[2] = (float)((double)hsbValue[2] + 0.3);
        } else {
            hsbValue[1] = hsbValue[1] / 4.0f;
            hsbValue[2] = (float)((double)hsbValue[2] - 0.3);
            hsbValue[2] = Math.max(hsbValue[2], 0.0f);
        }
        int rgbValue = Color.HSBtoRGB(hsbValue[0], hsbValue[1], hsbValue[2]);
        Color offColor = new Color((rgbValue & 0xFF0000) >> 16, (rgbValue & 0xFF00) >> 8, rgbValue & 0xFF);
        if (olsColor.equals(Color.black)) {
            offColor = Color.gray;
        }
        ls = new LineStyle(offColor, new BaseLength("1 px"), 10201);
        this.tileChartModel.putOutlineLineStyle(ls, 3);
        this.tileChartModel.putOutlineLineStyle(ls, 4);
        this.tileChartModel.putOutlineLineStyle(ls, 5);
        this.tileChartModel.putOutlineLineStyle(ls, -1);
        for (int ii = 4; ii < 20; ++ii) {
            if (this.tileChartModel.getOutlineLineStyle(ii) == null) continue;
            this.tileChartModel.putOutlineLineStyle(ls, ii);
        }
        this.tileChartModel.putOutlineLineStyle(ls, -1);
        TileChartHighlightModel tchm = new TileChartHighlightModel();
        tchm.setStyle(31);
        Color bgColor = graphStyle.getDataTipBackgroundColor();
        Color newbg = new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 190);
        tchm.setBackground(new FillStyle(newbg));
        Font font = graphStyle.getDataTipTextStyle().getFont();
        tchm.setTextStyle(new TextStyle(font, graphStyle.getDataTipTextStyle().getColor(), 2, true));
        this.tileChartModel.setDataTipHighlightModel(tchm);
        Util.Conveyer.applyTextStyle(graphStyle.getValueTextStyle(), this.tileChartModel.getDataLabelTextStyle());
        this.tileChartModel.setStatusLineTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getLabelTextStyle(), this.tileChartModel.getStatusLineTextStyle()));
        this.tileChartModel.getLegendModel().getBackgroundFillStyle().apply(graphStyle.getLegendBackgroundFillStyle());
        this.tileChartModel.getLegendModel().getFrameLineStyle().apply(graphStyle.getFrameLineStyle());
        this.tileChartModel.getLegendModel().getShadowStyle().apply(graphStyle.getLegendShadowStyle());
        Color tipBG = this.tileChartModel.getDataTipModel().getBackgroundColor();
        this.tileChartModel.getDataTipModel().setBackgroundColor(new Color(tipBG.getRed(), tipBG.getGreen(), tipBG.getBlue(), tipBG.getAlpha() == 255 ? 190 : tipBG.getAlpha()));
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.tileChartModel.getLegendModel());
        Util.Conveyer.applyColorSchemeToLabelText(scheme, this.tileChartModel.getStatusLineTextStyle());
        Util.Conveyer.applyColorSchemeToLabelText(scheme, this.tileChartModel.getTileLabelStyle(1));
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public String[] getTileValues() {
        String[] result = this.matrixModel.getTileValues();
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    public String[] getIDLabels() {
        String[] ids = this.matrixModel.getIDLabels();
        if (ids == null) {
            ids = new String[]{};
        }
        return ids;
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof TileChartTableDataModel) {
            TileChartTableDataModel tm = (TileChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof TileChartOLAPDataModel) {
            TileChartOLAPDataModel om = (TileChartOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private JPopupMenu newPopupMenu(int x, int y) {
        if (this.matrix != null) {
            Point p = Util.toDescendent(x, y, this, this.matrix);
            return this.matrix.newPopupMenu(p.x, p.y);
        }
        return null;
    }

    private boolean zoom(int x, int y) {
        if (this.matrix != null) {
            Point p = Util.toDescendent(x, y, this, this.matrix);
            return this.matrix.zoom(p.x, p.y);
        }
        return false;
    }

    @Override
    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
    }

    class ActivatePopupMenuAction
    extends AbstractAction {
        protected ActivatePopupMenuAction() {
            super("ActivatePopupMenu");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu popupmenu = TileChart.this.newPopupMenu(TileChart.this.lastx, TileChart.this.lasty);
            if (popupmenu != null) {
                popupmenu.show(TileChart.this, TileChart.this.lastx, TileChart.this.lasty);
            } else {
                Dimension dim = TileChart.this.getSize();
                JPopupMenu popupmenu1 = TileChart.this.newPopupMenu(dim.width / 2, dim.height / 2);
                popupmenu1.show(TileChart.this, dim.width / 2, dim.height / 2);
            }
        }
    }

    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(TileChartModel tileChartModel) {
            this.apply(tileChartModel);
        }

        public void apply(TileChartModel tileChartModel) {
            this.customOptions = tileChartModel.getCustomOptions() & dataOptions;
        }

        public boolean isApplyDataModel(TileChartModel tileChartModel, DataSource dataSource) {
            if (dataSource != null) {
                return false;
            }
            return this.customOptions != (tileChartModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && super.equals(arg);
        }
    }
}

